/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"checkNotEnumEntry", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkTypeReferences", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "kotlin-compiler"})
public final class DeclarationsCheckerKt {
    public static final void checkTypeReferences(@NotNull KtDeclaration $receiver, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if ($receiver instanceof KtCallableDeclaration) {
            KtTypeReference ktTypeReference = ((KtCallableDeclaration)$receiver).getTypeReference();
            if (ktTypeReference != null) {
                DeclarationsCheckerKt.checkNotEnumEntry(ktTypeReference, trace);
            }
            KtTypeReference ktTypeReference2 = ((KtCallableDeclaration)$receiver).getReceiverTypeReference();
            if (ktTypeReference2 != null) {
                DeclarationsCheckerKt.checkNotEnumEntry(ktTypeReference2, trace);
            }
        }
        if ($receiver instanceof KtDeclarationWithBody) {
            for (KtParameter parameter : ((KtDeclarationWithBody)$receiver).getValueParameters()) {
                KtTypeReference ktTypeReference = parameter.getTypeReference();
                if (ktTypeReference != null) {
                    DeclarationsCheckerKt.checkNotEnumEntry(ktTypeReference, trace);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean checkNotEnumEntry(@NotNull KtTypeReference $receiver, @NotNull BindingTrace trace) {
        void result2;
        block3: {
            Object it;
            Object object;
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            KotlinType kotlinType = (KotlinType)trace.getBindingContext().get(BindingContext.TYPE, $receiver);
            if (kotlinType != null) {
                object = kotlinType;
                it = object;
                ClassDescriptor targetDescriptor = TypeUtils.getClassDescriptor((KotlinType)it);
                if (targetDescriptor != null && DescriptorUtils.isEnumEntry(targetDescriptor)) {
                    trace.report(Errors.ENUM_ENTRY_AS_TYPE.on((KtTypeReference)((PsiElement)$receiver)));
                    result2.element = true;
                }
            }
            KtTypeElement ktTypeElement = $receiver.getTypeElement();
            if (ktTypeElement == null) break block3;
            object = ktTypeElement;
            it = (KtTypeElement)object;
            Iterator<KtTypeReference> iterator2 = it.getTypeArgumentsAsTypes().iterator();
            while (iterator2.hasNext()) {
                KtTypeReference typeArgument;
                KtTypeReference ktTypeReference = typeArgument = iterator2.next();
                if (ktTypeReference == null) continue;
                DeclarationsCheckerKt.checkNotEnumEntry(ktTypeReference, trace);
            }
        }
        return result2.element;
    }
}

