/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class CompileTimeConstantChecker {
    private static final Set<DiagnosticFactory<?>> errorsThatDependOnExpectedType = Sets.newHashSet(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH, Errors.NULL_FOR_NONNULL_TYPE);
    private final KotlinBuiltIns builtIns;
    private final BindingTrace trace;
    private final boolean checkOnlyErrorsThatDependOnExpectedType;
    private final ResolutionContext<?> context;

    public CompileTimeConstantChecker(@NotNull ResolutionContext<?> context, @NotNull KotlinBuiltIns builtIns, boolean checkOnlyErrorsThatDependOnExpectedType) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "<init>"));
        }
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "<init>"));
        }
        this.checkOnlyErrorsThatDependOnExpectedType = checkOnlyErrorsThatDependOnExpectedType;
        this.builtIns = builtIns;
        this.trace = context.trace;
        this.context = context;
    }

    public boolean checkConstantExpressionType(@Nullable ConstantValue<?> compileTimeConstant, @NotNull KtConstantExpression expression, @NotNull KotlinType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "checkConstantExpressionType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "checkConstantExpressionType"));
        }
        IElementType elementType = expression.getNode().getElementType();
        if (elementType == KtNodeTypes.INTEGER_CONSTANT) {
            return this.checkIntegerValue(compileTimeConstant, expectedType, expression);
        }
        if (elementType == KtNodeTypes.FLOAT_CONSTANT) {
            return this.checkFloatValue(compileTimeConstant, expectedType, expression);
        }
        if (elementType == KtNodeTypes.BOOLEAN_CONSTANT) {
            return this.checkBooleanValue(expectedType, expression);
        }
        if (elementType == KtNodeTypes.CHARACTER_CONSTANT) {
            return this.checkCharValue(compileTimeConstant, expectedType, expression);
        }
        if (elementType == KtNodeTypes.NULL) {
            return this.checkNullValue(expectedType, expression);
        }
        return false;
    }

    private boolean checkIntegerValue(@Nullable ConstantValue<?> value, @NotNull KotlinType expectedType, @NotNull KtConstantExpression expression) {
        KotlinType valueType;
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "checkIntegerValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "checkIntegerValue"));
        }
        if (value == null) {
            return this.reportError(Errors.INT_LITERAL_OUT_OF_RANGE.on(expression));
        }
        if (expression.getText().endsWith("l")) {
            return this.reportError(Errors.WRONG_LONG_SUFFIX.on(expression));
        }
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(valueType = value.getType(), expectedType)) {
            return this.reportConstantExpectedTypeMismatch(expression, "integer", expectedType, null);
        }
        return false;
    }

    private boolean checkFloatValue(@Nullable ConstantValue<?> value, @NotNull KotlinType expectedType, @NotNull KtConstantExpression expression) {
        KotlinType valueType;
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "checkFloatValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "checkFloatValue"));
        }
        if (value == null) {
            return this.reportError(Errors.FLOAT_LITERAL_OUT_OF_RANGE.on(expression));
        }
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(valueType = value.getType(), expectedType)) {
            return this.reportConstantExpectedTypeMismatch(expression, "floating-point", expectedType, null);
        }
        return false;
    }

    private boolean checkBooleanValue(@NotNull KotlinType expectedType, @NotNull KtConstantExpression expression) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "checkBooleanValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "checkBooleanValue"));
        }
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(this.builtIns.getBooleanType(), expectedType)) {
            return this.reportConstantExpectedTypeMismatch(expression, "boolean", expectedType, this.builtIns.getBooleanType());
        }
        return false;
    }

    private boolean checkCharValue(ConstantValue<?> constant, KotlinType expectedType, KtConstantExpression expression) {
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(this.builtIns.getCharType(), expectedType)) {
            return this.reportConstantExpectedTypeMismatch(expression, "character", expectedType, this.builtIns.getCharType());
        }
        if (constant != null) {
            return false;
        }
        Diagnostic diagnostic = CompileTimeConstantChecker.parseCharacter(expression).getDiagnostic();
        if (diagnostic != null) {
            return this.reportError(diagnostic);
        }
        return false;
    }

    private boolean checkNullValue(@NotNull KotlinType expectedType, @NotNull KtConstantExpression expression) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "checkNullValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "checkNullValue"));
        }
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType) && !TypeUtils.acceptsNullable(expectedType)) {
            if (DiagnosticUtilsKt.reportTypeMismatchDueToTypeProjection(this.context, expression, expectedType, this.builtIns.getNullableNothingType())) {
                return true;
            }
            return this.reportError(Errors.NULL_FOR_NONNULL_TYPE.on(expression, expectedType));
        }
        return false;
    }

    @NotNull
    private static CharacterWithDiagnostic parseCharacter(@NotNull KtConstantExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "parseCharacter"));
        }
        String text2 = expression.getText();
        if (text2.length() < 2 || text2.charAt(0) != '\'' || text2.charAt(text2.length() - 1) != '\'') {
            CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.createErrorCharacter(Errors.INCORRECT_CHARACTER_LITERAL.on(expression));
            if (characterWithDiagnostic == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "parseCharacter"));
            }
            return characterWithDiagnostic;
        }
        if ((text2 = text2.substring(1, text2.length() - 1)).length() == 0) {
            CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.createErrorCharacter(Errors.EMPTY_CHARACTER_LITERAL.on(expression));
            if (characterWithDiagnostic == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "parseCharacter"));
            }
            return characterWithDiagnostic;
        }
        if (text2.charAt(0) != '\\') {
            if (text2.length() == 1) {
                CharacterWithDiagnostic characterWithDiagnostic = new CharacterWithDiagnostic(text2.charAt(0));
                if (characterWithDiagnostic == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "parseCharacter"));
                }
                return characterWithDiagnostic;
            }
            CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.createErrorCharacter(Errors.TOO_MANY_CHARACTERS_IN_CHARACTER_LITERAL.on(expression, expression));
            if (characterWithDiagnostic == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "parseCharacter"));
            }
            return characterWithDiagnostic;
        }
        CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.escapedStringToCharacter(text2, expression);
        if (characterWithDiagnostic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "parseCharacter"));
        }
        return characterWithDiagnostic;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static CharacterWithDiagnostic escapedStringToCharacter(@NotNull String text2, @NotNull KtElement expression) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "escapedStringToCharacter"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "escapedStringToCharacter"));
        }
        assert (text2.length() > 0 && text2.charAt(0) == '\\') : "Only escaped sequences must be passed to this routine: " + text2;
        String escape = text2.substring(1);
        switch (escape.length()) {
            case 0: {
                CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.illegalEscape(expression);
                if (characterWithDiagnostic != null) return characterWithDiagnostic;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "escapedStringToCharacter"));
            }
            case 1: {
                Character escaped = CompileTimeConstantChecker.translateEscape(escape.charAt(0));
                if (escaped == null) {
                    CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.illegalEscape(expression);
                    if (characterWithDiagnostic != null) return characterWithDiagnostic;
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "escapedStringToCharacter"));
                }
                CharacterWithDiagnostic characterWithDiagnostic = new CharacterWithDiagnostic(escaped.charValue());
                if (characterWithDiagnostic != null) return characterWithDiagnostic;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "escapedStringToCharacter"));
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                try {
                    Integer intValue = Integer.valueOf(escape.substring(1), 16);
                    CharacterWithDiagnostic characterWithDiagnostic = new CharacterWithDiagnostic((char)intValue.intValue());
                    if (characterWithDiagnostic != null) return characterWithDiagnostic;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "escapedStringToCharacter"));
            }
        }
        CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.illegalEscape(expression);
        if (characterWithDiagnostic != null) return characterWithDiagnostic;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "escapedStringToCharacter"));
    }

    @NotNull
    private static CharacterWithDiagnostic illegalEscape(@NotNull KtElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "illegalEscape"));
        }
        CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.createErrorCharacter(Errors.ILLEGAL_ESCAPE.on(expression, expression));
        if (characterWithDiagnostic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "illegalEscape"));
        }
        return characterWithDiagnostic;
    }

    @NotNull
    private static CharacterWithDiagnostic createErrorCharacter(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "createErrorCharacter"));
        }
        CharacterWithDiagnostic characterWithDiagnostic = new CharacterWithDiagnostic(diagnostic);
        if (characterWithDiagnostic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "createErrorCharacter"));
        }
        return characterWithDiagnostic;
    }

    @Nullable
    public static Character parseChar(@NotNull KtConstantExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "parseChar"));
        }
        return CompileTimeConstantChecker.parseCharacter(expression).getValue();
    }

    @Nullable
    private static Character translateEscape(char c) {
        switch (c) {
            case 't': {
                return Character.valueOf('\t');
            }
            case 'b': {
                return Character.valueOf('\b');
            }
            case 'n': {
                return Character.valueOf('\n');
            }
            case 'r': {
                return Character.valueOf('\r');
            }
            case '\'': {
                return Character.valueOf('\'');
            }
            case '\"': {
                return Character.valueOf('\"');
            }
            case '\\': {
                return Character.valueOf('\\');
            }
            case '$': {
                return Character.valueOf('$');
            }
        }
        return null;
    }

    private static boolean noExpectedTypeOrError(KotlinType expectedType) {
        return TypeUtils.noExpectedType(expectedType) || expectedType.isError();
    }

    private boolean reportConstantExpectedTypeMismatch(@NotNull KtConstantExpression expression, @NotNull String typeName, @NotNull KotlinType expectedType, @Nullable KotlinType expressionType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "reportConstantExpectedTypeMismatch"));
        }
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "reportConstantExpectedTypeMismatch"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "reportConstantExpectedTypeMismatch"));
        }
        if (DiagnosticUtilsKt.reportTypeMismatchDueToTypeProjection(this.context, expression, expectedType, expressionType)) {
            return true;
        }
        this.trace.report(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.on(expression, typeName, expectedType));
        return true;
    }

    private boolean reportError(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker", "reportError"));
        }
        if (!this.checkOnlyErrorsThatDependOnExpectedType || errorsThatDependOnExpectedType.contains(diagnostic.getFactory())) {
            this.trace.report(diagnostic);
            return true;
        }
        return false;
    }

    public static class CharacterWithDiagnostic {
        private Diagnostic diagnostic;
        private Character value;

        public CharacterWithDiagnostic(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker$CharacterWithDiagnostic", "<init>"));
            }
            this.diagnostic = diagnostic;
        }

        public CharacterWithDiagnostic(char value) {
            this.value = Character.valueOf(value);
        }

        @Nullable
        public Diagnostic getDiagnostic() {
            return this.diagnostic;
        }

        @Nullable
        public Character getValue() {
            return this.value;
        }
    }
}

