/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH$J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/AbstractLocalRedeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/scopes/LocalRedeclarationChecker;", "overloadChecker", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "(Lorg/jetbrains/kotlin/resolve/OverloadChecker;)V", "getOverloadChecker", "()Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "checkBeforeAddingToScope", "", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "newDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "handleConflictingOverloads", "first", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "second", "handleRedeclaration", "kotlin-compiler"})
public abstract class AbstractLocalRedeclarationChecker
implements LocalRedeclarationChecker {
    @NotNull
    private final OverloadChecker overloadChecker;

    @Override
    public void checkBeforeAddingToScope(@NotNull LexicalScope scope, @NotNull DeclarationDescriptor newDescriptor) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Intrinsics.checkParameterIsNotNull(newDescriptor, "newDescriptor");
        Name name2 = newDescriptor.getName();
        NoLookupLocation location2 = NoLookupLocation.WHEN_CHECK_REDECLARATIONS;
        DeclarationDescriptor declarationDescriptor = newDescriptor;
        if (declarationDescriptor instanceof ClassifierDescriptor || declarationDescriptor instanceof VariableDescriptor) {
            DeclarationDescriptorNonRoot otherDescriptor;
            DeclarationDescriptorNonRoot declarationDescriptorNonRoot;
            Name name3 = name2;
            Intrinsics.checkExpressionValueIsNotNull(name3, "name");
            ClassifierDescriptor classifierDescriptor = scope.getContributedClassifier(name3, location2);
            if (classifierDescriptor != null) {
                declarationDescriptorNonRoot = classifierDescriptor;
            } else {
                Name name4 = name2;
                Intrinsics.checkExpressionValueIsNotNull(name4, "name");
                declarationDescriptorNonRoot = otherDescriptor = (DeclarationDescriptorNonRoot)CollectionsKt.firstOrNull((Iterable)scope.getContributedVariables(name4, location2));
            }
            if (otherDescriptor != null) {
                this.handleRedeclaration(otherDescriptor, newDescriptor);
            }
        } else if (declarationDescriptor instanceof FunctionDescriptor) {
            Collection collection;
            Name name5 = name2;
            Intrinsics.checkExpressionValueIsNotNull(name5, "name");
            Collection otherFunctions = scope.getContributedFunctions(name5, location2);
            Name name6 = name2;
            Intrinsics.checkExpressionValueIsNotNull(name6, "name");
            ClassifierDescriptor otherClass = scope.getContributedClassifier(name6, location2);
            if (otherClass instanceof ClassDescriptor) {
                Iterable iterable = ((ClassDescriptor)otherClass).getConstructors();
                Intrinsics.checkExpressionValueIsNotNull(iterable, "otherClass.constructors");
                collection = CollectionsKt.plus(otherFunctions, iterable);
            } else {
                collection = otherFunctions;
            }
            Collection potentiallyConflictingOverloads = collection;
            for (FunctionDescriptor overloadedDescriptor : potentiallyConflictingOverloads) {
                DeclarationDescriptor declarationDescriptor2 = overloadedDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "overloadedDescriptor");
                if (this.overloadChecker.isOverloadable(declarationDescriptor2, newDescriptor)) continue;
                CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)newDescriptor;
                CallableMemberDescriptor callableMemberDescriptor2 = overloadedDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor2, "overloadedDescriptor");
                this.handleConflictingOverloads(callableMemberDescriptor, callableMemberDescriptor2);
                break;
            }
        } else {
            throw (Throwable)new IllegalStateException("Unexpected type of descriptor: " + newDescriptor.getClass().getName() + ", descriptor: " + newDescriptor);
        }
    }

    protected abstract void handleRedeclaration(@NotNull DeclarationDescriptor var1, @NotNull DeclarationDescriptor var2);

    protected abstract void handleConflictingOverloads(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);

    @NotNull
    public final OverloadChecker getOverloadChecker() {
        return this.overloadChecker;
    }

    public AbstractLocalRedeclarationChecker(@NotNull OverloadChecker overloadChecker) {
        Intrinsics.checkParameterIsNotNull(overloadChecker, "overloadChecker");
        this.overloadChecker = overloadChecker;
    }
}

