/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsDynamicScope;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.translate.context.DeclarationExporter;
import org.jetbrains.kotlin.js.translate.context.DeferredCallSite;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.generator.Generator;
import org.jetbrains.kotlin.js.translate.context.generator.Rule;
import org.jetbrains.kotlin.js.translate.declaration.InterfaceFunctionCopier;
import org.jetbrains.kotlin.js.translate.intrinsic.Intrinsics;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public final class StaticContext {
    @NotNull
    private final JsProgram program;
    @NotNull
    private final BindingTrace bindingTrace;
    @NotNull
    private final Namer namer;
    @NotNull
    private final Intrinsics intrinsics;
    @NotNull
    private final JsScope rootScope;
    @NotNull
    private final Generator<JsName> innerNames;
    @NotNull
    private final Map<FqName, JsName> packageNames;
    @NotNull
    private final Generator<JsScope> scopes;
    @NotNull
    private final Generator<JsName> objectInstanceNames;
    @NotNull
    private final Map<JsScope, JsFunction> scopeToFunction;
    @NotNull
    private final Map<MemberDescriptor, List<DeclarationDescriptor>> classOrConstructorClosure;
    @NotNull
    private final Map<ClassDescriptor, List<DeferredCallSite>> deferredCallSites;
    @NotNull
    private final JsConfig config;
    @NotNull
    private final ModuleDescriptor currentModule;
    @NotNull
    private final NameSuggestion nameSuggestion;
    @NotNull
    private final Map<DeclarationDescriptor, JsName> nameCache;
    @NotNull
    private final Map<PropertyDescriptor, JsName> backingFieldNameCache;
    @NotNull
    private final Map<DeclarationDescriptor, JsExpression> fqnCache;
    @NotNull
    private final Map<ImportedModuleKey, ImportedModule> importedModules;
    private Collection<ImportedModule> readOnlyImportedModules;
    @NotNull
    private final JsScope rootPackageScope;
    @NotNull
    private JsFunction rootFunction;
    @NotNull
    private final List<JsStatement> declarationStatements;
    @NotNull
    private final List<JsStatement> topLevelStatements;
    @NotNull
    private final List<JsStatement> importStatements;
    @NotNull
    private final DeclarationExporter exporter;
    @NotNull
    private final Set<ClassDescriptor> classes;
    @NotNull
    private final Map<FqName, JsScope> packageScopes;

    public static StaticContext generateStaticContext(@NotNull BindingTrace bindingTrace, @NotNull JsConfig config, @NotNull ModuleDescriptor moduleDescriptor) {
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/kotlin/js/translate/context/StaticContext", "generateStaticContext"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/translate/context/StaticContext", "generateStaticContext"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "generateStaticContext"));
        }
        JsProgram program = new JsProgram();
        Namer namer = Namer.newInstance(program.getRootScope());
        JsFunction rootFunction = JsAstUtils.createFunctionWithEmptyBody(program.getScope());
        return new StaticContext(program, rootFunction, bindingTrace, namer, program.getRootScope(), config, moduleDescriptor);
    }

    private StaticContext(@NotNull JsProgram program, @NotNull JsFunction rootFunction, @NotNull BindingTrace bindingTrace, @NotNull Namer namer, @NotNull JsScope rootScope2, @NotNull JsConfig config, @NotNull ModuleDescriptor moduleDescriptor) {
        if (program == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "program", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (rootFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootFunction", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (namer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namer", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (rootScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        this.innerNames = new InnerNameGenerator();
        this.packageNames = Maps.newHashMap();
        this.scopes = new ScopeGenerator();
        this.objectInstanceNames = new ObjectInstanceNameGenerator();
        this.scopeToFunction = Maps.newHashMap();
        this.classOrConstructorClosure = Maps.newHashMap();
        this.deferredCallSites = new HashMap<ClassDescriptor, List<DeferredCallSite>>();
        this.nameSuggestion = new NameSuggestion();
        this.nameCache = new HashMap<DeclarationDescriptor, JsName>();
        this.backingFieldNameCache = new HashMap<PropertyDescriptor, JsName>();
        this.fqnCache = new HashMap<DeclarationDescriptor, JsExpression>();
        this.importedModules = new LinkedHashMap<ImportedModuleKey, ImportedModule>();
        this.declarationStatements = new ArrayList<JsStatement>();
        this.topLevelStatements = new ArrayList<JsStatement>();
        this.importStatements = new ArrayList<JsStatement>();
        this.exporter = new DeclarationExporter(this);
        this.classes = new LinkedHashSet<ClassDescriptor>();
        this.packageScopes = new HashMap<FqName, JsScope>();
        this.program = program;
        this.rootFunction = rootFunction;
        this.bindingTrace = bindingTrace;
        this.namer = namer;
        this.intrinsics = new Intrinsics(this);
        this.rootScope = rootScope2;
        this.config = config;
        this.currentModule = moduleDescriptor;
        this.rootFunction = rootFunction;
        this.rootPackageScope = new JsObjectScope(rootScope2, "<root package>");
        JsName kotlinName = rootScope2.declareName("Kotlin");
        this.importedModules.put(new ImportedModuleKey(Namer.KOTLIN_LOWER_NAME, null), new ImportedModule(Namer.KOTLIN_LOWER_NAME, kotlinName, null));
    }

    @NotNull
    public JsProgram getProgram() {
        JsProgram jsProgram = this.program;
        if (jsProgram == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getProgram"));
        }
        return jsProgram;
    }

    @NotNull
    public BindingTrace getBindingTrace() {
        BindingTrace bindingTrace = this.bindingTrace;
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getBindingTrace"));
        }
        return bindingTrace;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.bindingTrace.getBindingContext();
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getBindingContext"));
        }
        return bindingContext;
    }

    @NotNull
    public Intrinsics getIntrinsics() {
        Intrinsics intrinsics = this.intrinsics;
        if (intrinsics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getIntrinsics"));
        }
        return intrinsics;
    }

    @NotNull
    public Namer getNamer() {
        Namer namer = this.namer;
        if (namer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNamer"));
        }
        return namer;
    }

    @NotNull
    public Collection<ImportedModule> getImportedModules() {
        if (this.readOnlyImportedModules == null) {
            this.readOnlyImportedModules = Collections.unmodifiableCollection(this.importedModules.values());
        }
        Collection<ImportedModule> collection = this.readOnlyImportedModules;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getImportedModules"));
        }
        return collection;
    }

    @NotNull
    public JsScope getScopeForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getScopeForDescriptor"));
        }
        if (descriptor2 instanceof ModuleDescriptor) {
            JsScope jsScope = this.rootScope;
            if (jsScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getScopeForDescriptor"));
            }
            return jsScope;
        }
        JsScope scope = this.scopes.get(descriptor2.getOriginal());
        assert (scope != null) : "Must have a scope for descriptor";
        JsScope jsScope = scope;
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getScopeForDescriptor"));
        }
        return jsScope;
    }

    @NotNull
    public JsFunction getFunctionWithScope(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getFunctionWithScope"));
        }
        JsScope scope = this.getScopeForDescriptor(descriptor2);
        JsFunction function2 = this.scopeToFunction.get(scope);
        assert (scope.equals(function2.getScope())) : "Inconsistency.";
        JsFunction jsFunction = function2;
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getFunctionWithScope"));
        }
        return jsFunction;
    }

    @NotNull
    public JsNameRef getQualifiedReference(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedReference"));
        }
        JsNameRef jsNameRef = (JsNameRef)this.getQualifiedExpression(descriptor2);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedReference"));
        }
        return jsNameRef;
    }

    @NotNull
    private JsExpression getQualifiedExpression(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedExpression"));
        }
        JsExpression fqn = this.fqnCache.get(descriptor2);
        if (fqn == null) {
            fqn = this.buildQualifiedExpression(descriptor2);
            this.fqnCache.put(descriptor2, fqn);
        }
        JsExpression jsExpression = fqn.deepCopy();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedExpression"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression buildQualifiedExpression(@NotNull DeclarationDescriptor descriptor2) {
        String moduleName;
        SuggestedName suggested;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "buildQualifiedExpression"));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
            if (KotlinBuiltIns.isAny(classDescriptor)) {
                JsNameRef jsNameRef = JsAstUtils.pureFqn("Object", null);
                if (jsNameRef == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "buildQualifiedExpression"));
                }
                return jsNameRef;
            }
            if (TypeUtilsKt.isThrowable(classDescriptor.getDefaultType())) {
                JsNameRef jsNameRef = JsAstUtils.pureFqn("Error", null);
                if (jsNameRef == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "buildQualifiedExpression"));
                }
                return jsNameRef;
            }
        }
        if ((suggested = this.nameSuggestion.suggest(descriptor2)) == null) {
            ModuleDescriptor module = DescriptorUtils.getContainingModule(descriptor2);
            JsExpression result2 = this.getModuleExpressionFor(module);
            JsExpression jsExpression = result2 != null ? result2 : JsAstUtils.pureFqn(Namer.getRootPackageName(), null);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "buildQualifiedExpression"));
            }
            return jsExpression;
        }
        if (this.config.getModuleKind() != ModuleKind.PLAIN && (moduleName = AnnotationsUtils.getModuleName(suggested.getDescriptor())) != null) {
            JsNameRef jsNameRef = JsAstUtils.pureFqn(this.getImportedModule(moduleName, suggested.getDescriptor()).internalName, null);
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "buildQualifiedExpression"));
            }
            return jsNameRef;
        }
        List<JsName> partNames = this.getActualNameFromSuggested(suggested);
        Object expression = AnnotationsUtils.isLibraryObject(suggested.getDescriptor()) ? Namer.kotlinObject() : (AnnotationsUtils.isNativeObject(suggested.getDescriptor()) && !AnnotationsUtils.isNativeObject(suggested.getScope()) || suggested.getDescriptor() instanceof CallableDescriptor && suggested.getScope() instanceof FunctionDescriptor ? null : this.getQualifiedExpression(suggested.getScope()));
        if (AnnotationsUtils.isNativeObject(suggested.getDescriptor()) && DescriptorUtils.isTopLevelDeclaration(suggested.getDescriptor())) {
            String qualifier;
            String fileModuleName = AnnotationsUtils.getFileModuleName(this.getBindingContext(), suggested.getDescriptor());
            if (fileModuleName != null) {
                JsName moduleJsName = this.getImportedModule(fileModuleName, null).internalName;
                expression = JsAstUtils.pureFqn(moduleJsName, (JsExpression)expression);
            }
            if ((qualifier = AnnotationsUtils.getFileQualifier(this.getBindingContext(), suggested.getDescriptor())) != null) {
                for (String qualifierPart : StringUtil.split(qualifier, ".")) {
                    expression = JsAstUtils.pureFqn(qualifierPart, (JsExpression)expression);
                }
            }
        }
        for (JsName partName : partNames) {
            expression = new JsNameRef(partName, (JsExpression)expression);
            StaticContext.applySideEffects((JsExpression)expression, suggested.getDescriptor());
        }
        assert (expression != null) : "Since partNames is not empty, expression must be non-null";
        JsExpression jsExpression = expression;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "buildQualifiedExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public JsNameRef getQualifiedReference(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedReference"));
        }
        JsName packageName = this.getNameForPackage(packageFqName);
        JsNameRef jsNameRef = JsAstUtils.pureFqn(packageName, packageFqName.isRoot() ? null : this.getQualifierForParentPackage(packageFqName.parent()));
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsName getNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForDescriptor"));
        }
        if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isAny((ClassDescriptor)descriptor2)) {
            JsName result2 = this.rootScope.declareName("Object");
            MetadataProperties.setDescriptor(result2, descriptor2);
            JsName jsName = result2;
            if (jsName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForDescriptor"));
            }
            return jsName;
        }
        SuggestedName suggested = this.nameSuggestion.suggest(descriptor2);
        if (suggested == null) {
            throw new IllegalArgumentException("Can't generate name for root declarations: " + descriptor2);
        }
        JsName jsName = this.getActualNameFromSuggested(suggested).get(0);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForDescriptor"));
        }
        return jsName;
    }

    @NotNull
    public JsName getNameForBackingField(@NotNull PropertyDescriptor property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForBackingField"));
        }
        JsName name2 = this.backingFieldNameCache.get(property);
        if (name2 == null) {
            SuggestedName fqn = this.nameSuggestion.suggest(property);
            assert (fqn != null) : "Properties are non-root declarations: " + property;
            assert (fqn.getNames().size() == 1) : "Private names must always consist of exactly one name";
            JsScope scope = this.getScopeForDescriptor(fqn.getScope());
            String baseName = NameSuggestion.getPrivateMangledName(fqn.getNames().get(0), property) + "_0";
            name2 = scope.declareFreshName(baseName);
            this.backingFieldNameCache.put(property, name2);
        }
        JsName jsName = name2;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForBackingField"));
        }
        return jsName;
    }

    @NotNull
    public JsName getInnerNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getInnerNameForDescriptor"));
        }
        JsName name2 = this.innerNames.get(descriptor2.getOriginal());
        assert (name2 != null) : "Must have inner name for descriptor";
        JsName jsName = name2;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getInnerNameForDescriptor"));
        }
        return jsName;
    }

    @NotNull
    public JsName getNameForObjectInstance(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForObjectInstance"));
        }
        JsName name2 = this.objectInstanceNames.get(descriptor2.getOriginal());
        assert (name2 != null) : "Must have inner name for object instance";
        JsName jsName = name2;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForObjectInstance"));
        }
        return jsName;
    }

    @NotNull
    private List<JsName> getActualNameFromSuggested(@NotNull SuggestedName suggested) {
        if (suggested == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggested", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getActualNameFromSuggested"));
        }
        JsScope scope = this.getScopeForDescriptor(suggested.getScope());
        if (DynamicCallsKt.isDynamic(suggested.getDescriptor())) {
            scope = JsDynamicScope.INSTANCE;
        } else if (AnnotationsUtils.isPredefinedObject(suggested.getDescriptor()) && DescriptorUtils.isTopLevelDeclaration(suggested.getDescriptor())) {
            scope = this.rootScope;
        }
        ArrayList<JsName> names2 = new ArrayList<JsName>();
        if (suggested.getStable()) {
            for (String namePart : suggested.getNames()) {
                JsName name2 = scope.declareName(namePart);
                MetadataProperties.setDescriptor(name2, suggested.getDescriptor());
                names2.add(name2);
            }
        } else {
            assert (suggested.getNames().size() == 1) : "Private names must always consist of exactly one name";
            JsName name3 = this.nameCache.get(suggested.getDescriptor());
            if (name3 == null) {
                String baseName = NameSuggestion.sanitizeName(suggested.getNames().get(0));
                if (suggested.getDescriptor() instanceof LocalVariableDescriptor || suggested.getDescriptor() instanceof ValueParameterDescriptor) {
                    name3 = scope.declareTemporaryName(baseName);
                } else {
                    if (!DescriptorUtils.isDescriptorWithLocalVisibility(suggested.getDescriptor())) {
                        baseName = baseName + "_0";
                    }
                    name3 = scope.declareFreshName(baseName);
                }
            }
            this.nameCache.put(suggested.getDescriptor(), name3);
            MetadataProperties.setDescriptor(name3, suggested.getDescriptor());
            names2.add(name3);
        }
        ArrayList<JsName> arrayList = names2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getActualNameFromSuggested"));
        }
        return arrayList;
    }

    @NotNull
    private JsName getNameForPackage(final @NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForPackage"));
        }
        JsName jsName = ContainerUtil.getOrCreate(this.packageNames, packageFqName, new Factory<JsName>(){

            @Override
            public JsName create() {
                String name2 = Namer.generatePackageName(packageFqName);
                return StaticContext.this.rootPackageScope.declareName(name2);
            }
        });
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForPackage"));
        }
        return jsName;
    }

    @NotNull
    private JsNameRef getQualifierForParentPackage(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifierForParentPackage"));
        }
        JsNameRef result2 = null;
        JsNameRef qualifier = null;
        FqName fqName2 = packageFqName;
        while (true) {
            JsNameRef ref = JsAstUtils.pureFqn(this.getNameForPackage(fqName2), null);
            if (qualifier == null) {
                result2 = ref;
            } else {
                qualifier.setQualifier(ref);
            }
            qualifier = ref;
            if (fqName2.isRoot()) break;
            fqName2 = fqName2.parent();
        }
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifierForParentPackage"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsConfig getConfig() {
        JsConfig jsConfig = this.config;
        if (jsConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getConfig"));
        }
        return jsConfig;
    }

    @NotNull
    public JsName importDeclaration(@NotNull String suggestedName, @NotNull JsExpression declaration) {
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "org/jetbrains/kotlin/js/translate/context/StaticContext", "importDeclaration"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/js/translate/context/StaticContext", "importDeclaration"));
        }
        JsName result2 = this.rootFunction.getScope().declareTemporaryName(suggestedName);
        MetadataProperties.setImported(result2, true);
        this.importStatements.add(JsAstUtils.newVar(result2, declaration));
        JsName jsName = result2;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "importDeclaration"));
        }
        return jsName;
    }

    @NotNull
    private JsName localOrImportedName(@NotNull DeclarationDescriptor descriptor2, @NotNull String suggestedName) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "localOrImportedName"));
        }
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "org/jetbrains/kotlin/js/translate/context/StaticContext", "localOrImportedName"));
        }
        ModuleDescriptor module = DescriptorUtilsKt.getModule(descriptor2);
        JsName name2 = module != this.currentModule ? this.importDeclaration(suggestedName, this.getQualifiedReference(descriptor2)) : this.rootFunction.getScope().declareTemporaryName(suggestedName);
        MetadataProperties.setDescriptor(name2, descriptor2);
        JsName jsName = name2;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "localOrImportedName"));
        }
        return jsName;
    }

    @NotNull
    public static String getSuggestedName(@NotNull DeclarationDescriptor descriptor2) {
        String suggestedName;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getSuggestedName"));
        }
        if (descriptor2 instanceof PropertyGetterDescriptor) {
            PropertyGetterDescriptor getter2 = (PropertyGetterDescriptor)descriptor2;
            suggestedName = "get_" + StaticContext.getSuggestedName(getter2.getCorrespondingProperty());
        } else if (descriptor2 instanceof PropertySetterDescriptor) {
            PropertySetterDescriptor setter2 = (PropertySetterDescriptor)descriptor2;
            suggestedName = "set_" + StaticContext.getSuggestedName(setter2.getCorrespondingProperty());
        } else if (descriptor2 instanceof ConstructorDescriptor) {
            ConstructorDescriptor constructor = (ConstructorDescriptor)descriptor2;
            suggestedName = StaticContext.getSuggestedName(constructor.getContainingDeclaration()) + "_init";
            descriptor2 = descriptor2.getContainingDeclaration();
            assert (descriptor2 != null) : "ConstructorDescriptor should have containing declaration: " + constructor;
        } else {
            suggestedName = descriptor2.getName().isSpecial() ? (descriptor2 instanceof ClassDescriptor ? (DescriptorUtils.isAnonymousObject(descriptor2) ? "ObjectLiteral" : "Anonymous") : (descriptor2 instanceof FunctionDescriptor ? "lambda" : "anonymous")) : NameSuggestion.sanitizeName(descriptor2.getName().asString());
        }
        if (!(descriptor2 instanceof PackageFragmentDescriptor) && !DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
            assert (container2 != null) : "We just figured out that descriptor is not for a top-level declaration: " + descriptor2;
            suggestedName = StaticContext.getSuggestedName(container2) + "$" + NameSuggestion.sanitizeName(suggestedName);
        }
        String string = suggestedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getSuggestedName"));
        }
        return string;
    }

    private JsScope getScopeForPackage(FqName fqName2) {
        JsScope scope = this.packageScopes.get(fqName2);
        if (scope == null) {
            if (fqName2.isRoot()) {
                scope = new JsRootScope(this.program);
            } else {
                JsScope parentScope = this.getScopeForPackage(fqName2.parent());
                scope = parentScope.innerObjectScope(fqName2.shortName().asString());
            }
            this.packageScopes.put(fqName2, scope);
        }
        return scope;
    }

    @Nullable
    public JsExpression getModuleExpressionFor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getModuleExpressionFor"));
        }
        JsName name2 = this.getModuleInnerName(descriptor2);
        return name2 != null ? JsAstUtils.pureFqn(name2, null) : null;
    }

    @Nullable
    private JsName getModuleInnerName(@NotNull DeclarationDescriptor descriptor2) {
        String moduleName;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getModuleInnerName"));
        }
        ModuleDescriptor module = DescriptorUtils.getContainingModule(descriptor2);
        if (this.currentModule == module) {
            return this.rootScope.declareName(Namer.getRootPackageName());
        }
        if (module == module.getBuiltIns().getBuiltInsModule()) {
            moduleName = Namer.KOTLIN_LOWER_NAME;
        } else {
            moduleName = module.getName().asString();
            moduleName = moduleName.substring(1, moduleName.length() - 1);
        }
        if ("<unknown>".equals(moduleName)) {
            return null;
        }
        return this.getImportedModule(moduleName, null).getInternalName();
    }

    @NotNull
    private ImportedModule getImportedModule(@NotNull String baseName, @Nullable DeclarationDescriptor descriptor2) {
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getImportedModule"));
        }
        JsName plainName = descriptor2 != null && this.config.getModuleKind() == ModuleKind.UMD ? this.rootScope.declareName(this.getPlainId(descriptor2)) : null;
        ImportedModuleKey key = new ImportedModuleKey(baseName, plainName);
        ImportedModule module = this.importedModules.get(key);
        if (module == null) {
            JsName internalName = this.rootScope.declareTemporaryName("$module$" + Namer.suggestedModuleName(baseName));
            module = new ImportedModule(baseName, internalName, plainName != null ? JsAstUtils.pureFqn(plainName, null) : null);
            this.importedModules.put(key, module);
        }
        ImportedModule importedModule = module;
        if (importedModule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getImportedModule"));
        }
        return importedModule;
    }

    @NotNull
    private String getPlainId(@NotNull DeclarationDescriptor declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getPlainId"));
        }
        SuggestedName suggestedName = this.nameSuggestion.suggest(declaration);
        assert (suggestedName != null) : "Declaration should not be ModuleDescriptor, therefore suggestedName should be non-null";
        String string = suggestedName.getNames().get(0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getPlainId"));
        }
        return string;
    }

    private static JsExpression applySideEffects(JsExpression expression, DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof FunctionDescriptor || descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof ClassDescriptor) {
            MetadataProperties.setSideEffects(expression, SideEffectKind.PURE);
        }
        return expression;
    }

    public void putClassOrConstructorClosure(@NotNull MemberDescriptor localClass, @NotNull List<DeclarationDescriptor> closure) {
        if (localClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localClass", "org/jetbrains/kotlin/js/translate/context/StaticContext", "putClassOrConstructorClosure"));
        }
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/kotlin/js/translate/context/StaticContext", "putClassOrConstructorClosure"));
        }
        this.classOrConstructorClosure.put(localClass, Lists.newArrayList(closure));
    }

    @Nullable
    public List<DeclarationDescriptor> getClassOrConstructorClosure(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getClassOrConstructorClosure"));
        }
        List<DeclarationDescriptor> result2 = this.classOrConstructorClosure.get(descriptor2);
        return result2 != null ? Lists.newArrayList(result2) : null;
    }

    @NotNull
    public Map<ClassDescriptor, List<DeferredCallSite>> getDeferredCallSites() {
        Map<ClassDescriptor, List<DeferredCallSite>> map2 = this.deferredCallSites;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getDeferredCallSites"));
        }
        return map2;
    }

    @NotNull
    public JsFunction getRootFunction() {
        JsFunction jsFunction = this.rootFunction;
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getRootFunction"));
        }
        return jsFunction;
    }

    @NotNull
    public List<JsStatement> getTopLevelStatements() {
        List<JsStatement> list2 = this.topLevelStatements;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getTopLevelStatements"));
        }
        return list2;
    }

    @NotNull
    public List<JsStatement> getDeclarationStatements() {
        List<JsStatement> list2 = this.declarationStatements;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getDeclarationStatements"));
        }
        return list2;
    }

    public void addClass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "addClass"));
        }
        this.classes.add(classDescriptor);
    }

    public void export(@NotNull MemberDescriptor descriptor2, boolean force) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "export"));
        }
        this.exporter.export(descriptor2, force);
    }

    @NotNull
    public NameSuggestion getNameSuggestion() {
        NameSuggestion nameSuggestion = this.nameSuggestion;
        if (nameSuggestion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameSuggestion"));
        }
        return nameSuggestion;
    }

    @NotNull
    public ModuleDescriptor getCurrentModule() {
        ModuleDescriptor moduleDescriptor = this.currentModule;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getCurrentModule"));
        }
        return moduleDescriptor;
    }

    public void postProcess() {
        this.addInterfaceDefaultMethods();
        this.rootFunction.getBody().getStatements().addAll(this.importStatements);
        this.addClassPrototypes();
        this.rootFunction.getBody().getStatements().addAll(this.declarationStatements);
        this.rootFunction.getBody().getStatements().addAll(this.exporter.getStatements());
        this.rootFunction.getBody().getStatements().addAll(this.topLevelStatements);
    }

    private void addClassPrototypes() {
        HashSet<ClassDescriptor> visited2 = new HashSet<ClassDescriptor>();
        for (ClassDescriptor cls : this.classes) {
            this.addClassPrototypes(cls, visited2);
        }
    }

    private void addClassPrototypes(@NotNull ClassDescriptor cls, @NotNull Set<ClassDescriptor> visited2) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "org/jetbrains/kotlin/js/translate/context/StaticContext", "addClassPrototypes"));
        }
        if (visited2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "org/jetbrains/kotlin/js/translate/context/StaticContext", "addClassPrototypes"));
        }
        if (!visited2.add(cls)) {
            return;
        }
        if (DescriptorUtilsKt.getModule(cls) != this.currentModule) {
            return;
        }
        if (AnnotationsUtils.isNativeObject(cls) || AnnotationsUtils.isLibraryObject(cls)) {
            return;
        }
        ClassDescriptor superclass = DescriptorUtilsKt.getSuperClassNotAny(cls);
        if (superclass != null) {
            this.addClassPrototypes(superclass, visited2);
            List<JsStatement> statements = this.rootFunction.getBody().getStatements();
            JsNameRef superclassRef = AnnotationsUtils.isNativeObject(superclass) || AnnotationsUtils.isLibraryObject(superclass) ? this.getQualifiedReference(superclass) : this.getInnerNameForDescriptor(superclass).makeRef();
            JsExpression superPrototype = JsAstUtils.prototypeOf(superclassRef);
            JsInvocation superPrototypeInstance = new JsInvocation((JsExpression)new JsNameRef("create", "Object"), superPrototype);
            JsNameRef classRef = new JsNameRef(this.getInnerNameForDescriptor(cls));
            JsExpression prototype = JsAstUtils.prototypeOf(classRef);
            statements.add(JsAstUtils.assignment(prototype, superPrototypeInstance).makeStmt());
            JsNameRef constructorRef = new JsNameRef("constructor", prototype.deepCopy());
            statements.add(JsAstUtils.assignment(constructorRef, ((JsExpression)classRef).deepCopy()).makeStmt());
        }
    }

    private void addInterfaceDefaultMethods() {
        new InterfaceFunctionCopier(this).copyInterfaceFunctions(this.classes);
    }

    public boolean isBuiltinModule() {
        for (ClassDescriptor cls : this.classes) {
            FqNameUnsafe fqn = DescriptorUtils.getFqName(cls);
            if (!"kotlin.Enum".equals(fqn.asString())) continue;
            return true;
        }
        return false;
    }

    private static class ImportedModuleKey {
        @NotNull
        private final String baseName;
        @Nullable
        private final JsName plainName;

        public ImportedModuleKey(@NotNull String baseName, @Nullable JsName plainName) {
            if (baseName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "org/jetbrains/kotlin/js/translate/context/StaticContext$ImportedModuleKey", "<init>"));
            }
            this.baseName = baseName;
            this.plainName = plainName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImportedModuleKey key = (ImportedModuleKey)o;
            if (!this.baseName.equals(key.baseName)) {
                return false;
            }
            return !(this.plainName != null ? !this.plainName.equals(key.plainName) : key.plainName != null);
        }

        public int hashCode() {
            int result2 = this.baseName.hashCode();
            result2 = 31 * result2 + (this.plainName != null ? this.plainName.hashCode() : 0);
            return result2;
        }
    }

    public static class ImportedModule {
        @NotNull
        private final String externalName;
        @NotNull
        private final JsName internalName;
        @Nullable
        private final JsExpression plainReference;

        ImportedModule(@NotNull String externalName, @NotNull JsName internalName, @Nullable JsExpression plainReference) {
            if (externalName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalName", "org/jetbrains/kotlin/js/translate/context/StaticContext$ImportedModule", "<init>"));
            }
            if (internalName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/js/translate/context/StaticContext$ImportedModule", "<init>"));
            }
            this.externalName = externalName;
            this.internalName = internalName;
            this.plainReference = plainReference;
        }

        @NotNull
        public String getExternalName() {
            String string = this.externalName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext$ImportedModule", "getExternalName"));
            }
            return string;
        }

        @NotNull
        public JsName getInternalName() {
            JsName jsName = this.internalName;
            if (jsName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext$ImportedModule", "getInternalName"));
            }
            return jsName;
        }

        @Nullable
        public JsExpression getPlainReference() {
            return this.plainReference;
        }
    }

    private final class ScopeGenerator
    extends Generator<JsScope> {
        public ScopeGenerator() {
            Rule<JsScope> generateNewScopesForClassesWithNoAncestors = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$1", "apply"));
                    }
                    if (!(descriptor2 instanceof ClassDescriptor)) {
                        return null;
                    }
                    if (JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor2) == null) {
                        JsFunction function2 = new JsFunction((JsScope)new JsRootScope(StaticContext.this.program), new JsBlock(), descriptor2.toString());
                        StaticContext.this.scopeToFunction.put(function2.getScope(), function2);
                        return function2.getScope();
                    }
                    return null;
                }
            };
            Rule<JsScope> generateInnerScopesForDerivedClasses = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$2", "apply"));
                    }
                    if (!(descriptor2 instanceof ClassDescriptor)) {
                        return null;
                    }
                    ClassDescriptor superclass = JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor2);
                    if (superclass == null) {
                        return null;
                    }
                    return StaticContext.this.getScopeForDescriptor(superclass).innerObjectScope("Scope for class " + descriptor2.getName());
                }
            };
            Rule<JsScope> generateNewScopesForPackageDescriptors = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$3", "apply"));
                    }
                    return StaticContext.this.rootFunction.getScope();
                }
            };
            Rule<JsScope> generateInnerScopesForMembers = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$4", "apply"));
                    }
                    return StaticContext.this.rootFunction.getScope().innerObjectScope("Scope for member " + descriptor2.getName());
                }
            };
            Rule<JsScope> createFunctionObjectsForCallableDescriptors = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$5", "apply"));
                    }
                    if (!(descriptor2 instanceof CallableDescriptor)) {
                        return null;
                    }
                    JsFunction correspondingFunction = JsAstUtils.createFunctionWithEmptyBody(StaticContext.this.rootFunction.getScope());
                    assert (!StaticContext.this.scopeToFunction.containsKey(correspondingFunction.getScope())) : "Scope to function value overridden for " + descriptor2;
                    StaticContext.this.scopeToFunction.put(correspondingFunction.getScope(), correspondingFunction);
                    return correspondingFunction.getScope();
                }
            };
            Rule<JsScope> scopeForPackage = new Rule<JsScope>(){

                @Override
                @Nullable
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$6", "apply"));
                    }
                    if (!(descriptor2 instanceof PackageFragmentDescriptor)) {
                        return null;
                    }
                    PackageFragmentDescriptor packageDescriptor = (PackageFragmentDescriptor)descriptor2;
                    return StaticContext.this.getScopeForPackage(packageDescriptor.getFqName());
                }
            };
            this.addRule(scopeForPackage);
            this.addRule(createFunctionObjectsForCallableDescriptors);
            this.addRule(generateNewScopesForClassesWithNoAncestors);
            this.addRule(generateInnerScopesForDerivedClasses);
            this.addRule(generateNewScopesForPackageDescriptors);
            this.addRule(generateInnerScopesForMembers);
        }
    }

    private final class ObjectInstanceNameGenerator
    extends Generator<JsName> {
        public ObjectInstanceNameGenerator() {
            this.addRule(new Rule<JsName>(){

                @Override
                @Nullable
                public JsName apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ObjectInstanceNameGenerator$1", "apply"));
                    }
                    String suggested = StaticContext.getSuggestedName(descriptor2) + "_getInstance";
                    return StaticContext.this.localOrImportedName(descriptor2, suggested);
                }
            });
        }
    }

    private final class InnerNameGenerator
    extends Generator<JsName> {
        public InnerNameGenerator() {
            this.addRule(new Rule<JsName>(){

                @Override
                @Nullable
                public JsName apply(@NotNull DeclarationDescriptor descriptor2) {
                    FunctionDescriptor initialDescriptor;
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$InnerNameGenerator$1", "apply"));
                    }
                    if (descriptor2 instanceof FunctionDescriptor && (initialDescriptor = ((FunctionDescriptor)descriptor2).getInitialSignatureDescriptor()) != null) {
                        return StaticContext.this.getInnerNameForDescriptor(initialDescriptor);
                    }
                    if (descriptor2 instanceof ModuleDescriptor) {
                        return StaticContext.this.getModuleInnerName(descriptor2);
                    }
                    if (descriptor2 instanceof LocalVariableDescriptor || descriptor2 instanceof ParameterDescriptor) {
                        return StaticContext.this.getNameForDescriptor(descriptor2);
                    }
                    if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary()) {
                        return StaticContext.this.getInnerNameForDescriptor(((ConstructorDescriptor)descriptor2).getConstructedClass());
                    }
                    return StaticContext.this.localOrImportedName(descriptor2, StaticContext.getSuggestedName(descriptor2));
                }
            });
        }
    }
}

