/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithDifferentJvmName;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.kotlin.JvmType;
import org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import org.jetbrains.kotlin.resolve.ExternalOverridabilityCondition;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/load/java/JavaIncompatibilityRulesOverridabilityCondition;", "Lorg/jetbrains/kotlin/resolve/ExternalOverridabilityCondition;", "()V", "getContract", "Lorg/jetbrains/kotlin/resolve/ExternalOverridabilityCondition$Contract;", "isIncompatibleInAccordanceWithBuiltInOverridabilityRules", "", "superDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "subDescriptor", "subClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isOverridable", "Lorg/jetbrains/kotlin/resolve/ExternalOverridabilityCondition$Result;", "Companion", "kotlin-compiler"})
public final class JavaIncompatibilityRulesOverridabilityCondition
implements ExternalOverridabilityCondition {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ExternalOverridabilityCondition.Result isOverridable(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor, @Nullable ClassDescriptor subClassDescriptor) {
        Intrinsics.checkParameterIsNotNull(superDescriptor, "superDescriptor");
        Intrinsics.checkParameterIsNotNull(subDescriptor, "subDescriptor");
        if (this.isIncompatibleInAccordanceWithBuiltInOverridabilityRules(superDescriptor, subDescriptor, subClassDescriptor)) {
            return ExternalOverridabilityCondition.Result.INCOMPATIBLE;
        }
        if (Companion.doesJavaOverrideHaveIncompatibleValueParameterKinds(superDescriptor, subDescriptor)) {
            return ExternalOverridabilityCondition.Result.INCOMPATIBLE;
        }
        return ExternalOverridabilityCondition.Result.UNKNOWN;
    }

    private final boolean isIncompatibleInAccordanceWithBuiltInOverridabilityRules(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor, ClassDescriptor subClassDescriptor) {
        if (!(superDescriptor instanceof CallableMemberDescriptor) || !(subDescriptor instanceof FunctionDescriptor) || KotlinBuiltIns.isBuiltIn(subDescriptor)) {
            return false;
        }
        if (!BuiltinMethodsWithSpecialGenericSignature.INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters(((FunctionDescriptor)subDescriptor).getName()) && !BuiltinMethodsWithDifferentJvmName.INSTANCE.getSameAsRenamedInJvmBuiltin(((FunctionDescriptor)subDescriptor).getName())) {
            return false;
        }
        CallableMemberDescriptor overriddenBuiltin = SpecialBuiltinMembers.getOverriddenSpecialBuiltin((CallableMemberDescriptor)superDescriptor);
        Boolean bl = ((FunctionDescriptor)subDescriptor).isHiddenToOvercomeSignatureClash();
        CallableDescriptor callableDescriptor = superDescriptor;
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor;
        boolean isOneOfDescriptorsHidden = Intrinsics.areEqual(bl, functionDescriptor != null ? Boolean.valueOf(functionDescriptor.isHiddenToOvercomeSignatureClash()) : null) ^ true;
        if (isOneOfDescriptorsHidden && (overriddenBuiltin == null || !((FunctionDescriptor)subDescriptor).isHiddenToOvercomeSignatureClash())) {
            return true;
        }
        if (!(subClassDescriptor instanceof JavaClassDescriptor) || ((FunctionDescriptor)subDescriptor).getInitialSignatureDescriptor() != null) {
            return false;
        }
        if (overriddenBuiltin == null || SpecialBuiltinMembers.hasRealKotlinSuperClassWithOverrideOf(subClassDescriptor, overriddenBuiltin)) {
            return false;
        }
        return !(overriddenBuiltin instanceof FunctionDescriptor) || !(superDescriptor instanceof FunctionDescriptor) || BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava((FunctionDescriptor)overriddenBuiltin) == null || !Intrinsics.areEqual(MethodSignatureMappingKt.computeJvmDescriptor((FunctionDescriptor)subDescriptor, false), MethodSignatureMappingKt.computeJvmDescriptor(((FunctionDescriptor)superDescriptor).getOriginal(), false));
    }

    @Override
    @NotNull
    public ExternalOverridabilityCondition.Contract getContract() {
        return ExternalOverridabilityCondition.Contract.CONFLICTS_ONLY;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/load/java/JavaIncompatibilityRulesOverridabilityCondition$Companion;", "", "()V", "doesJavaOverrideHaveIncompatibleValueParameterKinds", "", "superDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "subDescriptor", "isPrimitiveCompareTo", "f", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "mapValueParameterType", "Lorg/jetbrains/kotlin/load/kotlin/JvmType;", "valueParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "kotlin-compiler"})
    public static final class Companion {
        public final boolean doesJavaOverrideHaveIncompatibleValueParameterKinds(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(superDescriptor, "superDescriptor");
            Intrinsics.checkParameterIsNotNull(subDescriptor, "subDescriptor");
            if (!(subDescriptor instanceof JavaMethodDescriptor) || !(superDescriptor instanceof FunctionDescriptor)) {
                return false;
            }
            boolean bl2 = bl = ((JavaMethodDescriptor)subDescriptor).getValueParameters().size() == ((FunctionDescriptor)superDescriptor).getValueParameters().size();
            if (_Assertions.ENABLED && !bl) {
                String string = "External overridability condition with CONFLICTS_ONLY should not be run with different value parameters size";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Iterable iterable = ((JavaMethodDescriptor)subDescriptor).getOriginal().getValueParameters();
            List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)superDescriptor).getOriginal().getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "superDescriptor.original.valueParameters");
            for (Pair pair : CollectionsKt.zip(iterable, (Iterable)list2)) {
                ValueParameterDescriptor subParameter = (ValueParameterDescriptor)pair.component1();
                ValueParameterDescriptor superParameter = (ValueParameterDescriptor)pair.component2();
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)subDescriptor;
                ValueParameterDescriptor valueParameterDescriptor = subParameter;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "subParameter");
                boolean isSubPrimitive = this.mapValueParameterType(functionDescriptor, valueParameterDescriptor) instanceof JvmType.Primitive;
                FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)superDescriptor;
                ValueParameterDescriptor valueParameterDescriptor2 = superParameter;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor2, "superParameter");
                boolean isSuperPrimitive = this.mapValueParameterType(functionDescriptor2, valueParameterDescriptor2) instanceof JvmType.Primitive;
                if (isSubPrimitive == isSuperPrimitive) continue;
                return true;
            }
            return false;
        }

        private final JvmType mapValueParameterType(FunctionDescriptor f, ValueParameterDescriptor valueParameterDescriptor) {
            return MethodSignatureMappingKt.forceSingleValueParameterBoxing(f) || this.isPrimitiveCompareTo(f) ? MethodSignatureMappingKt.mapToJvmType(TypeUtilsKt.makeNullable(valueParameterDescriptor.getType())) : MethodSignatureMappingKt.mapToJvmType(valueParameterDescriptor.getType());
        }

        private final boolean isPrimitiveCompareTo(FunctionDescriptor f) {
            if (f.getValueParameters().size() != 1) {
                return false;
            }
            DeclarationDescriptor declarationDescriptor = f.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            if (classDescriptor == null) {
                return false;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            ClassifierDescriptor classifierDescriptor = CollectionsKt.single(f.getValueParameters()).getType().getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor3 = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor3 == null) {
                return false;
            }
            ClassDescriptor parameterClass = classDescriptor3;
            return KotlinBuiltIns.isPrimitiveClass(classDescriptor2) && Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(classDescriptor2), DescriptorUtilsKt.getFqNameSafe(parameterClass));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

