/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.util;

import com.baselet.control.util.CanOpenDiagram;
import com.baselet.control.util.Path;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.TimerTask;

public class RunningFileChecker
extends TimerTask {
    private final File file;
    private final CanOpenDiagram canOpenDiagram;

    public RunningFileChecker(File file, CanOpenDiagram canOpenDiagram) {
        this.canOpenDiagram = canOpenDiagram;
        this.file = file;
    }

    @Override
    public void run() {
        try {
            Path.safeCreateFile(this.file, false);
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            String filename = reader.readLine();
            reader.close();
            if (filename != null) {
                Path.safeDeleteFile(this.file, false);
                Path.safeCreateFile(this.file, true);
                this.canOpenDiagram.doOpen(filename);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

