/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.core;

import java.util.Iterator;
import org.owasp.jbrofuzz.core.Fuzzer;
import org.owasp.jbrofuzz.core.NoSuchFuzzerException;
import org.owasp.jbrofuzz.core.Prototype;

public class CrossProductFuzzer
implements Iterator<String[]> {
    private final Fuzzer fuzzer1;
    private final Fuzzer fuzzer2;
    private transient long cValue;
    private final transient long maxValue;
    private transient String payload1;
    private transient String payload2;

    protected CrossProductFuzzer(Prototype proto1, int len1, Prototype proto2, int len2) throws NoSuchFuzzerException {
        this.fuzzer1 = new Fuzzer(proto1, len1);
        this.fuzzer2 = new Fuzzer(proto2, len2);
        this.cValue = 0L;
        this.maxValue = this.fuzzer1.getMaximumValue() * this.fuzzer2.getMaximumValue();
    }

    public long getCurrentValue() {
        return this.cValue;
    }

    public String getId() {
        return "X-Fuzzer( " + this.fuzzer1.getId() + ", " + this.fuzzer2.getId() + " )";
    }

    public long getMaximumValue() {
        return this.maxValue;
    }

    public String getName() {
        return "X-Fuzzer( " + this.fuzzer1.getName() + ", " + this.fuzzer2.getName() + " )";
    }

    @Override
    public boolean hasNext() {
        return this.cValue < this.maxValue;
    }

    @Override
    public String[] next() {
        if (this.cValue % this.fuzzer2.getMaximumValue() == 0L) {
            this.payload1 = this.fuzzer1.next();
        }
        if (!this.fuzzer2.hasNext()) {
            this.fuzzer2.resetCurrentValue();
        }
        this.payload2 = this.fuzzer2.next();
        ++this.cValue;
        return new String[]{this.payload1, this.payload2};
    }

    @Override
    public void remove() {
        --this.cValue;
    }

    public int getPower() {
        return 2;
    }
}

