/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.SortOrder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.option.DialogAddProxyExcludedDomain;
import org.parosproxy.paros.extension.option.DialogModifyProxyExcludedDomain;
import org.parosproxy.paros.extension.option.ProxyExcludedDomainsTableModel;
import org.parosproxy.paros.extension.option.SecurityProtocolsPanel;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.ProxyExcludedDomainMatcher;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.CommonUserAgents;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapPortNumberSpinner;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractMultipleOptionsTablePanel;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.ProxyDialog;

public class OptionsConnectionPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox chkUseProxyChain = null;
    private JPanel jPanel = null;
    private JPanel panelProxyAuth = null;
    private JPanel panelProxyChain = null;
    private ZapTextField txtProxyChainName = null;
    private ZapPortNumberSpinner spinnerProxyChainPort = null;
    private ZapTextField txtProxyChainRealm = null;
    private ZapTextField txtProxyChainUserName = null;
    private JPasswordField txtProxyChainPassword = null;
    private JCheckBox chkShowPassword = null;
    private JCheckBox chkProxyChainAuth = null;
    private JCheckBox chkProxyChainPrompt = null;
    private ZapTextField txtTimeoutInSecs = null;
    private JPanel panelGeneral = null;
    private JCheckBox checkBoxSingleCookieRequestHeader;
    private JComboBox<String> commonUserAgents = null;
    private ZapTextField defaultUserAgent = null;
    private SecurityProtocolsPanel securityProtocolsPanel;
    private ProxyExcludedDomainsMultipleOptionsPanel proxyExcludedDomainsPanel;
    private ProxyExcludedDomainsTableModel proxyExcludedDomainsTableModel;

    public OptionsConnectionPanel() {
        this.initialize();
    }

    private JCheckBox getChkShowPassword() {
        if (this.chkShowPassword == null) {
            this.chkShowPassword = new JCheckBox();
            this.chkShowPassword.setText(Constant.messages.getString("conn.options.proxy.auth.showpass"));
            this.chkShowPassword.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (OptionsConnectionPanel.this.chkShowPassword.isSelected()) {
                        OptionsConnectionPanel.this.txtProxyChainPassword.setEchoChar('\u0000');
                    } else {
                        OptionsConnectionPanel.this.txtProxyChainPassword.setEchoChar('*');
                    }
                }
            });
        }
        return this.chkShowPassword;
    }

    private JCheckBox getChkUseProxyChain() {
        if (this.chkUseProxyChain == null) {
            this.chkUseProxyChain = new JCheckBox();
            this.chkUseProxyChain.setText(Constant.messages.getString("conn.options.useProxy"));
            this.chkUseProxyChain.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsConnectionPanel.this.setProxyChainEnabled(OptionsConnectionPanel.this.chkUseProxyChain.isSelected());
                }
            });
        }
        return this.chkUseProxyChain;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            JLabel jLabel2 = new JLabel();
            JLabel jLabel3 = new JLabel();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            jLabel3.setText(Constant.messages.getString("conn.options.proxy.address"));
            jLabel2.setText(Constant.messages.getString("conn.options.proxy.port"));
            jLabel.setText(Constant.messages.getString("conn.options.proxy.skipAddresses"));
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints7.anchor = 18;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridwidth = 2;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.weightx = 0.5;
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 0.5;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.ipadx = 50;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.weightx = 0.5;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.weightx = 0.5;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.ipadx = 50;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 3;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.anchor = 12;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 12;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.ipady = 20;
            this.jPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("conn.options.proxy.useProxyChain"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            this.jPanel.add((Component)this.getChkUseProxyChain(), gridBagConstraints7);
            this.jPanel.add((Component)jLabel3, gridBagConstraints6);
            this.jPanel.add((Component)this.getTxtProxyChainName(), gridBagConstraints5);
            this.jPanel.add((Component)jLabel2, gridBagConstraints4);
            this.jPanel.add((Component)this.getTxtProxyChainPort(), gridBagConstraints3);
            this.jPanel.add((Component)jLabel, gridBagConstraints2);
            this.jPanel.add((Component)this.getProxyExcludedDomainsPanel(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private JPanel getPanelProxyAuth() {
        if (this.panelProxyAuth == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            JLabel jLabel2 = new JLabel();
            JLabel jLabel3 = new JLabel();
            this.panelProxyAuth = new JPanel();
            this.panelProxyAuth.setLayout(new GridBagLayout());
            jLabel3.setText(Constant.messages.getString("conn.options.proxy.auth.realm"));
            jLabel2.setText(Constant.messages.getString("conn.options.proxy.auth.username"));
            jLabel.setText(Constant.messages.getString("conn.options.proxy.auth.password"));
            this.panelProxyAuth.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("conn.options.proxy.auth.auth"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints8.anchor = 18;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridwidth = 2;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = 1;
            gridBagConstraints9.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridwidth = 2;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 2;
            gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.weightx = 0.5;
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.weightx = 0.5;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.ipadx = 50;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 3;
            gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.weightx = 0.5;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 3;
            gridBagConstraints4.weightx = 0.5;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.ipadx = 50;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 4;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.weightx = 0.5;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 4;
            gridBagConstraints2.weightx = 0.5;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.ipadx = 50;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.ipadx = 50;
            this.panelProxyAuth.add((Component)this.getChkProxyChainAuth(), gridBagConstraints8);
            this.panelProxyAuth.add((Component)this.getChkProxyChainPrompt(), gridBagConstraints9);
            this.panelProxyAuth.add((Component)jLabel3, gridBagConstraints7);
            this.panelProxyAuth.add((Component)this.getTxtProxyChainRealm(), gridBagConstraints6);
            this.panelProxyAuth.add((Component)jLabel2, gridBagConstraints5);
            this.panelProxyAuth.add((Component)this.getTxtProxyChainUserName(), gridBagConstraints4);
            this.panelProxyAuth.add((Component)jLabel, gridBagConstraints3);
            this.panelProxyAuth.add((Component)this.getTxtProxyChainPassword(), gridBagConstraints2);
            this.panelProxyAuth.add((Component)this.getChkShowPassword(), gridBagConstraints);
        }
        return this.panelProxyAuth;
    }

    private JPanel getPanelProxyChain() {
        if (this.panelProxyChain == null) {
            this.panelProxyChain = new JPanel(new BorderLayout());
            this.panelProxyChain.setName("ProxyChain");
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 3;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.fill = 2;
            jPanel.add((Component)this.getPanelGeneral(), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            jPanel.add((Component)this.getSecurityProtocolsPanel(), gridBagConstraints);
            jPanel.add((Component)this.getJPanel(), gridBagConstraints2);
            jPanel.add((Component)this.getPanelProxyAuth(), gridBagConstraints3);
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.panelProxyChain.add((Component)jScrollPane, "Center");
        }
        return this.panelProxyChain;
    }

    private ZapTextField getTxtProxyChainName() {
        if (this.txtProxyChainName == null) {
            this.txtProxyChainName = new ZapTextField();
        }
        return this.txtProxyChainName;
    }

    private ZapPortNumberSpinner getTxtProxyChainPort() {
        if (this.spinnerProxyChainPort == null) {
            this.spinnerProxyChainPort = new ZapPortNumberSpinner(8080);
        }
        return this.spinnerProxyChainPort;
    }

    private JComboBox<String> getCommonUserAgents() {
        if (this.commonUserAgents == null) {
            this.commonUserAgents = new JComboBox<String>(CommonUserAgents.getNames());
            if (this.commonUserAgents.getItemCount() == 0) {
                this.commonUserAgents.setEnabled(false);
            } else {
                this.commonUserAgents.addItem("");
                this.commonUserAgents.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = (String)OptionsConnectionPanel.this.commonUserAgents.getSelectedItem();
                        String string2 = CommonUserAgents.getStringFromName(string);
                        if (string2 != null) {
                            OptionsConnectionPanel.this.getDefaultUserAgent().setText(string2);
                        }
                    }
                });
            }
        }
        return this.commonUserAgents;
    }

    private ZapTextField getDefaultUserAgent() {
        if (this.defaultUserAgent == null) {
            this.defaultUserAgent = new ZapTextField();
            this.defaultUserAgent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsConnectionPanel.this.setUaFromString();
                }
            });
            this.defaultUserAgent.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    OptionsConnectionPanel.this.setUaFromString();
                }
            });
        }
        return this.defaultUserAgent;
    }

    private void setUaFromString() {
        String string = CommonUserAgents.getNameFromString(this.getDefaultUserAgent().getText());
        if (string != null) {
            this.getCommonUserAgents().setSelectedItem(string);
        } else {
            this.getCommonUserAgents().setSelectedItem("");
        }
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("conn.options.title"));
        this.add((Component)this.getPanelProxyChain(), this.getPanelProxyChain().getName());
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        ConnectionParam connectionParam = optionsParam.getConnectionParam();
        this.txtTimeoutInSecs.setText(Integer.toString(connectionParam.getTimeoutInSecs()));
        this.txtTimeoutInSecs.discardAllEdits();
        this.checkBoxSingleCookieRequestHeader.setSelected(connectionParam.isSingleCookieRequestHeader());
        this.getProxyExcludedDomainsTableModel().setExcludedDomains(connectionParam.getProxyExcludedDomains());
        this.getProxyExcludedDomainsPanel().setRemoveWithoutConfirmation(!connectionParam.isConfirmRemoveProxyExcludedDomain());
        this.chkUseProxyChain.setSelected(connectionParam.isUseProxyChain());
        this.txtProxyChainName.setText(connectionParam.getProxyChainName());
        this.txtProxyChainName.discardAllEdits();
        this.spinnerProxyChainPort.setValue(connectionParam.getProxyChainPort());
        this.chkProxyChainAuth.setSelected(connectionParam.isUseProxyChainAuth());
        this.txtProxyChainRealm.setText(connectionParam.getProxyChainRealm());
        this.txtProxyChainRealm.discardAllEdits();
        this.txtProxyChainUserName.setText(connectionParam.getProxyChainUserName());
        this.txtProxyChainUserName.discardAllEdits();
        this.chkProxyChainPrompt.setSelected(connectionParam.isProxyChainPrompt());
        this.chkShowPassword.setSelected(false);
        this.txtProxyChainPassword.setEchoChar('*');
        this.setProxyChainEnabled(connectionParam.isUseProxyChain());
        if (!connectionParam.isProxyChainPrompt()) {
            this.txtProxyChainPassword.setText(connectionParam.getProxyChainPassword());
        }
        this.securityProtocolsPanel.setSecurityProtocolsEnabled(connectionParam.getSecurityProtocolsEnabled());
        this.defaultUserAgent.setText(connectionParam.getDefaultUserAgent());
        this.setUaFromString();
    }

    private void setProxyChainEnabled(boolean bl) {
        this.txtProxyChainName.setEnabled(bl);
        this.spinnerProxyChainPort.setEnabled(bl);
        this.getProxyExcludedDomainsPanel().setComponentEnabled(bl);
        this.chkProxyChainAuth.setEnabled(bl);
        this.setProxyChainAuthEnabled(bl && this.chkProxyChainAuth.isSelected());
        Color color = Color.WHITE;
        if (!bl) {
            color = this.panelProxyChain.getBackground();
        }
        this.txtProxyChainName.setBackground(color);
        this.spinnerProxyChainPort.setBackground(color);
    }

    private void setProxyChainAuthEnabled(boolean bl) {
        this.txtProxyChainRealm.setEnabled(bl);
        this.txtProxyChainUserName.setEnabled(bl);
        this.txtProxyChainPassword.setEnabled(bl);
        this.chkProxyChainPrompt.setEnabled(bl);
        this.chkShowPassword.setEnabled(bl);
        if (this.chkProxyChainPrompt.isSelected()) {
            this.setProxyChainPromptEnabled(true);
        }
        Color color = Color.WHITE;
        if (!bl) {
            color = this.panelProxyChain.getBackground();
        }
        this.txtProxyChainRealm.setBackground(color);
        this.txtProxyChainUserName.setBackground(color);
        this.txtProxyChainPassword.setBackground(color);
    }

    private void setProxyChainPromptEnabled(boolean bl) {
        this.txtProxyChainPassword.setEnabled(!bl);
        this.chkShowPassword.setEnabled(!bl);
        Color color = Color.WHITE;
        if (bl) {
            this.txtProxyChainPassword.setText("");
            color = this.panelProxyChain.getBackground();
        }
        this.txtProxyChainPassword.setBackground(color);
    }

    @Override
    public void validateParam(Object object) throws Exception {
        try {
            Integer.parseInt(this.txtTimeoutInSecs.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.txtTimeoutInSecs.requestFocus();
            throw new Exception(Constant.messages.getString("conn.options.timeout.invalid"));
        }
        if (this.chkUseProxyChain.isSelected()) {
            if (this.txtProxyChainName.getText().isEmpty()) {
                this.txtProxyChainName.requestFocus();
                throw new Exception(Constant.messages.getString("conn.options.proxy.address.empty"));
            }
            if (this.chkProxyChainAuth.isSelected() && !this.chkProxyChainPrompt.isSelected() && this.txtProxyChainUserName.getText().isEmpty()) {
                this.txtProxyChainUserName.requestFocus();
                throw new Exception(Constant.messages.getString("conn.options.proxy.username.empty"));
            }
        }
        this.securityProtocolsPanel.validateSecurityProtocols();
    }

    @Override
    public void saveParam(Object object) throws Exception {
        int n;
        OptionsParam optionsParam = (OptionsParam)object;
        ConnectionParam connectionParam = optionsParam.getConnectionParam();
        try {
            n = Integer.parseInt(this.txtTimeoutInSecs.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.txtTimeoutInSecs.requestFocus();
            throw new Exception(Constant.messages.getString("conn.options.timeout.invalid"));
        }
        connectionParam.setProxyChainName(this.txtProxyChainName.getText());
        connectionParam.setProxyChainPort(this.spinnerProxyChainPort.getValue());
        connectionParam.setProxyExcludedDomains(this.getProxyExcludedDomainsTableModel().getElements());
        connectionParam.setConfirmRemoveProxyExcludedDomain(!this.getProxyExcludedDomainsPanel().isRemoveWithoutConfirmation());
        connectionParam.setProxyChainRealm(this.txtProxyChainRealm.getText());
        connectionParam.setProxyChainUserName(this.txtProxyChainUserName.getText());
        connectionParam.setProxyChainPrompt(this.chkProxyChainPrompt.isSelected());
        if (this.chkUseProxyChain.isSelected() && this.chkProxyChainAuth.isSelected() && this.chkProxyChainPrompt.isSelected()) {
            if (View.isInitialised()) {
                ProxyDialog proxyDialog = new ProxyDialog((Frame)View.getSingleton().getMainFrame(), true);
                proxyDialog.init(Model.getSingleton().getOptionsParam());
                proxyDialog.setVisible(true);
            }
        } else {
            connectionParam.setProxyChainPassword(new String(this.txtProxyChainPassword.getPassword()));
        }
        connectionParam.setTimeoutInSecs(n);
        connectionParam.setSingleCookieRequestHeader(this.checkBoxSingleCookieRequestHeader.isSelected());
        connectionParam.setUseProxyChain(this.chkUseProxyChain.isSelected());
        connectionParam.setUseProxyChainAuth(this.chkProxyChainAuth.isSelected());
        connectionParam.setSecurityProtocolsEnabled(this.securityProtocolsPanel.getSelectedProtocols());
        connectionParam.setDefaultUserAgent(this.defaultUserAgent.getText());
    }

    private ZapTextField getTxtProxyChainRealm() {
        if (this.txtProxyChainRealm == null) {
            this.txtProxyChainRealm = new ZapTextField();
        }
        return this.txtProxyChainRealm;
    }

    private ZapTextField getTxtProxyChainUserName() {
        if (this.txtProxyChainUserName == null) {
            this.txtProxyChainUserName = new ZapTextField();
        }
        return this.txtProxyChainUserName;
    }

    private JPasswordField getTxtProxyChainPassword() {
        if (this.txtProxyChainPassword == null) {
            this.txtProxyChainPassword = new JPasswordField();
        }
        return this.txtProxyChainPassword;
    }

    private JCheckBox getChkProxyChainAuth() {
        if (this.chkProxyChainAuth == null) {
            this.chkProxyChainAuth = new JCheckBox();
            this.chkProxyChainAuth.setText(Constant.messages.getString("conn.options.proxy.auth.required"));
            this.chkProxyChainAuth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsConnectionPanel.this.setProxyChainAuthEnabled(OptionsConnectionPanel.this.chkProxyChainAuth.isSelected());
                }
            });
        }
        return this.chkProxyChainAuth;
    }

    private JCheckBox getChkProxyChainPrompt() {
        if (this.chkProxyChainPrompt == null) {
            this.chkProxyChainPrompt = new JCheckBox();
            this.chkProxyChainPrompt.setText(Constant.messages.getString("conn.options.proxy.auth.prompt"));
            this.chkProxyChainPrompt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsConnectionPanel.this.setProxyChainPromptEnabled(OptionsConnectionPanel.this.chkProxyChainPrompt.isSelected());
                }
            });
        }
        return this.chkProxyChainPrompt;
    }

    private JPanel getPanelGeneral() {
        if (this.panelGeneral == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            this.panelGeneral = new JPanel();
            this.panelGeneral.setLayout(new GridBagLayout());
            jLabel.setText(Constant.messages.getString("conn.options.timeout"));
            jLabel.setLabelFor(this.getTxtTimeoutInSecs());
            this.panelGeneral.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("conn.options.general"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 0.5;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.ipadx = 50;
            this.panelGeneral.add((Component)jLabel, gridBagConstraints2);
            this.panelGeneral.add((Component)this.getTxtTimeoutInSecs(), gridBagConstraints);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridy = 3;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.anchor = 17;
            JLabel jLabel2 = new JLabel(Constant.messages.getString("conn.options.defaultUserAgent"));
            jLabel2.setLabelFor(this.getDefaultUserAgent());
            this.panelGeneral.add((Component)jLabel2, LayoutHelper.getGBC(0, 1, 1, 0.5));
            this.panelGeneral.add(this.getCommonUserAgents(), LayoutHelper.getGBC(1, 1, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panelGeneral.add((Component)this.getDefaultUserAgent(), LayoutHelper.getGBC(0, 2, 2, 1.0, new Insets(2, 2, 2, 2)));
            this.panelGeneral.add((Component)this.getCheckBoxSingleCookeRequestHeader(), gridBagConstraints3);
        }
        return this.panelGeneral;
    }

    private SecurityProtocolsPanel getSecurityProtocolsPanel() {
        if (this.securityProtocolsPanel == null) {
            this.securityProtocolsPanel = new SecurityProtocolsPanel();
        }
        return this.securityProtocolsPanel;
    }

    private ZapTextField getTxtTimeoutInSecs() {
        if (this.txtTimeoutInSecs == null) {
            this.txtTimeoutInSecs = new ZapTextField();
        }
        return this.txtTimeoutInSecs;
    }

    private JCheckBox getCheckBoxSingleCookeRequestHeader() {
        if (this.checkBoxSingleCookieRequestHeader == null) {
            this.checkBoxSingleCookieRequestHeader = new JCheckBox(Constant.messages.getString("conn.options.singleCookieRequestHeader"));
        }
        return this.checkBoxSingleCookieRequestHeader;
    }

    private ProxyExcludedDomainsMultipleOptionsPanel getProxyExcludedDomainsPanel() {
        if (this.proxyExcludedDomainsPanel == null) {
            this.proxyExcludedDomainsPanel = new ProxyExcludedDomainsMultipleOptionsPanel(this.getProxyExcludedDomainsTableModel());
        }
        return this.proxyExcludedDomainsPanel;
    }

    private ProxyExcludedDomainsTableModel getProxyExcludedDomainsTableModel() {
        if (this.proxyExcludedDomainsTableModel == null) {
            this.proxyExcludedDomainsTableModel = new ProxyExcludedDomainsTableModel();
        }
        return this.proxyExcludedDomainsTableModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.connection";
    }

    private static class ProxyExcludedDomainsMultipleOptionsPanel
    extends AbstractMultipleOptionsTablePanel<ProxyExcludedDomainMatcher> {
        private static final long serialVersionUID = 2332044353650231701L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("conn.options.proxy.excluded.domain.dialog.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("conn.options.proxy.excluded.domain.dialog.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("conn.options.proxy.excluded.domain.dialog.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("conn.options.proxy.excluded.domain.dialog.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("conn.options.proxy.excluded.domain.dialog.remove.checkbox.label");
        private DialogAddProxyExcludedDomain addDialog = null;
        private DialogModifyProxyExcludedDomain modifyDialog = null;

        public ProxyExcludedDomainsMultipleOptionsPanel(ProxyExcludedDomainsTableModel proxyExcludedDomainsTableModel) {
            super(proxyExcludedDomainsTableModel);
            this.getTable().setVisibleRowCount(5);
            this.getTable().setSortOrder(2, SortOrder.ASCENDING);
        }

        @Override
        public ProxyExcludedDomainMatcher showAddDialogue() {
            if (this.addDialog == null) {
                this.addDialog = new DialogAddProxyExcludedDomain(View.getSingleton().getOptionsDialog(null));
                this.addDialog.pack();
            }
            this.addDialog.setVisible(true);
            ProxyExcludedDomainMatcher proxyExcludedDomainMatcher = this.addDialog.getProxyExcludedDomain();
            this.addDialog.clear();
            return proxyExcludedDomainMatcher;
        }

        @Override
        public ProxyExcludedDomainMatcher showModifyDialogue(ProxyExcludedDomainMatcher proxyExcludedDomainMatcher) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogModifyProxyExcludedDomain(View.getSingleton().getOptionsDialog(null));
                this.modifyDialog.pack();
            }
            this.modifyDialog.setProxyExcludedDomain(proxyExcludedDomainMatcher);
            this.modifyDialog.setVisible(true);
            ProxyExcludedDomainMatcher proxyExcludedDomainMatcher2 = this.modifyDialog.getProxyExcludedDomain();
            this.modifyDialog.clear();
            if (!proxyExcludedDomainMatcher2.equals(proxyExcludedDomainMatcher)) {
                return proxyExcludedDomainMatcher2;
            }
            return null;
        }

        @Override
        public boolean showRemoveDialogue(ProxyExcludedDomainMatcher proxyExcludedDomainMatcher) {
            JCheckBox jCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] objectArray = new Object[]{REMOVE_DIALOG_TEXT, " ", jCheckBox};
            int n = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), objectArray, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (n == 0) {
                this.setRemoveWithoutConfirmation(jCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }
}

