/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.util.Collections;
import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.parosproxy.paros.core.scanner.Alert;

public class AlertNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private final Comparator<AlertNode> childComparator;
    private String nodeName = null;
    private int risk = -1;
    private Alert alert;

    public AlertNode(int n, String string) {
        this(n, string, null);
    }

    public AlertNode(int n, String string, Comparator<AlertNode> comparator) {
        this.nodeName = string;
        this.setRisk(n);
        this.childComparator = comparator;
    }

    @Override
    public void setUserObject(Object object) {
        if (!(object instanceof Alert)) {
            throw new IllegalArgumentException("Parameter userObject must be an Alert.");
        }
        this.alert = (Alert)object;
    }

    @Override
    public Alert getUserObject() {
        return this.alert;
    }

    @Override
    public AlertNode getChildAt(int n) {
        return (AlertNode)super.getChildAt(n);
    }

    @Override
    public AlertNode getParent() {
        return (AlertNode)super.getParent();
    }

    @Override
    public void add(MutableTreeNode mutableTreeNode) {
        if (!(mutableTreeNode instanceof AlertNode)) {
            throw new IllegalArgumentException("Parameter newChild must be an AlertNode.");
        }
        super.add(mutableTreeNode);
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        if (!(mutableTreeNode instanceof AlertNode)) {
            throw new IllegalArgumentException("Parameter newChild must be an AlertNode.");
        }
        super.insert(mutableTreeNode, n);
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!(treeNode instanceof AlertNode)) {
            return -1;
        }
        if (!this.isNodeChild(treeNode)) {
            return -1;
        }
        int n = this.findIndex((AlertNode)treeNode);
        if (n < 0) {
            return -1;
        }
        return n;
    }

    public int findIndex(AlertNode alertNode) {
        if (this.children == null) {
            return -1;
        }
        int n = Collections.binarySearch(this.children, alertNode, this.childComparator);
        return n;
    }

    @Override
    public String toString() {
        if (this.getChildCount() > 1) {
            return this.nodeName + " (" + this.getChildCount() + ")";
        }
        return this.nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setRisk(int n) {
        this.risk = n;
    }

    public int getRisk() {
        return this.risk;
    }
}

