/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.component.split.request;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.request.RequestHeaderStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.text.HttpPanelTextArea;
import org.zaproxy.zap.extension.httppanel.view.text.HttpPanelTextView;
import org.zaproxy.zap.extension.search.SearchMatch;

public class HttpRequestHeaderPanelTextView
extends HttpPanelTextView {
    private static final Logger log = Logger.getLogger(HttpRequestHeaderPanelTextView.class);

    public HttpRequestHeaderPanelTextView(RequestHeaderStringHttpPanelViewModel requestHeaderStringHttpPanelViewModel) {
        super(requestHeaderStringHttpPanelViewModel);
    }

    @Override
    protected HttpPanelTextArea createHttpPanelTextArea() {
        return new HttpRequestHeaderPanelTextArea();
    }

    private static class HttpRequestHeaderPanelTextArea
    extends HttpPanelTextArea {
        private static final long serialVersionUID = 985537589818833350L;

        private HttpRequestHeaderPanelTextArea() {
        }

        @Override
        public void search(Pattern pattern, List<SearchMatch> list) {
            Matcher matcher = pattern.matcher(this.getText());
            while (matcher.find()) {
                int n = matcher.start();
                try {
                    n += this.getLineOfOffset(n);
                }
                catch (BadLocationException badLocationException) {
                    log.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
                    return;
                }
                int n2 = matcher.end();
                try {
                    n2 += this.getLineOfOffset(n2);
                }
                catch (BadLocationException badLocationException) {
                    log.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
                    return;
                }
                list.add(new SearchMatch(SearchMatch.Location.REQUEST_HEAD, n, n2));
            }
        }

        @Override
        public void highlight(SearchMatch searchMatch) {
            if (!SearchMatch.Location.REQUEST_HEAD.equals((Object)searchMatch.getLocation())) {
                return;
            }
            int n = 0;
            String string = searchMatch.getMessage().getRequestHeader().toString();
            int n2 = 0;
            while ((n2 = string.indexOf("\r\n", n2)) != -1 && n2 < searchMatch.getStart()) {
                n2 += 2;
                ++n;
            }
            int n3 = this.getText().length();
            if (searchMatch.getStart() - n > n3 || searchMatch.getEnd() - n > n3) {
                return;
            }
            this.highlight(searchMatch.getStart() - n, searchMatch.getEnd() - n);
        }
    }
}

