/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordStructure;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.StructuralSiteNode;
import org.zaproxy.zap.model.StructuralTableNode;

public class SessionStructure {
    public static final String ROOT = "Root";
    public static final String DATA_DRIVEN_NODE_PREFIX = "\u00ab";
    public static final String DATA_DRIVEN_NODE_POSTFIX = "\u00bb";
    public static final String DATA_DRIVEN_NODE_REGEX = "(.+?)";
    private static final Logger log = Logger.getLogger(SessionStructure.class);

    public static StructuralNode addPath(Session session, HistoryReference historyReference, HttpMessage httpMessage) {
        if (!Constant.isLowMemoryOptionSet()) {
            return new StructuralSiteNode(session.getSiteTree().addPath(historyReference, httpMessage));
        }
        try {
            List<String> list = session.getTreePath(httpMessage);
            String string = SessionStructure.getHostName(httpMessage.getRequestHeader().getURI());
            return new StructuralTableNode(SessionStructure.addStructure(session, string, httpMessage, list, list.size(), historyReference.getHistoryId()));
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public static StructuralNode find(long l, URI uRI, String string, String string2) throws DatabaseException, URIException {
        Model model = Model.getSingleton();
        if (!Constant.isLowMemoryOptionSet()) {
            SiteNode siteNode = model.getSession().getSiteTree().findNode(uRI, string, string2);
            if (siteNode == null) {
                return null;
            }
            return new StructuralSiteNode(siteNode);
        }
        String string3 = SessionStructure.getNodeName(l, uRI, string, string2);
        RecordStructure recordStructure = model.getDb().getTableStructure().find(l, string3, string);
        if (recordStructure == null) {
            return null;
        }
        return new StructuralTableNode(recordStructure);
    }

    private static String getNodeName(long l, URI uRI, String string, String string2) throws URIException {
        String string3;
        Session session = Model.getSingleton().getSession();
        List<String> list = session.getTreePath(uRI);
        String string4 = SessionStructure.getHostName(uRI);
        String string5 = SessionStructure.pathsToUrl(string4, list, list.size());
        if (string2 != null && (string3 = SessionStructure.getParams(session, uRI, string2)).length() > 0) {
            string5 = string5 + " " + string3;
        }
        return string5;
    }

    private static String getNodeName(Session session, String string, HttpMessage httpMessage, List<String> list, int n) throws URIException {
        String string2;
        String string3 = SessionStructure.pathsToUrl(string, list, n);
        if (httpMessage != null && (string2 = SessionStructure.getParams(session, httpMessage)).length() > 0) {
            string3 = string3 + " " + string2;
        }
        return string3;
    }

    public static String regexEscape(String string) {
        String string2 = ".*+?^=!${}()|[]\\";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) >= 0) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String getRegexName(StructuralNode structuralNode, boolean bl) {
        return SessionStructure.getSpecifiedName(structuralNode, bl, true);
    }

    public static String getCleanRelativeName(StructuralNode structuralNode, boolean bl) {
        return SessionStructure.getSpecifiedName(structuralNode, bl, false);
    }

    private static String getSpecifiedName(StructuralNode structuralNode, boolean bl, boolean bl2) {
        int n;
        int n2;
        String string = structuralNode.getName();
        if (structuralNode.isDataDriven() && bl2) {
            return DATA_DRIVEN_NODE_REGEX;
        }
        int n3 = string.lastIndexOf("(");
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        if ((n2 = string.indexOf("?")) >= 0) {
            if (bl) {
                String string2 = string.substring(n2);
                string = string.substring(0, n2) + SessionStructure.regexEscape(string2);
            } else {
                string = string.substring(0, n2);
            }
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            if (structuralNode.getURI().getPath() == null || structuralNode.getURI().getPath().length() == 1) {
                return string;
            }
        }
        catch (URIException uRIException) {
            // empty catch block
        }
        int n4 = string.lastIndexOf(47);
        if (n4 >= 0) {
            string = string.substring(n4 + 1);
        }
        if (structuralNode.isLeaf() && (n = string.indexOf(":")) > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String getRegexPattern(StructuralNode structuralNode) throws DatabaseException {
        return SessionStructure.getRegexPattern(structuralNode, true);
    }

    public static String getRegexPattern(StructuralNode structuralNode, boolean bl) throws DatabaseException {
        boolean bl2;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = bl2 = structuralNode.isLeaf() || !bl;
        while (!structuralNode.isRoot()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, "/");
            }
            stringBuilder.insert(0, SessionStructure.getRegexName(structuralNode, bl2));
            structuralNode = structuralNode.getParent();
            bl2 = false;
        }
        if (bl) {
            stringBuilder.append(".*");
        }
        return stringBuilder.toString();
    }

    private static RecordStructure addStructure(Session session, String string, HttpMessage httpMessage, List<String> list, int n, int n2) throws DatabaseException, URIException {
        RecordStructure recordStructure;
        String string2;
        String string3 = SessionStructure.getNodeName(session, string, httpMessage, list, n);
        String string4 = SessionStructure.pathsToUrl(string, list, n - 1);
        String string5 = "";
        if (httpMessage != null) {
            string5 = httpMessage.getRequestHeader().getURI().toString();
            string2 = SessionStructure.getParams(session, httpMessage);
            if (string2.length() > 0) {
                string3 = string3 + " " + string2;
            }
        }
        string2 = "GET";
        if (httpMessage != null) {
            string2 = httpMessage.getRequestHeader().getMethod();
        }
        if ((recordStructure = Model.getSingleton().getDb().getTableStructure().find(session.getSessionId(), string3, string2)) == null) {
            long l = -1L;
            if (!string3.equals(ROOT)) {
                HttpMessage httpMessage2 = null;
                int n3 = -1;
                if (!string4.equals(ROOT)) {
                    httpMessage2 = SessionStructure.getTempHttpMessage(session, string4, httpMessage);
                    n3 = httpMessage2.getHistoryRef().getHistoryId();
                }
                RecordStructure recordStructure2 = SessionStructure.addStructure(session, string, httpMessage2, list, n - 1, n3);
                l = recordStructure2.getStructureId();
            }
            recordStructure = Model.getSingleton().getDb().getTableStructure().insert(session.getSessionId(), l, n2, string3, string5, string2);
        }
        return recordStructure;
    }

    private static HttpMessage getTempHttpMessage(Session session, String string, HttpMessage httpMessage) {
        try {
            HttpMessage httpMessage2 = httpMessage.cloneRequest();
            URI uRI = new URI(string, false);
            httpMessage2.getRequestHeader().setURI(uRI);
            httpMessage2.getRequestHeader().setMethod("GET");
            httpMessage2.getRequestBody().setBody("");
            httpMessage2.getRequestHeader().setHeader("Content-Type", null);
            httpMessage2.getRequestHeader().setHeader("Content-Length", null);
            HistoryReference historyReference = new HistoryReference(session, 0, httpMessage2);
            httpMessage2.setHistoryRef(historyReference);
            return httpMessage2;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private static String pathsToUrl(String string, List<String> list, int n) {
        if (n < 0) {
            return ROOT;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        int n2 = 1;
        for (String string2 : list) {
            if (n2 > n) break;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("/");
            }
            stringBuilder.append(string2);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String getHostName(HttpMessage httpMessage) throws URIException {
        return SessionStructure.getHostName(httpMessage.getRequestHeader().getURI());
    }

    public static String getHostName(URI uRI) throws URIException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = uRI.getScheme().toLowerCase();
        stringBuilder.append(string).append("://").append(uRI.getHost());
        int n = uRI.getPort();
        if (n != -1 && (n == 80 && !"http".equals(string) || n == 443 && !"https".equals(string) || n != 80 && n != 443)) {
            stringBuilder.append(":").append(n);
        }
        return stringBuilder.toString();
    }

    private static String getParams(Session session, HttpMessage httpMessage) throws URIException {
        String string = null;
        if (httpMessage.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
            String string2 = httpMessage.getRequestHeader().getHeader("Content-Type");
            string = string2 != null && string2.startsWith("multipart/form-data") ? "(multipart/form-data)" : httpMessage.getRequestBody().toString();
        }
        return SessionStructure.getParams(session, httpMessage.getRequestHeader().getURI(), string);
    }

    private static String getParams(Session session, URI uRI, String string) throws URIException {
        String string2 = "";
        String string3 = "";
        try {
            string3 = uRI.getQuery();
        }
        catch (URIException uRIException) {
            log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
        }
        if (string3 == null) {
            string3 = "";
        }
        string2 = string2 + SessionStructure.getQueryParamString(session.getUrlParams(uRI));
        string3 = "";
        if (string != null && string.length() > 0) {
            string2 = string.equals("multipart/form-data") ? string2 + "(multipart/form-data)" : string2 + SessionStructure.getQueryParamString(session.getFormParams(uRI, string));
        }
        return string2;
    }

    private static String getQueryParamString(Map<String, String> map) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            treeSet.add(entry.getKey());
        }
        return SessionStructure.getQueryParamString(treeSet);
    }

    private static String getQueryParamString(SortedSet<String> sortedSet) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = sortedSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string != null) {
                if (n > 0) {
                    stringBuilder.append(',');
                }
                if (string.length() > 40) {
                    string = string.substring(0, 40);
                }
                stringBuilder.append(string);
            }
            ++n;
        }
        String string = "";
        if (stringBuilder.length() > 0) {
            string = stringBuilder.insert(0, '(').append(')').toString();
        }
        return string;
    }
}

