/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.IPolyExpression;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.ExceptionInferenceFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public class LambdaExpression
extends FunctionalExpression
implements IPolyExpression,
ReferenceContext,
ProblemSeverities {
    public Argument[] arguments;
    private TypeBinding[] argumentTypes;
    public int arrowPosition;
    public Statement body;
    public boolean hasParentheses;
    public MethodScope scope;
    boolean voidCompatible = true;
    boolean valueCompatible = false;
    boolean returnsValue;
    private boolean requiresGenericSignature;
    boolean returnsVoid;
    public LambdaExpression original = this;
    public SyntheticArgumentBinding[] outerLocalVariables = NO_SYNTHETIC_ARGUMENTS;
    private int outerLocalVariablesSlotSize = 0;
    private boolean assistNode = false;
    private boolean hasIgnoredMandatoryErrors = false;
    private ReferenceBinding classType;
    public int ordinal;
    private Set thrownExceptions;
    public char[] text;
    private static final SyntheticArgumentBinding[] NO_SYNTHETIC_ARGUMENTS = new SyntheticArgumentBinding[0];
    private static final Block NO_BODY = new Block(0);
    private HashMap<TypeBinding, LambdaExpression> copiesPerTargetType;
    protected Expression[] resultExpressions = NO_EXPRESSIONS;
    public InferenceContext18 inferenceContext;

    public LambdaExpression(CompilationResult compilationResult, boolean bl, boolean bl2) {
        super(compilationResult);
        this.assistNode = bl;
        this.requiresGenericSignature = bl2;
        this.setArguments(NO_ARGUMENTS);
        this.setBody(NO_BODY);
    }

    public LambdaExpression(CompilationResult compilationResult, boolean bl) {
        this(compilationResult, bl, false);
    }

    public void setArguments(Argument[] argumentArray) {
        this.arguments = argumentArray != null ? argumentArray : ASTNode.NO_ARGUMENTS;
        this.argumentTypes = new TypeBinding[argumentArray != null ? argumentArray.length : 0];
    }

    public Argument[] arguments() {
        return this.arguments;
    }

    public TypeBinding[] argumentTypes() {
        return this.argumentTypes;
    }

    public void setBody(Statement statement) {
        this.body = statement == null ? NO_BODY : statement;
    }

    public Statement body() {
        return this.body;
    }

    public Expression[] resultExpressions() {
        return this.resultExpressions;
    }

    public void setArrowPosition(int n) {
        this.arrowPosition = n;
    }

    public int arrowPosition() {
        return this.arrowPosition;
    }

    protected FunctionalExpression original() {
        return this.original;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n;
        int n2;
        this.binding.modifiers = this.shouldCaptureInstance ? (this.binding.modifiers &= 0xFFFFFFF7) : (this.binding.modifiers |= 8);
        SourceTypeBinding sourceTypeBinding = blockScope.enclosingSourceType();
        boolean bl2 = !(this.binding instanceof SyntheticMethodBinding);
        this.binding = sourceTypeBinding.addSyntheticMethod(this);
        int n3 = codeStream.position;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        if (this.shouldCaptureInstance) {
            codeStream.aload_0();
            stringBuffer.append(sourceTypeBinding.signature());
        }
        int n4 = n2 = this.outerLocalVariables == null ? 0 : this.outerLocalVariables.length;
        for (n = 0; n < n2; ++n) {
            SyntheticArgumentBinding syntheticArgumentBinding = this.outerLocalVariables[n];
            if (this.shouldCaptureInstance && bl2) {
                ++syntheticArgumentBinding.resolvedPosition;
            }
            stringBuffer.append(syntheticArgumentBinding.type.signature());
            LocalVariableBinding localVariableBinding = syntheticArgumentBinding.actualOuterLocalVariable;
            Object[] objectArray = blockScope.getEmulationPath(localVariableBinding);
            codeStream.generateOuterAccess(objectArray, this, localVariableBinding, blockScope);
        }
        stringBuffer.append(')');
        if (this.expectedType instanceof IntersectionTypeBinding18) {
            stringBuffer.append(((IntersectionTypeBinding18)this.expectedType).getSAMType(blockScope).signature());
        } else {
            stringBuffer.append(this.expectedType.signature());
        }
        n = codeStream.classFile.recordBootstrapMethod(this);
        codeStream.invokeDynamic(n, (this.shouldCaptureInstance ? 1 : 0) + this.outerLocalVariablesSlotSize, 1, this.descriptor.selector, stringBuffer.toString().toCharArray());
        if (!bl) {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n3, this.sourceStart);
    }

    @Override
    public boolean kosherDescriptor(Scope scope, MethodBinding methodBinding, boolean bl) {
        if (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES) {
            if (bl) {
                scope.problemReporter().lambdaExpressionCannotImplementGenericMethod(this, methodBinding);
            }
            return false;
        }
        return super.kosherDescriptor(scope, methodBinding, bl);
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope, boolean bl) {
        Object object2;
        TypeBinding typeBinding;
        Object object3;
        int n;
        int n2;
        boolean bl2;
        int n3;
        boolean bl3 = this.argumentsTypeElided();
        int n4 = n3 = this.arguments == null ? 0 : this.arguments.length;
        if (this.constant != Constant.NotAConstant) {
            this.constant = Constant.NotAConstant;
            this.enclosingScope = blockScope;
            if (this.original == this) {
                this.ordinal = this.recordFunctionalType(blockScope);
            }
            if (!bl3) {
                for (int i = 0; i < n3; ++i) {
                    this.argumentTypes[i] = this.arguments[i].type.resolveType(blockScope, true);
                }
            }
            if (this.expectedType == null && this.expressionContext == ExpressionContext.INVOCATION_CONTEXT) {
                return new PolyTypeBinding(this);
            }
        }
        MethodScope methodScope = blockScope.methodScope();
        this.scope = new MethodScope(blockScope, this, methodScope.isStatic, methodScope.lastVisibleFieldID);
        this.scope.isConstructorCall = methodScope.isConstructorCall;
        super.resolveType(blockScope, bl);
        boolean bl4 = bl2 = this.descriptor != null;
        if (!(bl || bl2 && this.descriptor.typeVariables == Binding.NO_TYPE_VARIABLES)) {
            this.resolvedType = null;
            return null;
        }
        this.binding = new MethodBinding(0x2001002, CharOperation.concat(TypeConstants.ANONYMOUS_METHOD, Integer.toString(this.ordinal).toCharArray()), bl2 ? this.descriptor.returnType : TypeBinding.VOID, Binding.NO_PARAMETERS, bl2 ? this.descriptor.thrownExceptions : Binding.NO_EXCEPTIONS, blockScope.enclosingSourceType());
        this.binding.typeVariables = Binding.NO_TYPE_VARIABLES;
        boolean bl5 = false;
        if (bl2 && (n2 = this.descriptor.parameters.length) != n3) {
            this.scope.problemReporter().lambdaSignatureMismatched(this);
            if (bl3 || this.original != this) {
                this.resolvedType = null;
                return null;
            }
            this.resolvedType = null;
            bl5 = true;
        }
        TypeBinding[] typeBindingArray = new TypeBinding[n3];
        AnnotationBinding[][] annotationBindingArray = null;
        for (n = 0; n < n3; ++n) {
            object3 = this.arguments[n];
            if (((Argument)object3).isVarArgs()) {
                if (n == n3 - 1) {
                    this.binding.modifiers |= 0x80;
                } else {
                    this.scope.problemReporter().illegalVarargInLambda((Argument)object3);
                    bl5 = true;
                }
            }
            typeBinding = bl2 && n < this.descriptor.parameters.length ? this.descriptor.parameters[n] : null;
            Object object = object2 = bl3 ? typeBinding : this.argumentTypes[n];
            if (object2 == null) {
                bl5 = true;
                continue;
            }
            if (object2 == TypeBinding.VOID) {
                this.scope.problemReporter().argumentTypeCannotBeVoid(this, (Argument)object3);
                bl5 = true;
                continue;
            }
            if (!((Binding)object2).isValidBinding()) {
                this.binding.tagBits |= 0x200L;
            }
            if ((((TypeBinding)object2).tagBits & 0x80L) == 0L) continue;
            this.binding.tagBits |= 0x80L;
        }
        if (!bl3 && !bl5) {
            ReferenceBinding referenceBinding = null;
            object3 = null;
            if (this.expectedType instanceof IntersectionTypeBinding18) {
                object3 = (ReferenceBinding)((IntersectionTypeBinding18)this.expectedType).getSAMType(blockScope);
            } else if (this.expectedType instanceof ReferenceBinding) {
                object3 = (ReferenceBinding)this.expectedType;
            }
            if (object3 != null) {
                referenceBinding = this.findGroundTargetType(blockScope, (TypeBinding)object3, bl3);
            }
            if (referenceBinding != null) {
                this.descriptor = referenceBinding.getSingleAbstractMethod(blockScope, true);
                if (!this.descriptor.isValidBinding()) {
                    this.reportSamProblem(blockScope, this.descriptor);
                } else {
                    if (referenceBinding != object3 && !referenceBinding.isCompatibleWith((TypeBinding)object3, this.scope)) {
                        blockScope.problemReporter().typeMismatchError((TypeBinding)referenceBinding, this.expectedType, this, null);
                        this.resolvedType = null;
                        return null;
                    }
                    this.resolvedType = referenceBinding;
                }
            }
        }
        n = this.requiresGenericSignature || blockScope.compilerOptions().generateGenericSignatureForLambdaExpressions ? 1 : 0;
        for (int i = 0; i < n3; ++i) {
            TypeBinding typeBinding2;
            object2 = this.arguments[i];
            TypeBinding object5 = bl2 && i < this.descriptor.parameters.length ? this.descriptor.parameters[i] : null;
            TypeBinding typeBinding3 = typeBinding = bl3 ? object5 : this.argumentTypes[i];
            if (typeBinding == null || typeBinding == TypeBinding.VOID) continue;
            if (bl2 && object5 != null && typeBinding.isValidBinding() && TypeBinding.notEquals(typeBinding, object5) && object5.isProperType(true)) {
                this.scope.problemReporter().lambdaParameterTypeMismatched((Argument)object2, ((Argument)object2).type, object5);
                this.resolvedType = null;
            }
            if (n != 0 && (typeBinding2 = typeBinding.leafComponentType()) instanceof ReferenceBinding && (((ReferenceBinding)typeBinding2).modifiers & 0x40000000) != 0) {
                this.binding.modifiers |= 0x40000000;
            }
            typeBindingArray[i] = ((Argument)object2).bind(this.scope, typeBinding, false);
            if (((Argument)object2).annotations != null) {
                this.binding.tagBits |= 0x400L;
                if (annotationBindingArray == null) {
                    annotationBindingArray = new AnnotationBinding[n3][];
                    for (int j = 0; j < i; ++j) {
                        annotationBindingArray[j] = Binding.NO_ANNOTATIONS;
                    }
                }
                annotationBindingArray[i] = ((Argument)object2).binding.getAnnotations();
                continue;
            }
            if (annotationBindingArray == null) continue;
            annotationBindingArray[i] = Binding.NO_ANNOTATIONS;
        }
        if (!bl5) {
            this.binding.parameters = typeBindingArray;
            if (annotationBindingArray != null) {
                this.binding.setParameterAnnotations(annotationBindingArray);
            }
        }
        if (!bl3 && !bl5 && this.binding.isVarargs() && !this.binding.parameters[this.binding.parameters.length - 1].isReifiable()) {
            this.scope.problemReporter().possibleHeapPollutionFromVararg(this.arguments[this.arguments.length - 1]);
        }
        for (ReferenceBinding referenceBinding : this.binding.thrownExceptions) {
            if ((referenceBinding.tagBits & 0x80L) != 0L) {
                this.binding.tagBits |= 0x80L;
            }
            if (n == 0) continue;
            this.binding.modifiers |= referenceBinding.modifiers & 0x40000000;
        }
        TypeBinding typeBinding4 = this.binding.returnType;
        if (typeBinding4 != null) {
            TypeBinding typeBinding5;
            if ((typeBinding4.tagBits & 0x80L) != 0L) {
                this.binding.tagBits |= 0x80L;
            }
            if (n != 0 && (typeBinding5 = typeBinding4.leafComponentType()) instanceof ReferenceBinding && (((ReferenceBinding)typeBinding5).modifiers & 0x40000000) != 0) {
                this.binding.modifiers |= 0x40000000;
            }
        }
        if (bl2 && !bl5 && blockScope.compilerOptions().isAnnotationBasedNullAnalysisEnabled) {
            if (!bl3) {
                AbstractMethodDeclaration.createArgumentBindings(this.arguments, this.binding, this.scope);
                this.mergeParameterNullAnnotations(blockScope);
            }
            this.binding.tagBits |= this.descriptor.tagBits & 0x180000000000000L;
        }
        this.binding.modifiers &= 0xFDFFFFFF;
        if (this.body instanceof Expression) {
            Expression expression = (Expression)this.body;
            new ReturnStatement(expression, expression.sourceStart, expression.sourceEnd, true).resolve(this.scope);
            if (expression.resolvedType == TypeBinding.VOID && !expression.statementExpression()) {
                this.scope.problemReporter().invalidExpressionAsStatement(expression);
            }
        } else {
            this.body.resolve(this.scope);
            if (!this.returnsVoid && !this.returnsValue) {
                this.valueCompatible = this.body.doesNotCompleteNormally();
            }
        }
        if ((this.binding.tagBits & 0x80L) != 0L) {
            this.scope.problemReporter().missingTypeInLambda(this, this.binding);
        }
        if (this.shouldCaptureInstance && this.scope.isConstructorCall) {
            this.scope.problemReporter().fieldsOrThisBeforeConstructorInvocation(this);
        }
        return bl5 ? (this.resolvedType = null) : this.resolvedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReferenceBinding findGroundTargetType(BlockScope blockScope, TypeBinding typeBinding, boolean bl) {
        if (typeBinding instanceof IntersectionTypeBinding18) {
            typeBinding = ((IntersectionTypeBinding18)typeBinding).getSAMType(blockScope);
        }
        if (typeBinding instanceof ReferenceBinding && typeBinding.isValidBinding()) {
            ParameterizedTypeBinding parameterizedTypeBinding = InferenceContext18.parameterizedWithWildcard(typeBinding);
            if (parameterizedTypeBinding != null) {
                if (!bl) {
                    InferenceContext18 inferenceContext18 = new InferenceContext18(blockScope);
                    try {
                        ReferenceBinding referenceBinding = inferenceContext18.inferFunctionalInterfaceParameterization(this, blockScope, parameterizedTypeBinding);
                        return referenceBinding;
                    }
                    finally {
                        inferenceContext18.cleanUp();
                    }
                }
                return this.findGroundTargetTypeForElidedLambda(blockScope, parameterizedTypeBinding);
            }
            return (ReferenceBinding)typeBinding;
        }
        return null;
    }

    public ReferenceBinding findGroundTargetTypeForElidedLambda(BlockScope blockScope, ParameterizedTypeBinding parameterizedTypeBinding) {
        TypeBinding[] typeBindingArray = parameterizedTypeBinding.getNonWildcardParameterization(blockScope);
        if (typeBindingArray == null) {
            return null;
        }
        ReferenceBinding referenceBinding = parameterizedTypeBinding.genericType();
        return blockScope.environment().createParameterizedType(referenceBinding, typeBindingArray, parameterizedTypeBinding.enclosingType());
    }

    @Override
    public boolean argumentsTypeElided() {
        return this.arguments.length > 0 && this.arguments[0].hasElidedType();
    }

    private void analyzeExceptions() {
        try {
            ExceptionInferenceFlowContext exceptionInferenceFlowContext = new ExceptionInferenceFlowContext(null, this, Binding.NO_EXCEPTIONS, null, this.scope, FlowInfo.DEAD_END);
            this.body.analyseCode(this.scope, exceptionInferenceFlowContext, UnconditionalFlowInfo.fakeInitializedFlowInfo(this.scope.outerMostMethodScope().analysisIndex, this.scope.referenceType().maxFieldCount));
            this.thrownExceptions = exceptionInferenceFlowContext.extendedExceptions == null ? Collections.emptySet() : new HashSet(exceptionInferenceFlowContext.extendedExceptions);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return flowInfo;
        }
        FlowInfo flowInfo2 = flowInfo.copy();
        ExceptionHandlingFlowContext exceptionHandlingFlowContext = new ExceptionHandlingFlowContext(flowContext, this, this.binding.thrownExceptions, flowContext.getInitializationContext(), this.scope, FlowInfo.DEAD_END);
        MethodBinding methodBinding = this.argumentsTypeElided() ? this.descriptor : this.binding;
        AbstractMethodDeclaration.analyseArguments(blockScope.environment(), flowInfo2, this.arguments, methodBinding);
        if (this.arguments != null) {
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                this.bits |= this.arguments[i].bits & 0x100000;
            }
        }
        flowInfo2 = this.body.analyseCode(this.scope, exceptionHandlingFlowContext, flowInfo2);
        if (this.body instanceof Block) {
            TypeBinding typeBinding = this.expectedResultType();
            if (typeBinding == TypeBinding.VOID) {
                if ((flowInfo2.tagBits & 1) == 0 || ((Block)this.body).statements == null) {
                    this.bits |= 0x40;
                }
            } else if (flowInfo2 != FlowInfo.DEAD_END) {
                this.scope.problemReporter().shouldReturn(typeBinding, this);
            }
        } else if (blockScope.compilerOptions().isAnnotationBasedNullAnalysisEnabled && flowInfo2.reachMode() == 0) {
            Expression expression = (Expression)this.body;
            this.checkAgainstNullAnnotation(flowContext, expression, flowInfo, expression.nullStatus(flowInfo2, flowContext));
        }
        return flowInfo;
    }

    void validateNullAnnotations() {
        if (this.binding != null) {
            int n = this.binding.parameters.length;
            for (int i = 0; i < n; ++i) {
                if (this.scope.validateNullAnnotation(this.binding.returnType.tagBits, this.arguments[i].type, this.arguments[i].annotations)) continue;
                this.binding.returnType = this.binding.returnType.withoutToplevelNullAnnotation();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mergeParameterNullAnnotations(BlockScope blockScope) {
        LookupEnvironment lookupEnvironment = blockScope.environment();
        TypeBinding[] typeBindingArray = this.binding.parameters;
        TypeBinding[] typeBindingArray2 = this.descriptor.parameters;
        int n = Math.min(typeBindingArray.length, typeBindingArray2.length);
        for (int i = 0; i < n; ++i) {
            void var11_13;
            long l = typeBindingArray[i].tagBits & 0x180000000000000L;
            long l2 = typeBindingArray2[i].tagBits & 0x180000000000000L;
            if (l == 0L) {
                if (l2 == 0L || typeBindingArray[i].isBaseType()) continue;
                for (AnnotationBinding annotationBinding : typeBindingArray2[i].getTypeAnnotations()) {
                    if (annotationBinding == null || !annotationBinding.getAnnotationType().hasNullBit(96)) continue;
                    typeBindingArray[i] = lookupEnvironment.createAnnotatedType(typeBindingArray[i], new AnnotationBinding[]{annotationBinding});
                }
                continue;
            }
            if (l == l2 || l != 0x100000000000000L) continue;
            char[][] cArray = null;
            if (l2 == 0x80000000000000L) {
                char[][] cArray2 = lookupEnvironment.getNullableAnnotationName();
            }
            blockScope.problemReporter().illegalRedefinitionToNonNullParameter(this.arguments[i], this.descriptor.declaringClass, (char[][])var11_13);
        }
    }

    void checkAgainstNullAnnotation(FlowContext flowContext, Expression expression, FlowInfo flowInfo, int n) {
        if (n != 4 && (this.descriptor.returnType.tagBits & 0x100000000000000L) != 0L) {
            flowContext.recordNullityMismatch(this.scope, expression, expression.resolvedType, this.descriptor.returnType, flowInfo, n, null);
        }
    }

    @Override
    public boolean isPertinentToApplicability(final TypeBinding typeBinding, final MethodBinding methodBinding) {
        if (typeBinding == null) {
            return true;
        }
        if (this.argumentsTypeElided()) {
            return false;
        }
        if (!super.isPertinentToApplicability(typeBinding, methodBinding)) {
            return false;
        }
        if (this.body instanceof Expression) {
            if (!((Expression)this.body).isPertinentToApplicability(typeBinding, methodBinding)) {
                return false;
            }
        } else {
            Expression[] expressionArray = this.resultExpressions;
            if (expressionArray != NO_EXPRESSIONS) {
                int n = expressionArray.length;
                for (int i = 0; i < n; ++i) {
                    if (expressionArray[i].isPertinentToApplicability(typeBinding, methodBinding)) continue;
                    return false;
                }
            } else {
                class NotPertientToApplicability
                extends RuntimeException {
                    private static final long serialVersionUID = 1L;

                    NotPertientToApplicability() {
                    }
                }
                try {
                    class ResultsAnalyser
                    extends ASTVisitor {
                        ResultsAnalyser() {
                        }

                        @Override
                        public boolean visit(TypeDeclaration typeDeclaration, BlockScope blockScope) {
                            return false;
                        }

                        @Override
                        public boolean visit(TypeDeclaration typeDeclaration, ClassScope classScope) {
                            return false;
                        }

                        @Override
                        public boolean visit(LambdaExpression lambdaExpression, BlockScope blockScope) {
                            return false;
                        }

                        @Override
                        public boolean visit(ReturnStatement returnStatement, BlockScope blockScope) {
                            if (returnStatement.expression != null && !returnStatement.expression.isPertinentToApplicability(typeBinding, methodBinding)) {
                                throw new NotPertientToApplicability();
                            }
                            return false;
                        }
                    }
                    this.body.traverse(new ResultsAnalyser(), this.scope);
                }
                catch (NotPertientToApplicability notPertientToApplicability) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isVoidCompatible() {
        return this.voidCompatible;
    }

    public boolean isValueCompatible() {
        return this.valueCompatible;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        return this.printExpression(n, stringBuffer, false);
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer, boolean bl) {
        int n2;
        int n3 = (this.bits & 0x1FE00000) >> 21;
        String string = "";
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append('(');
            string = string + ')';
        }
        stringBuffer.append('(');
        if (this.arguments != null) {
            for (n2 = 0; n2 < this.arguments.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].print(0, stringBuffer);
            }
        }
        stringBuffer.append(") -> ");
        if (bl) {
            stringBuffer.append("{}");
        } else if (this.body != null) {
            this.body.print(this.body instanceof Block ? n : 0, stringBuffer);
        } else {
            stringBuffer.append("<@incubator>");
        }
        return stringBuffer.append(string);
    }

    public TypeBinding expectedResultType() {
        return this.descriptor != null && this.descriptor.isValidBinding() ? this.descriptor.returnType : null;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.arguments != null) {
                int n = this.arguments.length;
                for (int i = 0; i < n; ++i) {
                    this.arguments[i].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.body != null) {
                this.body.traverse(aSTVisitor, this.scope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public MethodScope getScope() {
        return this.scope;
    }

    private boolean enclosingScopesHaveErrors() {
        Scope scope = this.enclosingScope;
        while (scope != null) {
            ReferenceContext referenceContext = scope.referenceContext();
            if (referenceContext != null && referenceContext.hasErrors()) {
                return true;
            }
            scope = scope.parent;
        }
        return false;
    }

    private void analyzeShape() {
        if (this.body instanceof Expression) {
            this.voidCompatible = this.assistNode ? true : ((Expression)this.body).statementExpression();
            this.valueCompatible = true;
        } else {
            if (this.assistNode) {
                this.voidCompatible = true;
                this.valueCompatible = true;
            }
            class ShapeComputer
            extends ASTVisitor {
                ShapeComputer() {
                }

                @Override
                public boolean visit(TypeDeclaration typeDeclaration, BlockScope blockScope) {
                    return false;
                }

                @Override
                public boolean visit(TypeDeclaration typeDeclaration, ClassScope classScope) {
                    return false;
                }

                @Override
                public boolean visit(LambdaExpression lambdaExpression, BlockScope blockScope) {
                    return false;
                }

                @Override
                public boolean visit(ReturnStatement returnStatement, BlockScope blockScope) {
                    if (returnStatement.expression != null) {
                        LambdaExpression.this.valueCompatible = true;
                        LambdaExpression.this.voidCompatible = false;
                        LambdaExpression.this.returnsValue = true;
                    } else {
                        LambdaExpression.this.voidCompatible = true;
                        LambdaExpression.this.valueCompatible = false;
                        LambdaExpression.this.returnsVoid = true;
                    }
                    return false;
                }
            }
            this.body.traverse(new ShapeComputer(), null);
            if (!this.returnsValue && !this.returnsVoid) {
                this.valueCompatible = this.body.doesNotCompleteNormally();
            }
        }
    }

    @Override
    public boolean isPotentiallyCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (!super.isPertinentToApplicability(typeBinding, null)) {
            return true;
        }
        MethodBinding methodBinding = typeBinding.getSingleAbstractMethod(scope, true);
        if (methodBinding == null || !methodBinding.isValidBinding()) {
            return false;
        }
        if (methodBinding.parameters.length != this.arguments.length) {
            return false;
        }
        this.analyzeShape();
        return !(methodBinding.returnType.id == 6 ? !this.voidCompatible : !this.valueCompatible);
    }

    @Override
    public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (!super.isPertinentToApplicability(typeBinding, null)) {
            return true;
        }
        LambdaExpression lambdaExpression = null;
        try {
            lambdaExpression = this.cachedResolvedCopy(typeBinding, this.argumentsTypeElided(), false, null);
        }
        catch (CopyFailureException copyFailureException) {
            if (this.assistNode) {
                return true;
            }
            return !this.isPertinentToApplicability(typeBinding, null);
        }
        if (lambdaExpression == null) {
            return false;
        }
        MethodBinding methodBinding = (typeBinding = this.findGroundTargetType(this.enclosingScope, typeBinding, this.argumentsTypeElided())).getSingleAbstractMethod(this.enclosingScope, true);
        if (methodBinding == null || methodBinding.problemId() == 17) {
            return false;
        }
        if (methodBinding.returnType.id == 6 ? !lambdaExpression.voidCompatible : !lambdaExpression.valueCompatible) {
            return false;
        }
        if (!this.isPertinentToApplicability(typeBinding, null)) {
            return true;
        }
        if (!this.kosherDescriptor(this.enclosingScope, methodBinding, false)) {
            return false;
        }
        Expression[] expressionArray = lambdaExpression.resultExpressions;
        int n = expressionArray.length;
        for (int i = 0; i < n; ++i) {
            if (this.enclosingScope.parameterCompatibilityLevel(expressionArray[i].resolvedType, methodBinding.returnType) != -1 || expressionArray[i].isConstantValueOfTypeAssignableToType(expressionArray[i].resolvedType, methodBinding.returnType) || methodBinding.returnType.id == 6 && !(this.body instanceof Block)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LambdaExpression cachedResolvedCopy(TypeBinding typeBinding, boolean bl, boolean bl2, InferenceContext18 inferenceContext18) {
        if ((typeBinding = this.findGroundTargetType(this.enclosingScope, typeBinding, this.argumentsTypeElided())) == null) {
            return null;
        }
        MethodBinding methodBinding = typeBinding.getSingleAbstractMethod(this.enclosingScope, true);
        if (methodBinding == null || !methodBinding.isValidBinding()) {
            return null;
        }
        if (methodBinding.parameters.length != this.arguments.length) {
            return null;
        }
        LambdaExpression lambdaExpression = null;
        if (this.copiesPerTargetType != null && (lambdaExpression = this.copiesPerTargetType.get(typeBinding)) == null && bl && this.copiesPerTargetType.values().size() > 0) {
            lambdaExpression = this.copiesPerTargetType.values().iterator().next();
        }
        IErrorHandlingPolicy iErrorHandlingPolicy = this.enclosingScope.problemReporter().switchErrorHandlingPolicy(silentErrorHandlingPolicy);
        try {
            Object object;
            if (lambdaExpression == null) {
                lambdaExpression = this.copy();
                if (lambdaExpression == null) {
                    throw new CopyFailureException();
                }
                lambdaExpression.setExpressionContext(this.expressionContext);
                lambdaExpression.setExpectedType(typeBinding);
                lambdaExpression.inferenceContext = inferenceContext18;
                object = lambdaExpression.resolveType(this.enclosingScope, true);
                if (object == null || !((Binding)object).isValidBinding()) {
                    LambdaExpression lambdaExpression2 = null;
                    return lambdaExpression2;
                }
                if (this.copiesPerTargetType == null) {
                    this.copiesPerTargetType = new HashMap();
                }
                this.copiesPerTargetType.put(typeBinding, lambdaExpression);
            }
            if (!bl2) {
                object = lambdaExpression;
                return object;
            }
            if (lambdaExpression.thrownExceptions == null && !lambdaExpression.hasIgnoredMandatoryErrors && !this.enclosingScopesHaveErrors()) {
                lambdaExpression.analyzeExceptions();
            }
            object = lambdaExpression;
            return object;
        }
        finally {
            this.enclosingScope.problemReporter().switchErrorHandlingPolicy(iErrorHandlingPolicy);
        }
    }

    @Override
    public LambdaExpression resolveExpressionExpecting(TypeBinding typeBinding, Scope scope, InferenceContext18 inferenceContext18) {
        LambdaExpression lambdaExpression = null;
        try {
            lambdaExpression = this.cachedResolvedCopy(typeBinding, false, true, inferenceContext18);
        }
        catch (CopyFailureException copyFailureException) {
            return null;
        }
        return lambdaExpression;
    }

    @Override
    public boolean sIsMoreSpecific(TypeBinding typeBinding, TypeBinding typeBinding2, Scope scope) {
        int n;
        if (super.sIsMoreSpecific(typeBinding, typeBinding2, scope)) {
            return true;
        }
        if (this.argumentsTypeElided() || typeBinding2.findSuperTypeOriginatingFrom(typeBinding) != null) {
            return false;
        }
        MethodBinding methodBinding = (typeBinding = typeBinding.capture(this.enclosingScope, this.sourceStart, this.sourceEnd)).getSingleAbstractMethod(this.enclosingScope, true);
        if (methodBinding == null || !methodBinding.isValidBinding()) {
            return false;
        }
        TypeBinding typeBinding3 = methodBinding.returnType;
        MethodBinding methodBinding2 = typeBinding2.getSingleAbstractMethod(this.enclosingScope, true);
        if (methodBinding2 == null || !methodBinding2.isValidBinding()) {
            return true;
        }
        TypeBinding typeBinding4 = methodBinding2.returnType;
        if (typeBinding4.id == 6) {
            return true;
        }
        if (typeBinding3.id == 6) {
            return false;
        }
        if (typeBinding3.isCompatibleWith(typeBinding4, scope)) {
            return true;
        }
        LambdaExpression lambdaExpression = this.cachedResolvedCopy(typeBinding, true, false, null);
        Expression[] expressionArray = lambdaExpression.resultExpressions;
        int n2 = n = expressionArray == null ? 0 : expressionArray.length;
        if (n > 0) {
            int n3;
            if (typeBinding3.isBaseType() && !typeBinding4.isBaseType()) {
                for (n3 = 0; n3 < n && !expressionArray[n3].isPolyExpression() && expressionArray[n3].resolvedType.isBaseType(); ++n3) {
                }
                if (n3 == n) {
                    return true;
                }
            }
            if (!typeBinding3.isBaseType() && typeBinding4.isBaseType()) {
                for (n3 = 0; n3 < n && !expressionArray[n3].resolvedType.isBaseType(); ++n3) {
                }
                if (n3 == n) {
                    return true;
                }
            }
            if (typeBinding3.isFunctionalInterface(this.enclosingScope) && typeBinding4.isFunctionalInterface(this.enclosingScope)) {
                Expression expression;
                for (n3 = 0; n3 < n && (expression = expressionArray[n3]).sIsMoreSpecific(typeBinding3, typeBinding4, scope); ++n3) {
                }
                if (n3 == n) {
                    return true;
                }
            }
        }
        return false;
    }

    LambdaExpression copy() {
        ICompilationUnit iCompilationUnit;
        char[] cArray;
        Parser parser = new Parser(this.enclosingScope.problemReporter(), false);
        LambdaExpression lambdaExpression = (LambdaExpression)parser.parseLambdaExpression(cArray = (iCompilationUnit = this.compilationResult.getCompilationUnit()) != null ? iCompilationUnit.getContents() : this.text, iCompilationUnit != null ? this.sourceStart : 0, this.sourceEnd - this.sourceStart + 1, this.enclosingScope.referenceCompilationUnit(), false);
        if (lambdaExpression != null) {
            lambdaExpression.original = this;
            lambdaExpression.assistNode = this.assistNode;
            lambdaExpression.enclosingScope = this.enclosingScope;
        }
        return lambdaExpression;
    }

    public void returnsExpression(Expression expression, TypeBinding typeBinding) {
        if (this.original == this) {
            return;
        }
        if (this.body instanceof Expression) {
            this.valueCompatible = typeBinding == null || typeBinding.id != 6;
            this.voidCompatible = this.assistNode ? true : ((Expression)this.body).statementExpression();
            this.resultExpressions = new Expression[]{expression};
            return;
        }
        if (expression != null) {
            this.returnsValue = true;
            this.voidCompatible = false;
            this.valueCompatible = !this.returnsVoid;
            Expression[] expressionArray = this.resultExpressions;
            int n = expressionArray.length;
            Expression[] expressionArray2 = expressionArray;
            expressionArray = new Expression[n + 1];
            System.arraycopy(expressionArray2, 0, expressionArray, 0, n);
            expressionArray[n] = expression;
            this.resultExpressions = expressionArray;
        } else {
            this.returnsVoid = true;
            this.valueCompatible = false;
            this.voidCompatible = !this.returnsValue;
        }
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    @Override
    public void abort(int n, CategorizedProblem categorizedProblem) {
        switch (n) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, categorizedProblem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, categorizedProblem);
            }
            case 8: {
                throw new AbortType(this.compilationResult, categorizedProblem);
            }
        }
        throw new AbortMethod(this.compilationResult, categorizedProblem);
    }

    @Override
    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        return this.enclosingScope == null ? null : this.enclosingScope.compilationUnitScope().referenceContext;
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    @Override
    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
        Scope scope = this.enclosingScope.parent;
        while (scope != null) {
            switch (scope.kind) {
                case 2: 
                case 3: {
                    ReferenceContext referenceContext = scope.referenceContext();
                    if (referenceContext == this) break;
                    referenceContext.tagAsHavingErrors();
                    return;
                }
            }
            scope = scope.parent;
        }
    }

    @Override
    public void tagAsHavingIgnoredMandatoryErrors(int n) {
        MethodScope methodScope;
        switch (n) {
            case 16777362: 
            case 16777384: 
            case 16778098: {
                return;
            }
            case 99: 
            case 0x1000013: 
            case 67108969: 
            case 0x4000303: 
            case 553648781: 
            case 553648783: 
            case 553648784: 
            case 553648785: 
            case 553648786: 
            case 553648787: 
            case 603979884: {
                return;
            }
        }
        this.hasIgnoredMandatoryErrors = true;
        MethodScope methodScope2 = methodScope = this.scope == null ? null : this.scope.enclosingLambdaScope();
        while (methodScope != null) {
            LambdaExpression lambdaExpression = (LambdaExpression)methodScope.referenceContext;
            lambdaExpression.hasIgnoredMandatoryErrors = true;
            methodScope = methodScope.enclosingLambdaScope();
        }
    }

    public Set<TypeBinding> getThrownExceptions() {
        if (this.thrownExceptions == null) {
            return Collections.emptySet();
        }
        return this.thrownExceptions;
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int n = 0;
        classFile.codeStream.wideMode = false;
        boolean bl = false;
        do {
            try {
                n = classFile.contentsOffset;
                this.generateCode(classFile);
                bl = false;
            }
            catch (AbortMethod abortMethod) {
                if (abortMethod.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.resetInWideMode();
                    bl = true;
                    continue;
                }
                if (abortMethod.compilationResult == CodeStream.RESTART_CODE_GEN_FOR_UNUSED_LOCALS_MODE) {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.resetForCodeGenUnusedLocals();
                    bl = true;
                    continue;
                }
                throw new AbortType(this.compilationResult, abortMethod.problem);
            }
        } while (bl);
    }

    public void generateCode(ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int n = classFile.contentsOffset;
        int n2 = classFile.generateMethodInfoAttributes(this.binding);
        int n3 = classFile.contentsOffset;
        classFile.generateCodeAttributeHeader();
        CodeStream codeStream = classFile.codeStream;
        codeStream.reset(this, classFile);
        this.scope.computeLocalVariablePositions(this.outerLocalVariablesSlotSize + (this.binding.isStatic() ? 0 : 1), codeStream);
        if (this.outerLocalVariables != null) {
            for (SyntheticArgumentBinding localVariableBinding : this.outerLocalVariables) {
                codeStream.addVisibleLocalVariable(localVariableBinding);
                codeStream.record(localVariableBinding);
                localVariableBinding.recordInitializationStartPC(0);
            }
        }
        if (this.arguments != null) {
            int n4 = this.arguments.length;
            for (int i = 0; i < n4; ++i) {
                LocalVariableBinding localVariableBinding = this.arguments[i].binding;
                codeStream.addVisibleLocalVariable(localVariableBinding);
                localVariableBinding.recordInitializationStartPC(0);
            }
        }
        if (this.body instanceof Block) {
            this.body.generateCode(this.scope, codeStream);
            if ((this.bits & 0x40) != 0) {
                codeStream.return_();
            }
        } else {
            Expression expression = (Expression)this.body;
            expression.generateCode(this.scope, codeStream, true);
            if (this.binding.returnType == TypeBinding.VOID) {
                codeStream.return_();
            } else {
                codeStream.generateReturnBytecode(expression);
            }
        }
        codeStream.exitUserScope(this.scope);
        codeStream.recordPositionsFrom(0, this.sourceEnd);
        try {
            classFile.completeCodeAttribute(n3);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
        }
        classFile.completeMethodInfo(this.binding, n, ++n2);
    }

    public void addSyntheticArgument(LocalVariableBinding localVariableBinding) {
        int n;
        if (this.original != this || this.binding == null) {
            return;
        }
        SyntheticArgumentBinding syntheticArgumentBinding = null;
        int n2 = this.outerLocalVariables.length;
        for (n = 0; n < n2; ++n) {
            if (this.outerLocalVariables[n].actualOuterLocalVariable != localVariableBinding) continue;
            return;
        }
        this.outerLocalVariables = new SyntheticArgumentBinding[n2 + 1];
        System.arraycopy(this.outerLocalVariables, 0, this.outerLocalVariables, 0, n2);
        this.outerLocalVariables[n2] = syntheticArgumentBinding = new SyntheticArgumentBinding(localVariableBinding);
        syntheticArgumentBinding.resolvedPosition = this.outerLocalVariablesSlotSize;
        syntheticArgumentBinding.declaringScope = this.scope;
        n = this.binding.parameters.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n + 1];
        typeBindingArray[n2] = localVariableBinding.type;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            if (n3 == n2) {
                ++n4;
            }
            typeBindingArray[n4] = this.binding.parameters[n3];
            ++n3;
            ++n4;
        }
        this.binding.parameters = typeBindingArray;
        switch (syntheticArgumentBinding.type.id) {
            case 7: 
            case 8: {
                this.outerLocalVariablesSlotSize += 2;
                break;
            }
            default: {
                ++this.outerLocalVariablesSlotSize;
            }
        }
    }

    public SyntheticArgumentBinding getSyntheticArgument(LocalVariableBinding localVariableBinding) {
        int n;
        int n2 = n = this.outerLocalVariables == null ? 0 : this.outerLocalVariables.length;
        for (int i = 0; i < n; ++i) {
            if (this.outerLocalVariables[i].actualOuterLocalVariable != localVariableBinding) continue;
            return this.outerLocalVariables[i];
        }
        return null;
    }

    @Override
    public MethodBinding getMethodBinding() {
        if (this.actualMethodBinding == null) {
            if (this.binding != null) {
                TypeBinding[] typeBindingArray = null;
                if (this.binding instanceof SyntheticMethodBinding && this.outerLocalVariables.length > 0) {
                    typeBindingArray = new TypeBinding[this.binding.parameters.length - this.outerLocalVariables.length];
                    System.arraycopy(this.binding.parameters, this.outerLocalVariables.length, typeBindingArray, 0, typeBindingArray.length);
                } else {
                    typeBindingArray = this.binding.parameters;
                }
                this.actualMethodBinding = new MethodBinding(this.binding.modifiers, this.binding.selector, this.binding.returnType, typeBindingArray, this.binding.thrownExceptions, this.binding.declaringClass);
                this.actualMethodBinding.tagBits = this.binding.tagBits;
            } else {
                this.actualMethodBinding = new ProblemMethodBinding(CharOperation.NO_CHAR, null, 17);
            }
        }
        return this.actualMethodBinding;
    }

    @Override
    public int diagnosticsSourceEnd() {
        return this.body instanceof Block ? this.arrowPosition : this.sourceEnd;
    }

    public TypeBinding[] getMarkerInterfaces() {
        if (this.expectedType instanceof IntersectionTypeBinding18) {
            LinkedHashSet<ReferenceBinding> linkedHashSet = new LinkedHashSet<ReferenceBinding>();
            IntersectionTypeBinding18 intersectionTypeBinding18 = (IntersectionTypeBinding18)this.expectedType;
            ReferenceBinding[] referenceBindingArray = intersectionTypeBinding18.intersectingTypes;
            TypeBinding typeBinding = intersectionTypeBinding18.getSAMType(this.enclosingScope);
            for (ReferenceBinding referenceBinding : referenceBindingArray) {
                if (!((TypeBinding)referenceBinding).isInterface() || TypeBinding.equalsEquals(typeBinding, referenceBinding) || referenceBinding.id == 37) continue;
                linkedHashSet.add(referenceBinding);
            }
            if (linkedHashSet.size() > 0) {
                return linkedHashSet.toArray(new TypeBinding[linkedHashSet.size()]);
            }
        }
        return null;
    }

    public ReferenceBinding getTypeBinding() {
        if (this.classType != null || this.resolvedType == null) {
            return null;
        }
        class LambdaTypeBinding
        extends ReferenceBinding {
            LambdaTypeBinding() {
            }

            @Override
            public MethodBinding[] methods() {
                return new MethodBinding[]{LambdaExpression.this.getMethodBinding()};
            }

            @Override
            public char[] sourceName() {
                return TypeConstants.LAMBDA_TYPE;
            }

            @Override
            public ReferenceBinding superclass() {
                return LambdaExpression.this.scope.getJavaLangObject();
            }

            @Override
            public ReferenceBinding[] superInterfaces() {
                return new ReferenceBinding[]{(ReferenceBinding)LambdaExpression.this.resolvedType};
            }

            @Override
            public char[] computeUniqueKey() {
                return LambdaExpression.this.descriptor.declaringClass.computeUniqueKey();
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer("()->{} implements ");
                stringBuffer.append(LambdaExpression.this.descriptor.declaringClass.sourceName());
                stringBuffer.append('.');
                stringBuffer.append(LambdaExpression.this.descriptor.toString());
                return stringBuffer.toString();
            }
        }
        this.classType = new LambdaTypeBinding();
        return this.classType;
    }

    class CopyFailureException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        CopyFailureException() {
        }
    }
}

