/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.NextException;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.control.RedoException;
import org.jruby.truffle.language.control.RetryException;

public class CatchForProcNode
extends RubyNode {
    @Node.Child
    private RubyNode body;
    private final BranchProfile redoProfile = BranchProfile.create();
    private final BranchProfile nextProfile = BranchProfile.create();
    private final BranchProfile retryProfile = BranchProfile.create();

    public CatchForProcNode(RubyNode body) {
        this.body = body;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        while (true) {
            try {
                return this.body.execute(frame);
            }
            catch (RedoException e) {
                this.redoProfile.enter();
                this.getContext().getSafepointManager().poll(this);
                continue;
            }
            catch (NextException e) {
                this.nextProfile.enter();
                return e.getResult();
            }
            catch (RetryException e) {
                this.retryProfile.enter();
                throw new RaiseException(this.coreExceptions().syntaxErrorInvalidRetry(this));
            }
            break;
        }
    }
}

