/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.InvisibleNode;
import org.jruby.truffle.parser.ast.NilImplicitParseNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.types.INameNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;

public abstract class ParseNode {
    static final List<ParseNode> EMPTY_LIST = new ArrayList<ParseNode>();
    private int sourceCharIndex;
    private int sourceLength;
    protected boolean containsVariableAssignment;
    protected boolean newline;

    public ParseNode(SourceIndexLength position, boolean containsAssignment) {
        if (position == null) {
            this.sourceCharIndex = -1;
            this.sourceLength = -1;
        } else {
            this.sourceCharIndex = position.getCharIndex();
            this.sourceLength = position.getLength();
        }
        this.containsVariableAssignment = containsAssignment;
    }

    public void setNewline() {
        this.newline = true;
    }

    public boolean isNewline() {
        return this.newline;
    }

    public SourceIndexLength getPosition() {
        return new SourceIndexLength(this.sourceCharIndex, this.sourceLength);
    }

    public void setPosition(SourceIndexLength position) {
        this.sourceCharIndex = position.getCharIndex();
        this.sourceLength = position.getLength();
    }

    public abstract <T> T accept(NodeVisitor<T> var1);

    public abstract List<ParseNode> childNodes();

    protected static List<ParseNode> createList(ParseNode node) {
        return Collections.singletonList(node);
    }

    protected static List<ParseNode> createList(ParseNode node1, ParseNode node2) {
        ArrayList<ParseNode> list = new ArrayList<ParseNode>(2);
        list.add(node1);
        list.add(node2);
        return list;
    }

    protected static List<ParseNode> createList(ParseNode node1, ParseNode node2, ParseNode node3) {
        ArrayList<ParseNode> list = new ArrayList<ParseNode>(3);
        list.add(node1);
        list.add(node2);
        list.add(node3);
        return list;
    }

    protected static List<ParseNode> createList(ParseNode ... nodes) {
        ArrayList<ParseNode> list = new ArrayList<ParseNode>(nodes.length);
        for (ParseNode node : nodes) {
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    public String toString() {
        return this.toString(false, 0);
    }

    public String toString(boolean indent, int indentation) {
        if (this instanceof InvisibleNode) {
            return "";
        }
        StringBuilder builder = new StringBuilder(60);
        if (indent) {
            ParseNode.indent(indentation, builder);
        }
        builder.append("(").append(this.getNodeName());
        String moreState = this.toStringInternal();
        if (moreState != null) {
            builder.append("[").append(moreState).append("]");
        }
        if (this instanceof INameNode) {
            builder.append(":").append(((INameNode)((Object)this)).getName());
        }
        if (!this.childNodes().isEmpty() && indent) {
            builder.append("\n");
        }
        for (ParseNode child : this.childNodes()) {
            if (!indent) {
                builder.append(", ");
            }
            if (child == null) {
                if (indent) {
                    ParseNode.indent(indentation + 1, builder);
                }
                builder.append("null");
            } else if (indent && child instanceof NilImplicitParseNode) {
                ParseNode.indent(indentation + 1, builder);
                builder.append(child.getClass().getSimpleName());
            } else {
                builder.append(child.toString(indent, indentation + 1));
            }
            if (!indent) continue;
            builder.append("\n");
        }
        if (!this.childNodes().isEmpty() && indent) {
            ParseNode.indent(indentation, builder);
        }
        builder.append(")");
        return builder.toString();
    }

    protected String toStringInternal() {
        return null;
    }

    private static void indent(int indentation, StringBuilder builder) {
        for (int n = 0; n < indentation; ++n) {
            builder.append("  ");
        }
    }

    protected String getNodeName() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public abstract NodeType getNodeType();

    public boolean isNil() {
        return false;
    }

    public boolean needsDefinitionCheck() {
        return true;
    }

    public boolean containsVariableAssignment() {
        return this.containsVariableAssignment;
    }
}

