/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.readline;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import jline.console.CursorBuffer;
import jline.console.completer.Completer;
import jline.console.completer.FileNameCompleter;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.array.ArrayHelpers;
import org.jruby.truffle.core.cast.BooleanCastWithDefaultNodeGen;
import org.jruby.truffle.core.cast.NameToJavaStringNodeGen;
import org.jruby.truffle.core.cast.NameToJavaStringWithDefaultNodeGen;
import org.jruby.truffle.core.cast.ToStrNodeGen;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.TaintNode;

@CoreClass(value="Truffle::Readline")
public abstract class ReadlineNodes {

    public static class RubyFileNameCompleter
    extends FileNameCompleter {
        @Override
        @CompilerDirectives.TruffleBoundary
        public int complete(String buffer, int cursor, List<CharSequence> candidates) {
            int index = (buffer = buffer.substring(0, cursor)).lastIndexOf(" ");
            if (index != -1) {
                buffer = buffer.substring(index + 1);
            }
            return index + 1 + super.complete(buffer, cursor, candidates);
        }
    }

    public static class ProcCompleter
    implements Completer {
        private static String[] delimiters = new String[]{" ", "\t", "\n", "\"", "\\", "'", "`", "@", "$", ">", "<", "=", ";", "|", "&", "{", "("};

        public ProcCompleter(DynamicObject procCompleter) {
        }

        @CompilerDirectives.TruffleBoundary
        public static String getDelimiter() {
            StringBuilder result = new StringBuilder(delimiters.length);
            for (String delimiter : delimiters) {
                result.append(delimiter);
            }
            return result.toString();
        }

        @CompilerDirectives.TruffleBoundary
        public static void setDelimiter(String delimiter) {
            ArrayList<String> l = new ArrayList<String>();
            CharBuffer buf = CharBuffer.wrap(delimiter);
            while (buf.hasRemaining()) {
                l.add(String.valueOf(buf.get()));
            }
            delimiters = l.toArray(new String[l.size()]);
        }

        @CompilerDirectives.TruffleBoundary
        private int wordIndexOf(String buffer) {
            int index = 0;
            for (String c : delimiters) {
                index = buffer.lastIndexOf(c);
                if (index == -1) continue;
                return index;
            }
            return index;
        }

        @Override
        public int complete(String buffer, int cursor, List<CharSequence> candidates) {
            throw new UnsupportedOperationException("auto-completion via proc not yet supported");
        }
    }

    @CoreMethod(names={"refresh_line"}, onSingleton=true)
    public static abstract class RefreshLineNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject refreshLine() {
            try {
                this.getContext().getConsoleHolder().getReadline().redrawLine();
            }
            catch (IOException e) {
                throw new RaiseException(this.coreExceptions().ioError(e.getMessage(), this));
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"line_buffer"}, onSingleton=true)
    public static abstract class LineBufferNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintNode taintNode = TaintNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object lineBuffer() {
            CursorBuffer cb = this.getContext().getConsoleHolder().getReadline().getCursorBuffer();
            DynamicObject ret = this.createString(StringOperations.encodeRope(cb.toString(), this.getDefaultInternalEncoding()));
            return this.taintNode.executeTaint(ret);
        }
    }

    @CoreMethod(names={"delete_text"}, constructor=true)
    public static abstract class DeleteTextNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject deleteText(DynamicObject readline) {
            this.getContext().getConsoleHolder().getReadline().getCursorBuffer().clear();
            return readline;
        }
    }

    @CoreMethod(names={"insert_text"}, constructor=true, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="text")})
    public static abstract class InsertTextNode
    extends CoreMethodNode {
        @CreateCast(value={"text"})
        public RubyNode coerceTextToString(RubyNode text) {
            return NameToJavaStringNodeGen.create(text);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject insertText(DynamicObject readline, String text) {
            this.getContext().getConsoleHolder().getReadline().getCursorBuffer().write(text);
            return readline;
        }
    }

    @CoreMethod(names={"point"}, onSingleton=true)
    public static abstract class PointNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int point() {
            return this.getContext().getConsoleHolder().getReadline().getCursorBuffer().cursor;
        }
    }

    @CoreMethod(names={"readline"}, isModuleFunction=true, optional=2)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="prompt"), @NodeChild(type=RubyNode.class, value="addToHistory")})
    public static abstract class ReadlineNode
    extends CoreMethodNode {
        @Node.Child
        private TaintNode taintNode = TaintNode.create();

        @CreateCast(value={"prompt"})
        public RubyNode coercePromptToJavaString(RubyNode prompt) {
            return NameToJavaStringWithDefaultNodeGen.create(this.coreStrings().EMPTY_STRING.toString(), prompt);
        }

        @CreateCast(value={"addToHistory"})
        public RubyNode coerceToBoolean(RubyNode addToHistory) {
            return BooleanCastWithDefaultNodeGen.create(false, addToHistory);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object readline(String prompt, boolean addToHistory) {
            this.getContext().getConsoleHolder().getReadline().setExpandEvents(false);
            DynamicObject line = this.nil();
            String value = null;
            try {
                this.getContext().getConsoleHolder().getReadline().getTerminal().setEchoEnabled(false);
                value = this.getContext().getConsoleHolder().getReadline().readLine(prompt);
            }
            catch (IOException e) {
                throw new RaiseException(this.coreExceptions().ioError(e.getMessage(), this));
            }
            finally {
                this.getContext().getConsoleHolder().getReadline().getTerminal().setEchoEnabled(true);
            }
            if (value != null) {
                if (addToHistory) {
                    this.getContext().getConsoleHolder().getReadline().getHistory().add(value);
                }
                line = this.createString(StringOperations.encodeRope(value, this.getContext().getEncodingManager().getDefaultExternalEncoding()));
            }
            return this.taintNode.executeTaint(line);
        }
    }

    @CoreMethod(names={"get_screen_size"}, onSingleton=true)
    public static abstract class GetScreenSizeNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject getScreenSize() {
            int[] store = new int[]{this.getContext().getConsoleHolder().getReadline().getTerminal().getHeight(), this.getContext().getConsoleHolder().getReadline().getTerminal().getWidth()};
            return ArrayHelpers.createArray(this.getContext(), store, 2);
        }
    }

    @CoreMethod(names={"basic_word_break_characters="}, onSingleton=true, required=1)
    @NodeChild(type=RubyNode.class, value="characters")
    public static abstract class SetBasicWordBreakCharactersNode
    extends CoreMethodNode {
        @CreateCast(value={"characters"})
        public RubyNode coerceCharactersToString(RubyNode characters) {
            return ToStrNodeGen.create(characters);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject setBasicWordBreakCharacters(DynamicObject characters) {
            ProcCompleter.setDelimiter(RopeOperations.decodeUTF8(StringOperations.rope(characters)));
            return characters;
        }
    }

    @CoreMethod(names={"basic_word_break_characters"}, onSingleton=true)
    public static abstract class BasicWordBreakCharactersNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject basicWordBreakCharacters() {
            return this.createString(StringOperations.encodeRope(ProcCompleter.getDelimiter(), UTF8Encoding.INSTANCE));
        }
    }
}

