/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.Visitor;

public class LocalVariableTable
extends Attribute {
    private LocalVariable[] local_variable_table;

    public LocalVariableTable(LocalVariableTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLocalVariableTable(), c.getConstantPool());
    }

    public LocalVariableTable(int name_index, int length, LocalVariable[] local_variable_table, ConstantPool constant_pool) {
        super((byte)5, name_index, length, constant_pool);
        this.local_variable_table = local_variable_table;
    }

    LocalVariableTable(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (LocalVariable[])null, constant_pool);
        int local_variable_table_length = input.readUnsignedShort();
        this.local_variable_table = new LocalVariable[local_variable_table_length];
        for (int i = 0; i < local_variable_table_length; ++i) {
            this.local_variable_table[i] = new LocalVariable(input, constant_pool);
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitLocalVariableTable(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.local_variable_table.length);
        for (LocalVariable variable : this.local_variable_table) {
            variable.dump(file);
        }
    }

    public final LocalVariable[] getLocalVariableTable() {
        return this.local_variable_table;
    }

    @Deprecated
    public final LocalVariable getLocalVariable(int index) {
        for (LocalVariable variable : this.local_variable_table) {
            if (variable.getIndex() != index) continue;
            return variable;
        }
        return null;
    }

    public final LocalVariable getLocalVariable(int index, int pc) {
        for (LocalVariable variable : this.local_variable_table) {
            if (variable.getIndex() != index) continue;
            int start_pc = variable.getStartPC();
            int end_pc = start_pc + variable.getLength();
            if (pc < start_pc || pc > end_pc) continue;
            return variable;
        }
        return null;
    }

    public final void setLocalVariableTable(LocalVariable[] local_variable_table) {
        this.local_variable_table = local_variable_table;
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.local_variable_table.length; ++i) {
            buf.append(this.local_variable_table[i]);
            if (i >= this.local_variable_table.length - 1) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        LocalVariableTable c = (LocalVariableTable)this.clone();
        c.local_variable_table = new LocalVariable[this.local_variable_table.length];
        for (int i = 0; i < this.local_variable_table.length; ++i) {
            c.local_variable_table[i] = this.local_variable_table[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    public final int getTableLength() {
        return this.local_variable_table == null ? 0 : this.local_variable_table.length;
    }
}

