/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;

public class AnalyzeRequest
extends SingleShardRequest<AnalyzeRequest> {
    private String[] text;
    private String analyzer;
    private NameOrDefinition tokenizer;
    private final List<NameOrDefinition> tokenFilters = new ArrayList<NameOrDefinition>();
    private final List<NameOrDefinition> charFilters = new ArrayList<NameOrDefinition>();
    private String field;
    private boolean explain = false;
    private String[] attributes = Strings.EMPTY_ARRAY;

    public AnalyzeRequest() {
    }

    public AnalyzeRequest(String index) {
        this.index(index);
    }

    public String[] text() {
        return this.text;
    }

    public AnalyzeRequest text(String ... text) {
        this.text = text;
        return this;
    }

    public AnalyzeRequest analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public AnalyzeRequest tokenizer(String tokenizer) {
        this.tokenizer = new NameOrDefinition(tokenizer);
        return this;
    }

    public AnalyzeRequest tokenizer(Map<String, ?> tokenizer) {
        this.tokenizer = new NameOrDefinition(tokenizer);
        return this;
    }

    public NameOrDefinition tokenizer() {
        return this.tokenizer;
    }

    public AnalyzeRequest addTokenFilter(String tokenFilter) {
        this.tokenFilters.add(new NameOrDefinition(tokenFilter));
        return this;
    }

    public AnalyzeRequest addTokenFilter(Map<String, ?> tokenFilter) {
        this.tokenFilters.add(new NameOrDefinition(tokenFilter));
        return this;
    }

    public List<NameOrDefinition> tokenFilters() {
        return this.tokenFilters;
    }

    public AnalyzeRequest addCharFilter(Map<String, ?> charFilter) {
        this.charFilters.add(new NameOrDefinition(charFilter));
        return this;
    }

    public AnalyzeRequest addCharFilter(String charFilter) {
        this.charFilters.add(new NameOrDefinition(charFilter));
        return this;
    }

    public List<NameOrDefinition> charFilters() {
        return this.charFilters;
    }

    public AnalyzeRequest field(String field) {
        this.field = field;
        return this;
    }

    public String field() {
        return this.field;
    }

    public AnalyzeRequest explain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public boolean explain() {
        return this.explain;
    }

    public AnalyzeRequest attributes(String ... attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes must not be null");
        }
        this.attributes = attributes;
        return this;
    }

    public String[] attributes() {
        return this.attributes;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.text == null || this.text.length == 0) {
            validationException = ValidateActions.addValidationError("text is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.text = in.readStringArray();
        this.analyzer = in.readOptionalString();
        this.tokenizer = in.readOptionalWriteable(NameOrDefinition::new);
        this.tokenFilters.addAll(in.readList(NameOrDefinition::new));
        this.charFilters.addAll(in.readList(NameOrDefinition::new));
        this.field = in.readOptionalString();
        this.explain = in.readBoolean();
        this.attributes = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.text);
        out.writeOptionalString(this.analyzer);
        out.writeOptionalWriteable(this.tokenizer);
        out.writeList(this.tokenFilters);
        out.writeList(this.charFilters);
        out.writeOptionalString(this.field);
        out.writeBoolean(this.explain);
        out.writeStringArray(this.attributes);
    }

    public static class NameOrDefinition
    implements Writeable {
        public final String name;
        public final Settings definition;

        NameOrDefinition(String name) {
            this.name = Objects.requireNonNull(name);
            this.definition = null;
        }

        NameOrDefinition(Map<String, ?> definition) {
            this.name = null;
            Objects.requireNonNull(definition);
            try {
                XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
                builder.map(definition);
                this.definition = Settings.builder().loadFromSource(builder.string()).build();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to parse [" + definition + "]", e);
            }
        }

        NameOrDefinition(StreamInput in) throws IOException {
            this.name = in.readOptionalString();
            this.definition = in.readBoolean() ? Settings.readSettingsFromStream(in) : null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.name);
            boolean isNotNullDefinition = this.definition != null;
            out.writeBoolean(isNotNullDefinition);
            if (isNotNullDefinition) {
                Settings.writeSettingsToStream(this.definition, out);
            }
        }
    }
}

