/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.Collections;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class BytesRestResponse
extends RestResponse {
    public static final String TEXT_CONTENT_TYPE = "text/plain; charset=UTF-8";
    private final RestStatus status;
    private final BytesReference content;
    private final String contentType;
    private static final Logger SUPPRESSED_ERROR_LOGGER = ESLoggerFactory.getLogger("rest.suppressed");

    public BytesRestResponse(RestStatus status, XContentBuilder builder) {
        this(status, builder.contentType().mediaType(), builder.bytes());
    }

    public BytesRestResponse(RestStatus status, String content) {
        this(status, TEXT_CONTENT_TYPE, new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, String content) {
        this(status, contentType, new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, byte[] content) {
        this(status, contentType, new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, BytesReference content) {
        this.status = status;
        this.content = content;
        this.contentType = contentType;
    }

    public BytesRestResponse(RestChannel channel, Exception e) throws IOException {
        this(channel, ExceptionsHelper.status(e), e);
    }

    public BytesRestResponse(RestChannel channel, RestStatus status, Exception e) throws IOException {
        this.status = status;
        if (channel.request().method() == RestRequest.Method.HEAD) {
            this.content = BytesArray.EMPTY;
            this.contentType = TEXT_CONTENT_TYPE;
        } else {
            try (XContentBuilder builder = BytesRestResponse.convert(channel, status, e);){
                this.content = builder.bytes();
                this.contentType = builder.contentType().mediaType();
            }
        }
        if (e instanceof ElasticsearchException) {
            this.copyHeaders((ElasticsearchException)e);
        }
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public BytesReference content() {
        return this.content;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    private static XContentBuilder convert(RestChannel channel, RestStatus status, Exception e) throws IOException {
        XContentBuilder builder = channel.newErrorBuilder().startObject();
        if (e == null) {
            builder.field("error", "unknown");
        } else if (channel.detailedErrorsEnabled()) {
            ToXContent.Params params;
            if (channel.request().paramAsBoolean("error_trace", false)) {
                params = new ToXContent.DelegatingMapParams(Collections.singletonMap("rest.exception.stacktrace.skip", "false"), channel.request());
            } else {
                if (status.getStatus() < 500) {
                    SUPPRESSED_ERROR_LOGGER.debug(() -> new ParameterizedMessage("path: {}, params: {}", (Object)channel.request().rawPath(), channel.request().params()), (Throwable)e);
                } else {
                    SUPPRESSED_ERROR_LOGGER.warn(() -> new ParameterizedMessage("path: {}, params: {}", (Object)channel.request().rawPath(), channel.request().params()), (Throwable)e);
                }
                params = channel.request();
            }
            builder.field("error");
            builder.startObject();
            ElasticsearchException[] rootCauses = ElasticsearchException.guessRootCauses(e);
            builder.field("root_cause");
            builder.startArray();
            for (ElasticsearchException rootCause : rootCauses) {
                builder.startObject();
                rootCause.toXContent(builder, new ToXContent.DelegatingMapParams(Collections.singletonMap("rest.exception.cause.skip", "true"), params));
                builder.endObject();
            }
            builder.endArray();
            ElasticsearchException.toXContent(builder, params, e);
            builder.endObject();
        } else {
            builder.field("error", BytesRestResponse.simpleMessage(e));
        }
        builder.field("status", status.getStatus());
        builder.endObject();
        return builder;
    }

    private static String simpleMessage(Throwable t) throws IOException {
        int counter = 0;
        for (Throwable next = t; next != null && counter++ < 10; next = next.getCause()) {
            if (!(t instanceof ElasticsearchException)) continue;
            return next.getClass().getSimpleName() + "[" + next.getMessage() + "]";
        }
        return "No ElasticsearchException found";
    }
}

