/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.TypeRegistry;
import org.springsource.loaded.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringLoaded {
    public static int loadNewVersionOfType(Class<?> clazz, byte[] newbytes) {
        return SpringLoaded.loadNewVersionOfType(clazz.getClassLoader(), clazz.getName(), newbytes);
    }

    public static int loadNewVersionOfType(ClassLoader classLoader, String dottedClassname, byte[] newbytes) {
        try {
            TypeRegistry typeRegistry = TypeRegistry.getTypeRegistryFor(classLoader);
            if (typeRegistry == null) {
                return 1;
            }
            ReloadableType reloadableType = typeRegistry.getReloadableType(dottedClassname.replace('.', '/'));
            if (reloadableType == null) {
                return 2;
            }
            String tag = Utils.encode(System.currentTimeMillis());
            boolean reloaded = reloadableType.loadNewVersion(tag, newbytes);
            return reloaded ? 0 : 3;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 4;
        }
    }
}

