/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.format.FormatFrameDescriptor;
import org.jruby.truffle.core.format.FormatGuards;
import org.jruby.truffle.core.format.exceptions.TooFewArgumentsException;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.language.RubyBaseNode;

@ImportStatic(value={FormatGuards.class})
public abstract class FormatNode
extends RubyBaseNode {
    private final ConditionProfile writeMoreThanZeroBytes = ConditionProfile.createBinaryProfile();
    private final ConditionProfile tooFewArgumentsProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile sourceRangeProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile codeRangeIncreasedProfile = ConditionProfile.createBinaryProfile();

    public abstract Object execute(VirtualFrame var1);

    public int getSourceLength(VirtualFrame frame) {
        try {
            return frame.getInt(FormatFrameDescriptor.SOURCE_LENGTH_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
    }

    protected int getSourcePosition(VirtualFrame frame) {
        try {
            return frame.getInt(FormatFrameDescriptor.SOURCE_POSITION_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setSourcePosition(VirtualFrame frame, int position) {
        frame.setInt(FormatFrameDescriptor.SOURCE_POSITION_SLOT, position);
    }

    protected int advanceSourcePosition(VirtualFrame frame) {
        return this.advanceSourcePosition(frame, 1);
    }

    protected int advanceSourcePosition(VirtualFrame frame, int count) {
        int sourcePosition = this.getSourcePosition(frame);
        if (this.tooFewArgumentsProfile.profile(sourcePosition + count > this.getSourceLength(frame))) {
            throw new TooFewArgumentsException();
        }
        this.setSourcePosition(frame, sourcePosition + count);
        return sourcePosition;
    }

    protected int advanceSourcePositionNoThrow(VirtualFrame frame) {
        return this.advanceSourcePositionNoThrow(frame, 1, false);
    }

    protected int advanceSourcePositionNoThrow(VirtualFrame frame, int count, boolean consumePartial) {
        int sourceLength;
        int sourcePosition = this.getSourcePosition(frame);
        if (this.sourceRangeProfile.profile(sourcePosition + count > (sourceLength = this.getSourceLength(frame)))) {
            if (consumePartial) {
                this.setSourcePosition(frame, sourceLength);
            }
            return -1;
        }
        this.setSourcePosition(frame, sourcePosition + count);
        return sourcePosition;
    }

    protected Object getOutput(VirtualFrame frame) {
        try {
            return frame.getObject(FormatFrameDescriptor.OUTPUT_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setOutput(VirtualFrame frame, Object output) {
        CompilerAsserts.neverPartOfCompilation();
        frame.setObject(FormatFrameDescriptor.OUTPUT_SLOT, output);
    }

    protected int getOutputPosition(VirtualFrame frame) {
        try {
            return frame.getInt(FormatFrameDescriptor.OUTPUT_POSITION_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setOutputPosition(VirtualFrame frame, int position) {
        frame.setInt(FormatFrameDescriptor.OUTPUT_POSITION_SLOT, position);
    }

    protected int getStringLength(VirtualFrame frame) {
        try {
            return frame.getInt(FormatFrameDescriptor.STRING_LENGTH_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setStringLength(VirtualFrame frame, int length) {
        frame.setInt(FormatFrameDescriptor.STRING_LENGTH_SLOT, length);
    }

    protected void increaseStringLength(VirtualFrame frame, int additionalLength) {
        this.setStringLength(frame, this.getStringLength(frame) + additionalLength);
    }

    protected void setStringCodeRange(VirtualFrame frame, CodeRange codeRange) {
        try {
            int existingCodeRange = frame.getInt(FormatFrameDescriptor.STRING_CODE_RANGE_SLOT);
            if (this.codeRangeIncreasedProfile.profile(codeRange.toInt() > existingCodeRange)) {
                frame.setInt(FormatFrameDescriptor.STRING_CODE_RANGE_SLOT, codeRange.toInt());
            }
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setTainted(VirtualFrame frame) {
        frame.setBoolean(FormatFrameDescriptor.TAINT_SLOT, true);
    }

    protected void writeByte(VirtualFrame frame, byte value) {
        byte[] output = this.ensureCapacity(frame, 1);
        int outputPosition = this.getOutputPosition(frame);
        output[outputPosition] = value;
        this.setOutputPosition(frame, outputPosition + 1);
        this.setStringCodeRange(frame, value >= 0 ? CodeRange.CR_7BIT : CodeRange.CR_VALID);
        this.increaseStringLength(frame, 1);
    }

    protected void writeBytes(VirtualFrame frame, byte ... values) {
        this.writeBytes(frame, values, values.length);
    }

    protected void writeBytes(VirtualFrame frame, byte[] values, int valuesLength) {
        byte[] output = this.ensureCapacity(frame, valuesLength);
        int outputPosition = this.getOutputPosition(frame);
        System.arraycopy(values, 0, output, outputPosition, valuesLength);
        this.setOutputPosition(frame, outputPosition + valuesLength);
        this.increaseStringLength(frame, valuesLength);
    }

    protected void writeNullBytes(VirtualFrame frame, int length) {
        if (this.writeMoreThanZeroBytes.profile(length > 0)) {
            this.ensureCapacity(frame, length);
            int outputPosition = this.getOutputPosition(frame);
            this.setOutputPosition(frame, outputPosition + length);
            this.increaseStringLength(frame, length);
        }
    }

    private byte[] ensureCapacity(VirtualFrame frame, int length) {
        byte[] output = (byte[])this.getOutput(frame);
        int outputPosition = this.getOutputPosition(frame);
        if (outputPosition + length > output.length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            output = Arrays.copyOf(output, ArrayUtils.capacity(this.getContext(), output.length, outputPosition + length));
            this.setOutput(frame, output);
        }
        return output;
    }

    @Override
    protected boolean isNil(Object object) {
        return object == this.coreLibrary().getNilObject();
    }

    public static int safeGet(ByteBuffer encode) {
        while (encode.hasRemaining()) {
            int got = encode.get() & 0xFF;
            if (got == 0) continue;
            return got;
        }
        return 0;
    }
}

