/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

public abstract class RescueNode
extends RubyNode {
    @Node.Child
    private RubyNode rescueBody;
    @Node.Child
    private CallDispatchHeadNode callTripleEqualsNode;
    @Node.Child
    private BooleanCastNode booleanCastNode;
    private final BranchProfile errorProfile = BranchProfile.create();

    public RescueNode(RubyNode rescueBody) {
        this.rescueBody = rescueBody;
    }

    public abstract boolean canHandle(VirtualFrame var1, DynamicObject var2);

    @Override
    public Object execute(VirtualFrame frame) {
        return this.rescueBody.execute(frame);
    }

    protected boolean matches(VirtualFrame frame, Object exception, Object handlingClass) {
        if (!RubyGuards.isRubyModule(handlingClass)) {
            this.errorProfile.enter();
            throw new RaiseException(this.coreExceptions().typeErrorRescueInvalidClause(this));
        }
        if (this.callTripleEqualsNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callTripleEqualsNode = this.insert(DispatchHeadNodeFactory.createMethodCall());
            this.booleanCastNode = this.insert(BooleanCastNodeGen.create(null));
        }
        return this.booleanCastNode.executeToBoolean(this.callTripleEqualsNode.call(frame, handlingClass, "===", exception));
    }
}

