/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;

public class UntilParseNode
extends ParseNode {
    private final ParseNode conditionNode;
    private final ParseNode bodyNode;
    private final boolean evaluateAtStart;

    public UntilParseNode(SourceIndexLength position, ParseNode conditionNode, ParseNode bodyNode) {
        this(position, conditionNode, bodyNode, true);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNTILNODE;
    }

    public UntilParseNode(SourceIndexLength position, ParseNode conditionNode, ParseNode bodyNode, boolean evaluateAtStart) {
        super(position, conditionNode.containsVariableAssignment() || bodyNode.containsVariableAssignment());
        assert (conditionNode != null) : "conditionNode is not null";
        assert (bodyNode != null) : "bodyNode is not null";
        this.conditionNode = conditionNode;
        this.bodyNode = bodyNode;
        this.evaluateAtStart = evaluateAtStart;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitUntilNode(this);
    }

    public ParseNode getBodyNode() {
        return this.bodyNode;
    }

    public ParseNode getConditionNode() {
        return this.conditionNode;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.conditionNode, this.bodyNode);
    }

    public boolean evaluateAtStart() {
        return this.evaluateAtStart;
    }
}

