/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.BuildStep;
import org.jetbrains.kotlin.incremental.TestLogsParsingUtilKt;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/BuildLogParserParametrizedTest;", "", "()V", "testDirName", "", "testParser", "", "Companion", "kotlin-build-common"})
public final class BuildLogParserParametrizedTest {
    @Parameterized.Parameter
    @JvmField
    @NotNull
    public String testDirName = "";
    private static final File TEST_ROOT;
    private static final String LOG_FILE_NAME = "build.log";
    private static final String EXPECTED_PARSED_LOG_FILE_NAME = "expected.txt";
    public static final Companion Companion;

    @Test
    public final void testParser() {
        String string;
        String string2;
        String $i$a$1$assert;
        File testDir = new File(BuildLogParserParametrizedTest.Companion.getTEST_ROOT(), this.testDirName);
        File logFile = new File(testDir, BuildLogParserParametrizedTest.Companion.getLOG_FILE_NAME());
        boolean bl = logFile.isFile();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Log file: " + logFile + " does not exist";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        String string4 = $i$a$1$assert = StringsKt.replace$default((String)TestLogsParsingUtilKt.dumpBuildLog((Iterable<BuildStep>)TestLogsParsingUtilKt.parseTestBuildLog(logFile)), (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String actualNormalized = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        File expectedFile = new File(testDir, BuildLogParserParametrizedTest.Companion.getEXPECTED_PARSED_LOG_FILE_NAME());
        if (!expectedFile.isFile()) {
            expectedFile.createNewFile();
            FilesKt.writeText$default((File)expectedFile, (String)actualNormalized, null, (int)2, null);
            throw (Throwable)((Object)new AssertionError((Object)("Expected file log did not exist, created: " + expectedFile)));
        }
        String string5 = string2 = StringsKt.replace$default((String)FilesKt.readText$default((File)expectedFile, null, (int)1, null), (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String expectedNormalized = ((Object)StringsKt.trim((CharSequence)string5)).toString();
        Assert.assertEquals((String)"Parsed content was unexpected: ", (Object)expectedNormalized, (Object)actualNormalized);
        String string6 = string = TestLogsParsingUtilKt.dumpBuildLog((Iterable<BuildStep>)TestLogsParsingUtilKt.parseTestBuildLog(expectedFile));
        if (string6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String reparsedActualNormalized = ((Object)StringsKt.trim((CharSequence)string6)).toString();
        Assert.assertEquals((String)"Reparsed content was unexpected: ", (Object)expectedNormalized, (Object)reparsedActualNormalized);
    }

    static {
        Companion = new Companion(null);
        TEST_ROOT = new File("compiler/incremental-compilation-impl/testData/buildLogsParserData");
        LOG_FILE_NAME = LOG_FILE_NAME;
        EXPECTED_PARSED_LOG_FILE_NAME = EXPECTED_PARSED_LOG_FILE_NAME;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    @JvmStatic
    @NotNull
    public static final List<String[]> data() {
        return Companion.data();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0011\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000f0\u000eH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/BuildLogParserParametrizedTest$Companion;", "", "()V", "EXPECTED_PARSED_LOG_FILE_NAME", "", "getEXPECTED_PARSED_LOG_FILE_NAME", "()Ljava/lang/String;", "LOG_FILE_NAME", "getLOG_FILE_NAME", "TEST_ROOT", "Ljava/io/File;", "getTEST_ROOT", "()Ljava/io/File;", "data", "", "", "kotlin-build-common"})
    public static final class Companion {
        private final File getTEST_ROOT() {
            return TEST_ROOT;
        }

        private final String getLOG_FILE_NAME() {
            return LOG_FILE_NAME;
        }

        private final String getEXPECTED_PARSED_LOG_FILE_NAME() {
            return EXPECTED_PARSED_LOG_FILE_NAME;
        }

        /*
         * WARNING - void declaration
         */
        @Parameterized.Parameters(name="{index}: {0}")
        @JvmStatic
        @NotNull
        public final List<String[]> data() {
            void var3_3;
            File it;
            Object $receiver$iv$iv;
            Object $receiver$iv = this.getTEST_ROOT().listFiles();
            Object[] objectArray = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void element$iv$iv = $receiver$iv$iv[i];
                it = (File)element$iv$iv;
                if (!it.isDirectory()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List directories = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv = (Iterable)directories;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv = iterator.next();
                it = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                String[] elements$iv = new String[]{it.getName()};
                String[] stringArray = (String[])((Object[])elements$iv);
                collection.add(stringArray);
            }
            return (List)var3_3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

