/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

class HardElementInfo
extends SmartPointerElementInfo {
    @NotNull
    private final PsiElement myElement;
    @NotNull
    private final Project myProject;

    public HardElementInfo(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/HardElementInfo", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/HardElementInfo", "<init>"));
        }
        this.myElement = element;
        this.myProject = project;
    }

    @Override
    public PsiElement restoreElement() {
        return this.myElement;
    }

    @Override
    public PsiFile restoreFile() {
        return this.myElement.getContainingFile();
    }

    @Override
    public int elementHashCode() {
        return this.myElement.hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(final @NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/HardElementInfo", "pointsToTheSameElementAs"));
        }
        return Comparing.equal(this.myElement, ApplicationManager.getApplication().runReadAction(new Computable<PsiElement>(){

            @Override
            public PsiElement compute() {
                return other.restoreElement();
            }
        }));
    }

    @Override
    public VirtualFile getVirtualFile() {
        return PsiUtilCore.getVirtualFile(this.myElement);
    }

    @Override
    public Segment getRange() {
        return this.myElement.getTextRange();
    }

    @Override
    public Segment getPsiRange() {
        return this.getRange();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/HardElementInfo", "getProject"));
        }
        return project;
    }

    public String toString() {
        return "hard{" + this.myElement + " of " + this.myElement.getClass() + "}";
    }
}

