/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.facade;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.coroutine.CoroutineTransformer;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationResult;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationException;
import org.jetbrains.kotlin.js.inline.JsInliner;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedImportsKt;
import org.jetbrains.kotlin.js.inline.clean.ResolveTemporaryNamesKt;
import org.jetbrains.kotlin.js.translate.context.StaticContext;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.ExpandIsCallsKt;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public final class K2JSTranslator {
    @NotNull
    private final JsConfig config;

    public K2JSTranslator(@NotNull JsConfig config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "<init>"));
        }
        this.config = config;
    }

    @NotNull
    public TranslationResult translate(@NotNull List<KtFile> files2, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
        }
        TranslationResult translationResult = this.translate(files2, mainCallParameters, null);
        if (translationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
        }
        return translationResult;
    }

    @NotNull
    public TranslationResult translate(@NotNull List<KtFile> files2, @NotNull MainCallParameters mainCallParameters, @Nullable JsAnalysisResult analysisResult) throws TranslationException {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
        }
        if (analysisResult == null) {
            analysisResult = TopDownAnalyzerFacadeForJS.analyzeFiles(files2, this.config);
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        }
        BindingTrace bindingTrace = analysisResult.getBindingTrace();
        TopDownAnalyzerFacadeForJS.checkForErrors(JsConfig.withJsLibAdded(files2, this.config), bindingTrace.getBindingContext());
        ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
        Diagnostics diagnostics = bindingTrace.getBindingContext().getDiagnostics();
        TranslationContext context = Translation.generateAst(bindingTrace, files2, mainCallParameters, moduleDescriptor, this.config);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (DiagnosticUtils.hasError(diagnostics)) {
            TranslationResult.Fail fail = new TranslationResult.Fail(diagnostics);
            if (fail == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
            }
            return fail;
        }
        JsProgram program = JsInliner.process(context);
        ResolveTemporaryNamesKt.resolveTemporaryNames(program);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (DiagnosticUtils.hasError(diagnostics)) {
            TranslationResult.Fail fail = new TranslationResult.Fail(diagnostics);
            if (fail == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
            }
            return fail;
        }
        CoroutineTransformer coroutineTransformer = new CoroutineTransformer(program);
        coroutineTransformer.accept(program);
        RemoveUnusedImportsKt.removeUnusedImports(program);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (DiagnosticUtils.hasError(diagnostics)) {
            TranslationResult.Fail fail = new TranslationResult.Fail(diagnostics);
            if (fail == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
            }
            return fail;
        }
        ExpandIsCallsKt.expandIsCalls(program, context);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        ArrayList<String> importedModules = new ArrayList<String>();
        for (StaticContext.ImportedModule module : context.getImportedModules()) {
            importedModules.add(module.getExternalName());
        }
        TranslationResult.Success success = new TranslationResult.Success(this.config, files2, program, diagnostics, importedModules, moduleDescriptor, bindingTrace.getBindingContext());
        if (success == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/facade/K2JSTranslator", "translate"));
        }
        return success;
    }
}

