/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallableReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetClassImpl;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/ReflectionReferencesGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "generateCallableReference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ktCallableReference", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "generateClassLiteral", "ktClassLiteral", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "kotlin-compiler"})
public final class ReflectionReferencesGenerator
extends StatementGeneratorExtension {
    @NotNull
    public final IrExpression generateClassLiteral(@NotNull KtClassLiteralExpression ktClassLiteral) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull(ktClassLiteral, "ktClassLiteral");
        KtExpression ktExpression = ktClassLiteral.getReceiverExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktArgument = ktExpression;
        WritableSlice<KtExpression, DoubleColonLHS> writableSlice = BindingContext.DOUBLE_COLON_LHS;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.DOUBLE_COLON_LHS");
        DoubleColonLHS lhs = (DoubleColonLHS)GeneratorKt.getOrFail(this, writableSlice, ktArgument);
        KotlinType resultType = GeneratorKt.getInferredTypeWithImplicitCastsOrFail(this, ktClassLiteral);
        if (lhs instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)lhs).isObjectQualifier()) {
            irExpression = new IrGetClassImpl(PsiUtilsKt.getStartOffset(ktClassLiteral), PsiUtilsKt.getEndOffset(ktClassLiteral), resultType, this.getStatementGenerator().generateExpression(ktArgument));
        } else {
            ClassifierDescriptor typeConstructorDeclaration = lhs.getType().getConstructor().getDeclarationDescriptor();
            ClassifierDescriptor classifierDescriptor = typeConstructorDeclaration;
            if (!(classifierDescriptor instanceof ClassifierDescriptor)) {
                classifierDescriptor = null;
            }
            if (classifierDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected type constructor for " + lhs.getType() + ": " + typeConstructorDeclaration)));
            }
            ClassifierDescriptor typeClass = classifierDescriptor;
            irExpression = new IrClassReferenceImpl(PsiUtilsKt.getStartOffset(ktClassLiteral), PsiUtilsKt.getEndOffset(ktClassLiteral), resultType, typeClass);
        }
        return irExpression;
    }

    @NotNull
    public final IrExpression generateCallableReference(@NotNull KtCallableReferenceExpression ktCallableReference) {
        IrCallableReferenceImpl irCallableRef;
        block4: {
            ReceiverValue receiverValue;
            Intrinsics.checkParameterIsNotNull(ktCallableReference, "ktCallableReference");
            KtSimpleNameExpression ktSimpleNameExpression = ktCallableReference.getCallableReference();
            Intrinsics.checkExpressionValueIsNotNull(ktSimpleNameExpression, "ktCallableReference.callableReference");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, ktSimpleNameExpression);
            if (resolvedCall2 == null) {
                Intrinsics.throwNpe();
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            irCallableRef = new IrCallableReferenceImpl(PsiUtilsKt.getStartOffset(ktCallableReference), PsiUtilsKt.getEndOffset(ktCallableReference), GeneratorKt.getInferredTypeWithImplicitCastsOrFail(this, ktCallableReference), resolvedCall3.getResultingDescriptor(), null, null, 32, null);
            ReceiverValue receiverValue2 = resolvedCall3.getDispatchReceiver();
            if (receiverValue2 != null) {
                receiverValue = receiverValue2;
                ReceiverValue dispatchReceiver = receiverValue;
                if (!(dispatchReceiver instanceof TransientReceiver)) {
                    StatementGenerator statementGenerator = this.getStatementGenerator();
                    KtElement ktElement = ktCallableReference;
                    ReceiverValue receiverValue3 = dispatchReceiver;
                    Intrinsics.checkExpressionValueIsNotNull(receiverValue3, "dispatchReceiver");
                    irCallableRef.setDispatchReceiver(ArgumentsGenerationUtilsKt.generateReceiver(statementGenerator, ktElement, receiverValue3).load());
                }
            }
            ReceiverValue receiverValue4 = resolvedCall3.getExtensionReceiver();
            if (receiverValue4 == null) break block4;
            receiverValue = receiverValue4;
            ReceiverValue extensionReceiver = receiverValue;
            if (!(extensionReceiver instanceof TransientReceiver)) {
                StatementGenerator statementGenerator = this.getStatementGenerator();
                KtElement ktElement = ktCallableReference;
                ReceiverValue receiverValue5 = extensionReceiver;
                Intrinsics.checkExpressionValueIsNotNull(receiverValue5, "extensionReceiver");
                irCallableRef.setExtensionReceiver(ArgumentsGenerationUtilsKt.generateReceiver(statementGenerator, ktElement, receiverValue5).load());
            }
        }
        return irCallableRef;
    }

    public ReflectionReferencesGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull(statementGenerator, "statementGenerator");
        super(statementGenerator);
    }
}

