/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ContextSensitiveHelpAction
extends AbstractAction {
    private String helpTopic;

    public void setHelpTopic(String string) {
        this.helpTopic = Optional.ofNullable(string).orElse("/");
    }

    public ContextSensitiveHelpAction() {
        this(HelpUtil.ht("/"));
    }

    public ContextSensitiveHelpAction(String string) {
        this.putValue("ShortDescription", I18n.tr("Show help information", new Object[0]));
        this.putValue("Name", I18n.tr("Help", new Object[0]));
        new ImageProvider("help").getResource().attachImageIcon(this);
        this.helpTopic = string;
        this.setEnabled(!Main.isOffline(OnlineResource.JOSM_WEBSITE));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.helpTopic != null) {
            HelpBrowser.setUrlForHelpTopic(this.helpTopic);
        }
    }
}

