/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CustomExceptionHandler;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
        }
        ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(element);
            ExceptionUtil.addExceptions(array, exceptions);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
        }
        if (element instanceof PsiClass) {
            PsiExpressionList argumentList2;
            if (element instanceof PsiAnonymousClass && (argumentList2 = ((PsiAnonymousClass)element).getArgumentList()) != null) {
                List<PsiClassType> list2 = ExceptionUtil.getThrownExceptions(argumentList2);
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
                }
                return list2;
            }
            List<PsiClassType> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
            }
            return list3;
        }
        if (element instanceof PsiLambdaExpression) {
            List<PsiClassType> list4 = Collections.emptyList();
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
            }
            return list4;
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodRef = ((PsiMethodCallExpression)element).getMethodExpression();
            JavaResolveResult result2 = methodRef.advancedResolve(false);
            List<PsiClassType> list5 = ExceptionUtil.getExceptionsByMethodAndChildren(element, result2);
            if (list5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
            }
            return list5;
        }
        if (element instanceof PsiNewExpression) {
            JavaResolveResult result3 = ((PsiNewExpression)element).resolveMethodGenerics();
            List<PsiClassType> list6 = ExceptionUtil.getExceptionsByMethodAndChildren(element, result3);
            if (list6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
            }
            return list6;
        }
        if (element instanceof PsiThrowStatement) {
            PsiExpression expr = ((PsiThrowStatement)element).getException();
            if (expr == null) {
                List<PsiClassType> list7 = Collections.emptyList();
                if (list7 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
                }
                return list7;
            }
            List<PsiType> types = ExceptionUtil.getPreciseThrowTypes(expr);
            ArrayList<PsiClassType> classTypes = new ArrayList<PsiClassType>(ContainerUtil.mapNotNull(types, new NullableFunction<PsiType, PsiClassType>(){

                @Override
                public PsiClassType fun(PsiType type2) {
                    return type2 instanceof PsiClassType ? (PsiClassType)type2 : null;
                }
            }));
            ExceptionUtil.addExceptions(classTypes, ExceptionUtil.getThrownExceptions(expr));
            ArrayList<PsiClassType> arrayList = classTypes;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
            }
            return arrayList;
        }
        if (element instanceof PsiTryStatement) {
            List<PsiClassType> list8 = ExceptionUtil.getTryExceptions((PsiTryStatement)element);
            if (list8 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
            }
            return list8;
        }
        if (element instanceof PsiResourceListElement) {
            PsiResourceVariable variable;
            PsiExpression initializer2;
            ArrayList<PsiClassType> types = ContainerUtil.newArrayList();
            ExceptionUtil.addExceptions(types, ExceptionUtil.getCloserExceptions((PsiResourceListElement)element));
            if (element instanceof PsiResourceVariable && (initializer2 = (variable = (PsiResourceVariable)element).getInitializer()) != null) {
                ExceptionUtil.addExceptions(types, ExceptionUtil.getThrownExceptions(initializer2));
            }
            ArrayList<PsiClassType> arrayList = types;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
            }
            return arrayList;
        }
        List<PsiClassType> list9 = ExceptionUtil.getThrownExceptions(element.getChildren());
        if (list9 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
        }
        return list9;
    }

    @NotNull
    private static List<PsiClassType> getTryExceptions(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        if (tryStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryStatement", "com/intellij/codeInsight/ExceptionUtil", "getTryExceptions"));
        }
        ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiResourceListElement psiResourceListElement : resourceList) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(psiResourceListElement, resourceList));
            }
        }
        if ((tryBlock = tryStatement.getTryBlock()) != null) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(tryBlock));
        }
        for (PsiParameter psiParameter : tryStatement.getCatchBlockParameters()) {
            PsiType exception = psiParameter.getType();
            for (int j = array.size() - 1; j >= 0; --j) {
                PsiClassType exception1 = (PsiClassType)array.get(j);
                if (!exception.isAssignableFrom(exception1)) continue;
                array.remove(exception1);
            }
        }
        for (PsiCodeBlock psiCodeBlock : tryStatement.getCatchBlocks()) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(psiCodeBlock));
        }
        PsiCodeBlock psiCodeBlock = tryStatement.getFinallyBlock();
        if (psiCodeBlock != null) {
            try {
                ControlFlow flow = ControlFlowFactory.getInstance(psiCodeBlock.getProject()).getControlFlow(psiCodeBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
                List<PsiClassType> list2 = ExceptionUtil.getThrownExceptions(psiCodeBlock);
                if (!BitUtil.isSet(completionReasons, 1)) {
                    array = ContainerUtil.newArrayList(list2);
                } else {
                    ExceptionUtil.addExceptions(array, list2);
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getTryExceptions"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethodAndChildren(@NotNull PsiElement element, @NotNull JavaResolveResult resolveResult) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethodAndChildren"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethodAndChildren"));
        }
        ArrayList<PsiClassType> result2 = ContainerUtil.newArrayList();
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method != null) {
            ExceptionUtil.addExceptions(result2, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
        }
        ExceptionUtil.addExceptions(result2, ExceptionUtil.getThrownExceptions(element.getChildren()));
        ArrayList<PsiClassType> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethodAndChildren"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, @NotNull PsiElement place) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethod"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethod"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethod"));
        }
        PsiClassType[] referenceTypes = method.getThrowsList().getReferencedTypes();
        if (referenceTypes.length == 0) {
            List<PsiClassType> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethod"));
            }
            return list2;
        }
        GlobalSearchScope scope = place.getResolveScope();
        ArrayList<PsiClassType> result2 = ContainerUtil.newArrayList();
        for (PsiType type2 : referenceTypes) {
            if (!((type2 = PsiClassImplUtil.correctType(substitutor2.substitute(type2), scope)) instanceof PsiClassType)) continue;
            result2.add((PsiClassType)type2);
        }
        ArrayList<PsiClassType> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethod"));
        }
        return arrayList;
    }

    private static void addExceptions(@NotNull List<PsiClassType> array, @NotNull Collection<PsiClassType> exceptions) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/codeInsight/ExceptionUtil", "addExceptions"));
        }
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/intellij/codeInsight/ExceptionUtil", "addExceptions"));
        }
        for (PsiClassType exception : exceptions) {
            ExceptionUtil.addException(array, exception);
        }
    }

    private static void addException(@NotNull List<PsiClassType> array, @Nullable PsiClassType exception) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/codeInsight/ExceptionUtil", "addException"));
        }
        if (exception == null) {
            return;
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            PsiClassType exception1 = array.get(i);
            if (exception1.isAssignableFrom(exception)) {
                return;
            }
            if (!exception.isAssignableFrom(exception1)) continue;
            array.remove(i);
        }
        array.add(exception);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/ExceptionUtil", "collectUnhandledExceptions"));
        }
        Collection<PsiClassType> collection = ExceptionUtil.collectUnhandledExceptions(element, topElement, true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "collectUnhandledExceptions"));
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/ExceptionUtil", "collectUnhandledExceptions"));
        }
        Set<PsiClassType> set = ExceptionUtil.collectUnhandledExceptions(element, topElement, null, includeSelfCalls);
        Collection<Object> collection = set == null ? Collections.emptyList() : set;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "collectUnhandledExceptions"));
        }
        return collection;
    }

    @Nullable
    private static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, @Nullable Set<PsiClassType> foundExceptions, boolean includeSelfCalls) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/ExceptionUtil", "collectUnhandledExceptions"));
        }
        Collection<PsiClassType> unhandledExceptions = null;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression = (PsiCallExpression)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(expression, topElement, includeSelfCalls);
        } else {
            List<PsiClassType> unhandled;
            if (element instanceof PsiMethodReferenceExpression) {
                PsiExpression qualifierExpression = ((PsiMethodReferenceExpression)element).getQualifierExpression();
                return qualifierExpression != null ? ExceptionUtil.collectUnhandledExceptions(qualifierExpression, topElement, null, false) : null;
            }
            if (element instanceof PsiLambdaExpression) {
                return null;
            }
            if (element instanceof PsiThrowStatement) {
                PsiThrowStatement statement = (PsiThrowStatement)element;
                unhandledExceptions = ExceptionUtil.getUnhandledExceptions(statement, topElement);
            } else if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiMethod && ((PsiMethod)element.getParent()).isConstructor() && !ExceptionUtil.firstStatementIsConstructorCall((PsiCodeBlock)element)) {
                PsiMethod constructor = (PsiMethod)element.getParent();
                PsiClass aClass2 = constructor.getContainingClass();
                PsiClass superClass = aClass2 == null ? null : aClass2.getSuperClass();
                PsiMethod[] superConstructors = superClass == null ? PsiMethod.EMPTY_ARRAY : superClass.getConstructors();
                HashSet<PsiClassType> unhandled2 = new HashSet<PsiClassType>();
                for (PsiMethod superConstructor : superConstructors) {
                    PsiClassType[] exceptionTypes;
                    if (superConstructor.hasModifierProperty("private") || superConstructor.getParameterList().getParametersCount() != 0) continue;
                    for (PsiClassType exceptionType : exceptionTypes = superConstructor.getThrowsList().getReferencedTypes()) {
                        if (ExceptionUtil.isUncheckedException(exceptionType) || ExceptionUtil.isHandled(element, exceptionType, topElement)) continue;
                        unhandled2.add(exceptionType);
                    }
                    break;
                }
                if (aClass2 != null) {
                    PsiClassInitializer[] initializers = aClass2.getInitializers();
                    THashSet<PsiClassType> thrownByInitializer = new THashSet<PsiClassType>();
                    for (PsiClassInitializer initializer2 : initializers) {
                        if (initializer2.hasModifierProperty("static")) continue;
                        thrownByInitializer.clear();
                        ExceptionUtil.collectUnhandledExceptions(initializer2.getBody(), initializer2, thrownByInitializer, includeSelfCalls);
                        for (PsiClassType thrown : thrownByInitializer) {
                            if (ExceptionUtil.isHandled(constructor.getBody(), thrown, topElement)) continue;
                            unhandled2.add(thrown);
                        }
                    }
                }
                unhandledExceptions = unhandled2;
            } else if (element instanceof PsiResourceListElement && !(unhandled = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, topElement)).isEmpty()) {
                unhandledExceptions = ContainerUtil.newArrayList(unhandled);
            }
        }
        if (unhandledExceptions != null) {
            if (foundExceptions == null) {
                foundExceptions = new THashSet<PsiClassType>();
            }
            foundExceptions.addAll(unhandledExceptions);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Set<PsiClassType> foundInChild = ExceptionUtil.collectUnhandledExceptions(child, topElement, foundExceptions, includeSelfCalls);
            if (foundExceptions == null) {
                foundExceptions = foundInChild;
                continue;
            }
            if (foundInChild == null) continue;
            foundExceptions.addAll(foundInChild);
        }
        return foundExceptions;
    }

    @NotNull
    private static Collection<PsiClassType> getUnhandledExceptions(@NotNull PsiMethodReferenceExpression methodReferenceExpression, PsiElement topElement) {
        if (methodReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReferenceExpression", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        JavaResolveResult resolveResult = methodReferenceExpression.advancedResolve(false);
        PsiElement resolve2 = resolveResult.getElement();
        if (resolve2 instanceof PsiMethod) {
            PsiElement referenceNameElement = methodReferenceExpression.getReferenceNameElement();
            List<PsiClassType> list2 = ExceptionUtil.getUnhandledExceptions((PsiMethod)resolve2, referenceNameElement, topElement, resolveResult.getSubstitutor());
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
            }
            return list2;
        }
        List<PsiClassType> list3 = Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return list3;
    }

    private static boolean firstStatementIsConstructorCall(@NotNull PsiCodeBlock constructorBody) {
        if (constructorBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorBody", "com/intellij/codeInsight/ExceptionUtil", "firstStatementIsConstructorCall"));
        }
        PsiStatement[] statements = constructorBody.getStatements();
        if (statements.length == 0) {
            return false;
        }
        if (!(statements[0] instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression = ((PsiExpressionStatement)statements[0]).getExpression();
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod method = (PsiMethod)((PsiMethodCallExpression)expression).getMethodExpression().resolve();
        return method != null && method.isConstructor();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(final @NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        final ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        JavaRecursiveElementWalkingVisitor visitor2 = new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitEnumConstant(PsiEnumConstant enumConstant) {
                PsiMethod method = enumConstant.resolveMethod();
                if (method != null) {
                    ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(method, (PsiElement)enumConstant, null, PsiSubstitutor.EMPTY));
                }
                this.visitElement(enumConstant);
            }

            @Override
            public void visitCallExpression(@NotNull PsiCallExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/ExceptionUtil$2", "visitCallExpression"));
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(expression, null));
                this.visitElement(expression);
            }

            @Override
            public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
                if (statement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/ExceptionUtil$2", "visitThrowStatement"));
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(statement, null));
                this.visitElement(statement);
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression) {
                if (ArrayUtil.find(elements, expression) >= 0) {
                    this.visitElement(expression);
                }
            }

            @Override
            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/ExceptionUtil$2", "visitMethodReferenceExpression"));
                }
                if (ArrayUtil.find(elements, expression) >= 0) {
                    ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(expression, null));
                    this.visitElement(expression);
                }
            }

            @Override
            public void visitResourceVariable(@NotNull PsiResourceVariable resource) {
                if (resource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/codeInsight/ExceptionUtil$2", "visitResourceVariable"));
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(resource, null));
                this.visitElement(resource);
            }

            @Override
            public void visitResourceExpression(@NotNull PsiResourceExpression resource) {
                if (resource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/codeInsight/ExceptionUtil$2", "visitResourceExpression"));
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(resource, null));
                this.visitElement(resource);
            }

            @Override
            public void visitClass(PsiClass aClass2) {
            }
        };
        for (PsiElement element : elements) {
            element.accept(visitor2);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        List<PsiClassType> list2 = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, true);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return list2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        block18: {
            block19: {
                if (methodCall == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"methodCall", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
                }
                if (MethodCandidateInfo.isOverloadCheck()) {
                    v0 = Collections.emptyList();
                    if (v0 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
                    }
                    return v0;
                }
                properties = MethodCandidateInfo.getCurrentMethod(methodCall.getArgumentList());
                result = properties != null ? properties.getInfo() : InferenceSession.getResolveResult(methodCall);
                element = result.getElement();
                v1 = method = element instanceof PsiMethod != false ? (PsiMethod)element : null;
                if (method == null) {
                    v2 = Collections.emptyList();
                    if (v2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
                    }
                    return v2;
                }
                containingMethod = PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class);
                if (!includeSelfCalls && method == containingMethod) {
                    v3 = Collections.emptyList();
                    if (v3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
                    }
                    return v3;
                }
                thrownExceptions = method.getThrowsList().getReferencedTypes();
                if (thrownExceptions.length == 0) {
                    v4 = Collections.emptyList();
                    if (v4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
                    }
                    return v4;
                }
                substitutor = result.getSubstitutor();
                if (ExceptionUtil.isArrayClone(method, methodCall) || !(methodCall instanceof PsiMethodCallExpression)) break block18;
                containingFile = (containingMethod == null ? methodCall : containingMethod).getContainingFile();
                processor = new MethodResolverProcessor((PsiMethodCallExpression)methodCall, containingFile);
                try {
                    PsiScopesUtil.setupAndRunProcessor(processor, methodCall, false);
                    candidates = ContainerUtil.mapNotNull(processor.getResults(), new Function<CandidateInfo, Pair<PsiMethod, PsiSubstitutor>>(){

                        @Override
                        public Pair<PsiMethod, PsiSubstitutor> fun(CandidateInfo info) {
                            PsiElement element = info.getElement();
                            if (info instanceof MethodCandidateInfo && MethodSignatureUtil.areSignaturesEqual(method, (PsiMethod)element) && !MethodSignatureUtil.isSuperMethod((PsiMethod)element, method)) {
                                return Pair.create((PsiMethod)element, ((MethodCandidateInfo)info).getSubstitutor(false));
                            }
                            return null;
                        }
                    });
                    if (candidates.size() <= 1) break block18;
                    scope = methodCall.getResolveScope();
                    ex = ExceptionUtil.collectSubstituted(substitutor, thrownExceptions, scope);
lbl39:
                    // 2 sources

                    for (Pair<PsiMethod, PsiSubstitutor> pair : candidates) {
                        exceptions = ((PsiMethod)pair.first).getThrowsList().getReferencedTypes();
                        if (exceptions.length == 0) {
                            v5 = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, PsiSubstitutor.EMPTY, PsiClassType.EMPTY_ARRAY);
                            break block19;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl57
                }
                catch (MethodProcessorSetupFailedException ignore) {
                    v6 = Collections.emptyList();
                    if (v6 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
                    }
                    return v6;
                }
            }
            if (v5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
            }
            return v5;
lbl-1000:
            // 1 sources

            {
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted((PsiSubstitutor)pair.second, exceptions, scope));
                ** GOTO lbl39
lbl57:
                // 1 sources

                v7 = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, PsiSubstitutor.EMPTY, ex.toArray(new PsiClassType[ex.size()]));
            }
            if (v7 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
            }
            return v7;
        }
        v8 = ExceptionUtil.getUnhandledExceptions(method, (PsiElement)methodCall, topElement, substitutor);
        if (v8 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
        }
        return v8;
    }

    public static void retainExceptions(List<PsiClassType> ex, List<PsiClassType> thrownEx) {
        ArrayList<PsiClassType> replacement = new ArrayList<PsiClassType>();
        Iterator<PsiClassType> iterator2 = ex.iterator();
        while (iterator2.hasNext()) {
            PsiClassType classType = iterator2.next();
            boolean found = false;
            for (PsiClassType psiClassType : thrownEx) {
                if (psiClassType.isAssignableFrom(classType)) {
                    found = true;
                    break;
                }
                if (!classType.isAssignableFrom(psiClassType)) continue;
                if (ExceptionUtil.isUncheckedException(classType) == ExceptionUtil.isUncheckedException(psiClassType)) {
                    replacement.add(psiClassType);
                    iterator2.remove();
                }
                found = true;
                break;
            }
            if (found) continue;
            iterator2.remove();
        }
        ex.addAll(replacement);
    }

    public static List<PsiClassType> collectSubstituted(PsiSubstitutor substitutor2, PsiClassType[] thrownExceptions, GlobalSearchScope scope) {
        ArrayList<PsiClassType> ex = new ArrayList<PsiClassType>();
        for (PsiClassType thrownException : thrownExceptions) {
            PsiType psiType = PsiClassImplUtil.correctType(substitutor2.substitute(thrownException), scope);
            if (!(psiType instanceof PsiClassType)) continue;
            ex.add((PsiClassType)psiType);
        }
        return ex;
    }

    @NotNull
    public static List<PsiClassType> getCloserExceptions(@NotNull PsiResourceListElement resource) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/codeInsight/ExceptionUtil", "getCloserExceptions"));
        }
        Pair<PsiMethod, PsiSubstitutor> closer = ExceptionUtil.resolveCloser(resource);
        List<PsiClassType> list2 = closer != null ? ExceptionUtil.getExceptionsByMethod((PsiMethod)closer.first, (PsiSubstitutor)closer.second, resource) : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getCloserExceptions"));
        }
        return list2;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(@NotNull PsiResourceListElement resource, @Nullable PsiElement topElement) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledCloserExceptions"));
        }
        Pair<PsiMethod, PsiSubstitutor> closer = ExceptionUtil.resolveCloser(resource);
        List<PsiClassType> list2 = closer != null ? ExceptionUtil.getUnhandledExceptions((PsiMethod)closer.first, (PsiElement)resource, topElement, (PsiSubstitutor)closer.second) : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledCloserExceptions"));
        }
        return list2;
    }

    private static Pair<PsiMethod, PsiSubstitutor> resolveCloser(PsiResourceListElement resource) {
        PsiSubstitutor substitutor2;
        PsiClass resourceClass;
        PsiClassType.ClassResolveResult resourceType;
        PsiClass closerClass;
        PsiMethod method = PsiUtil.getResourceCloserMethod(resource);
        if (method != null && (closerClass = method.getContainingClass()) != null && (resourceType = PsiUtil.resolveGenericsClassInType(resource.getType())) != null && (resourceClass = resourceType.getElement()) != null && (substitutor2 = TypeConversionUtil.getClassSubstitutor(closerClass, resourceClass, resourceType.getSubstitutor())) != null) {
            return Pair.pair(method, substitutor2);
        }
        return null;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiThrowStatement throwStatement, @Nullable PsiElement topElement) {
        if (throwStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwStatement", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        SmartList<PsiClassType> unhandled = new SmartList<PsiClassType>();
        for (PsiType type2 : ExceptionUtil.getPreciseThrowTypes(throwStatement.getException())) {
            List<PsiType> types = type2 instanceof PsiDisjunctionType ? ((PsiDisjunctionType)type2).getDisjunctions() : Collections.singletonList(type2);
            for (PsiType subType : types) {
                PsiClassType classType;
                if (!(subType instanceof PsiClassType) || ExceptionUtil.isUncheckedException(classType = (PsiClassType)subType) || ExceptionUtil.isHandled(throwStatement, classType, topElement)) continue;
                unhandled.add(classType);
            }
        }
        SmartList<PsiClassType> smartList = unhandled;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return smartList;
    }

    @NotNull
    private static List<PsiType> getPreciseThrowTypes(@Nullable PsiExpression expression) {
        PsiType type2;
        PsiElement target;
        if ((expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression).resolve()) != null && PsiUtil.isCatchParameter(target)) {
            List<PsiType> list2 = ((PsiCatchSection)target.getParent()).getPreciseCatchTypes();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getPreciseThrowTypes"));
            }
            return list2;
        }
        if (expression != null && (type2 = expression.getType()) != null) {
            List<PsiType> list3 = Collections.singletonList(type2);
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getPreciseThrowTypes"));
            }
            return list3;
        }
        List<PsiType> list4 = Collections.emptyList();
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getPreciseThrowTypes"));
        }
        return list4;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethod method, PsiElement element, PsiElement topElement, @NotNull PsiSubstitutor substitutor2) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        if (ExceptionUtil.isArrayClone(method, element)) {
            List<PsiClassType> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
            }
            return list2;
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        List<PsiClassType> list3 = ExceptionUtil.getUnhandledExceptions(element, topElement, substitutor2, referencedTypes);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return list3;
    }

    private static List<PsiClassType> getUnhandledExceptions(PsiElement element, PsiElement topElement, PsiSubstitutor substitutor2, PsiClassType[] referencedTypes) {
        if (referencedTypes.length > 0) {
            ArrayList<PsiClassType> result2 = ContainerUtil.newArrayList();
            for (PsiClassType referencedType : referencedTypes) {
                PsiType type2 = PsiClassImplUtil.correctType(GenericsUtil.eliminateWildcards(substitutor2.substitute(referencedType), false), element.getResolveScope());
                if (!(type2 instanceof PsiClassType)) continue;
                PsiClassType classType = (PsiClassType)type2;
                PsiClass exceptionClass = ((PsiClassType)type2).resolve();
                if (exceptionClass == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.isHandled(element, classType, topElement)) continue;
                result2.add((PsiClassType)type2);
            }
            return result2;
        }
        return Collections.emptyList();
    }

    private static boolean isArrayClone(@NotNull PsiMethod method, PsiElement element) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExceptionUtil", "isArrayClone"));
        }
        if (!method.getName().equals("clone")) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodCallExpression = (PsiMethodReferenceExpression)element;
            PsiExpression qualifierExpression = methodCallExpression.getQualifierExpression();
            return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
        return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
    }

    public static boolean isUncheckedException(@NotNull PsiClassType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ExceptionUtil", "isUncheckedException"));
        }
        return InheritanceUtil.isInheritor(type2, "java.lang.RuntimeException") || InheritanceUtil.isInheritor(type2, "java.lang.Error");
    }

    public static boolean isUncheckedExceptionOrSuperclass(@NotNull PsiClassType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ExceptionUtil", "isUncheckedExceptionOrSuperclass"));
        }
        return ExceptionUtil.isGeneralExceptionType(type2) || ExceptionUtil.isUncheckedException(type2);
    }

    public static boolean isGeneralExceptionType(@NotNull PsiType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ExceptionUtil", "isGeneralExceptionType"));
        }
        String canonicalText = type2.getCanonicalText();
        return "java.lang.Throwable".equals(canonicalText) || "java.lang.Exception".equals(canonicalText);
    }

    private static boolean isHandled(@Nullable PsiElement element, @NotNull PsiClassType exceptionType, PsiElement topElement) {
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "isHandled"));
        }
        if (element == null || element.getParent() == topElement || element.getParent() == null) {
            return false;
        }
        PsiElement parent2 = element.getParent();
        if (parent2 instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent2;
            return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType);
        }
        if (parent2 instanceof PsiClass) {
            return parent2 instanceof PsiAnonymousClass && ExceptionUtil.isHandled(parent2, exceptionType, topElement);
        }
        if (parent2 instanceof PsiLambdaExpression || parent2 instanceof PsiMethodReferenceExpression && element == ((PsiMethodReferenceExpression)parent2).getReferenceNameElement()) {
            PsiType interfaceType = ((PsiFunctionalExpression)parent2).getFunctionalInterfaceType();
            return ExceptionUtil.isDeclaredBySAMMethod(exceptionType, interfaceType);
        }
        if (parent2 instanceof PsiClassInitializer) {
            if (((PsiClassInitializer)parent2).hasModifierProperty("static")) {
                return false;
            }
            if (!(parent2.getParent() instanceof PsiAnonymousClass)) {
                PsiClass aClass2 = ((PsiClassInitializer)parent2).getContainingClass();
                return ExceptionUtil.areAllConstructorsThrow(aClass2, exceptionType);
            }
        } else if (parent2 instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)parent2;
            if (tryStatement.getTryBlock() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            if (tryStatement.getResourceList() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
                return true;
            }
        } else {
            if (parent2 instanceof JavaCodeFragment) {
                JavaCodeFragment codeFragment = (JavaCodeFragment)parent2;
                JavaCodeFragment.ExceptionHandler exceptionHandler = codeFragment.getExceptionHandler();
                return exceptionHandler != null && exceptionHandler.isHandledException(exceptionType);
            }
            if (PsiImplUtil.isInServerPage(parent2) && parent2 instanceof PsiFile) {
                return true;
            }
            if (parent2 instanceof PsiFile) {
                return false;
            }
            if (parent2 instanceof PsiField && ((PsiField)parent2).getInitializer() == element) {
                PsiClass aClass3 = ((PsiField)parent2).getContainingClass();
                if (aClass3 != null && !(aClass3 instanceof PsiAnonymousClass) && !((PsiField)parent2).hasModifierProperty("static")) {
                    return ExceptionUtil.areAllConstructorsThrow(aClass3, exceptionType);
                }
            } else {
                for (CustomExceptionHandler exceptionHandler : Extensions.getExtensions(CustomExceptionHandler.KEY)) {
                    if (!exceptionHandler.isHandled(element, exceptionType, topElement)) continue;
                    return true;
                }
            }
        }
        return ExceptionUtil.isHandled(parent2, exceptionType, topElement);
    }

    private static boolean isDeclaredBySAMMethod(@NotNull PsiClassType exceptionType, @Nullable PsiType interfaceType) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "isDeclaredBySAMMethod"));
        }
        if (interfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(interfaceType))) != null) {
            return ExceptionUtil.isHandledByMethodThrowsClause(interfaceMethod, exceptionType, LambdaUtil.getSubstitutor(interfaceMethod, resolveResult));
        }
        return true;
    }

    private static boolean areAllConstructorsThrow(@Nullable PsiClass aClass2, @NotNull PsiClassType exceptionType) {
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "areAllConstructorsThrow"));
        }
        if (aClass2 == null) {
            return false;
        }
        PsiMethod[] constructors2 = aClass2.getConstructors();
        boolean thrown = constructors2.length != 0;
        for (PsiMethod constructor : constructors2) {
            if (ExceptionUtil.isHandledByMethodThrowsClause(constructor, exceptionType)) continue;
            thrown = false;
            break;
        }
        return thrown;
    }

    private static boolean isCaught(@NotNull PsiTryStatement tryStatement, @NotNull PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        if (tryStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryStatement", "com/intellij/codeInsight/ExceptionUtil", "isCaught"));
        }
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "isCaught"));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
            return true;
        }
        for (PsiParameter parameter : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter.getType();
            if (!paramType.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static boolean blockCompletesAbruptly(@NotNull PsiCodeBlock finallyBlock) {
        if (finallyBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finallyBlock", "com/intellij/codeInsight/ExceptionUtil", "blockCompletesAbruptly"));
        }
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow(finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
            if (!BitUtil.isSet(completionReasons, 1)) {
                return true;
            }
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return false;
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExceptionUtil", "isHandledByMethodThrowsClause"));
        }
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "isHandledByMethodThrowsClause"));
        }
        return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType, PsiSubstitutor.EMPTY);
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, PsiSubstitutor substitutor2) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExceptionUtil", "isHandledByMethodThrowsClause"));
        }
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "isHandledByMethodThrowsClause"));
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, substitutor2);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes, PsiSubstitutor substitutor2) {
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "isHandledBy"));
        }
        if (referencedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedTypes", "com/intellij/codeInsight/ExceptionUtil", "isHandledBy"));
        }
        for (PsiClassType classType : referencedTypes) {
            PsiType psiType = substitutor2.substitute(classType);
            if (psiType == null || !psiType.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }
}

