/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileMoveEvent
extends VirtualFileEvent {
    private final VirtualFile myOldParent;
    private final VirtualFile myNewParent;

    public VirtualFileMoveEvent(@Nullable Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile oldParent, @NotNull VirtualFile newParent) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/VirtualFileMoveEvent", "<init>"));
        }
        if (oldParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldParent", "com/intellij/openapi/vfs/VirtualFileMoveEvent", "<init>"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/VirtualFileMoveEvent", "<init>"));
        }
        super(requestor, file2, file2.getName(), file2.getParent());
        this.myOldParent = oldParent;
        this.myNewParent = newParent;
    }

    @NotNull
    public VirtualFile getOldParent() {
        VirtualFile virtualFile = this.myOldParent;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFileMoveEvent", "getOldParent"));
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getNewParent() {
        VirtualFile virtualFile = this.myNewParent;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFileMoveEvent", "getNewParent"));
        }
        return virtualFile;
    }
}

