/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.output;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.output.OutputFile;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/output/SimpleOutputBinaryFile;", "Lorg/jetbrains/kotlin/backend/common/output/OutputFile;", "sourceFiles", "", "Ljava/io/File;", "relativePath", "", "content", "", "(Ljava/util/List;Ljava/lang/String;[B)V", "getRelativePath", "()Ljava/lang/String;", "getSourceFiles", "()Ljava/util/List;", "asByteArray", "asText", "toString", "kotlin-compiler"})
public final class SimpleOutputBinaryFile
implements OutputFile {
    @NotNull
    private final List<File> sourceFiles;
    @NotNull
    private final String relativePath;
    private final byte[] content;

    @Override
    @NotNull
    public byte[] asByteArray() {
        return this.content;
    }

    @Override
    @NotNull
    public String asText() {
        byte[] byArray = this.content;
        return new String(byArray, Charsets.UTF_8);
    }

    @NotNull
    public String toString() {
        return this.getRelativePath() + " (compiled from " + this.getSourceFiles() + ")";
    }

    @Override
    @NotNull
    public List<File> getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    @NotNull
    public String getRelativePath() {
        return this.relativePath;
    }

    public SimpleOutputBinaryFile(@NotNull List<? extends File> sourceFiles2, @NotNull String relativePath, @NotNull byte[] content) {
        Intrinsics.checkParameterIsNotNull(sourceFiles2, "sourceFiles");
        Intrinsics.checkParameterIsNotNull(relativePath, "relativePath");
        Intrinsics.checkParameterIsNotNull(content, "content");
        this.sourceFiles = sourceFiles2;
        this.relativePath = relativePath;
        this.content = content;
    }
}

