/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.JvmRuntimeVersionsConsistencyChecker;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.config.MavenComparableVersion;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004?@ABB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J$\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J \u0010\u001f\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(H\u0002J \u0010)\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001d0$H\u0002J\u0018\u0010+\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010,\u001a\u00020(2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020%H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0006H\u0002J\u0012\u00103\u001a\u00020\u00192\b\u00104\u001a\u0004\u0018\u000105H\u0002J'\u00106\u001a\u0002H7\"\u0004\b\u0000\u00107*\u0004\u0018\u0001H72\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000608H\u0002\u00a2\u0006\u0002\u00109J\f\u0010:\u001a\u00020\u0004*\u000205H\u0002J(\u0010;\u001a\u00020 *\u00020\u001b2\b\u0010<\u001a\u0004\u0018\u00010%2\u0006\u00102\u001a\u00020\u00062\b\b\u0002\u0010=\u001a\u00020>H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker;", "", "()V", "CURRENT_COMPILER_VERSION", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "KOTLIN_REFLECT_MODULE", "", "KOTLIN_RUNTIME_COMPONENT_ATTRIBUTE", "KOTLIN_RUNTIME_COMPONENT_CORE", "KOTLIN_RUNTIME_COMPONENT_MAIN", "KOTLIN_STDLIB_MODULE", "KOTLIN_VERSION_ATTRIBUTE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MANIFEST_KOTLIN_RUNTIME_COMPONENT", "MANIFEST_KOTLIN_RUNTIME_COMPONENT_CORE", "MANIFEST_KOTLIN_RUNTIME_COMPONENT_MAIN", "MANIFEST_KOTLIN_VERSION_ATTRIBUTE", "MANIFEST_KOTLIN_VERSION_VALUE", "MANIFEST_MF", "META_INF", "RUNTIME_IMPLEMENTATION_TITLES", "", "checkCompatibleWithApiVersion", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "jar", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$KotlinLibraryFile;", "apiVersion", "checkCompilerClasspathConsistency", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "classpathJarRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency;", "runtimeJarsInfo", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$RuntimeJarsInfo;", "checkMatchingVersionsAndGetRuntimeVersion", "jars", "checkNotNewerThanCompiler", "collectRuntimeJarsInfo", "determineFileKind", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind;", "jarRoot", "fatal", "", "message", "isGenuineKotlinRuntime", "manifest", "Ljava/util/jar/Manifest;", "assertNotNull", "T", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getKotlinLanguageVersion", "issue", "file", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "ClasspathConsistency", "FileKind", "KotlinLibraryFile", "RuntimeJarsInfo", "kotlin-compiler"})
public final class JvmRuntimeVersionsConsistencyChecker {
    private static final Logger LOG;
    private static final Set<String> RUNTIME_IMPLEMENTATION_TITLES;
    private static final String KOTLIN_VERSION_ATTRIBUTE;
    private static final MavenComparableVersion CURRENT_COMPILER_VERSION;
    private static final String KOTLIN_RUNTIME_COMPONENT_ATTRIBUTE;
    private static final String KOTLIN_RUNTIME_COMPONENT_CORE;
    private static final String KOTLIN_RUNTIME_COMPONENT_MAIN;
    public static final JvmRuntimeVersionsConsistencyChecker INSTANCE;

    private final Void fatal(String message) {
        LOG.error(message);
        throw (Throwable)((Object)new AssertionError((Object)message));
    }

    private final <T> T assertNotNull(@Nullable T $receiver, Function0<String> message) {
        if ($receiver == null) {
            Void void_ = this.fatal(message.invoke());
            throw null;
        }
        return $receiver;
    }

    public final void checkCompilerClasspathConsistency(@NotNull MessageCollector messageCollector, @NotNull CompilerConfiguration configuration, @NotNull List<? extends VirtualFile> classpathJarRoots) {
        Object actualApi;
        Intrinsics.checkParameterIsNotNull(messageCollector, "messageCollector");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(classpathJarRoots, "classpathJarRoots");
        RuntimeJarsInfo runtimeJarsInfo = this.collectRuntimeJarsInfo(classpathJarRoots);
        if (runtimeJarsInfo.getJars().isEmpty()) {
            return;
        }
        LanguageVersionSettings languageVersionSettings = configuration.get(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS);
        Object object = languageVersionSettings;
        if (object == null || (object = object.getApiVersion()) == null || (object = ((ApiVersion)object).getVersion()) == null) {
            object = CURRENT_COMPILER_VERSION;
        }
        Object apiVersion = object;
        ClasspathConsistency consistency = this.checkCompilerClasspathConsistency(messageCollector, (MavenComparableVersion)apiVersion, runtimeJarsInfo);
        if (consistency instanceof ClasspathConsistency.InconsistentWithApiVersion) {
            MavenComparableVersion actualRuntimeVersion = ((ClasspathConsistency.InconsistentWithApiVersion)consistency).getActualRuntimeVersion();
            JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, null, "Runtime JAR files in the classpath have the version " + actualRuntimeVersion + ", " + ("which is older than the API version " + apiVersion + ". ") + ("Consider using the runtime of version " + apiVersion + ", or pass '-api-version " + actualRuntimeVersion + "' explicitly to ") + ("restrict the available APIs to the runtime of version " + actualRuntimeVersion + ". ") + ("You can also pass '-language-version " + actualRuntimeVersion + "' instead, which will restrict ") + "not only the APIs to the specified version, but also the language features. " + "Alternatively, you can use '-Xskip-runtime-version-check' to suppress this warning", null, 4, null);
            String string = actualRuntimeVersion.toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "actualRuntimeVersion.toString()");
            actualApi = ApiVersion.Companion.parse(string);
            if (actualApi != null) {
                LanguageVersionSettingsImpl languageVersionSettingsImpl;
                if (languageVersionSettings == null) {
                    languageVersionSettingsImpl = new LanguageVersionSettingsImpl(LanguageVersionSettingsImpl.DEFAULT.getLanguageVersion(), (ApiVersion)actualApi, CollectionsKt.listOf(LanguageFeature.WarnOnCoroutines), false, 8, null);
                } else {
                    ApiVersion inferredApiVersion = languageVersionSettings.isApiVersionExplicit() ? languageVersionSettings.getApiVersion() : (ApiVersion)ComparisonsKt.minOf((Comparable)languageVersionSettings.getApiVersion(), (Comparable)actualApi);
                    languageVersionSettingsImpl = new LanguageVersionSettingsImpl(languageVersionSettings.getLanguageVersion(), inferredApiVersion, languageVersionSettings.getAdditionalFeatures(), false);
                }
                LanguageVersionSettingsImpl newSettings = languageVersionSettingsImpl;
                this.issue(messageCollector, null, "Old runtime has been found in the classpath. " + ("Initial language version settings: " + languageVersionSettings + ". ") + ("Updated language version settings: " + newSettings), CompilerMessageSeverity.LOGGING);
                configuration.put(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS, newSettings);
            } else {
                JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, null, "Could not parse runtime JAR version: " + actualRuntimeVersion, null, 4, null);
            }
        } else if (Intrinsics.areEqual(consistency, ClasspathConsistency.Consistent.INSTANCE) ^ true) {
            JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, null, "Some runtime JAR files in the classpath have an incompatible version. Consider removing them from the classpath or use '-Xskip-runtime-version-check' to suppress this warning", null, 4, null);
        }
        List<VirtualFile> librariesWithBundled = runtimeJarsInfo.getOtherLibrariesWithBundledRuntime();
        actualApi = librariesWithBundled;
        if (!actualApi.isEmpty()) {
            JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, null, "Some JAR files in the classpath have the Kotlin Runtime library bundled into them. This may cause difficult to debug problems if there's a different version of the Kotlin Runtime library in the classpath. Consider removing these libraries from the classpath or use '-Xskip-runtime-version-check' to suppress this warning", null, 4, null);
            for (VirtualFile library : librariesWithBundled) {
                JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, library, "Library has Kotlin runtime bundled into it", null, 4, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ClasspathConsistency checkCompilerClasspathConsistency(MessageCollector messageCollector, MavenComparableVersion apiVersion, RuntimeJarsInfo runtimeJarsInfo) {
        boolean bl;
        MavenComparableVersion runtimeVersion;
        block9: {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            boolean bl2;
            Boolean bl3;
            Collection collection;
            block8: {
                Iterator $receiver$iv$iv2;
                Iterable $receiver$iv2;
                Iterable iterable = $receiver$iv2 = (Iterable)runtimeJarsInfo.getCoreJars();
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                Iterator iterator2 = $receiver$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    Object item$iv$iv = iterator2.next();
                    KotlinLibraryFile kotlinLibraryFile = (KotlinLibraryFile)item$iv$iv;
                    collection = destination$iv$iv;
                    bl3 = INSTANCE.checkNotNewerThanCompiler(messageCollector, (KotlinLibraryFile)it);
                    collection.add(bl3);
                }
                $receiver$iv2 = (List)destination$iv$iv;
                for (Object element$iv : $receiver$iv2) {
                    boolean it = (Boolean)element$iv;
                    if (!it) continue;
                    bl2 = true;
                    break block8;
                }
                bl2 = false;
            }
            if (bl2) {
                return ClasspathConsistency.InconsistentWithCompilerVersion.INSTANCE;
            }
            List<KotlinLibraryFile> jars = runtimeJarsInfo.getJars();
            if (jars.isEmpty()) {
                return ClasspathConsistency.Consistent.INSTANCE;
            }
            MavenComparableVersion mavenComparableVersion = this.checkMatchingVersionsAndGetRuntimeVersion(messageCollector, jars);
            if (mavenComparableVersion == null) {
                return ClasspathConsistency.InconsistentBecauseOfRuntimesWithDifferentVersions.INSTANCE;
            }
            runtimeVersion = mavenComparableVersion;
            Iterable it = $receiver$iv = (Iterable)jars;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it2;
                KotlinLibraryFile $i$f$mapTo = (KotlinLibraryFile)item$iv$iv;
                collection = destination$iv$iv;
                bl3 = INSTANCE.checkCompatibleWithApiVersion(messageCollector, (KotlinLibraryFile)it2, apiVersion);
                collection.add(bl3);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                boolean it3 = (Boolean)element$iv;
                if (!it3) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        if (bl) {
            return new ClasspathConsistency.InconsistentWithApiVersion(runtimeVersion);
        }
        return ClasspathConsistency.Consistent.INSTANCE;
    }

    private final boolean checkNotNewerThanCompiler(MessageCollector messageCollector, KotlinLibraryFile jar) {
        if (jar.getVersion().compareTo(CURRENT_COMPILER_VERSION) > 0) {
            this.issue(messageCollector, jar.getFile(), "Runtime JAR file has version " + jar.getVersion() + " which is newer than compiler version " + CURRENT_COMPILER_VERSION, CompilerMessageSeverity.ERROR);
            return true;
        }
        return false;
    }

    private final boolean checkCompatibleWithApiVersion(MessageCollector messageCollector, KotlinLibraryFile jar, MavenComparableVersion apiVersion) {
        if (jar.getVersion().compareTo(apiVersion) < 0) {
            JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, jar.getFile(), "Runtime JAR file has version " + jar.getVersion() + " which is older than required for API version " + apiVersion, null, 4, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final MavenComparableVersion checkMatchingVersionsAndGetRuntimeVersion(MessageCollector messageCollector, List<KotlinLibraryFile> jars) {
        Object v6;
        KotlinLibraryFile it;
        void $receiver$iv$iv;
        Object minElem$iv;
        Object v5;
        void $receiver$iv;
        Iterable $receiver$iv3;
        StringBuilder $receiver;
        MavenComparableVersion newestVersion;
        Object v$iv;
        Object e$iv;
        Iterator<KotlinLibraryFile> maxValue$iv;
        Object v2;
        Object v1;
        boolean bl;
        Collection collection = jars;
        boolean bl2 = bl = !collection.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "'jars' must not be empty";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Iterable $receiver$iv2 = jars;
        Iterator iterator$iv = $receiver$iv2.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv2 = iterator$iv.next();
            KotlinLibraryFile kotlinLibraryFile = (KotlinLibraryFile)minElem$iv2;
            Comparable comparable = kotlinLibraryFile.getVersion();
            while (iterator$iv.hasNext()) {
                void var7_12;
                Object e$iv2 = iterator$iv.next();
                KotlinLibraryFile it4 = (KotlinLibraryFile)e$iv2;
                Comparable v$iv2 = it4.getVersion();
                if (var7_12.compareTo(v$iv2) <= 0) continue;
                minElem$iv2 = e$iv2;
                Comparable comparable2 = v$iv2;
            }
            v1 = minElem$iv2;
        }
        if (v1 == null) {
            Intrinsics.throwNpe();
        }
        MavenComparableVersion oldestVersion = ((KotlinLibraryFile)v1).getVersion();
        Object $receiver$iv22 = jars;
        Iterator iterator$iv2 = $receiver$iv22.iterator();
        if (!iterator$iv2.hasNext()) {
            v2 = null;
        } else {
            void var7_15;
            Object t = iterator$iv2.next();
            KotlinLibraryFile it6 = (KotlinLibraryFile)t;
            maxValue$iv = it6.getVersion();
            while (iterator$iv2.hasNext()) {
                e$iv = iterator$iv2.next();
                KotlinLibraryFile it3 = (KotlinLibraryFile)e$iv;
                v$iv = it3.getVersion();
                if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                Object t2 = e$iv;
                maxValue$iv = v$iv;
            }
            v2 = var7_15;
        }
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual(oldestVersion, newestVersion = ((KotlinLibraryFile)v2).getVersion())) {
            return oldestVersion;
        }
        VirtualFile virtualFile = null;
        MessageCollector messageCollector2 = messageCollector;
        JvmRuntimeVersionsConsistencyChecker jvmRuntimeVersionsConsistencyChecker = this;
        $receiver$iv22 = new StringBuilder();
        StringBuilder stringBuilder = $receiver = (StringBuilder)$receiver$iv22;
        maxValue$iv = "Runtime JAR files in the classpath should have the same version. These files were found in the classpath:";
        StringsKt.appendln(stringBuilder.append((String)((Object)maxValue$iv)));
        for (KotlinLibraryFile kotlinLibraryFile : jars) {
            e$iv = $receiver;
            v$iv = "    " + kotlinLibraryFile.getFile().getPath() + " (version " + kotlinLibraryFile.getVersion() + ")";
            StringsKt.appendln(((StringBuilder)e$iv).append((String)v$iv));
        }
        String string = ((StringBuilder)$receiver$iv22).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        String string2 = string;
        Object object = $receiver$iv22 = string2;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string2 = ((Object)StringsKt.trimEnd((CharSequence)object)).toString();
        JvmRuntimeVersionsConsistencyChecker.issue$default(jvmRuntimeVersionsConsistencyChecker, messageCollector2, virtualFile, string2, null, 4, null);
        Iterable iterable = $receiver$iv3 = (Iterable)jars;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : iterable) {
            KotlinLibraryFile it2 = (KotlinLibraryFile)element$iv$iv;
            if (!StringsKt.startsWith$default(it2.getFile().getName(), "kotlin-reflect", false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv3 = (List)destination$iv$iv;
        Iterator iterator2 = $receiver$iv.iterator();
        if (!iterator2.hasNext()) {
            v5 = null;
        } else {
            minElem$iv = iterator2.next();
            KotlinLibraryFile it2 = (KotlinLibraryFile)minElem$iv;
            Comparable minValue$iv = it2.getVersion();
            while (iterator2.hasNext()) {
                Object e$iv3 = iterator2.next();
                KotlinLibraryFile it3 = (KotlinLibraryFile)e$iv3;
                Comparable v$iv3 = it3.getVersion();
                if (minValue$iv.compareTo(v$iv3) <= 0) continue;
                minElem$iv = e$iv3;
                minValue$iv = v$iv3;
            }
            v5 = minElem$iv;
        }
        KotlinLibraryFile minReflectJar = v5;
        Iterable iterable2 = jars;
        minElem$iv = iterable2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (KotlinLibraryFile)element$iv$iv;
            if (!(StringsKt.startsWith$default(it.getFile().getName(), "kotlin-runtime", false, 2, null) || StringsKt.startsWith$default(it.getFile().getName(), "kotlin-stdlib", false, 2, null))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable iterable3 = (List)destination$iv$iv2;
        Iterator iterator$iv4 = iterable3.iterator();
        if (!iterator$iv4.hasNext()) {
            v6 = null;
        } else {
            Object maxElem$iv2 = iterator$iv4.next();
            KotlinLibraryFile it4 = (KotlinLibraryFile)maxElem$iv2;
            Comparable maxValue$iv2 = it4.getVersion();
            while (iterator$iv4.hasNext()) {
                Object e$iv4 = iterator$iv4.next();
                it = (KotlinLibraryFile)e$iv4;
                Comparable v$iv4 = it.getVersion();
                if (maxValue$iv2.compareTo(v$iv4) >= 0) continue;
                maxElem$iv2 = e$iv4;
                maxValue$iv2 = v$iv4;
            }
            v6 = maxElem$iv2;
        }
        KotlinLibraryFile maxStdlibJar = v6;
        if (minReflectJar != null && maxStdlibJar != null && minReflectJar.getVersion().compareTo(maxStdlibJar.getVersion()) < 0) {
            JvmRuntimeVersionsConsistencyChecker.issue$default(this, messageCollector, null, "Consider providing an explicit dependency on kotlin-reflect " + maxStdlibJar.getVersion() + " to prevent strange errors", null, 4, null);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final void issue(@NotNull MessageCollector $receiver, VirtualFile file, String message, CompilerMessageSeverity severity) {
        v0 = $receiver;
        v1 = severity;
        v2 = message;
        v3 = CompilerMessageLocation.Companion;
        v4 = file;
        if (v4 == null) ** GOTO lbl-1000
        var5_5 = v4;
        var11_6 = v3;
        var10_7 = v2;
        var9_8 = v1;
        var8_9 = v0;
        p1 = var5_5;
        var12_11 = VfsUtilCore.virtualToIoFile(p1);
        v0 = var8_9;
        v1 = var9_8;
        v2 = var10_7;
        v3 = var11_6;
        v4 = var12_11;
        if (v4 != null) {
            v5 = v4.getPath();
        } else lbl-1000:
        // 2 sources

        {
            v5 = null;
        }
        v0.report(v1, v2, v3.create(v5));
    }

    static /* bridge */ /* synthetic */ void issue$default(JvmRuntimeVersionsConsistencyChecker jvmRuntimeVersionsConsistencyChecker, MessageCollector messageCollector, VirtualFile virtualFile, String string, CompilerMessageSeverity compilerMessageSeverity, int n, Object object) {
        if ((n & 4) != 0) {
            compilerMessageSeverity = CompilerMessageSeverity.STRONG_WARNING;
        }
        jvmRuntimeVersionsConsistencyChecker.issue(messageCollector, virtualFile, string, compilerMessageSeverity);
    }

    private final RuntimeJarsInfo collectRuntimeJarsInfo(List<? extends VirtualFile> classpathJarRoots) {
        ArrayList<KotlinLibraryFile> jars = new ArrayList<KotlinLibraryFile>(2);
        ArrayList<KotlinLibraryFile> coreJars = new ArrayList<KotlinLibraryFile>(2);
        ArrayList<VirtualFile> otherLibrariesWithBundledRuntime = new ArrayList<VirtualFile>(0);
        HashSet<String> visitedPaths = new HashSet<String>();
        for (VirtualFile virtualFile : classpathJarRoots) {
            VirtualFile jarFile;
            FileKind fileKind = this.determineFileKind(virtualFile);
            if (fileKind instanceof FileKind.Irrelevant) continue;
            if (VfsUtilCore.getVirtualFileForJar(virtualFile) == null) {
                continue;
            }
            if (!visitedPaths.add(jarFile.getPath())) continue;
            FileKind fileKind2 = fileKind;
            if (fileKind2 instanceof FileKind.Runtime) {
                VirtualFile virtualFile2 = jarFile;
                Intrinsics.checkExpressionValueIsNotNull(virtualFile2, "jarFile");
                KotlinLibraryFile file2 = new KotlinLibraryFile(virtualFile2, ((FileKind.Runtime)fileKind).getVersion());
                jars.add(file2);
                if (!((FileKind.Runtime)fileKind).isCoreComponent()) continue;
                coreJars.add(file2);
                continue;
            }
            if (Intrinsics.areEqual(fileKind2, FileKind.OldRuntime.INSTANCE)) {
                VirtualFile virtualFile3 = jarFile;
                Intrinsics.checkExpressionValueIsNotNull(virtualFile3, "jarFile");
                jars.add(new KotlinLibraryFile(virtualFile3, ApiVersion.KOTLIN_1_0.getVersion()));
                continue;
            }
            if (!Intrinsics.areEqual(fileKind2, FileKind.LibraryWithBundledRuntime.INSTANCE)) continue;
            otherLibrariesWithBundledRuntime.add(jarFile);
        }
        return new RuntimeJarsInfo((List<KotlinLibraryFile>)jars, (List<KotlinLibraryFile>)coreJars, (List<? extends VirtualFile>)otherLibrariesWithBundledRuntime);
    }

    private final FileKind determineFileKind(VirtualFile jarRoot) {
        String runtimeComponent;
        VirtualFile virtualFile;
        VirtualFile manifestFile = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF");
        try {
            Manifest manifest;
            VirtualFile virtualFile2 = manifestFile;
            if (virtualFile2 != null) {
                VirtualFile it = virtualFile = virtualFile2;
                manifest = new Manifest(it.getInputStream());
            } else {
                manifest = null;
            }
            virtualFile = manifest;
        }
        catch (IOException e) {
            return FileKind.Irrelevant.INSTANCE;
        }
        VirtualFile manifest = virtualFile;
        Cloneable cloneable2 = manifest;
        String string = runtimeComponent = cloneable2 != null && (cloneable2 = ((Manifest)cloneable2).getMainAttributes()) != null ? ((Attributes)cloneable2).getValue(KOTLIN_RUNTIME_COMPONENT_ATTRIBUTE) : null;
        return Intrinsics.areEqual(string, KOTLIN_RUNTIME_COMPONENT_MAIN) ? (FileKind)new FileKind.Runtime(this.getKotlinLanguageVersion((Manifest)((Object)manifest)), false) : (Intrinsics.areEqual(string, KOTLIN_RUNTIME_COMPONENT_CORE) ? (FileKind)new FileKind.Runtime(this.getKotlinLanguageVersion((Manifest)((Object)manifest)), true) : (Intrinsics.areEqual(string, null) ? (jarRoot.findFileByRelativePath("META-INF/kotlin-stdlib.kotlin_module") == null && jarRoot.findFileByRelativePath("META-INF/kotlin-reflection.kotlin_module") == null ? (FileKind)FileKind.Irrelevant.INSTANCE : (this.isGenuineKotlinRuntime((Manifest)((Object)manifest)) ? (FileKind)FileKind.OldRuntime.INSTANCE : (FileKind)FileKind.LibraryWithBundledRuntime.INSTANCE)) : (FileKind)FileKind.Irrelevant.INSTANCE));
    }

    private final boolean isGenuineKotlinRuntime(Manifest manifest) {
        return manifest != null && RUNTIME_IMPLEMENTATION_TITLES.contains(manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE));
    }

    private final MavenComparableVersion getKotlinLanguageVersion(@NotNull Manifest $receiver) {
        String string;
        String p1;
        ApiVersion.Companion companion;
        Object object = $receiver.getMainAttributes().getValue(KOTLIN_VERSION_ATTRIBUTE);
        if (object == null || (object = (companion = ApiVersion.Companion).parse(p1 = (string = object))) == null) {
            object = ApiVersion.KOTLIN_1_0;
        }
        return ((ApiVersion)object).getVersion();
    }

    private JvmRuntimeVersionsConsistencyChecker() {
        Object object;
        INSTANCE = this;
        LOG = Logger.getInstance(JvmRuntimeVersionsConsistencyChecker.class);
        RUNTIME_IMPLEMENTATION_TITLES = SetsKt.setOf(new String[]{"kotlin-runtime", "kotlin-stdlib", "kotlin-reflect", "Kotlin Runtime", "Kotlin Standard Library", "Kotlin Reflect"});
        try {
            Properties properties2;
            object = JvmRuntimeVersionsConsistencyChecker.class.getResourceAsStream("/kotlinManifest.properties");
            InputStream input = object;
            Properties $receiver = properties2 = new Properties();
            $receiver.load(input);
            object = properties2;
        }
        catch (Exception e) {
            LOG.error(e);
            throw (Throwable)e;
        }
        Object manifestProperties = object;
        KOTLIN_VERSION_ATTRIBUTE = this.assertNotNull(((Properties)manifestProperties).getProperty("manifest.impl.attribute.kotlin.version"), 1.INSTANCE);
        object = this;
        JvmRuntimeVersionsConsistencyChecker $receiver = (JvmRuntimeVersionsConsistencyChecker)object;
        String kotlinVersionString2 = $receiver.assertNotNull(((Properties)manifestProperties).getProperty("manifest.impl.value.kotlin.version"), 2.kotlinVersionString.1.INSTANCE);
        CURRENT_COMPILER_VERSION = new MavenComparableVersion(kotlinVersionString2);
        if (Intrinsics.areEqual(CURRENT_COMPILER_VERSION, ApiVersion.LATEST.getVersion()) ^ true) {
            Void void_ = this.fatal("Kotlin compiler version " + CURRENT_COMPILER_VERSION + " in kotlinManifest.properties doesn't match " + ApiVersion.LATEST);
            throw null;
        }
        KOTLIN_RUNTIME_COMPONENT_ATTRIBUTE = this.assertNotNull(((Properties)manifestProperties).getProperty("manifest.impl.attribute.kotlin.runtime.component"), 3.INSTANCE);
        KOTLIN_RUNTIME_COMPONENT_CORE = this.assertNotNull(((Properties)manifestProperties).getProperty("manifest.impl.value.kotlin.runtime.component.core"), 4.INSTANCE);
        KOTLIN_RUNTIME_COMPONENT_MAIN = this.assertNotNull(((Properties)manifestProperties).getProperty("manifest.impl.value.kotlin.runtime.component.main"), 5.INSTANCE);
    }

    static {
        new JvmRuntimeVersionsConsistencyChecker();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$KotlinLibraryFile;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "version", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/config/MavenComparableVersion;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getVersion", "()Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "toString", "", "kotlin-compiler"})
    private static final class KotlinLibraryFile {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final MavenComparableVersion version;

        @NotNull
        public String toString() {
            return this.file.getName() + ":" + this.version;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final MavenComparableVersion getVersion() {
            return this.version;
        }

        public KotlinLibraryFile(@NotNull VirtualFile file2, @NotNull MavenComparableVersion version) {
            Intrinsics.checkParameterIsNotNull(file2, "file");
            Intrinsics.checkParameterIsNotNull(version, "version");
            this.file = file2;
            this.version = version;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$RuntimeJarsInfo;", "", "jars", "", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$KotlinLibraryFile;", "coreJars", "otherLibrariesWithBundledRuntime", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getCoreJars", "()Ljava/util/List;", "getJars", "getOtherLibrariesWithBundledRuntime", "kotlin-compiler"})
    private static final class RuntimeJarsInfo {
        @NotNull
        private final List<KotlinLibraryFile> jars;
        @NotNull
        private final List<KotlinLibraryFile> coreJars;
        @NotNull
        private final List<VirtualFile> otherLibrariesWithBundledRuntime;

        @NotNull
        public final List<KotlinLibraryFile> getJars() {
            return this.jars;
        }

        @NotNull
        public final List<KotlinLibraryFile> getCoreJars() {
            return this.coreJars;
        }

        @NotNull
        public final List<VirtualFile> getOtherLibrariesWithBundledRuntime() {
            return this.otherLibrariesWithBundledRuntime;
        }

        public RuntimeJarsInfo(@NotNull List<KotlinLibraryFile> jars, @NotNull List<KotlinLibraryFile> coreJars, @NotNull List<? extends VirtualFile> otherLibrariesWithBundledRuntime) {
            Intrinsics.checkParameterIsNotNull(jars, "jars");
            Intrinsics.checkParameterIsNotNull(coreJars, "coreJars");
            Intrinsics.checkParameterIsNotNull(otherLibrariesWithBundledRuntime, "otherLibrariesWithBundledRuntime");
            this.jars = jars;
            this.coreJars = coreJars;
            this.otherLibrariesWithBundledRuntime = otherLibrariesWithBundledRuntime;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency;", "", "()V", "Consistent", "InconsistentBecauseOfRuntimesWithDifferentVersions", "InconsistentWithApiVersion", "InconsistentWithCompilerVersion", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$Consistent;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$InconsistentWithApiVersion;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$InconsistentWithCompilerVersion;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$InconsistentBecauseOfRuntimesWithDifferentVersions;", "kotlin-compiler"})
    private static abstract class ClasspathConsistency {
        private ClasspathConsistency() {
        }

        public /* synthetic */ ClasspathConsistency(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$Consistent;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency;", "()V", "kotlin-compiler"})
        public static final class Consistent
        extends ClasspathConsistency {
            public static final Consistent INSTANCE;

            private Consistent() {
                super(null);
                INSTANCE = this;
            }

            static {
                new Consistent();
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$InconsistentWithApiVersion;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency;", "actualRuntimeVersion", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "(Lorg/jetbrains/kotlin/config/MavenComparableVersion;)V", "getActualRuntimeVersion", "()Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "kotlin-compiler"})
        public static final class InconsistentWithApiVersion
        extends ClasspathConsistency {
            @NotNull
            private final MavenComparableVersion actualRuntimeVersion;

            @NotNull
            public final MavenComparableVersion getActualRuntimeVersion() {
                return this.actualRuntimeVersion;
            }

            public InconsistentWithApiVersion(@NotNull MavenComparableVersion actualRuntimeVersion) {
                Intrinsics.checkParameterIsNotNull(actualRuntimeVersion, "actualRuntimeVersion");
                super(null);
                this.actualRuntimeVersion = actualRuntimeVersion;
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$InconsistentWithCompilerVersion;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency;", "()V", "kotlin-compiler"})
        public static final class InconsistentWithCompilerVersion
        extends ClasspathConsistency {
            public static final InconsistentWithCompilerVersion INSTANCE;

            private InconsistentWithCompilerVersion() {
                super(null);
                INSTANCE = this;
            }

            static {
                new InconsistentWithCompilerVersion();
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency$InconsistentBecauseOfRuntimesWithDifferentVersions;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$ClasspathConsistency;", "()V", "kotlin-compiler"})
        public static final class InconsistentBecauseOfRuntimesWithDifferentVersions
        extends ClasspathConsistency {
            public static final InconsistentBecauseOfRuntimesWithDifferentVersions INSTANCE;

            private InconsistentBecauseOfRuntimesWithDifferentVersions() {
                super(null);
                INSTANCE = this;
            }

            static {
                new InconsistentBecauseOfRuntimesWithDifferentVersions();
            }
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind;", "", "()V", "Irrelevant", "LibraryWithBundledRuntime", "OldRuntime", "Runtime", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$Runtime;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$OldRuntime;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$LibraryWithBundledRuntime;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$Irrelevant;", "kotlin-compiler"})
    private static abstract class FileKind {
        private FileKind() {
        }

        public /* synthetic */ FileKind(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$Runtime;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind;", "version", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "isCoreComponent", "", "(Lorg/jetbrains/kotlin/config/MavenComparableVersion;Z)V", "()Z", "getVersion", "()Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "kotlin-compiler"})
        public static final class Runtime
        extends FileKind {
            @NotNull
            private final MavenComparableVersion version;
            private final boolean isCoreComponent;

            @NotNull
            public final MavenComparableVersion getVersion() {
                return this.version;
            }

            public final boolean isCoreComponent() {
                return this.isCoreComponent;
            }

            public Runtime(@NotNull MavenComparableVersion version, boolean isCoreComponent) {
                Intrinsics.checkParameterIsNotNull(version, "version");
                super(null);
                this.version = version;
                this.isCoreComponent = isCoreComponent;
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$OldRuntime;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind;", "()V", "kotlin-compiler"})
        public static final class OldRuntime
        extends FileKind {
            public static final OldRuntime INSTANCE;

            private OldRuntime() {
                super(null);
                INSTANCE = this;
            }

            static {
                new OldRuntime();
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$LibraryWithBundledRuntime;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind;", "()V", "kotlin-compiler"})
        public static final class LibraryWithBundledRuntime
        extends FileKind {
            public static final LibraryWithBundledRuntime INSTANCE;

            private LibraryWithBundledRuntime() {
                super(null);
                INSTANCE = this;
            }

            static {
                new LibraryWithBundledRuntime();
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind$Irrelevant;", "Lorg/jetbrains/kotlin/cli/jvm/JvmRuntimeVersionsConsistencyChecker$FileKind;", "()V", "kotlin-compiler"})
        public static final class Irrelevant
        extends FileKind {
            public static final Irrelevant INSTANCE;

            private Irrelevant() {
                super(null);
                INSTANCE = this;
            }

            static {
                new Irrelevant();
            }
        }
    }
}

