(function(Prism) {

var javascript = Prism.util.clone(Prism.languages.javascript);

Prism.languages.jsx = Prism.languages.extend('markup', javascript);
Prism.languages.jsx.tag.pattern= /<\/?[\w:-]+\s*(?:\s+[\w:-]+(?:=(?:("|')(\\?[\w\W])*?\1|[^\s'">=]+|(\{[\w\W]*?\})))?\s*)*\/?>/i;

Prism.languages.jsx.tag.inside['attr-value'].pattern = /=[^\{](?:('|")[\w\W]*?(\1)|[^\s>]+)/i;

Prism.languages.insertBefore('inside', 'attr-value',{
	'script': {
		pattern: /=(\{[\w\W]*?\})/i,
		inside: {
			'function' : Prism.languages.javascript.function,
			'punctuation': /[={}[\];(),.:]/,
			'keyword':  Prism.languages.javascript.keyword
		},
		'alias': 'language-javascript'
	}
}, Prism.languages.jsx.tag);

}(Prism));
