/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.db;

import java.io.IOException;
import java.util.Date;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.json.JSONException;
import org.json.JSONObject;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class CouchDBHandler {
    private String protocol = "http";
    private String host = JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[9].getId(), "");
    private int port = JBroFuzz.PREFS.getInt(JBroFuzzPrefs.DBSETTINGS[10].getId(), 0);

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public String[] getDocumentIds(String dbName) {
        String[] documentIds = new String[]{};
        return documentIds;
    }

    private String sendGet(String url) {
        String responseBody = "";
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.useragent", (Object)"jbrofuzz");
        GetMethod method = new GetMethod(url);
        try {
            try {
                responseBody = method.getResponseBodyAsString();
            }
            catch (HttpException e) {
                e.printStackTrace();
                client.getHttpConnectionManager().closeIdleConnections(0L);
            }
            catch (IOException e) {
                e.printStackTrace();
                client.getHttpConnectionManager().closeIdleConnections(0L);
            }
        }
        finally {
            client.getHttpConnectionManager().closeIdleConnections(0L);
        }
        return responseBody;
    }

    private String sendPut(String url, String requestBody) {
        String responseBody = "";
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.useragent", (Object)"jbrofuzz");
        PutMethod method = new PutMethod(url);
        if (requestBody.length() > 0) {
            method.setRequestBody(requestBody);
        }
        try {
            try {
                responseBody = method.getResponseBodyAsString();
            }
            catch (HttpException e) {
                e.printStackTrace();
                client.getHttpConnectionManager().closeIdleConnections(0L);
            }
            catch (IOException e) {
                e.printStackTrace();
                client.getHttpConnectionManager().closeIdleConnections(0L);
            }
        }
        finally {
            client.getHttpConnectionManager().closeIdleConnections(0L);
        }
        return responseBody;
    }

    private String sendDelete(String url) {
        String responseBody = "";
        DeleteMethod method = new DeleteMethod(url);
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.useragent", (Object)"jbrofuzz");
        try {
            try {
                client.executeMethod((HttpMethod)method);
                responseBody = method.getResponseBodyAsString();
            }
            catch (HttpException e) {
                e.printStackTrace();
                client.getHttpConnectionManager().closeIdleConnections(0L);
            }
            catch (IOException e) {
                e.printStackTrace();
                client.getHttpConnectionManager().closeIdleConnections(0L);
            }
        }
        finally {
            client.getHttpConnectionManager().closeIdleConnections(0L);
        }
        return responseBody;
    }

    private int evaluateConfiguration() {
        if (this.getHost().equals("") || this.getHost().length() == 0) {
            return -1;
        }
        if (this.getProtocol().equals("") || this.getProtocol().length() == 0) {
            return -1;
        }
        if (this.getPort() == 0 || this.getPort() < 0) {
            return -1;
        }
        return 1;
    }

    public String createDB(String dbName) {
        String response = "";
        String dbNameReal = "";
        if (dbName.length() < 0 || dbName.equals("")) {
            Date dat = new Date();
            dbNameReal = "jbrfuzz_" + dat.getTime();
        } else {
            dbNameReal = dbName;
        }
        if (this.evaluateConfiguration() > 0) {
            String url = String.valueOf(this.getProtocol()) + "://" + this.getHost() + ":" + this.getPort() + "/" + dbNameReal;
            response = this.sendPut(url, "");
        } else {
            dbNameReal = "-1";
        }
        if (response.length() == 0 || response.toLowerCase().contains("error")) {
            dbNameReal = "-1";
        }
        return dbNameReal;
    }

    public int removeDB(String dbName) {
        String url;
        int returnCode = 1;
        String response = "";
        if (this.evaluateConfiguration() > 0 && (response = this.sendDelete(url = String.valueOf(this.getProtocol()) + "://" + this.getHost() + ":" + this.getPort() + "/" + dbName)).toLowerCase().contains("error")) {
            returnCode = -1;
        }
        return returnCode;
    }

    public int removeDocument(String dbName, String documentId) {
        int returnCode = 0;
        String response = "";
        if (this.evaluateConfiguration() > 0) {
            String url = String.valueOf(this.getProtocol()) + "://" + this.getHost() + ":" + this.getPort() + "/" + dbName + "/" + documentId;
            response = this.sendDelete(url);
        }
        if (response.toLowerCase().contains("error")) {
            returnCode = -1;
        }
        return returnCode;
    }

    public int store(String dbName, String documentId, JSONObject document) {
        int returnCode = 0;
        String response = "";
        String body = "";
        if (documentId.length() < 0 || documentId.equals("")) {
            Date dat = new Date();
            documentId = String.valueOf(dat.getYear()) + "_" + dat.getMonth() + "_" + dat.getDay() + "_" + dat.getHours() + ":" + dat.getMinutes();
        }
        String url = String.valueOf(this.getProtocol()) + "://" + this.getHost() + ":" + this.getPort() + "/" + dbName + "/" + documentId;
        if (this.evaluateConfiguration() > 0) {
            String revision = this.getDocumentRevision(dbName, documentId);
            try {
                if (revision.length() > 0) {
                    document.put("_rev", revision);
                }
                body = document.toString();
                response = this.sendPut(url, body);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (response.toLowerCase().contains("error")) {
            returnCode = 1;
        }
        return returnCode;
    }

    private String getDocumentRevision(String dbName, String documentId) {
        String response = "";
        String revId = "";
        if (this.evaluateConfiguration() > 0) {
            String url = String.valueOf(this.getProtocol()) + "://" + this.getHost() + ":" + this.getPort() + "/" + dbName + "/" + documentId;
            response = this.sendGet(url);
            try {
                JSONObject jObject = new JSONObject(response);
                if (jObject.has("_rev")) {
                    revId = jObject.getString("_rev");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return revId;
    }

    public String getDocument(String dbName, String documentId) {
        String document = "";
        if (this.evaluateConfiguration() > 0) {
            String url = String.valueOf(this.getProtocol()) + "://" + this.getHost() + ":" + this.getPort() + "/" + dbName + "/" + documentId;
            document = this.sendGet(url);
        }
        return document;
    }

    public String getView(String viewName, String dbName, String documentId) {
        String view = "";
        if (this.evaluateConfiguration() > 0) {
            String url = String.valueOf(this.getProtocol()) + "://" + this.getHost() + ":" + this.getPort() + "/" + dbName + "/" + documentId + "/_view/" + viewName;
            view = this.sendGet(url);
        }
        return view;
    }

    public String getList(String listName, String view, String dbName, String documentId) {
        String list = "";
        if (this.evaluateConfiguration() > 0) {
            String url = String.valueOf(this.getProtocol()) + "://" + this.getHost() + ":" + this.getPort() + "/" + dbName + "/" + documentId + "/_list/" + listName + "_view/" + view;
            list = this.sendGet(url);
        }
        return list;
    }
}

