/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.filters;

import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.zaproxy.zap.spider.filters.FetchFilter;

public class HttpPrefixFetchFilter
extends FetchFilter {
    private static final Logger LOGGER = Logger.getLogger(HttpPrefixFetchFilter.class);
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final int DEFAULT_PORT = -1;
    private static final int UNKNOWN_PORT = -2;
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private final String scheme;
    private final String host;
    private final int port;
    private final char[] path;

    public HttpPrefixFetchFilter(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("Parameter prefix must not be null.");
        }
        char[] cArray = uRI.getRawScheme();
        if (cArray == null) {
            throw new IllegalArgumentException("Parameter prefix must have a scheme.");
        }
        String string = HttpPrefixFetchFilter.normalisedScheme(cArray);
        if (!HttpPrefixFetchFilter.isHttpOrHttps(string)) {
            throw new IllegalArgumentException("The prefix's scheme must be HTTP or HTTPS.");
        }
        this.scheme = string;
        if (uRI.getRawHost() == null) {
            throw new IllegalArgumentException("Parameter prefix must have a host.");
        }
        try {
            this.host = HttpPrefixFetchFilter.normalisedHost(uRI);
        }
        catch (URIException uRIException) {
            throw new IllegalArgumentException("Failed to obtain the host from the prefix:", uRIException);
        }
        this.port = HttpPrefixFetchFilter.normalisedPort(this.scheme, uRI.getPort());
        this.path = uRI.getRawPath();
    }

    private static String normalisedScheme(char[] cArray) {
        if (cArray == null) {
            return "";
        }
        return new String(cArray).toLowerCase(Locale.ROOT);
    }

    private static boolean isHttpOrHttps(String string) {
        return HttpPrefixFetchFilter.isHttp(string) || HttpPrefixFetchFilter.isHttps(string);
    }

    private static boolean isHttp(String string) {
        return HTTP_SCHEME.equals(string);
    }

    private static boolean isHttps(String string) {
        return HTTPS_SCHEME.equals(string);
    }

    private static String normalisedHost(URI uRI) throws URIException {
        if (uRI.getRawHost() == null) {
            return "";
        }
        return uRI.getHost().toLowerCase(Locale.ROOT);
    }

    private static int normalisedPort(String string, int n) {
        if (n != -1) {
            return n;
        }
        if (HttpPrefixFetchFilter.isHttp(string)) {
            return 80;
        }
        if (HttpPrefixFetchFilter.isHttps(string)) {
            return 443;
        }
        return -2;
    }

    public String getNormalisedPrefix() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.scheme).append("://").append(this.host);
        if (!HttpPrefixFetchFilter.isDefaultHttpOrHttpsPort(this.scheme, this.port)) {
            stringBuilder.append(':').append(this.port);
        }
        if (this.path != null) {
            stringBuilder.append(this.path);
        }
        return stringBuilder.toString();
    }

    private static boolean isDefaultHttpOrHttpsPort(String string, int n) {
        if (n == 80 && HttpPrefixFetchFilter.isHttp(string)) {
            return true;
        }
        return n == 443 && HttpPrefixFetchFilter.isHttps(string);
    }

    @Override
    public FetchFilter.FetchStatus checkFilter(URI uRI) {
        if (uRI == null) {
            return FetchFilter.FetchStatus.OUT_OF_SCOPE;
        }
        String string = HttpPrefixFetchFilter.normalisedScheme(uRI.getRawScheme());
        if (this.port != HttpPrefixFetchFilter.normalisedPort(string, uRI.getPort())) {
            return FetchFilter.FetchStatus.OUT_OF_SCOPE;
        }
        if (!this.scheme.equals(string)) {
            return FetchFilter.FetchStatus.OUT_OF_SCOPE;
        }
        if (!this.hasSameHost(uRI)) {
            return FetchFilter.FetchStatus.OUT_OF_SCOPE;
        }
        if (!HttpPrefixFetchFilter.startsWith(uRI.getRawPath(), this.path)) {
            return FetchFilter.FetchStatus.OUT_OF_SCOPE;
        }
        return FetchFilter.FetchStatus.VALID;
    }

    private boolean hasSameHost(URI uRI) {
        try {
            return this.host.equals(HttpPrefixFetchFilter.normalisedHost(uRI));
        }
        catch (URIException uRIException) {
            LOGGER.warn((Object)("Failed to normalise host: " + Arrays.toString(uRI.getRawHost())), (Throwable)uRIException);
            return false;
        }
    }

    private static boolean startsWith(char[] cArray, char[] cArray2) {
        if (cArray2 == null) {
            return true;
        }
        if (cArray == null) {
            return false;
        }
        int n = cArray2.length;
        if (cArray.length < n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (cArray2[i] == cArray[i]) continue;
            return false;
        }
        return true;
    }
}

