/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.help.ExtensionHelp;

public abstract class AbstractFormDialog
extends JDialog {
    private static final long serialVersionUID = -3345423228612477780L;
    private static final String CANCEL_BUTTON_LABEL = Constant.messages.getString("form.dialog.button.cancel");
    private JButton helpButton;
    private JButton confirmButton;
    private JButton cancelButton;
    private boolean firstTime;
    private String helpTarget;

    public AbstractFormDialog(Dialog dialog, String string) {
        this(dialog, string, true);
    }

    public AbstractFormDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, true);
        this.initialise(bl);
    }

    private void initialise(boolean bl) {
        this.firstTime = true;
        if (bl) {
            this.initView();
        }
    }

    public AbstractFormDialog(Frame frame, String string) {
        this(frame, string, true);
    }

    public AbstractFormDialog(Frame frame, String string, boolean bl) {
        super(frame, string, true);
        this.initialise(bl);
    }

    public AbstractFormDialog(Window window, String string) {
        this(window, string, true);
    }

    public AbstractFormDialog(Window window, String string, boolean bl) {
        super(window, string, Dialog.DEFAULT_MODALITY_TYPE);
        this.initialise(bl);
    }

    protected void initView() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(this.getHelpButton());
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.getCancelButton());
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.getConfirmButton());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.getFieldsPanel(), "Center");
        jPanel2.add((Component)jPanel, "Last");
        this.setContentPane(jPanel2);
    }

    private JButton getHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton();
            this.helpButton.setIcon(ExtensionHelp.HELP_ICON);
            this.helpButton.setToolTipText(Constant.messages.getString("help.dialog.button.tooltip"));
            this.helpButton.setVisible(false);
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AbstractFormDialog.this.helpTarget != null) {
                        ExtensionHelp.showHelp(AbstractFormDialog.this.helpTarget);
                    }
                }
            });
        }
        return this.helpButton;
    }

    protected void setHelpTarget(String string) {
        this.helpTarget = string;
        this.getHelpButton().setVisible(string != null);
    }

    private JButton getConfirmButton() {
        if (this.confirmButton == null) {
            this.confirmButton = new JButton(this.getConfirmButtonLabel());
            this.confirmButton.setEnabled(false);
            this.confirmButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AbstractFormDialog.this.validateFields()) {
                        AbstractFormDialog.this.performAction();
                        AbstractFormDialog.this.clearAndHide();
                    }
                }
            });
        }
        return this.confirmButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(this.getCancelButtonLabel());
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractFormDialog.this.clearAndHide();
                }
            });
        }
        return this.cancelButton;
    }

    protected abstract JPanel getFieldsPanel();

    @Override
    public void setVisible(boolean bl) {
        this.init();
        if (this.firstTime) {
            this.centreOnOwner();
            this.firstTime = false;
        }
        super.setVisible(bl);
    }

    private void clearAndHide() {
        this.clearFields();
        this.dispose();
    }

    protected abstract String getConfirmButtonLabel();

    protected String getCancelButtonLabel() {
        return CANCEL_BUTTON_LABEL;
    }

    protected void setConfirmButtonEnabled(boolean bl) {
        this.getConfirmButton().setEnabled(bl);
    }

    protected void init() {
    }

    protected boolean validateFields() {
        return true;
    }

    protected void performAction() {
    }

    protected void clearFields() {
    }

    private void centreOnOwner() {
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.getOwner().getBounds();
        int n = rectangle.x + (rectangle.width - dimension.width) / 2;
        int n2 = rectangle.y + (rectangle.height - dimension.height) / 2;
        this.setLocation(n, n2);
    }
}

