/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.security.util.AbstractAlgorithmConstraints;
import sun.security.util.AlgorithmDecomposer;
import sun.security.util.CertConstraintParameters;
import sun.security.util.Debug;
import sun.security.util.KeyUtil;

public class DisabledAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    private static final Debug debug = Debug.getInstance("certpath");
    public static final String PROPERTY_CERTPATH_DISABLED_ALGS = "jdk.certpath.disabledAlgorithms";
    public static final String PROPERTY_TLS_DISABLED_ALGS = "jdk.tls.disabledAlgorithms";
    public static final String PROPERTY_JAR_DISABLED_ALGS = "jdk.jar.disabledAlgorithms";
    private final String[] disabledAlgorithms;
    private final Constraints algorithmConstraints;

    public DisabledAlgorithmConstraints(String string) {
        this(string, new AlgorithmDecomposer());
    }

    public DisabledAlgorithmConstraints(String string, AlgorithmDecomposer algorithmDecomposer) {
        super(algorithmDecomposer);
        this.disabledAlgorithms = DisabledAlgorithmConstraints.getAlgorithms(string);
        this.algorithmConstraints = new Constraints(this.disabledAlgorithms);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
        if (set == null || set.isEmpty()) {
            throw new IllegalArgumentException("No cryptographic primitive specified");
        }
        return DisabledAlgorithmConstraints.checkAlgorithm(this.disabledAlgorithms, string, this.decomposer);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, Key key) {
        return this.checkConstraints(set, "", key, null);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        return this.checkConstraints(set, string, key, algorithmParameters);
    }

    public final void permits(Set<CryptoPrimitive> set, CertConstraintParameters certConstraintParameters) throws CertPathValidatorException {
        this.checkConstraints(set, certConstraintParameters);
    }

    public final void permits(Set<CryptoPrimitive> set, X509Certificate x509Certificate) throws CertPathValidatorException {
        this.checkConstraints(set, new CertConstraintParameters(x509Certificate));
    }

    public boolean checkProperty(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        for (String string2 : this.disabledAlgorithms) {
            if (string2.toLowerCase(Locale.ENGLISH).indexOf(string) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean checkConstraints(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        if (string != null && string.length() != 0 && !this.permits(set, string, algorithmParameters)) {
            return false;
        }
        if (!this.permits(set, key.getAlgorithm(), null)) {
            return false;
        }
        return this.algorithmConstraints.permits(key);
    }

    private void checkConstraints(Set<CryptoPrimitive> set, CertConstraintParameters certConstraintParameters) throws CertPathValidatorException {
        X509Certificate x509Certificate = certConstraintParameters.getCertificate();
        String string = x509Certificate.getSigAlgName();
        if (!this.permits(set, string, null)) {
            throw new CertPathValidatorException("Algorithm constraints check failed on disabled signature algorithm: " + string, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }
        if (!this.permits(set, x509Certificate.getPublicKey().getAlgorithm(), null)) {
            throw new CertPathValidatorException("Algorithm constraints check failed on disabled public key algorithm: " + string, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }
        this.algorithmConstraints.permits(certConstraintParameters);
    }

    private static class KeySizeConstraint
    extends Constraint {
        private int minSize;
        private int maxSize;
        private int prohibitedSize = -1;

        public KeySizeConstraint(String string, Constraint.Operator operator, int n) {
            this.algorithm = string;
            switch (operator) {
                case EQ: {
                    this.minSize = 0;
                    this.maxSize = Integer.MAX_VALUE;
                    this.prohibitedSize = n;
                    break;
                }
                case NE: {
                    this.minSize = n;
                    this.maxSize = n;
                    break;
                }
                case LT: {
                    this.minSize = n;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case LE: {
                    this.minSize = n + 1;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case GT: {
                    this.minSize = 0;
                    this.maxSize = n;
                    break;
                }
                case GE: {
                    this.minSize = 0;
                    this.maxSize = n > 1 ? n - 1 : 0;
                    break;
                }
                default: {
                    this.minSize = Integer.MAX_VALUE;
                    this.maxSize = -1;
                }
            }
        }

        @Override
        public void permits(CertConstraintParameters certConstraintParameters) throws CertPathValidatorException {
            if (!this.permitsImpl(certConstraintParameters.getCertificate().getPublicKey())) {
                if (this.nextConstraint != null) {
                    this.nextConstraint.permits(certConstraintParameters);
                    return;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on keysize limits", null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public boolean permits(Key key) {
            if (this.nextConstraint != null && this.nextConstraint.permits(key)) {
                return true;
            }
            if (debug != null) {
                debug.println("KeySizeConstraints.permits(): " + this.algorithm);
            }
            return this.permitsImpl(key);
        }

        private boolean permitsImpl(Key key) {
            if (this.algorithm.compareToIgnoreCase(key.getAlgorithm()) != 0) {
                return true;
            }
            int n = KeyUtil.getKeySize(key);
            if (n == 0) {
                return false;
            }
            if (n > 0) {
                return n >= this.minSize && n <= this.maxSize && this.prohibitedSize != n;
            }
            return true;
        }
    }

    private static class jdkCAConstraint
    extends Constraint {
        jdkCAConstraint(String string) {
            this.algorithm = string;
        }

        @Override
        public void permits(CertConstraintParameters certConstraintParameters) throws CertPathValidatorException {
            if (debug != null) {
                debug.println("jdkCAConstraints.permits(): " + this.algorithm);
            }
            if (certConstraintParameters.isTrustedMatch()) {
                if (this.nextConstraint != null) {
                    this.nextConstraint.permits(certConstraintParameters);
                    return;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on certificate anchor limits", null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
    }

    private static abstract class Constraint {
        String algorithm;
        Constraint nextConstraint = null;

        private Constraint() {
        }

        public boolean permits(Key key) {
            return true;
        }

        public abstract void permits(CertConstraintParameters var1) throws CertPathValidatorException;

        static enum Operator {
            EQ,
            NE,
            LT,
            LE,
            GT,
            GE;


            static Operator of(String string) {
                switch (string) {
                    case "==": {
                        return EQ;
                    }
                    case "!=": {
                        return NE;
                    }
                    case "<": {
                        return LT;
                    }
                    case "<=": {
                        return LE;
                    }
                    case ">": {
                        return GT;
                    }
                    case ">=": {
                        return GE;
                    }
                }
                throw new IllegalArgumentException("Error in security property. " + string + " is not a legal Operator");
            }
        }
    }

    private static class Constraints {
        private Map<String, Set<Constraint>> constraintsMap = new HashMap<String, Set<Constraint>>();
        private static final Pattern keySizePattern = Pattern.compile("keySize\\s*(<=|<|==|!=|>|>=)\\s*(\\d+)");

        public Constraints(String[] stringArray) {
            for (String string : stringArray) {
                int n;
                if (string == null || string.isEmpty()) continue;
                string = string.trim();
                if (debug != null) {
                    debug.println("Constraints: " + string);
                }
                if ((n = string.indexOf(32)) <= 0) {
                    this.constraintsMap.putIfAbsent(string.toUpperCase(Locale.ENGLISH), new HashSet());
                    continue;
                }
                String string2 = AlgorithmDecomposer.hashName(string.substring(0, n).toUpperCase(Locale.ENGLISH));
                String string3 = string.substring(n + 1);
                Constraint constraint = null;
                jdkCAConstraint jdkCAConstraint2 = null;
                boolean bl = false;
                for (String string4 : string3.split("&")) {
                    Matcher matcher = keySizePattern.matcher(string4 = string4.trim());
                    if (matcher.matches()) {
                        if (debug != null) {
                            debug.println("Constraints set to keySize: " + string4);
                        }
                        constraint = new KeySizeConstraint(string2, Constraint.Operator.of(matcher.group(1)), Integer.parseInt(matcher.group(2)));
                    } else if (string4.equalsIgnoreCase("jdkCA")) {
                        if (debug != null) {
                            debug.println("Constraints set to jdkCA.");
                        }
                        if (bl) {
                            throw new IllegalArgumentException("Only one jdkCA entry allowed in property. Constraint: " + string);
                        }
                        constraint = new jdkCAConstraint(string2);
                        bl = true;
                    }
                    if (jdkCAConstraint2 == null) {
                        if (!this.constraintsMap.containsKey(string2)) {
                            this.constraintsMap.putIfAbsent(string2, new HashSet());
                        }
                        if (constraint != null) {
                            this.constraintsMap.get(string2).add(constraint);
                        }
                    } else {
                        jdkCAConstraint2.nextConstraint = constraint;
                    }
                    jdkCAConstraint2 = constraint;
                }
            }
        }

        private Set<Constraint> getConstraints(String string) {
            return this.constraintsMap.get(string);
        }

        public boolean permits(Key key) {
            Set<Constraint> set = this.getConstraints(key.getAlgorithm());
            if (set == null) {
                return true;
            }
            for (Constraint constraint : set) {
                if (constraint.permits(key)) continue;
                if (debug != null) {
                    debug.println("keySizeConstraint: failed key constraint check " + KeyUtil.getKeySize(key));
                }
                return false;
            }
            return true;
        }

        public void permits(CertConstraintParameters certConstraintParameters) throws CertPathValidatorException {
            Set<String> set;
            X509Certificate x509Certificate = certConstraintParameters.getCertificate();
            if (debug != null) {
                debug.println("Constraints.permits(): " + x509Certificate.getSigAlgName());
            }
            if ((set = AlgorithmDecomposer.decomposeOneHash(x509Certificate.getSigAlgName())) == null || set.isEmpty()) {
                return;
            }
            set.add(x509Certificate.getPublicKey().getAlgorithm());
            for (String string : set) {
                Set<Constraint> set2 = this.getConstraints(string);
                if (set2 == null) continue;
                for (Constraint constraint : set2) {
                    constraint.permits(certConstraintParameters);
                }
            }
        }
    }
}

