/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.profile.query.ProfileScorer;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.elasticsearch.search.profile.query.QueryTimingType;

public final class ProfileWeight
extends Weight {
    private final Weight subQueryWeight;
    private final QueryProfileBreakdown profile;

    public ProfileWeight(Query query, Weight subQueryWeight, QueryProfileBreakdown profile) throws IOException {
        super(query);
        this.subQueryWeight = subQueryWeight;
        this.profile = profile;
    }

    public Scorer scorer(LeafReaderContext context) throws IOException {
        Scorer subQueryScorer;
        this.profile.startTime(QueryTimingType.BUILD_SCORER);
        try {
            subQueryScorer = this.subQueryWeight.scorer(context);
        }
        finally {
            this.profile.stopAndRecordTime();
        }
        if (subQueryScorer == null) {
            return null;
        }
        return new ProfileScorer(this, subQueryScorer, this.profile);
    }

    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        return super.bulkScorer(context);
    }

    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        return this.subQueryWeight.explain(context, doc);
    }

    public float getValueForNormalization() throws IOException {
        return this.subQueryWeight.getValueForNormalization();
    }

    public void normalize(float norm, float topLevelBoost) {
        this.subQueryWeight.normalize(norm, topLevelBoost);
    }

    public void extractTerms(Set<Term> set) {
        this.subQueryWeight.extractTerms(set);
    }
}

