/*
 * Decompiled with CFR 0.152.
 */
package info.dolezel.fatrat.applet.components;

import info.dolezel.fatrat.applet.FatRatApplet;
import info.dolezel.fatrat.applet.settings.AppletSettings;
import info.dolezel.fatrat.applet.settings.SettingsListener;
import info.dolezel.fatrat.applet.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.security.AccessControlException;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;

public class InfoBar
extends JFrame
implements SettingsListener,
ActionListener {
    AppletSettings settings;
    Timer timer;
    XmlRpcClient client;
    String uuid;
    boolean isDragged;
    int lastX;
    int lastY;
    private JLabel label;

    public InfoBar(String uuid, AppletSettings settings, XmlRpcClient client) {
        this.settings = settings;
        this.client = client;
        this.uuid = uuid;
        this.initComponents();
        this.getContentPane().setBackground(Color.WHITE);
        this.setSize(400, 16);
        try {
            Point pt = MouseInfo.getPointerInfo().getLocation();
            this.setLocation((int)pt.getX() - 5, (int)pt.getY() - 5);
        }
        catch (AccessControlException e) {
            this.setLocation(200, 200);
        }
        int iv = settings.getValue("refreshInterval", 1);
        this.timer = new Timer(FatRatApplet.refreshIntervals[iv] * 1000, this);
        this.timer.setInitialDelay(0);
        this.timer.start();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.setResizable(false);
        this.setType(Window.Type.POPUP);
        this.setUndecorated(true);
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.label.setFont(new Font("Dialog", 0, 12));
        this.label.setHorizontalAlignment(2);
        this.label.setVerticalAlignment(1);
        this.label.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                InfoBar.this.labelMouseClicked(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                InfoBar.this.labelMouseReleased(evt);
            }
        });
        this.label.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                InfoBar.this.labelMouseDragged(evt);
            }
        });
        this.getContentPane().add(this.label);
        this.pack();
    }

    private void labelMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 2) {
            this.timer.stop();
            this.setVisible(false);
        }
    }

    private void labelMouseDragged(MouseEvent evt) {
        if (!this.isDragged) {
            this.isDragged = true;
            this.lastX = evt.getX();
            this.lastY = evt.getY();
        } else {
            this.setLocation(this.getX() + (evt.getX() - this.lastX), this.getY() + (evt.getY() - this.lastY));
        }
    }

    private void labelMouseReleased(MouseEvent evt) {
        this.isDragged = false;
    }

    @Override
    public void onKeyValueChanged(String key) {
        if (!key.equals("refreshInterval")) {
            return;
        }
        int iv = this.settings.getValue("refreshInterval", 1);
        this.timer.setDelay(1000 * FatRatApplet.refreshIntervals[iv]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingWorker<Map<String, Object>, Void> worker = new SwingWorker<Map<String, Object>, Void>(){

            @Override
            protected Map<String, Object> doInBackground() throws Exception {
                try {
                    return (Map)InfoBar.this.client.execute("Transfer.getProperties", new String[]{InfoBar.this.uuid});
                }
                catch (XmlRpcException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            protected void done() {
                try {
                    Map map = (Map)this.get();
                    if (map == null) {
                        InfoBar.this.timer.stop();
                        InfoBar.this.setVisible(false);
                        return;
                    }
                    StringBuilder sb = new StringBuilder();
                    String state = map.get("state").toString();
                    boolean isActive = state.equals("Active") || state.equals("ForcedActive");
                    sb.append("<html><font color=blue>N:</font> ");
                    sb.append(Util.shortenText(map.get("name").toString(), 25));
                    sb.append(" | ");
                    sb.append("<font color=blue>P:</font> ");
                    long total = (Long)map.get("total");
                    long done = (Long)map.get("done");
                    if (total == 0L) {
                        sb.append("?");
                    } else {
                        float p = (float)done / (float)total * 100.0f;
                        sb.append(String.format("%.01f%%", Float.valueOf(p)));
                    }
                    sb.append(" | ");
                    String mode = (String)map.get("mode");
                    String primaryMode = (String)map.get("primaryMode");
                    sb.append("<font color=blue>S:</font> ");
                    Object[] speeds = (Object[])map.get("speeds");
                    int down = (Integer)speeds[0];
                    int up = (Integer)speeds[1];
                    if (down > 0 || isActive && primaryMode.equals("Download")) {
                        sb.append(Util.formatSize(down)).append("/s down ");
                    }
                    if (up > 0 || isActive && mode.equals("Upload")) {
                        sb.append(Util.formatSize(up)).append("/s up ");
                    }
                    if (!isActive) {
                        sb.append("--- ");
                    }
                    sb.append("| ");
                    InfoBar.this.label.setText(sb.toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        worker.execute();
    }
}

