/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.metadata;

import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ComponentArtifactMetadataSerializer
implements Serializer<ComponentArtifactMetadata> {
    private final ComponentIdentifierSerializer componentIdentifierSerializer = new ComponentIdentifierSerializer();

    public void write(Encoder encoder, ComponentArtifactMetadata value) throws Exception {
        if (!(value instanceof ModuleComponentArtifactMetadata)) {
            throw new IllegalArgumentException("Unknown artifact metadata type.");
        }
        ModuleComponentArtifactMetadata moduleComponentArtifactMetadata = (ModuleComponentArtifactMetadata)value;
        this.componentIdentifierSerializer.write(encoder, moduleComponentArtifactMetadata.getComponentId());
        IvyArtifactName ivyArtifactName = moduleComponentArtifactMetadata.getName();
        encoder.writeString((CharSequence)ivyArtifactName.getName());
        encoder.writeString((CharSequence)ivyArtifactName.getType());
        encoder.writeNullableString((CharSequence)ivyArtifactName.getExtension());
        encoder.writeNullableString((CharSequence)ivyArtifactName.getClassifier());
    }

    public ComponentArtifactMetadata read(Decoder decoder) throws Exception {
        ModuleComponentIdentifier componentIdentifier = (ModuleComponentIdentifier)this.componentIdentifierSerializer.read(decoder);
        String artifactName = decoder.readString();
        String type = decoder.readString();
        String extension = decoder.readNullableString();
        String classifier = decoder.readNullableString();
        return new DefaultModuleComponentArtifactMetadata(componentIdentifier, new DefaultIvyArtifactName(artifactName, type, extension, classifier));
    }
}

