/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiAnonymousClassImpl
extends PsiClassImpl
implements PsiAnonymousClass {
    private SoftReference<PsiClassType> myCachedBaseType;

    public PsiAnonymousClassImpl(PsiClassStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ANONYMOUS_CLASS);
    }

    public PsiAnonymousClassImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected Object clone() {
        PsiAnonymousClassImpl clone = (PsiAnonymousClassImpl)super.clone();
        clone.myCachedBaseType = null;
        return clone;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedBaseType = null;
    }

    @Override
    public PsiExpressionList getArgumentList() {
        return (PsiExpressionList)this.getNode().findChildByRoleAsPsiElement(73);
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement getBaseClassReference() {
        PsiElement baseRef = this.getFirstChild();
        assert (baseRef instanceof PsiJavaCodeReferenceElement) : this.getText();
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)baseRef;
        if (psiJavaCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiAnonymousClassImpl", "getBaseClassReference"));
        }
        return psiJavaCodeReferenceElement;
    }

    @Override
    @NotNull
    public PsiClassType getBaseClassType() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub == null) {
            this.myCachedBaseType = null;
            PsiClassType psiClassType = this.getTypeByTree();
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiAnonymousClassImpl", "getBaseClassType"));
            }
            return psiClassType;
        }
        PsiClassType type2 = SoftReference.dereference(this.myCachedBaseType);
        if (type2 != null) {
            PsiClassType psiClassType = type2;
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiAnonymousClassImpl", "getBaseClassType"));
            }
            return psiClassType;
        }
        if (!this.isInQualifiedNew()) {
            String refText = stub.getBaseClassReferenceText();
            assert (refText != null) : stub;
            PsiElementFactory factory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
            PsiElement context = this.calcBasesResolveContext(PsiNameHelper.getShortClassName(refText), this.getExtendsList());
            try {
                PsiJavaCodeReferenceElement ref = factory.createReferenceFromText(refText, context);
                ((PsiJavaCodeReferenceElementImpl)ref).setKindWhenDummy(1);
                type2 = factory.createType(ref);
            }
            catch (IncorrectOperationException e) {
                type2 = PsiType.getJavaLangObject(this.getManager(), this.getResolveScope());
            }
            this.myCachedBaseType = new SoftReference<PsiClassType>(type2);
            PsiClassType psiClassType = type2;
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiAnonymousClassImpl", "getBaseClassType"));
            }
            return psiClassType;
        }
        PsiClassType psiClassType = this.getTypeByTree();
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiAnonymousClassImpl", "getBaseClassType"));
        }
        return psiClassType;
    }

    private PsiClassType getTypeByTree() {
        return JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createType(this.getBaseClassReference());
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public PsiModifierList getModifierList() {
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiAnonymousClassImpl", "hasModifierProperty"));
        }
        return name2.equals("final");
    }

    @Override
    public PsiReferenceList getExtendsList() {
        return null;
    }

    @Override
    public PsiReferenceList getImplementsList() {
        return null;
    }

    @Override
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiAnonymousClassImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitAnonymousClass(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiAnonymousClass";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiAnonymousClassImpl", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiAnonymousClassImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiAnonymousClassImpl", "processDeclarations"));
        }
        if (lastParent instanceof PsiExpressionList) {
            return true;
        }
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return true;
        }
        if (lastParent != null && lastParent.getParent() == this && lastParent == this.getBaseClassReference()) {
            return true;
        }
        return super.processDeclarations(processor, state2, lastParent, place);
    }

    @Override
    public boolean isInQualifiedNew() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return stub.isAnonymousInQualifiedNew();
        }
        PsiElement parent2 = this.getParent();
        return parent2 instanceof PsiNewExpression && ((PsiNewExpression)parent2).getQualifier() != null;
    }

    @Override
    public PsiElement getParent() {
        return SharedImplUtil.getParent(this.getNode());
    }
}

