/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.patterns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;

public final class PatternBuilder {
    @NotNull
    private static final NamePredicate KOTLIN_NAME_PREDICATE = new NamePredicate("kotlin");
    @NotNull
    private static final Name KOTLIN_NAME = Name.identifier("Kotlin".toLowerCase());

    private PatternBuilder() {
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull NamePredicate checker, @NotNull String stringWithPattern) {
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        if (stringWithPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringWithPattern", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        ArrayList<NamePredicate> checkers = Lists.newArrayList(checker);
        checkers.addAll(PatternBuilder.parseFqNamesFromString(stringWithPattern));
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(checkers, PatternBuilder.parseArgumentsFromString(stringWithPattern));
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull String stringWithPattern, @NotNull NamePredicate checker) {
        if (stringWithPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringWithPattern", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        ArrayList<NamePredicate> checkers = Lists.newArrayList(PatternBuilder.parseFqNamesFromString(stringWithPattern));
        checkers.add(checker);
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(checkers);
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull String stringWithPattern) {
        if (stringWithPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringWithPattern", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(PatternBuilder.parseFqNamesFromString(stringWithPattern), PatternBuilder.parseArgumentsFromString(stringWithPattern));
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    private static List<NamePredicate> parseFqNamesFromString(@NotNull String stringWithPattern) {
        if (stringWithPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringWithPattern", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "parseFqNamesFromString"));
        }
        stringWithPattern = PatternBuilder.getNamePatternFromString(stringWithPattern);
        String[] subPatterns = stringWithPattern.split("\\.");
        ArrayList<NamePredicate> checkers = Lists.newArrayList();
        for (String subPattern : subPatterns) {
            String[] validNames = subPattern.split("\\|");
            checkers.add(new NamePredicate(validNames));
        }
        ArrayList<NamePredicate> arrayList = checkers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "parseFqNamesFromString"));
        }
        return arrayList;
    }

    @Nullable
    private static List<NamePredicate> parseArgumentsFromString(@NotNull String stringWithPattern) {
        String[] subPatterns;
        if (stringWithPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringWithPattern", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "parseArgumentsFromString"));
        }
        if ((stringWithPattern = PatternBuilder.getArgumentsPatternFromString(stringWithPattern)) == null) {
            return null;
        }
        ArrayList<NamePredicate> checkers = Lists.newArrayList();
        if (stringWithPattern.isEmpty()) {
            return checkers;
        }
        for (String subPattern : subPatterns = stringWithPattern.split("\\,")) {
            String[] validNames = subPattern.split("\\|");
            checkers.add(new NamePredicate(validNames));
        }
        return checkers;
    }

    @NotNull
    private static String getNamePatternFromString(@NotNull String stringWithPattern) {
        if (stringWithPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringWithPattern", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "getNamePatternFromString"));
        }
        int left = stringWithPattern.indexOf("(");
        if (left < 0) {
            String string = stringWithPattern;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "getNamePatternFromString"));
            }
            return string;
        }
        String string = stringWithPattern.substring(0, left);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "getNamePatternFromString"));
        }
        return string;
    }

    @Nullable
    private static String getArgumentsPatternFromString(@NotNull String stringWithPattern) {
        if (stringWithPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringWithPattern", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "getArgumentsPatternFromString"));
        }
        int left = stringWithPattern.indexOf("(");
        if (left < 0) {
            return null;
        }
        int right = stringWithPattern.indexOf(")");
        assert (right == stringWithPattern.length() - 1) : "expected ')' at the end: " + stringWithPattern;
        return stringWithPattern.substring(left + 1, right);
    }

    @NotNull
    private static DescriptorPredicate pattern(@NotNull List<NamePredicate> checkers) {
        if (checkers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkers", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(checkers, null);
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    private static DescriptorPredicate pattern(@NotNull List<NamePredicate> checkers, @Nullable List<NamePredicate> arguments2) {
        if (checkers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkers", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        assert (!checkers.isEmpty());
        final ArrayList<NamePredicate> checkersWithPrefixChecker = Lists.newArrayList();
        if (!checkers.get(0).apply(KOTLIN_NAME)) {
            checkersWithPrefixChecker.add(KOTLIN_NAME_PREDICATE);
        }
        checkersWithPrefixChecker.addAll(checkers);
        assert (checkersWithPrefixChecker.size() > 1);
        final ArrayList<NamePredicate> argumentCheckers = arguments2 != null ? Lists.newArrayList(arguments2) : null;
        DescriptorPredicate descriptorPredicate = new DescriptorPredicate(){

            @Override
            public boolean apply(@Nullable FunctionDescriptor descriptor2) {
                assert (descriptor2 != null) : "argument for DescriptorPredicate.apply should not be null, checkers=" + checkersWithPrefixChecker;
                try {
                    return this.doApply(descriptor2);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }

            private boolean doApply(@NotNull FunctionDescriptor descriptor2) {
                if (descriptor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/patterns/PatternBuilder$1", "doApply"));
                }
                List<Name> nameParts = DescriptorUtils.getFqName(descriptor2).pathSegments();
                if (nameParts.size() != checkersWithPrefixChecker.size()) {
                    return false;
                }
                return this.allNamePartsValid(nameParts) && this.checkAllArgumentsValidIfNeeded(descriptor2);
            }

            private boolean checkAllArgumentsValidIfNeeded(@NotNull FunctionDescriptor descriptor2) {
                if (descriptor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/patterns/PatternBuilder$1", "checkAllArgumentsValidIfNeeded"));
                }
                if (argumentCheckers != null) {
                    List<ValueParameterDescriptor> valueParameterDescriptors = descriptor2.getValueParameters();
                    if (valueParameterDescriptors.size() != argumentCheckers.size()) {
                        return false;
                    }
                    for (int i = 0; i < valueParameterDescriptors.size(); ++i) {
                        ValueParameterDescriptor valueParameterDescriptor = valueParameterDescriptors.get(i);
                        Name name2 = DescriptorUtilsKt.getNameIfStandardType(valueParameterDescriptor.getType());
                        NamePredicate namePredicate = (NamePredicate)argumentCheckers.get(i);
                        if (namePredicate.apply(name2)) continue;
                        return false;
                    }
                }
                return true;
            }

            private boolean allNamePartsValid(@NotNull List<Name> nameParts) {
                if (nameParts == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameParts", "org/jetbrains/kotlin/js/patterns/PatternBuilder$1", "allNamePartsValid"));
                }
                for (int i = 0; i < nameParts.size(); ++i) {
                    Name namePart = nameParts.get(i);
                    NamePredicate correspondingPredicate = (NamePredicate)checkersWithPrefixChecker.get(i);
                    if (correspondingPredicate.apply(namePart)) continue;
                    return false;
                }
                return true;
            }
        };
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicate pattern(NamePredicate ... checkers) {
        if (checkers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkers", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern(Arrays.asList(checkers));
        if (descriptorPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicate;
    }

    @NotNull
    public static DescriptorPredicateImpl pattern(String ... names2) {
        if (names2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        DescriptorPredicateImpl descriptorPredicateImpl = new DescriptorPredicateImpl(names2);
        if (descriptorPredicateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/patterns/PatternBuilder", "pattern"));
        }
        return descriptorPredicateImpl;
    }

    public static class DescriptorPredicateImpl
    implements DescriptorPredicate {
        private final String[] names;
        private String receiverFqName;
        private boolean checkOverridden;

        public DescriptorPredicateImpl(String ... names2) {
            this.names = names2;
        }

        public DescriptorPredicateImpl isExtensionOf(String receiverFqName) {
            this.receiverFqName = receiverFqName;
            return this;
        }

        public DescriptorPredicateImpl checkOverridden() {
            this.checkOverridden = true;
            return this;
        }

        private boolean matches(@NotNull CallableDescriptor callable) {
            if (callable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/js/patterns/PatternBuilder$DescriptorPredicateImpl", "matches"));
            }
            DeclarationDescriptor descriptor2 = callable;
            int nameIndex = this.names.length - 1;
            do {
                if (nameIndex == -1) {
                    return false;
                }
                if (!descriptor2.getName().asString().equals(this.names[nameIndex])) {
                    return false;
                }
                --nameIndex;
            } while (!((descriptor2 = descriptor2.getContainingDeclaration()) instanceof PackageFragmentDescriptor));
            return nameIndex == 0 && this.names[0].equals(((PackageFragmentDescriptor)descriptor2).getFqName().asString());
        }

        @Override
        public boolean apply(@Nullable FunctionDescriptor functionDescriptor) {
            assert (functionDescriptor != null) : "argument for DescriptorPredicate.apply should not be null, receiverFqName=" + this.receiverFqName + " names=" + Arrays.asList(this.names);
            ReceiverParameterDescriptor actualReceiver = functionDescriptor.getExtensionReceiverParameter();
            if (actualReceiver != null) {
                if (this.receiverFqName == null) {
                    return false;
                }
                String actualReceiverFqName = DescriptorUtilsKt.getJetTypeFqName(actualReceiver.getType(), false);
                if (!actualReceiverFqName.equals(this.receiverFqName)) {
                    return false;
                }
            }
            if (!(functionDescriptor.getContainingDeclaration() instanceof ClassDescriptor)) {
                return this.matches(functionDescriptor);
            }
            for (CallableMemberDescriptor real : OverridingUtil.getOverriddenDeclarations(functionDescriptor)) {
                if (!this.matches(real)) continue;
                return true;
            }
            if (this.checkOverridden) {
                for (FunctionDescriptor overridden : DescriptorUtils.getAllOverriddenDescriptors(functionDescriptor)) {
                    if (!this.matches(overridden)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

