/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoExtensionsKt;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCase;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCasesKt;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ.\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u0013\u001a\u00020\u0004*\u00020\u0014H\u0014J\f\u0010\u0007\u001a\u00020\u0004*\u00020\u0014H\u0014J\f\u0010\u0015\u001a\u00020\u0004*\u00020\u0014H\u0014J\f\u0010\u0016\u001a\u00020\u0004*\u00020\u0014H\u0014\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/js/translate/callTranslator/DefaultFunctionCallCase;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallCase;", "()V", "buildDefaultCallWithDispatchReceiver", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsExpression;", "argumentsInfo", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "dispatchReceiver", "functionName", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsName;", "isNative", "", "hasSpreadOperator", "buildDefaultCallWithoutReceiver", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "nativeSpreadFunWithDispatchOrExtensionReceiver", "bothReceivers", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;", "extensionReceiver", "noReceivers", "kotlin-compiler"})
public final class DefaultFunctionCallCase
extends FunctionCallCase {
    public static final DefaultFunctionCallCase INSTANCE;

    private final JsExpression nativeSpreadFunWithDispatchOrExtensionReceiver(CallArgumentTranslator.ArgumentsInfo argumentsInfo, JsName functionName) {
        TemporaryConstVariable temporaryConstVariable = argumentsInfo.getCachedReceiver();
        if (temporaryConstVariable == null) {
            Intrinsics.throwNpe();
        }
        TemporaryConstVariable cachedReceiver = temporaryConstVariable;
        JsNameRef functionCallRef = Namer.getFunctionApplyRef(new JsNameRef(functionName, cachedReceiver.assignmentExpression()));
        return new JsInvocation((JsExpression)functionCallRef, argumentsInfo.getTranslateArguments());
    }

    @NotNull
    public final JsExpression buildDefaultCallWithDispatchReceiver(@NotNull CallArgumentTranslator.ArgumentsInfo argumentsInfo, @NotNull JsExpression dispatchReceiver, @NotNull JsName functionName, boolean isNative, boolean hasSpreadOperator) {
        Intrinsics.checkParameterIsNotNull(argumentsInfo, "argumentsInfo");
        Intrinsics.checkParameterIsNotNull(dispatchReceiver, "dispatchReceiver");
        Intrinsics.checkParameterIsNotNull(functionName, "functionName");
        if (isNative && hasSpreadOperator) {
            return this.nativeSpreadFunWithDispatchOrExtensionReceiver(argumentsInfo, functionName);
        }
        return new JsInvocation((JsExpression)JsAstUtils.pureFqn(functionName, dispatchReceiver), argumentsInfo.getTranslateArguments());
    }

    @NotNull
    public final JsExpression buildDefaultCallWithoutReceiver(@NotNull TranslationContext context, @NotNull CallArgumentTranslator.ArgumentsInfo argumentsInfo, @NotNull CallableDescriptor callableDescriptor, boolean isNative, boolean hasSpreadOperator) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(argumentsInfo, "argumentsInfo");
        Intrinsics.checkParameterIsNotNull(callableDescriptor, "callableDescriptor");
        if (isNative && hasSpreadOperator) {
            JsNameRef functionCallRef = Namer.getFunctionApplyRef(new JsNameRef(context.getNameForDescriptor(callableDescriptor)));
            return new JsInvocation((JsExpression)functionCallRef, argumentsInfo.getTranslateArguments());
        }
        if (isNative) {
            return new JsInvocation((JsExpression)new JsNameRef(context.getNameForDescriptor(callableDescriptor)), argumentsInfo.getTranslateArguments());
        }
        JsExpression functionRef2 = CallInfoExtensionsKt.aliasOrValue(context, callableDescriptor, (Function1<? super CallableDescriptor, ? extends JsExpression>)new Function1<CallableDescriptor, JsNameRef>(context){
            final /* synthetic */ TranslationContext $context;

            @NotNull
            public final JsNameRef invoke(@NotNull CallableDescriptor it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                JsNameRef jsNameRef = this.$context.getQualifiedReference(it);
                Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "context.getQualifiedReference(it)");
                return jsNameRef;
            }
            {
                this.$context = translationContext;
                super(1);
            }
        });
        return new JsInvocation(functionRef2, argumentsInfo.getTranslateArguments());
    }

    @Override
    @NotNull
    protected JsExpression noReceivers(@NotNull FunctionCallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return this.buildDefaultCallWithoutReceiver($receiver.getContext(), $receiver.getArgumentsInfo(), CallInfoExtensionsKt.getCallableDescriptor($receiver), CallInfoExtensionsKt.isNative($receiver), CallInfoExtensionsKt.hasSpreadOperator($receiver));
    }

    @Override
    @NotNull
    protected JsExpression dispatchReceiver(@NotNull FunctionCallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = $receiver.getArgumentsInfo();
        JsExpression jsExpression = $receiver.getDispatchReceiver();
        if (jsExpression == null) {
            Intrinsics.throwNpe();
        }
        return this.buildDefaultCallWithDispatchReceiver(argumentsInfo, jsExpression, CallInfoExtensionsKt.getFunctionName($receiver), CallInfoExtensionsKt.isNative($receiver), CallInfoExtensionsKt.hasSpreadOperator($receiver));
    }

    @Override
    @NotNull
    protected JsExpression extensionReceiver(@NotNull FunctionCallInfo $receiver) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (CallInfoExtensionsKt.isNative($receiver) && CallInfoExtensionsKt.hasSpreadOperator($receiver)) {
            return this.nativeSpreadFunWithDispatchOrExtensionReceiver($receiver.getArgumentsInfo(), CallInfoExtensionsKt.getFunctionName($receiver));
        }
        if (CallInfoExtensionsKt.isNative($receiver)) {
            return new JsInvocation((JsExpression)new JsNameRef(CallInfoExtensionsKt.getFunctionName($receiver), $receiver.getExtensionReceiver()), $receiver.getArgumentsInfo().getTranslateArguments());
        }
        JsExpression functionRef2 = CallInfoExtensionsKt.aliasOrValue($receiver.getContext(), CallInfoExtensionsKt.getCallableDescriptor($receiver), (Function1<? super CallableDescriptor, ? extends JsExpression>)new Function1<CallableDescriptor, JsNameRef>($receiver){
            final /* synthetic */ FunctionCallInfo receiver$0;

            @NotNull
            public final JsNameRef invoke(@NotNull CallableDescriptor it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                JsNameRef jsNameRef = this.receiver$0.getContext().getQualifiedReference(it);
                Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "context.getQualifiedReference(it)");
                return jsNameRef;
            }
            {
                this.receiver$0 = functionCallInfo;
                super(1);
            }
        });
        if (Intrinsics.areEqual(CallInfoExtensionsKt.getCallableDescriptor($receiver).getVisibility(), Visibilities.LOCAL)) {
            JsExpression jsExpression2 = Namer.getFunctionCallRef(functionRef2);
            jsExpression = jsExpression2;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "Namer.getFunctionCallRef(functionRef)");
        } else {
            jsExpression = functionRef2;
        }
        JsExpression referenceToCall = jsExpression;
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = $receiver.getArgumentsInfo();
        JsExpression jsExpression3 = $receiver.getExtensionReceiver();
        if (jsExpression3 == null) {
            Intrinsics.throwNpe();
        }
        return new JsInvocation(referenceToCall, FunctionCallCasesKt.argsWithReceiver(argumentsInfo, jsExpression3));
    }

    @Override
    @NotNull
    protected JsExpression bothReceivers(@NotNull FunctionCallInfo $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        JsName jsName = CallInfoExtensionsKt.getFunctionName($receiver);
        JsExpression jsExpression = $receiver.getDispatchReceiver();
        if (jsExpression == null) {
            Intrinsics.throwNpe();
        }
        JsNameRef functionRef2 = new JsNameRef(jsName, jsExpression);
        JsExpression jsExpression2 = functionRef2;
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = $receiver.getArgumentsInfo();
        JsExpression jsExpression3 = $receiver.getExtensionReceiver();
        if (jsExpression3 == null) {
            Intrinsics.throwNpe();
        }
        return new JsInvocation(jsExpression2, FunctionCallCasesKt.argsWithReceiver(argumentsInfo, jsExpression3));
    }

    private DefaultFunctionCallCase() {
        INSTANCE = this;
    }

    static {
        new DefaultFunctionCallCase();
    }
}

