/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public final class BindingUtils {
    private BindingUtils() {
    }

    @NotNull
    private static <E extends PsiElement, D extends DeclarationDescriptor> D getDescriptorForExpression(@NotNull BindingContext context, @NotNull E expression, Class<D> descriptorClass) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getDescriptorForExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getDescriptorForExpression"));
        }
        DeclarationDescriptor descriptor2 = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, expression);
        assert (descriptor2 != null);
        assert (descriptorClass.isInstance(descriptor2)) : ErrorReportingUtils.message(expression, ((Object)expression).toString() + " expected to have of type" + descriptorClass.toString());
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getDescriptorForExpression"));
        }
        return (D)declarationDescriptor;
    }

    @NotNull
    public static ClassDescriptor getClassDescriptor(@NotNull BindingContext context, @NotNull KtClassOrObject declaration) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getClassDescriptor"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getClassDescriptor"));
        }
        ClassDescriptor classDescriptor = BindingContextUtils.getNotNull(context, BindingContext.CLASS, declaration);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getClassDescriptor"));
        }
        return classDescriptor;
    }

    @NotNull
    public static FunctionDescriptor getFunctionDescriptor(@NotNull BindingContext context, @NotNull KtDeclarationWithBody declaration) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getFunctionDescriptor"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getFunctionDescriptor"));
        }
        FunctionDescriptor functionDescriptor = BindingUtils.getDescriptorForExpression(context, declaration, FunctionDescriptor.class);
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getFunctionDescriptor"));
        }
        return functionDescriptor;
    }

    @NotNull
    public static PropertyDescriptor getPropertyDescriptor(@NotNull BindingContext context, @NotNull KtProperty declaration) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getPropertyDescriptor"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getPropertyDescriptor"));
        }
        PropertyDescriptor propertyDescriptor = BindingUtils.getDescriptorForExpression(context, declaration, PropertyDescriptor.class);
        if (propertyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getPropertyDescriptor"));
        }
        return propertyDescriptor;
    }

    @NotNull
    private static KtParameter getParameterForDescriptor(@NotNull ValueParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getParameterForDescriptor"));
        }
        PsiElement result2 = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        assert (result2 instanceof KtParameter) : ErrorReportingUtils.message(descriptor2, "ValueParameterDescriptor should have corresponding JetParameter");
        KtParameter ktParameter = (KtParameter)result2;
        if (ktParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getParameterForDescriptor"));
        }
        return ktParameter;
    }

    public static boolean hasAncestorClass(@NotNull BindingContext context, @NotNull KtClassOrObject classDeclaration) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "hasAncestorClass"));
        }
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclaration", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "hasAncestorClass"));
        }
        ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(context, classDeclaration);
        List<ClassDescriptor> superclassDescriptors = DescriptorUtils.getSuperclassDescriptors(classDescriptor);
        return JsDescriptorUtils.findAncestorClass(superclassDescriptors) != null;
    }

    @NotNull
    public static KotlinType getTypeByReference(@NotNull BindingContext context, @NotNull KtTypeReference typeReference) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getTypeByReference"));
        }
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getTypeByReference"));
        }
        KotlinType kotlinType = BindingContextUtils.getNotNull(context, BindingContext.TYPE, typeReference);
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getTypeByReference"));
        }
        return kotlinType;
    }

    @Nullable
    public static PropertyDescriptor getPropertyDescriptorForConstructorParameter(@NotNull BindingContext context, @NotNull KtParameter parameter) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getPropertyDescriptorForConstructorParameter"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getPropertyDescriptorForConstructorParameter"));
        }
        return context.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
    }

    @Nullable
    public static DeclarationDescriptor getDescriptorForReferenceExpression(@NotNull BindingContext context, @NotNull KtReferenceExpression reference) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getDescriptorForReferenceExpression"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getDescriptorForReferenceExpression"));
        }
        if (BindingContextUtils.isExpressionWithValidReference(reference, context)) {
            return BindingUtils.resolveObjectViaTypeAlias(BindingContextUtils.getNotNull(context, BindingContext.REFERENCE_TARGET, reference));
        }
        return null;
    }

    @Nullable
    private static DeclarationDescriptor getNullableDescriptorForReferenceExpression(@NotNull BindingContext context, @NotNull KtReferenceExpression reference) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getNullableDescriptorForReferenceExpression"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getNullableDescriptorForReferenceExpression"));
        }
        DeclarationDescriptor descriptor2 = context.get(BindingContext.REFERENCE_TARGET, reference);
        return descriptor2 != null ? BindingUtils.resolveObjectViaTypeAlias(descriptor2) : null;
    }

    @NotNull
    private static DeclarationDescriptor resolveObjectViaTypeAlias(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "resolveObjectViaTypeAlias"));
        }
        if (descriptor2 instanceof TypeAliasDescriptor) {
            ClassDescriptor classDescriptor = ((TypeAliasDescriptor)descriptor2).getClassDescriptor();
            assert (classDescriptor != null) : "Class descriptor must be non-null in resolved typealias: " + descriptor2;
            if (classDescriptor.getKind() != ClassKind.OBJECT) {
                classDescriptor = classDescriptor.getCompanionObjectDescriptor();
                assert (classDescriptor != null) : "Resolved typealias must have non-null class descriptor: " + descriptor2;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            if (classDescriptor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "resolveObjectViaTypeAlias"));
            }
            return classDescriptor2;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "resolveObjectViaTypeAlias"));
        }
        return declarationDescriptor;
    }

    public static boolean isVariableReassignment(@NotNull BindingContext context, @NotNull KtExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "isVariableReassignment"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "isVariableReassignment"));
        }
        return BindingContextUtils.getNotNull(context, BindingContext.VARIABLE_REASSIGNMENT, expression);
    }

    @Nullable
    public static CallableDescriptor getCallableDescriptorForOperationExpression(@NotNull BindingContext context, @NotNull KtOperationExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getCallableDescriptorForOperationExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getCallableDescriptorForOperationExpression"));
        }
        KtSimpleNameExpression operationReference = expression.getOperationReference();
        DeclarationDescriptor descriptorForReferenceExpression = BindingUtils.getNullableDescriptorForReferenceExpression(context, operationReference);
        if (descriptorForReferenceExpression == null) {
            return null;
        }
        assert (descriptorForReferenceExpression instanceof CallableDescriptor) : ErrorReportingUtils.message(operationReference, "Operation should resolve to callable descriptor");
        return (CallableDescriptor)descriptorForReferenceExpression;
    }

    @NotNull
    public static DeclarationDescriptor getDescriptorForElement(@NotNull BindingContext context, @NotNull PsiElement element) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getDescriptorForElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getDescriptorForElement"));
        }
        DeclarationDescriptor declarationDescriptor = BindingContextUtils.getNotNull(context, BindingContext.DECLARATION_TO_DESCRIPTOR, element);
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getDescriptorForElement"));
        }
        return declarationDescriptor;
    }

    @Nullable
    public static Object getCompileTimeValue(@NotNull BindingContext context, @NotNull KtExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getCompileTimeValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getCompileTimeValue"));
        }
        CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression, context);
        if (compileTimeValue != null) {
            return BindingUtils.getCompileTimeValue(context, expression, compileTimeValue);
        }
        return null;
    }

    @Nullable
    public static Object getCompileTimeValue(@NotNull BindingContext context, @NotNull KtExpression expression, @NotNull CompileTimeConstant<?> constant) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getCompileTimeValue"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getCompileTimeValue"));
        }
        if (constant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constant", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getCompileTimeValue"));
        }
        KotlinType expectedType = context.getType(expression);
        return constant.getValue(expectedType == null ? TypeUtils.NO_EXPECTED_TYPE : expectedType);
    }

    @NotNull
    public static KtExpression getDefaultArgument(@NotNull ValueParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterDescriptor", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getDefaultArgument"));
        }
        ValueParameterDescriptor descriptorWhichDeclaresDefaultValue = BindingUtils.getOriginalDescriptorWhichDeclaresDefaultValue(parameterDescriptor);
        KtParameter psiParameter = BindingUtils.getParameterForDescriptor(descriptorWhichDeclaresDefaultValue);
        KtExpression defaultValue = psiParameter.getDefaultValue();
        assert (defaultValue != null) : ErrorReportingUtils.message(parameterDescriptor, "No default value found in PSI");
        KtExpression ktExpression = defaultValue;
        if (ktExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getDefaultArgument"));
        }
        return ktExpression;
    }

    private static ValueParameterDescriptor getOriginalDescriptorWhichDeclaresDefaultValue(@NotNull ValueParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterDescriptor", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getOriginalDescriptorWhichDeclaresDefaultValue"));
        }
        ValueParameterDescriptor result2 = parameterDescriptor;
        assert (DescriptorUtilsKt.hasDefaultValue(result2)) : ErrorReportingUtils.message(parameterDescriptor, "Unsupplied parameter must have default value");
        while (!result2.declaresDefaultValue()) {
            result2 = result2.getOverriddenDescriptors().iterator().next();
        }
        return result2;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getIteratorFunction(@NotNull BindingContext context, @NotNull KtExpression rangeExpression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getIteratorFunction"));
        }
        if (rangeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeExpression", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getIteratorFunction"));
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingContextUtils.getNotNull(context, BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, rangeExpression);
        if (resolvedCall2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getIteratorFunction"));
        }
        return resolvedCall2;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getNextFunction(@NotNull BindingContext context, @NotNull KtExpression rangeExpression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getNextFunction"));
        }
        if (rangeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeExpression", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getNextFunction"));
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingContextUtils.getNotNull(context, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, rangeExpression);
        if (resolvedCall2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getNextFunction"));
        }
        return resolvedCall2;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getHasNextCallable(@NotNull BindingContext context, @NotNull KtExpression rangeExpression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getHasNextCallable"));
        }
        if (rangeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeExpression", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getHasNextCallable"));
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingContextUtils.getNotNull(context, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, rangeExpression);
        if (resolvedCall2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getHasNextCallable"));
        }
        return resolvedCall2;
    }

    @NotNull
    public static KotlinType getTypeForExpression(@NotNull BindingContext context, @NotNull KtExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getTypeForExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getTypeForExpression"));
        }
        KotlinType kotlinType = BindingContextUtils.getTypeNotNull(context, expression);
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getTypeForExpression"));
        }
        return kotlinType;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getResolvedCallForArrayAccess(@NotNull BindingContext context, @NotNull KtArrayAccessExpression arrayAccessExpression, boolean isGet) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getResolvedCallForArrayAccess"));
        }
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getResolvedCallForArrayAccess"));
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingContextUtils.getNotNull(context, isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression);
        if (resolvedCall2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getResolvedCallForArrayAccess"));
        }
        return resolvedCall2;
    }

    @Nullable
    public static ResolvedCall<FunctionDescriptor> getSuperCall(@NotNull BindingContext context, KtClassOrObject classDeclaration) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/BindingUtils", "getSuperCall"));
        }
        for (KtSuperTypeListEntry specifier : classDeclaration.getSuperTypeListEntries()) {
            if (!(specifier instanceof KtSuperTypeCallEntry)) continue;
            KtSuperTypeCallEntry superCall = (KtSuperTypeCallEntry)specifier;
            return CallUtilKt.getResolvedCallWithAssert(superCall, context);
        }
        return null;
    }
}

