/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.stats;

import org.gradle.internal.time.Clock;

public class DaemonRunningStats {
    private final Clock daemonClock;
    private Clock currentBuildClock;
    private int buildCount;
    private long allBuildsTime;

    public DaemonRunningStats(Clock daemonClock) {
        this.daemonClock = daemonClock;
    }

    public int getBuildCount() {
        return this.buildCount;
    }

    public String getPrettyUpTime() {
        return this.daemonClock.getElapsed();
    }

    public long getStartTime() {
        return this.daemonClock.getStartTime();
    }

    public long getCurrentBuildStart() {
        return this.currentBuildClock.getStartTime();
    }

    public long getAllBuildsTime() {
        return this.allBuildsTime;
    }

    public void buildStarted() {
        ++this.buildCount;
        this.currentBuildClock = new Clock();
    }

    public void buildFinished() {
        long buildTime = Math.max(this.currentBuildClock.getElapsedMillis(), 1L);
        this.allBuildsTime += buildTime;
    }
}

