/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.mutex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.thread.ThreadManager;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;

public abstract class MutexOperations {
    @CompilerDirectives.TruffleBoundary
    protected static void lock(final ReentrantLock lock, final DynamicObject thread, RubyNode currentNode) {
        RubyContext context = currentNode.getContext();
        if (lock.isHeldByCurrentThread()) {
            throw new RaiseException(context.getCoreExceptions().threadErrorRecursiveLocking(currentNode));
        }
        context.getThreadManager().runUntilResult(currentNode, new ThreadManager.BlockingAction<Boolean>(){

            @Override
            public Boolean block() throws InterruptedException {
                lock.lockInterruptibly();
                Layouts.THREAD.getOwnedLocks(thread).add(lock);
                return true;
            }
        });
    }

    @CompilerDirectives.TruffleBoundary
    protected static void unlock(ReentrantLock lock, DynamicObject thread, RubyNode currentNode) {
        RubyContext context = currentNode.getContext();
        try {
            lock.unlock();
        }
        catch (IllegalMonitorStateException e) {
            if (!lock.isLocked()) {
                throw new RaiseException(context.getCoreExceptions().threadErrorUnlockNotLocked(currentNode));
            }
            throw new RaiseException(context.getCoreExceptions().threadErrorAlreadyLocked(currentNode));
        }
        Layouts.THREAD.getOwnedLocks(thread).remove(lock);
    }
}

