/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.threadlocal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.language.RubyNode;

public abstract class ThreadLocalObjectNode
extends RubyNode {
    @Override
    public abstract DynamicObject executeDynamicObject(VirtualFrame var1);

    @Specialization(guards={"cachedThread == getCurrentThread(frame)"}, limit="getCacheLimit()")
    protected DynamicObject getThreadLocalObjectCached(VirtualFrame frame, @Cached(value="getCurrentThread(frame)") DynamicObject cachedThread, @Cached(value="getThreadLocals(cachedThread)") DynamicObject cachedThreadLocals) {
        return cachedThreadLocals;
    }

    @Specialization(contains={"getThreadLocalObjectCached"})
    protected DynamicObject getThreadLocalObjectUncached(VirtualFrame frame) {
        return this.getThreadLocals(this.getCurrentThread(frame));
    }

    protected DynamicObject getCurrentThread(VirtualFrame frame) {
        return this.getContext().getThreadManager().getCurrentThread();
    }

    protected DynamicObject getThreadLocals(DynamicObject thread) {
        return Layouts.THREAD.getThreadLocals(thread);
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().THREAD_CACHE;
    }
}

