/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.BinaryOperatorParseNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;

public class AndParseNode
extends ParseNode
implements BinaryOperatorParseNode {
    private final ParseNode firstNode;
    private final ParseNode secondNode;

    public AndParseNode(SourceIndexLength position, ParseNode firstNode, ParseNode secondNode) {
        super(position, firstNode.containsVariableAssignment() || secondNode.containsVariableAssignment());
        assert (firstNode != null) : "AndParseNode.first == null";
        assert (secondNode != null) : "AndParseNode.second == null";
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ANDNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitAndNode(this);
    }

    @Override
    public ParseNode getSecondNode() {
        return this.secondNode;
    }

    @Override
    public ParseNode getFirstNode() {
        return this.firstNode;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.firstNode, this.secondNode);
    }
}

