/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.StarProjectionImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

public class CommonSupertypes {
    @Nullable
    public static KotlinType commonSupertypeForNonDenotableTypes(@NotNull Collection<KotlinType> types) {
        KotlinType type2;
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSupertypeForNonDenotableTypes"));
        }
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() == 1 && (type2 = types.iterator().next()).getConstructor() instanceof IntersectionTypeConstructor) {
            return CommonSupertypes.commonSupertypeForNonDenotableTypes(type2.getConstructor().getSupertypes());
        }
        return CommonSupertypes.commonSupertype(types);
    }

    @NotNull
    public static KotlinType commonSupertype(@NotNull Collection<KotlinType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSupertype"));
        }
        if (types.size() == 1) {
            KotlinType kotlinType = types.iterator().next();
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSupertype"));
            }
            return kotlinType;
        }
        KotlinType kotlinType = CommonSupertypes.findCommonSupertype(types, 0, CommonSupertypes.maxDepth(types) + 3);
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSupertype"));
        }
        return kotlinType;
    }

    private static int maxDepth(@NotNull Collection<KotlinType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "maxDepth"));
        }
        int max = 0;
        for (KotlinType type2 : types) {
            int depth = CommonSupertypes.depth(type2);
            if (max >= depth) continue;
            max = depth;
        }
        return max;
    }

    private static int depth(final @NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/CommonSupertypes", "depth"));
        }
        return 1 + CommonSupertypes.maxDepth(CollectionsKt.map(type2.getArguments(), new Function1<TypeProjection, KotlinType>(){

            @Override
            public KotlinType invoke(TypeProjection projection) {
                if (projection.isStarProjection()) {
                    return type2.getConstructor().getBuiltIns().getAnyType();
                }
                return projection.getType();
            }
        }));
    }

    @NotNull
    private static KotlinType findCommonSupertype(@NotNull Collection<KotlinType> types, int recursionDepth, int maxDepth) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "findCommonSupertype"));
        }
        assert (recursionDepth <= maxDepth) : "Recursion depth exceeded: " + recursionDepth + " > " + maxDepth + " for types " + types;
        boolean hasFlexible = false;
        ArrayList<SimpleType> upper = new ArrayList<SimpleType>(types.size());
        ArrayList<SimpleType> lower2 = new ArrayList<SimpleType>(types.size());
        for (KotlinType type2 : types) {
            UnwrappedType unwrappedType = type2.unwrap();
            if (unwrappedType instanceof FlexibleType) {
                if (DynamicTypesKt.isDynamic(type2)) {
                    KotlinType kotlinType = type2;
                    if (kotlinType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "findCommonSupertype"));
                    }
                    return kotlinType;
                }
                hasFlexible = true;
                FlexibleType flexibleType = (FlexibleType)type2;
                upper.add(flexibleType.getUpperBound());
                lower2.add(flexibleType.getLowerBound());
                continue;
            }
            SimpleType simpleType2 = (SimpleType)unwrappedType;
            upper.add(simpleType2);
            lower2.add(simpleType2);
        }
        if (!hasFlexible) {
            SimpleType simpleType3 = CommonSupertypes.commonSuperTypeForInflexible(upper, recursionDepth, maxDepth);
            if (simpleType3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "findCommonSupertype"));
            }
            return simpleType3;
        }
        UnwrappedType unwrappedType = KotlinTypeFactory.flexibleType(CommonSupertypes.commonSuperTypeForInflexible(lower2, recursionDepth, maxDepth), CommonSupertypes.commonSuperTypeForInflexible(upper, recursionDepth, maxDepth));
        if (unwrappedType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "findCommonSupertype"));
        }
        return unwrappedType;
    }

    @NotNull
    private static SimpleType commonSuperTypeForInflexible(@NotNull Collection<SimpleType> types, int recursionDepth, int maxDepth) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
        }
        assert (!types.isEmpty());
        HashSet<SimpleType> typeSet = new HashSet<SimpleType>(types);
        boolean nullable = false;
        Iterator iterator2 = typeSet.iterator();
        while (iterator2.hasNext()) {
            KotlinType type2 = (KotlinType)iterator2.next();
            assert (type2 != null);
            assert (!FlexibleTypesKt.isFlexible(type2)) : "Flexible type " + type2 + " passed to commonSuperTypeForInflexible";
            if (KotlinBuiltIns.isNothingOrNullableNothing(type2)) {
                iterator2.remove();
            }
            if (type2.isError()) {
                SimpleType simpleType2 = ErrorUtils.createErrorType("Supertype of error type " + type2);
                if (simpleType2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
                }
                return simpleType2;
            }
            nullable |= type2.isMarkedNullable();
        }
        if (typeSet.isEmpty()) {
            KotlinBuiltIns builtIns = types.iterator().next().getConstructor().getBuiltIns();
            SimpleType simpleType3 = nullable ? builtIns.getNullableNothingType() : builtIns.getNothingType();
            if (simpleType3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
            }
            return simpleType3;
        }
        if (typeSet.size() == 1) {
            SimpleType simpleType4 = TypeUtils.makeNullableIfNeeded((SimpleType)typeSet.iterator().next(), nullable);
            if (simpleType4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
            }
            return simpleType4;
        }
        Map<TypeConstructor, Set<SimpleType>> commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(typeSet);
        while (commonSupertypes.size() > 1) {
            HashSet<SimpleType> merge = new HashSet<SimpleType>();
            for (Set<SimpleType> supertypes2 : commonSupertypes.values()) {
                merge.addAll(supertypes2);
            }
            commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(merge);
        }
        assert (!commonSupertypes.isEmpty()) : commonSupertypes + " <- " + types;
        Map.Entry<TypeConstructor, Set<SimpleType>> entry = commonSupertypes.entrySet().iterator().next();
        SimpleType result2 = CommonSupertypes.computeSupertypeProjections(entry.getKey(), entry.getValue(), recursionDepth, maxDepth);
        SimpleType simpleType5 = TypeUtils.makeNullableIfNeeded(result2, nullable);
        if (simpleType5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
        }
        return simpleType5;
    }

    @NotNull
    private static Map<TypeConstructor, Set<SimpleType>> computeCommonRawSupertypes(@NotNull Collection<SimpleType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "computeCommonRawSupertypes"));
        }
        assert (!types.isEmpty());
        HashMap<TypeConstructor, Set<SimpleType>> constructorToAllInstances = new HashMap<TypeConstructor, Set<SimpleType>>();
        HashSet<TypeConstructor> commonSuperclasses = null;
        List<TypeConstructor> order = null;
        for (SimpleType type2 : types) {
            HashSet<TypeConstructor> visited2 = new HashSet<TypeConstructor>();
            order = CommonSupertypes.topologicallySortSuperclassesAndRecordAllInstances(type2, constructorToAllInstances, visited2);
            if (commonSuperclasses == null) {
                commonSuperclasses = visited2;
                continue;
            }
            commonSuperclasses.retainAll(visited2);
        }
        assert (order != null);
        HashSet<TypeConstructor> notSource = new HashSet<TypeConstructor>();
        HashMap<TypeConstructor, Set<SimpleType>> result2 = new HashMap<TypeConstructor, Set<SimpleType>>();
        for (TypeConstructor superConstructor : order) {
            if (!commonSuperclasses.contains(superConstructor) || notSource.contains(superConstructor)) continue;
            result2.put(superConstructor, (Set<SimpleType>)constructorToAllInstances.get(superConstructor));
            CommonSupertypes.markAll(superConstructor, notSource);
        }
        HashMap<TypeConstructor, Set<SimpleType>> hashMap = result2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeCommonRawSupertypes"));
        }
        return hashMap;
    }

    @NotNull
    private static SimpleType computeSupertypeProjections(@NotNull TypeConstructor constructor, @NotNull Set<SimpleType> types, int recursionDepth, int maxDepth) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        assert (!types.isEmpty());
        if (types.size() == 1) {
            SimpleType simpleType2 = types.iterator().next();
            if (simpleType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjections"));
            }
            return simpleType2;
        }
        List<TypeParameterDescriptor> parameters2 = constructor.getParameters();
        ArrayList<TypeProjection> newProjections = new ArrayList<TypeProjection>(parameters2.size());
        for (TypeParameterDescriptor parameterDescriptor : parameters2) {
            HashSet<TypeProjection> typeProjections = new HashSet<TypeProjection>();
            for (SimpleType type2 : types) {
                typeProjections.add(type2.getArguments().get(parameterDescriptor.getIndex()));
            }
            newProjections.add(CommonSupertypes.computeSupertypeProjection(parameterDescriptor, typeProjections, recursionDepth, maxDepth));
        }
        boolean nullable = false;
        for (SimpleType type3 : types) {
            nullable |= type3.isMarkedNullable();
        }
        ClassifierDescriptor classifier = constructor.getDeclarationDescriptor();
        MemberScope newScope = classifier instanceof ClassDescriptor ? ((ClassDescriptor)classifier).getMemberScope(newProjections) : (classifier instanceof TypeParameterDescriptor ? classifier.getDefaultType().getMemberScope() : ErrorUtils.createErrorScope("A scope for common supertype which is not a normal classifier", true));
        SimpleType simpleType3 = KotlinTypeFactory.simpleType(Annotations.Companion.getEMPTY(), constructor, newProjections, nullable, newScope);
        if (simpleType3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        return simpleType3;
    }

    @NotNull
    private static TypeProjection computeSupertypeProjection(@NotNull TypeParameterDescriptor parameterDescriptor, @NotNull Set<TypeProjection> typeProjections, int recursionDepth, int maxDepth) {
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterDescriptor", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        if (typeProjections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjections", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        TypeProjection singleBestProjection = FlexibleTypesKt.singleBestRepresentative(typeProjections);
        if (singleBestProjection != null) {
            TypeProjection typeProjection = singleBestProjection;
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjection;
        }
        if (recursionDepth >= maxDepth) {
            TypeProjection typeProjection = TypeUtils.makeStarProjection(parameterDescriptor);
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjection;
        }
        HashSet<KotlinType> ins = new HashSet<KotlinType>();
        HashSet<KotlinType> outs = new HashSet<KotlinType>();
        Variance variance = parameterDescriptor.getVariance();
        switch (variance) {
            case INVARIANT: {
                break;
            }
            case IN_VARIANCE: {
                outs = null;
                break;
            }
            case OUT_VARIANCE: {
                ins = null;
            }
        }
        for (TypeProjection projection : typeProjections) {
            Variance projectionKind = projection.getProjectionKind();
            if (projectionKind.getAllowsInPosition()) {
                if (ins != null) {
                    ins.add(projection.getType());
                }
            } else {
                ins = null;
            }
            if (projectionKind.getAllowsOutPosition()) {
                if (outs == null) continue;
                outs.add(projection.getType());
                continue;
            }
            outs = null;
        }
        if (outs != null) {
            assert (!outs.isEmpty()) : "Out projections is empty for parameter " + parameterDescriptor + ", type projections " + typeProjections;
            Variance projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
            KotlinType superType = CommonSupertypes.findCommonSupertype(outs, recursionDepth + 1, maxDepth);
            for (KotlinType upperBound : parameterDescriptor.getUpperBounds()) {
                if (TypeUtilsKt.isSubtypeOf(superType, upperBound)) continue;
                StarProjectionImpl starProjectionImpl = new StarProjectionImpl(parameterDescriptor);
                if (starProjectionImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
                }
                return starProjectionImpl;
            }
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(projectionKind, superType);
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjectionImpl;
        }
        if (ins != null) {
            assert (!ins.isEmpty()) : "In projections is empty for parameter " + parameterDescriptor + ", type projections " + typeProjections;
            KotlinType intersection = TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, ins);
            if (intersection == null) {
                TypeProjection typeProjection = TypeUtils.makeStarProjection(parameterDescriptor);
                if (typeProjection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
                }
                return typeProjection;
            }
            Variance projectionKind = variance == Variance.IN_VARIANCE ? Variance.INVARIANT : Variance.IN_VARIANCE;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(projectionKind, intersection);
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjectionImpl;
        }
        TypeProjection typeProjection = TypeUtils.makeStarProjection(parameterDescriptor);
        if (typeProjection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        return typeProjection;
    }

    private static void markAll(@NotNull TypeConstructor typeConstructor2, @NotNull Set<TypeConstructor> markerSet) {
        if (typeConstructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/kotlin/types/CommonSupertypes", "markAll"));
        }
        if (markerSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markerSet", "org/jetbrains/kotlin/types/CommonSupertypes", "markAll"));
        }
        markerSet.add(typeConstructor2);
        for (KotlinType type2 : typeConstructor2.getSupertypes()) {
            CommonSupertypes.markAll(type2.getConstructor(), markerSet);
        }
    }

    @NotNull
    public static List<TypeConstructor> topologicallySortSuperclassesAndRecordAllInstances(@NotNull SimpleType type2, final @NotNull Map<TypeConstructor, Set<SimpleType>> constructorToAllInstances, final @NotNull Set<TypeConstructor> visited2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/CommonSupertypes", "topologicallySortSuperclassesAndRecordAllInstances"));
        }
        if (constructorToAllInstances == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorToAllInstances", "org/jetbrains/kotlin/types/CommonSupertypes", "topologicallySortSuperclassesAndRecordAllInstances"));
        }
        if (visited2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "org/jetbrains/kotlin/types/CommonSupertypes", "topologicallySortSuperclassesAndRecordAllInstances"));
        }
        List list2 = DFS.dfs(Collections.singletonList(type2), new DFS.Neighbors<SimpleType>(){

            @Override
            @NotNull
            public Iterable<? extends SimpleType> getNeighbors(SimpleType current) {
                TypeSubstitutor substitutor2 = TypeSubstitutor.create(current);
                Collection<KotlinType> supertypes2 = current.getConstructor().getSupertypes();
                ArrayList<SimpleType> result2 = new ArrayList<SimpleType>(supertypes2.size());
                for (KotlinType supertype : supertypes2) {
                    if (visited2.contains(supertype.getConstructor())) continue;
                    result2.add(FlexibleTypesKt.lowerIfFlexible(substitutor2.safeSubstitute(supertype, Variance.INVARIANT)));
                }
                ArrayList<SimpleType> arrayList = result2;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes$2", "getNeighbors"));
                }
                return arrayList;
            }
        }, new DFS.Visited<SimpleType>(){

            @Override
            public boolean checkAndMarkVisited(SimpleType current) {
                return visited2.add(current.getConstructor());
            }
        }, new DFS.NodeHandlerWithListResult<SimpleType, TypeConstructor>(){

            @Override
            public boolean beforeChildren(SimpleType current) {
                TypeConstructor constructor = current.getConstructor();
                HashSet<SimpleType> instances = (HashSet<SimpleType>)constructorToAllInstances.get(constructor);
                if (instances == null) {
                    instances = new HashSet<SimpleType>();
                    constructorToAllInstances.put(constructor, instances);
                }
                instances.add(current);
                return true;
            }

            @Override
            public void afterChildren(SimpleType current) {
                ((LinkedList)this.result).addFirst(current.getConstructor());
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "topologicallySortSuperclassesAndRecordAllInstances"));
        }
        return list2;
    }
}

