var searchIndex = {};
searchIndex["alloc"] = {"doc":"# The Rust core allocation library","items":[[0,"heap","alloc","",null,null],[5,"allocate","alloc::heap","Return a pointer to `size` bytes of memory aligned to `align`.",null,null],[5,"reallocate","","Resize the allocation referenced by `ptr` to `size` bytes.",null,null],[5,"reallocate_inplace","","Resize the allocation referenced by `ptr` to `size` bytes.",null,null],[5,"deallocate","","Deallocates the memory referenced by `ptr`.",null,null],[5,"usable_size","","Returns the usable size of an allocation created with the specified the\n`size` and `align`.",null,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"usize"}}],[17,"EMPTY","","An arbitrary non-null address to represent zero-size allocations.",null,null],[0,"boxed","alloc","A pointer type for heap allocation.",null,null],[3,"ExchangeHeapSingleton","alloc::boxed","This the singleton type used solely for `boxed::HEAP`.",null,null],[3,"Box","","A pointer type for heap allocation.",null,null],[3,"IntermediateBox","","`IntermediateBox` represents uninitialized backing storage for `Box`.",null,null],[17,"HEAP","","A value that represents the heap. This is the default place that the `box`\nkeyword allocates into when no place is supplied.",null,null],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed\nclosure objects. The idea is that where one would normally store a\n`Box&lt;FnOnce()&gt;` in a data structure, you should use\n`Box&lt;FnBox()&gt;`. The two traits behave essentially the same, except\nthat a `FnBox` closure can only be called if it is boxed. (Note\nthat `FnBox` may be deprecated in the future if `Box&lt;FnOnce()&gt;`\nclosures become directly usable.)",null,null],[16,"Output","","",0,null],[10,"call_box","","",0,null],[11,"clone","","",1,null],[11,"pointer","","",2,null],[11,"make_place","","",2,{"inputs":[],"output":{"name":"intermediatebox"}}],[11,"finalize","","",2,null],[11,"finalize","","",3,{"inputs":[{"name":"intermediatebox"}],"output":{"name":"box"}}],[11,"make_place","","",1,null],[11,"drop","","",2,null],[11,"new","","Allocates memory on the heap and then places `x` into it.",3,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"from_raw","","Constructs a box from a raw pointer.",3,null],[11,"into_raw","","Consumes the `Box`, returning the wrapped raw pointer.",3,null],[11,"default","","Creates a `Box&lt;T&gt;`, with the `Default` value for T.",3,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",3,{"inputs":[],"output":{"name":"box"}}],[11,"clone","","Returns a new box with a `clone()` of this box&#39;s contents.",3,null],[11,"clone_from","","Copies `source`&#39;s contents into `self` without creating a new allocation.",3,null],[11,"clone","","",3,null],[11,"eq","","",3,null],[11,"ne","","",3,null],[11,"partial_cmp","","",3,null],[11,"lt","","",3,null],[11,"le","","",3,null],[11,"ge","","",3,null],[11,"gt","","",3,null],[11,"cmp","","",3,null],[11,"hash","","",3,null],[11,"from","","",3,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",3,null],[11,"downcast","","Attempt to downcast the box to a concrete type.",3,null],[11,"fmt","","",3,null],[11,"fmt","","",3,null],[11,"fmt","","",3,null],[11,"deref","","",3,null],[11,"deref_mut","","",3,null],[11,"next","","",3,null],[11,"size_hint","","",3,null],[11,"nth","","",3,null],[11,"next_back","","",3,null],[11,"len","","",3,null],[11,"is_empty","","",3,null],[11,"call_once","","",3,null],[11,"call_once","","",3,null],[11,"clone","","",3,null],[11,"borrow","","",3,null],[11,"borrow_mut","","",3,null],[11,"as_ref","","",3,null],[11,"as_mut","","",3,null],[0,"arc","alloc","Thread-safe reference-counting pointers.",null,null],[3,"Arc","alloc::arc","A thread-safe reference-counting pointer.",null,null],[3,"Weak","","A weak version of [`Arc`][arc].",null,null],[11,"fmt","","",4,null],[11,"new","","Constructs a new `Arc&lt;T&gt;`.",5,{"inputs":[{"name":"t"}],"output":{"name":"arc"}}],[11,"try_unwrap","","Returns the contained value, if the `Arc` has exactly one strong reference.",5,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"into_raw","","Consumes the `Arc`, returning the wrapped pointer.",5,null],[11,"from_raw","","Constructs an `Arc` from a raw pointer.",5,null],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",5,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",5,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"strong_count","","Gets the number of strong (`Arc`) pointers to this value.",5,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"ptr_eq","","Returns true if the two `Arc`s point to the same value (not\njust values that compare as equal).",5,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"clone","","Makes a clone of the `Arc` pointer.",5,null],[11,"deref","","",5,null],[11,"make_mut","","Makes a mutable reference into the given `Arc`.",5,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"get_mut","","Returns a mutable reference to the inner value, if there are\nno other `Arc` or [`Weak`][weak] pointers to the same value.",5,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"drop","","Drops the `Arc`.",5,null],[11,"new","","Constructs a new `Weak&lt;T&gt;`, without an accompanying instance of `T`.",4,{"inputs":[],"output":{"name":"weak"}}],[11,"upgrade","","Upgrades the `Weak` pointer to an [`Arc`][arc], if possible.",4,null],[11,"clone","","Makes a clone of the `Weak` pointer.",4,null],[11,"default","","Constructs a new `Weak&lt;T&gt;`, without an accompanying instance of `T`.",4,{"inputs":[],"output":{"name":"weak"}}],[11,"drop","","Drops the `Weak` pointer.",4,null],[11,"eq","","Equality for two `Arc`s.",5,null],[11,"ne","","Inequality for two `Arc`s.",5,null],[11,"partial_cmp","","Partial comparison for two `Arc`s.",5,null],[11,"lt","","Less-than comparison for two `Arc`s.",5,null],[11,"le","","&#39;Less than or equal to&#39; comparison for two `Arc`s.",5,null],[11,"gt","","Greater-than comparison for two `Arc`s.",5,null],[11,"ge","","&#39;Greater than or equal to&#39; comparison for two `Arc`s.",5,null],[11,"cmp","","Comparison for two `Arc`s.",5,null],[11,"fmt","","",5,null],[11,"fmt","","",5,null],[11,"fmt","","",5,null],[11,"default","","Creates a new `Arc&lt;T&gt;`, with the `Default` value for `T`.",5,{"inputs":[],"output":{"name":"arc"}}],[11,"hash","","",5,null],[11,"from","","",5,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"borrow","","",5,null],[11,"as_ref","","",5,null],[0,"rc","alloc","Single-threaded reference-counting pointers.",null,null],[3,"Rc","alloc::rc","A single-threaded reference-counting pointer.",null,null],[3,"Weak","","A weak version of [`Rc`][rc].",null,null],[11,"new","","Constructs a new `Rc&lt;T&gt;`.",6,{"inputs":[{"name":"t"}],"output":{"name":"rc"}}],[11,"try_unwrap","","Returns the contained value, if the `Rc` has exactly one strong reference.",6,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"would_unwrap","","Checks whether [`Rc::try_unwrap`][try_unwrap] would return\n[`Ok`].",6,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"into_raw","","Consumes the `Rc`, returning the wrapped pointer.",6,null],[11,"from_raw","","Constructs an `Rc` from a raw pointer.",6,null],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",6,{"inputs":[{"name":"self"}],"output":{"name":"weak"}}],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",6,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"strong_count","","Gets the number of strong (`Rc`) pointers to this value.",6,{"inputs":[{"name":"self"}],"output":{"name":"usize"}}],[11,"is_unique","","Returns true if there are no other `Rc` or [`Weak`][weak] pointers to\nthis inner value.",6,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"get_mut","","Returns a mutable reference to the inner value, if there are\nno other `Rc` or [`Weak`][weak] pointers to the same value.",6,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"ptr_eq","","Returns true if the two `Rc`s point to the same value (not\njust values that compare as equal).",6,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"bool"}}],[11,"make_mut","","Makes a mutable reference into the given `Rc`.",6,{"inputs":[{"name":"self"}],"output":{"name":"t"}}],[11,"deref","","",6,null],[11,"drop","","Drops the `Rc`.",6,null],[11,"clone","","Makes a clone of the `Rc` pointer.",6,null],[11,"default","","Creates a new `Rc&lt;T&gt;`, with the `Default` value for `T`.",6,{"inputs":[],"output":{"name":"rc"}}],[11,"eq","","Equality for two `Rc`s.",6,null],[11,"ne","","Inequality for two `Rc`s.",6,null],[11,"partial_cmp","","Partial comparison for two `Rc`s.",6,null],[11,"lt","","Less-than comparison for two `Rc`s.",6,null],[11,"le","","&#39;Less than or equal to&#39; comparison for two `Rc`s.",6,null],[11,"gt","","Greater-than comparison for two `Rc`s.",6,null],[11,"ge","","&#39;Greater than or equal to&#39; comparison for two `Rc`s.",6,null],[11,"cmp","","Comparison for two `Rc`s.",6,null],[11,"hash","","",6,null],[11,"fmt","","",6,null],[11,"fmt","","",6,null],[11,"fmt","","",6,null],[11,"from","","",6,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[11,"new","","Constructs a new `Weak&lt;T&gt;`, without an accompanying instance of `T`.",7,{"inputs":[],"output":{"name":"weak"}}],[11,"upgrade","","Upgrades the `Weak` pointer to an [`Rc`][rc], if possible.",7,null],[11,"drop","","Drops the `Weak` pointer.",7,null],[11,"clone","","Makes a clone of the `Weak` pointer.",7,null],[11,"fmt","","",7,null],[11,"default","","Constructs a new `Weak&lt;T&gt;`, without an accompanying instance of `T`.",7,{"inputs":[],"output":{"name":"weak"}}],[11,"borrow","","",6,null],[11,"as_ref","","",6,null],[0,"raw_vec","alloc","",null,null],[3,"RawVec","alloc::raw_vec","A low-level utility for more ergonomically allocating, reallocating, and deallocating\na buffer of memory on the heap without having to worry about all the corner cases\ninvolved. This type is excellent for building your own data structures like Vec and VecDeque.\nIn particular:",null,null],[11,"new","","Creates the biggest possible RawVec without allocating. If T has positive\nsize, then this makes a RawVec with capacity 0. If T has 0 size, then it\nit makes a RawVec with capacity `usize::MAX`. Useful for implementing\ndelayed allocation.",8,{"inputs":[],"output":{"name":"self"}}],[11,"with_capacity","","Creates a RawVec with exactly the capacity and alignment requirements\nfor a `[T; cap]`. This is equivalent to calling RawVec::new when `cap` is 0\nor T is zero-sized. Note that if `T` is zero-sized this means you will *not*\nget a RawVec with the requested capacity!",8,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"from_raw_parts","","Reconstitutes a RawVec from a pointer and capacity.",8,null],[11,"from_box","","Converts a `Box&lt;[T]&gt;` into a `RawVec&lt;T&gt;`.",8,{"inputs":[{"name":"box"}],"output":{"name":"self"}}],[11,"ptr","","Gets a raw pointer to the start of the allocation. Note that this is\nheap::EMPTY if `cap = 0` or T is zero-sized. In the former case, you must\nbe careful.",8,null],[11,"cap","","Gets the capacity of the allocation.",8,null],[11,"double","","Doubles the size of the type&#39;s backing allocation. This is common enough\nto want to do that it&#39;s easiest to just have a dedicated method. Slightly\nmore efficient logic can be provided for this than the general case.",8,null],[11,"double_in_place","","Attempts to double the size of the type&#39;s backing allocation in place. This is common\nenough to want to do that it&#39;s easiest to just have a dedicated method. Slightly\nmore efficient logic can be provided for this than the general case.",8,null],[11,"reserve_exact","","Ensures that the buffer contains at least enough space to hold\n`used_cap + needed_extra_cap` elements. If it doesn&#39;t already,\nwill reallocate the minimum possible amount of memory necessary.\nGenerally this will be exactly the amount of memory necessary,\nbut in principle the allocator is free to give back more than\nwe asked for.",8,null],[11,"reserve","","Ensures that the buffer contains at least enough space to hold\n`used_cap + needed_extra_cap` elements. If it doesn&#39;t already have\nenough capacity, will reallocate enough space plus comfortable slack\nspace to get amortized `O(1)` behavior. Will limit this behavior\nif it would needlessly cause itself to panic.",8,null],[11,"reserve_in_place","","Attempts to ensure that the buffer contains at least enough space to hold\n`used_cap + needed_extra_cap` elements. If it doesn&#39;t already have\nenough capacity, will reallocate in place enough space plus comfortable slack\nspace to get amortized `O(1)` behaviour. Will limit this behaviour\nif it would needlessly cause itself to panic.",8,null],[11,"shrink_to_fit","","Shrinks the allocation down to the specified amount. If the given amount\nis 0, actually completely deallocates.",8,null],[11,"into_box","","Converts the entire buffer into `Box&lt;[T]&gt;`.",8,null],[11,"drop","","Frees the memory owned by the RawVec *without* trying to Drop its contents.",8,null],[0,"oom","alloc","",null,null],[5,"set_oom_handler","alloc::oom","Set a custom handler for out-of-memory conditions",null,null],[5,"oom","","Common out-of-memory routine",null,null]],"paths":[[8,"FnBox"],[3,"ExchangeHeapSingleton"],[3,"IntermediateBox"],[3,"Box"],[3,"Weak"],[3,"Arc"],[3,"Rc"],[3,"Weak"],[3,"RawVec"]]};
searchIndex["collections"] = {"doc":"Collection types.","items":[[0,"boxed","collections","A pointer type for heap allocation.",null,null],[17,"HEAP","collections::boxed","A value that represents the heap. This is the default place that the `box`\nkeyword allocates into when no place is supplied.",null,null],[3,"ExchangeHeapSingleton","","This the singleton type used solely for `boxed::HEAP`.",null,null],[3,"Box","","A pointer type for heap allocation.",null,null],[3,"IntermediateBox","","`IntermediateBox` represents uninitialized backing storage for `Box`.",null,null],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed\nclosure objects. The idea is that where one would normally store a\n`Box&lt;FnOnce()&gt;` in a data structure, you should use\n`Box&lt;FnBox()&gt;`. The two traits behave essentially the same, except\nthat a `FnBox` closure can only be called if it is boxed. (Note\nthat `FnBox` may be deprecated in the future if `Box&lt;FnOnce()&gt;`\nclosures become directly usable.)",null,null],[16,"Output","","",0,null],[10,"call_box","","",0,null],[4,"Bound","collections","An endpoint of a range of keys.",null,null],[13,"Included","","An inclusive bound.",1,null],[13,"Excluded","","An exclusive bound.",1,null],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in this direction.",1,null],[0,"binary_heap","","A priority queue implemented with a binary heap.",null,null],[3,"BinaryHeap","collections::binary_heap","A priority queue implemented with a binary heap.",null,null],[3,"PeekMut","","A container object that represents the result of the [`peek_mut()`] method\non `BinaryHeap`. See its documentation for details.",null,null],[3,"Iter","","`BinaryHeap` iterator.",null,null],[3,"IntoIter","","An iterator that moves out of a `BinaryHeap`.",null,null],[3,"Drain","","An iterator that drains a `BinaryHeap`.",null,null],[11,"drop","","",2,null],[11,"deref","","",2,null],[11,"deref_mut","","",2,null],[11,"clone","","",3,null],[11,"clone_from","","",3,null],[11,"default","","Creates an empty `BinaryHeap&lt;T&gt;`.",3,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"fmt","","",3,null],[11,"new","","Creates an empty `BinaryHeap` as a max-heap.",3,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"with_capacity","","Creates an empty `BinaryHeap` with a specific capacity.\nThis preallocates enough memory for `capacity` elements,\nso that the `BinaryHeap` does not have to be reallocated\nuntil it contains at least that many values.",3,{"inputs":[{"name":"usize"}],"output":{"name":"binaryheap"}}],[11,"iter","","Returns an iterator visiting all values in the underlying vector, in\narbitrary order.",3,null],[11,"peek","","Returns the greatest item in the binary heap, or `None` if it is empty.",3,null],[11,"peek_mut","","Returns a mutable reference to the greatest item in the binary heap, or\n`None` if it is empty.",3,null],[11,"capacity","","Returns the number of elements the binary heap can hold without reallocating.",3,null],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the\ngiven `BinaryHeap`. Does nothing if the capacity is already sufficient.",3,null],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the\n`BinaryHeap`. The collection may reserve more space to avoid frequent reallocations.",3,null],[11,"shrink_to_fit","","Discards as much additional capacity as possible.",3,null],[11,"pop","","Removes the greatest item from the binary heap and returns it, or `None` if it\nis empty.",3,null],[11,"push","","Pushes an item onto the binary heap.",3,null],[11,"push_pop","","Pushes an item onto the binary heap, then pops the greatest item off the queue in\nan optimized fashion.",3,null],[11,"replace","","Pops the greatest item off the binary heap, then pushes an item onto the queue in\nan optimized fashion. The push is done regardless of whether the binary heap\nwas empty.",3,null],[11,"into_vec","","Consumes the `BinaryHeap` and returns the underlying vector\nin arbitrary order.",3,null],[11,"into_sorted_vec","","Consumes the `BinaryHeap` and returns a vector in sorted\n(ascending) order.",3,null],[11,"len","","Returns the length of the binary heap.",3,null],[11,"is_empty","","Checks if the binary heap is empty.",3,null],[11,"drain","","Clears the binary heap, returning an iterator over the removed elements.",3,null],[11,"clear","","Drops all items from the binary heap.",3,null],[11,"append","","Moves all the elements of `other` into `self`, leaving `other` empty.",3,null],[11,"clone","","",4,null],[11,"next","","",4,null],[11,"size_hint","","",4,null],[11,"next_back","","",4,null],[11,"is_empty","","",4,null],[11,"clone","","",5,null],[11,"next","","",5,null],[11,"size_hint","","",5,null],[11,"next_back","","",5,null],[11,"is_empty","","",5,null],[11,"next","","",6,null],[11,"size_hint","","",6,null],[11,"next_back","","",6,null],[11,"is_empty","","",6,null],[11,"from","","",3,{"inputs":[{"name":"vec"}],"output":{"name":"binaryheap"}}],[11,"from_iter","","",3,{"inputs":[{"name":"i"}],"output":{"name":"binaryheap"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of\nthe binary heap in arbitrary order. The binary heap cannot be used\nafter calling this.",3,null],[11,"extend","","",3,null],[11,"extend","","",3,null],[0,"borrow","collections","A module for working with borrowed data.",null,null],[8,"Borrow","collections::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",7,null],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",8,null],[4,"Cow","","A clone-on-write smart pointer.",null,null],[13,"Borrowed","","Borrowed data.",9,null],[13,"Owned","","Owned data.",9,null],[8,"ToOwned","","A generalization of `Clone` to borrowed data.",null,null],[16,"Owned","","",10,null],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",10,null],[11,"borrow","","",9,null],[11,"clone","","",9,null],[11,"to_mut","","Acquires a mutable reference to the owned form of the data.",9,null],[11,"into_owned","","Extracts the owned data.",9,null],[11,"deref","","",9,null],[11,"cmp","","",9,null],[11,"eq","","",9,null],[11,"partial_cmp","","",9,null],[11,"fmt","","",9,null],[11,"fmt","","",9,null],[11,"default","","Creates an owned Cow&lt;&#39;a, B&gt; with the default value for the contained owned value.",9,{"inputs":[],"output":{"name":"cow"}}],[11,"hash","","",9,null],[11,"as_ref","","",9,null],[11,"add","","",9,null],[11,"add","","",9,null],[11,"add_assign","","",9,null],[11,"add_assign","","",9,null],[0,"enum_set","collections","A structure for holding a set of enum variants.",null,null],[3,"EnumSet","collections::enum_set","A specialized set implementation to use enum types.",null,null],[3,"Iter","","An iterator over an EnumSet",null,null],[8,"CLike","","An interface for casting C-like enum to usize and back.\nA typically implementation is as below.",null,null],[10,"to_usize","","Converts a C-like enum to a `usize`.",11,null],[10,"from_usize","","Converts a `usize` to a C-like enum.",11,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"eq","","",12,null],[11,"ne","","",12,null],[11,"partial_cmp","","",12,null],[11,"lt","","",12,null],[11,"le","","",12,null],[11,"gt","","",12,null],[11,"ge","","",12,null],[11,"cmp","","",12,null],[11,"hash","","",12,null],[11,"clone","","",12,null],[11,"fmt","","",12,null],[11,"new","","Returns an empty `EnumSet`.",12,{"inputs":[],"output":{"name":"enumset"}}],[11,"len","","Returns the number of elements in the given `EnumSet`.",12,null],[11,"is_empty","","Returns true if the `EnumSet` is empty.",12,null],[11,"clear","","",12,null],[11,"is_disjoint","","Returns `false` if the `EnumSet` contains any enum of the given `EnumSet`.",12,null],[11,"is_superset","","Returns `true` if a given `EnumSet` is included in this `EnumSet`.",12,null],[11,"is_subset","","Returns `true` if this `EnumSet` is included in the given `EnumSet`.",12,null],[11,"union","","Returns the union of both `EnumSets`.",12,null],[11,"intersection","","Returns the intersection of both `EnumSets`.",12,null],[11,"insert","","Adds an enum to the `EnumSet`, and returns `true` if it wasn&#39;t there before",12,null],[11,"remove","","Removes an enum from the EnumSet",12,null],[11,"contains","","Returns `true` if an `EnumSet` contains a given enum.",12,null],[11,"iter","","Returns an iterator over an `EnumSet`.",12,null],[11,"sub","","",12,null],[11,"bitor","","",12,null],[11,"bitand","","",12,null],[11,"bitxor","","",12,null],[11,"clone","","",13,null],[11,"next","","",13,null],[11,"size_hint","","",13,null],[11,"from_iter","","",12,{"inputs":[{"name":"i"}],"output":{"name":"enumset"}}],[11,"extend","","",12,null],[11,"extend","","",12,null],[0,"fmt","collections","Utilities for formatting and printing `String`s",null,null],[3,"Formatter","collections::fmt","A struct to represent both where to emit formatting strings to and how they\nshould be formatted. A mutable version of this is passed to all formatting\ntraits.",null,null],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write\nsucceeded.",14,null],[11,"write_char","","Writes a `char` into this writer, returning whether the write succeeded.",14,null],[11,"write_fmt","","Glue for usage of the `write!` macro with implementors of this trait.",14,null],[8,"Octal","","Format trait for the `o` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",15,null],[8,"Binary","","Format trait for the `b` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",16,null],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",17,null],[8,"Debug","","Format trait for the `?` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",18,null],[8,"LowerHex","","Format trait for the `x` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",19,null],[8,"UpperHex","","Format trait for the `X` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",20,null],[8,"Pointer","","Format trait for the `p` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",21,null],[8,"LowerExp","","Format trait for the `e` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",22,null],[8,"UpperExp","","Format trait for the `E` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",23,null],[3,"Error","","The error type which is returned from formatting a message into a stream.",null,null],[3,"Arguments","","This structure represents a safely precompiled version of a format string\nand its arguments. This cannot be generated at runtime because it cannot\nsafely be done so, so no constructors are given and the fields are private\nto prevent modification.",null,null],[5,"write","","The `write` function takes an output stream, a precompiled format string,\nand a list of arguments. The arguments will be formatted according to the\nspecified format string into the output stream provided.",null,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[5,"format","","The format function takes a precompiled format string and a list of\narguments, to return the resulting formatted string.",null,{"inputs":[{"name":"arguments"}],"output":{"name":"string"}}],[0,"linked_list","collections","A doubly-linked list with owned nodes.",null,null],[3,"LinkedList","collections::linked_list","A doubly-linked list.",null,null],[3,"Iter","","An iterator over references to the elements of a `LinkedList`.",null,null],[3,"IterMut","","An iterator over mutable references to the elements of a `LinkedList`.",null,null],[3,"IntoIter","","An iterator over the elements of a `LinkedList`.",null,null],[3,"FrontPlace","","A place for insertion at the front of a `LinkedList`.",null,null],[3,"BackPlace","","A place for insertion at the back of a `LinkedList`.",null,null],[11,"clone","","",24,null],[11,"clone","","",25,null],[11,"default","","Creates an empty `LinkedList&lt;T&gt;`.",26,{"inputs":[],"output":{"name":"self"}}],[11,"new","","Creates an empty `LinkedList`.",26,{"inputs":[],"output":{"name":"self"}}],[11,"append","","Moves all elements from `other` to the end of the list.",26,null],[11,"iter","","Provides a forward iterator.",26,null],[11,"iter_mut","","Provides a forward iterator with mutable references.",26,null],[11,"is_empty","","Returns `true` if the `LinkedList` is empty.",26,null],[11,"len","","Returns the length of the `LinkedList`.",26,null],[11,"clear","","Removes all elements from the `LinkedList`.",26,null],[11,"contains","","Returns `true` if the `LinkedList` contains an element equal to the\ngiven value.",26,null],[11,"front","","Provides a reference to the front element, or `None` if the list is\nempty.",26,null],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the list\nis empty.",26,null],[11,"back","","Provides a reference to the back element, or `None` if the list is\nempty.",26,null],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the list\nis empty.",26,null],[11,"push_front","","Adds an element first in the list.",26,null],[11,"pop_front","","Removes the first element and returns it, or `None` if the list is\nempty.",26,null],[11,"push_back","","Appends an element to the back of a list",26,null],[11,"pop_back","","Removes the last element from a list and returns it, or `None` if\nit is empty.",26,null],[11,"split_off","","Splits the list into two at the given index. Returns everything after the given index,\nincluding the index.",26,null],[11,"front_place","","Returns a place for insertion at the front of the list.",26,null],[11,"back_place","","Returns a place for insertion at the back of the list.",26,null],[11,"drop","","",26,null],[11,"next","","",24,null],[11,"size_hint","","",24,null],[11,"next_back","","",24,null],[11,"next","","",27,null],[11,"size_hint","","",27,null],[11,"next_back","","",27,null],[11,"insert_next","","Inserts the given element just after the element most recently returned by `.next()`.\nThe inserted element does not appear in the iteration.",27,null],[11,"peek_next","","Provides a reference to the next element, without changing the iterator.",27,null],[11,"next","","",25,null],[11,"size_hint","","",25,null],[11,"next_back","","",25,null],[11,"from_iter","","",26,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[11,"into_iter","","Consumes the list into an iterator yielding elements by value.",26,null],[11,"extend","","",26,null],[11,"extend","","",26,null],[11,"eq","","",26,null],[11,"ne","","",26,null],[11,"partial_cmp","","",26,null],[11,"cmp","","",26,null],[11,"clone","","",26,null],[11,"fmt","","",26,null],[11,"hash","","",26,null],[11,"make_place","","",28,null],[11,"pointer","","",28,null],[11,"finalize","","",28,null],[11,"make_place","","",29,null],[11,"pointer","","",29,null],[11,"finalize","","",29,null],[0,"range","collections","Range syntax.",null,null],[8,"RangeArgument","collections::range","**RangeArgument** is implemented by Rust&#39;s built-in range types, produced\nby range syntax like `..`, `a..`, `..b` or `c..d`.",null,null],[11,"start","","Start index (inclusive)",30,null],[11,"end","","End index (exclusive)",30,null],[0,"slice","collections","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[3,"Chunks","collections::slice","An iterator over a slice in (non-overlapping) chunks (`size` elements at a\ntime).",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Iter","","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"SplitMut","","An iterator over the subslices of the vector which are separated\nby elements that match `pred`.",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`size`\nelements at a time). When the slice len is not evenly divided by the chunk\nsize, the last slice of the iteration will be the remainder.",null,null],[3,"Split","","An iterator over subslices separated by elements that match a predicate\nfunction.",null,null],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate\nfunction, limited to a given number of splits.",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that match a\npredicate function, limited to a given number of splits, starting\nfrom the end of the slice.",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate\nfunction, limited to a given number of splits.",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a\npredicate function, limited to a given number of splits, starting\nfrom the end of the slice.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable\nslice is returned.",null,null],[8,"SliceIndex","","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",31,null],[10,"get","","Returns a shared reference to the output at this location, if in\nbounds.",31,null],[10,"get_mut","","Returns a mutable reference to the output at this location, if in\nbounds.",31,null],[10,"get_unchecked","","Returns a shared reference to the output at this location, without\nperforming any bounds checking.",31,null],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without\nperforming any bounds checking.",31,null],[10,"index","","Returns a shared reference to the output at this location, panicking\nif out of bounds.",31,null],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking\nif out of bounds.",31,null],[8,"SliceConcatExt","","An extension trait for concatenating slices",null,null],[16,"Output","","The resulting type after concatenation",32,null],[10,"concat","","Flattens a slice of `T` into a single value `Self::Output`.",32,null],[10,"join","","Flattens a slice of `T` into a single value `Self::Output`, placing a\ngiven separator between each.",32,null],[10,"connect","","",32,null],[0,"str","collections","Unicode string slices.",null,null],[8,"FromStr","collections::str","A trait to abstract the idea of creating a new instance of a type from a\nstring.",null,null],[16,"Err","","The associated error which can be returned from parsing.",33,null],[10,"from_str","","Parses a string `s` to return a value of this type.",33,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of `u8`\nas a string.",null,null],[3,"Lines","","Created with the method [`lines()`].",null,null],[3,"LinesAny","","Created with the method [`lines_any()`].",null,null],[3,"Split","","Created with the method [`split()`].",null,null],[3,"RSplit","","Created with the method [`rsplit()`].",null,null],[3,"SplitN","","Created with the method [`splitn()`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn()`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator()`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator()`].",null,null],[3,"Matches","","Created with the method [`matches()`].",null,null],[3,"RMatches","","Created with the method [`rmatches()`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices()`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices()`].",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[3,"Chars","","Iterator for the char (representing *Unicode Scalar Values*) of a string",null,null],[3,"CharIndices","","Iterator for a string&#39;s characters and their byte offsets.",null,null],[3,"Bytes","","External iterator for a string&#39;s bytes.\nUse with the `std::iter` module.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking\nthat the string contains valid UTF-8.",null,null],[3,"ParseBoolError","","An error returned when parsing a `bool` from a string fails.",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string,\nseparated by any amount of whitespace.",null,null],[0,"pattern","","The string Pattern API.",null,null],[8,"Pattern","collections::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",34,null],[10,"into_searcher","","Constructs the associated searcher from\n`self` and the `haystack` to search in.",34,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",34,null],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",34,null],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",34,null],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at\n`haystack[a..b]`.",35,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match\nof the pattern.",35,null],[13,"Done","","Expresses that every byte of the haystack has been visted, ending\nthe iteration.",35,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlaying string to be searched in",36,null],[10,"next","","Performs the next search step starting from the front.",36,null],[11,"next_match","","Find the next `Match` result. See `next()`",36,null],[11,"next_reject","","Find the next `Reject` result. See `next()`",36,null],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",37,null],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",37,null],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",37,null],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher`\ncan be used for a `DoubleEndedIterator` implementation.",null,null],[3,"CharSearcher","","Associated type for `&lt;char as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `&lt;&amp;[char] as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `&lt;F as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `&lt;&amp;str as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[3,"EncodeUtf16","collections::str","External iterator for a string&#39;s UTF-16 code units.",null,null],[11,"clone","","",38,null],[11,"next","","",38,null],[11,"size_hint","","",38,null],[0,"string","collections","A UTF-8 encoded, growable string.",null,null],[3,"String","collections::string","A UTF-8 encoded, growable string.",null,null],[3,"FromUtf8Error","","A possible error value when converting a `String` from a UTF-8 byte vector.",null,null],[3,"FromUtf16Error","","A possible error value when converting a `String` from a UTF-16 byte slice.",null,null],[3,"Drain","","A draining iterator for `String`.",null,null],[4,"ParseError","","An error when parsing a `String`.",null,null],[8,"ToString","","A trait for converting a value to a `String`.",null,null],[10,"to_string","","Converts the given value to a `String`.",39,null],[11,"partial_cmp","","",40,null],[11,"lt","","",40,null],[11,"le","","",40,null],[11,"gt","","",40,null],[11,"ge","","",40,null],[11,"cmp","","",40,null],[11,"fmt","","",41,null],[11,"fmt","","",42,null],[11,"new","","Creates a new empty `String`.",40,{"inputs":[],"output":{"name":"string"}}],[11,"with_capacity","","Creates a new empty `String` with a particular capacity.",40,{"inputs":[{"name":"usize"}],"output":{"name":"string"}}],[11,"from_utf8","","Converts a vector of bytes to a `String`.",40,{"inputs":[{"name":"vec"}],"output":{"name":"result"}}],[11,"from_utf8_lossy","","Converts a slice of bytes to a string, including invalid characters.",40,null],[11,"from_utf16","","Decode a UTF-16 encoded vector `v` into a `String`, returning `Err`\nif `v` contains any invalid data.",40,null],[11,"from_utf16_lossy","","Decode a UTF-16 encoded vector `v` into a string, replacing\ninvalid data with the replacement character (U+FFFD).",40,null],[11,"from_raw_parts","","Creates a new `String` from a length, capacity, and pointer.",40,null],[11,"from_utf8_unchecked","","Converts a vector of bytes to a `String` without checking that the\nstring contains valid UTF-8.",40,{"inputs":[{"name":"vec"}],"output":{"name":"string"}}],[11,"into_bytes","","Converts a `String` into a byte vector.",40,null],[11,"as_str","","Extracts a string slice containing the entire string.",40,null],[11,"as_mut_str","","Extracts a string slice containing the entire string.",40,null],[11,"push_str","","Appends a given string slice onto the end of this `String`.",40,null],[11,"capacity","","Returns this `String`&#39;s capacity, in bytes.",40,null],[11,"reserve","","Ensures that this `String`&#39;s capacity is at least `additional` bytes\nlarger than its length.",40,null],[11,"reserve_exact","","Ensures that this `String`&#39;s capacity is `additional` bytes\nlarger than its length.",40,null],[11,"shrink_to_fit","","Shrinks the capacity of this `String` to match its length.",40,null],[11,"push","","Appends the given `char` to the end of this `String`.",40,null],[11,"as_bytes","","Returns a byte slice of this `String`&#39;s contents.",40,null],[11,"truncate","","Shortens this `String` to the specified length.",40,null],[11,"pop","","Removes the last character from the string buffer and returns it.",40,null],[11,"remove","","Removes a `char` from this `String` at a byte position and returns it.",40,null],[11,"insert","","Inserts a character into this `String` at a byte position.",40,null],[11,"insert_str","","Inserts a string slice into this `String` at a byte position.",40,null],[11,"as_mut_vec","","Returns a mutable reference to the contents of this `String`.",40,null],[11,"len","","Returns the length of this `String`, in bytes.",40,null],[11,"is_empty","","Returns `true` if this `String` has a length of zero.",40,null],[11,"split_off","","Divide one string into two at an index.",40,null],[11,"clear","","Truncates this `String`, removing all contents.",40,null],[11,"drain","","Create a draining iterator that removes the specified range in the string\nand yields the removed chars.",40,null],[11,"into_boxed_str","","Converts this `String` into a `Box&lt;str&gt;`.",40,null],[11,"into_bytes","","Returns the bytes that were attempted to convert to a `String`.",41,null],[11,"utf8_error","","Fetch a `Utf8Error` to get more details about the conversion failure.",41,null],[11,"fmt","","",41,null],[11,"fmt","","",42,null],[11,"clone","","",40,null],[11,"clone_from","","",40,null],[11,"from_iter","","",40,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",40,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",40,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"extend","","",40,null],[11,"extend","","",40,null],[11,"extend","","",40,null],[11,"extend","","",40,null],[11,"eq","","",40,null],[11,"ne","","",40,null],[11,"eq","","",40,null],[11,"ne","","",40,null],[11,"eq","","",40,null],[11,"ne","","",40,null],[11,"eq","collections::borrow","",9,null],[11,"ne","","",9,null],[11,"eq","","",9,null],[11,"ne","","",9,null],[11,"eq","","",9,null],[11,"ne","","",9,null],[11,"eq","collections::string","",40,null],[11,"ne","","",40,null],[11,"default","","Creates an empty `String`.",40,{"inputs":[],"output":{"name":"string"}}],[11,"fmt","","",40,null],[11,"fmt","","",40,null],[11,"hash","","",40,null],[11,"add","","",40,null],[11,"add_assign","","",40,null],[11,"index","","",40,null],[11,"index","","",40,null],[11,"index","","",40,null],[11,"index","","",40,null],[11,"index","","",40,null],[11,"index","","",40,null],[11,"index_mut","","",40,null],[11,"index_mut","","",40,null],[11,"index_mut","","",40,null],[11,"index_mut","","",40,null],[11,"index_mut","","",40,null],[11,"index_mut","","",40,null],[11,"deref","","",40,null],[11,"deref_mut","","",40,null],[11,"from_str","","",40,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"clone","","",43,null],[11,"fmt","","",43,null],[11,"fmt","","",43,null],[11,"eq","","",43,null],[11,"as_ref","","",40,null],[11,"as_ref","","",40,null],[11,"from","","",40,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"from","","",40,{"inputs":[{"name":"cow"}],"output":{"name":"string"}}],[11,"from","collections::borrow","",9,{"inputs":[{"name":"str"}],"output":{"name":"cow"}}],[11,"from","","",9,{"inputs":[{"name":"string"}],"output":{"name":"cow"}}],[11,"from_iter","","",9,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","","",9,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","","",9,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"write_str","collections::string","",40,null],[11,"write_char","","",40,null],[11,"drop","","",44,null],[11,"next","","",44,null],[11,"size_hint","","",44,null],[11,"next_back","","",44,null],[0,"vec","collections","A contiguous growable array type with heap-allocated contents, written\n`Vec&lt;T&gt;` but pronounced &#39;vector.&#39;",null,null],[3,"Vec","collections::vec","A contiguous growable array type, written `Vec&lt;T&gt;` but pronounced &#39;vector&#39;.",null,null],[3,"IntoIter","","An iterator that moves out of a vector.",null,null],[3,"Drain","","A draining iterator for `Vec&lt;T&gt;`.",null,null],[11,"new","","Constructs a new, empty `Vec&lt;T&gt;`.",45,{"inputs":[],"output":{"name":"vec"}}],[11,"with_capacity","","Constructs a new, empty `Vec&lt;T&gt;` with the specified capacity.",45,{"inputs":[{"name":"usize"}],"output":{"name":"vec"}}],[11,"from_raw_parts","","Creates a `Vec&lt;T&gt;` directly from the raw components of another vector.",45,null],[11,"capacity","","Returns the number of elements the vector can hold without\nreallocating.",45,null],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted\nin the given `Vec&lt;T&gt;`. The collection may reserve more space to avoid\nfrequent reallocations.",45,null],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to\nbe inserted in the given `Vec&lt;T&gt;`. Does nothing if the capacity is already\nsufficient.",45,null],[11,"shrink_to_fit","","Shrinks the capacity of the vector as much as possible.",45,null],[11,"into_boxed_slice","","Converts the vector into [`Box&lt;[T]&gt;`][owned slice].",45,null],[11,"truncate","","Shortens the vector, keeping the first `len` elements and dropping\nthe rest.",45,null],[11,"as_slice","","Extracts a slice containing the entire vector.",45,null],[11,"as_mut_slice","","Extracts a mutable slice of the entire vector.",45,null],[11,"set_len","","Sets the length of a vector.",45,null],[11,"swap_remove","","Removes an element from anywhere in the vector and return it, replacing\nit with the last element.",45,null],[11,"insert","","Inserts an element at position `index` within the vector, shifting all\nelements after it to the right.",45,null],[11,"remove","","Removes and returns the element at position `index` within the vector,\nshifting all elements after it to the left.",45,null],[11,"retain","","Retains only the elements specified by the predicate.",45,null],[11,"dedup_by_key","","Removes consecutive elements in the vector that resolve to the same key.",45,null],[11,"dedup_by","","Removes consecutive elements in the vector that resolve to the same key.",45,null],[11,"push","","Appends an element to the back of a collection.",45,null],[11,"pop","","Removes the last element from a vector and returns it, or [`None`] if it\nis empty.",45,null],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",45,null],[11,"drain","","Create a draining iterator that removes the specified range in the vector\nand yields the removed items.",45,null],[11,"clear","","Clears the vector, removing all values.",45,null],[11,"len","","Returns the number of elements in the vector.",45,null],[11,"is_empty","","Returns `true` if the vector contains no elements.",45,null],[11,"split_off","","Splits the collection into two at the given index.",45,null],[11,"resize","","Resizes the `Vec` in-place so that `len()` is equal to `new_len`.",45,null],[11,"extend_from_slice","","Clones and appends all elements in a slice to the `Vec`.",45,null],[11,"dedup","","Removes consecutive repeated elements in the vector.",45,null],[11,"clone","","",45,null],[11,"clone_from","","",45,null],[11,"hash","","",45,null],[11,"index","","",45,null],[11,"index_mut","","",45,null],[11,"index","","",45,null],[11,"index","","",45,null],[11,"index","","",45,null],[11,"index","","",45,null],[11,"index","","",45,null],[11,"index","","",45,null],[11,"index_mut","","",45,null],[11,"index_mut","","",45,null],[11,"index_mut","","",45,null],[11,"index_mut","","",45,null],[11,"index_mut","","",45,null],[11,"index_mut","","",45,null],[11,"deref","","",45,null],[11,"deref_mut","","",45,null],[11,"from_iter","","",45,{"inputs":[{"name":"i"}],"output":{"name":"vec"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out of\nthe vector (from start to end). The vector cannot be used after calling\nthis.",45,null],[11,"extend","","",45,null],[11,"extend","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","collections::borrow","",9,null],[11,"ne","","",9,null],[11,"eq","","",9,null],[11,"ne","","",9,null],[11,"eq","","",9,null],[11,"ne","","",9,null],[11,"eq","collections::vec","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"eq","","",45,null],[11,"ne","","",45,null],[11,"partial_cmp","","",45,null],[11,"cmp","","",45,null],[11,"drop","","",45,null],[11,"default","","Creates an empty `Vec&lt;T&gt;`.",45,{"inputs":[],"output":{"name":"vec"}}],[11,"fmt","","",45,null],[11,"as_ref","","",45,null],[11,"as_mut","","",45,null],[11,"as_ref","","",45,null],[11,"as_mut","","",45,null],[11,"from","","",45,null],[11,"from","","",45,{"inputs":[{"name":"cow"}],"output":{"name":"vec"}}],[11,"from","","",45,{"inputs":[{"name":"str"}],"output":{"name":"vec"}}],[11,"from","collections::borrow","",9,null],[11,"from","","",9,{"inputs":[{"name":"vec"}],"output":{"name":"cow"}}],[11,"from_iter","","",9,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"fmt","collections::vec","",46,null],[11,"as_slice","","Returns the remaining items of this iterator as a slice.",46,null],[11,"as_mut_slice","","Returns the remaining items of this iterator as a mutable slice.",46,null],[11,"next","","",46,null],[11,"size_hint","","",46,null],[11,"count","","",46,null],[11,"next_back","","",46,null],[11,"is_empty","","",46,null],[11,"clone","","",46,null],[11,"drop","","",46,null],[11,"next","","",47,null],[11,"size_hint","","",47,null],[11,"next_back","","",47,null],[11,"drop","","",47,null],[11,"is_empty","","",47,null],[0,"vec_deque","collections","VecDeque is a double-ended queue, which is implemented with the help of a\ngrowing ring buffer.",null,null],[3,"VecDeque","collections::vec_deque","`VecDeque` is a growable ring buffer, which can be used as a double-ended\nqueue efficiently.",null,null],[3,"Iter","","`VecDeque` iterator.",null,null],[3,"IterMut","","`VecDeque` mutable iterator.",null,null],[3,"IntoIter","","A by-value VecDeque iterator",null,null],[3,"Drain","","A draining VecDeque iterator",null,null],[11,"clone","","",48,null],[11,"drop","","",48,null],[11,"default","","Creates an empty `VecDeque&lt;T&gt;`.",48,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"new","","Creates an empty `VecDeque`.",48,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"with_capacity","","Creates an empty `VecDeque` with space for at least `n` elements.",48,{"inputs":[{"name":"usize"}],"output":{"name":"vecdeque"}}],[11,"get","","Retrieves an element in the `VecDeque` by index.",48,null],[11,"get_mut","","Retrieves an element in the `VecDeque` mutably by index.",48,null],[11,"swap","","Swaps elements at indices `i` and `j`.",48,null],[11,"capacity","","Returns the number of elements the `VecDeque` can hold without\nreallocating.",48,null],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the\ngiven `VecDeque`. Does nothing if the capacity is already sufficient.",48,null],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given\n`VecDeque`. The collection may reserve more space to avoid frequent reallocations.",48,null],[11,"shrink_to_fit","","Shrinks the capacity of the `VecDeque` as much as possible.",48,null],[11,"truncate","","Shortens a `VecDeque`, dropping excess elements from the back.",48,null],[11,"iter","","Returns a front-to-back iterator.",48,null],[11,"iter_mut","","Returns a front-to-back iterator that returns mutable references.",48,null],[11,"as_slices","","Returns a pair of slices which contain, in order, the contents of the\n`VecDeque`.",48,null],[11,"as_mut_slices","","Returns a pair of slices which contain, in order, the contents of the\n`VecDeque`.",48,null],[11,"len","","Returns the number of elements in the `VecDeque`.",48,null],[11,"is_empty","","Returns true if the buffer contains no elements",48,null],[11,"drain","","Create a draining iterator that removes the specified range in the\n`VecDeque` and yields the removed items.",48,null],[11,"clear","","Clears the buffer, removing all values.",48,null],[11,"contains","","Returns `true` if the `VecDeque` contains an element equal to the\ngiven value.",48,null],[11,"front","","Provides a reference to the front element, or `None` if the sequence is\nempty.",48,null],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the\nsequence is empty.",48,null],[11,"back","","Provides a reference to the back element, or `None` if the sequence is\nempty.",48,null],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the\nsequence is empty.",48,null],[11,"pop_front","","Removes the first element and returns it, or `None` if the sequence is\nempty.",48,null],[11,"push_front","","Inserts an element first in the sequence.",48,null],[11,"push_back","","Appends an element to the back of a buffer",48,null],[11,"pop_back","","Removes the last element from a buffer and returns it, or `None` if\nit is empty.",48,null],[11,"swap_remove_back","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the\nlast element.",48,null],[11,"swap_remove_front","","Removes an element from anywhere in the `VecDeque` and returns it,\nreplacing it with the first element.",48,null],[11,"insert","","Inserts an element at `index` within the `VecDeque`. Whichever\nend is closer to the insertion point will be moved to make room,\nand all the affected elements will be moved to new positions.",48,null],[11,"remove","","Removes and returns the element at `index` from the `VecDeque`.\nWhichever end is closer to the removal point will be moved to make\nroom, and all the affected elements will be moved to new positions.\nReturns `None` if `index` is out of bounds.",48,null],[11,"split_off","","Splits the collection into two at the given index.",48,null],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",48,null],[11,"retain","","Retains only the elements specified by the predicate.",48,null],[11,"resize","","Modifies the `VecDeque` in-place so that `len()` is equal to new_len,\neither by removing excess elements or by appending copies of a value to the back.",48,null],[11,"clone","","",49,null],[11,"next","","",49,null],[11,"size_hint","","",49,null],[11,"fold","","",49,null],[11,"next_back","","",49,null],[11,"is_empty","","",49,null],[11,"next","","",50,null],[11,"size_hint","","",50,null],[11,"fold","","",50,null],[11,"next_back","","",50,null],[11,"is_empty","","",50,null],[11,"clone","","",51,null],[11,"next","","",51,null],[11,"size_hint","","",51,null],[11,"next_back","","",51,null],[11,"is_empty","","",51,null],[11,"drop","","",52,null],[11,"next","","",52,null],[11,"size_hint","","",52,null],[11,"next_back","","",52,null],[11,"eq","","",48,null],[11,"partial_cmp","","",48,null],[11,"cmp","","",48,null],[11,"hash","","",48,null],[11,"index","","",48,null],[11,"index_mut","","",48,null],[11,"from_iter","","",48,{"inputs":[{"name":"t"}],"output":{"name":"vecdeque"}}],[11,"into_iter","","Consumes the list into a front-to-back iterator yielding elements by\nvalue.",48,null],[11,"extend","","",48,null],[11,"extend","","",48,null],[11,"fmt","","",48,null],[11,"from","","",48,{"inputs":[{"name":"vec"}],"output":{"name":"self"}}],[11,"from","collections::vec","",45,{"inputs":[{"name":"vecdeque"}],"output":{"name":"self"}}],[0,"btree_map","collections","A map based on a B-Tree.",null,null],[3,"BTreeMap","collections::btree_map","A map based on a B-Tree.",null,null],[3,"Iter","","An iterator over a BTreeMap&#39;s entries.",null,null],[3,"IterMut","","A mutable iterator over a BTreeMap&#39;s entries.",null,null],[3,"IntoIter","","An owning iterator over a BTreeMap&#39;s entries.",null,null],[3,"Keys","","An iterator over a BTreeMap&#39;s keys.",null,null],[3,"Values","","An iterator over a BTreeMap&#39;s values.",null,null],[3,"ValuesMut","","A mutable iterator over a BTreeMap&#39;s values.",null,null],[3,"Range","","An iterator over a sub-range of BTreeMap&#39;s entries.",null,null],[3,"RangeMut","","A mutable iterator over a sub-range of BTreeMap&#39;s entries.",null,null],[3,"VacantEntry","","A vacant Entry. It is part of the [`Entry`] enum.",null,null],[3,"OccupiedEntry","","An occupied Entry. It is part of the [`Entry`] enum.",null,null],[4,"Entry","","A view into a single entry in a map, which may either be vacant or occupied.\nThis enum is constructed from the [`entry`] method on [`BTreeMap`].",null,null],[13,"Vacant","","A vacant Entry",53,null],[13,"Occupied","","An occupied Entry",53,null],[0,"btree_set","collections","A set based on a B-Tree.",null,null],[3,"BTreeSet","collections::btree_set","A set based on a B-Tree.",null,null],[3,"Iter","","An iterator over a BTreeSet&#39;s items.",null,null],[3,"IntoIter","","An owning iterator over a BTreeSet&#39;s items.",null,null],[3,"Range","","An iterator over a sub-range of BTreeSet&#39;s items.",null,null],[3,"Difference","","A lazy iterator producing elements in the set difference (in-order).",null,null],[3,"SymmetricDifference","","A lazy iterator producing elements in the set symmetric difference (in-order).",null,null],[3,"Intersection","","A lazy iterator producing elements in the set intersection (in-order).",null,null],[3,"Union","","A lazy iterator producing elements in the set union (in-order).",null,null],[11,"clone","collections","",1,null],[11,"fmt","","",1,null],[11,"hash","","",1,null],[11,"eq","","",1,null],[11,"ne","","",1,null],[14,"vec","","Creates a `Vec` containing the arguments.",null,null],[14,"format","","Use the syntax described in `std::fmt` to create a value of type `String`.\nSee [`std::fmt`][fmt] for more information.",null,null],[11,"deref","collections::boxed","",54,null],[11,"from","","",54,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"fmt","","",54,null],[11,"next_back","","",54,null],[11,"finalize","","",54,{"inputs":[{"name":"intermediatebox"}],"output":{"name":"box"}}],[11,"make_place","","",55,null],[11,"fmt","","",54,null],[11,"len","","",54,null],[11,"is_empty","","",54,null],[11,"borrow","","",54,null],[11,"clone","","Returns a new box with a `clone()` of this box&#39;s contents.",54,null],[11,"clone_from","","Copies `source`&#39;s contents into `self` without creating a new allocation.",54,null],[11,"clone","","",54,null],[11,"clone","","",54,null],[11,"clone","","",55,null],[11,"cmp","","",54,null],[11,"default","","Creates a `Box&lt;T&gt;`, with the `Default` value for T.",54,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",54,{"inputs":[],"output":{"name":"box"}}],[11,"finalize","","",56,null],[11,"pointer","","",56,null],[11,"partial_cmp","","",54,null],[11,"lt","","",54,null],[11,"le","","",54,null],[11,"ge","","",54,null],[11,"gt","","",54,null],[11,"call_once","","",54,null],[11,"call_once","","",54,null],[11,"fmt","","",54,null],[11,"deref_mut","","",54,null],[11,"make_place","","",56,{"inputs":[],"output":{"name":"intermediatebox"}}],[11,"eq","","",54,null],[11,"ne","","",54,null],[11,"borrow_mut","","",54,null],[11,"as_ref","","",54,null],[11,"next","","",54,null],[11,"size_hint","","",54,null],[11,"nth","","",54,null],[11,"hash","","",54,null],[11,"as_mut","","",54,null],[11,"drop","","",56,null],[11,"next_back","collections::str","",57,null],[11,"next","","",57,null],[11,"partial_cmp","collections::fmt","",58,null],[11,"write_str","","",59,null],[11,"write_char","","",59,null],[11,"write_fmt","","",59,null],[11,"next_back","collections::str::pattern","",60,null],[11,"next_match_back","","",60,null],[11,"next_reject_back","","",60,null],[11,"next_back","","",61,null],[11,"next_match_back","","",61,null],[11,"next_reject_back","","",61,null],[11,"next_back","","",62,null],[11,"next_match_back","","",62,null],[11,"next_reject_back","","",62,null],[11,"next_back","","",63,null],[11,"next_match_back","","",63,null],[11,"cmp","collections::fmt","",58,null],[11,"next_back","collections::slice","",64,null],[11,"next_back","","",65,null],[11,"next_back","","",66,null],[11,"next_back","","",67,null],[11,"next_back","","",68,null],[11,"next_back","collections::str","",69,null],[11,"next_back","","",70,null],[11,"next_back","","",71,null],[11,"next_back","","",72,null],[11,"next_back","","",73,null],[11,"next_back","collections::slice","",74,null],[11,"next_back","","",75,null],[11,"next_back","collections::str","",76,null],[11,"next_back","","",77,null],[11,"next_back","","",78,null],[11,"next_back","","",79,null],[11,"next_back","","",80,null],[11,"next_back","","",81,null],[11,"next_back","","",82,null],[11,"next_back","","",83,null],[11,"eq","collections::str::pattern","",35,null],[11,"ne","","",35,null],[11,"eq","collections::str","",84,null],[11,"ne","","",84,null],[11,"eq","","",85,null],[11,"ne","","",85,null],[11,"eq","collections::fmt","",58,null],[11,"next","collections::slice","",64,null],[11,"size_hint","","",64,null],[11,"next","","",65,null],[11,"size_hint","","",65,null],[11,"next","","",66,null],[11,"size_hint","","",66,null],[11,"count","","",66,null],[11,"nth","","",66,null],[11,"last","","",66,null],[11,"next","","",67,null],[11,"size_hint","","",67,null],[11,"count","","",67,null],[11,"nth","","",67,null],[11,"last","","",67,null],[11,"next","","",68,null],[11,"size_hint","","",68,null],[11,"count","","",68,null],[11,"nth","","",68,null],[11,"last","","",68,null],[11,"next","collections::str","",69,null],[11,"count","","",69,null],[11,"size_hint","","",69,null],[11,"last","","",69,null],[11,"next","","",70,null],[11,"count","","",70,null],[11,"size_hint","","",70,null],[11,"last","","",70,null],[11,"next","","",71,null],[11,"size_hint","","",71,null],[11,"count","","",71,null],[11,"last","","",71,null],[11,"nth","","",71,null],[11,"next","","",72,null],[11,"size_hint","","",72,null],[11,"next","","",73,null],[11,"size_hint","","",73,null],[11,"next","collections::slice","",74,null],[11,"size_hint","","",74,null],[11,"count","","",74,null],[11,"nth","","",74,null],[11,"last","","",74,null],[11,"next","","",75,null],[11,"size_hint","","",75,null],[11,"count","","",75,null],[11,"nth","","",75,null],[11,"last","","",75,null],[11,"next","","",86,null],[11,"size_hint","","",86,null],[11,"next","","",87,null],[11,"size_hint","","",87,null],[11,"next","","",88,null],[11,"size_hint","","",88,null],[11,"next","","",89,null],[11,"size_hint","","",89,null],[11,"next","collections::str","",76,null],[11,"next","","",77,null],[11,"next","","",78,null],[11,"next","","",79,null],[11,"next","","",90,null],[11,"next","","",91,null],[11,"next","","",80,null],[11,"next","","",81,null],[11,"next","","",82,null],[11,"next","","",83,null],[11,"fmt","","",84,null],[11,"fmt","","",85,null],[11,"fmt","collections::fmt","",92,null],[11,"fmt","","",58,null],[11,"clone","collections::slice","",74,null],[11,"clone","","",64,null],[11,"clone","","",66,null],[11,"clone","","",67,null],[11,"clone","collections::str::pattern","",35,null],[11,"clone","","",60,null],[11,"clone","","",61,null],[11,"clone","","",62,null],[11,"clone","","",63,null],[11,"clone","collections::str","",84,null],[11,"clone","","",85,null],[11,"clone","","",69,null],[11,"clone","","",70,null],[11,"clone","","",71,null],[11,"clone","","",76,null],[11,"clone","","",77,null],[11,"clone","","",78,null],[11,"clone","","",79,null],[11,"clone","","",90,null],[11,"clone","","",91,null],[11,"clone","","",80,null],[11,"clone","","",81,null],[11,"clone","","",82,null],[11,"clone","","",83,null],[11,"clone","","",72,null],[11,"clone","","",73,null],[11,"clone","collections::fmt","",58,null],[11,"clone","","",92,null],[11,"fmt","collections::slice","",74,null],[11,"fmt","","",75,null],[11,"fmt","","",64,null],[11,"fmt","","",65,null],[11,"fmt","","",86,null],[11,"fmt","","",87,null],[11,"fmt","","",88,null],[11,"fmt","","",89,null],[11,"fmt","collections::str::pattern","",62,null],[11,"fmt","collections::fmt","",92,null],[11,"fmt","collections::slice","",66,null],[11,"fmt","","",67,null],[11,"fmt","","",68,null],[11,"fmt","collections::str::pattern","",35,null],[11,"fmt","","",60,null],[11,"fmt","","",61,null],[11,"fmt","","",63,null],[11,"fmt","collections::str","",84,null],[11,"fmt","","",85,null],[11,"fmt","","",69,null],[11,"fmt","","",70,null],[11,"fmt","","",71,null],[11,"fmt","","",76,null],[11,"fmt","","",77,null],[11,"fmt","","",78,null],[11,"fmt","","",79,null],[11,"fmt","","",90,null],[11,"fmt","","",91,null],[11,"fmt","","",80,null],[11,"fmt","","",81,null],[11,"fmt","","",82,null],[11,"fmt","","",83,null],[11,"fmt","","",72,null],[11,"fmt","","",73,null],[11,"fmt","collections::fmt","",58,null],[11,"default","","",58,{"inputs":[],"output":{"name":"error"}}],[11,"is_empty","collections::slice","",74,null],[11,"is_empty","","",75,null],[11,"len","collections::str","",71,null],[11,"is_empty","","",71,null],[11,"hash","collections::fmt","",58,null],[11,"haystack","collections::str::pattern","",60,null],[11,"next","","",60,null],[11,"next_match","","",60,null],[11,"next_reject","","",60,null],[11,"haystack","","",61,null],[11,"next","","",61,null],[11,"next_match","","",61,null],[11,"next_reject","","",61,null],[11,"haystack","","",62,null],[11,"next","","",62,null],[11,"next_match","","",62,null],[11,"next_reject","","",62,null],[11,"haystack","","",63,null],[11,"next","","",63,null],[11,"next_match","","",63,null],[11,"as_ref","collections::slice","",74,null],[11,"new","collections::boxed","Allocates memory on the heap and then places `x` into it.",54,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"from_raw","","Constructs a box from a raw pointer.",54,null],[11,"into_raw","","Consumes the `Box`, returning the wrapped raw pointer.",54,null],[11,"downcast","","Attempt to downcast the box to a concrete type.",54,null],[11,"downcast","","Attempt to downcast the box to a concrete type.",54,null],[11,"from","collections::vec","",45,{"inputs":[{"name":"binaryheap"}],"output":{"name":"vec"}}],[11,"drop","collections::btree_map","",93,null],[11,"clone","","",93,null],[11,"fmt","","",53,null],[11,"fmt","","",94,null],[11,"fmt","","",95,null],[11,"new","","Makes a new empty BTreeMap with a reasonable choice for B.",93,{"inputs":[],"output":{"name":"btreemap"}}],[11,"clear","","Clears the map, removing all values.",93,null],[11,"get","","Returns a reference to the value corresponding to the key.",93,null],[11,"contains_key","","Returns true if the map contains a value for the specified key.",93,null],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",93,null],[11,"insert","","Inserts a key-value pair into the map.",93,null],[11,"remove","","Removes a key from the map, returning the value at the key if the key\nwas previously in the map.",93,null],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",93,null],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the map, starting\nat min, and ending at max. If min is `Unbounded`, then it will be treated as &quot;negative\ninfinity&quot;, and if max is `Unbounded`, then it will be treated as &quot;positive infinity&quot;.\nThus range(Unbounded, Unbounded) will yield the whole collection.",93,null],[11,"range_mut","","Constructs a mutable double-ended iterator over a sub-range of elements in the map, starting\nat min, and ending at max. If min is `Unbounded`, then it will be treated as &quot;negative\ninfinity&quot;, and if max is `Unbounded`, then it will be treated as &quot;positive infinity&quot;.\nThus range(Unbounded, Unbounded) will yield the whole collection.",93,null],[11,"entry","","Gets the given key&#39;s corresponding entry in the map for in-place manipulation.",93,null],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key,\nincluding the key.",93,null],[11,"next","","",96,null],[11,"size_hint","","",96,null],[11,"next_back","","",96,null],[11,"len","","",96,null],[11,"clone","","",96,null],[11,"next","","",97,null],[11,"size_hint","","",97,null],[11,"next_back","","",97,null],[11,"len","","",97,null],[11,"into_iter","","",93,null],[11,"drop","","",98,null],[11,"next","","",98,null],[11,"size_hint","","",98,null],[11,"next_back","","",98,null],[11,"len","","",98,null],[11,"next","","",99,null],[11,"size_hint","","",99,null],[11,"next_back","","",99,null],[11,"len","","",99,null],[11,"clone","","",99,null],[11,"next","","",100,null],[11,"size_hint","","",100,null],[11,"next_back","","",100,null],[11,"len","","",100,null],[11,"clone","","",100,null],[11,"next","","",101,null],[11,"next","","",102,null],[11,"size_hint","","",102,null],[11,"next_back","","",102,null],[11,"len","","",102,null],[11,"next_back","","",101,null],[11,"clone","","",101,null],[11,"next","","",103,null],[11,"next_back","","",103,null],[11,"from_iter","","",93,{"inputs":[{"name":"t"}],"output":{"name":"btreemap"}}],[11,"extend","","",93,null],[11,"extend","","",93,null],[11,"hash","","",93,null],[11,"default","","Creates an empty `BTreeMap&lt;K, V&gt;`.",93,{"inputs":[],"output":{"name":"btreemap"}}],[11,"eq","","",93,null],[11,"partial_cmp","","",93,null],[11,"cmp","","",93,null],[11,"fmt","","",93,null],[11,"index","","",93,null],[11,"iter","","Gets an iterator over the entries of the map, sorted by key.",93,null],[11,"iter_mut","","Gets a mutable iterator over the entries of the map, sorted by key.",93,null],[11,"keys","","Gets an iterator over the keys of the map, in sorted order.",93,null],[11,"values","","Gets an iterator over the values of the map, in order by key.",93,null],[11,"values_mut","","Gets a mutable iterator over the values of the map, in order by key.",93,null],[11,"len","","Returns the number of elements in the map.",93,null],[11,"is_empty","","Returns true if the map contains no elements.",93,null],[11,"or_insert","","Ensures a value is in the entry by inserting the default if empty, and returns\na mutable reference to the value in the entry.",53,null],[11,"or_insert_with","","Ensures a value is in the entry by inserting the result of the default function if empty,\nand returns a mutable reference to the value in the entry.",53,null],[11,"key","","Returns a reference to this entry&#39;s key.",53,null],[11,"key","","Gets a reference to the key that would be used when inserting a value\nthrough the VacantEntry.",94,null],[11,"into_key","","Take ownership of the key.",94,null],[11,"insert","","Sets the value of the entry with the `VacantEntry`&#39;s key,\nand returns a mutable reference to it.",94,null],[11,"key","","Gets a reference to the key in the entry.",95,null],[11,"remove_pair","","Deprecated, renamed to `remove_entry`",95,null],[11,"remove_entry","","Take ownership of the key and value from the map.",95,null],[11,"get","","Gets a reference to the value in the entry.",95,null],[11,"get_mut","","Gets a mutable reference to the value in the entry.",95,null],[11,"into_mut","","Converts the entry into a mutable reference to its value.",95,null],[11,"insert","","Sets the value of the entry with the `OccupiedEntry`&#39;s key,\nand returns the entry&#39;s old value.",95,null],[11,"remove","","Takes the value of the entry out of the map, and returns it.",95,null],[11,"clone","collections::btree_set","",104,null],[11,"hash","","",104,null],[11,"eq","","",104,null],[11,"ne","","",104,null],[11,"cmp","","",104,null],[11,"partial_cmp","","",104,null],[11,"lt","","",104,null],[11,"le","","",104,null],[11,"gt","","",104,null],[11,"ge","","",104,null],[11,"new","","Makes a new BTreeSet with a reasonable choice of B.",104,{"inputs":[],"output":{"name":"btreeset"}}],[11,"iter","","Gets an iterator over the BTreeSet&#39;s contents.",104,null],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the set, starting\nat min, and ending at max. If min is `Unbounded`, then it will be treated as &quot;negative\ninfinity&quot;, and if max is `Unbounded`, then it will be treated as &quot;positive infinity&quot;.\nThus range(Unbounded, Unbounded) will yield the whole collection.",104,null],[11,"difference","","Visits the values representing the difference, in ascending order.",104,null],[11,"symmetric_difference","","Visits the values representing the symmetric difference, in ascending order.",104,null],[11,"intersection","","Visits the values representing the intersection, in ascending order.",104,null],[11,"union","","Visits the values representing the union, in ascending order.",104,null],[11,"len","","Returns the number of elements in the set.",104,null],[11,"is_empty","","Returns true if the set contains no elements.",104,null],[11,"clear","","Clears the set, removing all values.",104,null],[11,"contains","","Returns `true` if the set contains a value.",104,null],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",104,null],[11,"is_disjoint","","Returns `true` if the set has no elements in common with `other`.\nThis is equivalent to checking for an empty intersection.",104,null],[11,"is_subset","","Returns `true` if the set is a subset of another.",104,null],[11,"is_superset","","Returns `true` if the set is a superset of another.",104,null],[11,"insert","","Adds a value to the set.",104,null],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given\none. Returns the replaced value.",104,null],[11,"remove","","Removes a value from the set. Returns `true` if the value was\npresent in the set.",104,null],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",104,null],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",104,null],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key,\nincluding the key.",104,null],[11,"from_iter","","",104,{"inputs":[{"name":"i"}],"output":{"name":"btreeset"}}],[11,"into_iter","","Gets an iterator for moving out the BtreeSet&#39;s contents.",104,null],[11,"extend","","",104,null],[11,"extend","","",104,null],[11,"default","","Makes an empty `BTreeSet&lt;T&gt;` with a reasonable choice of B.",104,{"inputs":[],"output":{"name":"btreeset"}}],[11,"fmt","","",104,null],[11,"clone","","",105,null],[11,"next","","",105,null],[11,"size_hint","","",105,null],[11,"next_back","","",105,null],[11,"len","","",105,null],[11,"next","","",106,null],[11,"size_hint","","",106,null],[11,"next_back","","",106,null],[11,"len","","",106,null],[11,"clone","","",107,null],[11,"next","","",107,null],[11,"next_back","","",107,null],[11,"clone","","",108,null],[11,"next","","",108,null],[11,"size_hint","","",108,null],[11,"clone","","",109,null],[11,"next","","",109,null],[11,"size_hint","","",109,null],[11,"clone","","",110,null],[11,"next","","",110,null],[11,"size_hint","","",110,null],[11,"clone","","",111,null],[11,"next","","",111,null],[11,"size_hint","","",111,null],[11,"pad_integral","collections::fmt","Performs the correct padding for an integer which has already been\nemitted into a str. The str should *not* contain the sign for the\ninteger, that will be added by this method.",59,null],[11,"pad","","This function takes a string slice and emits it to the internal buffer\nafter applying the relevant formatting flags specified. The flags\nrecognized for generic strings are:",59,null],[11,"write_str","","Writes some data to the underlying buffer contained within this\nformatter.",59,null],[11,"write_fmt","","Writes some formatted information into this instance",59,null],[11,"flags","","Flags for formatting (packed version of rt::Flag)",59,null],[11,"fill","","Character used as &#39;fill&#39; whenever there is alignment",59,null],[11,"align","","Flag indicating what form of alignment was requested",59,null],[11,"width","","Optionally specified integer width that the output should be",59,null],[11,"precision","","Optionally specified precision for numeric types",59,null],[11,"sign_plus","","Determines if the `+` flag was specified.",59,null],[11,"sign_minus","","Determines if the `-` flag was specified.",59,null],[11,"alternate","","Determines if the `#` flag was specified.",59,null],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",59,null],[11,"debug_struct","","Creates a `DebugStruct` builder designed to assist with creation of\n`fmt::Debug` implementations for structs.",59,null],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of\n`fmt::Debug` implementations for tuple structs.",59,null],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of\n`fmt::Debug` implementations for list-like structures.",59,null],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of\n`fmt::Debug` implementations for set-like structures.",59,null],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of\n`fmt::Debug` implementations for map-like structures.",59,null],[11,"entry","","Adds a new entry to the list output.",112,null],[11,"entries","","Adds the contents of an iterator of entries to the list output.",112,null],[11,"finish","","Finishes output and returns any error encountered.",112,null],[11,"entry","","Adds a new entry to the map output.",113,null],[11,"entries","","Adds the contents of an iterator of entries to the map output.",113,null],[11,"finish","","Finishes output and returns any error encountered.",113,null],[11,"entry","","Adds a new entry to the set output.",114,null],[11,"entries","","Adds the contents of an iterator of entries to the set output.",114,null],[11,"finish","","Finishes output and returns any error encountered.",114,null],[11,"field","","Adds a new field to the generated struct output.",115,null],[11,"finish","","Finishes output and returns any error encountered.",115,null],[11,"field","","Adds a new field to the generated tuple struct output.",116,null],[11,"finish","","Finishes output and returns any error encountered.",116,null],[11,"as_slice","collections::slice","View the underlying data as a subslice of the original data.",74,null],[11,"into_slice","","View the underlying data as a subslice of the original data.",75,null],[11,"borrow","collections::vec","",45,null],[11,"borrow_mut","","",45,null],[11,"valid_up_to","collections::str","Returns the index in the given string up to which valid UTF-8 was\nverified.",85,null],[11,"as_str","","View the underlying data as a subslice of the original data.",69,null],[11,"as_str","","View the underlying data as a subslice of the original data.",70,null],[11,"borrow","collections::string","",40,null],[11,"from","collections::vec","",45,{"inputs":[{"name":"string"}],"output":{"name":"vec"}}]],"paths":[[8,"FnBox"],[4,"Bound"],[3,"PeekMut"],[3,"BinaryHeap"],[3,"Iter"],[3,"IntoIter"],[3,"Drain"],[8,"Borrow"],[8,"BorrowMut"],[4,"Cow"],[8,"ToOwned"],[8,"CLike"],[3,"EnumSet"],[3,"Iter"],[8,"Write"],[8,"Octal"],[8,"Binary"],[8,"Display"],[8,"Debug"],[8,"LowerHex"],[8,"UpperHex"],[8,"Pointer"],[8,"LowerExp"],[8,"UpperExp"],[3,"Iter"],[3,"IntoIter"],[3,"LinkedList"],[3,"IterMut"],[3,"FrontPlace"],[3,"BackPlace"],[8,"RangeArgument"],[8,"SliceIndex"],[8,"SliceConcatExt"],[8,"FromStr"],[8,"Pattern"],[4,"SearchStep"],[8,"Searcher"],[8,"ReverseSearcher"],[3,"EncodeUtf16"],[8,"ToString"],[3,"String"],[3,"FromUtf8Error"],[3,"FromUtf16Error"],[4,"ParseError"],[3,"Drain"],[3,"Vec"],[3,"IntoIter"],[3,"Drain"],[3,"VecDeque"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Drain"],[4,"Entry"],[3,"Box"],[3,"ExchangeHeapSingleton"],[3,"IntermediateBox"],[3,"SplitWhitespace"],[3,"Error"],[3,"Formatter"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[3,"Split"],[3,"SplitMut"],[3,"Windows"],[3,"Chunks"],[3,"ChunksMut"],[3,"Chars"],[3,"CharIndices"],[3,"Bytes"],[3,"Lines"],[3,"LinesAny"],[3,"Iter"],[3,"IterMut"],[3,"Split"],[3,"RSplit"],[3,"SplitTerminator"],[3,"RSplitTerminator"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Matches"],[3,"RMatches"],[3,"ParseBoolError"],[3,"Utf8Error"],[3,"SplitN"],[3,"RSplitN"],[3,"SplitNMut"],[3,"RSplitNMut"],[3,"SplitN"],[3,"RSplitN"],[3,"Arguments"],[3,"BTreeMap"],[3,"VacantEntry"],[3,"OccupiedEntry"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Keys"],[3,"Values"],[3,"Range"],[3,"ValuesMut"],[3,"RangeMut"],[3,"BTreeSet"],[3,"Iter"],[3,"IntoIter"],[3,"Range"],[3,"Difference"],[3,"SymmetricDifference"],[3,"Intersection"],[3,"Union"],[3,"DebugList"],[3,"DebugMap"],[3,"DebugSet"],[3,"DebugStruct"],[3,"DebugTuple"]]};
searchIndex["core"] = {"doc":"# The Rust Core Library","items":[[0,"isize","core","The pointer-sized signed integer type.",null,null],[17,"MIN","core::isize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i8","core","The 8-bit signed integer type.",null,null],[17,"MIN","core::i8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i16","core","The 16-bit signed integer type.",null,null],[17,"MIN","core::i16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i32","core","The 32-bit signed integer type.",null,null],[17,"MIN","core::i32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i64","core","The 64-bit signed integer type.",null,null],[17,"MIN","core::i64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"usize","core","The pointer-sized unsigned integer type.",null,null],[17,"MIN","core::usize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u8","core","The 8-bit unsigned integer type.",null,null],[17,"MIN","core::u8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u16","core","The 16-bit unsigned integer type.",null,null],[17,"MIN","core::u16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u32","core","The 32-bit unsigned integer type.",null,null],[17,"MIN","core::u32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u64","core","The 64-bit unsigned integer type.",null,null],[17,"MIN","core::u64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"f32","core","Operations and constants for 32-bits floats (`f32` type)",null,null],[0,"consts","core::f32","Basic mathematical constants.",null,null],[17,"PI","core::f32::consts","Archimedes&#39; constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler&#39;s number (e)",null,null],[17,"LOG2_E","","log&lt;sub&gt;2&lt;/sub&gt;(e)",null,null],[17,"LOG10_E","","log&lt;sub&gt;10&lt;/sub&gt;(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f32","The radix or base of the internal representation of `f32`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","Difference between `1.0` and the next largest representable number.",null,null],[17,"MIN","","Smallest finite `f32` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f32` value.",null,null],[17,"MAX","","Largest finite `f32` value.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[0,"f64","core","Operations and constants for 64-bits floats (`f64` type)",null,null],[0,"consts","core::f64","Basic mathematical constants.",null,null],[17,"PI","core::f64::consts","Archimedes&#39; constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler&#39;s number (e)",null,null],[17,"LOG2_E","","log&lt;sub&gt;2&lt;/sub&gt;(e)",null,null],[17,"LOG10_E","","log&lt;sub&gt;10&lt;/sub&gt;(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f64","The radix or base of the internal representation of `f64`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","Difference between `1.0` and the next largest representable number.",null,null],[17,"MIN","","Smallest finite `f64` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f64` value.",null,null],[17,"MAX","","Largest finite `f64` value.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[0,"num","core","Numeric traits and functions for the built-in numeric types.",null,null],[3,"Wrapping","core::num","Provides intentionally-wrapped arithmetic on `T`.",null,null],[12,"0","","",0,null],[3,"TryFromIntError","","The error type returned when a checked integral type conversion fails.",null,null],[3,"ParseIntError","","An error which can be returned when parsing an integer.",null,null],[3,"ParseFloatError","","An error which can be returned when parsing a float.",null,null],[4,"FpCategory","","A classification of floating point numbers.",null,null],[13,"Nan","","&quot;Not a Number&quot;, often obtained by dividing by zero.",1,null],[13,"Infinite","","Positive or negative infinity.",1,null],[13,"Zero","","Positive or negative zero.",1,null],[13,"Subnormal","","De-normalized floating point representation (less precise than `Normal`).",1,null],[13,"Normal","","A regular floating point number.",1,null],[11,"shl","","",0,null],[11,"shl_assign","","",0,null],[11,"shr","","",0,null],[11,"shr_assign","","",0,null],[11,"shl","","",0,null],[11,"shl_assign","","",0,null],[11,"shr","","",0,null],[11,"shr_assign","","",0,null],[11,"shl","","",0,null],[11,"shl_assign","","",0,null],[11,"shr","","",0,null],[11,"shr_assign","","",0,null],[11,"shl","","",0,null],[11,"shl_assign","","",0,null],[11,"shr","","",0,null],[11,"shr_assign","","",0,null],[11,"shl","","",0,null],[11,"shl_assign","","",0,null],[11,"shr","","",0,null],[11,"shr_assign","","",0,null],[11,"shl","","",0,null],[11,"shl_assign","","",0,null],[11,"shr","","",0,null],[11,"shr_assign","","",0,null],[11,"shl","","",0,null],[11,"shl_assign","","",0,null],[11,"shr","","",0,null],[11,"shr_assign","","",0,null],[11,"shl","","",0,null],[11,"shl_assign","","",0,null],[11,"shr","","",0,null],[11,"shr_assign","","",0,null],[11,"shl","","",0,null],[11,"shl_assign","","",0,null],[11,"shr","","",0,null],[11,"shr_assign","","",0,null],[11,"shl","","",0,null],[11,"shl_assign","","",0,null],[11,"shr","","",0,null],[11,"shr_assign","","",0,null],[11,"add","","",0,null],[11,"add","","",0,null],[11,"add_assign","","",0,null],[11,"sub","","",0,null],[11,"sub","","",0,null],[11,"sub_assign","","",0,null],[11,"mul","","",0,null],[11,"mul","","",0,null],[11,"mul_assign","","",0,null],[11,"div","","",0,null],[11,"div","","",0,null],[11,"div_assign","","",0,null],[11,"rem","","",0,null],[11,"rem","","",0,null],[11,"rem_assign","","",0,null],[11,"not","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,null],[11,"bitor","","",0,null],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,null],[11,"bitand","","",0,null],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,null],[11,"neg","","",0,null],[11,"add","","",0,null],[11,"add","","",0,null],[11,"add_assign","","",0,null],[11,"sub","","",0,null],[11,"sub","","",0,null],[11,"sub_assign","","",0,null],[11,"mul","","",0,null],[11,"mul","","",0,null],[11,"mul_assign","","",0,null],[11,"div","","",0,null],[11,"div","","",0,null],[11,"div_assign","","",0,null],[11,"rem","","",0,null],[11,"rem","","",0,null],[11,"rem_assign","","",0,null],[11,"not","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,null],[11,"bitor","","",0,null],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,null],[11,"bitand","","",0,null],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,null],[11,"neg","","",0,null],[11,"add","","",0,null],[11,"add","","",0,null],[11,"add_assign","","",0,null],[11,"sub","","",0,null],[11,"sub","","",0,null],[11,"sub_assign","","",0,null],[11,"mul","","",0,null],[11,"mul","","",0,null],[11,"mul_assign","","",0,null],[11,"div","","",0,null],[11,"div","","",0,null],[11,"div_assign","","",0,null],[11,"rem","","",0,null],[11,"rem","","",0,null],[11,"rem_assign","","",0,null],[11,"not","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,null],[11,"bitor","","",0,null],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,null],[11,"bitand","","",0,null],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,null],[11,"neg","","",0,null],[11,"add","","",0,null],[11,"add","","",0,null],[11,"add_assign","","",0,null],[11,"sub","","",0,null],[11,"sub","","",0,null],[11,"sub_assign","","",0,null],[11,"mul","","",0,null],[11,"mul","","",0,null],[11,"mul_assign","","",0,null],[11,"div","","",0,null],[11,"div","","",0,null],[11,"div_assign","","",0,null],[11,"rem","","",0,null],[11,"rem","","",0,null],[11,"rem_assign","","",0,null],[11,"not","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,null],[11,"bitor","","",0,null],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,null],[11,"bitand","","",0,null],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,null],[11,"neg","","",0,null],[11,"add","","",0,null],[11,"add","","",0,null],[11,"add_assign","","",0,null],[11,"sub","","",0,null],[11,"sub","","",0,null],[11,"sub_assign","","",0,null],[11,"mul","","",0,null],[11,"mul","","",0,null],[11,"mul_assign","","",0,null],[11,"div","","",0,null],[11,"div","","",0,null],[11,"div_assign","","",0,null],[11,"rem","","",0,null],[11,"rem","","",0,null],[11,"rem_assign","","",0,null],[11,"not","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,null],[11,"bitor","","",0,null],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,null],[11,"bitand","","",0,null],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,null],[11,"neg","","",0,null],[11,"add","","",0,null],[11,"add","","",0,null],[11,"add_assign","","",0,null],[11,"sub","","",0,null],[11,"sub","","",0,null],[11,"sub_assign","","",0,null],[11,"mul","","",0,null],[11,"mul","","",0,null],[11,"mul_assign","","",0,null],[11,"div","","",0,null],[11,"div","","",0,null],[11,"div_assign","","",0,null],[11,"rem","","",0,null],[11,"rem","","",0,null],[11,"rem_assign","","",0,null],[11,"not","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,null],[11,"bitor","","",0,null],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,null],[11,"bitand","","",0,null],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,null],[11,"neg","","",0,null],[11,"add","","",0,null],[11,"add","","",0,null],[11,"add_assign","","",0,null],[11,"sub","","",0,null],[11,"sub","","",0,null],[11,"sub_assign","","",0,null],[11,"mul","","",0,null],[11,"mul","","",0,null],[11,"mul_assign","","",0,null],[11,"div","","",0,null],[11,"div","","",0,null],[11,"div_assign","","",0,null],[11,"rem","","",0,null],[11,"rem","","",0,null],[11,"rem_assign","","",0,null],[11,"not","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,null],[11,"bitor","","",0,null],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,null],[11,"bitand","","",0,null],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,null],[11,"neg","","",0,null],[11,"add","","",0,null],[11,"add","","",0,null],[11,"add_assign","","",0,null],[11,"sub","","",0,null],[11,"sub","","",0,null],[11,"sub_assign","","",0,null],[11,"mul","","",0,null],[11,"mul","","",0,null],[11,"mul_assign","","",0,null],[11,"div","","",0,null],[11,"div","","",0,null],[11,"div_assign","","",0,null],[11,"rem","","",0,null],[11,"rem","","",0,null],[11,"rem_assign","","",0,null],[11,"not","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,null],[11,"bitor","","",0,null],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,null],[11,"bitand","","",0,null],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,null],[11,"neg","","",0,null],[11,"add","","",0,null],[11,"add","","",0,null],[11,"add_assign","","",0,null],[11,"sub","","",0,null],[11,"sub","","",0,null],[11,"sub_assign","","",0,null],[11,"mul","","",0,null],[11,"mul","","",0,null],[11,"mul_assign","","",0,null],[11,"div","","",0,null],[11,"div","","",0,null],[11,"div_assign","","",0,null],[11,"rem","","",0,null],[11,"rem","","",0,null],[11,"rem_assign","","",0,null],[11,"not","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,null],[11,"bitor","","",0,null],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,null],[11,"bitand","","",0,null],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,null],[11,"neg","","",0,null],[11,"add","","",0,null],[11,"add","","",0,null],[11,"add_assign","","",0,null],[11,"sub","","",0,null],[11,"sub","","",0,null],[11,"sub_assign","","",0,null],[11,"mul","","",0,null],[11,"mul","","",0,null],[11,"mul_assign","","",0,null],[11,"div","","",0,null],[11,"div","","",0,null],[11,"div_assign","","",0,null],[11,"rem","","",0,null],[11,"rem","","",0,null],[11,"rem_assign","","",0,null],[11,"not","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor","","",0,null],[11,"bitxor_assign","","",0,null],[11,"bitor","","",0,null],[11,"bitor","","",0,null],[11,"bitor_assign","","",0,null],[11,"bitand","","",0,null],[11,"bitand","","",0,null],[11,"bitand_assign","","",0,null],[11,"neg","","",0,null],[11,"fmt","","",2,null],[11,"clone","","",2,null],[11,"eq","","",2,null],[11,"ne","","",2,null],[11,"fmt","","",2,null],[8,"Zero","","Types that have a &quot;zero&quot; value.",null,null],[10,"zero","","The &quot;zero&quot; (usually, additive identity) for this type.",3,{"inputs":[],"output":{"name":"self"}}],[8,"One","","Types that have a &quot;one&quot; value.",null,null],[10,"one","","The &quot;one&quot; (usually, multiplicative identity) for this type.",4,{"inputs":[],"output":{"name":"self"}}],[11,"eq","","",0,null],[11,"ne","","",0,null],[11,"partial_cmp","","",0,null],[11,"lt","","",0,null],[11,"le","","",0,null],[11,"gt","","",0,null],[11,"ge","","",0,null],[11,"cmp","","",0,null],[11,"clone","","",0,null],[11,"default","","",0,{"inputs":[],"output":{"name":"wrapping"}}],[11,"hash","","",0,null],[11,"fmt","","",0,null],[11,"fmt","","",0,null],[11,"fmt","","",0,null],[11,"fmt","","",0,null],[11,"fmt","","",0,null],[11,"fmt","","",0,null],[11,"clone","","",1,null],[11,"eq","","",1,null],[11,"fmt","","",1,null],[11,"fmt","","",5,null],[11,"clone","","",5,null],[11,"fmt","","",5,null],[11,"fmt","","",6,null],[11,"clone","","",6,null],[11,"eq","","",6,null],[11,"ne","","",6,null],[11,"fmt","","",6,null],[0,"prelude","core","The libcore prelude",null,null],[0,"v1","core::prelude","The core prelude",null,null],[0,"intrinsics","core","rustc compiler intrinsics.",null,null],[5,"atomic_cxchg","core::intrinsics","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas both the `success` and `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_acq","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas both the `success` and `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_rel","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_acqrel","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_relaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas both the `success` and `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_failrelaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_failacq","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchgweak","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas both the `success` and `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_acq","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas both the `success` and `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_rel","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_acqrel","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_relaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas both the `success` and `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_failrelaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_failacq","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_load","","Loads the current value of the pointer.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `load` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::load`](../../std/sync/atomic/struct.AtomicBool.html#method.load).",null,null],[5,"atomic_load_acq","","Loads the current value of the pointer.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `load` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::load`](../../std/sync/atomic/struct.AtomicBool.html#method.load).",null,null],[5,"atomic_load_relaxed","","Loads the current value of the pointer.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `load` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::load`](../../std/sync/atomic/struct.AtomicBool.html#method.load).",null,null],[5,"atomic_load_unordered","","",null,null],[5,"atomic_store","","Stores the value at the specified memory location.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `store` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::store`](../../std/sync/atomic/struct.AtomicBool.html#method.store).",null,null],[5,"atomic_store_rel","","Stores the value at the specified memory location.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `store` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::store`](../../std/sync/atomic/struct.AtomicBool.html#method.store).",null,null],[5,"atomic_store_relaxed","","Stores the value at the specified memory location.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `store` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::store`](../../std/sync/atomic/struct.AtomicBool.html#method.store).",null,null],[5,"atomic_store_unordered","","",null,null],[5,"atomic_xchg","","Stores the value at the specified memory location, returning the old value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `swap` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::swap`](../../std/sync/atomic/struct.AtomicBool.html#method.swap).",null,null],[5,"atomic_xchg_acq","","Stores the value at the specified memory location, returning the old value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `swap` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::swap`](../../std/sync/atomic/struct.AtomicBool.html#method.swap).",null,null],[5,"atomic_xchg_rel","","Stores the value at the specified memory location, returning the old value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `swap` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::swap`](../../std/sync/atomic/struct.AtomicBool.html#method.swap).",null,null],[5,"atomic_xchg_acqrel","","Stores the value at the specified memory location, returning the old value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `swap` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::swap`](../../std/sync/atomic/struct.AtomicBool.html#method.swap).",null,null],[5,"atomic_xchg_relaxed","","Stores the value at the specified memory location, returning the old value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `swap` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::swap`](../../std/sync/atomic/struct.AtomicBool.html#method.swap).",null,null],[5,"atomic_xadd","","Add to the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_add` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_add`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_add).",null,null],[5,"atomic_xadd_acq","","Add to the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_add` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_add`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_add).",null,null],[5,"atomic_xadd_rel","","Add to the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_add` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_add`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_add).",null,null],[5,"atomic_xadd_acqrel","","Add to the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_add` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_add`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_add).",null,null],[5,"atomic_xadd_relaxed","","Add to the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_add` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_add`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_add).",null,null],[5,"atomic_xsub","","Subtract from the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_sub` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_sub`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_sub).",null,null],[5,"atomic_xsub_acq","","Subtract from the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_sub` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_sub`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_sub).",null,null],[5,"atomic_xsub_rel","","Subtract from the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_sub` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_sub`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_sub).",null,null],[5,"atomic_xsub_acqrel","","Subtract from the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_sub` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_sub`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_sub).",null,null],[5,"atomic_xsub_relaxed","","Subtract from the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_sub` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_sub`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_sub).",null,null],[5,"atomic_and","","Bitwise and with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_and` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_and`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_and).",null,null],[5,"atomic_and_acq","","Bitwise and with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_and` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_and`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_and).",null,null],[5,"atomic_and_rel","","Bitwise and with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_and` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_and`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_and).",null,null],[5,"atomic_and_acqrel","","Bitwise and with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_and` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_and`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_and).",null,null],[5,"atomic_and_relaxed","","Bitwise and with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_and` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_and`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_and).",null,null],[5,"atomic_nand","","Bitwise nand with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_nand`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_nand).",null,null],[5,"atomic_nand_acq","","Bitwise nand with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_nand`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_nand).",null,null],[5,"atomic_nand_rel","","Bitwise nand with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_nand`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_nand).",null,null],[5,"atomic_nand_acqrel","","Bitwise nand with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_nand`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_nand).",null,null],[5,"atomic_nand_relaxed","","Bitwise nand with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_nand`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_nand).",null,null],[5,"atomic_or","","Bitwise or with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_or` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_or`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_or).",null,null],[5,"atomic_or_acq","","Bitwise or with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_or` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_or`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_or).",null,null],[5,"atomic_or_rel","","Bitwise or with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_or` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_or`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_or).",null,null],[5,"atomic_or_acqrel","","Bitwise or with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_or` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_or`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_or).",null,null],[5,"atomic_or_relaxed","","Bitwise or with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_or` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_or`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_or).",null,null],[5,"atomic_xor","","Bitwise xor with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_xor` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_xor`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_xor).",null,null],[5,"atomic_xor_acq","","Bitwise xor with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_xor` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_xor`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_xor).",null,null],[5,"atomic_xor_rel","","Bitwise xor with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_xor` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_xor`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_xor).",null,null],[5,"atomic_xor_acqrel","","Bitwise xor with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_xor` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_xor`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_xor).",null,null],[5,"atomic_xor_relaxed","","Bitwise xor with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_xor` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_xor`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_xor).",null,null],[5,"atomic_max","","",null,null],[5,"atomic_max_acq","","",null,null],[5,"atomic_max_rel","","",null,null],[5,"atomic_max_acqrel","","",null,null],[5,"atomic_max_relaxed","","",null,null],[5,"atomic_min","","",null,null],[5,"atomic_min_acq","","",null,null],[5,"atomic_min_rel","","",null,null],[5,"atomic_min_acqrel","","",null,null],[5,"atomic_min_relaxed","","",null,null],[5,"atomic_umin","","",null,null],[5,"atomic_umin_acq","","",null,null],[5,"atomic_umin_rel","","",null,null],[5,"atomic_umin_acqrel","","",null,null],[5,"atomic_umin_relaxed","","",null,null],[5,"atomic_umax","","",null,null],[5,"atomic_umax_acq","","",null,null],[5,"atomic_umax_rel","","",null,null],[5,"atomic_umax_acqrel","","",null,null],[5,"atomic_umax_relaxed","","",null,null],[5,"atomic_fence","","",null,null],[5,"atomic_fence_acq","","",null,null],[5,"atomic_fence_rel","","",null,null],[5,"atomic_fence_acqrel","","",null,null],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acq","","",null,null],[5,"atomic_singlethreadfence_rel","","",null,null],[5,"atomic_singlethreadfence_acqrel","","",null,null],[5,"rustc_peek","","Magic intrinsic that derives its meaning from attributes\nattached to the function.",null,null],[5,"abort","","Aborts the execution of the process.",null,null],[5,"unreachable","","Tells LLVM that this point in the code is not reachable,\nenabling further optimizations.",null,null],[5,"assume","","Informs the optimizer that a condition is always true.\nIf the condition is false, the behavior is undefined.",null,null],[5,"likely","","Hints to the compiler that branch condition is likely to be true.\nReturns the value passed to it.",null,null],[5,"unlikely","","Hints to the compiler that branch condition is likely to be false.\nReturns the value passed to it.",null,null],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",null,null],[5,"size_of","","The size of a type in bytes.",null,null],[5,"move_val_init","","Moves a value to an uninitialized memory location.",null,null],[5,"min_align_of","","",null,null],[5,"pref_align_of","","",null,null],[5,"size_of_val","","",null,null],[5,"min_align_of_val","","",null,null],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,null],[5,"type_name","","Gets a static string slice containing the name of a type.",null,null],[5,"type_id","","Gets an identifier which is globally unique to the specified type. This\nfunction will return the same value for a type regardless of whichever\ncrate it is invoked in.",null,null],[5,"init","","Creates a value initialized to zero.",null,null],[5,"uninit","","Creates an uninitialized value.",null,null],[5,"forget","","Moves a value out of scope without running drop glue.",null,null],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",null,null],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires drop\nglue; returns `false` if the actual type provided for `T`\nimplements `Copy`.",null,null],[5,"offset","","Calculates the offset from a pointer.",null,null],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",null,null],[5,"copy_nonoverlapping","","Copies `count * size_of&lt;T&gt;` bytes from `src` to `dst`. The source\nand destination may *not* overlap.",null,null],[5,"copy","","Copies `count * size_of&lt;T&gt;` bytes from `src` to `dst`. The source\nand destination may overlap.",null,null],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::&lt;T&gt;()`\nbytes of memory starting at `dst` to `val`.",null,null],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*` intrinsic, with\na size of `count` * `size_of::&lt;T&gt;()` and an alignment of\n`min_align_of::&lt;T&gt;()`",null,null],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*` intrinsic, with\na size of `count` * `size_of::&lt;T&gt;()` and an alignment of\n`min_align_of::&lt;T&gt;()`",null,null],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*` intrinsic, with a\nsize of `count` * `size_of::&lt;T&gt;()` and an alignment of\n`min_align_of::&lt;T&gt;()`.",null,null],[5,"volatile_load","","Perform a volatile load from the `src` pointer.\nThe stabilized version of this intrinsic is\n[`std::ptr::read_volatile`](../../std/ptr/fn.read_volatile.html).",null,null],[5,"volatile_store","","Perform a volatile store to the `dst` pointer.\nThe stabilized version of this intrinsic is\n[`std::ptr::write_volatile`](../../std/ptr/fn.write_volatile.html).",null,null],[5,"sqrtf32","","Returns the square root of an `f32`",null,null],[5,"sqrtf64","","Returns the square root of an `f64`",null,null],[5,"powif32","","Raises an `f32` to an integer power.",null,null],[5,"powif64","","Raises an `f64` to an integer power.",null,null],[5,"sinf32","","Returns the sine of an `f32`.",null,null],[5,"sinf64","","Returns the sine of an `f64`.",null,null],[5,"cosf32","","Returns the cosine of an `f32`.",null,null],[5,"cosf64","","Returns the cosine of an `f64`.",null,null],[5,"powf32","","Raises an `f32` to an `f32` power.",null,null],[5,"powf64","","Raises an `f64` to an `f64` power.",null,null],[5,"expf32","","Returns the exponential of an `f32`.",null,null],[5,"expf64","","Returns the exponential of an `f64`.",null,null],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",null,null],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",null,null],[5,"logf32","","Returns the natural logarithm of an `f32`.",null,null],[5,"logf64","","Returns the natural logarithm of an `f64`.",null,null],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",null,null],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",null,null],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",null,null],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",null,null],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",null,null],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",null,null],[5,"fabsf32","","Returns the absolute value of an `f32`.",null,null],[5,"fabsf64","","Returns the absolute value of an `f64`.",null,null],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",null,null],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",null,null],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",null,null],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",null,null],[5,"ceilf32","","Returns the smallest integer greater than or equal to an `f32`.",null,null],[5,"ceilf64","","Returns the smallest integer greater than or equal to an `f64`.",null,null],[5,"truncf32","","Returns the integer part of an `f32`.",null,null],[5,"truncf64","","Returns the integer part of an `f64`.",null,null],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an inexact floating-point exception\nif the argument is not an integer.",null,null],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an inexact floating-point exception\nif the argument is not an integer.",null,null],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",null,null],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",null,null],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way cases away from zero.",null,null],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way cases away from zero.",null,null],[5,"fadd_fast","","Float addition that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,null],[5,"fsub_fast","","Float subtraction that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,null],[5,"fmul_fast","","Float multiplication that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,null],[5,"fdiv_fast","","Float division that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,null],[5,"frem_fast","","Float remainder that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,null],[5,"ctpop","","Returns the number of bits set in an integer type `T`",null,null],[5,"ctlz","","Returns the number of leading bits unset in an integer type `T`",null,null],[5,"cttz","","Returns the number of trailing bits unset in an integer type `T`",null,null],[5,"bswap","","Reverses the bytes in an integer type `T`.",null,null],[5,"add_with_overflow","","Performs checked integer addition.\nThe stabilized versions of this intrinsic are available on the integer\nprimitives via the `overflowing_add` method. For example,\n[`std::u32::overflowing_add`](../../std/primitive.u32.html#method.overflowing_add)",null,null],[5,"sub_with_overflow","","Performs checked integer subtraction\nThe stabilized versions of this intrinsic are available on the integer\nprimitives via the `overflowing_sub` method. For example,\n[`std::u32::overflowing_sub`](../../std/primitive.u32.html#method.overflowing_sub)",null,null],[5,"mul_with_overflow","","Performs checked integer multiplication\nThe stabilized versions of this intrinsic are available on the integer\nprimitives via the `overflowing_mul` method. For example,\n[`std::u32::overflowing_mul`](../../std/primitive.u32.html#method.overflowing_mul)",null,null],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined behavior\nwhere y = 0 or x = `T::min_value()` and y = -1",null,null],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting in\nundefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,null],[5,"overflowing_add","","Returns (a + b) mod 2^N, where N is the width of T in bits.\nThe stabilized versions of this intrinsic are available on the integer\nprimitives via the `wrapping_add` method. For example,\n[`std::u32::wrapping_add`](../../std/primitive.u32.html#method.wrapping_add)",null,null],[5,"overflowing_sub","","Returns (a - b) mod 2^N, where N is the width of T in bits.\nThe stabilized versions of this intrinsic are available on the integer\nprimitives via the `wrapping_sub` method. For example,\n[`std::u32::wrapping_sub`](../../std/primitive.u32.html#method.wrapping_sub)",null,null],[5,"overflowing_mul","","Returns (a * b) mod 2^N, where N is the width of T in bits.\nThe stabilized versions of this intrinsic are available on the integer\nprimitives via the `wrapping_mul` method. For example,\n[`std::u32::wrapping_mul`](../../std/primitive.u32.html#method.wrapping_mul)",null,null],[5,"discriminant_value","","Returns the value of the discriminant for the variant in &#39;v&#39;,\ncast to a `u64`; if `T` has no discriminant, returns 0.",null,null],[5,"try","","Rust&#39;s &quot;try catch&quot; construct which invokes the function pointer `f` with\nthe data pointer `data`.",null,null],[0,"mem","core","Basic functions for dealing with memory.",null,null],[3,"Discriminant","core::mem","Opaque type representing the discriminant of an enum.",null,null],[5,"forget","","Leaks a value: takes ownership and &quot;forgets&quot; about the value **without running\nits destructor**.",null,{"inputs":[{"name":"t"}],"output":null}],[5,"size_of","","Returns the size of a type in bytes.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"zeroed","","Creates a value whose bytes are all zero.",null,{"inputs":[],"output":{"name":"t"}}],[5,"uninitialized","","Bypasses Rust&#39;s normal memory-initialization checks by pretending to\nproduce a value of type `T`, while doing nothing at all.",null,{"inputs":[],"output":{"name":"t"}}],[5,"swap","","Swaps the values at two mutable locations, without deinitializing either one.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":null}],[5,"replace","","Replaces the value at a mutable location with a new one, returning the old value, without\ndeinitializing either one.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"drop","","Disposes of a value.",null,{"inputs":[{"name":"t"}],"output":null}],[5,"transmute_copy","","Interprets `src` as having type `&amp;U`, and then reads `src` without moving\nthe contained value.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[5,"discriminant","","Returns a value uniquely identifying the enum variant in `v`.",null,{"inputs":[{"name":"t"}],"output":{"name":"discriminant"}}],[11,"clone","","",7,null],[11,"eq","","",7,null],[11,"hash","","",7,null],[11,"fmt","","",7,null],[0,"nonzero","core","Exposes the NonZero lang item which provides optimization hints.",null,null],[3,"NonZero","core::nonzero","A wrapper type for raw pointers and integers that will never be\nNULL or 0 that might allow certain optimizations.",null,null],[8,"Zeroable","","Unsafe trait to indicate what types are usable with the NonZero struct",null,null],[11,"clone","","",8,null],[11,"eq","","",8,null],[11,"ne","","",8,null],[11,"cmp","","",8,null],[11,"partial_cmp","","",8,null],[11,"lt","","",8,null],[11,"le","","",8,null],[11,"gt","","",8,null],[11,"ge","","",8,null],[11,"fmt","","",8,null],[11,"hash","","",8,null],[11,"new","","Creates an instance of NonZero with the provided value.\nYou must indeed ensure that the value is actually &quot;non-zero&quot;.",8,{"inputs":[{"name":"t"}],"output":{"name":"nonzero"}}],[11,"deref","","",8,null],[0,"ptr","core","Raw, unsafe pointers, `*const T`, and `*mut T`.",null,null],[3,"Unique","core::ptr","A wrapper around a raw non-null `*mut T` that indicates that the possessor\nof this wrapper owns the referent. This in turn implies that the\n`Unique&lt;T&gt;` is `Send`/`Sync` if `T` is `Send`/`Sync`, unlike a raw\n`*mut T` (which conveys no particular ownership semantics).  It\nalso implies that the referent of the pointer should not be\nmodified without a unique path to the `Unique` reference. Useful\nfor building abstractions like `Vec&lt;T&gt;` or `Box&lt;T&gt;`, which\ninternally use raw pointers to manage the memory that they own.",null,null],[3,"Shared","","A wrapper around a raw non-null `*mut T` that indicates that the possessor\nof this wrapper has shared ownership of the referent. Useful for\nbuilding abstractions like `Rc&lt;T&gt;` or `Arc&lt;T&gt;`, which internally\nuse raw pointers to manage the memory that they own.",null,null],[5,"null","","Creates a null raw pointer.",null,null],[5,"null_mut","","Creates a null mutable raw pointer.",null,null],[5,"swap","","Swaps the values at two mutable locations of the same type, without\ndeinitializing either. They may overlap, unlike `mem::swap` which is\notherwise equivalent.",null,null],[5,"replace","","Replaces the value at `dest` with `src`, returning the old\nvalue, without dropping either.",null,null],[5,"read","","Reads the value from `src` without moving it. This leaves the\nmemory in `src` unchanged.",null,null],[5,"read_unaligned","","Reads the value from `src` without moving it. This leaves the\nmemory in `src` unchanged.",null,null],[5,"write","","Overwrites a memory location with the given value without reading or\ndropping the old value.",null,null],[5,"write_unaligned","","Overwrites a memory location with the given value without reading or\ndropping the old value.",null,null],[5,"read_volatile","","Performs a volatile read of the value from `src` without moving it. This\nleaves the memory in `src` unchanged.",null,null],[5,"write_volatile","","Performs a volatile write of a memory location with the given value without\nreading or dropping the old value.",null,null],[5,"eq","","Compare raw pointers for equality.",null,null],[11,"new","","Creates a new `Unique`.",9,null],[11,"get","","Dereferences the content.",9,null],[11,"get_mut","","Mutably dereferences the content.",9,null],[11,"deref","","",9,null],[11,"fmt","","",9,null],[11,"new","","Creates a new `Shared`.",10,null],[11,"clone","","",10,null],[11,"deref","","",10,null],[11,"fmt","","",10,null],[0,"marker","core","Primitive traits and types representing basic properties of types.",null,null],[3,"PhantomData","core::marker","Zero-sized type used to mark things that &quot;act like&quot; they own a `T`.",null,null],[8,"Send","","Types that can be transferred across thread boundaries.",null,null],[8,"Sized","","Types with a constant size known at compile time.",null,null],[8,"Unsize","","Types that can be &quot;unsized&quot; to a dynamically-sized type.",null,null],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",null,null],[8,"Sync","","Types for which it is safe to share references between threads.",null,null],[8,"Reflect","","Types that can be reflected over.",null,null],[11,"hash","","",11,null],[11,"eq","","",11,null],[11,"partial_cmp","","",11,null],[11,"cmp","","",11,null],[11,"clone","","",11,null],[11,"default","","",11,{"inputs":[],"output":{"name":"phantomdata"}}],[0,"ops","core","Overloadable operators.",null,null],[3,"RangeFull","core::ops","An unbounded range. Use `..` (two dots) for its shorthand.",null,null],[3,"Range","","A (half-open) range which is bounded at both ends: { x | start &lt;= x &lt; end }.\nUse `start..end` (two dots) for its shorthand.",null,null],[12,"start","","The lower bound of the range (inclusive).",12,null],[12,"end","","The upper bound of the range (exclusive).",12,null],[3,"RangeFrom","","A range which is only bounded below: { x | start &lt;= x }.\nUse `start..` for its shorthand.",null,null],[12,"start","","The lower bound of the range (inclusive).",13,null],[3,"RangeTo","","A range which is only bounded above: { x | x &lt; end }.\nUse `..end` (two dots) for its shorthand.",null,null],[12,"end","","The upper bound of the range (exclusive).",14,null],[3,"RangeToInclusive","","An inclusive range which is only bounded above: { x | x &lt;= end }.\nUse `...end` (three dots) for its shorthand.",null,null],[12,"end","","The upper bound of the range (inclusive)",15,null],[4,"RangeInclusive","","An inclusive range which is bounded at both ends: { x | start &lt;= x &lt;= end }.\nUse `start...end` (three dots) for its shorthand.",null,null],[13,"Empty","","Empty range (iteration has finished)",16,null],[12,"at","core::ops::RangeInclusive","The point at which iteration finished",16,null],[13,"NonEmpty","core::ops","Non-empty range (iteration will yield value(s))",16,null],[12,"start","core::ops::RangeInclusive","The lower bound of the range (inclusive).",16,null],[12,"end","","The upper bound of the range (inclusive).",16,null],[8,"Drop","core::ops","The `Drop` trait is used to run some code when a value goes out of scope.\nThis is sometimes called a &#39;destructor&#39;.",null,null],[10,"drop","","A method called when the value goes out of scope.",17,null],[8,"Add","","The `Add` trait is used to specify the functionality of `+`.",null,null],[16,"Output","","The resulting type after applying the `+` operator",18,null],[10,"add","","The method for the `+` operator",18,null],[8,"Sub","","The `Sub` trait is used to specify the functionality of `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator",19,null],[10,"sub","","The method for the `-` operator",19,null],[8,"Mul","","The `Mul` trait is used to specify the functionality of `*`.",null,null],[16,"Output","","The resulting type after applying the `*` operator",20,null],[10,"mul","","The method for the `*` operator",20,null],[8,"Div","","The `Div` trait is used to specify the functionality of `/`.",null,null],[16,"Output","","The resulting type after applying the `/` operator",21,null],[10,"div","","The method for the `/` operator",21,null],[8,"Rem","","The `Rem` trait is used to specify the functionality of `%`.",null,null],[16,"Output","","The resulting type after applying the `%` operator",22,null],[10,"rem","","The method for the `%` operator",22,null],[8,"Neg","","The `Neg` trait is used to specify the functionality of unary `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator",23,null],[10,"neg","","The method for the unary `-` operator",23,null],[8,"Not","","The `Not` trait is used to specify the functionality of unary `!`.",null,null],[16,"Output","","The resulting type after applying the `!` operator",24,null],[10,"not","","The method for the unary `!` operator",24,null],[8,"BitAnd","","The `BitAnd` trait is used to specify the functionality of `&amp;`.",null,null],[16,"Output","","The resulting type after applying the `&amp;` operator",25,null],[10,"bitand","","The method for the `&amp;` operator",25,null],[8,"BitOr","","The `BitOr` trait is used to specify the functionality of `|`.",null,null],[16,"Output","","The resulting type after applying the `|` operator",26,null],[10,"bitor","","The method for the `|` operator",26,null],[8,"BitXor","","The `BitXor` trait is used to specify the functionality of `^`.",null,null],[16,"Output","","The resulting type after applying the `^` operator",27,null],[10,"bitxor","","The method for the `^` operator",27,null],[8,"Shl","","The `Shl` trait is used to specify the functionality of `&lt;&lt;`.",null,null],[16,"Output","","The resulting type after applying the `&lt;&lt;` operator",28,null],[10,"shl","","The method for the `&lt;&lt;` operator",28,null],[8,"Shr","","The `Shr` trait is used to specify the functionality of `&gt;&gt;`.",null,null],[16,"Output","","The resulting type after applying the `&gt;&gt;` operator",29,null],[10,"shr","","The method for the `&gt;&gt;` operator",29,null],[8,"AddAssign","","The `AddAssign` trait is used to specify the functionality of `+=`.",null,null],[10,"add_assign","","The method for the `+=` operator",30,null],[8,"SubAssign","","The `SubAssign` trait is used to specify the functionality of `-=`.",null,null],[10,"sub_assign","","The method for the `-=` operator",31,null],[8,"MulAssign","","The `MulAssign` trait is used to specify the functionality of `*=`.",null,null],[10,"mul_assign","","The method for the `*=` operator",32,null],[8,"DivAssign","","The `DivAssign` trait is used to specify the functionality of `/=`.",null,null],[10,"div_assign","","The method for the `/=` operator",33,null],[8,"RemAssign","","The `RemAssign` trait is used to specify the functionality of `%=`.",null,null],[10,"rem_assign","","The method for the `%=` operator",34,null],[8,"BitAndAssign","","The `BitAndAssign` trait is used to specify the functionality of `&amp;=`.",null,null],[10,"bitand_assign","","The method for the `&amp;=` operator",35,null],[8,"BitOrAssign","","The `BitOrAssign` trait is used to specify the functionality of `|=`.",null,null],[10,"bitor_assign","","The method for the `|=` operator",36,null],[8,"BitXorAssign","","The `BitXorAssign` trait is used to specify the functionality of `^=`.",null,null],[10,"bitxor_assign","","The method for the `^=` operator",37,null],[8,"ShlAssign","","The `ShlAssign` trait is used to specify the functionality of `&lt;&lt;=`.",null,null],[10,"shl_assign","","The method for the `&lt;&lt;=` operator",38,null],[8,"ShrAssign","","The `ShrAssign` trait is used to specify the functionality of `&gt;&gt;=`.",null,null],[10,"shr_assign","","The method for the `&gt;&gt;=` operator",39,null],[8,"Index","","The `Index` trait is used to specify the functionality of indexing operations\nlike `container[index]` when used in an immutable context.",null,null],[16,"Output","","The returned type after indexing",40,null],[10,"index","","The method for the indexing (`container[index]`) operation",40,null],[8,"IndexMut","","The `IndexMut` trait is used to specify the functionality of indexing\noperations like `container[index]` when used in a mutable context.",null,null],[10,"index_mut","","The method for the mutable indexing (`container[index]`) operation",41,null],[8,"Deref","","The `Deref` trait is used to specify the functionality of dereferencing\noperations, like `*v`.",null,null],[16,"Target","","The resulting type after dereferencing",42,null],[10,"deref","","The method called to dereference a value",42,null],[8,"DerefMut","","The `DerefMut` trait is used to specify the functionality of dereferencing\nmutably like `*v = 1;`",null,null],[10,"deref_mut","","The method called to mutably dereference a value",43,null],[8,"Fn","","A version of the call operator that takes an immutable receiver.",null,null],[10,"call","","This is called when the call operator is used.",44,null],[8,"FnMut","","A version of the call operator that takes a mutable receiver.",null,null],[10,"call_mut","","This is called when the call operator is used.",45,null],[8,"FnOnce","","A version of the call operator that takes a by-value receiver.",null,null],[16,"Output","","The returned type after the call operator is used.",46,null],[10,"call_once","","This is called when the call operator is used.",46,null],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper for one,\nwhere unsizing can be performed on the pointee.",null,null],[8,"Place","","Both `in (PLACE) EXPR` and `box EXPR` desugar into expressions\nthat allocate an intermediate &quot;place&quot; that holds uninitialized\nstate.  The desugaring evaluates EXPR, and writes the result at\nthe address returned by the `pointer` method of this trait.",null,null],[10,"pointer","","Returns the address where the input value will be written.\nNote that the data at this address is generally uninitialized,\nand thus one should use `ptr::write` for initializing it.",47,null],[8,"Placer","","Interface to implementations of  `in (PLACE) EXPR`.",null,null],[16,"Place","","`Place` is the intermedate agent guarding the\nuninitialized state for `Data`.",48,null],[10,"make_place","","Creates a fresh place from `self`.",48,null],[8,"InPlace","","Specialization of `Place` trait supporting `in (PLACE) EXPR`.",null,null],[16,"Owner","","`Owner` is the type of the end value of `in (PLACE) EXPR`",49,null],[10,"finalize","","Converts self into the final value, shifting\ndeallocation/cleanup responsibilities (if any remain), over to\nthe returned instance of `Owner` and forgetting self.",49,null],[8,"Boxed","","Core trait for the `box EXPR` form.",null,null],[16,"Data","","The kind of data that is stored in this kind of box.",50,null],[16,"Place","","The place that will negotiate the storage of the data.",50,null],[10,"finalize","","Converts filled place into final owning value, shifting\ndeallocation/cleanup responsibilities (if any remain), over to\nreturned instance of `Self` and forgetting `filled`.",50,null],[8,"BoxPlace","","Specialization of `Place` trait supporting `box EXPR`.",null,null],[10,"make_place","","Creates a globally fresh place.",51,{"inputs":[],"output":{"name":"self"}}],[8,"Carrier","","A trait for types which have success and error states and are meant to work\nwith the question mark operator.\nWhen the `?` operator is used with a value, whether the value is in the\nsuccess or error state is determined by calling `translate`.",null,null],[16,"Success","","The type of the value when computation succeeds.",52,null],[16,"Error","","The type of the value when computation errors out.",52,null],[10,"from_success","","Create a `Carrier` from a success value.",52,null],[10,"from_error","","Create a `Carrier` from an error value.",52,null],[10,"translate","","Translate this `Carrier` to another implementation of `Carrier` with the\nsame associated types.",52,null],[11,"clone","","",53,null],[11,"eq","","",53,null],[11,"hash","","",53,null],[11,"fmt","","",53,null],[11,"clone","","",12,null],[11,"eq","","",12,null],[11,"ne","","",12,null],[11,"hash","","",12,null],[11,"fmt","","",12,null],[11,"contains","","# Examples",12,null],[11,"clone","","",13,null],[11,"eq","","",13,null],[11,"ne","","",13,null],[11,"hash","","",13,null],[11,"fmt","","",13,null],[11,"contains","","# Examples",13,null],[11,"clone","","",14,null],[11,"eq","","",14,null],[11,"ne","","",14,null],[11,"hash","","",14,null],[11,"fmt","","",14,null],[11,"contains","","# Examples",14,null],[11,"clone","","",16,null],[11,"eq","","",16,null],[11,"ne","","",16,null],[11,"hash","","",16,null],[11,"fmt","","",16,null],[11,"contains","","# Examples",16,null],[11,"clone","","",15,null],[11,"eq","","",15,null],[11,"ne","","",15,null],[11,"hash","","",15,null],[11,"fmt","","",15,null],[11,"contains","","# Examples",15,null],[0,"cmp","core","Functionality for ordering and comparison.",null,null],[4,"Ordering","core::cmp","An `Ordering` is the result of a comparison between two values.",null,null],[13,"Less","","An ordering where a compared value is less [than another].",54,null],[13,"Equal","","An ordering where a compared value is equal [to another].",54,null],[13,"Greater","","An ordering where a compared value is greater [than another].",54,null],[5,"min","","Compare and return the minimum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"max","","Compare and return the maximum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[8,"PartialEq","","Trait for equality comparisons which are [partial equivalence\nrelations](http://en.wikipedia.org/wiki/Partial_equivalence_relation).",null,null],[10,"eq","","This method tests for `self` and `other` values to be equal, and is used\nby `==`.",55,null],[11,"ne","","This method tests for `!=`.",55,null],[8,"Eq","","Trait for equality comparisons which are [equivalence relations](\nhttps://en.wikipedia.org/wiki/Equivalence_relation).",null,null],[8,"Ord","","Trait for types that form a [total order](https://en.wikipedia.org/wiki/Total_order).",null,null],[10,"cmp","","This method returns an `Ordering` between `self` and `other`.",56,null],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",null,null],[10,"partial_cmp","","This method returns an ordering between `self` and `other` values if one exists.",57,null],[11,"lt","","This method tests less than (for `self` and `other`) and is used by the `&lt;` operator.",57,null],[11,"le","","This method tests less than or equal to (for `self` and `other`) and is used by the `&lt;=`\noperator.",57,null],[11,"gt","","This method tests greater than (for `self` and `other`) and is used by the `&gt;` operator.",57,null],[11,"ge","","This method tests greater than or equal to (for `self` and `other`) and is used by the `&gt;=`\noperator.",57,null],[11,"clone","","",54,null],[11,"eq","","",54,null],[11,"fmt","","",54,null],[11,"hash","","",54,null],[11,"reverse","","Reverse the `Ordering`.",54,null],[11,"then","","Chains two orderings.",54,null],[11,"then_with","","Chains the ordering with the given function.",54,null],[11,"cmp","","",54,null],[11,"partial_cmp","","",54,null],[0,"clone","core","The `Clone` trait for types that cannot be &#39;implicitly copied&#39;.",null,null],[8,"Clone","core::clone","A common trait for the ability to explicitly duplicate an object.",null,null],[10,"clone","","Returns a copy of the value.",58,null],[11,"clone_from","","Performs copy-assignment from `source`.",58,null],[0,"default","core","The `Default` trait for types which may have meaningful default values.",null,null],[8,"Default","core::default","A trait for giving a type a useful default value.",null,null],[10,"default","","Returns the &quot;default value&quot; for a type.",59,{"inputs":[],"output":{"name":"self"}}],[0,"convert","core","Traits for conversions between types.",null,null],[8,"AsRef","core::convert","A cheap, reference-to-reference conversion.",null,null],[10,"as_ref","","Performs the conversion.",60,null],[8,"AsMut","","A cheap, mutable reference-to-mutable reference conversion.",null,null],[10,"as_mut","","Performs the conversion.",61,null],[8,"Into","","A conversion that consumes `self`, which may or may not be expensive.",null,null],[10,"into","","Performs the conversion.",62,null],[8,"From","","Construct `Self` via a conversion.",null,null],[10,"from","","Performs the conversion.",63,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"TryInto","","An attempted conversion that consumes `self`, which may or may not be expensive.",null,null],[16,"Err","","The type returned in the event of a conversion error.",64,null],[10,"try_into","","Performs the conversion.",64,null],[8,"TryFrom","","Attempt to construct `Self` via a conversion.",null,null],[16,"Err","","The type returned in the event of a conversion error.",65,null],[10,"try_from","","Performs the conversion.",65,{"inputs":[{"name":"t"}],"output":{"name":"result"}}],[0,"borrow","core","A module for working with borrowed data.",null,null],[8,"Borrow","core::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",66,null],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",67,null],[0,"any","core","This module implements the `Any` trait, which enables dynamic typing\nof any `&#39;static` type through runtime reflection.",null,null],[3,"TypeId","core::any","A `TypeId` represents a globally unique identifier for a type.",null,null],[8,"Any","","A type to emulate dynamic typing.",null,null],[10,"get_type_id","","Gets the `TypeId` of `self`.",68,null],[11,"fmt","","",68,null],[11,"fmt","","",68,null],[11,"is","","Returns true if the boxed type is the same as `T`.",68,null],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or\n`None` if it isn&#39;t.",68,null],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or\n`None` if it isn&#39;t.",68,null],[11,"is","","Forwards to the method defined on the type `Any`.",68,null],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",68,null],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",68,null],[11,"clone","","",69,null],[11,"eq","","",69,null],[11,"ne","","",69,null],[11,"fmt","","",69,null],[11,"hash","","",69,null],[11,"of","","Returns the `TypeId` of the type this generic function has been\ninstantiated with.",69,{"inputs":[],"output":{"name":"typeid"}}],[0,"array","core","Implementations of things like `Eq` for fixed-length arrays\nup to a certain length. Eventually we should able to generalize\nto all lengths.",null,null],[8,"FixedSizeArray","core::array","Utility trait implemented only on arrays of fixed size",null,null],[10,"as_slice","","Converts the array to immutable slice",70,null],[10,"as_mut_slice","","Converts the array to mutable slice",70,null],[0,"sync","core","Synchronization primitives",null,null],[0,"atomic","core::sync","Atomic types",null,null],[3,"AtomicBool","core::sync::atomic","A boolean type which can be safely shared between threads.",null,null],[3,"AtomicPtr","","A raw pointer type which can be safely shared between threads.",null,null],[3,"AtomicI8","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU8","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI16","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU16","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI32","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU32","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI64","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU64","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicIsize","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicUsize","","An integer type which can be safely shared between threads.",null,null],[4,"Ordering","","Atomic memory orderings",null,null],[13,"Relaxed","","No ordering constraints, only atomic operations. Corresponds to LLVM&#39;s\n`Monotonic` ordering.",71,null],[13,"Release","","When coupled with a store, all previous writes become visible\nto the other threads that perform a load with `Acquire` ordering\non the same value.",71,null],[13,"Acquire","","When coupled with a load, all subsequent loads will see data\nwritten before a store with `Release` ordering on the same value\nin other threads.",71,null],[13,"AcqRel","","When coupled with a load, uses `Acquire` ordering, and with a store\n`Release` ordering.",71,null],[13,"SeqCst","","Like `AcqRel` with the additional guarantee that all threads see all\nsequentially consistent operations in the same order.",71,null],[5,"fence","","An atomic fence.",null,{"inputs":[{"name":"ordering"}],"output":null}],[17,"ATOMIC_BOOL_INIT","","An `AtomicBool` initialized to `false`.",null,null],[17,"ATOMIC_I8_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U8_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I16_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U16_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I32_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U32_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I64_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U64_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_ISIZE_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_USIZE_INIT","","An atomic integer initialized to `0`.",null,null],[11,"default","","Creates an `AtomicBool` initialized to `false`.",72,{"inputs":[],"output":{"name":"self"}}],[11,"default","","Creates a null `AtomicPtr&lt;T&gt;`.",73,{"inputs":[],"output":{"name":"atomicptr"}}],[11,"clone","","",71,null],[11,"fmt","","",71,null],[11,"new","","Creates a new `AtomicBool`.",72,{"inputs":[{"name":"bool"}],"output":{"name":"atomicbool"}}],[11,"get_mut","","Returns a mutable reference to the underlying `bool`.",72,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",72,null],[11,"load","","Loads a value from the bool.",72,null],[11,"store","","Stores a value into the bool.",72,null],[11,"swap","","Stores a value into the bool, returning the old value.",72,null],[11,"compare_and_swap","","Stores a value into the `bool` if the current value is the same as the `current` value.",72,null],[11,"compare_exchange","","Stores a value into the `bool` if the current value is the same as the `current` value.",72,null],[11,"compare_exchange_weak","","Stores a value into the `bool` if the current value is the same as the `current` value.",72,null],[11,"fetch_and","","Logical &quot;and&quot; with a boolean value.",72,null],[11,"fetch_nand","","Logical &quot;nand&quot; with a boolean value.",72,null],[11,"fetch_or","","Logical &quot;or&quot; with a boolean value.",72,null],[11,"fetch_xor","","Logical &quot;xor&quot; with a boolean value.",72,null],[11,"new","","Creates a new `AtomicPtr`.",73,null],[11,"get_mut","","Returns a mutable reference to the underlying pointer.",73,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",73,null],[11,"load","","Loads a value from the pointer.",73,null],[11,"store","","Stores a value into the pointer.",73,null],[11,"swap","","Stores a value into the pointer, returning the old value.",73,null],[11,"compare_and_swap","","Stores a value into the pointer if the current value is the same as the `current` value.",73,null],[11,"compare_exchange","","Stores a value into the pointer if the current value is the same as the `current` value.",73,null],[11,"compare_exchange_weak","","Stores a value into the pointer if the current value is the same as the `current` value.",73,null],[11,"default","","",74,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",74,null],[11,"new","","Creates a new atomic integer.",74,{"inputs":[{"name":"i8"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",74,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",74,null],[11,"load","","Loads a value from the atomic integer.",74,null],[11,"store","","Stores a value into the atomic integer.",74,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",74,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",74,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",74,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",74,null],[11,"fetch_add","","Add to the current value, returning the previous value.",74,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",74,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",74,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",74,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",74,null],[11,"default","","",75,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",75,null],[11,"new","","Creates a new atomic integer.",75,{"inputs":[{"name":"u8"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",75,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",75,null],[11,"load","","Loads a value from the atomic integer.",75,null],[11,"store","","Stores a value into the atomic integer.",75,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",75,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",75,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",75,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",75,null],[11,"fetch_add","","Add to the current value, returning the previous value.",75,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",75,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",75,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",75,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",75,null],[11,"default","","",76,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",76,null],[11,"new","","Creates a new atomic integer.",76,{"inputs":[{"name":"i16"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",76,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",76,null],[11,"load","","Loads a value from the atomic integer.",76,null],[11,"store","","Stores a value into the atomic integer.",76,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",76,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",76,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",76,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",76,null],[11,"fetch_add","","Add to the current value, returning the previous value.",76,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",76,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",76,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",76,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",76,null],[11,"default","","",77,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",77,null],[11,"new","","Creates a new atomic integer.",77,{"inputs":[{"name":"u16"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",77,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",77,null],[11,"load","","Loads a value from the atomic integer.",77,null],[11,"store","","Stores a value into the atomic integer.",77,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",77,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",77,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",77,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",77,null],[11,"fetch_add","","Add to the current value, returning the previous value.",77,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",77,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",77,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",77,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",77,null],[11,"default","","",78,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",78,null],[11,"new","","Creates a new atomic integer.",78,{"inputs":[{"name":"i32"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",78,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",78,null],[11,"load","","Loads a value from the atomic integer.",78,null],[11,"store","","Stores a value into the atomic integer.",78,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",78,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",78,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",78,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",78,null],[11,"fetch_add","","Add to the current value, returning the previous value.",78,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",78,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",78,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",78,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",78,null],[11,"default","","",79,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",79,null],[11,"new","","Creates a new atomic integer.",79,{"inputs":[{"name":"u32"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",79,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",79,null],[11,"load","","Loads a value from the atomic integer.",79,null],[11,"store","","Stores a value into the atomic integer.",79,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",79,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",79,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",79,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",79,null],[11,"fetch_add","","Add to the current value, returning the previous value.",79,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",79,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",79,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",79,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",79,null],[11,"default","","",80,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",80,null],[11,"new","","Creates a new atomic integer.",80,{"inputs":[{"name":"i64"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",80,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",80,null],[11,"load","","Loads a value from the atomic integer.",80,null],[11,"store","","Stores a value into the atomic integer.",80,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",80,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",80,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",80,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",80,null],[11,"fetch_add","","Add to the current value, returning the previous value.",80,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",80,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",80,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",80,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",80,null],[11,"default","","",81,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",81,null],[11,"new","","Creates a new atomic integer.",81,{"inputs":[{"name":"u64"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",81,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",81,null],[11,"load","","Loads a value from the atomic integer.",81,null],[11,"store","","Stores a value into the atomic integer.",81,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",81,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",81,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",81,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",81,null],[11,"fetch_add","","Add to the current value, returning the previous value.",81,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",81,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",81,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",81,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",81,null],[11,"default","","",82,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",82,null],[11,"new","","Creates a new atomic integer.",82,{"inputs":[{"name":"isize"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",82,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",82,null],[11,"load","","Loads a value from the atomic integer.",82,null],[11,"store","","Stores a value into the atomic integer.",82,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",82,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",82,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",82,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",82,null],[11,"fetch_add","","Add to the current value, returning the previous value.",82,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",82,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",82,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",82,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",82,null],[11,"default","","",83,{"inputs":[],"output":{"name":"self"}}],[11,"fmt","","",83,null],[11,"new","","Creates a new atomic integer.",83,{"inputs":[{"name":"usize"}],"output":{"name":"self"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",83,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",83,null],[11,"load","","Loads a value from the atomic integer.",83,null],[11,"store","","Stores a value into the atomic integer.",83,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",83,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",83,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",83,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",83,null],[11,"fetch_add","","Add to the current value, returning the previous value.",83,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",83,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",83,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",83,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",83,null],[11,"fmt","","",72,null],[11,"fmt","","",73,null],[0,"cell","core","Shareable mutable containers.",null,null],[3,"Cell","core::cell","A mutable memory location that admits only `Copy` data.",null,null],[3,"RefCell","","A mutable memory location with dynamically checked borrow rules",null,null],[3,"BorrowError","","An error returned by [`RefCell::try_borrow`](struct.RefCell.html#method.try_borrow).",null,null],[3,"BorrowMutError","","An error returned by [`RefCell::try_borrow_mut`](struct.RefCell.html#method.try_borrow_mut).",null,null],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box.\nA wrapper type for an immutably borrowed value from a `RefCell&lt;T&gt;`.",null,null],[3,"RefMut","","A wrapper type for a mutably borrowed value from a `RefCell&lt;T&gt;`.",null,null],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",null,null],[4,"BorrowState","","An enumeration of values returned from the `state` method on a `RefCell&lt;T&gt;`.",null,null],[13,"Reading","","The cell is currently being read, there is at least one active `borrow`.",84,null],[13,"Writing","","The cell is currently being written to, there is an active `borrow_mut`.",84,null],[13,"Unused","","There are no outstanding borrows on this cell.",84,null],[11,"new","","Creates a new `Cell` containing the given value.",85,{"inputs":[{"name":"t"}],"output":{"name":"cell"}}],[11,"get","","Returns a copy of the contained value.",85,null],[11,"set","","Sets the contained value.",85,null],[11,"as_unsafe_cell","","Returns a reference to the underlying `UnsafeCell`.",85,null],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",85,null],[11,"get_mut","","Returns a mutable reference to the underlying data.",85,null],[11,"clone","","",85,null],[11,"default","","Creates a `Cell&lt;T&gt;`, with the `Default` value for T.",85,{"inputs":[],"output":{"name":"cell"}}],[11,"eq","","",85,null],[11,"partial_cmp","","",85,null],[11,"lt","","",85,null],[11,"le","","",85,null],[11,"gt","","",85,null],[11,"ge","","",85,null],[11,"cmp","","",85,null],[11,"from","","",85,{"inputs":[{"name":"t"}],"output":{"name":"cell"}}],[11,"clone","","",84,null],[11,"eq","","",84,null],[11,"fmt","","",84,null],[11,"fmt","","",86,null],[11,"fmt","","",86,null],[11,"fmt","","",87,null],[11,"fmt","","",87,null],[11,"new","","Creates a new `RefCell` containing `value`.",88,{"inputs":[{"name":"t"}],"output":{"name":"refcell"}}],[11,"into_inner","","Consumes the `RefCell`, returning the wrapped value.",88,null],[11,"borrow_state","","Query the current state of this `RefCell`",88,null],[11,"borrow","","Immutably borrows the wrapped value.",88,null],[11,"try_borrow","","Immutably borrows the wrapped value, returning an error if the value is currently mutably\nborrowed.",88,null],[11,"borrow_mut","","Mutably borrows the wrapped value.",88,null],[11,"try_borrow_mut","","Mutably borrows the wrapped value, returning an error if the value is currently borrowed.",88,null],[11,"as_unsafe_cell","","Returns a reference to the underlying `UnsafeCell`.",88,null],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",88,null],[11,"get_mut","","Returns a mutable reference to the underlying data.",88,null],[11,"clone","","",88,null],[11,"default","","Creates a `RefCell&lt;T&gt;`, with the `Default` value for T.",88,{"inputs":[],"output":{"name":"refcell"}}],[11,"eq","","",88,null],[11,"partial_cmp","","",88,null],[11,"lt","","",88,null],[11,"le","","",88,null],[11,"gt","","",88,null],[11,"ge","","",88,null],[11,"cmp","","",88,null],[11,"from","","",88,{"inputs":[{"name":"t"}],"output":{"name":"refcell"}}],[11,"deref","","",89,null],[11,"clone","","Copies a `Ref`.",89,{"inputs":[{"name":"ref"}],"output":{"name":"ref"}}],[11,"map","","Make a new `Ref` for a component of the borrowed data.",89,{"inputs":[{"name":"ref"},{"name":"f"}],"output":{"name":"ref"}}],[11,"map","","Make a new `RefMut` for a component of the borrowed data, e.g. an enum\nvariant.",90,{"inputs":[{"name":"refmut"},{"name":"f"}],"output":{"name":"refmut"}}],[11,"deref","","",90,null],[11,"deref_mut","","",90,null],[11,"new","","Constructs a new instance of `UnsafeCell` which will wrap the specified\nvalue.",91,{"inputs":[{"name":"t"}],"output":{"name":"unsafecell"}}],[11,"into_inner","","Unwraps the value.",91,null],[11,"get","","Gets a mutable pointer to the wrapped value.",91,null],[11,"default","","Creates an `UnsafeCell`, with the `Default` value for T.",91,{"inputs":[],"output":{"name":"unsafecell"}}],[11,"from","","",91,{"inputs":[{"name":"t"}],"output":{"name":"unsafecell"}}],[0,"char","core","Character manipulation.",null,null],[3,"CharTryFromError","core::char","The error type returned when a conversion from u32 to char fails.",null,null],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode escape of a\ncharacter, as `char`s.",null,null],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"EscapeDebug","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"DecodeUtf8","","An iterator over an iterator of bytes of the characters the bytes represent\nas UTF-8",null,null],[3,"InvalidSequence","","`&lt;DecodeUtf8 as Iterator&gt;::next` returns this for an invalid input sequence.",null,null],[5,"from_u32","","Converts a `u32` to a `char`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"option"}}],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",null,{"inputs":[{"name":"u32"}],"output":{"name":"char"}}],[5,"from_digit","","Converts a digit in the given radix to a `char`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[5,"decode_utf8","","Decodes an `Iterator` of bytes as UTF-8.",null,{"inputs":[{"name":"i"}],"output":{"name":"decodeutf8"}}],[17,"MAX","","The highest valid code point a `char` can have.",null,null],[11,"clone","","",92,null],[11,"fmt","","",92,null],[11,"eq","","",92,null],[11,"ne","","",92,null],[11,"fmt","","",92,null],[11,"clone","","",93,null],[11,"fmt","","",93,null],[11,"next","","",93,null],[11,"size_hint","","",93,null],[11,"count","","",93,null],[11,"last","","",93,null],[11,"len","","",93,null],[11,"clone","","",94,null],[11,"fmt","","",94,null],[11,"next","","",94,null],[11,"size_hint","","",94,null],[11,"count","","",94,null],[11,"nth","","",94,null],[11,"last","","",94,null],[11,"len","","",94,null],[11,"clone","","",95,null],[11,"fmt","","",95,null],[11,"next","","",95,null],[11,"size_hint","","",95,null],[11,"clone","","",96,null],[11,"fmt","","",96,null],[11,"eq","","",97,null],[11,"ne","","",97,null],[11,"fmt","","",97,null],[11,"next","","",96,null],[0,"panicking","core","Panic support for libcore",null,null],[5,"panic","core::panicking","",null,null],[5,"panic_fmt","","",null,null],[0,"iter","core","Composable external iteration.",null,null],[3,"StepBy","core::iter","An adapter for stepping range iterators by a custom amount.",null,null],[3,"Repeat","","An iterator that repeats an element endlessly.",null,null],[3,"Empty","","An iterator that yields nothing.",null,null],[3,"Once","","An iterator that yields an element exactly once.",null,null],[3,"Rev","","An double-ended iterator with the direction inverted.",null,null],[3,"Cloned","","An iterator that clones the elements of an underlying iterator.",null,null],[3,"Cycle","","An iterator that repeats endlessly.",null,null],[3,"Chain","","An iterator that strings two iterators together.",null,null],[3,"Zip","","An iterator that iterates two other iterators simultaneously.",null,null],[3,"Map","","An iterator that maps the values of `iter` with `f`.",null,null],[3,"Filter","","An iterator that filters the elements of `iter` with `predicate`.",null,null],[3,"FilterMap","","An iterator that uses `f` to both filter and map elements from `iter`.",null,null],[3,"Enumerate","","An iterator that yields the current count and the element during iteration.",null,null],[3,"Peekable","","An iterator with a `peek()` that returns an optional reference to the next\nelement.",null,null],[3,"SkipWhile","","An iterator that rejects elements while `predicate` is true.",null,null],[3,"TakeWhile","","An iterator that only accepts elements while `predicate` is true.",null,null],[3,"Skip","","An iterator that skips over `n` elements of `iter`.",null,null],[3,"Take","","An iterator that only iterates over the first `n` iterations of `iter`.",null,null],[3,"Scan","","An iterator to maintain state while iterating another iterator.",null,null],[3,"FlatMap","","An iterator that maps each element to an iterator, and yields the elements\nof the produced iterators.",null,null],[3,"Fuse","","An iterator that yields `None` forever after the underlying iterator\nyields `None` once.",null,null],[3,"Inspect","","An iterator that calls a function with a reference to each element before\nyielding it.",null,null],[5,"repeat","","Creates a new iterator that endlessly repeats a single element.",null,{"inputs":[{"name":"t"}],"output":{"name":"repeat"}}],[5,"empty","","Creates an iterator that yields nothing.",null,{"inputs":[],"output":{"name":"empty"}}],[5,"once","","Creates an iterator that yields an element exactly once.",null,{"inputs":[{"name":"t"}],"output":{"name":"once"}}],[11,"clone","","",98,null],[11,"fmt","","",98,null],[11,"step_by","core::ops","Creates an iterator starting at the same point, but stepping by\nthe given amount at each iteration.",13,null],[11,"step_by","","Creates an iterator with the same range, but stepping by the\ngiven amount at each iteration.",12,null],[11,"step_by","","Creates an iterator with the same range, but stepping by the\ngiven amount at each iteration.",16,null],[11,"next","core::iter","",98,null],[11,"size_hint","","",98,null],[11,"next","","",98,null],[11,"size_hint","","",98,null],[11,"next","","",98,null],[11,"size_hint","","",98,null],[11,"next","core::ops","",12,null],[11,"size_hint","","",12,null],[11,"next_back","","",12,null],[11,"next","","",13,null],[11,"next","","",16,null],[11,"size_hint","","",16,null],[11,"next_back","","",16,null],[11,"clone","core::iter","",99,null],[11,"fmt","","",99,null],[11,"next","","",99,null],[11,"size_hint","","",99,null],[11,"next_back","","",99,null],[11,"fmt","","",100,null],[11,"next","","",100,null],[11,"size_hint","","",100,null],[11,"next_back","","",100,null],[11,"len","","",100,null],[11,"clone","","",100,null],[11,"default","","",100,{"inputs":[],"output":{"name":"empty"}}],[11,"clone","","",101,null],[11,"fmt","","",101,null],[11,"next","","",101,null],[11,"size_hint","","",101,null],[11,"next_back","","",101,null],[11,"len","","",101,null],[11,"sum","core::num","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",0,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[8,"Iterator","core::iter","An interface for dealing with iterators.",null,null],[16,"Item","","The type of the elements being iterated over.",102,null],[10,"next","","Advances the iterator and returns the next value.",102,null],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",102,null],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",102,null],[11,"last","","Consumes the iterator, returning the last element.",102,null],[11,"nth","","Returns the `n`th element of the iterator.",102,null],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",102,null],[11,"zip","","&#39;Zips up&#39; two iterators into a single iterator of pairs.",102,null],[11,"map","","Takes a closure and creates an iterator which calls that closure on each\nelement.",102,null],[11,"filter","","Creates an iterator which uses a closure to determine if an element\nshould be yielded.",102,null],[11,"filter_map","","Creates an iterator that both filters and maps.",102,null],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as\nthe next value.",102,null],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of\nthe iterator without consuming it.",102,null],[11,"skip_while","","Creates an iterator that [`skip()`]s elements based on a predicate.",102,null],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",102,null],[11,"skip","","Creates an iterator that skips the first `n` elements.",102,null],[11,"take","","Creates an iterator that yields its first `n` elements.",102,null],[11,"scan","","An iterator adaptor similar to [`fold()`] that holds internal state and\nproduces a new iterator.",102,null],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",102,null],[11,"fuse","","Creates an iterator which ends after the first [`None`].",102,null],[11,"inspect","","Do something with each element of an iterator, passing the value on.",102,null],[11,"by_ref","","Borrows an iterator, rather than consuming it.",102,null],[11,"collect","","Transforms an iterator into a collection.",102,null],[11,"partition","","Consumes an iterator, creating two collections from it.",102,null],[11,"fold","","An iterator adaptor that applies a function, producing a single, final value.",102,null],[11,"all","","Tests if every element of the iterator matches a predicate.",102,null],[11,"any","","Tests if any element of the iterator matches a predicate.",102,null],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",102,null],[11,"position","","Searches for an element in an iterator, returning its index.",102,null],[11,"rposition","","Searches for an element in an iterator from the right, returning its\nindex.",102,null],[11,"max","","Returns the maximum element of an iterator.",102,null],[11,"min","","Returns the minimum element of an iterator.",102,null],[11,"max_by_key","","Returns the element that gives the maximum value from the\nspecified function.",102,null],[11,"max_by","","Returns the element that gives the maximum value with respect to the\nspecified comparison function.",102,null],[11,"min_by_key","","Returns the element that gives the minimum value from the\nspecified function.",102,null],[11,"min_by","","Returns the element that gives the minimum value with respect to the\nspecified comparison function.",102,null],[11,"rev","","Reverses an iterator&#39;s direction.",102,null],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",102,null],[11,"cloned","","Creates an iterator which [`clone()`]s all of its elements.",102,null],[11,"cycle","","Repeats an iterator endlessly.",102,null],[11,"sum","","Sums the elements of an iterator.",102,null],[11,"product","","Iterates over the entire iterator, multiplying all the elements",102,null],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those\nof another.",102,null],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those\nof another.",102,null],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of\nanother.",102,null],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of\nanother.",102,null],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically\nless than those of another.",102,null],[11,"le","","Determines if the elements of this `Iterator` are lexicographically\nless or equal to those of another.",102,null],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically\ngreater than those of another.",102,null],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically\ngreater than or equal to those of another.",102,null],[8,"Step","","Objects that can be stepped over in both directions.",null,null],[10,"step","","Steps `self` if possible.",103,null],[10,"steps_between","","Returns the number of steps between two step objects. The count is\ninclusive of `start` and exclusive of `end`.",103,{"inputs":[{"name":"self"},{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[10,"steps_between_by_one","","Same as `steps_between`, but with a `by` of 1",103,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[10,"is_negative","","Tests whether this step is negative or not (going backwards)",103,null],[10,"replace_one","","Replaces this step with `1`, returning itself",103,null],[10,"replace_zero","","Replaces this step with `0`, returning itself",103,null],[10,"add_one","","Adds one to this step, returning the result",103,null],[10,"sub_one","","Subtracts one to this step, returning the result",103,null],[8,"FromIterator","","Conversion from an `Iterator`.",null,null],[10,"from_iter","","Creates a value from an iterator.",104,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"IntoIterator","","Conversion into an `Iterator`.",null,null],[16,"Item","","The type of the elements being iterated over.",105,null],[16,"IntoIter","","Which kind of iterator are we turning this into?",105,null],[10,"into_iter","","Creates an iterator from a value.",105,null],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",null,null],[10,"next_back","","Removes and returns an element from the end of the iterator.",106,null],[8,"Extend","","Extend a collection with the contents of an iterator.",null,null],[10,"extend","","Extends a collection with the contents of an iterator.",107,null],[8,"ExactSizeIterator","","An iterator that knows its exact length.",null,null],[11,"len","","Returns the exact number of times the iterator will iterate.",108,null],[11,"is_empty","","Returns whether the iterator is empty.",108,null],[8,"Sum","","Trait to represent types that can be created by summing up an iterator.",null,null],[10,"sum","","Method which takes an iterator and generates `Self` from the elements by\n&quot;summing up&quot; the items.",109,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[8,"Product","","Trait to represent types that can be created by multiplying elements of an\niterator.",null,null],[10,"product","","Method which takes an iterator and generates `Self` from the elements by\nmultiplying the items.",110,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[8,"FusedIterator","","An iterator that always continues to yield `None` when exhausted.",null,null],[8,"TrustedLen","","An iterator that reports an accurate length using size_hint.",null,null],[11,"clone","","",111,null],[11,"fmt","","",111,null],[11,"next","","",111,null],[11,"size_hint","","",111,null],[11,"next_back","","",111,null],[11,"len","","",111,null],[11,"is_empty","","",111,null],[11,"clone","","",112,null],[11,"fmt","","",112,null],[11,"next","","",112,null],[11,"size_hint","","",112,null],[11,"fold","","",112,null],[11,"next_back","","",112,null],[11,"len","","",112,null],[11,"is_empty","","",112,null],[11,"clone","","",113,null],[11,"fmt","","",113,null],[11,"next","","",113,null],[11,"size_hint","","",113,null],[11,"clone","","",114,null],[11,"fmt","","",114,null],[11,"next","","",114,null],[11,"count","","",114,null],[11,"fold","","",114,null],[11,"nth","","",114,null],[11,"find","","",114,null],[11,"last","","",114,null],[11,"size_hint","","",114,null],[11,"next_back","","",114,null],[11,"clone","","",115,null],[11,"fmt","","",115,null],[11,"next","","",115,null],[11,"size_hint","","",115,null],[11,"next_back","","",115,null],[11,"clone","","",116,null],[11,"fmt","","",116,null],[11,"next","","",116,null],[11,"size_hint","","",116,null],[11,"fold","","",116,null],[11,"next_back","","",116,null],[11,"len","","",116,null],[11,"is_empty","","",116,null],[11,"clone","","",117,null],[11,"fmt","","",117,null],[11,"next","","",117,null],[11,"size_hint","","",117,null],[11,"next_back","","",117,null],[11,"clone","","",118,null],[11,"fmt","","",118,null],[11,"next","","",118,null],[11,"size_hint","","",118,null],[11,"next_back","","",118,null],[11,"clone","","",119,null],[11,"fmt","","",119,null],[11,"next","","# Overflow Behavior",119,null],[11,"size_hint","","",119,null],[11,"nth","","",119,null],[11,"count","","",119,null],[11,"next_back","","",119,null],[11,"len","","",119,null],[11,"is_empty","","",119,null],[11,"clone","","",120,null],[11,"fmt","","",120,null],[11,"next","","",120,null],[11,"count","","",120,null],[11,"nth","","",120,null],[11,"last","","",120,null],[11,"size_hint","","",120,null],[11,"peek","","Returns a reference to the next() value without advancing the iterator.",120,null],[11,"clone","","",121,null],[11,"fmt","","",121,null],[11,"next","","",121,null],[11,"size_hint","","",121,null],[11,"clone","","",122,null],[11,"fmt","","",122,null],[11,"next","","",122,null],[11,"size_hint","","",122,null],[11,"clone","","",123,null],[11,"fmt","","",123,null],[11,"next","","",123,null],[11,"nth","","",123,null],[11,"count","","",123,null],[11,"last","","",123,null],[11,"size_hint","","",123,null],[11,"next_back","","",123,null],[11,"clone","","",124,null],[11,"fmt","","",124,null],[11,"next","","",124,null],[11,"nth","","",124,null],[11,"size_hint","","",124,null],[11,"clone","","",125,null],[11,"fmt","","",125,null],[11,"next","","",125,null],[11,"size_hint","","",125,null],[11,"clone","","",126,null],[11,"fmt","","",126,null],[11,"next","","",126,null],[11,"size_hint","","",126,null],[11,"next_back","","",126,null],[11,"clone","","",127,null],[11,"fmt","","",127,null],[11,"next","","",127,null],[11,"nth","","",127,null],[11,"last","","",127,null],[11,"count","","",127,null],[11,"size_hint","","",127,null],[11,"next_back","","",127,null],[11,"next","","",127,null],[11,"nth","","",127,null],[11,"last","","",127,null],[11,"count","","",127,null],[11,"size_hint","","",127,null],[11,"next_back","","",127,null],[11,"len","","",127,null],[11,"is_empty","","",127,null],[11,"clone","","",128,null],[11,"fmt","","",128,null],[11,"next","","",128,null],[11,"size_hint","","",128,null],[11,"next_back","","",128,null],[11,"len","","",128,null],[11,"is_empty","","",128,null],[0,"option","core","Optional values.",null,null],[3,"Iter","core::option","An iterator over a reference of the contained item in an [`Option`].",null,null],[3,"IterMut","","An iterator over a mutable reference of the contained item in an [`Option`].",null,null],[3,"IntoIter","","An iterator over the item contained inside an [`Option`].",null,null],[4,"Option","","The `Option` type. See [the module level documentation](index.html) for more.",null,null],[13,"None","","No value",129,null],[13,"Some","","Some value `T`",129,null],[11,"clone","","",129,null],[11,"eq","","",129,null],[11,"ne","","",129,null],[11,"partial_cmp","","",129,null],[11,"lt","","",129,null],[11,"le","","",129,null],[11,"gt","","",129,null],[11,"ge","","",129,null],[11,"cmp","","",129,null],[11,"fmt","","",129,null],[11,"hash","","",129,null],[11,"is_some","","Returns `true` if the option is a `Some` value.",129,null],[11,"is_none","","Returns `true` if the option is a `None` value.",129,null],[11,"as_ref","","Converts from `Option&lt;T&gt;` to `Option&lt;&amp;T&gt;`.",129,null],[11,"as_mut","","Converts from `Option&lt;T&gt;` to `Option&lt;&amp;mut T&gt;`.",129,null],[11,"expect","","Unwraps an option, yielding the content of a `Some`.",129,null],[11,"unwrap","","Moves the value `v` out of the `Option&lt;T&gt;` if it is `Some(v)`.",129,null],[11,"unwrap_or","","Returns the contained value or a default.",129,null],[11,"unwrap_or_else","","Returns the contained value or computes it from a closure.",129,null],[11,"map","","Maps an `Option&lt;T&gt;` to `Option&lt;U&gt;` by applying a function to a contained value.",129,null],[11,"map_or","","Applies a function to the contained value (if any),\nor returns a `default` (if not).",129,null],[11,"map_or_else","","Applies a function to the contained value (if any),\nor computes a `default` (if not).",129,null],[11,"ok_or","","Transforms the `Option&lt;T&gt;` into a [`Result&lt;T, E&gt;`], mapping `Some(v)` to\n[`Ok(v)`] and `None` to [`Err(err)`][Err].",129,null],[11,"ok_or_else","","Transforms the `Option&lt;T&gt;` into a [`Result&lt;T, E&gt;`], mapping `Some(v)` to\n[`Ok(v)`] and `None` to [`Err(err())`][Err].",129,null],[11,"iter","","Returns an iterator over the possibly contained value.",129,null],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",129,null],[11,"and","","Returns `None` if the option is `None`, otherwise returns `optb`.",129,null],[11,"and_then","","Returns `None` if the option is `None`, otherwise calls `f` with the\nwrapped value and returns the result.",129,null],[11,"or","","Returns the option if it contains a value, otherwise returns `optb`.",129,null],[11,"or_else","","Returns the option if it contains a value, otherwise calls `f` and\nreturns the result.",129,null],[11,"take","","Takes the value out of the option, leaving a `None` in its place.",129,null],[11,"cloned","","Maps an `Option&lt;&amp;T&gt;` to an `Option&lt;T&gt;` by cloning the contents of the\noption.",129,null],[11,"unwrap_or_default","","Returns the contained value or a default",129,null],[11,"default","","Returns None.",129,{"inputs":[],"output":{"name":"option"}}],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",129,null],[11,"from","","",129,{"inputs":[{"name":"t"}],"output":{"name":"option"}}],[11,"fmt","","",130,null],[11,"next","","",130,null],[11,"size_hint","","",130,null],[11,"next_back","","",130,null],[11,"clone","","",130,null],[11,"fmt","","",131,null],[11,"next","","",131,null],[11,"size_hint","","",131,null],[11,"next_back","","",131,null],[11,"clone","","",132,null],[11,"fmt","","",132,null],[11,"next","","",132,null],[11,"size_hint","","",132,null],[11,"next_back","","",132,null],[11,"from_iter","","Takes each element in the `Iterator`: if it is `None`, no further\nelements are taken, and the `None` is returned. Should no `None` occur, a\ncontainer with the values of each `Option` is returned.",129,{"inputs":[{"name":"i"}],"output":{"name":"option"}}],[0,"raw","core","Contains struct definitions for the layout of compiler built-in types.",null,null],[3,"TraitObject","core::raw","The representation of a trait object like `&amp;SomeTrait`.",null,null],[12,"data","","",133,null],[12,"vtable","","",133,null],[11,"clone","","",133,null],[0,"result","core","Error handling with the `Result` type.",null,null],[3,"Iter","core::result","An iterator over a reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IntoIter","","An iterator over the value in a [`Ok`] variant of a [`Result`]. This struct is\ncreated by the [`into_iter`] method on [`Result`][`Result`] (provided by\nthe [`IntoIterator`] trait).",null,null],[4,"Result","","`Result` is a type that represents either success (`Ok`) or failure (`Err`).",null,null],[13,"Ok","","Contains the success value",134,null],[13,"Err","","Contains the error value",134,null],[11,"clone","","",134,null],[11,"eq","","",134,null],[11,"ne","","",134,null],[11,"partial_cmp","","",134,null],[11,"lt","","",134,null],[11,"le","","",134,null],[11,"gt","","",134,null],[11,"ge","","",134,null],[11,"cmp","","",134,null],[11,"fmt","","",134,null],[11,"hash","","",134,null],[11,"is_ok","","Returns true if the result is `Ok`.",134,null],[11,"is_err","","Returns true if the result is `Err`.",134,null],[11,"ok","","Converts from `Result&lt;T, E&gt;` to [`Option&lt;T&gt;`].",134,null],[11,"err","","Converts from `Result&lt;T, E&gt;` to [`Option&lt;E&gt;`].",134,null],[11,"as_ref","","Converts from `Result&lt;T, E&gt;` to `Result&lt;&amp;T, &amp;E&gt;`.",134,null],[11,"as_mut","","Converts from `Result&lt;T, E&gt;` to `Result&lt;&amp;mut T, &amp;mut E&gt;`.",134,null],[11,"map","","Maps a `Result&lt;T, E&gt;` to `Result&lt;U, E&gt;` by applying a function to a\ncontained `Ok` value, leaving an `Err` value untouched.",134,null],[11,"map_err","","Maps a `Result&lt;T, E&gt;` to `Result&lt;T, F&gt;` by applying a function to a\ncontained `Err` value, leaving an `Ok` value untouched.",134,null],[11,"iter","","Returns an iterator over the possibly contained value.",134,null],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",134,null],[11,"and","","Returns `res` if the result is `Ok`, otherwise returns the `Err` value of `self`.",134,null],[11,"and_then","","Calls `op` if the result is `Ok`, otherwise returns the `Err` value of `self`.",134,null],[11,"or","","Returns `res` if the result is `Err`, otherwise returns the `Ok` value of `self`.",134,null],[11,"or_else","","Calls `op` if the result is `Err`, otherwise returns the `Ok` value of `self`.",134,null],[11,"unwrap_or","","Unwraps a result, yielding the content of an `Ok`.\nElse, it returns `optb`.",134,null],[11,"unwrap_or_else","","Unwraps a result, yielding the content of an `Ok`.\nIf the value is an `Err` then it calls `op` with its value.",134,null],[11,"unwrap","","Unwraps a result, yielding the content of an `Ok`.",134,null],[11,"expect","","Unwraps a result, yielding the content of an `Ok`.",134,null],[11,"unwrap_err","","Unwraps a result, yielding the content of an `Err`.",134,null],[11,"unwrap_or_default","","Returns the contained value or a default",134,null],[11,"into_iter","","Returns a consuming iterator over the possibly contained value.",134,null],[11,"fmt","","",135,null],[11,"next","","",135,null],[11,"size_hint","","",135,null],[11,"next_back","","",135,null],[11,"clone","","",135,null],[11,"fmt","","",136,null],[11,"next","","",136,null],[11,"size_hint","","",136,null],[11,"next_back","","",136,null],[11,"fmt","","",137,null],[11,"next","","",137,null],[11,"size_hint","","",137,null],[11,"next_back","","",137,null],[11,"from_iter","","Takes each element in the `Iterator`: if it is an `Err`, no further\nelements are taken, and the `Err` is returned. Should no `Err` occur, a\ncontainer with the values of each `Result` is returned.",134,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[0,"slice","core","Slice management and manipulation",null,null],[3,"Iter","core::slice","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"Split","","An iterator over subslices separated by elements that match a predicate\nfunction.",null,null],[3,"SplitMut","","An iterator over the subslices of the vector which are separated\nby elements that match `pred`.",null,null],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate\nfunction, limited to a given number of splits.",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that match a\npredicate function, limited to a given number of splits, starting\nfrom the end of the slice.",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate\nfunction, limited to a given number of splits.",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a\npredicate function, limited to a given number of splits, starting\nfrom the end of the slice.",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks (`size` elements at a\ntime).",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`size`\nelements at a time). When the slice len is not evenly divided by the chunk\nsize, the last slice of the iteration will be the remainder.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable\nslice is returned.",null,null],[8,"SliceExt","","Extension methods for slices.",null,null],[16,"Item","","",138,null],[10,"split_at","","",138,null],[10,"iter","","",138,null],[10,"split","","",138,null],[10,"splitn","","",138,null],[10,"rsplitn","","",138,null],[10,"windows","","",138,null],[10,"chunks","","",138,null],[10,"get","","",138,null],[10,"first","","",138,null],[10,"split_first","","",138,null],[10,"split_last","","",138,null],[10,"last","","",138,null],[10,"get_unchecked","","",138,null],[10,"as_ptr","","",138,null],[10,"binary_search","","",138,null],[10,"binary_search_by","","",138,null],[10,"binary_search_by_key","","",138,null],[10,"len","","",138,null],[11,"is_empty","","",138,null],[10,"get_mut","","",138,null],[10,"iter_mut","","",138,null],[10,"first_mut","","",138,null],[10,"split_first_mut","","",138,null],[10,"split_last_mut","","",138,null],[10,"last_mut","","",138,null],[10,"split_mut","","",138,null],[10,"splitn_mut","","",138,null],[10,"rsplitn_mut","","",138,null],[10,"chunks_mut","","",138,null],[10,"swap","","",138,null],[10,"split_at_mut","","",138,null],[10,"reverse","","",138,null],[10,"get_unchecked_mut","","",138,null],[10,"as_mut_ptr","","",138,null],[10,"contains","","",138,null],[10,"starts_with","","",138,null],[10,"ends_with","","",138,null],[10,"clone_from_slice","","",138,null],[10,"copy_from_slice","","",138,null],[8,"SliceIndex","","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",139,null],[10,"get","","Returns a shared reference to the output at this location, if in\nbounds.",139,null],[10,"get_mut","","Returns a mutable reference to the output at this location, if in\nbounds.",139,null],[10,"get_unchecked","","Returns a shared reference to the output at this location, without\nperforming any bounds checking.",139,null],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without\nperforming any bounds checking.",139,null],[10,"index","","Returns a shared reference to the output at this location, panicking\nif out of bounds.",139,null],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking\nif out of bounds.",139,null],[11,"get","core::ops","",12,null],[11,"get_mut","","",12,null],[11,"get_unchecked","","",12,null],[11,"get_unchecked_mut","","",12,null],[11,"index","","",12,null],[11,"index_mut","","",12,null],[11,"get","","",14,null],[11,"get_mut","","",14,null],[11,"get_unchecked","","",14,null],[11,"get_unchecked_mut","","",14,null],[11,"index","","",14,null],[11,"index_mut","","",14,null],[11,"get","","",13,null],[11,"get_mut","","",13,null],[11,"get_unchecked","","",13,null],[11,"get_unchecked_mut","","",13,null],[11,"index","","",13,null],[11,"index_mut","","",13,null],[11,"get","","",53,null],[11,"get_mut","","",53,null],[11,"get_unchecked","","",53,null],[11,"get_unchecked_mut","","",53,null],[11,"index","","",53,null],[11,"index_mut","","",53,null],[11,"get","","",16,null],[11,"get_mut","","",16,null],[11,"get_unchecked","","",16,null],[11,"get_unchecked_mut","","",16,null],[11,"index","","",16,null],[11,"index_mut","","",16,null],[11,"get","","",15,null],[11,"get_mut","","",15,null],[11,"get_unchecked","","",15,null],[11,"get_unchecked_mut","","",15,null],[11,"index","","",15,null],[11,"index_mut","","",15,null],[11,"fmt","core::slice","",140,null],[11,"as_slice","","View the underlying data as a subslice of the original data.",140,null],[11,"next","","",140,null],[11,"size_hint","","",140,null],[11,"count","","",140,null],[11,"nth","","",140,null],[11,"last","","",140,null],[11,"next_back","","",140,null],[11,"is_empty","","",140,null],[11,"clone","","",140,null],[11,"as_ref","","",140,null],[11,"fmt","","",141,null],[11,"into_slice","","View the underlying data as a subslice of the original data.",141,null],[11,"next","","",141,null],[11,"size_hint","","",141,null],[11,"count","","",141,null],[11,"nth","","",141,null],[11,"last","","",141,null],[11,"next_back","","",141,null],[11,"is_empty","","",141,null],[11,"fmt","","",142,null],[11,"clone","","",142,null],[11,"next","","",142,null],[11,"size_hint","","",142,null],[11,"next_back","","",142,null],[11,"fmt","","",143,null],[11,"next","","",143,null],[11,"size_hint","","",143,null],[11,"next_back","","",143,null],[11,"fmt","","",144,null],[11,"fmt","","",145,null],[11,"fmt","","",146,null],[11,"fmt","","",147,null],[11,"next","","",144,null],[11,"size_hint","","",144,null],[11,"next","","",145,null],[11,"size_hint","","",145,null],[11,"next","","",146,null],[11,"size_hint","","",146,null],[11,"next","","",147,null],[11,"size_hint","","",147,null],[11,"fmt","","",148,null],[11,"clone","","",148,null],[11,"next","","",148,null],[11,"size_hint","","",148,null],[11,"count","","",148,null],[11,"nth","","",148,null],[11,"last","","",148,null],[11,"next_back","","",148,null],[11,"fmt","","",149,null],[11,"clone","","",149,null],[11,"next","","",149,null],[11,"size_hint","","",149,null],[11,"count","","",149,null],[11,"nth","","",149,null],[11,"last","","",149,null],[11,"next_back","","",149,null],[11,"fmt","","",150,null],[11,"next","","",150,null],[11,"size_hint","","",150,null],[11,"count","","",150,null],[11,"nth","","",150,null],[11,"last","","",150,null],[11,"next_back","","",150,null],[0,"str","core","String manipulation",null,null],[3,"ParseBoolError","core::str","An error returned when parsing a `bool` from a string fails.",null,null],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of `u8`\nas a string.",null,null],[3,"Chars","","Iterator for the char (representing *Unicode Scalar Values*) of a string",null,null],[3,"CharIndices","","Iterator for a string&#39;s characters and their byte offsets.",null,null],[3,"Bytes","","External iterator for a string&#39;s bytes.\nUse with the `std::iter` module.",null,null],[3,"Split","","Created with the method [`split()`].",null,null],[3,"RSplit","","Created with the method [`rsplit()`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator()`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator()`].",null,null],[3,"SplitN","","Created with the method [`splitn()`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn()`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices()`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices()`].",null,null],[3,"Matches","","Created with the method [`matches()`].",null,null],[3,"RMatches","","Created with the method [`rmatches()`].",null,null],[3,"Lines","","Created with the method [`lines()`].",null,null],[3,"LinesAny","","Created with the method [`lines_any()`].",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking\nthat the string contains valid UTF-8.",null,null],[5,"next_code_point","","Reads the next code point out of a byte iterator (assuming a\nUTF-8-like encoding).",null,{"inputs":[{"name":"i"}],"output":{"name":"option"}}],[0,"pattern","","The string Pattern API.",null,null],[3,"CharSearcher","core::str::pattern","Associated type for `&lt;char as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `&lt;&amp;[char] as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `&lt;F as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `&lt;&amp;str as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at\n`haystack[a..b]`.",151,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match\nof the pattern.",151,null],[13,"Done","","Expresses that every byte of the haystack has been visted, ending\nthe iteration.",151,null],[8,"Pattern","","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",152,null],[10,"into_searcher","","Constructs the associated searcher from\n`self` and the `haystack` to search in.",152,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",152,null],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",152,null],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",152,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlaying string to be searched in",153,null],[10,"next","","Performs the next search step starting from the front.",153,null],[11,"next_match","","Find the next `Match` result. See `next()`",153,null],[11,"next_reject","","Find the next `Reject` result. See `next()`",153,null],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",154,null],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",154,null],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",154,null],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher`\ncan be used for a `DoubleEndedIterator` implementation.",null,null],[11,"clone","","",151,null],[11,"eq","","",151,null],[11,"ne","","",151,null],[11,"fmt","","",151,null],[11,"clone","","",155,null],[11,"fmt","","",155,null],[11,"haystack","","",155,null],[11,"next","","",155,null],[11,"next_match","","",155,null],[11,"next_reject","","",155,null],[11,"next_back","","",155,null],[11,"next_match_back","","",155,null],[11,"next_reject_back","","",155,null],[11,"clone","","",156,null],[11,"fmt","","",156,null],[11,"haystack","","",156,null],[11,"next","","",156,null],[11,"next_match","","",156,null],[11,"next_reject","","",156,null],[11,"next_back","","",156,null],[11,"next_match_back","","",156,null],[11,"next_reject_back","","",156,null],[11,"clone","","",157,null],[11,"fmt","","",157,null],[11,"haystack","","",157,null],[11,"next","","",157,null],[11,"next_match","","",157,null],[11,"next_reject","","",157,null],[11,"next_back","","",157,null],[11,"next_match_back","","",157,null],[11,"next_reject_back","","",157,null],[11,"clone","","",158,null],[11,"fmt","","",158,null],[11,"haystack","","",158,null],[11,"next","","",158,null],[11,"next_match","","",158,null],[11,"next_back","","",158,null],[11,"next_match_back","","",158,null],[8,"FromStr","core::str","A trait to abstract the idea of creating a new instance of a type from a\nstring.",null,null],[16,"Err","","The associated error which can be returned from parsing.",159,null],[10,"from_str","","Parses a string `s` to return a value of this type.",159,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"fmt","","",160,null],[11,"clone","","",160,null],[11,"eq","","",160,null],[11,"ne","","",160,null],[11,"fmt","","",160,null],[11,"eq","","",161,null],[11,"ne","","",161,null],[11,"clone","","",161,null],[11,"fmt","","",161,null],[11,"valid_up_to","","Returns the index in the given string up to which valid UTF-8 was\nverified.",161,null],[11,"fmt","","",161,null],[11,"clone","","",162,null],[11,"fmt","","",162,null],[11,"next","","",162,null],[11,"count","","",162,null],[11,"size_hint","","",162,null],[11,"last","","",162,null],[11,"next_back","","",162,null],[11,"as_str","","View the underlying data as a subslice of the original data.",162,null],[11,"clone","","",163,null],[11,"fmt","","",163,null],[11,"next","","",163,null],[11,"count","","",163,null],[11,"size_hint","","",163,null],[11,"last","","",163,null],[11,"next_back","","",163,null],[11,"as_str","","View the underlying data as a subslice of the original data.",163,null],[11,"clone","","",164,null],[11,"fmt","","",164,null],[11,"next","","",164,null],[11,"size_hint","","",164,null],[11,"count","","",164,null],[11,"last","","",164,null],[11,"nth","","",164,null],[11,"next_back","","",164,null],[11,"len","","",164,null],[11,"is_empty","","",164,null],[11,"fmt","","",165,null],[11,"next","","",165,null],[11,"clone","","",165,null],[11,"fmt","","",166,null],[11,"next","","",166,null],[11,"clone","","",166,null],[11,"next_back","","",165,null],[11,"next_back","","",166,null],[11,"fmt","","",167,null],[11,"next","","",167,null],[11,"clone","","",167,null],[11,"fmt","","",168,null],[11,"next","","",168,null],[11,"clone","","",168,null],[11,"next_back","","",167,null],[11,"next_back","","",168,null],[11,"fmt","","",169,null],[11,"next","","",169,null],[11,"clone","","",169,null],[11,"fmt","","",170,null],[11,"next","","",170,null],[11,"clone","","",170,null],[11,"fmt","","",171,null],[11,"next","","",171,null],[11,"clone","","",171,null],[11,"fmt","","",172,null],[11,"next","","",172,null],[11,"clone","","",172,null],[11,"next_back","","",171,null],[11,"next_back","","",172,null],[11,"fmt","","",173,null],[11,"next","","",173,null],[11,"clone","","",173,null],[11,"fmt","","",174,null],[11,"next","","",174,null],[11,"clone","","",174,null],[11,"next_back","","",173,null],[11,"next_back","","",174,null],[11,"clone","","",175,null],[11,"fmt","","",175,null],[11,"next","","",175,null],[11,"size_hint","","",175,null],[11,"next_back","","",175,null],[11,"clone","","",176,null],[11,"fmt","","",176,null],[11,"next","","",176,null],[11,"size_hint","","",176,null],[11,"next_back","","",176,null],[0,"hash","core","Generic hashing support.",null,null],[3,"SipHasher","core::hash","An implementation of SipHash 2-4.",null,null],[3,"SipHasher13","","An implementation of SipHash 1-3.",null,null],[3,"SipHasher24","","An implementation of SipHash 2-4.",null,null],[3,"BuildHasherDefault","","The `BuildHasherDefault` structure is used in scenarios where one has a\ntype that implements [`Hasher`] and [`Default`], but needs that type to\nimplement [`BuildHasher`].",null,null],[11,"fmt","","",177,null],[11,"clone","","",177,null],[11,"default","","",177,{"inputs":[],"output":{"name":"siphasher13"}}],[11,"fmt","","",178,null],[11,"clone","","",178,null],[11,"default","","",178,{"inputs":[],"output":{"name":"siphasher24"}}],[11,"fmt","","",179,null],[11,"clone","","",179,null],[11,"default","","",179,{"inputs":[],"output":{"name":"siphasher"}}],[11,"new","","Creates a new `SipHasher` with the two initial keys set to 0.",179,{"inputs":[],"output":{"name":"siphasher"}}],[11,"new_with_keys","","Creates a `SipHasher` that is keyed off the provided keys.",179,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"siphasher"}}],[11,"new","","Creates a new `SipHasher13` with the two initial keys set to 0.",177,{"inputs":[],"output":{"name":"siphasher13"}}],[11,"new_with_keys","","Creates a `SipHasher13` that is keyed off the provided keys.",177,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"siphasher13"}}],[11,"new","","Creates a new `SipHasher24` with the two initial keys set to 0.",178,{"inputs":[],"output":{"name":"siphasher24"}}],[11,"new_with_keys","","Creates a `SipHasher24` that is keyed off the provided keys.",178,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"siphasher24"}}],[11,"write","","",179,null],[11,"finish","","",179,null],[11,"write","","",177,null],[11,"finish","","",177,null],[11,"write","","",178,null],[11,"finish","","",178,null],[8,"Hash","","A hashable type.",null,null],[10,"hash","","Feeds this value into the state given, updating the hasher as necessary.",180,null],[11,"hash_slice","","Feeds a slice of this type into the state provided.",180,null],[8,"Hasher","","A trait which represents the ability to hash an arbitrary stream of bytes.",null,null],[10,"finish","","Completes a round of hashing, producing the output hash generated.",181,null],[10,"write","","Writes some data into this `Hasher`.",181,null],[11,"write_u8","","Write a single `u8` into this hasher.",181,null],[11,"write_u16","","Writes a single `u16` into this hasher.",181,null],[11,"write_u32","","Writes a single `u32` into this hasher.",181,null],[11,"write_u64","","Writes a single `u64` into this hasher.",181,null],[11,"write_usize","","Writes a single `usize` into this hasher.",181,null],[11,"write_i8","","Writes a single `i8` into this hasher.",181,null],[11,"write_i16","","Writes a single `i16` into this hasher.",181,null],[11,"write_i32","","Writes a single `i32` into this hasher.",181,null],[11,"write_i64","","Writes a single `i64` into this hasher.",181,null],[11,"write_isize","","Writes a single `isize` into this hasher.",181,null],[8,"BuildHasher","","A `BuildHasher` is typically used as a factory for instances of `Hasher`\nwhich a `HashMap` can then use to hash keys independently.",null,null],[16,"Hasher","","Type of the hasher that will be created.",182,null],[10,"build_hasher","","Creates a new hasher.",182,null],[11,"fmt","","",183,null],[11,"build_hasher","","",183,null],[11,"clone","","",183,null],[11,"default","","",183,{"inputs":[],"output":{"name":"buildhasherdefault"}}],[0,"fmt","core","Utilities for formatting and printing strings.",null,null],[3,"DebugStruct","core::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"Error","","The error type which is returned from formatting a message into a stream.",null,null],[3,"Formatter","","A struct to represent both where to emit formatting strings to and how they\nshould be formatted. A mutable version of this is passed to all formatting\ntraits.",null,null],[3,"Arguments","","This structure represents a safely precompiled version of a format string\nand its arguments. This cannot be generated at runtime because it cannot\nsafely be done so, so no constructors are given and the fields are private\nto prevent modification.",null,null],[4,"Alignment","","Possible alignments returned by `Formatter::align`",null,null],[13,"Left","","Indication that contents should be left-aligned.",184,null],[13,"Right","","Indication that contents should be right-aligned.",184,null],[13,"Center","","Indication that contents should be center-aligned.",184,null],[13,"Unknown","","No alignment was requested.",184,null],[5,"write","","The `write` function takes an output stream, a precompiled format string,\nand a list of arguments. The arguments will be formatted according to the\nspecified format string into the output stream provided.",null,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[11,"field","","Adds a new field to the generated struct output.",185,null],[11,"finish","","Finishes output and returns any error encountered.",185,null],[11,"field","","Adds a new field to the generated tuple struct output.",186,null],[11,"finish","","Finishes output and returns any error encountered.",186,null],[11,"entry","","Adds a new entry to the set output.",187,null],[11,"entries","","Adds the contents of an iterator of entries to the set output.",187,null],[11,"finish","","Finishes output and returns any error encountered.",187,null],[11,"entry","","Adds a new entry to the list output.",188,null],[11,"entries","","Adds the contents of an iterator of entries to the list output.",188,null],[11,"finish","","Finishes output and returns any error encountered.",188,null],[11,"entry","","Adds a new entry to the map output.",189,null],[11,"entries","","Adds the contents of an iterator of entries to the map output.",189,null],[11,"finish","","Finishes output and returns any error encountered.",189,null],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write\nsucceeded.",190,null],[11,"write_char","","Writes a `char` into this writer, returning whether the write succeeded.",190,null],[11,"write_fmt","","Glue for usage of the `write!` macro with implementors of this trait.",190,null],[8,"Debug","","Format trait for the `?` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",191,null],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",192,null],[8,"Octal","","Format trait for the `o` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",193,null],[8,"Binary","","Format trait for the `b` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",194,null],[8,"LowerHex","","Format trait for the `x` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",195,null],[8,"UpperHex","","Format trait for the `X` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",196,null],[8,"Pointer","","Format trait for the `p` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",197,null],[8,"LowerExp","","Format trait for the `e` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",198,null],[8,"UpperExp","","Format trait for the `E` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",199,null],[11,"fmt","","",184,null],[11,"clone","","",200,null],[11,"fmt","","",200,null],[11,"default","","",200,{"inputs":[],"output":{"name":"error"}}],[11,"hash","","",200,null],[11,"cmp","","",200,null],[11,"eq","","",200,null],[11,"partial_cmp","","",200,null],[11,"clone","","",201,null],[11,"fmt","","",201,null],[11,"fmt","","",201,null],[11,"pad_integral","","Performs the correct padding for an integer which has already been\nemitted into a str. The str should *not* contain the sign for the\ninteger, that will be added by this method.",202,null],[11,"pad","","This function takes a string slice and emits it to the internal buffer\nafter applying the relevant formatting flags specified. The flags\nrecognized for generic strings are:",202,null],[11,"write_str","","Writes some data to the underlying buffer contained within this\nformatter.",202,null],[11,"write_fmt","","Writes some formatted information into this instance",202,null],[11,"flags","","Flags for formatting (packed version of rt::Flag)",202,null],[11,"fill","","Character used as &#39;fill&#39; whenever there is alignment",202,null],[11,"align","","Flag indicating what form of alignment was requested",202,null],[11,"width","","Optionally specified integer width that the output should be",202,null],[11,"precision","","Optionally specified precision for numeric types",202,null],[11,"sign_plus","","Determines if the `+` flag was specified.",202,null],[11,"sign_minus","","Determines if the `-` flag was specified.",202,null],[11,"alternate","","Determines if the `#` flag was specified.",202,null],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",202,null],[11,"debug_struct","","Creates a `DebugStruct` builder designed to assist with creation of\n`fmt::Debug` implementations for structs.",202,null],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of\n`fmt::Debug` implementations for tuple structs.",202,null],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of\n`fmt::Debug` implementations for list-like structures.",202,null],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of\n`fmt::Debug` implementations for set-like structures.",202,null],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of\n`fmt::Debug` implementations for map-like structures.",202,null],[11,"write_str","","",202,null],[11,"write_char","","",202,null],[11,"write_fmt","","",202,null],[11,"fmt","","",200,null],[11,"fmt","core::marker","",11,null],[11,"fmt","core::cell","",85,null],[11,"fmt","","",88,null],[11,"fmt","","",89,null],[11,"fmt","","",90,null],[11,"fmt","","",91,null],[14,"panic","core","Entry point of thread panic, for details, see std::macros",null,null],[14,"assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"assert_eq","","Asserts that two expressions are equal to each other.",null,null],[14,"assert_ne","","Asserts that two expressions are not equal to each other.",null,null],[14,"debug_assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"debug_assert_eq","","Asserts that two expressions are equal to each other.",null,null],[14,"debug_assert_ne","","Asserts that two expressions are not equal to each other.",null,null],[14,"try","","Helper macro for reducing boilerplate code for matching `Result` together\nwith converting downstream errors.",null,null],[14,"write","","Write formatted data into a buffer",null,null],[14,"writeln","","Write formatted data into a buffer, with a newline appended.",null,null],[14,"unreachable","","A utility macro for indicating unreachable code.",null,null],[14,"unimplemented","","A standardized placeholder for marking unfinished code. It panics with the\nmessage `&quot;not yet implemented&quot;` when executed.",null,null],[14,"format_args","","The core macro for formatted string creation &amp; output.",null,null],[14,"env","","Inspect an environment variable at compile time.",null,null],[14,"option_env","","Optionally inspect an environment variable at compile time.",null,null],[14,"concat_idents","","Concatenate identifiers into one identifier.",null,null],[14,"concat","","Concatenates literals into a static string slice.",null,null],[14,"line","","A macro which expands to the line number on which it was invoked.",null,null],[14,"column","","A macro which expands to the column number on which it was invoked.",null,null],[14,"file","","A macro which expands to the file name from which it was invoked.",null,null],[14,"stringify","","A macro which stringifies its argument.",null,null],[14,"include_str","","Includes a utf8-encoded file as a string.",null,null],[14,"include_bytes","","Includes a file as a reference to a byte array.",null,null],[14,"module_path","","Expands to a string that represents the current module path.",null,null],[14,"cfg","","Boolean evaluation of configuration flags.",null,null],[14,"include","","Parse a file as an expression or an item according to the context.",null,null],[11,"from_success","core::result","",134,{"inputs":[{"name":"u"}],"output":{"name":"result"}}],[11,"from_error","","",134,{"inputs":[{"name":"v"}],"output":{"name":"result"}}],[11,"translate","","",134,null],[11,"size_hint","core::iter","Returns the bounds on the remaining length of the iterator.",102,null],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",102,null],[11,"last","","Consumes the iterator, returning the last element.",102,null],[11,"nth","","Returns the `n`th element of the iterator.",102,null],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",102,null],[11,"zip","","&#39;Zips up&#39; two iterators into a single iterator of pairs.",102,null],[11,"map","","Takes a closure and creates an iterator which calls that closure on each\nelement.",102,null],[11,"filter","","Creates an iterator which uses a closure to determine if an element\nshould be yielded.",102,null],[11,"filter_map","","Creates an iterator that both filters and maps.",102,null],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as\nthe next value.",102,null],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of\nthe iterator without consuming it.",102,null],[11,"skip_while","","Creates an iterator that [`skip()`]s elements based on a predicate.",102,null],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",102,null],[11,"skip","","Creates an iterator that skips the first `n` elements.",102,null],[11,"take","","Creates an iterator that yields its first `n` elements.",102,null],[11,"scan","","An iterator adaptor similar to [`fold()`] that holds internal state and\nproduces a new iterator.",102,null],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",102,null],[11,"fuse","","Creates an iterator which ends after the first [`None`].",102,null],[11,"inspect","","Do something with each element of an iterator, passing the value on.",102,null],[11,"by_ref","","Borrows an iterator, rather than consuming it.",102,null],[11,"collect","","Transforms an iterator into a collection.",102,null],[11,"partition","","Consumes an iterator, creating two collections from it.",102,null],[11,"fold","","An iterator adaptor that applies a function, producing a single, final value.",102,null],[11,"all","","Tests if every element of the iterator matches a predicate.",102,null],[11,"any","","Tests if any element of the iterator matches a predicate.",102,null],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",102,null],[11,"position","","Searches for an element in an iterator, returning its index.",102,null],[11,"rposition","","Searches for an element in an iterator from the right, returning its\nindex.",102,null],[11,"max","","Returns the maximum element of an iterator.",102,null],[11,"min","","Returns the minimum element of an iterator.",102,null],[11,"max_by_key","","Returns the element that gives the maximum value from the\nspecified function.",102,null],[11,"max_by","","Returns the element that gives the maximum value with respect to the\nspecified comparison function.",102,null],[11,"min_by_key","","Returns the element that gives the minimum value from the\nspecified function.",102,null],[11,"min_by","","Returns the element that gives the minimum value with respect to the\nspecified comparison function.",102,null],[11,"rev","","Reverses an iterator&#39;s direction.",102,null],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",102,null],[11,"cloned","","Creates an iterator which [`clone()`]s all of its elements.",102,null],[11,"cycle","","Repeats an iterator endlessly.",102,null],[11,"sum","","Sums the elements of an iterator.",102,null],[11,"product","","Iterates over the entire iterator, multiplying all the elements",102,null],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those\nof another.",102,null],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those\nof another.",102,null],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of\nanother.",102,null],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of\nanother.",102,null],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically\nless than those of another.",102,null],[11,"le","","Determines if the elements of this `Iterator` are lexicographically\nless or equal to those of another.",102,null],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically\ngreater than those of another.",102,null],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically\ngreater than or equal to those of another.",102,null],[11,"len","","Returns the exact number of times the iterator will iterate.",108,null],[11,"is_empty","","Returns whether the iterator is empty.",108,null]],"paths":[[3,"Wrapping"],[4,"FpCategory"],[3,"ParseFloatError"],[8,"Zero"],[8,"One"],[3,"TryFromIntError"],[3,"ParseIntError"],[3,"Discriminant"],[3,"NonZero"],[3,"Unique"],[3,"Shared"],[3,"PhantomData"],[3,"Range"],[3,"RangeFrom"],[3,"RangeTo"],[3,"RangeToInclusive"],[4,"RangeInclusive"],[8,"Drop"],[8,"Add"],[8,"Sub"],[8,"Mul"],[8,"Div"],[8,"Rem"],[8,"Neg"],[8,"Not"],[8,"BitAnd"],[8,"BitOr"],[8,"BitXor"],[8,"Shl"],[8,"Shr"],[8,"AddAssign"],[8,"SubAssign"],[8,"MulAssign"],[8,"DivAssign"],[8,"RemAssign"],[8,"BitAndAssign"],[8,"BitOrAssign"],[8,"BitXorAssign"],[8,"ShlAssign"],[8,"ShrAssign"],[8,"Index"],[8,"IndexMut"],[8,"Deref"],[8,"DerefMut"],[8,"Fn"],[8,"FnMut"],[8,"FnOnce"],[8,"Place"],[8,"Placer"],[8,"InPlace"],[8,"Boxed"],[8,"BoxPlace"],[8,"Carrier"],[3,"RangeFull"],[4,"Ordering"],[8,"PartialEq"],[8,"Ord"],[8,"PartialOrd"],[8,"Clone"],[8,"Default"],[8,"AsRef"],[8,"AsMut"],[8,"Into"],[8,"From"],[8,"TryInto"],[8,"TryFrom"],[8,"Borrow"],[8,"BorrowMut"],[8,"Any"],[3,"TypeId"],[8,"FixedSizeArray"],[4,"Ordering"],[3,"AtomicBool"],[3,"AtomicPtr"],[3,"AtomicI8"],[3,"AtomicU8"],[3,"AtomicI16"],[3,"AtomicU16"],[3,"AtomicI32"],[3,"AtomicU32"],[3,"AtomicI64"],[3,"AtomicU64"],[3,"AtomicIsize"],[3,"AtomicUsize"],[4,"BorrowState"],[3,"Cell"],[3,"BorrowError"],[3,"BorrowMutError"],[3,"RefCell"],[3,"Ref"],[3,"RefMut"],[3,"UnsafeCell"],[3,"CharTryFromError"],[3,"EscapeUnicode"],[3,"EscapeDefault"],[3,"EscapeDebug"],[3,"DecodeUtf8"],[3,"InvalidSequence"],[3,"StepBy"],[3,"Repeat"],[3,"Empty"],[3,"Once"],[8,"Iterator"],[8,"Step"],[8,"FromIterator"],[8,"IntoIterator"],[8,"DoubleEndedIterator"],[8,"Extend"],[8,"ExactSizeIterator"],[8,"Sum"],[8,"Product"],[3,"Rev"],[3,"Cloned"],[3,"Cycle"],[3,"Chain"],[3,"Zip"],[3,"Map"],[3,"Filter"],[3,"FilterMap"],[3,"Enumerate"],[3,"Peekable"],[3,"SkipWhile"],[3,"TakeWhile"],[3,"Skip"],[3,"Take"],[3,"Scan"],[3,"FlatMap"],[3,"Fuse"],[3,"Inspect"],[4,"Option"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"TraitObject"],[4,"Result"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[8,"SliceExt"],[8,"SliceIndex"],[3,"Iter"],[3,"IterMut"],[3,"Split"],[3,"SplitMut"],[3,"SplitN"],[3,"RSplitN"],[3,"SplitNMut"],[3,"RSplitNMut"],[3,"Windows"],[3,"Chunks"],[3,"ChunksMut"],[4,"SearchStep"],[8,"Pattern"],[8,"Searcher"],[8,"ReverseSearcher"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[8,"FromStr"],[3,"ParseBoolError"],[3,"Utf8Error"],[3,"Chars"],[3,"CharIndices"],[3,"Bytes"],[3,"Split"],[3,"RSplit"],[3,"SplitTerminator"],[3,"RSplitTerminator"],[3,"SplitN"],[3,"RSplitN"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Matches"],[3,"RMatches"],[3,"Lines"],[3,"LinesAny"],[3,"SipHasher13"],[3,"SipHasher24"],[3,"SipHasher"],[8,"Hash"],[8,"Hasher"],[8,"BuildHasher"],[3,"BuildHasherDefault"],[4,"Alignment"],[3,"DebugStruct"],[3,"DebugTuple"],[3,"DebugSet"],[3,"DebugList"],[3,"DebugMap"],[8,"Write"],[8,"Debug"],[8,"Display"],[8,"Octal"],[8,"Binary"],[8,"LowerHex"],[8,"UpperHex"],[8,"Pointer"],[8,"LowerExp"],[8,"UpperExp"],[3,"Error"],[3,"Arguments"],[3,"Formatter"]]};
searchIndex["libc"] = {"doc":"Crate docs","items":[[3,"group","libc","",null,null],[12,"gr_name","","",0,null],[12,"gr_passwd","","",0,null],[12,"gr_gid","","",0,null],[12,"gr_mem","","",0,null],[3,"utimbuf","","",null,null],[12,"actime","","",1,null],[12,"modtime","","",1,null],[3,"timeval","","",null,null],[12,"tv_sec","","",2,null],[12,"tv_usec","","",2,null],[3,"timespec","","",null,null],[12,"tv_sec","","",3,null],[12,"tv_nsec","","",3,null],[3,"rlimit","","",null,null],[12,"rlim_cur","","",4,null],[12,"rlim_max","","",4,null],[3,"rusage","","",null,null],[12,"ru_utime","","",5,null],[12,"ru_stime","","",5,null],[12,"ru_maxrss","","",5,null],[12,"ru_ixrss","","",5,null],[12,"ru_idrss","","",5,null],[12,"ru_isrss","","",5,null],[12,"ru_minflt","","",5,null],[12,"ru_majflt","","",5,null],[12,"ru_nswap","","",5,null],[12,"ru_inblock","","",5,null],[12,"ru_oublock","","",5,null],[12,"ru_msgsnd","","",5,null],[12,"ru_msgrcv","","",5,null],[12,"ru_nsignals","","",5,null],[12,"ru_nvcsw","","",5,null],[12,"ru_nivcsw","","",5,null],[3,"in_addr","","",null,null],[12,"s_addr","","",6,null],[3,"in6_addr","","",null,null],[12,"s6_addr","","",7,null],[3,"ip_mreq","","",null,null],[12,"imr_multiaddr","","",8,null],[12,"imr_interface","","",8,null],[3,"ipv6_mreq","","",null,null],[12,"ipv6mr_multiaddr","","",9,null],[12,"ipv6mr_interface","","",9,null],[3,"hostent","","",null,null],[12,"h_name","","",10,null],[12,"h_aliases","","",10,null],[12,"h_addrtype","","",10,null],[12,"h_length","","",10,null],[12,"h_addr_list","","",10,null],[3,"iovec","","",null,null],[12,"iov_base","","",11,null],[12,"iov_len","","",11,null],[3,"pollfd","","",null,null],[12,"fd","","",12,null],[12,"events","","",12,null],[12,"revents","","",12,null],[3,"winsize","","",null,null],[12,"ws_row","","",13,null],[12,"ws_col","","",13,null],[12,"ws_xpixel","","",13,null],[12,"ws_ypixel","","",13,null],[3,"linger","","",null,null],[12,"l_onoff","","",14,null],[12,"l_linger","","",14,null],[3,"sigval","","",null,null],[12,"sival_ptr","","",15,null],[3,"sockaddr","","",null,null],[12,"sa_family","","",16,null],[12,"sa_data","","",16,null],[3,"sockaddr_in","","",null,null],[12,"sin_family","","",17,null],[12,"sin_port","","",17,null],[12,"sin_addr","","",17,null],[12,"sin_zero","","",17,null],[3,"sockaddr_in6","","",null,null],[12,"sin6_family","","",18,null],[12,"sin6_port","","",18,null],[12,"sin6_flowinfo","","",18,null],[12,"sin6_addr","","",18,null],[12,"sin6_scope_id","","",18,null],[3,"sockaddr_un","","",null,null],[12,"sun_family","","",19,null],[12,"sun_path","","",19,null],[3,"sockaddr_storage","","",null,null],[12,"ss_family","","",20,null],[3,"addrinfo","","",null,null],[12,"ai_flags","","",21,null],[12,"ai_family","","",21,null],[12,"ai_socktype","","",21,null],[12,"ai_protocol","","",21,null],[12,"ai_addrlen","","",21,null],[12,"ai_addr","","",21,null],[12,"ai_canonname","","",21,null],[12,"ai_next","","",21,null],[3,"sockaddr_nl","","",null,null],[12,"nl_family","","",22,null],[12,"nl_pid","","",22,null],[12,"nl_groups","","",22,null],[3,"sockaddr_ll","","",null,null],[12,"sll_family","","",23,null],[12,"sll_protocol","","",23,null],[12,"sll_ifindex","","",23,null],[12,"sll_hatype","","",23,null],[12,"sll_pkttype","","",23,null],[12,"sll_halen","","",23,null],[12,"sll_addr","","",23,null],[3,"fd_set","","",null,null],[3,"tm","","",null,null],[12,"tm_sec","","",24,null],[12,"tm_min","","",24,null],[12,"tm_hour","","",24,null],[12,"tm_mday","","",24,null],[12,"tm_mon","","",24,null],[12,"tm_year","","",24,null],[12,"tm_wday","","",24,null],[12,"tm_yday","","",24,null],[12,"tm_isdst","","",24,null],[12,"tm_gmtoff","","",24,null],[12,"tm_zone","","",24,null],[3,"sched_param","","",null,null],[12,"sched_priority","","",25,null],[3,"Dl_info","","",null,null],[12,"dli_fname","","",26,null],[12,"dli_fbase","","",26,null],[12,"dli_sname","","",26,null],[12,"dli_saddr","","",26,null],[3,"epoll_event","","",null,null],[12,"events","","",27,null],[12,"u64","","",27,null],[3,"utsname","","",null,null],[12,"sysname","","",28,null],[12,"nodename","","",28,null],[12,"release","","",28,null],[12,"version","","",28,null],[12,"machine","","",28,null],[12,"domainname","","",28,null],[3,"lconv","","",null,null],[12,"decimal_point","","",29,null],[12,"thousands_sep","","",29,null],[12,"grouping","","",29,null],[12,"int_curr_symbol","","",29,null],[12,"currency_symbol","","",29,null],[12,"mon_decimal_point","","",29,null],[12,"mon_thousands_sep","","",29,null],[12,"mon_grouping","","",29,null],[12,"positive_sign","","",29,null],[12,"negative_sign","","",29,null],[12,"int_frac_digits","","",29,null],[12,"frac_digits","","",29,null],[12,"p_cs_precedes","","",29,null],[12,"p_sep_by_space","","",29,null],[12,"n_cs_precedes","","",29,null],[12,"n_sep_by_space","","",29,null],[12,"p_sign_posn","","",29,null],[12,"n_sign_posn","","",29,null],[12,"int_p_cs_precedes","","",29,null],[12,"int_p_sep_by_space","","",29,null],[12,"int_n_cs_precedes","","",29,null],[12,"int_n_sep_by_space","","",29,null],[12,"int_p_sign_posn","","",29,null],[12,"int_n_sign_posn","","",29,null],[3,"sigevent","","",null,null],[12,"sigev_value","","",30,null],[12,"sigev_signo","","",30,null],[12,"sigev_notify","","",30,null],[12,"sigev_notify_thread_id","","",30,null],[3,"dirent","","",null,null],[12,"d_ino","","",31,null],[12,"d_off","","",31,null],[12,"d_reclen","","",31,null],[12,"d_type","","",31,null],[12,"d_name","","",31,null],[3,"dirent64","","",null,null],[12,"d_ino","","",32,null],[12,"d_off","","",32,null],[12,"d_reclen","","",32,null],[12,"d_type","","",32,null],[12,"d_name","","",32,null],[3,"rlimit64","","",null,null],[12,"rlim_cur","","",33,null],[12,"rlim_max","","",33,null],[3,"glob_t","","",null,null],[12,"gl_pathc","","",34,null],[12,"gl_pathv","","",34,null],[12,"gl_offs","","",34,null],[12,"gl_flags","","",34,null],[3,"ifaddrs","","",null,null],[12,"ifa_next","","",35,null],[12,"ifa_name","","",35,null],[12,"ifa_flags","","",35,null],[12,"ifa_addr","","",35,null],[12,"ifa_netmask","","",35,null],[12,"ifa_ifu","","",35,null],[12,"ifa_data","","",35,null],[3,"pthread_mutex_t","","",null,null],[3,"pthread_rwlock_t","","",null,null],[3,"pthread_mutexattr_t","","",null,null],[3,"pthread_cond_t","","",null,null],[3,"pthread_condattr_t","","",null,null],[3,"passwd","","",null,null],[12,"pw_name","","",36,null],[12,"pw_passwd","","",36,null],[12,"pw_uid","","",36,null],[12,"pw_gid","","",36,null],[12,"pw_gecos","","",36,null],[12,"pw_dir","","",36,null],[12,"pw_shell","","",36,null],[3,"spwd","","",null,null],[12,"sp_namp","","",37,null],[12,"sp_pwdp","","",37,null],[12,"sp_lstchg","","",37,null],[12,"sp_min","","",37,null],[12,"sp_max","","",37,null],[12,"sp_warn","","",37,null],[12,"sp_inact","","",37,null],[12,"sp_expire","","",37,null],[12,"sp_flag","","",37,null],[3,"statvfs","","",null,null],[12,"f_bsize","","",38,null],[12,"f_frsize","","",38,null],[12,"f_blocks","","",38,null],[12,"f_bfree","","",38,null],[12,"f_bavail","","",38,null],[12,"f_files","","",38,null],[12,"f_ffree","","",38,null],[12,"f_favail","","",38,null],[12,"f_fsid","","",38,null],[12,"f_flag","","",38,null],[12,"f_namemax","","",38,null],[3,"dqblk","","",null,null],[12,"dqb_bhardlimit","","",39,null],[12,"dqb_bsoftlimit","","",39,null],[12,"dqb_curspace","","",39,null],[12,"dqb_ihardlimit","","",39,null],[12,"dqb_isoftlimit","","",39,null],[12,"dqb_curinodes","","",39,null],[12,"dqb_btime","","",39,null],[12,"dqb_itime","","",39,null],[12,"dqb_valid","","",39,null],[3,"signalfd_siginfo","","",null,null],[12,"ssi_signo","","",40,null],[12,"ssi_errno","","",40,null],[12,"ssi_code","","",40,null],[12,"ssi_pid","","",40,null],[12,"ssi_uid","","",40,null],[12,"ssi_fd","","",40,null],[12,"ssi_tid","","",40,null],[12,"ssi_band","","",40,null],[12,"ssi_overrun","","",40,null],[12,"ssi_trapno","","",40,null],[12,"ssi_status","","",40,null],[12,"ssi_int","","",40,null],[12,"ssi_ptr","","",40,null],[12,"ssi_utime","","",40,null],[12,"ssi_stime","","",40,null],[12,"ssi_addr","","",40,null],[3,"fsid_t","","",null,null],[3,"mq_attr","","",null,null],[12,"mq_flags","","",41,null],[12,"mq_maxmsg","","",41,null],[12,"mq_msgsize","","",41,null],[12,"mq_curmsgs","","",41,null],[3,"cpu_set_t","","",null,null],[3,"if_nameindex","","",null,null],[12,"if_index","","",42,null],[12,"if_name","","",42,null],[3,"msginfo","","",null,null],[12,"msgpool","","",43,null],[12,"msgmap","","",43,null],[12,"msgmax","","",43,null],[12,"msgmnb","","",43,null],[12,"msgmni","","",43,null],[12,"msgssz","","",43,null],[12,"msgtql","","",43,null],[12,"msgseg","","",43,null],[3,"aiocb","","",null,null],[12,"aio_fildes","","",44,null],[12,"aio_lio_opcode","","",44,null],[12,"aio_reqprio","","",44,null],[12,"aio_buf","","",44,null],[12,"aio_nbytes","","",44,null],[12,"aio_sigevent","","",44,null],[12,"aio_offset","","",44,null],[3,"__exit_status","","",null,null],[12,"e_termination","","",45,null],[12,"e_exit","","",45,null],[3,"__timeval","","",null,null],[12,"tv_sec","","",46,null],[12,"tv_usec","","",46,null],[3,"utmpx","","",null,null],[12,"ut_type","","",47,null],[12,"ut_pid","","",47,null],[12,"ut_line","","",47,null],[12,"ut_id","","",47,null],[12,"ut_user","","",47,null],[12,"ut_host","","",47,null],[12,"ut_exit","","",47,null],[12,"ut_session","","",47,null],[12,"ut_tv","","",47,null],[12,"ut_addr_v6","","",47,null],[3,"sigaction","","",null,null],[12,"sa_sigaction","","",48,null],[12,"sa_mask","","",48,null],[12,"sa_flags","","",48,null],[3,"stack_t","","",null,null],[12,"ss_sp","","",49,null],[12,"ss_flags","","",49,null],[12,"ss_size","","",49,null],[3,"siginfo_t","","",null,null],[12,"si_signo","","",50,null],[12,"si_errno","","",50,null],[12,"si_code","","",50,null],[12,"_pad","","",50,null],[3,"glob64_t","","",null,null],[12,"gl_pathc","","",51,null],[12,"gl_pathv","","",51,null],[12,"gl_offs","","",51,null],[12,"gl_flags","","",51,null],[3,"ucred","","",null,null],[12,"pid","","",52,null],[12,"uid","","",52,null],[12,"gid","","",52,null],[3,"statfs","","",null,null],[12,"f_type","","",53,null],[12,"f_bsize","","",53,null],[12,"f_blocks","","",53,null],[12,"f_bfree","","",53,null],[12,"f_bavail","","",53,null],[12,"f_files","","",53,null],[12,"f_ffree","","",53,null],[12,"f_fsid","","",53,null],[12,"f_namelen","","",53,null],[12,"f_frsize","","",53,null],[3,"msghdr","","",null,null],[12,"msg_name","","",54,null],[12,"msg_namelen","","",54,null],[12,"msg_iov","","",54,null],[12,"msg_iovlen","","",54,null],[12,"msg_control","","",54,null],[12,"msg_controllen","","",54,null],[12,"msg_flags","","",54,null],[3,"termios","","",null,null],[12,"c_iflag","","",55,null],[12,"c_oflag","","",55,null],[12,"c_cflag","","",55,null],[12,"c_lflag","","",55,null],[12,"c_line","","",55,null],[12,"c_cc","","",55,null],[12,"c_ispeed","","",55,null],[12,"c_ospeed","","",55,null],[3,"flock","","",null,null],[12,"l_type","","",56,null],[12,"l_whence","","",56,null],[12,"l_start","","",56,null],[12,"l_len","","",56,null],[12,"l_pid","","",56,null],[3,"sem_t","","",null,null],[3,"stat","","",null,null],[12,"st_dev","","",57,null],[12,"st_ino","","",57,null],[12,"st_mode","","",57,null],[12,"st_nlink","","",57,null],[12,"st_uid","","",57,null],[12,"st_gid","","",57,null],[12,"st_rdev","","",57,null],[12,"st_size","","",57,null],[12,"st_blksize","","",57,null],[12,"st_blocks","","",57,null],[12,"st_atime","","",57,null],[12,"st_atime_nsec","","",57,null],[12,"st_mtime","","",57,null],[12,"st_mtime_nsec","","",57,null],[12,"st_ctime","","",57,null],[12,"st_ctime_nsec","","",57,null],[3,"pthread_attr_t","","",null,null],[3,"sigset_t","","",null,null],[3,"sysinfo","","",null,null],[12,"uptime","","",58,null],[12,"loads","","",58,null],[12,"totalram","","",58,null],[12,"freeram","","",58,null],[12,"sharedram","","",58,null],[12,"bufferram","","",58,null],[12,"totalswap","","",58,null],[12,"freeswap","","",58,null],[12,"procs","","",58,null],[12,"pad","","",58,null],[12,"totalhigh","","",58,null],[12,"freehigh","","",58,null],[12,"mem_unit","","",58,null],[12,"_f","","",58,null],[3,"ipc_perm","","",null,null],[12,"__key","","",59,null],[12,"uid","","",59,null],[12,"gid","","",59,null],[12,"cuid","","",59,null],[12,"cgid","","",59,null],[12,"mode","","",59,null],[12,"__seq","","",59,null],[3,"stat64","","",null,null],[12,"st_dev","","",60,null],[12,"st_mode","","",60,null],[12,"st_nlink","","",60,null],[12,"st_uid","","",60,null],[12,"st_gid","","",60,null],[12,"st_rdev","","",60,null],[12,"st_size","","",60,null],[12,"st_blksize","","",60,null],[12,"st_blocks","","",60,null],[12,"st_atime","","",60,null],[12,"st_atime_nsec","","",60,null],[12,"st_mtime","","",60,null],[12,"st_mtime_nsec","","",60,null],[12,"st_ctime","","",60,null],[12,"st_ctime_nsec","","",60,null],[12,"st_ino","","",60,null],[3,"shmid_ds","","",null,null],[12,"shm_perm","","",61,null],[12,"shm_segsz","","",61,null],[12,"shm_atime","","",61,null],[12,"shm_dtime","","",61,null],[12,"shm_ctime","","",61,null],[12,"shm_cpid","","",61,null],[12,"shm_lpid","","",61,null],[12,"shm_nattch","","",61,null],[3,"msqid_ds","","",null,null],[12,"msg_perm","","",62,null],[12,"msg_stime","","",62,null],[12,"msg_rtime","","",62,null],[12,"msg_ctime","","",62,null],[12,"msg_qnum","","",62,null],[12,"msg_qbytes","","",62,null],[12,"msg_lspid","","",62,null],[12,"msg_lrpid","","",62,null],[4,"c_void","","",null,null],[4,"FILE","","",null,null],[4,"fpos_t","","",null,null],[4,"DIR","","",null,null],[4,"locale_t","","",null,null],[4,"timezone","","",null,null],[4,"fpos64_t","","",null,null],[5,"FD_CLR","","",null,null],[5,"FD_ISSET","","",null,null],[5,"FD_SET","","",null,null],[5,"FD_ZERO","","",null,null],[5,"WIFSTOPPED","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"bool"}}],[5,"WSTOPSIG","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"c_int"}}],[5,"WIFSIGNALED","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"bool"}}],[5,"WTERMSIG","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"c_int"}}],[5,"WIFEXITED","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"bool"}}],[5,"WEXITSTATUS","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"c_int"}}],[5,"WCOREDUMP","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"bool"}}],[5,"CPU_ZERO","","",null,null],[5,"CPU_SET","","",null,null],[5,"CPU_CLR","","",null,null],[5,"CPU_ISSET","","",null,{"inputs":[{"name":"usize"},{"name":"cpu_set_t"}],"output":{"name":"bool"}}],[5,"CPU_EQUAL","","",null,{"inputs":[{"name":"cpu_set_t"},{"name":"cpu_set_t"}],"output":{"name":"bool"}}],[5,"isalnum","","",null,null],[5,"isalpha","","",null,null],[5,"iscntrl","","",null,null],[5,"isdigit","","",null,null],[5,"isgraph","","",null,null],[5,"islower","","",null,null],[5,"isprint","","",null,null],[5,"ispunct","","",null,null],[5,"isspace","","",null,null],[5,"isupper","","",null,null],[5,"isxdigit","","",null,null],[5,"tolower","","",null,null],[5,"toupper","","",null,null],[5,"fopen","","",null,null],[5,"freopen","","",null,null],[5,"fflush","","",null,null],[5,"fclose","","",null,null],[5,"remove","","",null,null],[5,"rename","","",null,null],[5,"tmpfile","","",null,null],[5,"setvbuf","","",null,null],[5,"setbuf","","",null,null],[5,"getchar","","",null,null],[5,"putchar","","",null,null],[5,"fgetc","","",null,null],[5,"fgets","","",null,null],[5,"fputc","","",null,null],[5,"fputs","","",null,null],[5,"puts","","",null,null],[5,"ungetc","","",null,null],[5,"fread","","",null,null],[5,"fwrite","","",null,null],[5,"fseek","","",null,null],[5,"ftell","","",null,null],[5,"rewind","","",null,null],[5,"fgetpos","","",null,null],[5,"fsetpos","","",null,null],[5,"feof","","",null,null],[5,"ferror","","",null,null],[5,"perror","","",null,null],[5,"atoi","","",null,null],[5,"strtod","","",null,null],[5,"strtol","","",null,null],[5,"strtoul","","",null,null],[5,"calloc","","",null,null],[5,"malloc","","",null,null],[5,"realloc","","",null,null],[5,"free","","",null,null],[5,"abort","","",null,null],[5,"exit","","",null,null],[5,"_exit","","",null,null],[5,"atexit","","",null,null],[5,"system","","",null,null],[5,"getenv","","",null,null],[5,"strcpy","","",null,null],[5,"strncpy","","",null,null],[5,"strcat","","",null,null],[5,"strncat","","",null,null],[5,"strcmp","","",null,null],[5,"strncmp","","",null,null],[5,"strcoll","","",null,null],[5,"strchr","","",null,null],[5,"strrchr","","",null,null],[5,"strspn","","",null,null],[5,"strcspn","","",null,null],[5,"strdup","","",null,null],[5,"strpbrk","","",null,null],[5,"strstr","","",null,null],[5,"strlen","","",null,null],[5,"strnlen","","",null,null],[5,"strerror","","",null,null],[5,"strtok","","",null,null],[5,"strxfrm","","",null,null],[5,"wcslen","","",null,null],[5,"memchr","","",null,null],[5,"memcmp","","",null,null],[5,"memcpy","","",null,null],[5,"memmove","","",null,null],[5,"memset","","",null,null],[5,"abs","","",null,null],[5,"atof","","",null,null],[5,"labs","","",null,null],[5,"rand","","",null,null],[5,"srand","","",null,null],[5,"getgrnam","","",null,null],[5,"getgrgid","","",null,null],[5,"endpwent","","",null,null],[5,"getpwnam","","",null,null],[5,"getpwuid","","",null,null],[5,"fprintf","","",null,null],[5,"printf","","",null,null],[5,"snprintf","","",null,null],[5,"sprintf","","",null,null],[5,"fscanf","","",null,null],[5,"scanf","","",null,null],[5,"sscanf","","",null,null],[5,"getchar_unlocked","","",null,null],[5,"putchar_unlocked","","",null,null],[5,"socket","","",null,null],[5,"connect","","",null,null],[5,"bind","","",null,null],[5,"listen","","",null,null],[5,"accept","","",null,null],[5,"getpeername","","",null,null],[5,"getsockname","","",null,null],[5,"setsockopt","","",null,null],[5,"socketpair","","",null,null],[5,"sendto","","",null,null],[5,"shutdown","","",null,null],[5,"chmod","","",null,null],[5,"fchmod","","",null,null],[5,"fstat","","",null,null],[5,"mkdir","","",null,null],[5,"stat","","",null,null],[5,"popen","","",null,null],[5,"pclose","","",null,null],[5,"fdopen","","",null,null],[5,"fileno","","",null,null],[5,"open","","",null,null],[5,"creat","","",null,null],[5,"fcntl","","",null,null],[5,"opendir","","",null,null],[5,"readdir_r","","",null,null],[5,"closedir","","",null,null],[5,"rewinddir","","",null,null],[5,"access","","",null,null],[5,"alarm","","",null,null],[5,"chdir","","",null,null],[5,"chown","","",null,null],[5,"lchown","","",null,null],[5,"close","","",null,null],[5,"dup","","",null,null],[5,"dup2","","",null,null],[5,"execv","","",null,null],[5,"execve","","",null,null],[5,"execvp","","",null,null],[5,"fork","","",null,null],[5,"fpathconf","","",null,null],[5,"getcwd","","",null,null],[5,"getegid","","",null,null],[5,"geteuid","","",null,null],[5,"getgid","","",null,null],[5,"getgroups","","",null,null],[5,"getlogin","","",null,null],[5,"getopt","","",null,null],[5,"getpgid","","",null,null],[5,"getpgrp","","",null,null],[5,"getpid","","",null,null],[5,"getppid","","",null,null],[5,"getuid","","",null,null],[5,"isatty","","",null,null],[5,"link","","",null,null],[5,"lseek","","",null,null],[5,"pathconf","","",null,null],[5,"pause","","",null,null],[5,"pipe","","",null,null],[5,"posix_memalign","","",null,null],[5,"read","","",null,null],[5,"rmdir","","",null,null],[5,"setgid","","",null,null],[5,"setpgid","","",null,null],[5,"setsid","","",null,null],[5,"setuid","","",null,null],[5,"sleep","","",null,null],[5,"nanosleep","","",null,null],[5,"tcgetpgrp","","",null,null],[5,"tcsetpgrp","","",null,null],[5,"ttyname","","",null,null],[5,"unlink","","",null,null],[5,"wait","","",null,null],[5,"waitpid","","",null,null],[5,"write","","",null,null],[5,"pread","","",null,null],[5,"pwrite","","",null,null],[5,"umask","","",null,null],[5,"utime","","",null,null],[5,"kill","","",null,null],[5,"mlock","","",null,null],[5,"munlock","","",null,null],[5,"mlockall","","",null,null],[5,"munlockall","","",null,null],[5,"mmap","","",null,null],[5,"munmap","","",null,null],[5,"if_nametoindex","","",null,null],[5,"if_indextoname","","",null,null],[5,"lstat","","",null,null],[5,"fsync","","",null,null],[5,"setenv","","",null,null],[5,"unsetenv","","",null,null],[5,"symlink","","",null,null],[5,"ftruncate","","",null,null],[5,"signal","","",null,null],[5,"getrlimit","","",null,null],[5,"setrlimit","","",null,null],[5,"getrusage","","",null,null],[5,"getdtablesize","","",null,null],[5,"realpath","","",null,null],[5,"flock","","",null,null],[5,"gettimeofday","","",null,null],[5,"pthread_self","","",null,null],[5,"pthread_create","","",null,null],[5,"pthread_join","","",null,null],[5,"pthread_attr_init","","",null,null],[5,"pthread_attr_destroy","","",null,null],[5,"pthread_attr_setstacksize","","",null,null],[5,"pthread_attr_setdetachstate","","",null,null],[5,"pthread_detach","","",null,null],[5,"sched_yield","","",null,null],[5,"pthread_key_create","","",null,null],[5,"pthread_key_delete","","",null,null],[5,"pthread_getspecific","","",null,null],[5,"pthread_setspecific","","",null,null],[5,"pthread_mutex_init","","",null,null],[5,"pthread_mutex_destroy","","",null,null],[5,"pthread_mutex_lock","","",null,null],[5,"pthread_mutex_trylock","","",null,null],[5,"pthread_mutex_unlock","","",null,null],[5,"pthread_mutexattr_init","","",null,null],[5,"pthread_mutexattr_destroy","","",null,null],[5,"pthread_mutexattr_settype","","",null,null],[5,"pthread_cond_init","","",null,null],[5,"pthread_cond_wait","","",null,null],[5,"pthread_cond_timedwait","","",null,null],[5,"pthread_cond_signal","","",null,null],[5,"pthread_cond_broadcast","","",null,null],[5,"pthread_cond_destroy","","",null,null],[5,"pthread_condattr_init","","",null,null],[5,"pthread_condattr_destroy","","",null,null],[5,"pthread_rwlock_destroy","","",null,null],[5,"pthread_rwlock_rdlock","","",null,null],[5,"pthread_rwlock_tryrdlock","","",null,null],[5,"pthread_rwlock_wrlock","","",null,null],[5,"pthread_rwlock_trywrlock","","",null,null],[5,"pthread_rwlock_unlock","","",null,null],[5,"pthread_sigmask","","",null,null],[5,"pthread_kill","","",null,null],[5,"strerror_r","","",null,null],[5,"getsockopt","","",null,null],[5,"raise","","",null,null],[5,"sigaction","","",null,null],[5,"sigaltstack","","",null,null],[5,"sigwait","","",null,null],[5,"utimes","","",null,null],[5,"dlopen","","",null,null],[5,"dlerror","","",null,null],[5,"dlsym","","",null,null],[5,"dlclose","","",null,null],[5,"dladdr","","",null,null],[5,"getaddrinfo","","",null,null],[5,"freeaddrinfo","","",null,null],[5,"gai_strerror","","",null,null],[5,"gmtime_r","","",null,null],[5,"localtime_r","","",null,null],[5,"mktime","","",null,null],[5,"time","","",null,null],[5,"localtime","","",null,null],[5,"mknod","","",null,null],[5,"writev","","",null,null],[5,"readv","","",null,null],[5,"uname","","",null,null],[5,"daemon","","",null,null],[5,"gethostname","","",null,null],[5,"chroot","","",null,null],[5,"usleep","","",null,null],[5,"send","","",null,null],[5,"recv","","",null,null],[5,"putenv","","",null,null],[5,"sendmsg","","",null,null],[5,"recvmsg","","",null,null],[5,"poll","","",null,null],[5,"select","","",null,null],[5,"setlocale","","",null,null],[5,"localeconv","","",null,null],[5,"sem_destroy","","",null,null],[5,"sem_open","","",null,null],[5,"sem_close","","",null,null],[5,"sem_unlink","","",null,null],[5,"sem_wait","","",null,null],[5,"sem_trywait","","",null,null],[5,"sem_post","","",null,null],[5,"sem_init","","",null,null],[5,"glob","","",null,null],[5,"globfree","","",null,null],[5,"posix_madvise","","",null,null],[5,"shm_unlink","","",null,null],[5,"seekdir","","",null,null],[5,"telldir","","",null,null],[5,"getsid","","",null,null],[5,"madvise","","",null,null],[5,"readlink","","",null,null],[5,"msync","","",null,null],[5,"sysconf","","",null,null],[5,"recvfrom","","",null,null],[5,"mkfifo","","",null,null],[5,"sigemptyset","","",null,null],[5,"sigaddset","","",null,null],[5,"sigfillset","","",null,null],[5,"sigdelset","","",null,null],[5,"sigismember","","",null,null],[5,"pselect","","",null,null],[5,"fseeko","","",null,null],[5,"ftello","","",null,null],[5,"timegm","","",null,null],[5,"statvfs","","",null,null],[5,"fstatvfs","","",null,null],[5,"tcdrain","","",null,null],[5,"cfgetispeed","","",null,null],[5,"cfgetospeed","","",null,null],[5,"cfsetispeed","","",null,null],[5,"cfsetospeed","","",null,null],[5,"tcgetattr","","",null,null],[5,"tcsetattr","","",null,null],[5,"tcflow","","",null,null],[5,"tcflush","","",null,null],[5,"tcsendbreak","","",null,null],[5,"mkstemp","","",null,null],[5,"mkstemps","","",null,null],[5,"mkdtemp","","",null,null],[5,"futimes","","",null,null],[5,"nl_langinfo","","",null,null],[5,"openlog","","",null,null],[5,"closelog","","",null,null],[5,"setlogmask","","",null,null],[5,"syslog","","",null,null],[5,"nice","","",null,null],[5,"grantpt","","",null,null],[5,"posix_openpt","","",null,null],[5,"ptsname","","",null,null],[5,"unlockpt","","",null,null],[5,"getpwnam_r","","",null,null],[5,"getpwuid_r","","",null,null],[5,"fdatasync","","",null,null],[5,"mincore","","",null,null],[5,"clock_getres","","",null,null],[5,"clock_gettime","","",null,null],[5,"clock_nanosleep","","",null,null],[5,"prctl","","",null,null],[5,"pthread_getattr_np","","",null,null],[5,"pthread_attr_getguardsize","","",null,null],[5,"pthread_attr_getstack","","",null,null],[5,"memalign","","",null,null],[5,"setgroups","","",null,null],[5,"sched_setscheduler","","",null,null],[5,"sched_getscheduler","","",null,null],[5,"sched_get_priority_max","","",null,null],[5,"sched_get_priority_min","","",null,null],[5,"epoll_create","","",null,null],[5,"epoll_create1","","",null,null],[5,"epoll_ctl","","",null,null],[5,"epoll_wait","","",null,null],[5,"pipe2","","",null,null],[5,"mount","","",null,null],[5,"umount","","",null,null],[5,"umount2","","",null,null],[5,"clone","","",null,null],[5,"statfs","","",null,null],[5,"fstatfs","","",null,null],[5,"memrchr","","",null,null],[5,"syscall","","",null,null],[5,"sendfile","","",null,null],[5,"splice","","",null,null],[5,"tee","","",null,null],[5,"vmsplice","","",null,null],[5,"posix_fadvise","","",null,null],[5,"futimens","","",null,null],[5,"utimensat","","",null,null],[5,"duplocale","","",null,null],[5,"freelocale","","",null,null],[5,"newlocale","","",null,null],[5,"uselocale","","",null,null],[5,"creat64","","",null,null],[5,"fstat64","","",null,null],[5,"ftruncate64","","",null,null],[5,"getrlimit64","","",null,null],[5,"lseek64","","",null,null],[5,"lstat64","","",null,null],[5,"mmap64","","",null,null],[5,"open64","","",null,null],[5,"pread64","","",null,null],[5,"pwrite64","","",null,null],[5,"readdir64_r","","",null,null],[5,"setrlimit64","","",null,null],[5,"stat64","","",null,null],[5,"eventfd","","",null,null],[5,"sysinfo","","",null,null],[5,"openat","","",null,null],[5,"faccessat","","",null,null],[5,"fchmodat","","",null,null],[5,"fchownat","","",null,null],[5,"fstatat","","",null,null],[5,"linkat","","",null,null],[5,"mkdirat","","",null,null],[5,"mknodat","","",null,null],[5,"readlinkat","","",null,null],[5,"renameat","","",null,null],[5,"symlinkat","","",null,null],[5,"unlinkat","","",null,null],[5,"pthread_condattr_getclock","","",null,null],[5,"pthread_condattr_setclock","","",null,null],[5,"sched_getaffinity","","",null,null],[5,"sched_setaffinity","","",null,null],[5,"unshare","","",null,null],[5,"setns","","",null,null],[5,"sem_timedwait","","",null,null],[5,"accept4","","",null,null],[5,"pthread_mutex_timedlock","","",null,null],[5,"ptsname_r","","",null,null],[5,"aio_read","","",null,null],[5,"aio_write","","",null,null],[5,"aio_fsync","","",null,null],[5,"aio_error","","",null,null],[5,"aio_return","","",null,null],[5,"aio_suspend","","",null,null],[5,"aio_cancel","","",null,null],[5,"lio_listio","","",null,null],[5,"lutimes","","",null,null],[5,"setpwent","","",null,null],[5,"getpwent","","",null,null],[5,"setspent","","",null,null],[5,"endspent","","",null,null],[5,"getspent","","",null,null],[5,"getspnam","","",null,null],[5,"shm_open","","",null,null],[5,"shmget","","",null,null],[5,"shmat","","",null,null],[5,"shmdt","","",null,null],[5,"shmctl","","",null,null],[5,"ftok","","",null,null],[5,"msgctl","","",null,null],[5,"msgget","","",null,null],[5,"msgrcv","","",null,null],[5,"msgsnd","","",null,null],[5,"mprotect","","",null,null],[5,"__errno_location","","",null,null],[5,"fopen64","","",null,null],[5,"freopen64","","",null,null],[5,"tmpfile64","","",null,null],[5,"fgetpos64","","",null,null],[5,"fsetpos64","","",null,null],[5,"fseeko64","","",null,null],[5,"ftello64","","",null,null],[5,"fallocate","","",null,null],[5,"posix_fallocate","","",null,null],[5,"readahead","","",null,null],[5,"getxattr","","",null,null],[5,"lgetxattr","","",null,null],[5,"fgetxattr","","",null,null],[5,"setxattr","","",null,null],[5,"lsetxattr","","",null,null],[5,"fsetxattr","","",null,null],[5,"listxattr","","",null,null],[5,"llistxattr","","",null,null],[5,"flistxattr","","",null,null],[5,"removexattr","","",null,null],[5,"lremovexattr","","",null,null],[5,"fremovexattr","","",null,null],[5,"signalfd","","",null,null],[5,"pwritev","","",null,null],[5,"preadv","","",null,null],[5,"quotactl","","",null,null],[5,"mq_open","","",null,null],[5,"mq_close","","",null,null],[5,"mq_unlink","","",null,null],[5,"mq_receive","","",null,null],[5,"mq_send","","",null,null],[5,"mq_getattr","","",null,null],[5,"mq_setattr","","",null,null],[5,"epoll_pwait","","",null,null],[5,"dup3","","",null,null],[5,"sethostname","","",null,null],[5,"mkostemp","","",null,null],[5,"mkostemps","","",null,null],[5,"sigtimedwait","","",null,null],[5,"sigwaitinfo","","",null,null],[5,"openpty","","",null,null],[5,"forkpty","","",null,null],[5,"nl_langinfo_l","","",null,null],[5,"getnameinfo","","",null,null],[5,"prlimit","","",null,null],[5,"prlimit64","","",null,null],[5,"getloadavg","","",null,null],[5,"process_vm_readv","","",null,null],[5,"process_vm_writev","","",null,null],[5,"reboot","","",null,null],[5,"setfsgid","","",null,null],[5,"setfsuid","","",null,null],[5,"setresgid","","",null,null],[5,"setresuid","","",null,null],[5,"mkfifoat","","",null,null],[5,"if_nameindex","","",null,null],[5,"if_freenameindex","","",null,null],[5,"sync_file_range","","",null,null],[5,"getifaddrs","","",null,null],[5,"freeifaddrs","","",null,null],[5,"utmpxname","","",null,null],[5,"getutxent","","",null,null],[5,"getutxid","","",null,null],[5,"getutxline","","",null,null],[5,"pututxline","","",null,null],[5,"setutxent","","",null,null],[5,"endutxent","","",null,null],[5,"getpt","","",null,null],[5,"sysctl","","",null,null],[5,"ioctl","","",null,null],[5,"backtrace","","",null,null],[5,"glob64","","",null,null],[5,"globfree64","","",null,null],[5,"ptrace","","",null,null],[5,"pthread_attr_getaffinity_np","","",null,null],[5,"pthread_attr_setaffinity_np","","",null,null],[5,"getpriority","","",null,null],[5,"setpriority","","",null,null],[5,"pthread_getaffinity_np","","",null,null],[5,"pthread_setaffinity_np","","",null,null],[5,"sched_getcpu","","",null,null],[6,"int8_t","","",null,null],[6,"int16_t","","",null,null],[6,"int32_t","","",null,null],[6,"int64_t","","",null,null],[6,"uint8_t","","",null,null],[6,"uint16_t","","",null,null],[6,"uint32_t","","",null,null],[6,"uint64_t","","",null,null],[6,"c_schar","","",null,null],[6,"c_uchar","","",null,null],[6,"c_short","","",null,null],[6,"c_ushort","","",null,null],[6,"c_int","","",null,null],[6,"c_uint","","",null,null],[6,"c_float","","",null,null],[6,"c_double","","",null,null],[6,"c_longlong","","",null,null],[6,"c_ulonglong","","",null,null],[6,"intmax_t","","",null,null],[6,"uintmax_t","","",null,null],[6,"size_t","","",null,null],[6,"ptrdiff_t","","",null,null],[6,"intptr_t","","",null,null],[6,"uintptr_t","","",null,null],[6,"ssize_t","","",null,null],[6,"pid_t","","",null,null],[6,"uid_t","","",null,null],[6,"gid_t","","",null,null],[6,"in_addr_t","","",null,null],[6,"in_port_t","","",null,null],[6,"sighandler_t","","",null,null],[6,"cc_t","","",null,null],[6,"sa_family_t","","",null,null],[6,"pthread_key_t","","",null,null],[6,"speed_t","","",null,null],[6,"tcflag_t","","",null,null],[6,"loff_t","","",null,null],[6,"clockid_t","","",null,null],[6,"key_t","","",null,null],[6,"id_t","","",null,null],[6,"useconds_t","","",null,null],[6,"dev_t","","",null,null],[6,"socklen_t","","",null,null],[6,"pthread_t","","",null,null],[6,"mode_t","","",null,null],[6,"ino64_t","","",null,null],[6,"off64_t","","",null,null],[6,"blkcnt64_t","","",null,null],[6,"rlim64_t","","",null,null],[6,"shmatt_t","","",null,null],[6,"mqd_t","","",null,null],[6,"msgqnum_t","","",null,null],[6,"msglen_t","","",null,null],[6,"nfds_t","","",null,null],[6,"nl_item","","",null,null],[6,"fsblkcnt_t","","",null,null],[6,"fsfilcnt_t","","",null,null],[6,"rlim_t","","",null,null],[6,"__priority_which_t","","",null,null],[6,"c_long","","",null,null],[6,"c_ulong","","",null,null],[6,"clock_t","","",null,null],[6,"time_t","","",null,null],[6,"suseconds_t","","",null,null],[6,"ino_t","","",null,null],[6,"off_t","","",null,null],[6,"blkcnt_t","","",null,null],[6,"__fsword_t","","",null,null],[6,"blksize_t","","",null,null],[6,"nlink_t","","",null,null],[6,"c_char","","",null,null],[6,"wchar_t","","",null,null],[17,"SIG_DFL","","",null,null],[17,"SIG_IGN","","",null,null],[17,"SIG_ERR","","",null,null],[17,"DT_FIFO","","",null,null],[17,"DT_CHR","","",null,null],[17,"DT_DIR","","",null,null],[17,"DT_BLK","","",null,null],[17,"DT_REG","","",null,null],[17,"DT_LNK","","",null,null],[17,"DT_SOCK","","",null,null],[17,"FD_CLOEXEC","","",null,null],[17,"USRQUOTA","","",null,null],[17,"GRPQUOTA","","",null,null],[17,"SIGIOT","","",null,null],[17,"S_ISUID","","",null,null],[17,"S_ISGID","","",null,null],[17,"S_ISVTX","","",null,null],[17,"POLLIN","","",null,null],[17,"POLLPRI","","",null,null],[17,"POLLOUT","","",null,null],[17,"POLLERR","","",null,null],[17,"POLLHUP","","",null,null],[17,"POLLNVAL","","",null,null],[17,"IF_NAMESIZE","","",null,null],[17,"RTLD_LAZY","","",null,null],[17,"LOG_EMERG","","",null,null],[17,"LOG_ALERT","","",null,null],[17,"LOG_CRIT","","",null,null],[17,"LOG_ERR","","",null,null],[17,"LOG_WARNING","","",null,null],[17,"LOG_NOTICE","","",null,null],[17,"LOG_INFO","","",null,null],[17,"LOG_DEBUG","","",null,null],[17,"LOG_KERN","","",null,null],[17,"LOG_USER","","",null,null],[17,"LOG_MAIL","","",null,null],[17,"LOG_DAEMON","","",null,null],[17,"LOG_AUTH","","",null,null],[17,"LOG_SYSLOG","","",null,null],[17,"LOG_LPR","","",null,null],[17,"LOG_NEWS","","",null,null],[17,"LOG_UUCP","","",null,null],[17,"LOG_LOCAL0","","",null,null],[17,"LOG_LOCAL1","","",null,null],[17,"LOG_LOCAL2","","",null,null],[17,"LOG_LOCAL3","","",null,null],[17,"LOG_LOCAL4","","",null,null],[17,"LOG_LOCAL5","","",null,null],[17,"LOG_LOCAL6","","",null,null],[17,"LOG_LOCAL7","","",null,null],[17,"LOG_PID","","",null,null],[17,"LOG_CONS","","",null,null],[17,"LOG_ODELAY","","",null,null],[17,"LOG_NDELAY","","",null,null],[17,"LOG_NOWAIT","","",null,null],[17,"LOG_PRIMASK","","",null,null],[17,"LOG_FACMASK","","",null,null],[17,"PRIO_PROCESS","","",null,null],[17,"PRIO_PGRP","","",null,null],[17,"PRIO_USER","","",null,null],[17,"PRIO_MIN","","",null,null],[17,"PRIO_MAX","","",null,null],[17,"EXIT_FAILURE","","",null,null],[17,"EXIT_SUCCESS","","",null,null],[17,"RAND_MAX","","",null,null],[17,"EOF","","",null,null],[17,"SEEK_SET","","",null,null],[17,"SEEK_CUR","","",null,null],[17,"SEEK_END","","",null,null],[17,"_IOFBF","","",null,null],[17,"_IONBF","","",null,null],[17,"_IOLBF","","",null,null],[17,"F_DUPFD","","",null,null],[17,"F_GETFD","","",null,null],[17,"F_SETFD","","",null,null],[17,"F_GETFL","","",null,null],[17,"F_SETFL","","",null,null],[17,"F_SETLEASE","","",null,null],[17,"F_GETLEASE","","",null,null],[17,"F_NOTIFY","","",null,null],[17,"F_DUPFD_CLOEXEC","","",null,null],[17,"F_SETPIPE_SZ","","",null,null],[17,"F_GETPIPE_SZ","","",null,null],[17,"SIGTRAP","","",null,null],[17,"PTHREAD_CREATE_JOINABLE","","",null,null],[17,"PTHREAD_CREATE_DETACHED","","",null,null],[17,"CLOCK_REALTIME","","",null,null],[17,"CLOCK_MONOTONIC","","",null,null],[17,"CLOCK_PROCESS_CPUTIME_ID","","",null,null],[17,"CLOCK_THREAD_CPUTIME_ID","","",null,null],[17,"CLOCK_MONOTONIC_RAW","","",null,null],[17,"CLOCK_REALTIME_COARSE","","",null,null],[17,"CLOCK_MONOTONIC_COARSE","","",null,null],[17,"CLOCK_BOOTTIME","","",null,null],[17,"CLOCK_REALTIME_ALARM","","",null,null],[17,"CLOCK_BOOTTIME_ALARM","","",null,null],[17,"TIMER_ABSTIME","","",null,null],[17,"RLIMIT_CPU","","",null,null],[17,"RLIMIT_FSIZE","","",null,null],[17,"RLIMIT_DATA","","",null,null],[17,"RLIMIT_STACK","","",null,null],[17,"RLIMIT_CORE","","",null,null],[17,"RLIMIT_LOCKS","","",null,null],[17,"RLIMIT_SIGPENDING","","",null,null],[17,"RLIMIT_MSGQUEUE","","",null,null],[17,"RLIMIT_NICE","","",null,null],[17,"RLIMIT_RTPRIO","","",null,null],[17,"RUSAGE_SELF","","",null,null],[17,"O_RDONLY","","",null,null],[17,"O_WRONLY","","",null,null],[17,"O_RDWR","","",null,null],[17,"O_TRUNC","","",null,null],[17,"O_CLOEXEC","","",null,null],[17,"SOCK_CLOEXEC","","",null,null],[17,"S_IFIFO","","",null,null],[17,"S_IFCHR","","",null,null],[17,"S_IFBLK","","",null,null],[17,"S_IFDIR","","",null,null],[17,"S_IFREG","","",null,null],[17,"S_IFLNK","","",null,null],[17,"S_IFSOCK","","",null,null],[17,"S_IFMT","","",null,null],[17,"S_IRWXU","","",null,null],[17,"S_IXUSR","","",null,null],[17,"S_IWUSR","","",null,null],[17,"S_IRUSR","","",null,null],[17,"S_IRWXG","","",null,null],[17,"S_IXGRP","","",null,null],[17,"S_IWGRP","","",null,null],[17,"S_IRGRP","","",null,null],[17,"S_IRWXO","","",null,null],[17,"S_IXOTH","","",null,null],[17,"S_IWOTH","","",null,null],[17,"S_IROTH","","",null,null],[17,"F_OK","","",null,null],[17,"R_OK","","",null,null],[17,"W_OK","","",null,null],[17,"X_OK","","",null,null],[17,"STDIN_FILENO","","",null,null],[17,"STDOUT_FILENO","","",null,null],[17,"STDERR_FILENO","","",null,null],[17,"SIGHUP","","",null,null],[17,"SIGINT","","",null,null],[17,"SIGQUIT","","",null,null],[17,"SIGILL","","",null,null],[17,"SIGABRT","","",null,null],[17,"SIGFPE","","",null,null],[17,"SIGKILL","","",null,null],[17,"SIGSEGV","","",null,null],[17,"SIGPIPE","","",null,null],[17,"SIGALRM","","",null,null],[17,"SIGTERM","","",null,null],[17,"PROT_NONE","","",null,null],[17,"PROT_READ","","",null,null],[17,"PROT_WRITE","","",null,null],[17,"PROT_EXEC","","",null,null],[17,"LC_CTYPE","","",null,null],[17,"LC_NUMERIC","","",null,null],[17,"LC_TIME","","",null,null],[17,"LC_COLLATE","","",null,null],[17,"LC_MONETARY","","",null,null],[17,"LC_MESSAGES","","",null,null],[17,"LC_ALL","","",null,null],[17,"LC_CTYPE_MASK","","",null,null],[17,"LC_NUMERIC_MASK","","",null,null],[17,"LC_TIME_MASK","","",null,null],[17,"LC_COLLATE_MASK","","",null,null],[17,"LC_MONETARY_MASK","","",null,null],[17,"LC_MESSAGES_MASK","","",null,null],[17,"MAP_FILE","","",null,null],[17,"MAP_SHARED","","",null,null],[17,"MAP_PRIVATE","","",null,null],[17,"MAP_FIXED","","",null,null],[17,"MAP_FAILED","","",null,null],[17,"MS_ASYNC","","",null,null],[17,"MS_INVALIDATE","","",null,null],[17,"MS_SYNC","","",null,null],[17,"MS_RDONLY","","",null,null],[17,"MS_NOSUID","","",null,null],[17,"MS_NODEV","","",null,null],[17,"MS_NOEXEC","","",null,null],[17,"MS_SYNCHRONOUS","","",null,null],[17,"MS_REMOUNT","","",null,null],[17,"MS_MANDLOCK","","",null,null],[17,"MS_DIRSYNC","","",null,null],[17,"MS_NOATIME","","",null,null],[17,"MS_NODIRATIME","","",null,null],[17,"MS_BIND","","",null,null],[17,"MS_MOVE","","",null,null],[17,"MS_REC","","",null,null],[17,"MS_SILENT","","",null,null],[17,"MS_POSIXACL","","",null,null],[17,"MS_UNBINDABLE","","",null,null],[17,"MS_PRIVATE","","",null,null],[17,"MS_SLAVE","","",null,null],[17,"MS_SHARED","","",null,null],[17,"MS_RELATIME","","",null,null],[17,"MS_KERNMOUNT","","",null,null],[17,"MS_I_VERSION","","",null,null],[17,"MS_STRICTATIME","","",null,null],[17,"MS_ACTIVE","","",null,null],[17,"MS_NOUSER","","",null,null],[17,"MS_MGC_VAL","","",null,null],[17,"MS_MGC_MSK","","",null,null],[17,"MS_RMT_MASK","","",null,null],[17,"EPERM","","",null,null],[17,"ENOENT","","",null,null],[17,"ESRCH","","",null,null],[17,"EINTR","","",null,null],[17,"EIO","","",null,null],[17,"ENXIO","","",null,null],[17,"E2BIG","","",null,null],[17,"ENOEXEC","","",null,null],[17,"EBADF","","",null,null],[17,"ECHILD","","",null,null],[17,"EAGAIN","","",null,null],[17,"ENOMEM","","",null,null],[17,"EACCES","","",null,null],[17,"EFAULT","","",null,null],[17,"ENOTBLK","","",null,null],[17,"EBUSY","","",null,null],[17,"EEXIST","","",null,null],[17,"EXDEV","","",null,null],[17,"ENODEV","","",null,null],[17,"ENOTDIR","","",null,null],[17,"EISDIR","","",null,null],[17,"EINVAL","","",null,null],[17,"ENFILE","","",null,null],[17,"EMFILE","","",null,null],[17,"ENOTTY","","",null,null],[17,"ETXTBSY","","",null,null],[17,"EFBIG","","",null,null],[17,"ENOSPC","","",null,null],[17,"ESPIPE","","",null,null],[17,"EROFS","","",null,null],[17,"EMLINK","","",null,null],[17,"EPIPE","","",null,null],[17,"EDOM","","",null,null],[17,"ERANGE","","",null,null],[17,"EWOULDBLOCK","","",null,null],[17,"EBFONT","","",null,null],[17,"ENOSTR","","",null,null],[17,"ENODATA","","",null,null],[17,"ETIME","","",null,null],[17,"ENOSR","","",null,null],[17,"ENONET","","",null,null],[17,"ENOPKG","","",null,null],[17,"EREMOTE","","",null,null],[17,"ENOLINK","","",null,null],[17,"EADV","","",null,null],[17,"ESRMNT","","",null,null],[17,"ECOMM","","",null,null],[17,"EPROTO","","",null,null],[17,"EDOTDOT","","",null,null],[17,"AF_PACKET","","",null,null],[17,"IPPROTO_RAW","","",null,null],[17,"PROT_GROWSDOWN","","",null,null],[17,"PROT_GROWSUP","","",null,null],[17,"MAP_TYPE","","",null,null],[17,"MADV_NORMAL","","",null,null],[17,"MADV_RANDOM","","",null,null],[17,"MADV_SEQUENTIAL","","",null,null],[17,"MADV_WILLNEED","","",null,null],[17,"MADV_DONTNEED","","",null,null],[17,"MADV_REMOVE","","",null,null],[17,"MADV_DONTFORK","","",null,null],[17,"MADV_DOFORK","","",null,null],[17,"MADV_MERGEABLE","","",null,null],[17,"MADV_UNMERGEABLE","","",null,null],[17,"MADV_HWPOISON","","",null,null],[17,"IFF_UP","","",null,null],[17,"IFF_BROADCAST","","",null,null],[17,"IFF_DEBUG","","",null,null],[17,"IFF_LOOPBACK","","",null,null],[17,"IFF_POINTOPOINT","","",null,null],[17,"IFF_NOTRAILERS","","",null,null],[17,"IFF_RUNNING","","",null,null],[17,"IFF_NOARP","","",null,null],[17,"IFF_PROMISC","","",null,null],[17,"IFF_ALLMULTI","","",null,null],[17,"IFF_MASTER","","",null,null],[17,"IFF_SLAVE","","",null,null],[17,"IFF_MULTICAST","","",null,null],[17,"IFF_PORTSEL","","",null,null],[17,"IFF_AUTOMEDIA","","",null,null],[17,"IFF_DYNAMIC","","",null,null],[17,"AF_UNIX","","",null,null],[17,"AF_INET","","",null,null],[17,"AF_INET6","","",null,null],[17,"AF_NETLINK","","",null,null],[17,"SOCK_RAW","","",null,null],[17,"IPPROTO_TCP","","",null,null],[17,"IPPROTO_IP","","",null,null],[17,"IPPROTO_IPV6","","",null,null],[17,"IP_MULTICAST_TTL","","",null,null],[17,"IP_MULTICAST_LOOP","","",null,null],[17,"IP_TTL","","",null,null],[17,"IP_HDRINCL","","",null,null],[17,"IP_ADD_MEMBERSHIP","","",null,null],[17,"IP_DROP_MEMBERSHIP","","",null,null],[17,"IP_TRANSPARENT","","",null,null],[17,"IPV6_ADD_MEMBERSHIP","","",null,null],[17,"IPV6_DROP_MEMBERSHIP","","",null,null],[17,"TCP_NODELAY","","",null,null],[17,"TCP_MAXSEG","","",null,null],[17,"TCP_CORK","","",null,null],[17,"TCP_KEEPIDLE","","",null,null],[17,"TCP_KEEPINTVL","","",null,null],[17,"TCP_KEEPCNT","","",null,null],[17,"TCP_SYNCNT","","",null,null],[17,"TCP_LINGER2","","",null,null],[17,"TCP_DEFER_ACCEPT","","",null,null],[17,"TCP_WINDOW_CLAMP","","",null,null],[17,"TCP_INFO","","",null,null],[17,"TCP_QUICKACK","","",null,null],[17,"TCP_CONGESTION","","",null,null],[17,"IPV6_MULTICAST_LOOP","","",null,null],[17,"IPV6_V6ONLY","","",null,null],[17,"SO_DEBUG","","",null,null],[17,"MSG_NOSIGNAL","","",null,null],[17,"SHUT_RD","","",null,null],[17,"SHUT_WR","","",null,null],[17,"SHUT_RDWR","","",null,null],[17,"LOCK_SH","","",null,null],[17,"LOCK_EX","","",null,null],[17,"LOCK_NB","","",null,null],[17,"LOCK_UN","","",null,null],[17,"SA_NODEFER","","",null,null],[17,"SA_RESETHAND","","",null,null],[17,"SA_RESTART","","",null,null],[17,"SA_NOCLDSTOP","","",null,null],[17,"SS_ONSTACK","","",null,null],[17,"SS_DISABLE","","",null,null],[17,"PATH_MAX","","",null,null],[17,"FD_SETSIZE","","",null,null],[17,"EPOLLIN","","",null,null],[17,"EPOLLPRI","","",null,null],[17,"EPOLLOUT","","",null,null],[17,"EPOLLRDNORM","","",null,null],[17,"EPOLLRDBAND","","",null,null],[17,"EPOLLWRNORM","","",null,null],[17,"EPOLLWRBAND","","",null,null],[17,"EPOLLMSG","","",null,null],[17,"EPOLLERR","","",null,null],[17,"EPOLLHUP","","",null,null],[17,"EPOLLET","","",null,null],[17,"EPOLL_CTL_ADD","","",null,null],[17,"EPOLL_CTL_MOD","","",null,null],[17,"EPOLL_CTL_DEL","","",null,null],[17,"EPOLL_CLOEXEC","","",null,null],[17,"MNT_DETACH","","",null,null],[17,"MNT_EXPIRE","","",null,null],[17,"Q_GETFMT","","",null,null],[17,"Q_GETINFO","","",null,null],[17,"Q_SETINFO","","",null,null],[17,"QIF_BLIMITS","","",null,null],[17,"QIF_SPACE","","",null,null],[17,"QIF_ILIMITS","","",null,null],[17,"QIF_INODES","","",null,null],[17,"QIF_BTIME","","",null,null],[17,"QIF_ITIME","","",null,null],[17,"QIF_LIMITS","","",null,null],[17,"QIF_USAGE","","",null,null],[17,"QIF_TIMES","","",null,null],[17,"QIF_ALL","","",null,null],[17,"EFD_CLOEXEC","","",null,null],[17,"MNT_FORCE","","",null,null],[17,"Q_SYNC","","",null,null],[17,"Q_QUOTAON","","",null,null],[17,"Q_QUOTAOFF","","",null,null],[17,"Q_GETQUOTA","","",null,null],[17,"Q_SETQUOTA","","",null,null],[17,"TCIOFF","","",null,null],[17,"TCION","","",null,null],[17,"TCOOFF","","",null,null],[17,"TCOON","","",null,null],[17,"TCIFLUSH","","",null,null],[17,"TCOFLUSH","","",null,null],[17,"TCIOFLUSH","","",null,null],[17,"NL0","","",null,null],[17,"NL1","","",null,null],[17,"TAB0","","",null,null],[17,"CR0","","",null,null],[17,"FF0","","",null,null],[17,"BS0","","",null,null],[17,"VT0","","",null,null],[17,"VERASE","","",null,null],[17,"VKILL","","",null,null],[17,"VINTR","","",null,null],[17,"VQUIT","","",null,null],[17,"VLNEXT","","",null,null],[17,"IGNBRK","","",null,null],[17,"BRKINT","","",null,null],[17,"IGNPAR","","",null,null],[17,"PARMRK","","",null,null],[17,"INPCK","","",null,null],[17,"ISTRIP","","",null,null],[17,"INLCR","","",null,null],[17,"IGNCR","","",null,null],[17,"ICRNL","","",null,null],[17,"IXANY","","",null,null],[17,"IMAXBEL","","",null,null],[17,"OPOST","","",null,null],[17,"CS5","","",null,null],[17,"CRTSCTS","","",null,null],[17,"ECHO","","",null,null],[17,"CLONE_VM","","",null,null],[17,"CLONE_FS","","",null,null],[17,"CLONE_FILES","","",null,null],[17,"CLONE_SIGHAND","","",null,null],[17,"CLONE_PTRACE","","",null,null],[17,"CLONE_VFORK","","",null,null],[17,"CLONE_PARENT","","",null,null],[17,"CLONE_THREAD","","",null,null],[17,"CLONE_NEWNS","","",null,null],[17,"CLONE_SYSVSEM","","",null,null],[17,"CLONE_SETTLS","","",null,null],[17,"CLONE_PARENT_SETTID","","",null,null],[17,"CLONE_CHILD_CLEARTID","","",null,null],[17,"CLONE_DETACHED","","",null,null],[17,"CLONE_UNTRACED","","",null,null],[17,"CLONE_CHILD_SETTID","","",null,null],[17,"CLONE_NEWUTS","","",null,null],[17,"CLONE_NEWIPC","","",null,null],[17,"CLONE_NEWUSER","","",null,null],[17,"CLONE_NEWPID","","",null,null],[17,"CLONE_NEWNET","","",null,null],[17,"CLONE_IO","","",null,null],[17,"WNOHANG","","",null,null],[17,"WUNTRACED","","",null,null],[17,"WSTOPPED","","",null,null],[17,"WEXITED","","",null,null],[17,"WCONTINUED","","",null,null],[17,"WNOWAIT","","",null,null],[17,"__WNOTHREAD","","",null,null],[17,"__WALL","","",null,null],[17,"__WCLONE","","",null,null],[17,"SPLICE_F_MOVE","","",null,null],[17,"SPLICE_F_NONBLOCK","","",null,null],[17,"SPLICE_F_MORE","","",null,null],[17,"SPLICE_F_GIFT","","",null,null],[17,"RTLD_LOCAL","","",null,null],[17,"POSIX_FADV_NORMAL","","",null,null],[17,"POSIX_FADV_RANDOM","","",null,null],[17,"POSIX_FADV_SEQUENTIAL","","",null,null],[17,"POSIX_FADV_WILLNEED","","",null,null],[17,"AT_FDCWD","","",null,null],[17,"AT_SYMLINK_NOFOLLOW","","",null,null],[17,"LOG_CRON","","",null,null],[17,"LOG_AUTHPRIV","","",null,null],[17,"LOG_FTP","","",null,null],[17,"LOG_PERROR","","",null,null],[17,"PIPE_BUF","","",null,null],[17,"SI_LOAD_SHIFT","","",null,null],[17,"SIGEV_SIGNAL","","",null,null],[17,"SIGEV_NONE","","",null,null],[17,"SIGEV_THREAD","","",null,null],[17,"ABDAY_1","","",null,null],[17,"ABDAY_2","","",null,null],[17,"ABDAY_3","","",null,null],[17,"ABDAY_4","","",null,null],[17,"ABDAY_5","","",null,null],[17,"ABDAY_6","","",null,null],[17,"ABDAY_7","","",null,null],[17,"DAY_1","","",null,null],[17,"DAY_2","","",null,null],[17,"DAY_3","","",null,null],[17,"DAY_4","","",null,null],[17,"DAY_5","","",null,null],[17,"DAY_6","","",null,null],[17,"DAY_7","","",null,null],[17,"ABMON_1","","",null,null],[17,"ABMON_2","","",null,null],[17,"ABMON_3","","",null,null],[17,"ABMON_4","","",null,null],[17,"ABMON_5","","",null,null],[17,"ABMON_6","","",null,null],[17,"ABMON_7","","",null,null],[17,"ABMON_8","","",null,null],[17,"ABMON_9","","",null,null],[17,"ABMON_10","","",null,null],[17,"ABMON_11","","",null,null],[17,"ABMON_12","","",null,null],[17,"CLONE_NEWCGROUP","","",null,null],[17,"MON_1","","",null,null],[17,"MON_2","","",null,null],[17,"MON_3","","",null,null],[17,"MON_4","","",null,null],[17,"MON_5","","",null,null],[17,"MON_6","","",null,null],[17,"MON_7","","",null,null],[17,"MON_8","","",null,null],[17,"MON_9","","",null,null],[17,"MON_10","","",null,null],[17,"MON_11","","",null,null],[17,"MON_12","","",null,null],[17,"AM_STR","","",null,null],[17,"PM_STR","","",null,null],[17,"D_T_FMT","","",null,null],[17,"D_FMT","","",null,null],[17,"T_FMT","","",null,null],[17,"T_FMT_AMPM","","",null,null],[17,"ERA","","",null,null],[17,"ERA_D_FMT","","",null,null],[17,"ALT_DIGITS","","",null,null],[17,"ERA_D_T_FMT","","",null,null],[17,"ERA_T_FMT","","",null,null],[17,"CODESET","","",null,null],[17,"CRNCYSTR","","",null,null],[17,"RUSAGE_THREAD","","",null,null],[17,"RUSAGE_CHILDREN","","",null,null],[17,"RADIXCHAR","","",null,null],[17,"THOUSEP","","",null,null],[17,"YESEXPR","","",null,null],[17,"NOEXPR","","",null,null],[17,"YESSTR","","",null,null],[17,"NOSTR","","",null,null],[17,"FILENAME_MAX","","",null,null],[17,"L_tmpnam","","",null,null],[17,"_PC_LINK_MAX","","",null,null],[17,"_PC_MAX_CANON","","",null,null],[17,"_PC_MAX_INPUT","","",null,null],[17,"_PC_NAME_MAX","","",null,null],[17,"_PC_PATH_MAX","","",null,null],[17,"_PC_PIPE_BUF","","",null,null],[17,"_PC_CHOWN_RESTRICTED","","",null,null],[17,"_PC_NO_TRUNC","","",null,null],[17,"_PC_VDISABLE","","",null,null],[17,"_SC_ARG_MAX","","",null,null],[17,"_SC_CHILD_MAX","","",null,null],[17,"_SC_CLK_TCK","","",null,null],[17,"_SC_NGROUPS_MAX","","",null,null],[17,"_SC_OPEN_MAX","","",null,null],[17,"_SC_STREAM_MAX","","",null,null],[17,"_SC_TZNAME_MAX","","",null,null],[17,"_SC_JOB_CONTROL","","",null,null],[17,"_SC_SAVED_IDS","","",null,null],[17,"_SC_REALTIME_SIGNALS","","",null,null],[17,"_SC_PRIORITY_SCHEDULING","","",null,null],[17,"_SC_TIMERS","","",null,null],[17,"_SC_ASYNCHRONOUS_IO","","",null,null],[17,"_SC_PRIORITIZED_IO","","",null,null],[17,"_SC_SYNCHRONIZED_IO","","",null,null],[17,"_SC_FSYNC","","",null,null],[17,"_SC_MAPPED_FILES","","",null,null],[17,"_SC_MEMLOCK","","",null,null],[17,"_SC_MEMLOCK_RANGE","","",null,null],[17,"_SC_MEMORY_PROTECTION","","",null,null],[17,"_SC_MESSAGE_PASSING","","",null,null],[17,"_SC_SEMAPHORES","","",null,null],[17,"_SC_SHARED_MEMORY_OBJECTS","","",null,null],[17,"_SC_AIO_LISTIO_MAX","","",null,null],[17,"_SC_AIO_MAX","","",null,null],[17,"_SC_AIO_PRIO_DELTA_MAX","","",null,null],[17,"_SC_DELAYTIMER_MAX","","",null,null],[17,"_SC_MQ_OPEN_MAX","","",null,null],[17,"_SC_MQ_PRIO_MAX","","",null,null],[17,"_SC_VERSION","","",null,null],[17,"_SC_PAGESIZE","","",null,null],[17,"_SC_PAGE_SIZE","","",null,null],[17,"_SC_RTSIG_MAX","","",null,null],[17,"_SC_SEM_NSEMS_MAX","","",null,null],[17,"_SC_SEM_VALUE_MAX","","",null,null],[17,"_SC_SIGQUEUE_MAX","","",null,null],[17,"_SC_TIMER_MAX","","",null,null],[17,"_SC_BC_BASE_MAX","","",null,null],[17,"_SC_BC_DIM_MAX","","",null,null],[17,"_SC_BC_SCALE_MAX","","",null,null],[17,"_SC_BC_STRING_MAX","","",null,null],[17,"_SC_COLL_WEIGHTS_MAX","","",null,null],[17,"_SC_EXPR_NEST_MAX","","",null,null],[17,"_SC_LINE_MAX","","",null,null],[17,"_SC_RE_DUP_MAX","","",null,null],[17,"_SC_2_VERSION","","",null,null],[17,"_SC_2_C_BIND","","",null,null],[17,"_SC_2_C_DEV","","",null,null],[17,"_SC_2_FORT_DEV","","",null,null],[17,"_SC_2_FORT_RUN","","",null,null],[17,"_SC_2_SW_DEV","","",null,null],[17,"_SC_2_LOCALEDEF","","",null,null],[17,"_SC_IOV_MAX","","",null,null],[17,"_SC_THREADS","","",null,null],[17,"_SC_THREAD_SAFE_FUNCTIONS","","",null,null],[17,"_SC_GETGR_R_SIZE_MAX","","",null,null],[17,"_SC_GETPW_R_SIZE_MAX","","",null,null],[17,"_SC_LOGIN_NAME_MAX","","",null,null],[17,"_SC_TTY_NAME_MAX","","",null,null],[17,"_SC_THREAD_DESTRUCTOR_ITERATIONS","","",null,null],[17,"_SC_THREAD_KEYS_MAX","","",null,null],[17,"_SC_THREAD_STACK_MIN","","",null,null],[17,"_SC_THREAD_THREADS_MAX","","",null,null],[17,"_SC_THREAD_ATTR_STACKADDR","","",null,null],[17,"_SC_THREAD_ATTR_STACKSIZE","","",null,null],[17,"_SC_THREAD_PRIORITY_SCHEDULING","","",null,null],[17,"_SC_THREAD_PRIO_INHERIT","","",null,null],[17,"_SC_THREAD_PRIO_PROTECT","","",null,null],[17,"_SC_NPROCESSORS_ONLN","","",null,null],[17,"_SC_ATEXIT_MAX","","",null,null],[17,"_SC_XOPEN_VERSION","","",null,null],[17,"_SC_XOPEN_XCU_VERSION","","",null,null],[17,"_SC_XOPEN_UNIX","","",null,null],[17,"_SC_XOPEN_CRYPT","","",null,null],[17,"_SC_XOPEN_ENH_I18N","","",null,null],[17,"_SC_XOPEN_SHM","","",null,null],[17,"_SC_2_CHAR_TERM","","",null,null],[17,"_SC_2_UPE","","",null,null],[17,"_SC_XBS5_ILP32_OFF32","","",null,null],[17,"_SC_XBS5_ILP32_OFFBIG","","",null,null],[17,"_SC_XBS5_LPBIG_OFFBIG","","",null,null],[17,"_SC_XOPEN_LEGACY","","",null,null],[17,"_SC_XOPEN_REALTIME","","",null,null],[17,"_SC_XOPEN_REALTIME_THREADS","","",null,null],[17,"_SC_HOST_NAME_MAX","","",null,null],[17,"RLIM_SAVED_MAX","","",null,null],[17,"RLIM_SAVED_CUR","","",null,null],[17,"GLOB_ERR","","",null,null],[17,"GLOB_MARK","","",null,null],[17,"GLOB_NOSORT","","",null,null],[17,"GLOB_DOOFFS","","",null,null],[17,"GLOB_NOCHECK","","",null,null],[17,"GLOB_APPEND","","",null,null],[17,"GLOB_NOESCAPE","","",null,null],[17,"GLOB_NOSPACE","","",null,null],[17,"GLOB_ABORTED","","",null,null],[17,"GLOB_NOMATCH","","",null,null],[17,"POSIX_MADV_NORMAL","","",null,null],[17,"POSIX_MADV_RANDOM","","",null,null],[17,"POSIX_MADV_SEQUENTIAL","","",null,null],[17,"POSIX_MADV_WILLNEED","","",null,null],[17,"S_IEXEC","","",null,null],[17,"S_IWRITE","","",null,null],[17,"S_IREAD","","",null,null],[17,"F_LOCK","","",null,null],[17,"F_TEST","","",null,null],[17,"F_TLOCK","","",null,null],[17,"F_ULOCK","","",null,null],[17,"ST_RDONLY","","",null,null],[17,"ST_NOSUID","","",null,null],[17,"ST_NODEV","","",null,null],[17,"ST_NOEXEC","","",null,null],[17,"ST_SYNCHRONOUS","","",null,null],[17,"ST_MANDLOCK","","",null,null],[17,"ST_WRITE","","",null,null],[17,"ST_APPEND","","",null,null],[17,"ST_IMMUTABLE","","",null,null],[17,"ST_NOATIME","","",null,null],[17,"ST_NODIRATIME","","",null,null],[17,"RTLD_NEXT","","",null,null],[17,"RTLD_DEFAULT","","",null,null],[17,"RTLD_NODELETE","","",null,null],[17,"RTLD_NOW","","",null,null],[17,"TCP_MD5SIG","","",null,null],[17,"PTHREAD_MUTEX_INITIALIZER","","",null,null],[17,"PTHREAD_COND_INITIALIZER","","",null,null],[17,"PTHREAD_RWLOCK_INITIALIZER","","",null,null],[17,"PTHREAD_MUTEX_NORMAL","","",null,null],[17,"PTHREAD_MUTEX_RECURSIVE","","",null,null],[17,"PTHREAD_MUTEX_ERRORCHECK","","",null,null],[17,"PTHREAD_MUTEX_DEFAULT","","",null,null],[17,"__SIZEOF_PTHREAD_COND_T","","",null,null],[17,"SCHED_OTHER","","",null,null],[17,"SCHED_FIFO","","",null,null],[17,"SCHED_RR","","",null,null],[17,"SCHED_BATCH","","",null,null],[17,"SCHED_IDLE","","",null,null],[17,"IPC_PRIVATE","","",null,null],[17,"IPC_CREAT","","",null,null],[17,"IPC_EXCL","","",null,null],[17,"IPC_NOWAIT","","",null,null],[17,"IPC_RMID","","",null,null],[17,"IPC_SET","","",null,null],[17,"IPC_STAT","","",null,null],[17,"IPC_INFO","","",null,null],[17,"MSG_STAT","","",null,null],[17,"MSG_INFO","","",null,null],[17,"MSG_NOERROR","","",null,null],[17,"MSG_EXCEPT","","",null,null],[17,"MSG_COPY","","",null,null],[17,"SHM_R","","",null,null],[17,"SHM_W","","",null,null],[17,"SHM_RDONLY","","",null,null],[17,"SHM_RND","","",null,null],[17,"SHM_REMAP","","",null,null],[17,"SHM_EXEC","","",null,null],[17,"SHM_LOCK","","",null,null],[17,"SHM_UNLOCK","","",null,null],[17,"SHM_HUGETLB","","",null,null],[17,"SHM_NORESERVE","","",null,null],[17,"EPOLLRDHUP","","",null,null],[17,"EPOLLONESHOT","","",null,null],[17,"QFMT_VFS_OLD","","",null,null],[17,"QFMT_VFS_V0","","",null,null],[17,"SFD_CLOEXEC","","",null,null],[17,"EFD_SEMAPHORE","","",null,null],[17,"NCCS","","",null,null],[17,"LOG_NFACILITIES","","",null,null],[17,"SEM_FAILED","","",null,null],[17,"RB_AUTOBOOT","","",null,null],[17,"RB_HALT_SYSTEM","","",null,null],[17,"RB_ENABLE_CAD","","",null,null],[17,"RB_DISABLE_CAD","","",null,null],[17,"RB_POWER_OFF","","",null,null],[17,"RB_SW_SUSPEND","","",null,null],[17,"RB_KEXEC","","",null,null],[17,"SYNC_FILE_RANGE_WAIT_BEFORE","","",null,null],[17,"SYNC_FILE_RANGE_WRITE","","",null,null],[17,"SYNC_FILE_RANGE_WAIT_AFTER","","",null,null],[17,"EAI_SYSTEM","","",null,null],[17,"AIO_CANCELED","","",null,null],[17,"AIO_NOTCANCELED","","",null,null],[17,"AIO_ALLDONE","","",null,null],[17,"LIO_READ","","",null,null],[17,"LIO_WRITE","","",null,null],[17,"LIO_NOP","","",null,null],[17,"LIO_WAIT","","",null,null],[17,"LIO_NOWAIT","","",null,null],[17,"__UT_LINESIZE","","",null,null],[17,"__UT_NAMESIZE","","",null,null],[17,"__UT_HOSTSIZE","","",null,null],[17,"EMPTY","","",null,null],[17,"RUN_LVL","","",null,null],[17,"BOOT_TIME","","",null,null],[17,"NEW_TIME","","",null,null],[17,"OLD_TIME","","",null,null],[17,"INIT_PROCESS","","",null,null],[17,"LOGIN_PROCESS","","",null,null],[17,"USER_PROCESS","","",null,null],[17,"DEAD_PROCESS","","",null,null],[17,"ACCOUNTING","","",null,null],[17,"RLIMIT_RSS","","",null,null],[17,"RLIMIT_NOFILE","","",null,null],[17,"RLIMIT_AS","","",null,null],[17,"RLIMIT_NPROC","","",null,null],[17,"RLIMIT_MEMLOCK","","",null,null],[17,"RLIM_INFINITY","","",null,null],[17,"RLIMIT_RTTIME","","",null,null],[17,"RLIMIT_NLIMITS","","",null,null],[17,"O_APPEND","","",null,null],[17,"O_CREAT","","",null,null],[17,"O_EXCL","","",null,null],[17,"O_NOCTTY","","",null,null],[17,"O_NONBLOCK","","",null,null],[17,"O_SYNC","","",null,null],[17,"O_RSYNC","","",null,null],[17,"O_DSYNC","","",null,null],[17,"O_FSYNC","","",null,null],[17,"SOCK_NONBLOCK","","",null,null],[17,"LC_PAPER","","",null,null],[17,"LC_NAME","","",null,null],[17,"LC_ADDRESS","","",null,null],[17,"LC_TELEPHONE","","",null,null],[17,"LC_MEASUREMENT","","",null,null],[17,"LC_IDENTIFICATION","","",null,null],[17,"LC_PAPER_MASK","","",null,null],[17,"LC_NAME_MASK","","",null,null],[17,"LC_ADDRESS_MASK","","",null,null],[17,"LC_TELEPHONE_MASK","","",null,null],[17,"LC_MEASUREMENT_MASK","","",null,null],[17,"LC_IDENTIFICATION_MASK","","",null,null],[17,"LC_ALL_MASK","","",null,null],[17,"MAP_ANON","","",null,null],[17,"MAP_ANONYMOUS","","",null,null],[17,"MAP_GROWSDOWN","","",null,null],[17,"MAP_DENYWRITE","","",null,null],[17,"MAP_EXECUTABLE","","",null,null],[17,"MAP_POPULATE","","",null,null],[17,"MAP_NONBLOCK","","",null,null],[17,"MAP_STACK","","",null,null],[17,"EDEADLK","","",null,null],[17,"ENAMETOOLONG","","",null,null],[17,"ENOLCK","","",null,null],[17,"ENOSYS","","",null,null],[17,"ENOTEMPTY","","",null,null],[17,"ELOOP","","",null,null],[17,"ENOMSG","","",null,null],[17,"EIDRM","","",null,null],[17,"ECHRNG","","",null,null],[17,"EL2NSYNC","","",null,null],[17,"EL3HLT","","",null,null],[17,"EL3RST","","",null,null],[17,"ELNRNG","","",null,null],[17,"EUNATCH","","",null,null],[17,"ENOCSI","","",null,null],[17,"EL2HLT","","",null,null],[17,"EBADE","","",null,null],[17,"EBADR","","",null,null],[17,"EXFULL","","",null,null],[17,"ENOANO","","",null,null],[17,"EBADRQC","","",null,null],[17,"EBADSLT","","",null,null],[17,"EMULTIHOP","","",null,null],[17,"EOVERFLOW","","",null,null],[17,"ENOTUNIQ","","",null,null],[17,"EBADFD","","",null,null],[17,"EBADMSG","","",null,null],[17,"EREMCHG","","",null,null],[17,"ELIBACC","","",null,null],[17,"ELIBBAD","","",null,null],[17,"ELIBSCN","","",null,null],[17,"ELIBMAX","","",null,null],[17,"ELIBEXEC","","",null,null],[17,"EILSEQ","","",null,null],[17,"ERESTART","","",null,null],[17,"ESTRPIPE","","",null,null],[17,"EUSERS","","",null,null],[17,"ENOTSOCK","","",null,null],[17,"EDESTADDRREQ","","",null,null],[17,"EMSGSIZE","","",null,null],[17,"EPROTOTYPE","","",null,null],[17,"ENOPROTOOPT","","",null,null],[17,"EPROTONOSUPPORT","","",null,null],[17,"ESOCKTNOSUPPORT","","",null,null],[17,"EOPNOTSUPP","","",null,null],[17,"ENOTSUP","","",null,null],[17,"EPFNOSUPPORT","","",null,null],[17,"EAFNOSUPPORT","","",null,null],[17,"EADDRINUSE","","",null,null],[17,"EADDRNOTAVAIL","","",null,null],[17,"ENETDOWN","","",null,null],[17,"ENETUNREACH","","",null,null],[17,"ENETRESET","","",null,null],[17,"ECONNABORTED","","",null,null],[17,"ECONNRESET","","",null,null],[17,"ENOBUFS","","",null,null],[17,"EISCONN","","",null,null],[17,"ENOTCONN","","",null,null],[17,"ESHUTDOWN","","",null,null],[17,"ETOOMANYREFS","","",null,null],[17,"ETIMEDOUT","","",null,null],[17,"ECONNREFUSED","","",null,null],[17,"EHOSTDOWN","","",null,null],[17,"EHOSTUNREACH","","",null,null],[17,"EALREADY","","",null,null],[17,"EINPROGRESS","","",null,null],[17,"ESTALE","","",null,null],[17,"EUCLEAN","","",null,null],[17,"ENOTNAM","","",null,null],[17,"ENAVAIL","","",null,null],[17,"EISNAM","","",null,null],[17,"EREMOTEIO","","",null,null],[17,"EDQUOT","","",null,null],[17,"ENOMEDIUM","","",null,null],[17,"EMEDIUMTYPE","","",null,null],[17,"ECANCELED","","",null,null],[17,"ENOKEY","","",null,null],[17,"EKEYEXPIRED","","",null,null],[17,"EKEYREVOKED","","",null,null],[17,"EKEYREJECTED","","",null,null],[17,"EOWNERDEAD","","",null,null],[17,"ENOTRECOVERABLE","","",null,null],[17,"EHWPOISON","","",null,null],[17,"ERFKILL","","",null,null],[17,"SOCK_STREAM","","",null,null],[17,"SOCK_DGRAM","","",null,null],[17,"SOCK_SEQPACKET","","",null,null],[17,"SOL_SOCKET","","",null,null],[17,"SO_REUSEADDR","","",null,null],[17,"SO_TYPE","","",null,null],[17,"SO_ERROR","","",null,null],[17,"SO_DONTROUTE","","",null,null],[17,"SO_BROADCAST","","",null,null],[17,"SO_SNDBUF","","",null,null],[17,"SO_RCVBUF","","",null,null],[17,"SO_KEEPALIVE","","",null,null],[17,"SO_OOBINLINE","","",null,null],[17,"SO_LINGER","","",null,null],[17,"SO_REUSEPORT","","",null,null],[17,"SO_ACCEPTCONN","","",null,null],[17,"TCP_COOKIE_TRANSACTIONS","","",null,null],[17,"TCP_THIN_LINEAR_TIMEOUTS","","",null,null],[17,"TCP_THIN_DUPACK","","",null,null],[17,"TCP_USER_TIMEOUT","","",null,null],[17,"TCP_REPAIR","","",null,null],[17,"TCP_REPAIR_QUEUE","","",null,null],[17,"TCP_QUEUE_SEQ","","",null,null],[17,"TCP_REPAIR_OPTIONS","","",null,null],[17,"TCP_FASTOPEN","","",null,null],[17,"TCP_TIMESTAMP","","",null,null],[17,"SA_ONSTACK","","",null,null],[17,"SA_SIGINFO","","",null,null],[17,"SA_NOCLDWAIT","","",null,null],[17,"SIGCHLD","","",null,null],[17,"SIGBUS","","",null,null],[17,"SIGUSR1","","",null,null],[17,"SIGUSR2","","",null,null],[17,"SIGCONT","","",null,null],[17,"SIGSTOP","","",null,null],[17,"SIGTSTP","","",null,null],[17,"SIGURG","","",null,null],[17,"SIGIO","","",null,null],[17,"SIGSYS","","",null,null],[17,"SIGSTKFLT","","",null,null],[17,"SIGUNUSED","","",null,null],[17,"SIGTTIN","","",null,null],[17,"SIGTTOU","","",null,null],[17,"SIGXCPU","","",null,null],[17,"SIGXFSZ","","",null,null],[17,"SIGVTALRM","","",null,null],[17,"SIGPROF","","",null,null],[17,"SIGWINCH","","",null,null],[17,"SIGPOLL","","",null,null],[17,"SIGPWR","","",null,null],[17,"SIG_SETMASK","","",null,null],[17,"SIG_BLOCK","","",null,null],[17,"SIG_UNBLOCK","","",null,null],[17,"SIGEV_THREAD_ID","","",null,null],[17,"POLLRDNORM","","",null,null],[17,"POLLWRNORM","","",null,null],[17,"POLLRDBAND","","",null,null],[17,"POLLWRBAND","","",null,null],[17,"FALLOC_FL_KEEP_SIZE","","",null,null],[17,"FALLOC_FL_PUNCH_HOLE","","",null,null],[17,"BUFSIZ","","",null,null],[17,"TMP_MAX","","",null,null],[17,"FOPEN_MAX","","",null,null],[17,"POSIX_FADV_DONTNEED","","",null,null],[17,"POSIX_FADV_NOREUSE","","",null,null],[17,"POSIX_MADV_DONTNEED","","",null,null],[17,"_SC_2_C_VERSION","","",null,null],[17,"O_ACCMODE","","",null,null],[17,"O_ASYNC","","",null,null],[17,"O_NDELAY","","",null,null],[17,"ST_RELATIME","","",null,null],[17,"NI_MAXHOST","","",null,null],[17,"ADFS_SUPER_MAGIC","","",null,null],[17,"AFFS_SUPER_MAGIC","","",null,null],[17,"CODA_SUPER_MAGIC","","",null,null],[17,"CRAMFS_MAGIC","","",null,null],[17,"EFS_SUPER_MAGIC","","",null,null],[17,"EXT2_SUPER_MAGIC","","",null,null],[17,"EXT3_SUPER_MAGIC","","",null,null],[17,"EXT4_SUPER_MAGIC","","",null,null],[17,"HPFS_SUPER_MAGIC","","",null,null],[17,"HUGETLBFS_MAGIC","","",null,null],[17,"ISOFS_SUPER_MAGIC","","",null,null],[17,"JFFS2_SUPER_MAGIC","","",null,null],[17,"MINIX_SUPER_MAGIC","","",null,null],[17,"MINIX_SUPER_MAGIC2","","",null,null],[17,"MINIX2_SUPER_MAGIC","","",null,null],[17,"MINIX2_SUPER_MAGIC2","","",null,null],[17,"MSDOS_SUPER_MAGIC","","",null,null],[17,"NCP_SUPER_MAGIC","","",null,null],[17,"NFS_SUPER_MAGIC","","",null,null],[17,"OPENPROM_SUPER_MAGIC","","",null,null],[17,"PROC_SUPER_MAGIC","","",null,null],[17,"QNX4_SUPER_MAGIC","","",null,null],[17,"REISERFS_SUPER_MAGIC","","",null,null],[17,"SMB_SUPER_MAGIC","","",null,null],[17,"TMPFS_MAGIC","","",null,null],[17,"USBDEVICE_SUPER_MAGIC","","",null,null],[17,"VEOF","","",null,null],[17,"IUTF8","","",null,null],[17,"CPU_SETSIZE","","",null,null],[17,"QFMT_VFS_V1","","",null,null],[17,"PTRACE_TRACEME","","",null,null],[17,"PTRACE_PEEKTEXT","","",null,null],[17,"PTRACE_PEEKDATA","","",null,null],[17,"PTRACE_PEEKUSER","","",null,null],[17,"PTRACE_POKETEXT","","",null,null],[17,"PTRACE_POKEDATA","","",null,null],[17,"PTRACE_POKEUSER","","",null,null],[17,"PTRACE_CONT","","",null,null],[17,"PTRACE_KILL","","",null,null],[17,"PTRACE_SINGLESTEP","","",null,null],[17,"PTRACE_ATTACH","","",null,null],[17,"PTRACE_DETACH","","",null,null],[17,"PTRACE_SYSCALL","","",null,null],[17,"PTRACE_SETOPTIONS","","",null,null],[17,"PTRACE_GETEVENTMSG","","",null,null],[17,"PTRACE_GETSIGINFO","","",null,null],[17,"PTRACE_SETSIGINFO","","",null,null],[17,"PTRACE_GETREGSET","","",null,null],[17,"PTRACE_SETREGSET","","",null,null],[17,"PTRACE_SEIZE","","",null,null],[17,"PTRACE_INTERRUPT","","",null,null],[17,"PTRACE_LISTEN","","",null,null],[17,"PTRACE_PEEKSIGINFO","","",null,null],[17,"MADV_DODUMP","","",null,null],[17,"MADV_DONTDUMP","","",null,null],[17,"EPOLLWAKEUP","","",null,null],[17,"MADV_HUGEPAGE","","",null,null],[17,"MADV_NOHUGEPAGE","","",null,null],[17,"MAP_HUGETLB","","",null,null],[17,"EFD_NONBLOCK","","",null,null],[17,"F_GETLK","","",null,null],[17,"F_GETOWN","","",null,null],[17,"F_SETOWN","","",null,null],[17,"F_SETLK","","",null,null],[17,"F_SETLKW","","",null,null],[17,"SEEK_DATA","","",null,null],[17,"SEEK_HOLE","","",null,null],[17,"SFD_NONBLOCK","","",null,null],[17,"TCSANOW","","",null,null],[17,"TCSADRAIN","","",null,null],[17,"TCSAFLUSH","","",null,null],[17,"TIOCGSOFTCAR","","",null,null],[17,"TIOCSSOFTCAR","","",null,null],[17,"TIOCLINUX","","",null,null],[17,"TIOCGSERIAL","","",null,null],[17,"TIOCEXCL","","",null,null],[17,"TIOCNXCL","","",null,null],[17,"TIOCSCTTY","","",null,null],[17,"TIOCSTI","","",null,null],[17,"TIOCMGET","","",null,null],[17,"TIOCMBIS","","",null,null],[17,"TIOCMBIC","","",null,null],[17,"TIOCMSET","","",null,null],[17,"TIOCCONS","","",null,null],[17,"RTLD_DEEPBIND","","",null,null],[17,"RTLD_GLOBAL","","",null,null],[17,"RTLD_NOLOAD","","",null,null],[17,"LINUX_REBOOT_MAGIC1","","",null,null],[17,"LINUX_REBOOT_MAGIC2","","",null,null],[17,"LINUX_REBOOT_MAGIC2A","","",null,null],[17,"LINUX_REBOOT_MAGIC2B","","",null,null],[17,"LINUX_REBOOT_MAGIC2C","","",null,null],[17,"LINUX_REBOOT_CMD_RESTART","","",null,null],[17,"LINUX_REBOOT_CMD_HALT","","",null,null],[17,"LINUX_REBOOT_CMD_CAD_ON","","",null,null],[17,"LINUX_REBOOT_CMD_CAD_OFF","","",null,null],[17,"LINUX_REBOOT_CMD_POWER_OFF","","",null,null],[17,"LINUX_REBOOT_CMD_RESTART2","","",null,null],[17,"LINUX_REBOOT_CMD_SW_SUSPEND","","",null,null],[17,"LINUX_REBOOT_CMD_KEXEC","","",null,null],[17,"NETLINK_ROUTE","","",null,null],[17,"NETLINK_UNUSED","","",null,null],[17,"NETLINK_USERSOCK","","",null,null],[17,"NETLINK_FIREWALL","","",null,null],[17,"NETLINK_SOCK_DIAG","","",null,null],[17,"NETLINK_NFLOG","","",null,null],[17,"NETLINK_XFRM","","",null,null],[17,"NETLINK_SELINUX","","",null,null],[17,"NETLINK_ISCSI","","",null,null],[17,"NETLINK_AUDIT","","",null,null],[17,"NETLINK_FIB_LOOKUP","","",null,null],[17,"NETLINK_CONNECTOR","","",null,null],[17,"NETLINK_NETFILTER","","",null,null],[17,"NETLINK_IP6_FW","","",null,null],[17,"NETLINK_DNRTMSG","","",null,null],[17,"NETLINK_KOBJECT_UEVENT","","",null,null],[17,"NETLINK_GENERIC","","",null,null],[17,"NETLINK_SCSITRANSPORT","","",null,null],[17,"NETLINK_ECRYPTFS","","",null,null],[17,"NETLINK_RDMA","","",null,null],[17,"NETLINK_CRYPTO","","",null,null],[17,"NETLINK_INET_DIAG","","",null,null],[17,"MAX_LINKS","","",null,null],[17,"NLM_F_REQUEST","","",null,null],[17,"NLM_F_MULTI","","",null,null],[17,"NLM_F_ACK","","",null,null],[17,"NLM_F_ECHO","","",null,null],[17,"NLM_F_DUMP_INTR","","",null,null],[17,"NLM_F_DUMP_FILTERED","","",null,null],[17,"NLM_F_ROOT","","",null,null],[17,"NLM_F_MATCH","","",null,null],[17,"NLM_F_ATOMIC","","",null,null],[17,"NLM_F_DUMP","","",null,null],[17,"NLM_F_REPLACE","","",null,null],[17,"NLM_F_EXCL","","",null,null],[17,"NLM_F_CREATE","","",null,null],[17,"NLM_F_APPEND","","",null,null],[17,"NLMSG_NOOP","","",null,null],[17,"NLMSG_ERROR","","",null,null],[17,"NLMSG_DONE","","",null,null],[17,"NLMSG_OVERRUN","","",null,null],[17,"NLMSG_MIN_TYPE","","",null,null],[17,"NETLINK_ADD_MEMBERSHIP","","",null,null],[17,"NETLINK_DROP_MEMBERSHIP","","",null,null],[17,"NETLINK_PKTINFO","","",null,null],[17,"NETLINK_BROADCAST_ERROR","","",null,null],[17,"NETLINK_NO_ENOBUFS","","",null,null],[17,"NETLINK_RX_RING","","",null,null],[17,"NETLINK_TX_RING","","",null,null],[17,"NETLINK_LISTEN_ALL_NSID","","",null,null],[17,"NETLINK_LIST_MEMBERSHIPS","","",null,null],[17,"NETLINK_CAP_ACK","","",null,null],[17,"NLA_F_NESTED","","",null,null],[17,"NLA_F_NET_BYTEORDER","","",null,null],[17,"NLA_TYPE_MASK","","",null,null],[17,"PTHREAD_STACK_MIN","","",null,null],[17,"__SIZEOF_PTHREAD_CONDATTR_T","","",null,null],[17,"__SIZEOF_PTHREAD_MUTEX_T","","",null,null],[17,"__SIZEOF_PTHREAD_RWLOCK_T","","",null,null],[17,"__SIZEOF_PTHREAD_MUTEXATTR_T","","",null,null],[17,"PTRACE_GETFPREGS","","",null,null],[17,"PTRACE_SETFPREGS","","",null,null],[17,"PTRACE_GETREGS","","",null,null],[17,"PTRACE_SETREGS","","",null,null],[17,"O_DIRECT","","",null,null],[17,"O_DIRECTORY","","",null,null],[17,"O_NOFOLLOW","","",null,null],[17,"MAP_LOCKED","","",null,null],[17,"MAP_NORESERVE","","",null,null],[17,"EDEADLOCK","","",null,null],[17,"SO_PEERCRED","","",null,null],[17,"SO_RCVLOWAT","","",null,null],[17,"SO_SNDLOWAT","","",null,null],[17,"SO_RCVTIMEO","","",null,null],[17,"SO_SNDTIMEO","","",null,null],[17,"FIOCLEX","","",null,null],[17,"FIONBIO","","",null,null],[17,"SYS_gettid","","",null,null],[17,"SYS_perf_event_open","","",null,null],[17,"PTRACE_GETFPXREGS","","",null,null],[17,"PTRACE_SETFPXREGS","","",null,null],[17,"MCL_CURRENT","","",null,null],[17,"MCL_FUTURE","","",null,null],[17,"SIGSTKSZ","","",null,null],[17,"CBAUD","","",null,null],[17,"TAB1","","",null,null],[17,"TAB2","","",null,null],[17,"TAB3","","",null,null],[17,"CR1","","",null,null],[17,"CR2","","",null,null],[17,"CR3","","",null,null],[17,"FF1","","",null,null],[17,"BS1","","",null,null],[17,"VT1","","",null,null],[17,"VWERASE","","",null,null],[17,"VREPRINT","","",null,null],[17,"VSUSP","","",null,null],[17,"VSTART","","",null,null],[17,"VSTOP","","",null,null],[17,"VDISCARD","","",null,null],[17,"VTIME","","",null,null],[17,"IXON","","",null,null],[17,"IXOFF","","",null,null],[17,"ONLCR","","",null,null],[17,"CSIZE","","",null,null],[17,"CS6","","",null,null],[17,"CS7","","",null,null],[17,"CS8","","",null,null],[17,"CSTOPB","","",null,null],[17,"CREAD","","",null,null],[17,"PARENB","","",null,null],[17,"PARODD","","",null,null],[17,"HUPCL","","",null,null],[17,"CLOCAL","","",null,null],[17,"ECHOKE","","",null,null],[17,"ECHOE","","",null,null],[17,"ECHOK","","",null,null],[17,"ECHONL","","",null,null],[17,"ECHOPRT","","",null,null],[17,"ECHOCTL","","",null,null],[17,"ISIG","","",null,null],[17,"ICANON","","",null,null],[17,"PENDIN","","",null,null],[17,"NOFLSH","","",null,null],[17,"VEOL","","",null,null],[17,"VEOL2","","",null,null],[17,"VMIN","","",null,null],[17,"IEXTEN","","",null,null],[17,"TOSTOP","","",null,null],[17,"FLUSHO","","",null,null],[17,"EXTPROC","","",null,null],[17,"TCGETS","","",null,null],[17,"TCSETS","","",null,null],[17,"TCSETSW","","",null,null],[17,"TCSETSF","","",null,null],[17,"TCGETA","","",null,null],[17,"TCSETA","","",null,null],[17,"TCSETAW","","",null,null],[17,"TCSETAF","","",null,null],[17,"TCSBRK","","",null,null],[17,"TCXONC","","",null,null],[17,"TCFLSH","","",null,null],[17,"TIOCINQ","","",null,null],[17,"TIOCGPGRP","","",null,null],[17,"TIOCSPGRP","","",null,null],[17,"TIOCOUTQ","","",null,null],[17,"TIOCGWINSZ","","",null,null],[17,"TIOCSWINSZ","","",null,null],[17,"FIONREAD","","",null,null]],"paths":[[3,"group"],[3,"utimbuf"],[3,"timeval"],[3,"timespec"],[3,"rlimit"],[3,"rusage"],[3,"in_addr"],[3,"in6_addr"],[3,"ip_mreq"],[3,"ipv6_mreq"],[3,"hostent"],[3,"iovec"],[3,"pollfd"],[3,"winsize"],[3,"linger"],[3,"sigval"],[3,"sockaddr"],[3,"sockaddr_in"],[3,"sockaddr_in6"],[3,"sockaddr_un"],[3,"sockaddr_storage"],[3,"addrinfo"],[3,"sockaddr_nl"],[3,"sockaddr_ll"],[3,"tm"],[3,"sched_param"],[3,"Dl_info"],[3,"epoll_event"],[3,"utsname"],[3,"lconv"],[3,"sigevent"],[3,"dirent"],[3,"dirent64"],[3,"rlimit64"],[3,"glob_t"],[3,"ifaddrs"],[3,"passwd"],[3,"spwd"],[3,"statvfs"],[3,"dqblk"],[3,"signalfd_siginfo"],[3,"mq_attr"],[3,"if_nameindex"],[3,"msginfo"],[3,"aiocb"],[3,"__exit_status"],[3,"__timeval"],[3,"utmpx"],[3,"sigaction"],[3,"stack_t"],[3,"siginfo_t"],[3,"glob64_t"],[3,"ucred"],[3,"statfs"],[3,"msghdr"],[3,"termios"],[3,"flock"],[3,"stat"],[3,"sysinfo"],[3,"ipc_perm"],[3,"stat64"],[3,"shmid_ds"],[3,"msqid_ds"]]};
searchIndex["std"] = {"doc":"# The Rust Standard Library","items":[[0,"any","std","This module implements the `Any` trait, which enables dynamic typing\nof any `&#39;static` type through runtime reflection.",null,null],[8,"Any","std::any","A type to emulate dynamic typing.",null,null],[10,"get_type_id","","Gets the `TypeId` of `self`.",0,null],[3,"TypeId","","A `TypeId` represents a globally unique identifier for a type.",null,null],[0,"cell","std","Shareable mutable containers.",null,null],[3,"Cell","std::cell","A mutable memory location that admits only `Copy` data.",null,null],[3,"RefCell","","A mutable memory location with dynamically checked borrow rules",null,null],[4,"BorrowState","","An enumeration of values returned from the `state` method on a `RefCell&lt;T&gt;`.",null,null],[13,"Reading","","The cell is currently being read, there is at least one active `borrow`.",1,null],[13,"Writing","","The cell is currently being written to, there is an active `borrow_mut`.",1,null],[13,"Unused","","There are no outstanding borrows on this cell.",1,null],[3,"BorrowError","","An error returned by [`RefCell::try_borrow`](struct.RefCell.html#method.try_borrow).",null,null],[3,"BorrowMutError","","An error returned by [`RefCell::try_borrow_mut`](struct.RefCell.html#method.try_borrow_mut).",null,null],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box.\nA wrapper type for an immutably borrowed value from a `RefCell&lt;T&gt;`.",null,null],[3,"RefMut","","A wrapper type for a mutably borrowed value from a `RefCell&lt;T&gt;`.",null,null],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",null,null],[0,"clone","std","The `Clone` trait for types that cannot be &#39;implicitly copied&#39;.",null,null],[8,"Clone","std::clone","A common trait for the ability to explicitly duplicate an object.",null,null],[10,"clone","","Returns a copy of the value.",2,null],[11,"clone_from","","Performs copy-assignment from `source`.",2,null],[0,"cmp","std","Functionality for ordering and comparison.",null,null],[8,"PartialEq","std::cmp","Trait for equality comparisons which are [partial equivalence\nrelations](http://en.wikipedia.org/wiki/Partial_equivalence_relation).",null,null],[10,"eq","","This method tests for `self` and `other` values to be equal, and is used\nby `==`.",3,null],[11,"ne","","This method tests for `!=`.",3,null],[8,"Eq","","Trait for equality comparisons which are [equivalence relations](\nhttps://en.wikipedia.org/wiki/Equivalence_relation).",null,null],[4,"Ordering","","An `Ordering` is the result of a comparison between two values.",null,null],[13,"Less","","An ordering where a compared value is less [than another].",4,null],[13,"Equal","","An ordering where a compared value is equal [to another].",4,null],[13,"Greater","","An ordering where a compared value is greater [than another].",4,null],[8,"Ord","","Trait for types that form a [total order](https://en.wikipedia.org/wiki/Total_order).",null,null],[10,"cmp","","This method returns an `Ordering` between `self` and `other`.",5,null],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",null,null],[10,"partial_cmp","","This method returns an ordering between `self` and `other` values if one exists.",6,null],[11,"lt","","This method tests less than (for `self` and `other`) and is used by the `&lt;` operator.",6,null],[11,"le","","This method tests less than or equal to (for `self` and `other`) and is used by the `&lt;=`\noperator.",6,null],[11,"gt","","This method tests greater than (for `self` and `other`) and is used by the `&gt;` operator.",6,null],[11,"ge","","This method tests greater than or equal to (for `self` and `other`) and is used by the `&gt;=`\noperator.",6,null],[5,"min","","Compare and return the minimum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"max","","Compare and return the maximum of two values.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[0,"convert","std","Traits for conversions between types.",null,null],[8,"AsRef","std::convert","A cheap, reference-to-reference conversion.",null,null],[10,"as_ref","","Performs the conversion.",7,null],[8,"AsMut","","A cheap, mutable reference-to-mutable reference conversion.",null,null],[10,"as_mut","","Performs the conversion.",8,null],[8,"Into","","A conversion that consumes `self`, which may or may not be expensive.",null,null],[10,"into","","Performs the conversion.",9,null],[8,"From","","Construct `Self` via a conversion.",null,null],[10,"from","","Performs the conversion.",10,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"TryInto","","An attempted conversion that consumes `self`, which may or may not be expensive.",null,null],[16,"Err","","The type returned in the event of a conversion error.",11,null],[10,"try_into","","Performs the conversion.",11,null],[8,"TryFrom","","Attempt to construct `Self` via a conversion.",null,null],[16,"Err","","The type returned in the event of a conversion error.",12,null],[10,"try_from","","Performs the conversion.",12,{"inputs":[{"name":"t"}],"output":{"name":"result"}}],[0,"default","std","The `Default` trait for types which may have meaningful default values.",null,null],[8,"Default","std::default","A trait for giving a type a useful default value.",null,null],[10,"default","","Returns the &quot;default value&quot; for a type.",13,{"inputs":[],"output":{"name":"self"}}],[0,"hash","std","Generic hashing support.",null,null],[8,"Hash","std::hash","A hashable type.",null,null],[10,"hash","","Feeds this value into the state given, updating the hasher as necessary.",14,null],[11,"hash_slice","","Feeds a slice of this type into the state provided.",14,null],[8,"Hasher","","A trait which represents the ability to hash an arbitrary stream of bytes.",null,null],[10,"finish","","Completes a round of hashing, producing the output hash generated.",15,null],[10,"write","","Writes some data into this `Hasher`.",15,null],[11,"write_u8","","Write a single `u8` into this hasher.",15,null],[11,"write_u16","","Writes a single `u16` into this hasher.",15,null],[11,"write_u32","","Writes a single `u32` into this hasher.",15,null],[11,"write_u64","","Writes a single `u64` into this hasher.",15,null],[11,"write_usize","","Writes a single `usize` into this hasher.",15,null],[11,"write_i8","","Writes a single `i8` into this hasher.",15,null],[11,"write_i16","","Writes a single `i16` into this hasher.",15,null],[11,"write_i32","","Writes a single `i32` into this hasher.",15,null],[11,"write_i64","","Writes a single `i64` into this hasher.",15,null],[11,"write_isize","","Writes a single `isize` into this hasher.",15,null],[8,"BuildHasher","","A `BuildHasher` is typically used as a factory for instances of `Hasher`\nwhich a `HashMap` can then use to hash keys independently.",null,null],[16,"Hasher","","Type of the hasher that will be created.",16,null],[10,"build_hasher","","Creates a new hasher.",16,null],[3,"BuildHasherDefault","","The `BuildHasherDefault` structure is used in scenarios where one has a\ntype that implements [`Hasher`] and [`Default`], but needs that type to\nimplement [`BuildHasher`].",null,null],[3,"SipHasher","","An implementation of SipHash 2-4.",null,null],[3,"SipHasher24","","An implementation of SipHash 2-4.",null,null],[3,"SipHasher13","","An implementation of SipHash 1-3.",null,null],[0,"intrinsics","std","rustc compiler intrinsics.",null,null],[5,"atomic_cxchg","std::intrinsics","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas both the `success` and `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_acq","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas both the `success` and `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_rel","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_acqrel","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_relaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas both the `success` and `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_failrelaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_failacq","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchg_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange).",null,null],[5,"atomic_cxchgweak","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas both the `success` and `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_acq","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas both the `success` and `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_rel","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_acqrel","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_relaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas both the `success` and `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_failrelaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_failacq","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_acq_failrelaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_cxchgweak_acqrel_failrelaxed","","Stores a value if the current value is the same as the `old` value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `compare_exchange_weak` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `success` and\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `failure` parameters. For example,\n[`AtomicBool::compare_exchange_weak`]\n(../../std/sync/atomic/struct.AtomicBool.html#method.compare_exchange_weak).",null,null],[5,"atomic_load","","Loads the current value of the pointer.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `load` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::load`](../../std/sync/atomic/struct.AtomicBool.html#method.load).",null,null],[5,"atomic_load_acq","","Loads the current value of the pointer.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `load` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::load`](../../std/sync/atomic/struct.AtomicBool.html#method.load).",null,null],[5,"atomic_load_relaxed","","Loads the current value of the pointer.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `load` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::load`](../../std/sync/atomic/struct.AtomicBool.html#method.load).",null,null],[5,"atomic_load_unordered","","",null,null],[5,"atomic_store","","Stores the value at the specified memory location.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `store` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::store`](../../std/sync/atomic/struct.AtomicBool.html#method.store).",null,null],[5,"atomic_store_rel","","Stores the value at the specified memory location.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `store` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::store`](../../std/sync/atomic/struct.AtomicBool.html#method.store).",null,null],[5,"atomic_store_relaxed","","Stores the value at the specified memory location.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `store` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::store`](../../std/sync/atomic/struct.AtomicBool.html#method.store).",null,null],[5,"atomic_store_unordered","","",null,null],[5,"atomic_xchg","","Stores the value at the specified memory location, returning the old value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `swap` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::swap`](../../std/sync/atomic/struct.AtomicBool.html#method.swap).",null,null],[5,"atomic_xchg_acq","","Stores the value at the specified memory location, returning the old value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `swap` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::swap`](../../std/sync/atomic/struct.AtomicBool.html#method.swap).",null,null],[5,"atomic_xchg_rel","","Stores the value at the specified memory location, returning the old value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `swap` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::swap`](../../std/sync/atomic/struct.AtomicBool.html#method.swap).",null,null],[5,"atomic_xchg_acqrel","","Stores the value at the specified memory location, returning the old value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `swap` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::swap`](../../std/sync/atomic/struct.AtomicBool.html#method.swap).",null,null],[5,"atomic_xchg_relaxed","","Stores the value at the specified memory location, returning the old value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `swap` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::swap`](../../std/sync/atomic/struct.AtomicBool.html#method.swap).",null,null],[5,"atomic_xadd","","Add to the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_add` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_add`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_add).",null,null],[5,"atomic_xadd_acq","","Add to the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_add` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_add`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_add).",null,null],[5,"atomic_xadd_rel","","Add to the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_add` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_add`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_add).",null,null],[5,"atomic_xadd_acqrel","","Add to the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_add` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_add`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_add).",null,null],[5,"atomic_xadd_relaxed","","Add to the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_add` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_add`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_add).",null,null],[5,"atomic_xsub","","Subtract from the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_sub` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_sub`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_sub).",null,null],[5,"atomic_xsub_acq","","Subtract from the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_sub` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_sub`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_sub).",null,null],[5,"atomic_xsub_rel","","Subtract from the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_sub` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_sub`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_sub).",null,null],[5,"atomic_xsub_acqrel","","Subtract from the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_sub` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_sub`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_sub).",null,null],[5,"atomic_xsub_relaxed","","Subtract from the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_sub` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicIsize::fetch_sub`](../../std/sync/atomic/struct.AtomicIsize.html#method.fetch_sub).",null,null],[5,"atomic_and","","Bitwise and with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_and` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_and`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_and).",null,null],[5,"atomic_and_acq","","Bitwise and with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_and` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_and`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_and).",null,null],[5,"atomic_and_rel","","Bitwise and with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_and` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_and`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_and).",null,null],[5,"atomic_and_acqrel","","Bitwise and with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_and` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_and`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_and).",null,null],[5,"atomic_and_relaxed","","Bitwise and with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_and` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_and`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_and).",null,null],[5,"atomic_nand","","Bitwise nand with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_nand`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_nand).",null,null],[5,"atomic_nand_acq","","Bitwise nand with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_nand`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_nand).",null,null],[5,"atomic_nand_rel","","Bitwise nand with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_nand`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_nand).",null,null],[5,"atomic_nand_acqrel","","Bitwise nand with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_nand`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_nand).",null,null],[5,"atomic_nand_relaxed","","Bitwise nand with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic::AtomicBool` type via the `fetch_nand` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_nand`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_nand).",null,null],[5,"atomic_or","","Bitwise or with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_or` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_or`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_or).",null,null],[5,"atomic_or_acq","","Bitwise or with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_or` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_or`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_or).",null,null],[5,"atomic_or_rel","","Bitwise or with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_or` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_or`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_or).",null,null],[5,"atomic_or_acqrel","","Bitwise or with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_or` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_or`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_or).",null,null],[5,"atomic_or_relaxed","","Bitwise or with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_or` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_or`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_or).",null,null],[5,"atomic_xor","","Bitwise xor with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_xor` method by passing\n[`Ordering::SeqCst`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_xor`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_xor).",null,null],[5,"atomic_xor_acq","","Bitwise xor with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_xor` method by passing\n[`Ordering::Acquire`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_xor`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_xor).",null,null],[5,"atomic_xor_rel","","Bitwise xor with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_xor` method by passing\n[`Ordering::Release`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_xor`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_xor).",null,null],[5,"atomic_xor_acqrel","","Bitwise xor with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_xor` method by passing\n[`Ordering::AcqRel`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_xor`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_xor).",null,null],[5,"atomic_xor_relaxed","","Bitwise xor with the current value, returning the previous value.\nThe stabilized version of this intrinsic is available on the\n`std::sync::atomic` types via the `fetch_xor` method by passing\n[`Ordering::Relaxed`](../../std/sync/atomic/enum.Ordering.html)\nas the `order`. For example,\n[`AtomicBool::fetch_xor`](../../std/sync/atomic/struct.AtomicBool.html#method.fetch_xor).",null,null],[5,"atomic_max","","",null,null],[5,"atomic_max_acq","","",null,null],[5,"atomic_max_rel","","",null,null],[5,"atomic_max_acqrel","","",null,null],[5,"atomic_max_relaxed","","",null,null],[5,"atomic_min","","",null,null],[5,"atomic_min_acq","","",null,null],[5,"atomic_min_rel","","",null,null],[5,"atomic_min_acqrel","","",null,null],[5,"atomic_min_relaxed","","",null,null],[5,"atomic_umin","","",null,null],[5,"atomic_umin_acq","","",null,null],[5,"atomic_umin_rel","","",null,null],[5,"atomic_umin_acqrel","","",null,null],[5,"atomic_umin_relaxed","","",null,null],[5,"atomic_umax","","",null,null],[5,"atomic_umax_acq","","",null,null],[5,"atomic_umax_rel","","",null,null],[5,"atomic_umax_acqrel","","",null,null],[5,"atomic_umax_relaxed","","",null,null],[5,"atomic_fence","","",null,null],[5,"atomic_fence_acq","","",null,null],[5,"atomic_fence_rel","","",null,null],[5,"atomic_fence_acqrel","","",null,null],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acq","","",null,null],[5,"atomic_singlethreadfence_rel","","",null,null],[5,"atomic_singlethreadfence_acqrel","","",null,null],[5,"rustc_peek","","Magic intrinsic that derives its meaning from attributes\nattached to the function.",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"abort","","Aborts the execution of the process.",null,null],[5,"unreachable","","Tells LLVM that this point in the code is not reachable,\nenabling further optimizations.",null,null],[5,"assume","","Informs the optimizer that a condition is always true.\nIf the condition is false, the behavior is undefined.",null,null],[5,"likely","","Hints to the compiler that branch condition is likely to be true.\nReturns the value passed to it.",null,{"inputs":[{"name":"bool"}],"output":{"name":"bool"}}],[5,"unlikely","","Hints to the compiler that branch condition is likely to be false.\nReturns the value passed to it.",null,{"inputs":[{"name":"bool"}],"output":{"name":"bool"}}],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",null,null],[5,"size_of","","The size of a type in bytes.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"move_val_init","","Moves a value to an uninitialized memory location.",null,null],[5,"min_align_of","","",null,{"inputs":[],"output":{"name":"usize"}}],[5,"pref_align_of","","",null,{"inputs":[],"output":{"name":"usize"}}],[5,"size_of_val","","",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"min_align_of_val","","",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,null],[5,"type_name","","Gets a static string slice containing the name of a type.",null,{"inputs":[],"output":{"name":"str"}}],[5,"type_id","","Gets an identifier which is globally unique to the specified type. This\nfunction will return the same value for a type regardless of whichever\ncrate it is invoked in.",null,{"inputs":[],"output":{"name":"u64"}}],[5,"init","","Creates a value initialized to zero.",null,{"inputs":[],"output":{"name":"t"}}],[5,"uninit","","Creates an uninitialized value.",null,{"inputs":[],"output":{"name":"t"}}],[5,"forget","","Moves a value out of scope without running drop glue.",null,null],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires drop\nglue; returns `false` if the actual type provided for `T`\nimplements `Copy`.",null,{"inputs":[],"output":{"name":"bool"}}],[5,"offset","","Calculates the offset from a pointer.",null,null],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",null,null],[5,"copy_nonoverlapping","","Copies `count * size_of&lt;T&gt;` bytes from `src` to `dst`. The source\nand destination may *not* overlap.",null,null],[5,"copy","","Copies `count * size_of&lt;T&gt;` bytes from `src` to `dst`. The source\nand destination may overlap.",null,null],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::&lt;T&gt;()`\nbytes of memory starting at `dst` to `val`.",null,null],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*` intrinsic, with\na size of `count` * `size_of::&lt;T&gt;()` and an alignment of\n`min_align_of::&lt;T&gt;()`",null,null],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*` intrinsic, with\na size of `count` * `size_of::&lt;T&gt;()` and an alignment of\n`min_align_of::&lt;T&gt;()`",null,null],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*` intrinsic, with a\nsize of `count` * `size_of::&lt;T&gt;()` and an alignment of\n`min_align_of::&lt;T&gt;()`.",null,null],[5,"volatile_load","","Perform a volatile load from the `src` pointer.\nThe stabilized version of this intrinsic is\n[`std::ptr::read_volatile`](../../std/ptr/fn.read_volatile.html).",null,null],[5,"volatile_store","","Perform a volatile store to the `dst` pointer.\nThe stabilized version of this intrinsic is\n[`std::ptr::write_volatile`](../../std/ptr/fn.write_volatile.html).",null,null],[5,"sqrtf32","","Returns the square root of an `f32`",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"sqrtf64","","Returns the square root of an `f64`",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"powif32","","Raises an `f32` to an integer power.",null,{"inputs":[{"name":"f32"},{"name":"i32"}],"output":{"name":"f32"}}],[5,"powif64","","Raises an `f64` to an integer power.",null,{"inputs":[{"name":"f64"},{"name":"i32"}],"output":{"name":"f64"}}],[5,"sinf32","","Returns the sine of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"sinf64","","Returns the sine of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"cosf32","","Returns the cosine of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"cosf64","","Returns the cosine of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"powf32","","Raises an `f32` to an `f32` power.",null,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[5,"powf64","","Raises an `f64` to an `f64` power.",null,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[5,"expf32","","Returns the exponential of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"expf64","","Returns the exponential of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"logf32","","Returns the natural logarithm of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"logf64","","Returns the natural logarithm of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",null,{"inputs":[{"name":"f32"},{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",null,{"inputs":[{"name":"f64"},{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[5,"fabsf32","","Returns the absolute value of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"fabsf64","","Returns the absolute value of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",null,{"inputs":[{"name":"f32"},{"name":"f32"}],"output":{"name":"f32"}}],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",null,{"inputs":[{"name":"f64"},{"name":"f64"}],"output":{"name":"f64"}}],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"ceilf32","","Returns the smallest integer greater than or equal to an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"ceilf64","","Returns the smallest integer greater than or equal to an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"truncf32","","Returns the integer part of an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"truncf64","","Returns the integer part of an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an inexact floating-point exception\nif the argument is not an integer.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an inexact floating-point exception\nif the argument is not an integer.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way cases away from zero.",null,{"inputs":[{"name":"f32"}],"output":{"name":"f32"}}],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way cases away from zero.",null,{"inputs":[{"name":"f64"}],"output":{"name":"f64"}}],[5,"fadd_fast","","Float addition that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"fsub_fast","","Float subtraction that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"fmul_fast","","Float multiplication that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"fdiv_fast","","Float division that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"frem_fast","","Float remainder that allows optimizations based on algebraic rules.\nMay assume inputs are finite.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"ctpop","","Returns the number of bits set in an integer type `T`",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"ctlz","","Returns the number of leading bits unset in an integer type `T`",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"cttz","","Returns the number of trailing bits unset in an integer type `T`",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"bswap","","Reverses the bytes in an integer type `T`.",null,{"inputs":[{"name":"t"}],"output":{"name":"t"}}],[5,"add_with_overflow","","Performs checked integer addition.\nThe stabilized versions of this intrinsic are available on the integer\nprimitives via the `overflowing_add` method. For example,\n[`std::u32::overflowing_add`](../../std/primitive.u32.html#method.overflowing_add)",null,null],[5,"sub_with_overflow","","Performs checked integer subtraction\nThe stabilized versions of this intrinsic are available on the integer\nprimitives via the `overflowing_sub` method. For example,\n[`std::u32::overflowing_sub`](../../std/primitive.u32.html#method.overflowing_sub)",null,null],[5,"mul_with_overflow","","Performs checked integer multiplication\nThe stabilized versions of this intrinsic are available on the integer\nprimitives via the `overflowing_mul` method. For example,\n[`std::u32::overflowing_mul`](../../std/primitive.u32.html#method.overflowing_mul)",null,null],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined behavior\nwhere y = 0 or x = `T::min_value()` and y = -1",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting in\nundefined behavior where y = 0 or x = `T::min_value()` and y = -1",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"overflowing_add","","Returns (a + b) mod 2^N, where N is the width of T in bits.\nThe stabilized versions of this intrinsic are available on the integer\nprimitives via the `wrapping_add` method. For example,\n[`std::u32::wrapping_add`](../../std/primitive.u32.html#method.wrapping_add)",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"overflowing_sub","","Returns (a - b) mod 2^N, where N is the width of T in bits.\nThe stabilized versions of this intrinsic are available on the integer\nprimitives via the `wrapping_sub` method. For example,\n[`std::u32::wrapping_sub`](../../std/primitive.u32.html#method.wrapping_sub)",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"overflowing_mul","","Returns (a * b) mod 2^N, where N is the width of T in bits.\nThe stabilized versions of this intrinsic are available on the integer\nprimitives via the `wrapping_mul` method. For example,\n[`std::u32::wrapping_mul`](../../std/primitive.u32.html#method.wrapping_mul)",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"discriminant_value","","Returns the value of the discriminant for the variant in &#39;v&#39;,\ncast to a `u64`; if `T` has no discriminant, returns 0.",null,{"inputs":[{"name":"t"}],"output":{"name":"u64"}}],[5,"try","","Rust&#39;s &quot;try catch&quot; construct which invokes the function pointer `f` with\nthe data pointer `data`.",null,null],[0,"iter","std","Composable external iteration.",null,null],[3,"Rev","std::iter","An double-ended iterator with the direction inverted.",null,null],[3,"Cloned","","An iterator that clones the elements of an underlying iterator.",null,null],[3,"Cycle","","An iterator that repeats endlessly.",null,null],[3,"Chain","","An iterator that strings two iterators together.",null,null],[3,"Zip","","An iterator that iterates two other iterators simultaneously.",null,null],[3,"Map","","An iterator that maps the values of `iter` with `f`.",null,null],[3,"Filter","","An iterator that filters the elements of `iter` with `predicate`.",null,null],[3,"FilterMap","","An iterator that uses `f` to both filter and map elements from `iter`.",null,null],[3,"Enumerate","","An iterator that yields the current count and the element during iteration.",null,null],[3,"Peekable","","An iterator with a `peek()` that returns an optional reference to the next\nelement.",null,null],[3,"SkipWhile","","An iterator that rejects elements while `predicate` is true.",null,null],[3,"TakeWhile","","An iterator that only accepts elements while `predicate` is true.",null,null],[3,"Skip","","An iterator that skips over `n` elements of `iter`.",null,null],[3,"Take","","An iterator that only iterates over the first `n` iterations of `iter`.",null,null],[3,"Scan","","An iterator to maintain state while iterating another iterator.",null,null],[3,"FlatMap","","An iterator that maps each element to an iterator, and yields the elements\nof the produced iterators.",null,null],[3,"Fuse","","An iterator that yields `None` forever after the underlying iterator\nyields `None` once.",null,null],[3,"Inspect","","An iterator that calls a function with a reference to each element before\nyielding it.",null,null],[3,"Repeat","","An iterator that repeats an element endlessly.",null,null],[3,"Empty","","An iterator that yields nothing.",null,null],[8,"FromIterator","","Conversion from an `Iterator`.",null,null],[10,"from_iter","","Creates a value from an iterator.",17,{"inputs":[{"name":"t"}],"output":{"name":"self"}}],[8,"Sum","","Trait to represent types that can be created by summing up an iterator.",null,null],[10,"sum","","Method which takes an iterator and generates `Self` from the elements by\n&quot;summing up&quot; the items.",18,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[8,"Product","","Trait to represent types that can be created by multiplying elements of an\niterator.",null,null],[10,"product","","Method which takes an iterator and generates `Self` from the elements by\nmultiplying the items.",19,{"inputs":[{"name":"i"}],"output":{"name":"self"}}],[8,"IntoIterator","","Conversion into an `Iterator`.",null,null],[16,"Item","","The type of the elements being iterated over.",20,null],[16,"IntoIter","","Which kind of iterator are we turning this into?",20,null],[10,"into_iter","","Creates an iterator from a value.",20,null],[5,"once","","Creates an iterator that yields an element exactly once.",null,{"inputs":[{"name":"t"}],"output":{"name":"once"}}],[3,"Once","","An iterator that yields an element exactly once.",null,null],[3,"StepBy","","An adapter for stepping range iterators by a custom amount.",null,null],[8,"Step","","Objects that can be stepped over in both directions.",null,null],[10,"step","","Steps `self` if possible.",21,null],[10,"steps_between","","Returns the number of steps between two step objects. The count is\ninclusive of `start` and exclusive of `end`.",21,{"inputs":[{"name":"self"},{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[10,"steps_between_by_one","","Same as `steps_between`, but with a `by` of 1",21,{"inputs":[{"name":"self"},{"name":"self"}],"output":{"name":"option"}}],[10,"is_negative","","Tests whether this step is negative or not (going backwards)",21,null],[10,"replace_one","","Replaces this step with `1`, returning itself",21,null],[10,"replace_zero","","Replaces this step with `0`, returning itself",21,null],[10,"add_one","","Adds one to this step, returning the result",21,null],[10,"sub_one","","Subtracts one to this step, returning the result",21,null],[8,"TrustedLen","","An iterator that reports an accurate length using size_hint.",null,null],[8,"Iterator","","An interface for dealing with iterators.",null,null],[16,"Item","","The type of the elements being iterated over.",22,null],[10,"next","","Advances the iterator and returns the next value.",22,null],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",22,null],[11,"count","","Consumes the iterator, counting the number of iterations and returning it.",22,null],[11,"last","","Consumes the iterator, returning the last element.",22,null],[11,"nth","","Returns the `n`th element of the iterator.",22,null],[11,"chain","","Takes two iterators and creates a new iterator over both in sequence.",22,null],[11,"zip","","&#39;Zips up&#39; two iterators into a single iterator of pairs.",22,null],[11,"map","","Takes a closure and creates an iterator which calls that closure on each\nelement.",22,null],[11,"filter","","Creates an iterator which uses a closure to determine if an element\nshould be yielded.",22,null],[11,"filter_map","","Creates an iterator that both filters and maps.",22,null],[11,"enumerate","","Creates an iterator which gives the current iteration count as well as\nthe next value.",22,null],[11,"peekable","","Creates an iterator which can use `peek` to look at the next element of\nthe iterator without consuming it.",22,null],[11,"skip_while","","Creates an iterator that [`skip()`]s elements based on a predicate.",22,null],[11,"take_while","","Creates an iterator that yields elements based on a predicate.",22,null],[11,"skip","","Creates an iterator that skips the first `n` elements.",22,null],[11,"take","","Creates an iterator that yields its first `n` elements.",22,null],[11,"scan","","An iterator adaptor similar to [`fold()`] that holds internal state and\nproduces a new iterator.",22,null],[11,"flat_map","","Creates an iterator that works like map, but flattens nested structure.",22,null],[11,"fuse","","Creates an iterator which ends after the first [`None`].",22,null],[11,"inspect","","Do something with each element of an iterator, passing the value on.",22,null],[11,"by_ref","","Borrows an iterator, rather than consuming it.",22,null],[11,"collect","","Transforms an iterator into a collection.",22,null],[11,"partition","","Consumes an iterator, creating two collections from it.",22,null],[11,"fold","","An iterator adaptor that applies a function, producing a single, final value.",22,null],[11,"all","","Tests if every element of the iterator matches a predicate.",22,null],[11,"any","","Tests if any element of the iterator matches a predicate.",22,null],[11,"find","","Searches for an element of an iterator that satisfies a predicate.",22,null],[11,"position","","Searches for an element in an iterator, returning its index.",22,null],[11,"rposition","","Searches for an element in an iterator from the right, returning its\nindex.",22,null],[11,"max","","Returns the maximum element of an iterator.",22,null],[11,"min","","Returns the minimum element of an iterator.",22,null],[11,"max_by_key","","Returns the element that gives the maximum value from the\nspecified function.",22,null],[11,"max_by","","Returns the element that gives the maximum value with respect to the\nspecified comparison function.",22,null],[11,"min_by_key","","Returns the element that gives the minimum value from the\nspecified function.",22,null],[11,"min_by","","Returns the element that gives the minimum value with respect to the\nspecified comparison function.",22,null],[11,"rev","","Reverses an iterator&#39;s direction.",22,null],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",22,null],[11,"cloned","","Creates an iterator which [`clone()`]s all of its elements.",22,null],[11,"cycle","","Repeats an iterator endlessly.",22,null],[11,"sum","","Sums the elements of an iterator.",22,null],[11,"product","","Iterates over the entire iterator, multiplying all the elements",22,null],[11,"cmp","","Lexicographically compares the elements of this `Iterator` with those\nof another.",22,null],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator` with those\nof another.",22,null],[11,"eq","","Determines if the elements of this `Iterator` are equal to those of\nanother.",22,null],[11,"ne","","Determines if the elements of this `Iterator` are unequal to those of\nanother.",22,null],[11,"lt","","Determines if the elements of this `Iterator` are lexicographically\nless than those of another.",22,null],[11,"le","","Determines if the elements of this `Iterator` are lexicographically\nless or equal to those of another.",22,null],[11,"gt","","Determines if the elements of this `Iterator` are lexicographically\ngreater than those of another.",22,null],[11,"ge","","Determines if the elements of this `Iterator` are lexicographically\ngreater than or equal to those of another.",22,null],[5,"empty","","Creates an iterator that yields nothing.",null,{"inputs":[],"output":{"name":"empty"}}],[5,"repeat","","Creates a new iterator that endlessly repeats a single element.",null,{"inputs":[{"name":"t"}],"output":{"name":"repeat"}}],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",null,null],[10,"next_back","","Removes and returns an element from the end of the iterator.",23,null],[8,"Extend","","Extend a collection with the contents of an iterator.",null,null],[10,"extend","","Extends a collection with the contents of an iterator.",24,null],[8,"ExactSizeIterator","","An iterator that knows its exact length.",null,null],[11,"len","","Returns the exact number of times the iterator will iterate.",25,null],[11,"is_empty","","Returns whether the iterator is empty.",25,null],[8,"FusedIterator","","An iterator that always continues to yield `None` when exhausted.",null,null],[0,"marker","std","Primitive traits and types representing basic properties of types.",null,null],[8,"Send","std::marker","Types that can be transferred across thread boundaries.",null,null],[8,"Sized","","Types with a constant size known at compile time.",null,null],[8,"Unsize","","Types that can be &quot;unsized&quot; to a dynamically-sized type.",null,null],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",null,null],[8,"Sync","","Types for which it is safe to share references between threads.",null,null],[3,"PhantomData","","Zero-sized type used to mark things that &quot;act like&quot; they own a `T`.",null,null],[8,"Reflect","","Types that can be reflected over.",null,null],[0,"mem","std","Basic functions for dealing with memory.",null,null],[5,"forget","std::mem","Leaks a value: takes ownership and &quot;forgets&quot; about the value **without running\nits destructor**.",null,null],[5,"size_of","","Returns the size of a type in bytes.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",null,{"inputs":[],"output":{"name":"usize"}}],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type of the value that `val` points to.",null,{"inputs":[{"name":"t"}],"output":{"name":"usize"}}],[5,"zeroed","","Creates a value whose bytes are all zero.",null,{"inputs":[],"output":{"name":"t"}}],[5,"uninitialized","","Bypasses Rust&#39;s normal memory-initialization checks by pretending to\nproduce a value of type `T`, while doing nothing at all.",null,{"inputs":[],"output":{"name":"t"}}],[5,"swap","","Swaps the values at two mutable locations, without deinitializing either one.",null,null],[5,"replace","","Replaces the value at a mutable location with a new one, returning the old value, without\ndeinitializing either one.",null,{"inputs":[{"name":"t"},{"name":"t"}],"output":{"name":"t"}}],[5,"drop","","Disposes of a value.",null,null],[5,"transmute_copy","","Interprets `src` as having type `&amp;U`, and then reads `src` without moving\nthe contained value.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[3,"Discriminant","","Opaque type representing the discriminant of an enum.",null,null],[5,"discriminant","","Returns a value uniquely identifying the enum variant in `v`.",null,{"inputs":[{"name":"t"}],"output":{"name":"discriminant"}}],[5,"transmute","","Reinterprets the bits of a value of one type as another type.",null,{"inputs":[{"name":"t"}],"output":{"name":"u"}}],[0,"ops","std","Overloadable operators.",null,null],[8,"Drop","std::ops","The `Drop` trait is used to run some code when a value goes out of scope.\nThis is sometimes called a &#39;destructor&#39;.",null,null],[10,"drop","","A method called when the value goes out of scope.",26,null],[8,"Add","","The `Add` trait is used to specify the functionality of `+`.",null,null],[16,"Output","","The resulting type after applying the `+` operator",27,null],[10,"add","","The method for the `+` operator",27,null],[8,"Sub","","The `Sub` trait is used to specify the functionality of `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator",28,null],[10,"sub","","The method for the `-` operator",28,null],[8,"Mul","","The `Mul` trait is used to specify the functionality of `*`.",null,null],[16,"Output","","The resulting type after applying the `*` operator",29,null],[10,"mul","","The method for the `*` operator",29,null],[8,"Div","","The `Div` trait is used to specify the functionality of `/`.",null,null],[16,"Output","","The resulting type after applying the `/` operator",30,null],[10,"div","","The method for the `/` operator",30,null],[8,"Rem","","The `Rem` trait is used to specify the functionality of `%`.",null,null],[16,"Output","","The resulting type after applying the `%` operator",31,null],[10,"rem","","The method for the `%` operator",31,null],[8,"Neg","","The `Neg` trait is used to specify the functionality of unary `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator",32,null],[10,"neg","","The method for the unary `-` operator",32,null],[8,"Not","","The `Not` trait is used to specify the functionality of unary `!`.",null,null],[16,"Output","","The resulting type after applying the `!` operator",33,null],[10,"not","","The method for the unary `!` operator",33,null],[8,"BitAnd","","The `BitAnd` trait is used to specify the functionality of `&amp;`.",null,null],[16,"Output","","The resulting type after applying the `&amp;` operator",34,null],[10,"bitand","","The method for the `&amp;` operator",34,null],[8,"BitOr","","The `BitOr` trait is used to specify the functionality of `|`.",null,null],[16,"Output","","The resulting type after applying the `|` operator",35,null],[10,"bitor","","The method for the `|` operator",35,null],[8,"BitXor","","The `BitXor` trait is used to specify the functionality of `^`.",null,null],[16,"Output","","The resulting type after applying the `^` operator",36,null],[10,"bitxor","","The method for the `^` operator",36,null],[8,"Shl","","The `Shl` trait is used to specify the functionality of `&lt;&lt;`.",null,null],[16,"Output","","The resulting type after applying the `&lt;&lt;` operator",37,null],[10,"shl","","The method for the `&lt;&lt;` operator",37,null],[8,"Shr","","The `Shr` trait is used to specify the functionality of `&gt;&gt;`.",null,null],[16,"Output","","The resulting type after applying the `&gt;&gt;` operator",38,null],[10,"shr","","The method for the `&gt;&gt;` operator",38,null],[8,"AddAssign","","The `AddAssign` trait is used to specify the functionality of `+=`.",null,null],[10,"add_assign","","The method for the `+=` operator",39,null],[8,"SubAssign","","The `SubAssign` trait is used to specify the functionality of `-=`.",null,null],[10,"sub_assign","","The method for the `-=` operator",40,null],[8,"MulAssign","","The `MulAssign` trait is used to specify the functionality of `*=`.",null,null],[10,"mul_assign","","The method for the `*=` operator",41,null],[8,"DivAssign","","The `DivAssign` trait is used to specify the functionality of `/=`.",null,null],[10,"div_assign","","The method for the `/=` operator",42,null],[8,"RemAssign","","The `RemAssign` trait is used to specify the functionality of `%=`.",null,null],[10,"rem_assign","","The method for the `%=` operator",43,null],[8,"BitAndAssign","","The `BitAndAssign` trait is used to specify the functionality of `&amp;=`.",null,null],[10,"bitand_assign","","The method for the `&amp;=` operator",44,null],[8,"BitOrAssign","","The `BitOrAssign` trait is used to specify the functionality of `|=`.",null,null],[10,"bitor_assign","","The method for the `|=` operator",45,null],[8,"BitXorAssign","","The `BitXorAssign` trait is used to specify the functionality of `^=`.",null,null],[10,"bitxor_assign","","The method for the `^=` operator",46,null],[8,"ShlAssign","","The `ShlAssign` trait is used to specify the functionality of `&lt;&lt;=`.",null,null],[10,"shl_assign","","The method for the `&lt;&lt;=` operator",47,null],[8,"ShrAssign","","The `ShrAssign` trait is used to specify the functionality of `&gt;&gt;=`.",null,null],[10,"shr_assign","","The method for the `&gt;&gt;=` operator",48,null],[8,"Index","","The `Index` trait is used to specify the functionality of indexing operations\nlike `container[index]` when used in an immutable context.",null,null],[16,"Output","","The returned type after indexing",49,null],[10,"index","","The method for the indexing (`container[index]`) operation",49,null],[8,"IndexMut","","The `IndexMut` trait is used to specify the functionality of indexing\noperations like `container[index]` when used in a mutable context.",null,null],[10,"index_mut","","The method for the mutable indexing (`container[index]`) operation",50,null],[3,"RangeFull","","An unbounded range. Use `..` (two dots) for its shorthand.",null,null],[3,"Range","","A (half-open) range which is bounded at both ends: { x | start &lt;= x &lt; end }.\nUse `start..end` (two dots) for its shorthand.",null,null],[12,"start","","The lower bound of the range (inclusive).",51,null],[12,"end","","The upper bound of the range (exclusive).",51,null],[3,"RangeFrom","","A range which is only bounded below: { x | start &lt;= x }.\nUse `start..` for its shorthand.",null,null],[12,"start","","The lower bound of the range (inclusive).",52,null],[3,"RangeTo","","A range which is only bounded above: { x | x &lt; end }.\nUse `..end` (two dots) for its shorthand.",null,null],[12,"end","","The upper bound of the range (exclusive).",53,null],[4,"RangeInclusive","","An inclusive range which is bounded at both ends: { x | start &lt;= x &lt;= end }.\nUse `start...end` (three dots) for its shorthand.",null,null],[13,"Empty","","Empty range (iteration has finished)",54,null],[12,"at","std::ops::RangeInclusive","The point at which iteration finished",54,null],[13,"NonEmpty","std::ops","Non-empty range (iteration will yield value(s))",54,null],[12,"start","std::ops::RangeInclusive","The lower bound of the range (inclusive).",54,null],[12,"end","","The upper bound of the range (inclusive).",54,null],[3,"RangeToInclusive","std::ops","An inclusive range which is only bounded above: { x | x &lt;= end }.\nUse `...end` (three dots) for its shorthand.",null,null],[12,"end","","The upper bound of the range (inclusive)",55,null],[8,"Deref","","The `Deref` trait is used to specify the functionality of dereferencing\noperations, like `*v`.",null,null],[16,"Target","","The resulting type after dereferencing",56,null],[10,"deref","","The method called to dereference a value",56,null],[8,"DerefMut","","The `DerefMut` trait is used to specify the functionality of dereferencing\nmutably like `*v = 1;`",null,null],[10,"deref_mut","","The method called to mutably dereference a value",57,null],[8,"Fn","","A version of the call operator that takes an immutable receiver.",null,null],[10,"call","","This is called when the call operator is used.",58,null],[8,"FnMut","","A version of the call operator that takes a mutable receiver.",null,null],[10,"call_mut","","This is called when the call operator is used.",59,null],[8,"FnOnce","","A version of the call operator that takes a by-value receiver.",null,null],[16,"Output","","The returned type after the call operator is used.",60,null],[10,"call_once","","This is called when the call operator is used.",60,null],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper for one,\nwhere unsizing can be performed on the pointee.",null,null],[8,"Place","","Both `in (PLACE) EXPR` and `box EXPR` desugar into expressions\nthat allocate an intermediate &quot;place&quot; that holds uninitialized\nstate.  The desugaring evaluates EXPR, and writes the result at\nthe address returned by the `pointer` method of this trait.",null,null],[10,"pointer","","Returns the address where the input value will be written.\nNote that the data at this address is generally uninitialized,\nand thus one should use `ptr::write` for initializing it.",61,null],[8,"Placer","","Interface to implementations of  `in (PLACE) EXPR`.",null,null],[16,"Place","","`Place` is the intermedate agent guarding the\nuninitialized state for `Data`.",62,null],[10,"make_place","","Creates a fresh place from `self`.",62,null],[8,"InPlace","","Specialization of `Place` trait supporting `in (PLACE) EXPR`.",null,null],[16,"Owner","","`Owner` is the type of the end value of `in (PLACE) EXPR`",63,null],[10,"finalize","","Converts self into the final value, shifting\ndeallocation/cleanup responsibilities (if any remain), over to\nthe returned instance of `Owner` and forgetting self.",63,null],[8,"Boxed","","Core trait for the `box EXPR` form.",null,null],[16,"Data","","The kind of data that is stored in this kind of box.",64,null],[16,"Place","","The place that will negotiate the storage of the data.",64,null],[10,"finalize","","Converts filled place into final owning value, shifting\ndeallocation/cleanup responsibilities (if any remain), over to\nreturned instance of `Self` and forgetting `filled`.",64,null],[8,"BoxPlace","","Specialization of `Place` trait supporting `box EXPR`.",null,null],[10,"make_place","","Creates a globally fresh place.",65,{"inputs":[],"output":{"name":"self"}}],[8,"Carrier","","A trait for types which have success and error states and are meant to work\nwith the question mark operator.\nWhen the `?` operator is used with a value, whether the value is in the\nsuccess or error state is determined by calling `translate`.",null,null],[16,"Success","","The type of the value when computation succeeds.",66,null],[16,"Error","","The type of the value when computation errors out.",66,null],[10,"from_success","","Create a `Carrier` from a success value.",66,null],[10,"from_error","","Create a `Carrier` from an error value.",66,null],[10,"translate","","Translate this `Carrier` to another implementation of `Carrier` with the\nsame associated types.",66,null],[0,"ptr","std","Raw, unsafe pointers, `*const T`, and `*mut T`.",null,null],[5,"null","std::ptr","Creates a null raw pointer.",null,null],[5,"null_mut","","Creates a null mutable raw pointer.",null,null],[5,"swap","","Swaps the values at two mutable locations of the same type, without\ndeinitializing either. They may overlap, unlike `mem::swap` which is\notherwise equivalent.",null,null],[5,"replace","","Replaces the value at `dest` with `src`, returning the old\nvalue, without dropping either.",null,null],[5,"read","","Reads the value from `src` without moving it. This leaves the\nmemory in `src` unchanged.",null,null],[5,"read_unaligned","","Reads the value from `src` without moving it. This leaves the\nmemory in `src` unchanged.",null,null],[5,"write","","Overwrites a memory location with the given value without reading or\ndropping the old value.",null,null],[5,"write_unaligned","","Overwrites a memory location with the given value without reading or\ndropping the old value.",null,null],[5,"read_volatile","","Performs a volatile read of the value from `src` without moving it. This\nleaves the memory in `src` unchanged.",null,null],[5,"write_volatile","","Performs a volatile write of a memory location with the given value without\nreading or dropping the old value.",null,null],[5,"eq","","Compare raw pointers for equality.",null,null],[3,"Unique","","A wrapper around a raw non-null `*mut T` that indicates that the possessor\nof this wrapper owns the referent. This in turn implies that the\n`Unique&lt;T&gt;` is `Send`/`Sync` if `T` is `Send`/`Sync`, unlike a raw\n`*mut T` (which conveys no particular ownership semantics).  It\nalso implies that the referent of the pointer should not be\nmodified without a unique path to the `Unique` reference. Useful\nfor building abstractions like `Vec&lt;T&gt;` or `Box&lt;T&gt;`, which\ninternally use raw pointers to manage the memory that they own.",null,null],[3,"Shared","","A wrapper around a raw non-null `*mut T` that indicates that the possessor\nof this wrapper has shared ownership of the referent. Useful for\nbuilding abstractions like `Rc&lt;T&gt;` or `Arc&lt;T&gt;`, which internally\nuse raw pointers to manage the memory that they own.",null,null],[5,"copy_nonoverlapping","","Copies `count * size_of&lt;T&gt;` bytes from `src` to `dst`. The source\nand destination may *not* overlap.",null,null],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,null],[5,"copy","","Copies `count * size_of&lt;T&gt;` bytes from `src` to `dst`. The source\nand destination may overlap.",null,null],[5,"write_bytes","","Invokes memset on the specified pointer, setting `count * size_of::&lt;T&gt;()`\nbytes of memory starting at `dst` to `val`.",null,null],[0,"raw","std","Contains struct definitions for the layout of compiler built-in types.",null,null],[3,"TraitObject","std::raw","The representation of a trait object like `&amp;SomeTrait`.",null,null],[12,"data","","",67,null],[12,"vtable","","",67,null],[0,"result","std","Error handling with the `Result` type.",null,null],[4,"Result","std::result","`Result` is a type that represents either success (`Ok`) or failure (`Err`).",null,null],[13,"Ok","","Contains the success value",68,null],[13,"Err","","Contains the error value",68,null],[3,"Iter","","An iterator over a reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Ok`] variant of a [`Result`].",null,null],[3,"IntoIter","","An iterator over the value in a [`Ok`] variant of a [`Result`]. This struct is\ncreated by the [`into_iter`] method on [`Result`][`Result`] (provided by\nthe [`IntoIterator`] trait).",null,null],[0,"option","std","Optional values.",null,null],[4,"Option","std::option","The `Option` type. See [the module level documentation](index.html) for more.",null,null],[13,"None","","No value",69,null],[13,"Some","","Some value `T`",69,null],[3,"Iter","","An iterator over a reference of the contained item in an [`Option`].",null,null],[3,"IterMut","","An iterator over a mutable reference of the contained item in an [`Option`].",null,null],[3,"IntoIter","","An iterator over the item contained inside an [`Option`].",null,null],[0,"isize","std","The pointer-sized signed integer type.",null,null],[17,"MIN","std::isize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i8","std","The 8-bit signed integer type.",null,null],[17,"MIN","std::i8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i16","std","The 16-bit signed integer type.",null,null],[17,"MIN","std::i16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i32","std","The 32-bit signed integer type.",null,null],[17,"MIN","std::i32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"i64","std","The 64-bit signed integer type.",null,null],[17,"MIN","std::i64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"usize","std","The pointer-sized unsigned integer type.",null,null],[17,"MIN","std::usize","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u8","std","The 8-bit unsigned integer type.",null,null],[17,"MIN","std::u8","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u16","std","The 16-bit unsigned integer type.",null,null],[17,"MIN","std::u16","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u32","std","The 32-bit unsigned integer type.",null,null],[17,"MIN","std::u32","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"u64","std","The 64-bit unsigned integer type.",null,null],[17,"MIN","std::u64","The smallest value that can be represented by this integer type.",null,null],[17,"MAX","","The largest value that can be represented by this integer type.",null,null],[0,"boxed","std","A pointer type for heap allocation.",null,null],[17,"HEAP","std::boxed","A value that represents the heap. This is the default place that the `box`\nkeyword allocates into when no place is supplied.",null,null],[3,"ExchangeHeapSingleton","","This the singleton type used solely for `boxed::HEAP`.",null,null],[3,"Box","","A pointer type for heap allocation.",null,null],[3,"IntermediateBox","","`IntermediateBox` represents uninitialized backing storage for `Box`.",null,null],[8,"FnBox","","`FnBox` is a version of the `FnOnce` intended for use with boxed\nclosure objects. The idea is that where one would normally store a\n`Box&lt;FnOnce()&gt;` in a data structure, you should use\n`Box&lt;FnBox()&gt;`. The two traits behave essentially the same, except\nthat a `FnBox` closure can only be called if it is boxed. (Note\nthat `FnBox` may be deprecated in the future if `Box&lt;FnOnce()&gt;`\nclosures become directly usable.)",null,null],[16,"Output","","",70,null],[10,"call_box","","",70,null],[0,"rc","std","Single-threaded reference-counting pointers.",null,null],[3,"Rc","std::rc","A single-threaded reference-counting pointer.",null,null],[3,"Weak","","A weak version of [`Rc`][rc].",null,null],[0,"borrow","std","A module for working with borrowed data.",null,null],[8,"ToOwned","std::borrow","A generalization of `Clone` to borrowed data.",null,null],[16,"Owned","","",71,null],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",71,null],[4,"Cow","","A clone-on-write smart pointer.",null,null],[13,"Borrowed","","Borrowed data.",72,null],[13,"Owned","","Owned data.",72,null],[8,"Borrow","","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",73,null],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",74,null],[0,"fmt","std","Utilities for formatting and printing `String`s",null,null],[5,"format","std::fmt","The format function takes a precompiled format string and a list of\narguments, to return the resulting formatted string.",null,{"inputs":[{"name":"arguments"}],"output":{"name":"string"}}],[8,"UpperExp","","Format trait for the `E` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",75,null],[8,"LowerHex","","Format trait for the `x` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",76,null],[8,"UpperHex","","Format trait for the `X` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",77,null],[8,"Pointer","","Format trait for the `p` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",78,null],[5,"write","","The `write` function takes an output stream, a precompiled format string,\nand a list of arguments. The arguments will be formatted according to the\nspecified format string into the output stream provided.",null,{"inputs":[{"name":"write"},{"name":"arguments"}],"output":{"name":"result"}}],[8,"Write","","A collection of methods that are required to format a message into a stream.",null,null],[10,"write_str","","Writes a slice of bytes into this writer, returning whether the write\nsucceeded.",79,null],[11,"write_char","","Writes a `char` into this writer, returning whether the write succeeded.",79,null],[11,"write_fmt","","Glue for usage of the `write!` macro with implementors of this trait.",79,null],[8,"Octal","","Format trait for the `o` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",80,null],[8,"Binary","","Format trait for the `b` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",81,null],[6,"Result","","The type returned by formatter methods.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[8,"Debug","","Format trait for the `?` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",82,null],[3,"Formatter","","A struct to represent both where to emit formatting strings to and how they\nshould be formatted. A mutable version of this is passed to all formatting\ntraits.",null,null],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"Error","","The error type which is returned from formatting a message into a stream.",null,null],[3,"Arguments","","This structure represents a safely precompiled version of a format string\nand its arguments. This cannot be generated at runtime because it cannot\nsafely be done so, so no constructors are given and the fields are private\nto prevent modification.",null,null],[8,"LowerExp","","Format trait for the `e` character.",null,null],[10,"fmt","","Formats the value using the given formatter.",83,null],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",84,null],[0,"slice","std","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[8,"SliceConcatExt","std::slice","An extension trait for concatenating slices",null,null],[16,"Output","","The resulting type after concatenation",85,null],[10,"concat","","Flattens a slice of `T` into a single value `Self::Output`.",85,null],[10,"join","","Flattens a slice of `T` into a single value `Self::Output`, placing a\ngiven separator between each.",85,null],[10,"connect","","",85,null],[3,"Iter","","Immutable slice iterator",null,null],[5,"from_raw_parts_mut","","Performs the same functionality as `from_raw_parts`, except that a mutable\nslice is returned.",null,null],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks (`size` elements at a\ntime).",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that match a\npredicate function, limited to a given number of splits, starting\nfrom the end of the slice.",null,null],[8,"SliceIndex","","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",86,null],[10,"get","","Returns a shared reference to the output at this location, if in\nbounds.",86,null],[10,"get_mut","","Returns a mutable reference to the output at this location, if in\nbounds.",86,null],[10,"get_unchecked","","Returns a shared reference to the output at this location, without\nperforming any bounds checking.",86,null],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this location, without\nperforming any bounds checking.",86,null],[10,"index","","Returns a shared reference to the output at this location, panicking\nif out of bounds.",86,null],[10,"index_mut","","Returns a mutable reference to the output at this location, panicking\nif out of bounds.",86,null],[3,"RSplitN","","An iterator over subslices separated by elements that match a\npredicate function, limited to a given number of splits, starting\nfrom the end of the slice.",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that match a predicate\nfunction, limited to a given number of splits.",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable chunks (`size`\nelements at a time). When the slice len is not evenly divided by the chunk\nsize, the last slice of the iteration will be the remainder.",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,null],[3,"SplitMut","","An iterator over the subslices of the vector which are separated\nby elements that match `pred`.",null,null],[3,"Split","","An iterator over subslices separated by elements that match a predicate\nfunction.",null,null],[3,"SplitN","","An iterator over subslices separated by elements that match a predicate\nfunction, limited to a given number of splits.",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[0,"str","std","Unicode string slices.",null,null],[3,"EncodeUtf16","std::str","External iterator for a string&#39;s UTF-16 code units.",null,null],[3,"Matches","","Created with the method [`matches()`].",null,null],[3,"RMatches","","Created with the method [`rmatches()`].",null,null],[3,"Lines","","Created with the method [`lines()`].",null,null],[3,"LinesAny","","Created with the method [`lines_any()`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn()`].",null,null],[0,"pattern","","The string Pattern API.",null,null],[8,"Pattern","std::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",87,null],[10,"into_searcher","","Constructs the associated searcher from\n`self` and the `haystack` to search in.",87,null],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",87,null],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",87,null],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",87,null],[4,"SearchStep","","Result of calling `Searcher::next()` or `ReverseSearcher::next_back()`.",null,null],[13,"Match","","Expresses that a match of the pattern has been found at\n`haystack[a..b]`.",88,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a possible match\nof the pattern.",88,null],[13,"Done","","Expresses that every byte of the haystack has been visted, ending\nthe iteration.",88,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlaying string to be searched in",89,null],[10,"next","","Performs the next search step starting from the front.",89,null],[11,"next_match","","Find the next `Match` result. See `next()`",89,null],[11,"next_reject","","Find the next `Reject` result. See `next()`",89,null],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",90,null],[11,"next_match_back","","Find the next `Match` result. See `next_back()`",90,null],[11,"next_reject_back","","Find the next `Reject` result. See `next_back()`",90,null],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher`\ncan be used for a `DoubleEndedIterator` implementation.",null,null],[3,"CharSearcher","","Associated type for `&lt;char as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `&lt;&amp;[char] as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `&lt;F as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `&lt;&amp;str as Pattern&lt;&#39;a&gt;&gt;::Searcher`.",null,null],[3,"RSplit","std::str","Created with the method [`rsplit()`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator()`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator()`].",null,null],[3,"Chars","","Iterator for the char (representing *Unicode Scalar Values*) of a string",null,null],[3,"CharIndices","","Iterator for a string&#39;s characters and their byte offsets.",null,null],[3,"Bytes","","External iterator for a string&#39;s bytes.\nUse with the `std::iter` module.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without checking\nthat the string contains valid UTF-8.",null,null],[3,"SplitN","","Created with the method [`splitn()`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices()`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices()`].",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a string,\nseparated by any amount of whitespace.",null,null],[8,"FromStr","","A trait to abstract the idea of creating a new instance of a type from a\nstring.",null,null],[16,"Err","","The associated error which can be returned from parsing.",91,null],[10,"from_str","","Parses a string `s` to return a value of this type.",91,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[3,"Utf8Error","","Errors which can occur when attempting to interpret a sequence of `u8`\nas a string.",null,null],[3,"ParseBoolError","","An error returned when parsing a `bool` from a string fails.",null,null],[3,"Split","","Created with the method [`split()`].",null,null],[0,"string","std","A UTF-8 encoded, growable string.",null,null],[3,"String","std::string","A UTF-8 encoded, growable string.",null,null],[3,"FromUtf8Error","","A possible error value when converting a `String` from a UTF-8 byte vector.",null,null],[3,"FromUtf16Error","","A possible error value when converting a `String` from a UTF-16 byte slice.",null,null],[4,"ParseError","","An error when parsing a `String`.",null,null],[8,"ToString","","A trait for converting a value to a `String`.",null,null],[10,"to_string","","Converts the given value to a `String`.",92,null],[3,"Drain","","A draining iterator for `String`.",null,null],[0,"vec","std","A contiguous growable array type with heap-allocated contents, written\n`Vec&lt;T&gt;` but pronounced &#39;vector.&#39;",null,null],[3,"Vec","std::vec","A contiguous growable array type, written `Vec&lt;T&gt;` but pronounced &#39;vector&#39;.",null,null],[3,"IntoIter","","An iterator that moves out of a vector.",null,null],[3,"Drain","","A draining iterator for `Vec&lt;T&gt;`.",null,null],[0,"char","std","A character type.",null,null],[3,"ToLowercase","std::char","Returns an iterator that yields the lowercase equivalent of a `char`.",null,null],[3,"ToUppercase","","Returns an iterator that yields the uppercase equivalent of a `char`.",null,null],[3,"DecodeUtf16","","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",null,null],[3,"DecodeUtf16Error","","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",null,null],[5,"decode_utf16","","Create an iterator over the UTF-16 encoded code points in `iter`,\nreturning unpaired surrogates as `Err`s.",null,{"inputs":[{"name":"i"}],"output":{"name":"decodeutf16"}}],[17,"REPLACEMENT_CHARACTER","","`U+FFFD REPLACEMENT CHARACTER` (�) is used in Unicode to represent a\ndecoding error.",null,null],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode escape of a\ncharacter, as `char`s.",null,null],[5,"decode_utf8","","Decodes an `Iterator` of bytes as UTF-8.",null,{"inputs":[{"name":"i"}],"output":{"name":"decodeutf8"}}],[3,"EscapeDebug","","An iterator that yields the literal escape code of a `char`.",null,null],[5,"from_digit","","Converts a digit in the given radix to a `char`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",null,{"inputs":[{"name":"u32"}],"output":{"name":"char"}}],[5,"from_u32","","Converts a `u32` to a `char`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"option"}}],[3,"CharTryFromError","","The error type returned when a conversion from u32 to char fails.",null,null],[17,"UNICODE_VERSION","","The version of [Unicode](http://www.unicode.org/)\nthat the unicode parts of `CharExt` and `UnicodeStrPrelude` traits are based on.",null,null],[3,"DecodeUtf8","","An iterator over an iterator of bytes of the characters the bytes represent\nas UTF-8",null,null],[17,"MAX","","The highest valid code point a `char` can have.",null,null],[0,"prelude","std","The Rust Prelude.",null,null],[0,"v1","std::prelude","The first version of the prelude of The Rust Standard Library.",null,null],[0,"f32","std","The 32-bit floating point type.",null,null],[17,"RADIX","std::f32","The radix or base of the internal representation of `f32`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","Difference between `1.0` and the next largest representable number.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[17,"MIN","","Smallest finite `f32` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f32` value.",null,null],[17,"MAX","","Largest finite `f32` value.",null,null],[0,"consts","","Basic mathematical constants.",null,null],[17,"PI","std::f32::consts","Archimedes&#39; constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler&#39;s number (e)",null,null],[17,"LOG2_E","","log&lt;sub&gt;2&lt;/sub&gt;(e)",null,null],[17,"LOG10_E","","log&lt;sub&gt;10&lt;/sub&gt;(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[0,"f64","std","The 64-bit floating point type.",null,null],[17,"RADIX","std::f64","The radix or base of the internal representation of `f64`.",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2.",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10.",null,null],[17,"EPSILON","","Difference between `1.0` and the next largest representable number.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 exponent.",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent.",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent.",null,null],[17,"NAN","","Not a Number (NaN).",null,null],[17,"INFINITY","","Infinity (∞).",null,null],[17,"NEG_INFINITY","","Negative infinity (-∞).",null,null],[17,"MIN","","Smallest finite `f64` value.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f64` value.",null,null],[17,"MAX","","Largest finite `f64` value.",null,null],[0,"consts","","Basic mathematical constants.",null,null],[17,"PI","std::f64::consts","Archimedes&#39; constant (π)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler&#39;s number (e)",null,null],[17,"LOG2_E","","log&lt;sub&gt;2&lt;/sub&gt;(e)",null,null],[17,"LOG10_E","","log&lt;sub&gt;10&lt;/sub&gt;(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[0,"thread","std","Native threads.",null,null],[3,"LocalKey","std::thread","A thread local storage key which owns its contents.",null,null],[3,"Builder","","Thread configuration. Provides detailed control over the properties\nand behavior of new threads.",null,null],[3,"ThreadId","","A unique identifier for a running thread.",null,null],[3,"Thread","","A handle to a thread.",null,null],[3,"JoinHandle","","An owned permission to join on a thread (block on its termination).",null,null],[4,"LocalKeyState","","Indicator of the state of a thread local storage key.",null,null],[13,"Uninitialized","","All keys are in this state whenever a thread starts. Keys will\ntransition to the `Valid` state once the first call to `with` happens\nand the initialization expression succeeds.",93,null],[13,"Valid","","Once a key has been accessed successfully, it will enter the `Valid`\nstate. Keys in the `Valid` state will remain so until the thread exits,\nat which point the destructor will be run and the key will enter the\n`Destroyed` state.",93,null],[13,"Destroyed","","When a thread exits, the destructors for keys will be run (if\nnecessary). While a destructor is running, and possibly after a\ndestructor has run, a key is in the `Destroyed` state.",93,null],[5,"spawn","","Spawns a new thread, returning a `JoinHandle` for it.",null,{"inputs":[{"name":"f"}],"output":{"name":"joinhandle"}}],[5,"current","","Gets a handle to the thread that invokes it.",null,{"inputs":[],"output":{"name":"thread"}}],[5,"yield_now","","Cooperatively gives up a timeslice to the OS scheduler.",null,{"inputs":[],"output":null}],[5,"panicking","","Determines whether the current thread is unwinding because of panic.",null,{"inputs":[],"output":{"name":"bool"}}],[5,"sleep_ms","","Puts the current thread to sleep for the specified amount of time.",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"sleep","","Puts the current thread to sleep for the specified amount of time.",null,{"inputs":[{"name":"duration"}],"output":null}],[5,"park","","Blocks unless or until the current thread&#39;s token is made available.",null,{"inputs":[],"output":null}],[5,"park_timeout_ms","","Use [park_timeout].",null,{"inputs":[{"name":"u32"}],"output":null}],[5,"park_timeout","","Blocks unless or until the current thread&#39;s token is made available or\nthe specified duration has been reached (may wake spuriously).",null,{"inputs":[{"name":"duration"}],"output":null}],[11,"eq","","",93,null],[11,"clone","","",93,null],[11,"with","","Acquires a reference to the value in this TLS key.",94,null],[11,"state","","Query the current state of this key.",94,null],[6,"Result","","Indicates the manner in which a thread exited.",null,null],[11,"new","","Generates the base configuration for spawning a thread, from which\nconfiguration methods can be chained.",95,{"inputs":[],"output":{"name":"builder"}}],[11,"name","","Names the thread-to-be. Currently the name is used for identification\nonly in panic messages.",95,null],[11,"stack_size","","Sets the size of the stack for the new thread.",95,null],[11,"spawn","","Spawns a new thread, and returns a join handle for it.",95,null],[11,"eq","","",96,null],[11,"ne","","",96,null],[11,"clone","","",96,null],[11,"clone","","",97,null],[11,"unpark","","Atomically makes the handle&#39;s token available if it is not already.",97,null],[11,"id","","Gets the thread&#39;s unique identifier.",97,null],[11,"name","","Gets the thread&#39;s name.",97,null],[11,"fmt","","",97,null],[11,"thread","","Extracts a handle to the underlying thread",98,null],[11,"join","","Waits for the associated thread to finish.",98,null],[0,"ascii","std","Operations on ASCII strings and characters.",null,null],[3,"EscapeDefault","std::ascii","An iterator over the escaped version of a byte, constructed via\n`std::ascii::escape_default`.",null,null],[5,"escape_default","","Returns an iterator that produces an escaped version of a `u8`.",null,{"inputs":[{"name":"u8"}],"output":{"name":"escapedefault"}}],[8,"AsciiExt","","Extension methods for ASCII-subset only operations on string slices.",null,null],[16,"Owned","","Container type for copied ASCII characters.",99,null],[10,"is_ascii","","Checks if the value is within the ASCII range.",99,null],[10,"to_ascii_uppercase","","Makes a copy of the string in ASCII upper case.",99,null],[10,"to_ascii_lowercase","","Makes a copy of the string in ASCII lower case.",99,null],[10,"eq_ignore_ascii_case","","Checks that two strings are an ASCII case-insensitive match.",99,null],[10,"make_ascii_uppercase","","Converts this type to its ASCII upper case equivalent in-place.",99,null],[10,"make_ascii_lowercase","","Converts this type to its ASCII lower case equivalent in-place.",99,null],[11,"next","","",100,null],[11,"size_hint","","",100,null],[11,"next_back","","",100,null],[0,"collections","std","Collection types.",null,null],[4,"Bound","std::collections","An endpoint of a range of keys.",null,null],[13,"Included","","An inclusive bound.",101,null],[13,"Excluded","","An exclusive bound.",101,null],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in this direction.",101,null],[3,"BinaryHeap","","A priority queue implemented with a binary heap.",null,null],[3,"BTreeMap","","A map based on a B-Tree.",null,null],[3,"BTreeSet","","A set based on a B-Tree.",null,null],[3,"LinkedList","","A doubly-linked list.",null,null],[3,"VecDeque","","`VecDeque` is a growable ring buffer, which can be used as a double-ended\nqueue efficiently.",null,null],[0,"binary_heap","","A priority queue implemented with a binary heap.",null,null],[3,"BinaryHeap","std::collections::binary_heap","A priority queue implemented with a binary heap.",null,null],[3,"PeekMut","","A container object that represents the result of the [`peek_mut()`] method\non `BinaryHeap`. See its documentation for details.",null,null],[3,"Iter","","`BinaryHeap` iterator.",null,null],[3,"IntoIter","","An iterator that moves out of a `BinaryHeap`.",null,null],[3,"Drain","","An iterator that drains a `BinaryHeap`.",null,null],[0,"btree_map","std::collections","A map based on a B-Tree.",null,null],[3,"RangeMut","std::collections::btree_map","A mutable iterator over a sub-range of BTreeMap&#39;s entries.",null,null],[3,"Iter","","An iterator over a BTreeMap&#39;s entries.",null,null],[3,"Values","","An iterator over a BTreeMap&#39;s values.",null,null],[3,"OccupiedEntry","","An occupied Entry. It is part of the [`Entry`] enum.",null,null],[3,"IterMut","","A mutable iterator over a BTreeMap&#39;s entries.",null,null],[3,"BTreeMap","","A map based on a B-Tree.",null,null],[3,"Keys","","An iterator over a BTreeMap&#39;s keys.",null,null],[3,"Range","","An iterator over a sub-range of BTreeMap&#39;s entries.",null,null],[3,"VacantEntry","","A vacant Entry. It is part of the [`Entry`] enum.",null,null],[3,"ValuesMut","","A mutable iterator over a BTreeMap&#39;s values.",null,null],[3,"IntoIter","","An owning iterator over a BTreeMap&#39;s entries.",null,null],[4,"Entry","","A view into a single entry in a map, which may either be vacant or occupied.\nThis enum is constructed from the [`entry`] method on [`BTreeMap`].",null,null],[13,"Vacant","","A vacant Entry",102,null],[13,"Occupied","","An occupied Entry",102,null],[0,"btree_set","std::collections","A set based on a B-Tree.",null,null],[3,"Difference","std::collections::btree_set","A lazy iterator producing elements in the set difference (in-order).",null,null],[3,"SymmetricDifference","","A lazy iterator producing elements in the set symmetric difference (in-order).",null,null],[3,"Iter","","An iterator over a BTreeSet&#39;s items.",null,null],[3,"Union","","A lazy iterator producing elements in the set union (in-order).",null,null],[3,"Intersection","","A lazy iterator producing elements in the set intersection (in-order).",null,null],[3,"Range","","An iterator over a sub-range of BTreeSet&#39;s items.",null,null],[3,"IntoIter","","An owning iterator over a BTreeSet&#39;s items.",null,null],[3,"BTreeSet","","A set based on a B-Tree.",null,null],[0,"linked_list","std::collections","A doubly-linked list with owned nodes.",null,null],[3,"LinkedList","std::collections::linked_list","A doubly-linked list.",null,null],[3,"Iter","","An iterator over references to the elements of a `LinkedList`.",null,null],[3,"IterMut","","An iterator over mutable references to the elements of a `LinkedList`.",null,null],[3,"IntoIter","","An iterator over the elements of a `LinkedList`.",null,null],[3,"FrontPlace","","A place for insertion at the front of a `LinkedList`.",null,null],[3,"BackPlace","","A place for insertion at the back of a `LinkedList`.",null,null],[0,"vec_deque","std::collections","VecDeque is a double-ended queue, which is implemented with the help of a\ngrowing ring buffer.",null,null],[3,"VecDeque","std::collections::vec_deque","`VecDeque` is a growable ring buffer, which can be used as a double-ended\nqueue efficiently.",null,null],[3,"Iter","","`VecDeque` iterator.",null,null],[3,"IterMut","","`VecDeque` mutable iterator.",null,null],[3,"IntoIter","","A by-value VecDeque iterator",null,null],[3,"Drain","","A draining VecDeque iterator",null,null],[0,"range","std::collections","Range syntax.",null,null],[8,"RangeArgument","std::collections::range","**RangeArgument** is implemented by Rust&#39;s built-in range types, produced\nby range syntax like `..`, `a..`, `..b` or `c..d`.",null,null],[11,"start","","Start index (inclusive)",103,null],[11,"end","","End index (exclusive)",103,null],[3,"HashMap","std::collections","A hash map implementation which uses linear probing with Robin Hood bucket\nstealing.",null,null],[3,"HashSet","","An implementation of a hash set using the underlying representation of a\nHashMap where the value is ().",null,null],[11,"clone","","",104,null],[11,"new","","Creates an empty `HashMap`.",104,{"inputs":[],"output":{"name":"hashmap"}}],[11,"with_capacity","","Creates an empty `HashMap` with the specified capacity.",104,{"inputs":[{"name":"usize"}],"output":{"name":"hashmap"}}],[11,"with_hasher","","Creates an empty `HashMap` which will use the given hash builder to hash\nkeys.",104,{"inputs":[{"name":"s"}],"output":{"name":"hashmap"}}],[11,"with_capacity_and_hasher","","Creates an empty `HashMap` with the specified capacity, using `hasher`\nto hash the keys.",104,{"inputs":[{"name":"usize"},{"name":"s"}],"output":{"name":"hashmap"}}],[11,"hasher","","Returns a reference to the map&#39;s hasher.",104,null],[11,"capacity","","Returns the number of elements the map can hold without reallocating.",104,null],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted\nin the `HashMap`. The collection may reserve more space to avoid\nfrequent reallocations.",104,null],[11,"shrink_to_fit","","Shrinks the capacity of the map as much as possible. It will drop\ndown as much as possible while maintaining the internal rules\nand possibly leaving some space in accordance with the resize policy.",104,null],[11,"keys","","An iterator visiting all keys in arbitrary order.\nIterator element type is `&amp;&#39;a K`.",104,null],[11,"values","","An iterator visiting all values in arbitrary order.\nIterator element type is `&amp;&#39;a V`.",104,null],[11,"values_mut","","An iterator visiting all values mutably in arbitrary order.\nIterator element type is `&amp;&#39;a mut V`.",104,null],[11,"iter","","An iterator visiting all key-value pairs in arbitrary order.\nIterator element type is `(&amp;&#39;a K, &amp;&#39;a V)`.",104,null],[11,"iter_mut","","An iterator visiting all key-value pairs in arbitrary order,\nwith mutable references to the values.\nIterator element type is `(&amp;&#39;a K, &amp;&#39;a mut V)`.",104,null],[11,"entry","","Gets the given key&#39;s corresponding entry in the map for in-place manipulation.",104,null],[11,"len","","Returns the number of elements in the map.",104,null],[11,"is_empty","","Returns true if the map contains no elements.",104,null],[11,"drain","","Clears the map, returning all key-value pairs as an iterator. Keeps the\nallocated memory for reuse.",104,null],[11,"clear","","Clears the map, removing all key-value pairs. Keeps the allocated memory\nfor reuse.",104,null],[11,"get","","Returns a reference to the value corresponding to the key.",104,null],[11,"contains_key","","Returns true if the map contains a value for the specified key.",104,null],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",104,null],[11,"insert","","Inserts a key-value pair into the map.",104,null],[11,"remove","","Removes a key from the map, returning the value at the key if the key\nwas previously in the map.",104,null],[11,"eq","","",104,null],[11,"fmt","","",104,null],[11,"default","","Creates an empty `HashMap&lt;K, V, S&gt;`, with the `Default` value for the hasher.",104,{"inputs":[],"output":{"name":"hashmap"}}],[11,"index","","",104,null],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each key-value\npair out of the map in arbitrary order. The map cannot be used after\ncalling this.",104,null],[11,"from_iter","","",104,{"inputs":[{"name":"t"}],"output":{"name":"hashmap"}}],[11,"extend","","",104,null],[11,"extend","","",104,null],[11,"clone","","",105,null],[11,"new","","Creates an empty HashSet.",105,{"inputs":[],"output":{"name":"hashset"}}],[11,"with_capacity","","Creates an empty `HashSet` with the specified capacity.",105,{"inputs":[{"name":"usize"}],"output":{"name":"hashset"}}],[11,"with_hasher","","Creates a new empty hash set which will use the given hasher to hash\nkeys.",105,{"inputs":[{"name":"s"}],"output":{"name":"hashset"}}],[11,"with_capacity_and_hasher","","Creates an empty HashSet with with the specified capacity, using\n`hasher` to hash the keys.",105,{"inputs":[{"name":"usize"},{"name":"s"}],"output":{"name":"hashset"}}],[11,"hasher","","Returns a reference to the set&#39;s hasher.",105,null],[11,"capacity","","Returns the number of elements the set can hold without reallocating.",105,null],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted\nin the `HashSet`. The collection may reserve more space to avoid\nfrequent reallocations.",105,null],[11,"shrink_to_fit","","Shrinks the capacity of the set as much as possible. It will drop\ndown as much as possible while maintaining the internal rules\nand possibly leaving some space in accordance with the resize policy.",105,null],[11,"iter","","An iterator visiting all elements in arbitrary order.\nIterator element type is &amp;&#39;a T.",105,null],[11,"difference","","Visit the values representing the difference.",105,null],[11,"symmetric_difference","","Visit the values representing the symmetric difference.",105,null],[11,"intersection","","Visit the values representing the intersection.",105,null],[11,"union","","Visit the values representing the union.",105,null],[11,"len","","Returns the number of elements in the set.",105,null],[11,"is_empty","","Returns true if the set contains no elements.",105,null],[11,"drain","","Clears the set, returning all elements in an iterator.",105,null],[11,"clear","","Clears the set, removing all values.",105,null],[11,"contains","","Returns `true` if the set contains a value.",105,null],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",105,null],[11,"is_disjoint","","Returns `true` if the set has no elements in common with `other`.\nThis is equivalent to checking for an empty intersection.",105,null],[11,"is_subset","","Returns `true` if the set is a subset of another.",105,null],[11,"is_superset","","Returns `true` if the set is a superset of another.",105,null],[11,"insert","","Adds a value to the set.",105,null],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given\none. Returns the replaced value.",105,null],[11,"remove","","Removes a value from the set. Returns `true` if the value was\npresent in the set.",105,null],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",105,null],[11,"eq","","",105,null],[11,"fmt","","",105,null],[11,"from_iter","","",105,{"inputs":[{"name":"i"}],"output":{"name":"hashset"}}],[11,"extend","","",105,null],[11,"extend","","",105,null],[11,"default","","Creates an empty `HashSet&lt;T, S&gt;` with the `Default` value for the hasher.",105,{"inputs":[],"output":{"name":"hashset"}}],[11,"into_iter","","Creates a consuming iterator, that is, one that moves each value out\nof the set in arbitrary order. The set cannot be used after calling\nthis.",105,null],[0,"hash_map","","A hash map implementation which uses linear probing with Robin\nHood bucket stealing.",null,null],[3,"HashMap","std::collections::hash_map","A hash map implementation which uses linear probing with Robin Hood bucket\nstealing.",null,null],[3,"Iter","","HashMap iterator.",null,null],[3,"IterMut","","HashMap mutable values iterator.",null,null],[3,"IntoIter","","HashMap move iterator.",null,null],[3,"Keys","","HashMap keys iterator.",null,null],[3,"Values","","HashMap values iterator.",null,null],[3,"Drain","","HashMap drain iterator.",null,null],[3,"ValuesMut","","Mutable HashMap values iterator.",null,null],[3,"OccupiedEntry","","A view into a single occupied location in a HashMap.\nIt is part of the [`Entry`] enum.",null,null],[3,"VacantEntry","","A view into a single empty location in a HashMap.\nIt is part of the [`Entry`] enum.",null,null],[3,"RandomState","","`RandomState` is the default state for [`HashMap`] types.",null,null],[3,"DefaultHasher","","The default [`Hasher`] used by [`RandomState`].",null,null],[4,"Entry","","A view into a single location in a map, which may be vacant or occupied.\nThis enum is constructed from the [`entry`] method on [`HashMap`].",null,null],[13,"Occupied","","An occupied Entry.",106,null],[13,"Vacant","","A vacant Entry.",106,null],[0,"hash_set","std::collections","An implementation of a hash set using the underlying representation of a\nHashMap where the value is ().",null,null],[3,"HashSet","std::collections::hash_set","An implementation of a hash set using the underlying representation of a\nHashMap where the value is ().",null,null],[3,"Iter","","HashSet iterator",null,null],[3,"IntoIter","","HashSet move iterator",null,null],[3,"Drain","","HashSet drain iterator",null,null],[3,"Intersection","","Intersection iterator",null,null],[3,"Difference","","Difference iterator",null,null],[3,"SymmetricDifference","","Symmetric difference iterator.",null,null],[3,"Union","","Set union iterator.",null,null],[0,"env","std","Inspection and manipulation of the process&#39;s environment.",null,null],[3,"Vars","std::env","An iterator over a snapshot of the environment variables of this process.",null,null],[3,"VarsOs","","An iterator over a snapshot of the environment variables of this process.",null,null],[3,"SplitPaths","","An iterator over `PathBuf` instances for parsing an environment variable\naccording to platform-specific conventions.",null,null],[3,"JoinPathsError","","Error type returned from `std::env::join_paths` when paths fail to be\njoined.",null,null],[3,"Args","","An iterator over the arguments of a process, yielding a [`String`] value\nfor each argument.",null,null],[3,"ArgsOs","","An iterator over the arguments of a process, yielding an [`OsString`] value\nfor each argument.",null,null],[4,"VarError","","Possible errors from the `env::var` method.",null,null],[13,"NotPresent","","The specified environment variable was not present in the current\nprocess&#39;s environment.",107,null],[13,"NotUnicode","","The specified environment variable was found, but it did not contain\nvalid unicode data. The found data is returned as a payload of this\nvariant.",107,null],[5,"current_dir","","Returns the current working directory as a `PathBuf`.",null,{"inputs":[],"output":{"name":"result"}}],[5,"set_current_dir","","Changes the current working directory to the specified path, returning\nwhether the change was completed successfully or not.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"vars","","Returns an iterator of (variable, value) pairs of strings, for all the\nenvironment variables of the current process.",null,{"inputs":[],"output":{"name":"vars"}}],[5,"vars_os","","Returns an iterator of (variable, value) pairs of OS strings, for all the\nenvironment variables of the current process.",null,{"inputs":[],"output":{"name":"varsos"}}],[5,"var","","Fetches the environment variable `key` from the current process.",null,{"inputs":[{"name":"k"}],"output":{"name":"result"}}],[5,"var_os","","Fetches the environment variable `key` from the current process, returning\n`None` if the variable isn&#39;t set.",null,{"inputs":[{"name":"k"}],"output":{"name":"option"}}],[5,"set_var","","Sets the environment variable `k` to the value `v` for the currently running\nprocess.",null,{"inputs":[{"name":"k"},{"name":"v"}],"output":null}],[5,"remove_var","","Removes an environment variable from the environment of the currently running process.",null,{"inputs":[{"name":"k"}],"output":null}],[5,"split_paths","","Parses input according to platform conventions for the `PATH`\nenvironment variable.",null,{"inputs":[{"name":"t"}],"output":{"name":"splitpaths"}}],[5,"join_paths","","Joins a collection of `Path`s appropriately for the `PATH`\nenvironment variable.",null,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[5,"home_dir","","Returns the path of the current user&#39;s home directory if known.",null,{"inputs":[],"output":{"name":"option"}}],[5,"temp_dir","","Returns the path of a temporary directory.",null,{"inputs":[],"output":{"name":"pathbuf"}}],[5,"current_exe","","Returns the full filesystem path of the current running executable.",null,{"inputs":[],"output":{"name":"result"}}],[5,"args","","Returns the arguments which this program was started with (normally passed\nvia the command line).",null,{"inputs":[],"output":{"name":"args"}}],[5,"args_os","","Returns the arguments which this program was started with (normally passed\nvia the command line).",null,{"inputs":[],"output":{"name":"argsos"}}],[0,"consts","","Constants associated with the current target",null,null],[17,"ARCH","std::env::consts","A string describing the architecture of the CPU that is currently\nin use.",null,null],[17,"FAMILY","","The family of the operating system. Example value is `unix`.",null,null],[17,"OS","","A string describing the specific operating system in use.\nExample value is `linux`.",null,null],[17,"DLL_PREFIX","","Specifies the filename prefix used for shared libraries on this\nplatform. Example value is `lib`.",null,null],[17,"DLL_SUFFIX","","Specifies the filename suffix used for shared libraries on this\nplatform. Example value is `.so`.",null,null],[17,"DLL_EXTENSION","","Specifies the file extension used for shared libraries on this\nplatform that goes after the dot. Example value is `so`.",null,null],[17,"EXE_SUFFIX","","Specifies the filename suffix used for executable binaries on this\nplatform. Example value is `.exe`.",null,null],[17,"EXE_EXTENSION","","Specifies the file extension, if any, used for executable binaries\non this platform. Example value is `exe`.",null,null],[11,"next","std::env","",108,null],[11,"size_hint","","",108,null],[11,"next","","",109,null],[11,"size_hint","","",109,null],[11,"fmt","","",107,null],[11,"eq","","",107,null],[11,"ne","","",107,null],[11,"clone","","",107,null],[11,"fmt","","",107,null],[11,"description","","",107,null],[11,"next","","",110,null],[11,"size_hint","","",110,null],[11,"fmt","","",111,null],[11,"fmt","","",111,null],[11,"description","","",111,null],[11,"next","","",112,null],[11,"size_hint","","",112,null],[11,"len","","",112,null],[11,"is_empty","","",112,null],[11,"next_back","","",112,null],[11,"next","","",113,null],[11,"size_hint","","",113,null],[11,"len","","",113,null],[11,"is_empty","","",113,null],[11,"next_back","","",113,null],[0,"error","std","Traits for working with Errors.",null,null],[8,"Error","std::error","Base functionality for all errors in Rust.",null,null],[10,"description","","A short description of the error.",114,null],[11,"cause","","The lower-level cause of this error, if any.",114,null],[11,"from","std::boxed","",115,{"inputs":[{"name":"e"}],"output":{"name":"box"}}],[11,"from","","",115,{"inputs":[{"name":"e"}],"output":{"name":"box"}}],[11,"from","","",115,{"inputs":[{"name":"string"}],"output":{"name":"box"}}],[11,"from","","",115,{"inputs":[{"name":"string"}],"output":{"name":"box"}}],[11,"from","","",115,{"inputs":[{"name":"str"}],"output":{"name":"box"}}],[11,"from","","",115,{"inputs":[{"name":"str"}],"output":{"name":"box"}}],[11,"description","std::str","",116,null],[11,"description","","",117,null],[11,"description","std::string","",118,null],[11,"description","","",119,null],[11,"description","","",120,null],[11,"description","std::char","",121,null],[11,"description","std::boxed","",115,null],[11,"cause","","",115,null],[11,"description","std::fmt","",122,null],[11,"description","std::cell","",123,null],[11,"description","","",124,null],[11,"description","std::char","",125,null],[11,"is","std::error","Returns true if the boxed type is the same as `T`",114,null],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or\n`None` if it isn&#39;t.",114,null],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or\n`None` if it isn&#39;t.",114,null],[11,"is","","Forwards to the method defined on the type `Any`.",114,null],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",114,null],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",114,null],[11,"is","","Forwards to the method defined on the type `Any`.",114,null],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",114,null],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",114,null],[11,"downcast","","Attempt to downcast the box to a concrete type.",114,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",114,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[11,"downcast","","Attempt to downcast the box to a concrete type.",114,{"inputs":[{"name":"box"}],"output":{"name":"result"}}],[0,"ffi","std","Utilities related to FFI bindings.",null,null],[3,"CString","std::ffi","A type representing an owned C-compatible string",null,null],[3,"CStr","","Representation of a borrowed C string.",null,null],[3,"NulError","","An error returned from `CString::new` to indicate that a nul byte was found\nin the vector provided.",null,null],[3,"IntoStringError","","An error returned from `CString::into_string` to indicate that a UTF-8 error\nwas encountered during the conversion.",null,null],[3,"FromBytesWithNulError","","An error returned from `CStr::from_bytes_with_nul` to indicate that a nul\nbyte was found too early in the slice provided or one wasn&#39;t found at all.",null,null],[3,"OsString","","A type that can represent owned, mutable platform-native strings, but is\ncheaply inter-convertible with Rust strings.",null,null],[3,"OsStr","","Slices into OS strings (see `OsString`).",null,null],[11,"eq","","",126,null],[11,"ne","","",126,null],[11,"partial_cmp","","",126,null],[11,"lt","","",126,null],[11,"le","","",126,null],[11,"gt","","",126,null],[11,"ge","","",126,null],[11,"cmp","","",126,null],[11,"hash","","",126,null],[11,"clone","","",126,null],[11,"hash","","",127,null],[11,"clone","","",128,null],[11,"eq","","",128,null],[11,"ne","","",128,null],[11,"fmt","","",128,null],[11,"clone","","",129,null],[11,"eq","","",129,null],[11,"ne","","",129,null],[11,"fmt","","",129,null],[11,"clone","","",130,null],[11,"eq","","",130,null],[11,"ne","","",130,null],[11,"fmt","","",130,null],[11,"new","","Creates a new C-compatible string from a container of bytes.",126,{"inputs":[{"name":"t"}],"output":{"name":"result"}}],[11,"from_vec_unchecked","","Creates a C-compatible string from a byte vector without checking for\ninterior 0 bytes.",126,{"inputs":[{"name":"vec"}],"output":{"name":"cstring"}}],[11,"from_raw","","Retakes ownership of a `CString` that was transferred to C.",126,null],[11,"into_raw","","Transfers ownership of the string to a C caller.",126,null],[11,"into_string","","Converts the `CString` into a `String` if it contains valid Unicode data.",126,null],[11,"into_bytes","","Returns the underlying byte buffer.",126,null],[11,"into_bytes_with_nul","","Equivalent to the `into_bytes` function except that the returned vector\nincludes the trailing nul byte.",126,null],[11,"as_bytes","","Returns the contents of this `CString` as a slice of bytes.",126,null],[11,"as_bytes_with_nul","","Equivalent to the `as_bytes` function except that the returned slice\nincludes the trailing nul byte.",126,null],[11,"drop","","",126,null],[11,"deref","","",126,null],[11,"fmt","","",126,null],[11,"from","std::vec","",131,{"inputs":[{"name":"cstring"}],"output":{"name":"vec"}}],[11,"fmt","std::ffi","",127,null],[11,"default","","Creates an empty `CString`.",126,{"inputs":[],"output":{"name":"cstring"}}],[11,"borrow","","",126,null],[11,"nul_position","","Returns the position of the nul byte in the slice that was provided to\n`CString::new`.",128,null],[11,"into_vec","","Consumes this error, returning the underlying vector of bytes which\ngenerated the error in the first place.",128,null],[11,"description","","",128,null],[11,"fmt","","",128,null],[11,"into_cstring","","Consumes this error, returning original `CString` which generated the\nerror.",130,null],[11,"utf8_error","","Access the underlying UTF-8 error that was the cause of this error.",130,null],[11,"description","","",130,null],[11,"cause","","",130,null],[11,"fmt","","",130,null],[11,"from_ptr","","Casts a raw C string to a safe C string wrapper.",127,null],[11,"from_bytes_with_nul","","Creates a C string wrapper from a byte slice.",127,null],[11,"from_bytes_with_nul_unchecked","","Unsafely creates a C string wrapper from a byte slice.",127,null],[11,"as_ptr","","Returns the inner pointer to this C string.",127,null],[11,"to_bytes","","Converts this C string to a byte slice.",127,null],[11,"to_bytes_with_nul","","Converts this C string to a byte slice containing the trailing 0 byte.",127,null],[11,"to_str","","Yields a `&amp;str` slice if the `CStr` contains valid UTF-8.",127,null],[11,"to_string_lossy","","Converts a `CStr` into a `Cow&lt;str&gt;`.",127,null],[11,"eq","","",127,null],[11,"partial_cmp","","",127,null],[11,"cmp","","",127,null],[11,"to_owned","","",127,null],[11,"from","","",126,{"inputs":[{"name":"cstr"}],"output":{"name":"cstring"}}],[11,"index","","",126,null],[11,"as_ref","","",127,null],[11,"as_ref","","",126,null],[11,"clone","","",132,null],[11,"new","","Constructs a new empty `OsString`.",132,{"inputs":[],"output":{"name":"osstring"}}],[11,"as_os_str","","Converts to an `OsStr` slice.",132,null],[11,"into_string","","Converts the `OsString` into a `String` if it contains valid Unicode data.",132,null],[11,"push","","Extends the string with the given `&amp;OsStr` slice.",132,null],[11,"with_capacity","","Creates a new `OsString` with the given capacity.",132,{"inputs":[{"name":"usize"}],"output":{"name":"osstring"}}],[11,"clear","","Truncates the `OsString` to zero length.",132,null],[11,"capacity","","Returns the capacity this `OsString` can hold without reallocating.",132,null],[11,"reserve","","Reserves capacity for at least `additional` more capacity to be inserted\nin the given `OsString`.",132,null],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more capacity to\nbe inserted in the given `OsString`. Does nothing if the capacity is\nalready sufficient.",132,null],[11,"from","","",132,{"inputs":[{"name":"string"}],"output":{"name":"osstring"}}],[11,"from","","",132,{"inputs":[{"name":"t"}],"output":{"name":"osstring"}}],[11,"index","","",132,null],[11,"deref","","",132,null],[11,"default","","Constructs an empty `OsString`.",132,{"inputs":[],"output":{"name":"osstring"}}],[11,"fmt","","",132,null],[11,"eq","","",132,null],[11,"eq","","",132,null],[11,"partial_cmp","","",132,null],[11,"lt","","",132,null],[11,"le","","",132,null],[11,"gt","","",132,null],[11,"ge","","",132,null],[11,"partial_cmp","","",132,null],[11,"cmp","","",132,null],[11,"hash","","",132,null],[11,"new","","Coerces into an `OsStr` slice.",133,{"inputs":[{"name":"s"}],"output":{"name":"osstr"}}],[11,"to_str","","Yields a `&amp;str` slice if the `OsStr` is valid Unicode.",133,null],[11,"to_string_lossy","","Converts an `OsStr` to a `Cow&lt;str&gt;`.",133,null],[11,"to_os_string","","Copies the slice into an owned `OsString`.",133,null],[11,"is_empty","","Checks whether the `OsStr` is empty.",133,null],[11,"len","","Returns the length of this `OsStr`.",133,null],[11,"eq","","",133,null],[11,"eq","","",133,null],[11,"partial_cmp","","",133,null],[11,"lt","","",133,null],[11,"le","","",133,null],[11,"gt","","",133,null],[11,"ge","","",133,null],[11,"partial_cmp","","",133,null],[11,"cmp","","",133,null],[11,"eq","","",132,null],[11,"eq","","",133,null],[11,"partial_cmp","","",132,null],[11,"partial_cmp","","",133,null],[11,"eq","","",132,null],[11,"partial_cmp","","",132,null],[11,"eq","std::borrow","",72,null],[11,"eq","std::ffi","",133,null],[11,"partial_cmp","std::borrow","",72,null],[11,"partial_cmp","std::ffi","",133,null],[11,"eq","std::borrow","",72,null],[11,"partial_cmp","","",72,null],[11,"eq","","",72,null],[11,"eq","std::ffi","",132,null],[11,"partial_cmp","std::borrow","",72,null],[11,"partial_cmp","std::ffi","",132,null],[11,"hash","","",133,null],[11,"fmt","","",133,null],[11,"borrow","","",132,null],[11,"to_owned","","",133,null],[11,"as_ref","","",133,null],[11,"as_ref","","",132,null],[11,"as_ref","std::string","",134,null],[0,"fs","std","Filesystem manipulation operations.",null,null],[3,"File","std::fs","A reference to an open file on the filesystem.",null,null],[3,"Metadata","","Metadata information about a file.",null,null],[3,"ReadDir","","Iterator over the entries in a directory.",null,null],[3,"DirEntry","","Entries returned by the [`ReadDir`] iterator.",null,null],[3,"OpenOptions","","Options and flags which can be used to configure how a file is opened.",null,null],[3,"Permissions","","Representation of the various permissions on a file.",null,null],[3,"FileType","","A structure representing a type of file with accessors for each file type.\nIt is returned by [`Metadata::file_type`] method.",null,null],[3,"DirBuilder","","A builder used to create directories in various manners.",null,null],[5,"remove_file","","Removes a file from the filesystem.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"metadata","","Given a path, query the file system to get information about a file,\ndirectory, etc.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"symlink_metadata","","Query the metadata about a file without following symlinks.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"rename","","Rename a file or directory to a new name, replacing the original file if\n`to` already exists.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"copy","","Copies the contents of one file to another. This function will also\ncopy the permission bits of the original file to the destination file.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"hard_link","","Creates a new hard link on the filesystem.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"soft_link","","Creates a new symbolic link on the filesystem.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[5,"read_link","","Reads a symbolic link, returning the file that the link points to.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"canonicalize","","Returns the canonical form of a path with all intermediate components\nnormalized and symbolic links resolved.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"create_dir","","Creates a new, empty directory at the provided path",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"create_dir_all","","Recursively create a directory and all of its parent components if they\nare missing.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"remove_dir","","Removes an existing, empty directory.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"remove_dir_all","","Removes a directory at this path, after removing all its contents. Use\ncarefully!",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"read_dir","","Returns an iterator over the entries within a directory.",null,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[5,"set_permissions","","Changes the permissions found on a file or a directory.",null,{"inputs":[{"name":"p"},{"name":"permissions"}],"output":{"name":"result"}}],[11,"clone","","",135,null],[11,"fmt","","",136,null],[11,"clone","","",137,null],[11,"clone","","",138,null],[11,"eq","","",138,null],[11,"ne","","",138,null],[11,"fmt","","",138,null],[11,"clone","","",139,null],[11,"eq","","",139,null],[11,"ne","","",139,null],[11,"hash","","",139,null],[11,"fmt","","",139,null],[11,"open","","Attempts to open a file in read-only mode.",140,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"create","","Opens a file in write-only mode.",140,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"sync_all","","Attempts to sync all OS-internal metadata to disk.",140,null],[11,"sync_data","","This function is similar to [`sync_all`], except that it may not\nsynchronize file metadata to the filesystem.",140,null],[11,"set_len","","Truncates or extends the underlying file, updating the size of\nthis file to become `size`.",140,null],[11,"metadata","","Queries metadata about the underlying file.",140,null],[11,"try_clone","","Creates a new independently owned handle to the underlying file.",140,null],[11,"set_permissions","","Changes the permissions on the underlying file.",140,null],[11,"fmt","","",140,null],[11,"read","","",140,null],[11,"read_to_end","","",140,null],[11,"write","","",140,null],[11,"flush","","",140,null],[11,"seek","","",140,null],[11,"new","","Creates a blank new set of options ready for configuration.",137,{"inputs":[],"output":{"name":"openoptions"}}],[11,"read","","Sets the option for read access.",137,null],[11,"write","","Sets the option for write access.",137,null],[11,"append","","Sets the option for the append mode.",137,null],[11,"truncate","","Sets the option for truncating a previous file.",137,null],[11,"create","","Sets the option for creating a new file.",137,null],[11,"create_new","","Sets the option to always create a new file.",137,null],[11,"open","","Opens a file at `path` with the options specified by `self`.",137,null],[11,"file_type","","Returns the file type for this metadata.",135,null],[11,"is_dir","","Returns whether this metadata is for a directory.",135,null],[11,"is_file","","Returns whether this metadata is for a regular file.",135,null],[11,"len","","Returns the size of the file, in bytes, this metadata is for.",135,null],[11,"permissions","","Returns the permissions of the file this metadata is for.",135,null],[11,"modified","","Returns the last modification time listed in this metadata.",135,null],[11,"accessed","","Returns the last access time of this metadata.",135,null],[11,"created","","Returns the creation time listed in the this metadata.",135,null],[11,"readonly","","Returns whether these permissions describe a readonly file.",138,null],[11,"set_readonly","","Modifies the readonly flag for this set of permissions.",138,null],[11,"is_dir","","Test whether this file type represents a directory.",139,null],[11,"is_file","","Test whether this file type represents a regular file.",139,null],[11,"is_symlink","","Test whether this file type represents a symbolic link.",139,null],[11,"next","","",136,null],[11,"path","","Returns the full path to the file that this entry represents.",141,null],[11,"metadata","","Return the metadata for the file that this entry points at.",141,null],[11,"file_type","","Return the file type for the file that this entry points at.",141,null],[11,"file_name","","Returns the bare file name of this directory entry without any other\nleading path component.",141,null],[11,"fmt","","",141,null],[11,"new","","Creates a new set of options with default mode/security settings for all\nplatforms and also non-recursive.",142,{"inputs":[],"output":{"name":"dirbuilder"}}],[11,"recursive","","Indicate that directories create should be created recursively, creating\nall parent directories if they do not exist with the same security and\npermissions settings.",142,null],[11,"create","","Create the specified directory with the options configured in this\nbuilder.",142,null],[0,"io","std","Traits, helpers, and type definitions for core I/O functionality.",null,null],[3,"BufReader","std::io","The `BufReader` struct adds buffering to any reader.",null,null],[3,"BufWriter","","Wraps a writer and buffers its output.",null,null],[3,"LineWriter","","Wraps a writer and buffers output to it, flushing whenever a newline\n(`0x0a`, `&#39;\\n&#39;`) is detected.",null,null],[3,"IntoInnerError","","An error returned by `into_inner` which combines an error that\nhappened while writing out the buffer, and the buffered writer object\nwhich may be used to recover from the condition.",null,null],[3,"Cursor","","A `Cursor` wraps another type and provides it with a\n[`Seek`] implementation.",null,null],[3,"Error","","The error type for I/O operations of the `Read`, `Write`, `Seek`, and\nassociated traits.",null,null],[3,"Sink","","A writer which will move data into the void.",null,null],[3,"Empty","","A reader which is always at EOF.",null,null],[3,"Repeat","","A reader which yields one byte over and over and over and over and over and...",null,null],[3,"Stdin","","A handle to the standard input stream of a process.",null,null],[3,"Stdout","","A handle to the global standard output stream of the current process.",null,null],[3,"Stderr","","A handle to the standard error stream of a process.",null,null],[3,"StdoutLock","","A locked reference to the `Stdout` handle.",null,null],[3,"StderrLock","","A locked reference to the `Stderr` handle.",null,null],[3,"StdinLock","","A locked reference to the `Stdin` handle.",null,null],[3,"Chain","","Adaptor to chain together two readers.",null,null],[3,"Take","","Reader adaptor which limits the bytes read from an underlying reader.",null,null],[3,"Bytes","","An iterator over `u8` values of a reader.",null,null],[3,"Chars","","An iterator over the `char`s of a reader.",null,null],[3,"Split","","An iterator over the contents of an instance of `BufRead` split on a\nparticular byte.",null,null],[3,"Lines","","An iterator over the lines of an instance of `BufRead`.",null,null],[4,"ErrorKind","","A list specifying general categories of I/O error.",null,null],[13,"NotFound","","An entity was not found, often a file.",143,null],[13,"PermissionDenied","","The operation lacked the necessary privileges to complete.",143,null],[13,"ConnectionRefused","","The connection was refused by the remote server.",143,null],[13,"ConnectionReset","","The connection was reset by the remote server.",143,null],[13,"ConnectionAborted","","The connection was aborted (terminated) by the remote server.",143,null],[13,"NotConnected","","The network operation failed because it was not connected yet.",143,null],[13,"AddrInUse","","A socket address could not be bound because the address is already in\nuse elsewhere.",143,null],[13,"AddrNotAvailable","","A nonexistent interface was requested or the requested address was not\nlocal.",143,null],[13,"BrokenPipe","","The operation failed because a pipe was closed.",143,null],[13,"AlreadyExists","","An entity already exists, often a file.",143,null],[13,"WouldBlock","","The operation needs to block to complete, but the blocking operation was\nrequested to not occur.",143,null],[13,"InvalidInput","","A parameter was incorrect.",143,null],[13,"InvalidData","","Data not valid for the operation were encountered.",143,null],[13,"TimedOut","","The I/O operation&#39;s timeout expired, causing it to be canceled.",143,null],[13,"WriteZero","","An error returned when an operation could not be completed because a\ncall to [`write()`] returned [`Ok(0)`].",143,null],[13,"Interrupted","","This operation was interrupted.",143,null],[13,"Other","","Any I/O error not part of this list.",143,null],[13,"UnexpectedEof","","An error returned when an operation could not be completed because an\n&quot;end of file&quot; was reached prematurely.",143,null],[4,"SeekFrom","","Enumeration of possible methods to seek within an I/O object.",null,null],[13,"Start","","Set the offset to the provided number of bytes.",144,null],[13,"End","","Set the offset to the size of this object plus the specified number of\nbytes.",144,null],[13,"Current","","Set the offset to the current position plus the specified number of\nbytes.",144,null],[4,"CharsError","","An enumeration of possible errors that can be generated from the `Chars`\nadapter.",null,null],[13,"NotUtf8","","Variant representing that the underlying stream was read successfully\nbut it did not contain valid utf8 data.",145,null],[13,"Other","","Variant representing that an I/O error occurred.",145,null],[5,"copy","","Copies the entire contents of a reader into a writer.",null,{"inputs":[{"name":"r"},{"name":"w"}],"output":{"name":"result"}}],[5,"sink","","Creates an instance of a writer which will successfully consume all data.",null,{"inputs":[],"output":{"name":"sink"}}],[5,"empty","","Constructs a new handle to an empty reader.",null,{"inputs":[],"output":{"name":"empty"}}],[5,"repeat","","Creates an instance of a reader that infinitely repeats one byte.",null,{"inputs":[{"name":"u8"}],"output":{"name":"repeat"}}],[5,"stdin","","Constructs a new handle to the standard input of the current process.",null,{"inputs":[],"output":{"name":"stdin"}}],[5,"stdout","","Constructs a new handle to the standard output of the current process.",null,{"inputs":[],"output":{"name":"stdout"}}],[5,"stderr","","Constructs a new handle to the standard error of the current process.",null,{"inputs":[],"output":{"name":"stderr"}}],[0,"prelude","","The I/O Prelude",null,null],[11,"new","","Creates a new `BufReader` with a default buffer capacity.",146,{"inputs":[{"name":"r"}],"output":{"name":"bufreader"}}],[11,"with_capacity","","Creates a new `BufReader` with the specified buffer capacity.",146,{"inputs":[{"name":"usize"},{"name":"r"}],"output":{"name":"bufreader"}}],[11,"get_ref","","Gets a reference to the underlying reader.",146,null],[11,"get_mut","","Gets a mutable reference to the underlying reader.",146,null],[11,"into_inner","","Unwraps this `BufReader`, returning the underlying reader.",146,null],[11,"read","","",146,null],[11,"fill_buf","","",146,null],[11,"consume","","",146,null],[11,"fmt","","",146,null],[11,"seek","","Seek to an offset, in bytes, in the underlying reader.",146,null],[11,"fmt","","",147,null],[11,"new","","Creates a new `BufWriter` with a default buffer capacity.",148,{"inputs":[{"name":"w"}],"output":{"name":"bufwriter"}}],[11,"with_capacity","","Creates a new `BufWriter` with the specified buffer capacity.",148,{"inputs":[{"name":"usize"},{"name":"w"}],"output":{"name":"bufwriter"}}],[11,"get_ref","","Gets a reference to the underlying writer.",148,null],[11,"get_mut","","Gets a mutable reference to the underlying writer.",148,null],[11,"into_inner","","Unwraps this `BufWriter`, returning the underlying writer.",148,null],[11,"write","","",148,null],[11,"flush","","",148,null],[11,"fmt","","",148,null],[11,"seek","","Seek to the offset, in bytes, in the underlying writer.",148,null],[11,"drop","","",148,null],[11,"error","","Returns the error which caused the call to `into_inner()` to fail.",147,null],[11,"into_inner","","Returns the buffered writer instance which generated the error.",147,null],[11,"from","","",149,{"inputs":[{"name":"intoinnererror"}],"output":{"name":"error"}}],[11,"description","","",147,null],[11,"fmt","","",147,null],[11,"new","","Creates a new `LineWriter`.",150,{"inputs":[{"name":"w"}],"output":{"name":"linewriter"}}],[11,"with_capacity","","Creates a new `LineWriter` with a specified capacity for the internal\nbuffer.",150,{"inputs":[{"name":"usize"},{"name":"w"}],"output":{"name":"linewriter"}}],[11,"get_ref","","Gets a reference to the underlying writer.",150,null],[11,"get_mut","","Gets a mutable reference to the underlying writer.",150,null],[11,"into_inner","","Unwraps this `LineWriter`, returning the underlying writer.",150,null],[11,"write","","",150,null],[11,"flush","","",150,null],[11,"fmt","","",150,null],[11,"clone","","",151,null],[11,"fmt","","",151,null],[11,"new","","Creates a new cursor wrapping the provided underlying I/O object.",151,{"inputs":[{"name":"t"}],"output":{"name":"cursor"}}],[11,"into_inner","","Consumes this cursor, returning the underlying value.",151,null],[11,"get_ref","","Gets a reference to the underlying value in this cursor.",151,null],[11,"get_mut","","Gets a mutable reference to the underlying value in this cursor.",151,null],[11,"position","","Returns the current position of this cursor.",151,null],[11,"set_position","","Sets the position of this cursor.",151,null],[11,"seek","","",151,null],[11,"read","","",151,null],[11,"fill_buf","","",151,null],[11,"consume","","",151,null],[11,"write","","",151,null],[11,"flush","","",151,null],[11,"write","","",151,null],[11,"flush","","",151,null],[11,"write","","",151,null],[11,"flush","","",151,null],[11,"fmt","","",149,null],[11,"clone","","",143,null],[11,"fmt","","",143,null],[11,"hash","","",143,null],[11,"cmp","","",143,null],[11,"eq","","",143,null],[11,"partial_cmp","","",143,null],[11,"from","","",149,{"inputs":[{"name":"errorkind"}],"output":{"name":"error"}}],[11,"new","","Creates a new I/O error from a known kind of error as well as an\narbitrary error payload.",149,{"inputs":[{"name":"errorkind"},{"name":"e"}],"output":{"name":"error"}}],[11,"last_os_error","","Returns an error representing the last OS error which occurred.",149,{"inputs":[],"output":{"name":"error"}}],[11,"from_raw_os_error","","Creates a new instance of an `Error` from a particular OS error code.",149,{"inputs":[{"name":"i32"}],"output":{"name":"error"}}],[11,"raw_os_error","","Returns the OS error that this error represents (if any).",149,null],[11,"get_ref","","Returns a reference to the inner error wrapped by this error (if any).",149,null],[11,"get_mut","","Returns a mutable reference to the inner error wrapped by this error\n(if any).",149,null],[11,"into_inner","","Consumes the `Error`, returning its inner error (if any).",149,null],[11,"kind","","Returns the corresponding `ErrorKind` for this error.",149,null],[11,"fmt","","",149,null],[11,"description","","",149,null],[11,"cause","","",149,null],[11,"read","std::boxed","",115,null],[11,"read_to_end","","",115,null],[11,"read_to_string","","",115,null],[11,"read_exact","","",115,null],[11,"write","","",115,null],[11,"flush","","",115,null],[11,"write_all","","",115,null],[11,"write_fmt","","",115,null],[11,"seek","","",115,null],[11,"fill_buf","","",115,null],[11,"consume","","",115,null],[11,"read_until","","",115,null],[11,"read_line","","",115,null],[11,"write","std::vec","",131,null],[11,"write_all","","",131,null],[11,"flush","","",131,null],[11,"read","std::io","",152,null],[11,"fill_buf","","",152,null],[11,"consume","","",152,null],[11,"read","","",153,null],[11,"write","","",154,null],[11,"flush","","",154,null],[11,"lock","","Locks this handle to the standard input stream, returning a readable\nguard.",155,null],[11,"read_line","","Locks this handle and reads a line of input into the specified buffer.",155,null],[11,"read","","",155,null],[11,"read_to_end","","",155,null],[11,"read_to_string","","",155,null],[11,"read_exact","","",155,null],[11,"read","","",156,null],[11,"read_to_end","","",156,null],[11,"fill_buf","","",156,null],[11,"consume","","",156,null],[11,"lock","","Locks this handle to the standard output stream, returning a writable\nguard.",157,null],[11,"write","","",157,null],[11,"flush","","",157,null],[11,"write_all","","",157,null],[11,"write_fmt","","",157,null],[11,"write","","",158,null],[11,"flush","","",158,null],[11,"lock","","Locks this handle to the standard error stream, returning a writable\nguard.",159,null],[11,"write","","",159,null],[11,"flush","","",159,null],[11,"write_all","","",159,null],[11,"write_fmt","","",159,null],[11,"write","","",160,null],[11,"flush","","",160,null],[6,"Result","","A specialized [`Result`](../result/enum.Result.html) type for I/O\noperations.",null,null],[8,"Read","","The `Read` trait allows for reading bytes from a source.",null,null],[10,"read","","Pull some bytes from this source into the specified buffer, returning\nhow many bytes were read.",161,null],[11,"read_to_end","","Read all bytes until EOF in this source, placing them into `buf`.",161,null],[11,"read_to_string","","Read all bytes until EOF in this source, placing them into `buf`.",161,null],[11,"read_exact","","Read the exact number of bytes required to fill `buf`.",161,null],[11,"by_ref","","Creates a &quot;by reference&quot; adaptor for this instance of `Read`.",161,null],[11,"bytes","","Transforms this `Read` instance to an `Iterator` over its bytes.",161,null],[11,"chars","","Transforms this `Read` instance to an `Iterator` over `char`s.",161,null],[11,"chain","","Creates an adaptor which will chain this stream with another.",161,null],[11,"take","","Creates an adaptor which will read at most `limit` bytes from it.",161,null],[8,"Write","","A trait for objects which are byte-oriented sinks.",null,null],[10,"write","","Write a buffer into this object, returning how many bytes were written.",162,null],[10,"flush","","Flush this output stream, ensuring that all intermediately buffered\ncontents reach their destination.",162,null],[11,"write_all","","Attempts to write an entire buffer into this write.",162,null],[11,"write_fmt","","Writes a formatted string into this writer, returning any error\nencountered.",162,null],[11,"by_ref","","Creates a &quot;by reference&quot; adaptor for this instance of `Write`.",162,null],[8,"Seek","","The `Seek` trait provides a cursor which can be moved within a stream of\nbytes.",null,null],[10,"seek","","Seek to an offset, in bytes, in a stream.",163,null],[8,"BufRead","","A `BufRead` is a type of `Read`er which has an internal buffer, allowing it\nto perform extra ways of reading.",null,null],[10,"fill_buf","","Fills the internal buffer of this object, returning the buffer contents.",164,null],[10,"consume","","Tells this buffer that `amt` bytes have been consumed from the buffer,\nso they should no longer be returned in calls to `read`.",164,null],[11,"read_until","","Read all bytes into `buf` until the delimiter `byte` or EOF is reached.",164,null],[11,"read_line","","Read all bytes until a newline (the 0xA byte) is reached, and append\nthem to the provided buffer.",164,null],[11,"split","","Returns an iterator over the contents of this reader split on the byte\n`byte`.",164,null],[11,"lines","","Returns an iterator over the lines of this reader.",164,null],[11,"eq","","",144,null],[11,"ne","","",144,null],[11,"clone","","",144,null],[11,"fmt","","",144,null],[11,"read","","",165,null],[11,"fill_buf","","",165,null],[11,"consume","","",165,null],[11,"limit","","Returns the number of bytes that can be read before this instance will\nreturn EOF.",166,null],[11,"into_inner","","Consumes the `Take`, returning the wrapped reader.",166,null],[11,"read","","",166,null],[11,"fill_buf","","",166,null],[11,"consume","","",166,null],[11,"next","","",167,null],[11,"fmt","","",145,null],[11,"next","","",168,null],[11,"description","","",145,null],[11,"cause","","",145,null],[11,"fmt","","",145,null],[11,"next","","",169,null],[11,"next","","",170,null],[0,"net","std","Networking primitives for TCP/UDP communication.",null,null],[3,"Ipv4Addr","std::net","Representation of an IPv4 address.",null,null],[3,"Ipv6Addr","","Representation of an IPv6 address.",null,null],[3,"SocketAddrV4","","An IPv4 socket address which is a (ip, port) combination.",null,null],[3,"SocketAddrV6","","An IPv6 socket address.",null,null],[3,"TcpStream","","A structure which represents a TCP stream between a local socket and a\nremote socket.",null,null],[3,"TcpListener","","A structure representing a socket server.",null,null],[3,"Incoming","","An infinite iterator over the connections from a `TcpListener`.",null,null],[3,"UdpSocket","","A User Datagram Protocol socket.",null,null],[3,"AddrParseError","","An error returned when parsing an IP address or a socket address.",null,null],[3,"LookupHost","","An iterator over `SocketAddr` values returned from a host lookup operation.",null,null],[4,"IpAddr","","An IP address, either an IPv4 or IPv6 address.",null,null],[13,"V4","","Representation of an IPv4 address.",171,null],[13,"V6","","Representation of an IPv6 address.",171,null],[4,"Ipv6MulticastScope","","",null,null],[13,"InterfaceLocal","","",172,null],[13,"LinkLocal","","",172,null],[13,"RealmLocal","","",172,null],[13,"AdminLocal","","",172,null],[13,"SiteLocal","","",172,null],[13,"OrganizationLocal","","",172,null],[13,"Global","","",172,null],[4,"SocketAddr","","Representation of a socket address for networking applications.",null,null],[13,"V4","","An IPv4 socket address which is a (ip, port) combination.",173,null],[13,"V6","","An IPv6 socket address.",173,null],[4,"Shutdown","","Possible values which can be passed to the [`shutdown`] method of\n[`TcpStream`].",null,null],[13,"Read","","Indicates that the reading portion of this stream/socket should be shut\ndown. All currently blocked and future reads will return `Ok(0)`.",174,null],[13,"Write","","Indicates that the writing portion of this stream/socket should be shut\ndown. All currently blocked and future writes will return an error.",174,null],[13,"Both","","Shut down both the reading and writing portions of this stream.",174,null],[5,"lookup_host","","Resolve the host specified by `host` as a number of `SocketAddr` instances.",null,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"clone","","",171,null],[11,"eq","","",171,null],[11,"ne","","",171,null],[11,"fmt","","",171,null],[11,"hash","","",171,null],[11,"partial_cmp","","",171,null],[11,"lt","","",171,null],[11,"le","","",171,null],[11,"gt","","",171,null],[11,"ge","","",171,null],[11,"cmp","","",171,null],[11,"eq","","",172,null],[11,"clone","","",172,null],[11,"hash","","",172,null],[11,"fmt","","",172,null],[11,"is_unspecified","","Returns true for the special &#39;unspecified&#39; address ([IPv4], [IPv6]).",171,null],[11,"is_loopback","","Returns true if this is a loopback address ([IPv4], [IPv6]).",171,null],[11,"is_global","","Returns true if the address appears to be globally routable ([IPv4], [IPv6]).",171,null],[11,"is_multicast","","Returns true if this is a multicast address ([IPv4], [IPv6]).",171,null],[11,"is_documentation","","Returns true if this address is in a range designated for documentation ([IPv4], [IPv6]).",171,null],[11,"is_ipv4","","Returns true if this address is a valid IPv4 address, false if it&#39;s a valid IPv6 address.",171,null],[11,"is_ipv6","","Returns true if this address is a valid IPv6 address, false if it&#39;s a valid IPv4 address.",171,null],[11,"new","","Creates a new IPv4 address from four eight-bit octets.",175,{"inputs":[{"name":"u8"},{"name":"u8"},{"name":"u8"},{"name":"u8"}],"output":{"name":"ipv4addr"}}],[11,"octets","","Returns the four eight-bit integers that make up this address.",175,null],[11,"is_unspecified","","Returns true for the special &#39;unspecified&#39; address (0.0.0.0).",175,null],[11,"is_loopback","","Returns true if this is a loopback address (127.0.0.0/8).",175,null],[11,"is_private","","Returns true if this is a private address.",175,null],[11,"is_link_local","","Returns true if the address is link-local (169.254.0.0/16).",175,null],[11,"is_global","","Returns true if the address appears to be globally routable.\nSee [iana-ipv4-special-registry][ipv4-sr].",175,null],[11,"is_multicast","","Returns true if this is a multicast address (224.0.0.0/4).",175,null],[11,"is_broadcast","","Returns true if this is a broadcast address (255.255.255.255).",175,null],[11,"is_documentation","","Returns true if this address is in a range designated for documentation.",175,null],[11,"to_ipv6_compatible","","Converts this address to an IPv4-compatible IPv6 address.",175,null],[11,"to_ipv6_mapped","","Converts this address to an IPv4-mapped IPv6 address.",175,null],[11,"fmt","","",171,null],[11,"fmt","","",175,null],[11,"fmt","","",175,null],[11,"clone","","",175,null],[11,"eq","","",175,null],[11,"hash","","",175,null],[11,"partial_cmp","","",175,null],[11,"cmp","","",175,null],[11,"from","","",175,{"inputs":[{"name":"u32"}],"output":{"name":"ipv4addr"}}],[11,"from","","",175,null],[11,"new","","Creates a new IPv6 address from eight 16-bit segments.",176,{"inputs":[{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"},{"name":"u16"}],"output":{"name":"ipv6addr"}}],[11,"segments","","Returns the eight 16-bit segments that make up this address.",176,null],[11,"is_unspecified","","Returns true for the special &#39;unspecified&#39; address (::).",176,null],[11,"is_loopback","","Returns true if this is a loopback address (::1).",176,null],[11,"is_global","","Returns true if the address appears to be globally routable.",176,null],[11,"is_unique_local","","Returns true if this is a unique local address (fc00::/7).",176,null],[11,"is_unicast_link_local","","Returns true if the address is unicast and link-local (fe80::/10).",176,null],[11,"is_unicast_site_local","","Returns true if this is a deprecated unicast site-local address\n(fec0::/10).",176,null],[11,"is_documentation","","Returns true if this is an address reserved for documentation\n(2001:db8::/32).",176,null],[11,"is_unicast_global","","Returns true if the address is a globally routable unicast address.",176,null],[11,"multicast_scope","","Returns the address&#39;s multicast scope if the address is multicast.",176,null],[11,"is_multicast","","Returns true if this is a multicast address (ff00::/8).",176,null],[11,"to_ipv4","","Converts this address to an IPv4 address. Returns None if this address is\nneither IPv4-compatible or IPv4-mapped.",176,null],[11,"octets","","Returns the sixteen eight-bit integers the IPv6 address consists of.",176,null],[11,"fmt","","",176,null],[11,"fmt","","",176,null],[11,"clone","","",176,null],[11,"eq","","",176,null],[11,"hash","","",176,null],[11,"partial_cmp","","",176,null],[11,"cmp","","",176,null],[11,"from","","",176,null],[11,"clone","","",173,null],[11,"eq","","",173,null],[11,"ne","","",173,null],[11,"hash","","",173,null],[11,"fmt","","",173,null],[11,"new","","Creates a new socket address from the (ip, port) pair.",173,{"inputs":[{"name":"ipaddr"},{"name":"u16"}],"output":{"name":"socketaddr"}}],[11,"ip","","Returns the IP address associated with this socket address.",173,null],[11,"set_ip","","Change the IP address associated with this socket address.",173,null],[11,"port","","Returns the port number associated with this socket address.",173,null],[11,"set_port","","Change the port number associated with this socket address.",173,null],[11,"is_ipv4","","Returns true if the IP in this `SocketAddr` is a valid IPv4 address,\nfalse if it&#39;s a valid IPv6 address.",173,null],[11,"is_ipv6","","Returns true if the IP in this `SocketAddr` is a valid IPv6 address,\nfalse if it&#39;s a valid IPv4 address.",173,null],[11,"new","","Creates a new socket address from the (ip, port) pair.",177,{"inputs":[{"name":"ipv4addr"},{"name":"u16"}],"output":{"name":"socketaddrv4"}}],[11,"ip","","Returns the IP address associated with this socket address.",177,null],[11,"set_ip","","Change the IP address associated with this socket address.",177,null],[11,"port","","Returns the port number associated with this socket address.",177,null],[11,"set_port","","Change the port number associated with this socket address.",177,null],[11,"new","","Creates a new socket address from the ip/port/flowinfo/scope_id\ncomponents.",178,{"inputs":[{"name":"ipv6addr"},{"name":"u16"},{"name":"u32"},{"name":"u32"}],"output":{"name":"socketaddrv6"}}],[11,"ip","","Returns the IP address associated with this socket address.",178,null],[11,"set_ip","","Change the IP address associated with this socket address.",178,null],[11,"port","","Returns the port number associated with this socket address.",178,null],[11,"set_port","","Change the port number associated with this socket address.",178,null],[11,"flowinfo","","Returns the flow information associated with this address,\ncorresponding to the `sin6_flowinfo` field in C.",178,null],[11,"set_flowinfo","","Change the flow information associated with this socket address.",178,null],[11,"scope_id","","Returns the scope ID associated with this address,\ncorresponding to the `sin6_scope_id` field in C.",178,null],[11,"set_scope_id","","Change the scope ID associated with this socket address.",178,null],[11,"fmt","","",173,null],[11,"fmt","","",177,null],[11,"fmt","","",177,null],[11,"fmt","","",178,null],[11,"fmt","","",178,null],[11,"clone","","",177,null],[11,"clone","","",178,null],[11,"eq","","",177,null],[11,"eq","","",178,null],[11,"hash","","",177,null],[11,"hash","","",178,null],[11,"to_socket_addrs","","",173,null],[11,"to_socket_addrs","","",177,null],[11,"to_socket_addrs","","",178,null],[11,"connect","","Opens a TCP connection to a remote host.",179,{"inputs":[{"name":"a"}],"output":{"name":"result"}}],[11,"peer_addr","","Returns the socket address of the remote peer of this TCP connection.",179,null],[11,"local_addr","","Returns the socket address of the local half of this TCP connection.",179,null],[11,"shutdown","","Shuts down the read, write, or both halves of this connection.",179,null],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",179,null],[11,"set_read_timeout","","Sets the read timeout to the timeout specified.",179,null],[11,"set_write_timeout","","Sets the write timeout to the timeout specified.",179,null],[11,"read_timeout","","Returns the read timeout of this socket.",179,null],[11,"write_timeout","","Returns the write timeout of this socket.",179,null],[11,"set_nodelay","","Sets the value of the `TCP_NODELAY` option on this socket.",179,null],[11,"nodelay","","Gets the value of the `TCP_NODELAY` option on this socket.",179,null],[11,"set_ttl","","Sets the value for the `IP_TTL` option on this socket.",179,null],[11,"ttl","","Gets the value of the `IP_TTL` option for this socket.",179,null],[11,"take_error","","Get the value of the `SO_ERROR` option on this socket.",179,null],[11,"set_nonblocking","","Moves this TCP stream into or out of nonblocking mode.",179,null],[11,"read","","",179,null],[11,"read_to_end","","",179,null],[11,"write","","",179,null],[11,"flush","","",179,null],[11,"fmt","","",179,null],[11,"bind","","Creates a new `TcpListener` which will be bound to the specified\naddress.",180,{"inputs":[{"name":"a"}],"output":{"name":"result"}}],[11,"local_addr","","Returns the local socket address of this listener.",180,null],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",180,null],[11,"accept","","Accept a new incoming connection from this listener.",180,null],[11,"incoming","","Returns an iterator over the connections being received on this\nlistener.",180,null],[11,"set_ttl","","Sets the value for the `IP_TTL` option on this socket.",180,null],[11,"ttl","","Gets the value of the `IP_TTL` option for this socket.",180,null],[11,"set_only_v6","","Sets the value for the `IPV6_V6ONLY` option on this socket.",180,null],[11,"only_v6","","Gets the value of the `IPV6_V6ONLY` option for this socket.",180,null],[11,"take_error","","Get the value of the `SO_ERROR` option on this socket.",180,null],[11,"set_nonblocking","","Moves this TCP stream into or out of nonblocking mode.",180,null],[11,"next","","",181,null],[11,"fmt","","",180,null],[11,"bind","","Creates a UDP socket from the given address.",182,{"inputs":[{"name":"a"}],"output":{"name":"result"}}],[11,"recv_from","","Receives data from the socket. On success, returns the number of bytes\nread and the address from whence the data came.",182,null],[11,"send_to","","Sends data on the socket to the given address. On success, returns the\nnumber of bytes written.",182,null],[11,"local_addr","","Returns the socket address that this socket was created from.",182,null],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",182,null],[11,"set_read_timeout","","Sets the read timeout to the timeout specified.",182,null],[11,"set_write_timeout","","Sets the write timeout to the timeout specified.",182,null],[11,"read_timeout","","Returns the read timeout of this socket.",182,null],[11,"write_timeout","","Returns the write timeout of this socket.",182,null],[11,"set_broadcast","","Sets the value of the `SO_BROADCAST` option for this socket.",182,null],[11,"broadcast","","Gets the value of the `SO_BROADCAST` option for this socket.",182,null],[11,"set_multicast_loop_v4","","Sets the value of the `IP_MULTICAST_LOOP` option for this socket.",182,null],[11,"multicast_loop_v4","","Gets the value of the `IP_MULTICAST_LOOP` option for this socket.",182,null],[11,"set_multicast_ttl_v4","","Sets the value of the `IP_MULTICAST_TTL` option for this socket.",182,null],[11,"multicast_ttl_v4","","Gets the value of the `IP_MULTICAST_TTL` option for this socket.",182,null],[11,"set_multicast_loop_v6","","Sets the value of the `IPV6_MULTICAST_LOOP` option for this socket.",182,null],[11,"multicast_loop_v6","","Gets the value of the `IPV6_MULTICAST_LOOP` option for this socket.",182,null],[11,"set_ttl","","Sets the value for the `IP_TTL` option on this socket.",182,null],[11,"ttl","","Gets the value of the `IP_TTL` option for this socket.",182,null],[11,"join_multicast_v4","","Executes an operation of the `IP_ADD_MEMBERSHIP` type.",182,null],[11,"join_multicast_v6","","Executes an operation of the `IPV6_ADD_MEMBERSHIP` type.",182,null],[11,"leave_multicast_v4","","Executes an operation of the `IP_DROP_MEMBERSHIP` type.",182,null],[11,"leave_multicast_v6","","Executes an operation of the `IPV6_DROP_MEMBERSHIP` type.",182,null],[11,"take_error","","Get the value of the `SO_ERROR` option on this socket.",182,null],[11,"connect","","Connects this UDP socket to a remote address, allowing the `send` and\n`recv` syscalls to be used to send data and also applies filters to only\nreceive data from the specified address.",182,null],[11,"send","","Sends data on the socket to the remote address to which it is connected.",182,null],[11,"recv","","Receives data on the socket from the remote address to which it is\nconnected.",182,null],[11,"set_nonblocking","","Moves this UDP socket into or out of nonblocking mode.",182,null],[11,"fmt","","",182,null],[11,"from_str","","",171,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",175,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",176,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",177,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",178,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",173,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"fmt","","",183,null],[11,"clone","","",183,null],[11,"eq","","",183,null],[11,"ne","","",183,null],[11,"fmt","","",183,null],[11,"description","","",183,null],[8,"ToSocketAddrs","","A trait for objects which can be converted or resolved to one or more\n`SocketAddr` values.",null,null],[16,"Iter","","Returned iterator over socket addresses which this type may correspond\nto.",184,null],[10,"to_socket_addrs","","Converts this object to an iterator of resolved `SocketAddr`s.",184,null],[11,"clone","","",174,null],[11,"eq","","",174,null],[11,"fmt","","",174,null],[11,"next","","",185,null],[0,"num","std","Additional functionality for numerics.",null,null],[8,"Zero","std::num","Types that have a &quot;zero&quot; value.",null,null],[10,"zero","","The &quot;zero&quot; (usually, additive identity) for this type.",186,{"inputs":[],"output":{"name":"self"}}],[8,"One","","Types that have a &quot;one&quot; value.",null,null],[10,"one","","The &quot;one&quot; (usually, multiplicative identity) for this type.",187,{"inputs":[],"output":{"name":"self"}}],[4,"FpCategory","","A classification of floating point numbers.",null,null],[13,"Nan","","&quot;Not a Number&quot;, often obtained by dividing by zero.",188,null],[13,"Infinite","","Positive or negative infinity.",188,null],[13,"Zero","","Positive or negative zero.",188,null],[13,"Subnormal","","De-normalized floating point representation (less precise than `Normal`).",188,null],[13,"Normal","","A regular floating point number.",188,null],[3,"ParseIntError","","An error which can be returned when parsing an integer.",null,null],[3,"ParseFloatError","","An error which can be returned when parsing a float.",null,null],[3,"TryFromIntError","","The error type returned when a checked integral type conversion fails.",null,null],[3,"Wrapping","","Provides intentionally-wrapped arithmetic on `T`.",null,null],[12,"0","","",189,null],[0,"os","std","OS-specific functionality.",null,null],[0,"unix","std::os","Experimental extensions to `std` for Unix platforms.",null,null],[0,"io","std::os::unix","Unix-specific extensions to general I/O primitives",null,null],[6,"RawFd","std::os::unix::io","Raw file descriptors.",null,null],[8,"AsRawFd","","A trait to extract the raw unix file descriptor from an underlying\nobject.",null,null],[10,"as_raw_fd","","Extracts the raw file descriptor.",190,null],[8,"FromRawFd","","A trait to express the ability to construct an object from a raw file\ndescriptor.",null,null],[10,"from_raw_fd","","Constructs a new instance of `Self` from the given raw file\ndescriptor.",191,{"inputs":[{"name":"rawfd"}],"output":{"name":"self"}}],[8,"IntoRawFd","","A trait to express the ability to consume an object and acquire ownership of\nits raw file descriptor.",null,null],[10,"into_raw_fd","","Consumes this object, returning the raw underlying file descriptor.",192,null],[0,"ffi","std::os::unix","Unix-specific extension to the primitives in the `std::ffi` module",null,null],[8,"OsStringExt","std::os::unix::ffi","Unix-specific extensions to `OsString`.",null,null],[10,"from_vec","","Creates an `OsString` from a byte vector.",193,{"inputs":[{"name":"vec"}],"output":{"name":"self"}}],[10,"into_vec","","Yields the underlying byte vector of this `OsString`.",193,null],[8,"OsStrExt","","Unix-specific extensions to `OsStr`.",null,null],[10,"from_bytes","","",194,null],[10,"as_bytes","","Gets the underlying byte view of the `OsStr` slice.",194,null],[0,"fs","std::os::unix","Unix-specific extensions to primitives in the `std::fs` module.",null,null],[5,"symlink","std::os::unix::fs","Creates a new symbolic link on the filesystem.",null,{"inputs":[{"name":"p"},{"name":"q"}],"output":{"name":"result"}}],[8,"FileExt","","Unix-specific extensions to `File`",null,null],[10,"read_at","","Reads a number of bytes starting from a given offset.",195,null],[10,"write_at","","Writes a number of bytes starting from a given offset.",195,null],[8,"PermissionsExt","","Unix-specific extensions to `Permissions`",null,null],[10,"mode","","Returns the underlying raw `mode_t` bits that are the standard Unix\npermissions for this file.",196,null],[10,"set_mode","","Sets the underlying raw bits for this set of permissions.",196,null],[10,"from_mode","","Creates a new instance of `Permissions` from the given set of Unix\npermission bits.",196,{"inputs":[{"name":"u32"}],"output":{"name":"self"}}],[8,"OpenOptionsExt","","Unix-specific extensions to `OpenOptions`",null,null],[10,"mode","","Sets the mode bits that a new file will be created with.",197,null],[10,"custom_flags","","Pass custom flags to the `flags` agument of `open`.",197,null],[8,"MetadataExt","","",null,null],[10,"dev","","",198,null],[10,"ino","","",198,null],[10,"mode","","",198,null],[10,"nlink","","",198,null],[10,"uid","","",198,null],[10,"gid","","",198,null],[10,"rdev","","",198,null],[10,"size","","",198,null],[10,"atime","","",198,null],[10,"atime_nsec","","",198,null],[10,"mtime","","",198,null],[10,"mtime_nsec","","",198,null],[10,"ctime","","",198,null],[10,"ctime_nsec","","",198,null],[10,"blksize","","",198,null],[10,"blocks","","",198,null],[8,"FileTypeExt","","Add special unix types (block/char device, fifo and socket)",null,null],[10,"is_block_device","","Returns whether this file type is a block device.",199,null],[10,"is_char_device","","Returns whether this file type is a char device.",199,null],[10,"is_fifo","","Returns whether this file type is a fifo.",199,null],[10,"is_socket","","Returns whether this file type is a socket.",199,null],[8,"DirEntryExt","","Unix-specific extension methods for `fs::DirEntry`",null,null],[10,"ino","","Returns the underlying `d_ino` field in the contained `dirent`\nstructure.",200,null],[8,"DirBuilderExt","","An extension trait for `fs::DirBuilder` for unix-specific options.",null,null],[10,"mode","","Sets the mode to create new directories with. This option defaults to\n0o777.",201,null],[0,"process","std::os::unix","Unix-specific extensions to primitives in the `std::process` module.",null,null],[8,"CommandExt","std::os::unix::process","Unix-specific extensions to the `std::process::Command` builder",null,null],[10,"uid","","Sets the child process&#39;s user id. This translates to a\n`setuid` call in the child process. Failure in the `setuid`\ncall will cause the spawn to fail.",202,null],[10,"gid","","Similar to `uid`, but sets the group id of the child process. This has\nthe same semantics as the `uid` field.",202,null],[10,"before_exec","","Schedules a closure to be run just before the `exec` function is\ninvoked.",202,null],[10,"exec","","Performs all the required setup by this `Command`, followed by calling\nthe `execvp` syscall.",202,null],[8,"ExitStatusExt","","Unix-specific extensions to `std::process::ExitStatus`",null,null],[10,"from_raw","","Creates a new `ExitStatus` from the raw underlying `i32` return value of\na process.",203,{"inputs":[{"name":"i32"}],"output":{"name":"self"}}],[10,"signal","","If the process was terminated by a signal, returns that signal.",203,null],[0,"raw","std::os::unix","Unix-specific primitives available on all unix platforms",null,null],[6,"uid_t","std::os::unix::raw","",null,null],[6,"gid_t","","",null,null],[6,"pid_t","","",null,null],[6,"pthread_t","","",null,null],[6,"dev_t","","",null,null],[6,"ino_t","","",null,null],[6,"mode_t","","",null,null],[6,"nlink_t","","",null,null],[6,"off_t","","",null,null],[6,"blksize_t","","",null,null],[6,"blkcnt_t","","",null,null],[6,"time_t","","",null,null],[0,"thread","std::os::unix","Unix-specific extensions to primitives in the `std::thread` module.",null,null],[6,"RawPthread","std::os::unix::thread","",null,null],[8,"JoinHandleExt","","Unix-specific extensions to `std::thread::JoinHandle`",null,null],[10,"as_pthread_t","","Extracts the raw pthread_t without taking ownership",204,null],[10,"into_pthread_t","","Consumes the thread, returning the raw pthread_t",204,null],[0,"net","std::os::unix","Unix-specific networking functionality",null,null],[3,"SocketAddr","std::os::unix::net","An address associated with a Unix socket.",null,null],[3,"UnixStream","","A Unix stream socket.",null,null],[3,"UnixListener","","A structure representing a Unix domain socket server.",null,null],[3,"Incoming","","An iterator over incoming connections to a `UnixListener`.",null,null],[3,"UnixDatagram","","A Unix datagram socket.",null,null],[0,"prelude","std::os::unix","A prelude for conveniently writing platform-specific code.",null,null],[0,"linux","std::os","Linux-specific definitions",null,null],[0,"raw","std::os::linux","Linux-specific raw type definitions",null,null],[3,"stat","std::os::linux::raw","",null,null],[12,"st_dev","","",205,null],[12,"__pad1","","",205,null],[12,"__st_ino","","",205,null],[12,"st_mode","","",205,null],[12,"st_nlink","","",205,null],[12,"st_uid","","",205,null],[12,"st_gid","","",205,null],[12,"st_rdev","","",205,null],[12,"__pad2","","",205,null],[12,"st_size","","",205,null],[12,"st_blksize","","",205,null],[12,"st_blocks","","",205,null],[12,"st_atime","","",205,null],[12,"st_atime_nsec","","",205,null],[12,"st_mtime","","",205,null],[12,"st_mtime_nsec","","",205,null],[12,"st_ctime","","",205,null],[12,"st_ctime_nsec","","",205,null],[12,"st_ino","","",205,null],[11,"clone","","",205,null],[6,"dev_t","","",null,null],[6,"mode_t","","",null,null],[6,"pthread_t","","",null,null],[6,"off_t","","",null,null],[6,"ino_t","","",null,null],[6,"nlink_t","","",null,null],[6,"blksize_t","","",null,null],[6,"blkcnt_t","","",null,null],[6,"time_t","","",null,null],[0,"fs","std::os::linux","",null,null],[8,"MetadataExt","std::os::linux::fs","OS-specific extension methods for `fs::Metadata`",null,null],[10,"as_raw_stat","","Gain a reference to the underlying `stat` structure which contains\nthe raw information returned by the OS.",206,null],[10,"st_dev","","",206,null],[10,"st_ino","","",206,null],[10,"st_mode","","",206,null],[10,"st_nlink","","",206,null],[10,"st_uid","","",206,null],[10,"st_gid","","",206,null],[10,"st_rdev","","",206,null],[10,"st_size","","",206,null],[10,"st_atime","","",206,null],[10,"st_atime_nsec","","",206,null],[10,"st_mtime","","",206,null],[10,"st_mtime_nsec","","",206,null],[10,"st_ctime","","",206,null],[10,"st_ctime_nsec","","",206,null],[10,"st_blksize","","",206,null],[10,"st_blocks","","",206,null],[11,"as_raw_stat","std::fs","",135,null],[11,"st_dev","","",135,null],[11,"st_ino","","",135,null],[11,"st_mode","","",135,null],[11,"st_nlink","","",135,null],[11,"st_uid","","",135,null],[11,"st_gid","","",135,null],[11,"st_rdev","","",135,null],[11,"st_size","","",135,null],[11,"st_atime","","",135,null],[11,"st_atime_nsec","","",135,null],[11,"st_mtime","","",135,null],[11,"st_mtime_nsec","","",135,null],[11,"st_ctime","","",135,null],[11,"st_ctime_nsec","","",135,null],[11,"st_blksize","","",135,null],[11,"st_blocks","","",135,null],[0,"raw","std::os","Raw OS-specific types for the current platform/architecture",null,null],[4,"c_void","std::os::raw","Type used to construct void pointers for use with C.",null,null],[6,"c_char","","",null,null],[6,"c_schar","","",null,null],[6,"c_uchar","","",null,null],[6,"c_short","","",null,null],[6,"c_ushort","","",null,null],[6,"c_int","","",null,null],[6,"c_uint","","",null,null],[6,"c_long","","",null,null],[6,"c_ulong","","",null,null],[6,"c_longlong","","",null,null],[6,"c_ulonglong","","",null,null],[6,"c_float","","",null,null],[6,"c_double","","",null,null],[0,"panic","std","Panic support in the standard library",null,null],[3,"PanicInfo","std::panic","A struct providing information about a panic.",null,null],[3,"Location","","A struct containing information about the location of a panic.",null,null],[3,"AssertUnwindSafe","","A simple wrapper around a type to assert that it is unwind safe.",null,null],[12,"0","","",207,null],[5,"take_hook","","Unregisters the current panic hook, returning it.",null,{"inputs":[],"output":{"name":"box"}}],[5,"set_hook","","Registers a custom panic hook, replacing any that was previously registered.",null,{"inputs":[{"name":"box"}],"output":null}],[5,"catch_unwind","","Invokes a closure, capturing the cause of an unwinding panic if one occurs.",null,{"inputs":[{"name":"f"}],"output":{"name":"result"}}],[5,"resume_unwind","","Triggers a panic without invoking the panic hook.",null,null],[8,"UnwindSafe","","A marker trait which represents &quot;panic safe&quot; types in Rust.",null,null],[8,"RefUnwindSafe","","A marker trait representing types where a shared reference is considered\nunwind safe.",null,null],[11,"deref","","",207,null],[11,"deref_mut","","",207,null],[11,"call_once","","",207,null],[0,"path","std","Cross-platform path manipulation.",null,null],[3,"PrefixComponent","std::path","A Windows path prefix, e.g. `C:` or `\\\\server\\share`.",null,null],[3,"Components","","The core iterator giving the components of a path.",null,null],[3,"Iter","","An iterator over the components of a path, as `OsStr` slices.",null,null],[3,"PathBuf","","An owned, mutable path (akin to [`String`]).",null,null],[3,"Path","","A slice of a path (akin to [`str`]).",null,null],[3,"StripPrefixError","","An error returned from the `Path::strip_prefix` method indicating that the\nprefix was not found in `self`.",null,null],[3,"Display","","Helper struct for safely printing paths with `format!()` and `{}`",null,null],[4,"Prefix","","Path prefixes (Windows only).",null,null],[13,"Verbatim","","Prefix `\\\\?\\`, together with the given component immediately following it.",208,null],[13,"VerbatimUNC","","Prefix `\\\\?\\UNC\\`, with the &quot;server&quot; and &quot;share&quot; components following it.",208,null],[13,"VerbatimDisk","","Prefix like `\\\\?\\C:\\`, for the given drive letter",208,null],[13,"DeviceNS","","Prefix `\\\\.\\`, together with the given component immediately following it.",208,null],[13,"UNC","","Prefix `\\\\server\\share`, with the given &quot;server&quot; and &quot;share&quot; components.",208,null],[13,"Disk","","Prefix `C:` for the given disk drive.",208,null],[4,"Component","","A single component of a path.",null,null],[13,"Prefix","","A Windows path prefix, e.g. `C:` or `\\\\server\\share`.",209,null],[13,"RootDir","","The root directory component, appears after any prefix and before anything else",209,null],[13,"CurDir","","A reference to the current directory, i.e. `.`",209,null],[13,"ParentDir","","A reference to the parent directory, i.e. `..`",209,null],[13,"Normal","","A normal component, i.e. `a` and `b` in `a/b`",209,null],[5,"is_separator","","Determines whether the character is one of the permitted path\nseparators for the current platform.",null,{"inputs":[{"name":"char"}],"output":{"name":"bool"}}],[17,"MAIN_SEPARATOR","","The primary separator of path components for the current platform.",null,null],[11,"clone","","",208,null],[11,"fmt","","",208,null],[11,"hash","","",208,null],[11,"partial_cmp","","",208,null],[11,"lt","","",208,null],[11,"le","","",208,null],[11,"gt","","",208,null],[11,"ge","","",208,null],[11,"cmp","","",208,null],[11,"eq","","",208,null],[11,"ne","","",208,null],[11,"is_verbatim","","Determines if the prefix is verbatim, i.e. begins with `\\\\?\\`.",208,null],[11,"clone","","",210,null],[11,"fmt","","",210,null],[11,"kind","","The parsed prefix data.",210,null],[11,"as_os_str","","The raw `OsStr` slice for this prefix.",210,null],[11,"eq","","",210,null],[11,"partial_cmp","","",210,null],[11,"cmp","","",210,null],[11,"hash","","",210,null],[11,"clone","","",209,null],[11,"eq","","",209,null],[11,"ne","","",209,null],[11,"partial_cmp","","",209,null],[11,"lt","","",209,null],[11,"le","","",209,null],[11,"gt","","",209,null],[11,"ge","","",209,null],[11,"cmp","","",209,null],[11,"hash","","",209,null],[11,"fmt","","",209,null],[11,"as_os_str","","Extracts the underlying `OsStr` slice.",209,null],[11,"as_ref","","",209,null],[11,"clone","","",211,null],[11,"clone","","",212,null],[11,"fmt","","",211,null],[11,"as_path","","Extracts a slice corresponding to the portion of the path remaining for iteration.",211,null],[11,"as_ref","","",211,null],[11,"as_ref","","",211,null],[11,"fmt","","",212,null],[11,"as_path","","Extracts a slice corresponding to the portion of the path remaining for iteration.",212,null],[11,"as_ref","","",212,null],[11,"as_ref","","",212,null],[11,"next","","",212,null],[11,"next_back","","",212,null],[11,"next","","",211,null],[11,"next_back","","",211,null],[11,"eq","","",211,null],[11,"partial_cmp","","",211,null],[11,"cmp","","",211,null],[11,"clone","","",213,null],[11,"new","","Allocates an empty `PathBuf`.",213,{"inputs":[],"output":{"name":"pathbuf"}}],[11,"as_path","","Coerces to a [`Path`] slice.",213,null],[11,"push","","Extends `self` with `path`.",213,null],[11,"pop","","Truncate `self` to [`self.parent()`].",213,null],[11,"set_file_name","","Updates [`self.file_name()`] to `file_name`.",213,null],[11,"set_extension","","Updates [`self.extension()`] to `extension`.",213,null],[11,"into_os_string","","Consumes the `PathBuf`, yielding its internal [`OsString`] storage.",213,null],[11,"from","","",213,{"inputs":[{"name":"t"}],"output":{"name":"pathbuf"}}],[11,"from","","",213,{"inputs":[{"name":"osstring"}],"output":{"name":"pathbuf"}}],[11,"from","std::ffi","",132,{"inputs":[{"name":"pathbuf"}],"output":{"name":"osstring"}}],[11,"from","std::path","",213,{"inputs":[{"name":"string"}],"output":{"name":"pathbuf"}}],[11,"from_iter","","",213,{"inputs":[{"name":"i"}],"output":{"name":"pathbuf"}}],[11,"extend","","",213,null],[11,"fmt","","",213,null],[11,"deref","","",213,null],[11,"borrow","","",213,null],[11,"from","std::borrow","",72,{"inputs":[{"name":"path"}],"output":{"name":"cow"}}],[11,"from","","",72,{"inputs":[{"name":"pathbuf"}],"output":{"name":"cow"}}],[11,"to_owned","std::path","",214,null],[11,"eq","","",213,null],[11,"hash","","",213,null],[11,"partial_cmp","","",213,null],[11,"cmp","","",213,null],[11,"as_ref","","",213,null],[11,"fmt","","",215,null],[11,"clone","","",215,null],[11,"eq","","",215,null],[11,"ne","","",215,null],[11,"new","","Directly wrap a string slice as a `Path` slice.",214,{"inputs":[{"name":"s"}],"output":{"name":"path"}}],[11,"as_os_str","","Yields the underlying [`OsStr`] slice.",214,null],[11,"to_str","","Yields a [`&amp;str`] slice if the `Path` is valid unicode.",214,null],[11,"to_string_lossy","","Converts a `Path` to a [`Cow&lt;str&gt;`].",214,null],[11,"to_path_buf","","Converts a `Path` to an owned [`PathBuf`].",214,null],[11,"is_absolute","","A path is *absolute* if it is independent of the current directory.",214,null],[11,"is_relative","","A path is *relative* if it is not absolute.",214,null],[11,"has_root","","A path has a root if the body of the path begins with the directory separator.",214,null],[11,"parent","","The path without its final component, if any.",214,null],[11,"file_name","","The final component of the path, if it is a normal file.",214,null],[11,"strip_prefix","","Returns a path that, when joined onto `base`, yields `self`.",214,null],[11,"starts_with","","Determines whether `base` is a prefix of `self`.",214,null],[11,"ends_with","","Determines whether `child` is a suffix of `self`.",214,null],[11,"file_stem","","Extracts the stem (non-extension) portion of [`self.file_name()`].",214,null],[11,"extension","","Extracts the extension of [`self.file_name()`], if possible.",214,null],[11,"join","","Creates an owned [`PathBuf`] with `path` adjoined to `self`.",214,null],[11,"with_file_name","","Creates an owned [`PathBuf`] like `self` but with the given file name.",214,null],[11,"with_extension","","Creates an owned [`PathBuf`] like `self` but with the given extension.",214,null],[11,"components","","Produce an iterator over the components of the path.",214,null],[11,"iter","","Produce an iterator over the path&#39;s components viewed as [`OsStr`] slices.",214,null],[11,"display","","Returns an object that implements [`Display`] for safely printing paths\nthat may contain non-Unicode data.",214,null],[11,"metadata","","Query the file system to get information about a file, directory, etc.",214,null],[11,"symlink_metadata","","Query the metadata about a file without following symlinks.",214,null],[11,"canonicalize","","Returns the canonical form of the path with all intermediate components\nnormalized and symbolic links resolved.",214,null],[11,"read_link","","Reads a symbolic link, returning the file that the link points to.",214,null],[11,"read_dir","","Returns an iterator over the entries within a directory.",214,null],[11,"exists","","Returns whether the path points at an existing entity.",214,null],[11,"is_file","","Returns whether the path is pointing at a regular file.",214,null],[11,"is_dir","","Returns whether the path is pointing at a directory.",214,null],[11,"as_ref","","",214,null],[11,"fmt","","",214,null],[11,"fmt","","",216,null],[11,"fmt","","",216,null],[11,"eq","","",214,null],[11,"hash","","",214,null],[11,"partial_cmp","","",214,null],[11,"cmp","","",214,null],[11,"as_ref","","",214,null],[11,"as_ref","std::ffi","",133,null],[11,"as_ref","std::borrow","",72,null],[11,"as_ref","std::ffi","",132,null],[11,"as_ref","std::string","",134,null],[11,"as_ref","std::path","",213,null],[11,"eq","","",213,null],[11,"eq","","",214,null],[11,"partial_cmp","","",213,null],[11,"partial_cmp","","",214,null],[11,"eq","","",213,null],[11,"partial_cmp","","",213,null],[11,"eq","std::borrow","",72,null],[11,"eq","std::path","",214,null],[11,"partial_cmp","std::borrow","",72,null],[11,"partial_cmp","std::path","",214,null],[11,"eq","std::borrow","",72,null],[11,"partial_cmp","","",72,null],[11,"eq","","",72,null],[11,"eq","std::path","",213,null],[11,"partial_cmp","std::borrow","",72,null],[11,"partial_cmp","std::path","",213,null],[11,"eq","","",213,null],[11,"eq","std::ffi","",133,null],[11,"partial_cmp","std::path","",213,null],[11,"partial_cmp","std::ffi","",133,null],[11,"eq","std::path","",213,null],[11,"partial_cmp","","",213,null],[11,"eq","","",213,null],[11,"eq","std::borrow","",72,null],[11,"partial_cmp","std::path","",213,null],[11,"partial_cmp","std::borrow","",72,null],[11,"eq","std::path","",213,null],[11,"eq","std::ffi","",132,null],[11,"partial_cmp","std::path","",213,null],[11,"partial_cmp","std::ffi","",132,null],[11,"eq","std::path","",214,null],[11,"eq","std::ffi","",133,null],[11,"partial_cmp","std::path","",214,null],[11,"partial_cmp","std::ffi","",133,null],[11,"eq","std::path","",214,null],[11,"partial_cmp","","",214,null],[11,"eq","","",214,null],[11,"eq","std::borrow","",72,null],[11,"partial_cmp","std::path","",214,null],[11,"partial_cmp","std::borrow","",72,null],[11,"eq","std::path","",214,null],[11,"eq","std::ffi","",132,null],[11,"partial_cmp","std::path","",214,null],[11,"partial_cmp","std::ffi","",132,null],[11,"eq","","",133,null],[11,"partial_cmp","","",133,null],[11,"eq","std::borrow","",72,null],[11,"partial_cmp","","",72,null],[11,"eq","std::ffi","",132,null],[11,"partial_cmp","","",132,null],[11,"eq","std::borrow","",72,null],[11,"eq","std::ffi","",133,null],[11,"partial_cmp","std::borrow","",72,null],[11,"partial_cmp","std::ffi","",133,null],[11,"eq","std::borrow","",72,null],[11,"partial_cmp","","",72,null],[11,"eq","","",72,null],[11,"eq","std::ffi","",132,null],[11,"partial_cmp","std::borrow","",72,null],[11,"partial_cmp","std::ffi","",132,null],[11,"fmt","std::path","",215,null],[11,"description","","",215,null],[0,"process","std","A module for working with processes.",null,null],[3,"Child","std::process","Representation of a running or exited child process.",null,null],[12,"stdin","","The handle for writing to the child&#39;s stdin, if it has been captured",217,null],[12,"stdout","","The handle for reading from the child&#39;s stdout, if it has been captured",217,null],[12,"stderr","","The handle for reading from the child&#39;s stderr, if it has been captured",217,null],[3,"ChildStdin","","A handle to a child process&#39;s stdin. This struct is used in the [`stdin`]\nfield on [`Child`].",null,null],[3,"ChildStdout","","A handle to a child process&#39;s stdout. This struct is used in the [`stdout`]\nfield on [`Child`].",null,null],[3,"ChildStderr","","A handle to a child process&#39;s stderr. This struct is used in the [`stderr`]\nfield on [`Child`].",null,null],[3,"Command","","A process builder, providing fine-grained control\nover how a new process should be spawned.",null,null],[3,"Output","","The output of a finished process.",null,null],[12,"status","","The status (exit code) of the process.",218,null],[12,"stdout","","The data that the process wrote to stdout.",218,null],[12,"stderr","","The data that the process wrote to stderr.",218,null],[3,"Stdio","","Describes what to do with a standard I/O stream for a child process.",null,null],[3,"ExitStatus","","Describes the result of a process after it has terminated.",null,null],[5,"exit","","Terminates the current process with the specified exit code.",null,null],[5,"abort","","Terminates the process in an abnormal fashion.",null,null],[11,"write","","",219,null],[11,"flush","","",219,null],[11,"read","","",220,null],[11,"read_to_end","","",220,null],[11,"read","","",221,null],[11,"read_to_end","","",221,null],[11,"new","","Constructs a new `Command` for launching the program at\npath `program`, with the following default configuration:",222,{"inputs":[{"name":"s"}],"output":{"name":"command"}}],[11,"arg","","Add an argument to pass to the program.",222,null],[11,"args","","Add multiple arguments to pass to the program.",222,null],[11,"env","","Inserts or updates an environment variable mapping.",222,null],[11,"env_remove","","Removes an environment variable mapping.",222,null],[11,"env_clear","","Clears the entire environment map for the child process.",222,null],[11,"current_dir","","Sets the working directory for the child process.",222,null],[11,"stdin","","Configuration for the child process&#39;s stdin handle (file descriptor 0).",222,null],[11,"stdout","","Configuration for the child process&#39;s stdout handle (file descriptor 1).",222,null],[11,"stderr","","Configuration for the child process&#39;s stderr handle (file descriptor 2).",222,null],[11,"spawn","","Executes the command as a child process, returning a handle to it.",222,null],[11,"output","","Executes the command as a child process, waiting for it to finish and\ncollecting all of its output.",222,null],[11,"status","","Executes a command as a child process, waiting for it to finish and\ncollecting its exit status.",222,null],[11,"fmt","","Format the program and arguments of a Command for display. Any\nnon-utf8 data is lossily converted using the utf8 replacement\ncharacter.",222,null],[11,"eq","","",218,null],[11,"ne","","",218,null],[11,"clone","","",218,null],[11,"fmt","","",218,null],[11,"piped","","A new pipe should be arranged to connect the parent and child processes.",223,{"inputs":[],"output":{"name":"stdio"}}],[11,"inherit","","The child inherits from the corresponding parent descriptor.",223,{"inputs":[],"output":{"name":"stdio"}}],[11,"null","","This stream will be ignored. This is the equivalent of attaching the\nstream to `/dev/null`",223,{"inputs":[],"output":{"name":"stdio"}}],[11,"eq","","",224,null],[11,"ne","","",224,null],[11,"clone","","",224,null],[11,"fmt","","",224,null],[11,"success","","Was termination successful? Signal termination not considered a success,\nand success is defined as a zero exit status.",224,null],[11,"code","","Returns the exit code of the process, if any.",224,null],[11,"fmt","","",224,null],[11,"kill","","Forces the child to exit. This is equivalent to sending a\nSIGKILL on unix platforms.",217,null],[11,"id","","Returns the OS-assigned process identifier associated with this child.",217,null],[11,"wait","","Waits for the child to exit completely, returning the status that it\nexited with. This function will continue to have the same return value\nafter it has been called at least once.",217,null],[11,"wait_with_output","","Simultaneously waits for the child to exit and collect all remaining\noutput on the stdout/stderr handles, returning an `Output`\ninstance.",217,null],[0,"sync","std","Useful synchronization primitives.",null,null],[3,"Arc","std::sync","A thread-safe reference-counting pointer.",null,null],[3,"Weak","","A weak version of [`Arc`][arc].",null,null],[0,"atomic","","Atomic types",null,null],[3,"AtomicBool","std::sync::atomic","A boolean type which can be safely shared between threads.",null,null],[3,"AtomicPtr","","A raw pointer type which can be safely shared between threads.",null,null],[4,"Ordering","","Atomic memory orderings",null,null],[13,"Relaxed","","No ordering constraints, only atomic operations. Corresponds to LLVM&#39;s\n`Monotonic` ordering.",225,null],[13,"Release","","When coupled with a store, all previous writes become visible\nto the other threads that perform a load with `Acquire` ordering\non the same value.",225,null],[13,"Acquire","","When coupled with a load, all subsequent loads will see data\nwritten before a store with `Release` ordering on the same value\nin other threads.",225,null],[13,"AcqRel","","When coupled with a load, uses `Acquire` ordering, and with a store\n`Release` ordering.",225,null],[13,"SeqCst","","Like `AcqRel` with the additional guarantee that all threads see all\nsequentially consistent operations in the same order.",225,null],[17,"ATOMIC_BOOL_INIT","","An `AtomicBool` initialized to `false`.",null,null],[3,"AtomicI8","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_I8_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicU8","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_U8_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicI16","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_I16_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicU16","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_U16_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicI32","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_I32_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicU32","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_U32_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicI64","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_I64_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicU64","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_U64_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicIsize","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_ISIZE_INIT","","An atomic integer initialized to `0`.",null,null],[3,"AtomicUsize","","An integer type which can be safely shared between threads.",null,null],[17,"ATOMIC_USIZE_INIT","","An atomic integer initialized to `0`.",null,null],[5,"fence","","An atomic fence.",null,null],[3,"Barrier","std::sync","A barrier enables multiple threads to synchronize the beginning\nof some computation.",null,null],[3,"BarrierWaitResult","","A result returned from wait.",null,null],[3,"Condvar","","A Condition Variable",null,null],[3,"WaitTimeoutResult","","A type indicating whether a timed wait on a condition variable returned\ndue to a time out or not.",null,null],[3,"Mutex","","A mutual exclusion primitive useful for protecting shared data",null,null],[3,"MutexGuard","","An RAII implementation of a &quot;scoped lock&quot; of a mutex. When this structure is\ndropped (falls out of scope), the lock will be unlocked.",null,null],[3,"Once","","A synchronization primitive which can be used to run a one-time global\ninitialization. Useful for one-time initialization for FFI or related\nfunctionality. This type can only be constructed with the `ONCE_INIT`\nvalue.",null,null],[3,"OnceState","","State yielded to the `call_once_force` method which can be used to query\nwhether the `Once` was previously poisoned or not.",null,null],[3,"PoisonError","","A type of error which can be returned whenever a lock is acquired.",null,null],[3,"RwLock","","A reader-writer lock",null,null],[3,"RwLockReadGuard","","RAII structure used to release the shared read access of a lock when\ndropped.",null,null],[3,"RwLockWriteGuard","","RAII structure used to release the exclusive write access of a lock when\ndropped.",null,null],[4,"TryLockError","","An enumeration of possible errors which can occur while calling the\n`try_lock` method.",null,null],[13,"Poisoned","","The lock could not be acquired because another thread failed while holding\nthe lock.",226,null],[13,"WouldBlock","","The lock could not be acquired at this time because the operation would\notherwise block.",226,null],[0,"mpsc","","Multi-producer, single-consumer FIFO queue communication primitives.",null,null],[3,"Select","std::sync::mpsc","The &quot;receiver set&quot; of the select interface. This structure is used to manage\na set of receivers which are being selected over.",null,null],[3,"Handle","","A handle to a receiver which is currently a member of a `Select` set of\nreceivers.  This handle is used to keep the receiver in the set as well as\ninteract with the underlying receiver.",null,null],[3,"Receiver","","The receiving-half of Rust&#39;s channel type. This half can only be owned by\none thread",null,null],[3,"Iter","","An iterator over messages on a receiver, this iterator will block\nwhenever `next` is called, waiting for a new message, and `None` will be\nreturned when the corresponding channel has hung up.",null,null],[3,"TryIter","","An iterator that attempts to yield all pending values for a receiver.\n`None` will be returned when there are no pending values remaining or\nif the corresponding channel has hung up.",null,null],[3,"IntoIter","","An owning iterator over messages on a receiver, this iterator will block\nwhenever `next` is called, waiting for a new message, and `None` will be\nreturned when the corresponding channel has hung up.",null,null],[3,"Sender","","The sending-half of Rust&#39;s asynchronous channel type. This half can only be\nowned by one thread, but it can be cloned to send to other threads.",null,null],[3,"SyncSender","","The sending-half of Rust&#39;s synchronous channel type. This half can only be\nowned by one thread, but it can be cloned to send to other threads.",null,null],[3,"SendError","","An error returned from the `send` function on channels.",null,null],[12,"0","","",227,null],[3,"RecvError","","An error returned from the `recv` function on a `Receiver`.",null,null],[4,"TryRecvError","","This enumeration is the list of the possible reasons that `try_recv` could\nnot return data when called.",null,null],[13,"Empty","","This channel is currently empty, but the sender(s) have not yet\ndisconnected, so data may yet become available.",228,null],[13,"Disconnected","","This channel&#39;s sending half has become disconnected, and there will\nnever be any more data received on this channel",228,null],[4,"RecvTimeoutError","","This enumeration is the list of possible errors that `recv_timeout` could\nnot return data when called.",null,null],[13,"Timeout","","This channel is currently empty, but the sender(s) have not yet\ndisconnected, so data may yet become available.",229,null],[13,"Disconnected","","This channel&#39;s sending half has become disconnected, and there will\nnever be any more data received on this channel",229,null],[4,"TrySendError","","This enumeration is the list of the possible error outcomes for the\n`SyncSender::try_send` method.",null,null],[13,"Full","","The data could not be sent on the channel because it would require that\nthe callee block to send the data.",230,null],[13,"Disconnected","","This channel&#39;s receiving half has disconnected, so the data could not be\nsent. The data is returned back to the callee in this case.",230,null],[5,"channel","","Creates a new asynchronous channel, returning the sender/receiver halves.\nAll data sent on the sender will become available on the receiver, and no\nsend will block the calling thread (this channel has an &quot;infinite buffer&quot;).",null,null],[5,"sync_channel","","Creates a new synchronous, bounded channel.",null,null],[11,"new","","Creates a new selection structure. This set is initially empty.",231,{"inputs":[],"output":{"name":"select"}}],[11,"handle","","Creates a new handle into this receiver set for a new receiver. Note\nthat this does *not* add the receiver to the receiver set, for that you\nmust call the `add` method on the handle itself.",231,null],[11,"wait","","Waits for an event on this receiver set. The returned value is *not* an\nindex, but rather an id. This id can be queried against any active\n`Handle` structures (each one has an `id` method). The handle with\nthe matching `id` will have some sort of event available on it. The\nevent could either be that data is available or the corresponding\nchannel has been closed.",231,null],[11,"id","","Retrieves the id of this handle.",232,null],[11,"recv","","Blocks to receive a value on the underlying receiver, returning `Some` on\nsuccess or `None` if the channel disconnects. This function has the same\nsemantics as `Receiver.recv`",232,null],[11,"add","","Adds this handle to the receiver set that the handle was created from. This\nmethod can be called multiple times, but it has no effect if `add` was\ncalled previously.",232,null],[11,"remove","","Removes this handle from the `Select` set. This method is unsafe because\nit has no guarantee that the `Handle` was not moved since `add` was\ncalled.",232,null],[11,"drop","","",231,null],[11,"drop","","",232,null],[11,"fmt","","",231,null],[11,"fmt","","",232,null],[11,"eq","","",227,null],[11,"ne","","",227,null],[11,"clone","","",227,null],[11,"eq","","",233,null],[11,"clone","","",233,null],[11,"fmt","","",233,null],[11,"eq","","",228,null],[11,"clone","","",228,null],[11,"fmt","","",228,null],[11,"eq","","",229,null],[11,"clone","","",229,null],[11,"fmt","","",229,null],[11,"eq","","",230,null],[11,"ne","","",230,null],[11,"clone","","",230,null],[11,"send","","Attempts to send a value on this channel, returning it back if it could\nnot be sent.",234,null],[11,"clone","","",234,null],[11,"drop","","",234,null],[11,"fmt","","",234,null],[11,"send","","Sends a value on this synchronous channel.",235,null],[11,"try_send","","Attempts to send a value on this channel without blocking.",235,null],[11,"clone","","",235,null],[11,"drop","","",235,null],[11,"fmt","","",235,null],[11,"try_recv","","Attempts to return a pending value on this receiver without blocking",236,null],[11,"recv","","Attempts to wait for a value on this receiver, returning an error if the\ncorresponding channel has hung up.",236,null],[11,"recv_timeout","","Attempts to wait for a value on this receiver, returning an error if the\ncorresponding channel has hung up, or if it waits more than `timeout`.",236,null],[11,"iter","","Returns an iterator that will block waiting for messages, but never\n`panic!`. It will return `None` when the channel has hung up.",236,null],[11,"try_iter","","Returns an iterator that will attempt to yield all pending values.\nIt will return `None` if there are no more pending values or if the\nchannel has hung up. The iterator will never `panic!` or block the\nuser by waiting for values.",236,null],[11,"next","","",237,null],[11,"next","","",238,null],[11,"next","","",239,null],[11,"into_iter","","",236,null],[11,"drop","","",236,null],[11,"fmt","","",236,null],[11,"fmt","","",227,null],[11,"fmt","","",227,null],[11,"description","","",227,null],[11,"cause","","",227,null],[11,"fmt","","",230,null],[11,"fmt","","",230,null],[11,"description","","",230,null],[11,"cause","","",230,null],[11,"fmt","","",233,null],[11,"description","","",233,null],[11,"cause","","",233,null],[11,"fmt","","",228,null],[11,"description","","",228,null],[11,"cause","","",228,null],[11,"fmt","","",229,null],[11,"description","","",229,null],[11,"cause","","",229,null],[11,"new","std::sync","Creates a new barrier that can block a given number of threads.",240,{"inputs":[{"name":"usize"}],"output":{"name":"barrier"}}],[11,"wait","","Blocks the current thread until all threads have rendezvoused here.",240,null],[11,"is_leader","","Returns whether this thread from `wait` is the &quot;leader thread&quot;.",241,null],[11,"fmt","","",242,null],[11,"eq","","",242,null],[11,"ne","","",242,null],[11,"clone","","",242,null],[11,"timed_out","","Returns whether the wait was known to have timed out.",242,null],[11,"new","","Creates a new condition variable which is ready to be waited on and\nnotified.",243,{"inputs":[],"output":{"name":"condvar"}}],[11,"wait","","Blocks the current thread until this condition variable receives a\nnotification.",243,null],[11,"wait_timeout_ms","","Waits on this condition variable for a notification, timing out after a\nspecified duration.",243,null],[11,"wait_timeout","","Waits on this condition variable for a notification, timing out after a\nspecified duration.",243,null],[11,"notify_one","","Wakes up one blocked thread on this condvar.",243,null],[11,"notify_all","","Wakes up all blocked threads on this condvar.",243,null],[11,"default","","Creates a `Condvar` which is ready to be waited on and notified.",243,{"inputs":[],"output":{"name":"condvar"}}],[11,"drop","","",243,null],[11,"new","","Creates a new mutex in an unlocked state ready for use.",244,{"inputs":[{"name":"t"}],"output":{"name":"mutex"}}],[11,"lock","","Acquires a mutex, blocking the current thread until it is able to do so.",244,null],[11,"try_lock","","Attempts to acquire this lock.",244,null],[11,"is_poisoned","","Determines whether the lock is poisoned.",244,null],[11,"into_inner","","Consumes this mutex, returning the underlying data.",244,null],[11,"get_mut","","Returns a mutable reference to the underlying data.",244,null],[11,"drop","","",244,null],[11,"default","","Creates a `Mutex&lt;T&gt;`, with the `Default` value for T.",244,{"inputs":[],"output":{"name":"mutex"}}],[11,"fmt","","",244,null],[11,"deref","","",245,null],[11,"deref_mut","","",245,null],[11,"drop","","",245,null],[11,"new","","Creates a new `Once` value.",246,{"inputs":[],"output":{"name":"once"}}],[11,"call_once","","Performs an initialization routine once and only once. The given closure\nwill be executed if this is the first time `call_once` has been called,\nand otherwise the routine will *not* be invoked.",246,null],[11,"call_once_force","","Performs the same function as `call_once` except ignores poisoning.",246,null],[11,"poisoned","","Returns whether the associated `Once` has been poisoned.",247,null],[11,"new","","Creates a new instance of an `RwLock&lt;T&gt;` which is unlocked.",248,{"inputs":[{"name":"t"}],"output":{"name":"rwlock"}}],[11,"read","","Locks this rwlock with shared read access, blocking the current thread\nuntil it can be acquired.",248,null],[11,"try_read","","Attempts to acquire this rwlock with shared read access.",248,null],[11,"write","","Locks this rwlock with exclusive write access, blocking the current\nthread until it can be acquired.",248,null],[11,"try_write","","Attempts to lock this rwlock with exclusive write access.",248,null],[11,"is_poisoned","","Determines whether the lock is poisoned.",248,null],[11,"into_inner","","Consumes this `RwLock`, returning the underlying data.",248,null],[11,"get_mut","","Returns a mutable reference to the underlying data.",248,null],[11,"drop","","",248,null],[11,"fmt","","",248,null],[11,"default","","Creates a new `RwLock&lt;T&gt;`, with the `Default` value for T.",248,{"inputs":[],"output":{"name":"rwlock"}}],[11,"deref","","",249,null],[11,"deref","","",250,null],[11,"deref_mut","","",250,null],[11,"drop","","",249,null],[11,"drop","","",250,null],[6,"TryLockResult","","A type alias for the result of a nonblocking locking method.",null,null],[6,"LockResult","","A type alias for the result of a lock method which can be poisoned.",null,null],[17,"ONCE_INIT","","Initialization value for static `Once` values.",null,null],[0,"time","std","Temporal quantification.",null,null],[3,"Duration","std::time","A duration type to represent a span of time, typically used for system\ntimeouts.",null,null],[3,"Instant","","A measurement of a monotonically increasing clock.\n Opaque and useful only with `Duration`.",null,null],[3,"SystemTime","","A measurement of the system clock, useful for talking to\nexternal entities like the file system or other processes.",null,null],[3,"SystemTimeError","","An error returned from the `duration_since` method on `SystemTime`,\nused to learn how far in the opposite direction a system time lies.",null,null],[11,"clone","","",251,null],[11,"eq","","",251,null],[11,"ne","","",251,null],[11,"partial_cmp","","",251,null],[11,"lt","","",251,null],[11,"le","","",251,null],[11,"gt","","",251,null],[11,"ge","","",251,null],[11,"cmp","","",251,null],[11,"fmt","","",251,null],[11,"hash","","",251,null],[11,"default","","",251,{"inputs":[],"output":{"name":"duration"}}],[11,"new","","Creates a new `Duration` from the specified number of seconds and\nadditional nanosecond precision.",251,{"inputs":[{"name":"u64"},{"name":"u32"}],"output":{"name":"duration"}}],[11,"from_secs","","Creates a new `Duration` from the specified number of seconds.",251,{"inputs":[{"name":"u64"}],"output":{"name":"duration"}}],[11,"from_millis","","Creates a new `Duration` from the specified number of milliseconds.",251,{"inputs":[{"name":"u64"}],"output":{"name":"duration"}}],[11,"as_secs","","Returns the number of whole seconds represented by this duration.",251,null],[11,"subsec_nanos","","Returns the nanosecond precision represented by this duration.",251,null],[11,"checked_add","","Checked duration addition. Computes `self + other`, returning `None`\nif overflow occurred.",251,null],[11,"checked_sub","","Checked duration subtraction. Computes `self + other`, returning `None`\nif the result would be negative or if underflow occurred.",251,null],[11,"checked_mul","","Checked duration multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",251,null],[11,"checked_div","","Checked duration division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",251,null],[11,"add","","",251,null],[11,"add_assign","","",251,null],[11,"sub","","",251,null],[11,"sub_assign","","",251,null],[11,"mul","","",251,null],[11,"mul_assign","","",251,null],[11,"div","","",251,null],[11,"div_assign","","",251,null],[17,"UNIX_EPOCH","","An anchor in time which can be used to create new `SystemTime` instances or\nlearn about where in time a `SystemTime` lies.",null,null],[11,"clone","","",252,null],[11,"eq","","",252,null],[11,"ne","","",252,null],[11,"partial_cmp","","",252,null],[11,"lt","","",252,null],[11,"le","","",252,null],[11,"gt","","",252,null],[11,"ge","","",252,null],[11,"cmp","","",252,null],[11,"clone","","",253,null],[11,"eq","","",253,null],[11,"ne","","",253,null],[11,"partial_cmp","","",253,null],[11,"lt","","",253,null],[11,"le","","",253,null],[11,"gt","","",253,null],[11,"ge","","",253,null],[11,"cmp","","",253,null],[11,"clone","","",254,null],[11,"fmt","","",254,null],[11,"now","","Returns an instant corresponding to &quot;now&quot;.",252,{"inputs":[],"output":{"name":"instant"}}],[11,"duration_since","","Returns the amount of time elapsed from another instant to this one.",252,null],[11,"elapsed","","Returns the amount of time elapsed since this instant was created.",252,null],[11,"add","","",252,null],[11,"add_assign","","",252,null],[11,"sub","","",252,null],[11,"sub_assign","","",252,null],[11,"sub","","",252,null],[11,"fmt","","",252,null],[11,"now","","Returns the system time corresponding to &quot;now&quot;.",253,{"inputs":[],"output":{"name":"systemtime"}}],[11,"duration_since","","Returns the amount of time elapsed from an earlier point in time.",253,null],[11,"elapsed","","Returns the amount of time elapsed since this system time was created.",253,null],[11,"add","","",253,null],[11,"add_assign","","",253,null],[11,"sub","","",253,null],[11,"sub_assign","","",253,null],[11,"fmt","","",253,null],[11,"duration","","Returns the positive duration which represents how far forward the\nsecond system time was from the first.",254,null],[11,"description","","",254,null],[11,"fmt","","",254,null],[11,"fmt","std::sync","",255,null],[11,"fmt","","",255,null],[11,"description","","",255,null],[11,"new","","Creates a `PoisonError`.",255,{"inputs":[{"name":"t"}],"output":{"name":"poisonerror"}}],[11,"into_inner","","Consumes this error indicating that a lock is poisoned, returning the\nunderlying guard to allow access regardless.",255,null],[11,"get_ref","","Reaches into this error indicating that a lock is poisoned, returning a\nreference to the underlying guard to allow access regardless.",255,null],[11,"get_mut","","Reaches into this error indicating that a lock is poisoned, returning a\nmutable reference to the underlying guard to allow access regardless.",255,null],[11,"from","","",226,{"inputs":[{"name":"poisonerror"}],"output":{"name":"trylockerror"}}],[11,"fmt","","",226,null],[11,"fmt","","",226,null],[11,"description","","",226,null],[11,"cause","","",226,null],[11,"as_raw_fd","std::fs","",140,null],[11,"from_raw_fd","","",140,{"inputs":[{"name":"rawfd"}],"output":{"name":"file"}}],[11,"into_raw_fd","","",140,null],[11,"as_raw_fd","std::net","",179,null],[11,"as_raw_fd","","",180,null],[11,"as_raw_fd","","",182,null],[11,"from_raw_fd","","",179,{"inputs":[{"name":"rawfd"}],"output":{"name":"tcpstream"}}],[11,"from_raw_fd","","",180,{"inputs":[{"name":"rawfd"}],"output":{"name":"tcplistener"}}],[11,"from_raw_fd","","",182,{"inputs":[{"name":"rawfd"}],"output":{"name":"udpsocket"}}],[11,"into_raw_fd","","",179,null],[11,"into_raw_fd","","",180,null],[11,"into_raw_fd","","",182,null],[11,"from_vec","std::ffi","",132,{"inputs":[{"name":"vec"}],"output":{"name":"osstring"}}],[11,"into_vec","","",132,null],[11,"from_bytes","","",133,null],[11,"as_bytes","","",133,null],[11,"read_at","std::fs","",140,null],[11,"write_at","","",140,null],[11,"mode","","",138,null],[11,"set_mode","","",138,null],[11,"from_mode","","",138,{"inputs":[{"name":"u32"}],"output":{"name":"permissions"}}],[11,"mode","","",137,null],[11,"custom_flags","","",137,null],[11,"dev","","",135,null],[11,"ino","","",135,null],[11,"mode","","",135,null],[11,"nlink","","",135,null],[11,"uid","","",135,null],[11,"gid","","",135,null],[11,"rdev","","",135,null],[11,"size","","",135,null],[11,"atime","","",135,null],[11,"atime_nsec","","",135,null],[11,"mtime","","",135,null],[11,"mtime_nsec","","",135,null],[11,"ctime","","",135,null],[11,"ctime_nsec","","",135,null],[11,"blksize","","",135,null],[11,"blocks","","",135,null],[11,"is_block_device","","",139,null],[11,"is_char_device","","",139,null],[11,"is_fifo","","",139,null],[11,"is_socket","","",139,null],[11,"ino","","",141,null],[11,"mode","","",142,null],[11,"uid","std::process","",222,null],[11,"gid","","",222,null],[11,"before_exec","","",222,null],[11,"exec","","",222,null],[11,"from_raw","","",224,{"inputs":[{"name":"i32"}],"output":{"name":"self"}}],[11,"signal","","",224,null],[11,"from_raw_fd","","",223,{"inputs":[{"name":"rawfd"}],"output":{"name":"stdio"}}],[11,"as_raw_fd","","",219,null],[11,"as_raw_fd","","",220,null],[11,"as_raw_fd","","",221,null],[11,"into_raw_fd","","",219,null],[11,"into_raw_fd","","",220,null],[11,"into_raw_fd","","",221,null],[11,"as_pthread_t","std::thread","",98,null],[11,"into_pthread_t","","",98,null],[11,"clone","std::os::unix::net","",256,null],[11,"is_unnamed","","Returns true if and only if the address is unnamed.",256,null],[11,"as_pathname","","Returns the contents of this address if it is a `pathname` address.",256,null],[11,"fmt","","",256,null],[11,"fmt","","",257,null],[11,"connect","","Connects to the socket named by `path`.",257,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"pair","","Creates an unnamed pair of connected sockets.",257,{"inputs":[],"output":{"name":"result"}}],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",257,null],[11,"local_addr","","Returns the socket address of the local half of this connection.",257,null],[11,"peer_addr","","Returns the socket address of the remote half of this connection.",257,null],[11,"set_read_timeout","","Sets the read timeout for the socket.",257,null],[11,"set_write_timeout","","Sets the write timeout for the socket.",257,null],[11,"read_timeout","","Returns the read timeout of this socket.",257,null],[11,"write_timeout","","Returns the write timeout of this socket.",257,null],[11,"set_nonblocking","","Moves the socket into or out of nonblocking mode.",257,null],[11,"take_error","","Returns the value of the `SO_ERROR` option.",257,null],[11,"shutdown","","Shuts down the read, write, or both halves of this connection.",257,null],[11,"read","","",257,null],[11,"read_to_end","","",257,null],[11,"write","","",257,null],[11,"flush","","",257,null],[11,"as_raw_fd","","",257,null],[11,"from_raw_fd","","",257,{"inputs":[{"name":"rawfd"}],"output":{"name":"unixstream"}}],[11,"into_raw_fd","","",257,null],[11,"fmt","","",258,null],[11,"bind","","Creates a new `UnixListener` bound to the specified socket.",258,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"accept","","Accepts a new incoming connection to this listener.",258,null],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",258,null],[11,"local_addr","","Returns the local socket address of this listener.",258,null],[11,"set_nonblocking","","Moves the socket into or out of nonblocking mode.",258,null],[11,"take_error","","Returns the value of the `SO_ERROR` option.",258,null],[11,"incoming","","Returns an iterator over incoming connections.",258,null],[11,"as_raw_fd","","",258,null],[11,"from_raw_fd","","",258,{"inputs":[{"name":"rawfd"}],"output":{"name":"unixlistener"}}],[11,"into_raw_fd","","",258,null],[11,"fmt","","",259,null],[11,"next","","",259,null],[11,"size_hint","","",259,null],[11,"fmt","","",260,null],[11,"bind","","Creates a Unix datagram socket bound to the given path.",260,{"inputs":[{"name":"p"}],"output":{"name":"result"}}],[11,"unbound","","Creates a Unix Datagram socket which is not bound to any address.",260,{"inputs":[],"output":{"name":"result"}}],[11,"pair","","Create an unnamed pair of connected sockets.",260,{"inputs":[],"output":{"name":"result"}}],[11,"connect","","Connects the socket to the specified address.",260,null],[11,"try_clone","","Creates a new independently owned handle to the underlying socket.",260,null],[11,"local_addr","","Returns the address of this socket.",260,null],[11,"peer_addr","","Returns the address of this socket&#39;s peer.",260,null],[11,"recv_from","","Receives data from the socket.",260,null],[11,"recv","","Receives data from the socket.",260,null],[11,"send_to","","Sends data on the socket to the specified address.",260,null],[11,"send","","Sends data on the socket to the socket&#39;s peer.",260,null],[11,"set_read_timeout","","Sets the read timeout for the socket.",260,null],[11,"set_write_timeout","","Sets the write timeout for the socket.",260,null],[11,"read_timeout","","Returns the read timeout of this socket.",260,null],[11,"write_timeout","","Returns the write timeout of this socket.",260,null],[11,"set_nonblocking","","Moves the socket into or out of nonblocking mode.",260,null],[11,"take_error","","Returns the value of the `SO_ERROR` option.",260,null],[11,"shutdown","","Shut down the read, write, or both halves of this connection.",260,null],[11,"as_raw_fd","","",260,null],[11,"from_raw_fd","","",260,{"inputs":[{"name":"rawfd"}],"output":{"name":"unixdatagram"}}],[11,"into_raw_fd","","",260,null],[11,"payload","std::panic","Returns the payload associated with the panic.",261,null],[11,"location","","Returns information about the location from which the panic originated,\nif available.",261,null],[11,"file","","Returns the name of the source file from which the panic originated.",262,null],[11,"line","","Returns the line number from which the panic originated.",262,null],[14,"format","std","Use the syntax described in `std::fmt` to create a value of type `String`.\nSee [`std::fmt`][fmt] for more information.",null,null],[14,"vec","","Creates a `Vec` containing the arguments.",null,null],[14,"try","","Helper macro for reducing boilerplate code for matching `Result` together\nwith converting downstream errors.",null,null],[14,"writeln","","Write formatted data into a buffer, with a newline appended.",null,null],[14,"write","","Write formatted data into a buffer",null,null],[14,"unimplemented","","A standardized placeholder for marking unfinished code. It panics with the\nmessage `&quot;not yet implemented&quot;` when executed.",null,null],[14,"unreachable","","A utility macro for indicating unreachable code.",null,null],[14,"debug_assert_ne","","Asserts that two expressions are not equal to each other.",null,null],[14,"debug_assert_eq","","Asserts that two expressions are equal to each other.",null,null],[14,"debug_assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"assert_ne","","Asserts that two expressions are not equal to each other.",null,null],[14,"assert_eq","","Asserts that two expressions are equal to each other.",null,null],[14,"assert","","Ensure that a boolean expression is `true` at runtime.",null,null],[14,"panic","","The entry point for panic of Rust threads.",null,null],[14,"print","","Macro for printing to the standard output.",null,null],[14,"println","","Macro for printing to the standard output, with a newline. On all\nplatforms, the newline is the LINE FEED character (`\\n`/`U+000A`) alone\n(no additional CARRIAGE RETURN (`\\r`/`U+000D`).",null,null],[14,"select","","A macro to select an event from a number of receivers.",null,null],[14,"format_args","","The core macro for formatted string creation &amp; output.",null,null],[14,"env","","Inspect an environment variable at compile time.",null,null],[14,"option_env","","Optionally inspect an environment variable at compile time.",null,null],[14,"concat_idents","","Concatenate identifiers into one identifier.",null,null],[14,"concat","","Concatenates literals into a static string slice.",null,null],[14,"line","","A macro which expands to the line number on which it was invoked.",null,null],[14,"column","","A macro which expands to the column number on which it was invoked.",null,null],[14,"file","","A macro which expands to the file name from which it was invoked.",null,null],[14,"stringify","","A macro which stringifies its argument.",null,null],[14,"include_str","","Includes a utf8-encoded file as a string.",null,null],[14,"include_bytes","","Includes a file as a reference to a byte array.",null,null],[14,"module_path","","Expands to a string that represents the current module path.",null,null],[14,"cfg","","Boolean evaluation of configuration flags.",null,null],[14,"include","","Parse a file as an expression or an item according to the context.",null,null],[14,"thread_local","","Declare a new thread local storage key of type `std::thread::LocalKey`.",null,null],[15,"bool","","The boolean type.",null,null],[15,"char","","A character type.",null,null],[15,"pointer","","Raw, unsafe pointers, `*const T`, and `*mut T`.",null,null],[15,"array","","A fixed-size array, denoted `[T; N]`, for the element type, `T`, and the\nnon-negative compile-time constant size, `N`.",null,null],[15,"slice","","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[15,"str","","String slices.",null,null],[15,"tuple","","A finite heterogeneous sequence, `(T, U, ..)`.",null,null],[15,"f32","","The 32-bit floating point type.",null,null],[15,"f64","","The 64-bit floating point type.",null,null],[15,"i8","","The 8-bit signed integer type.",null,null],[15,"i16","","The 16-bit signed integer type.",null,null],[15,"i32","","The 32-bit signed integer type.",null,null],[15,"i64","","The 64-bit signed integer type.",null,null],[15,"u8","","The 8-bit unsigned integer type.",null,null],[15,"u16","","The 16-bit unsigned integer type.",null,null],[15,"u32","","The 32-bit unsigned integer type.",null,null],[15,"u64","","The 64-bit unsigned integer type.",null,null],[15,"isize","","The pointer-sized signed integer type.",null,null],[15,"usize","","The pointer-sized unsigned integer type.",null,null],[11,"is","std::any","Returns true if the boxed type is the same as `T`.",0,null],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type `T`, or\n`None` if it isn&#39;t.",0,null],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is of type `T`, or\n`None` if it isn&#39;t.",0,null],[11,"is","","Forwards to the method defined on the type `Any`.",0,null],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",0,null],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",0,null],[11,"deref","std::boxed","",115,null],[11,"deref","std::sync","",263,null],[11,"deref","std::rc","",264,null],[11,"from","std::boxed","",115,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"from","std::sync","",263,{"inputs":[{"name":"t"}],"output":{"name":"arc"}}],[11,"from","std::rc","",264,{"inputs":[{"name":"t"}],"output":{"name":"rc"}}],[11,"fmt","std::boxed","",115,null],[11,"fmt","std::sync","",263,null],[11,"fmt","std::rc","",264,null],[11,"next_back","std::boxed","",115,null],[11,"finalize","","",115,{"inputs":[{"name":"intermediatebox"}],"output":{"name":"box"}}],[11,"make_place","","",265,null],[11,"fmt","","",115,null],[11,"fmt","std::sync","",266,null],[11,"fmt","","",263,null],[11,"fmt","std::rc","",264,null],[11,"fmt","","",267,null],[11,"len","std::boxed","",115,null],[11,"is_empty","","",115,null],[11,"borrow","","",115,null],[11,"borrow","std::sync","",263,null],[11,"borrow","std::rc","",264,null],[11,"clone","std::boxed","Returns a new box with a `clone()` of this box&#39;s contents.",115,null],[11,"clone_from","","Copies `source`&#39;s contents into `self` without creating a new allocation.",115,null],[11,"clone","","",115,null],[11,"clone","","",115,null],[11,"clone","std::sync","Makes a clone of the `Arc` pointer.",263,null],[11,"clone","","Makes a clone of the `Weak` pointer.",266,null],[11,"clone","std::rc","Makes a clone of the `Rc` pointer.",264,null],[11,"clone","","Makes a clone of the `Weak` pointer.",267,null],[11,"clone","std::boxed","",265,null],[11,"cmp","","",115,null],[11,"cmp","std::sync","Comparison for two `Arc`s.",263,null],[11,"cmp","std::rc","Comparison for two `Rc`s.",264,null],[11,"default","std::boxed","Creates a `Box&lt;T&gt;`, with the `Default` value for T.",115,{"inputs":[],"output":{"name":"box"}}],[11,"default","","",115,{"inputs":[],"output":{"name":"box"}}],[11,"default","std::sync","Constructs a new `Weak&lt;T&gt;`, without an accompanying instance of `T`.",266,{"inputs":[],"output":{"name":"weak"}}],[11,"default","","Creates a new `Arc&lt;T&gt;`, with the `Default` value for `T`.",263,{"inputs":[],"output":{"name":"arc"}}],[11,"default","std::rc","Creates a new `Rc&lt;T&gt;`, with the `Default` value for `T`.",264,{"inputs":[],"output":{"name":"rc"}}],[11,"default","","Constructs a new `Weak&lt;T&gt;`, without an accompanying instance of `T`.",267,{"inputs":[],"output":{"name":"weak"}}],[11,"finalize","std::boxed","",268,null],[11,"pointer","","",268,null],[11,"partial_cmp","","",115,null],[11,"lt","","",115,null],[11,"le","","",115,null],[11,"ge","","",115,null],[11,"gt","","",115,null],[11,"partial_cmp","std::sync","Partial comparison for two `Arc`s.",263,null],[11,"lt","","Less-than comparison for two `Arc`s.",263,null],[11,"le","","&#39;Less than or equal to&#39; comparison for two `Arc`s.",263,null],[11,"gt","","Greater-than comparison for two `Arc`s.",263,null],[11,"ge","","&#39;Greater than or equal to&#39; comparison for two `Arc`s.",263,null],[11,"partial_cmp","std::rc","Partial comparison for two `Rc`s.",264,null],[11,"lt","","Less-than comparison for two `Rc`s.",264,null],[11,"le","","&#39;Less than or equal to&#39; comparison for two `Rc`s.",264,null],[11,"gt","","Greater-than comparison for two `Rc`s.",264,null],[11,"ge","","&#39;Greater than or equal to&#39; comparison for two `Rc`s.",264,null],[11,"call_once","std::boxed","",115,null],[11,"call_once","","",115,null],[11,"fmt","","",115,null],[11,"fmt","std::sync","",263,null],[11,"fmt","std::rc","",264,null],[11,"deref_mut","std::boxed","",115,null],[11,"make_place","","",268,{"inputs":[],"output":{"name":"intermediatebox"}}],[11,"eq","","",115,null],[11,"ne","","",115,null],[11,"eq","std::sync","Equality for two `Arc`s.",263,null],[11,"ne","","Inequality for two `Arc`s.",263,null],[11,"eq","std::rc","Equality for two `Rc`s.",264,null],[11,"ne","","Inequality for two `Rc`s.",264,null],[11,"borrow_mut","std::boxed","",115,null],[11,"as_ref","","",115,null],[11,"as_ref","std::sync","",263,null],[11,"as_ref","std::rc","",264,null],[11,"next","std::boxed","",115,null],[11,"size_hint","","",115,null],[11,"nth","","",115,null],[11,"hash","","",115,null],[11,"hash","std::sync","",263,null],[11,"hash","std::rc","",264,null],[11,"as_mut","std::boxed","",115,null],[11,"drop","","",268,null],[11,"drop","std::sync","Drops the `Arc`.",263,null],[11,"drop","","Drops the `Weak` pointer.",266,null],[11,"drop","std::rc","Drops the `Rc`.",264,null],[11,"drop","","Drops the `Weak` pointer.",267,null],[11,"next_back","std::str","",269,null],[11,"fmt","std::char","",121,null],[11,"fmt","","",121,null],[11,"split_whitespace","std","",270,null],[11,"is_whitespace","","",270,null],[11,"is_alphanumeric","","",270,null],[11,"trim","","",270,null],[11,"trim_left","","",270,null],[11,"trim_right","","",270,null],[11,"eq","std::char","",121,null],[11,"ne","","",121,null],[11,"clone","","",271,null],[11,"clone","","",121,null],[11,"next","std::str","",269,null],[11,"next","std::char","",272,null],[11,"next","","",273,null],[11,"next","","",271,null],[11,"size_hint","","",271,null],[11,"to_string","std","",270,null],[11,"deref","std::collections::binary_heap","",274,null],[11,"deref","std::borrow","",72,null],[11,"len","std","Returns the length of `self`.",270,null],[11,"is_empty","","Returns true if this slice has a length of zero bytes.",270,null],[11,"is_char_boundary","","Checks that `index`-th byte lies at the start and/or end of a\nUTF-8 code point sequence.",270,null],[11,"as_bytes","","Converts a string slice to a byte slice.",270,null],[11,"as_ptr","","Converts a string slice to a raw pointer.",270,null],[11,"slice_unchecked","","Creates a string slice from another string slice, bypassing safety\nchecks.",270,null],[11,"slice_mut_unchecked","","Creates a string slice from another string slice, bypassing safety\nchecks.",270,null],[11,"split_at","","Divide one string slice into two at an index.",270,null],[11,"split_at_mut","","Divide one mutable string slice into two at an index.",270,null],[11,"chars","","Returns an iterator over the `char`s of a string slice.",270,null],[11,"char_indices","","Returns an iterator over the [`char`]s of a string slice, and their\npositions.",270,null],[11,"bytes","","An iterator over the bytes of a string slice.",270,null],[11,"split_whitespace","","Split a string slice by whitespace.",270,null],[11,"lines","","An iterator over the lines of a string, as string slices.",270,null],[11,"lines_any","","An iterator over the lines of a string.",270,null],[11,"encode_utf16","","Returns an iterator of `u16` over the string encoded as UTF-16.",270,null],[11,"contains","","Returns `true` if the given pattern matches a sub-slice of\nthis string slice.",270,null],[11,"starts_with","","Returns `true` if the given pattern matches a prefix of this\nstring slice.",270,null],[11,"ends_with","","Returns `true` if the given pattern matches a suffix of this\nstring slice.",270,null],[11,"find","","Returns the byte index of the first character of this string slice that\nmatches the pattern.",270,null],[11,"rfind","","Returns the byte index of the last character of this string slice that\nmatches the pattern.",270,null],[11,"split","","An iterator over substrings of this string slice, separated by\ncharacters matched by a pattern.",270,null],[11,"rsplit","","An iterator over substrings of the given string slice, separated by\ncharacters matched by a pattern and yielded in reverse order.",270,null],[11,"split_terminator","","An iterator over substrings of the given string slice, separated by\ncharacters matched by a pattern.",270,null],[11,"rsplit_terminator","","An iterator over substrings of `self`, separated by characters\nmatched by a pattern and yielded in reverse order.",270,null],[11,"splitn","","An iterator over substrings of the given string slice, separated by a\npattern, restricted to returning at most `n` items.",270,null],[11,"rsplitn","","An iterator over substrings of this string slice, separated by a\npattern, starting from the end of the string, restricted to returning\nat most `n` items.",270,null],[11,"matches","","An iterator over the matches of a pattern within the given string\nslice.",270,null],[11,"rmatches","","An iterator over the matches of a pattern within this string slice,\nyielded in reverse order.",270,null],[11,"match_indices","","An iterator over the disjoint matches of a pattern within this string\nslice as well as the index that the match starts at.",270,null],[11,"rmatch_indices","","An iterator over the disjoint matches of a pattern within `self`,\nyielded in reverse order along with the index of the match.",270,null],[11,"trim","","Returns a string slice with leading and trailing whitespace removed.",270,null],[11,"trim_left","","Returns a string slice with leading whitespace removed.",270,null],[11,"trim_right","","Returns a string slice with trailing whitespace removed.",270,null],[11,"trim_matches","","Returns a string slice with all prefixes and suffixes that match a\npattern repeatedly removed.",270,null],[11,"trim_left_matches","","Returns a string slice with all prefixes that match a pattern\nrepeatedly removed.",270,null],[11,"trim_right_matches","","Returns a string slice with all suffixes that match a pattern\nrepeatedly removed.",270,null],[11,"parse","","Parses this string slice into another type.",270,null],[11,"replace","","Replaces all matches of a pattern with another string.",270,null],[11,"replacen","","Replaces first N matches of a pattern with another string.",270,null],[11,"to_lowercase","","Returns the lowercase equivalent of this string slice, as a new [`String`].",270,null],[11,"to_uppercase","","Returns the uppercase equivalent of this string slice, as a new [`String`].",270,null],[11,"escape_debug","","Escapes each char in `s` with `char::escape_debug`.",270,null],[11,"escape_default","","Escapes each char in `s` with `char::escape_default`.",270,null],[11,"escape_unicode","","Escapes each char in `s` with `char::escape_unicode`.",270,null],[11,"into_string","","Converts a `Box&lt;str&gt;` into a [`String`] without copying or allocating.",270,{"inputs":[{"name":"box"}],"output":{"name":"string"}}],[11,"repeat","","Create a [`String`] by repeating a string `n` times.",270,null],[11,"deref","std::string","",134,null],[11,"len","std","Returns the number of elements in the slice.",275,null],[11,"is_empty","","Returns true if the slice has a length of 0.",275,null],[11,"first","","Returns the first element of a slice, or `None` if it is empty.",275,null],[11,"first_mut","","Returns a mutable pointer to the first element of a slice, or `None` if it is empty.",275,null],[11,"split_first","","Returns the first and all the rest of the elements of a slice.",275,null],[11,"split_first_mut","","Returns the first and all the rest of the elements of a slice.",275,null],[11,"split_last","","Returns the last and all the rest of the elements of a slice.",275,null],[11,"split_last_mut","","Returns the last and all the rest of the elements of a slice.",275,null],[11,"last","","Returns the last element of a slice, or `None` if it is empty.",275,null],[11,"last_mut","","Returns a mutable pointer to the last item in the slice.",275,null],[11,"get","","Returns the element of a slice at the given index, or `None` if the\nindex is out of bounds.",275,null],[11,"get_mut","","Returns a mutable reference to the element at the given index.",275,null],[11,"get_unchecked","","Returns a pointer to the element at the given index, without doing\nbounds checking. So use it very carefully!",275,null],[11,"get_unchecked_mut","","Returns an unsafe mutable pointer to the element in index. So use it\nvery carefully!",275,null],[11,"as_ptr","","Returns an raw pointer to the slice&#39;s buffer.",275,null],[11,"as_mut_ptr","","Returns an unsafe mutable pointer to the slice&#39;s buffer.",275,null],[11,"swap","","Swaps two elements in a slice.",275,null],[11,"reverse","","Reverse the order of elements in a slice, in place.",275,null],[11,"iter","","Returns an iterator over the slice.",275,null],[11,"iter_mut","","Returns an iterator that allows modifying each value.",275,null],[11,"windows","","Returns an iterator over all contiguous windows of length\n`size`. The windows overlap. If the slice is shorter than\n`size`, the iterator returns no values.",275,null],[11,"chunks","","Returns an iterator over `size` elements of the slice at a\ntime. The chunks are slices and do not overlap. If `size` does\nnot divide the length of the slice, then the last chunk will\nnot have length `size`.",275,null],[11,"chunks_mut","","Returns an iterator over `chunk_size` elements of the slice at a time.\nThe chunks are mutable slices, and do not overlap. If `chunk_size` does\nnot divide the length of the slice, then the last chunk will not\nhave length `chunk_size`.",275,null],[11,"split_at","","Divides one slice into two at an index.",275,null],[11,"split_at_mut","","Divides one `&amp;mut` into two at an index.",275,null],[11,"split","","Returns an iterator over subslices separated by elements that match\n`pred`. The matched element is not contained in the subslices.",275,null],[11,"split_mut","","Returns an iterator over mutable subslices separated by elements that\nmatch `pred`. The matched element is not contained in the subslices.",275,null],[11,"splitn","","Returns an iterator over subslices separated by elements that match\n`pred`, limited to returning at most `n` items. The matched element is\nnot contained in the subslices.",275,null],[11,"splitn_mut","","Returns an iterator over subslices separated by elements that match\n`pred`, limited to returning at most `n` items. The matched element is\nnot contained in the subslices.",275,null],[11,"rsplitn","","Returns an iterator over subslices separated by elements that match\n`pred` limited to returning at most `n` items. This starts at the end of\nthe slice and works backwards.  The matched element is not contained in\nthe subslices.",275,null],[11,"rsplitn_mut","","Returns an iterator over subslices separated by elements that match\n`pred` limited to returning at most `n` items. This starts at the end of\nthe slice and works backwards. The matched element is not contained in\nthe subslices.",275,null],[11,"contains","","Returns true if the slice contains an element with the given value.",275,null],[11,"starts_with","","Returns true if `needle` is a prefix of the slice.",275,null],[11,"ends_with","","Returns true if `needle` is a suffix of the slice.",275,null],[11,"binary_search","","Binary search a sorted slice for a given element.",275,null],[11,"binary_search_by","","Binary search a sorted slice with a comparator function.",275,null],[11,"binary_search_by_key","","Binary search a sorted slice with a key extraction function.",275,null],[11,"sort","","This is equivalent to `self.sort_by(|a, b| a.cmp(b))`.",275,null],[11,"sort_by_key","","Sorts the slice, in place, using `f` to extract a key by which to\norder the sort by.",275,null],[11,"sort_by","","Sorts the slice, in place, using `compare` to compare\nelements.",275,null],[11,"clone_from_slice","","Copies the elements from `src` into `self`.",275,null],[11,"copy_from_slice","","Copies all elements from `src` into `self`, using a memcpy.",275,null],[11,"to_vec","","Copies `self` into a new `Vec`.",275,null],[11,"into_vec","","Converts `self` into a vector without clones or allocation.",275,{"inputs":[{"name":"box"}],"output":{"name":"vec"}}],[11,"deref","std::vec","",131,null],[11,"drop","std::collections::binary_heap","",274,null],[11,"drop","std::collections::btree_map","",276,null],[11,"drop","","",277,null],[11,"drop","std::collections::linked_list","",278,null],[11,"drop","std::string","",279,null],[11,"drop","std::vec","",131,null],[11,"drop","","",280,null],[11,"drop","","",281,null],[11,"drop","std::collections::vec_deque","",282,null],[11,"drop","","",283,null],[11,"from","std::collections::binary_heap","",284,{"inputs":[{"name":"vec"}],"output":{"name":"binaryheap"}}],[11,"from","std::vec","",131,{"inputs":[{"name":"binaryheap"}],"output":{"name":"vec"}}],[11,"from","std::string","",134,{"inputs":[{"name":"str"}],"output":{"name":"string"}}],[11,"from","","",134,{"inputs":[{"name":"cow"}],"output":{"name":"string"}}],[11,"from","std::borrow","",72,{"inputs":[{"name":"str"}],"output":{"name":"cow"}}],[11,"from","","",72,{"inputs":[{"name":"string"}],"output":{"name":"cow"}}],[11,"from","std::vec","",131,{"inputs":[{"name":"string"}],"output":{"name":"vec"}}],[11,"from","","",131,null],[11,"from","","",131,{"inputs":[{"name":"cow"}],"output":{"name":"vec"}}],[11,"from","","",131,{"inputs":[{"name":"str"}],"output":{"name":"vec"}}],[11,"from","std::borrow","",72,null],[11,"from","","",72,{"inputs":[{"name":"vec"}],"output":{"name":"cow"}}],[11,"from","std::collections::vec_deque","",282,{"inputs":[{"name":"vec"}],"output":{"name":"vecdeque"}}],[11,"from","std::vec","",131,{"inputs":[{"name":"vecdeque"}],"output":{"name":"vec"}}],[11,"next_back","std::collections::binary_heap","",285,null],[11,"next_back","","",286,null],[11,"next_back","","",287,null],[11,"next_back","std::collections::btree_map","",288,null],[11,"next_back","","",289,null],[11,"next_back","","",277,null],[11,"next_back","","",290,null],[11,"next_back","","",291,null],[11,"next_back","","",292,null],[11,"next_back","","",293,null],[11,"next_back","","",294,null],[11,"next_back","std::collections::btree_set","",295,null],[11,"next_back","","",296,null],[11,"next_back","","",297,null],[11,"next_back","std::collections::linked_list","",298,null],[11,"next_back","","",299,null],[11,"next_back","","",300,null],[11,"next_back","std::string","",279,null],[11,"next_back","std::vec","",280,null],[11,"next_back","","",281,null],[11,"next_back","std::collections::vec_deque","",301,null],[11,"next_back","","",302,null],[11,"next_back","","",303,null],[11,"next_back","","",283,null],[11,"make_place","std::collections::linked_list","",304,null],[11,"make_place","","",305,null],[11,"fmt","std::collections::binary_heap","",284,null],[11,"fmt","std::collections::btree_map","",102,null],[11,"fmt","","",306,null],[11,"fmt","","",307,null],[11,"fmt","","",276,null],[11,"fmt","std::collections::btree_set","",308,null],[11,"fmt","std::borrow","",72,null],[11,"fmt","std::collections::linked_list","",278,null],[11,"fmt","std::string","",134,null],[11,"fmt","","",120,null],[11,"fmt","std::vec","",131,null],[11,"fmt","","",280,null],[11,"fmt","std::collections::vec_deque","",282,null],[11,"fmt","std::string","",118,null],[11,"fmt","","",119,null],[11,"fmt","std::collections","",101,null],[11,"is_empty","std::collections::binary_heap","",285,null],[11,"is_empty","","",286,null],[11,"is_empty","","",287,null],[11,"len","std::collections::btree_map","",288,null],[11,"len","","",289,null],[11,"len","","",277,null],[11,"len","","",290,null],[11,"len","","",291,null],[11,"len","","",292,null],[11,"len","std::collections::btree_set","",295,null],[11,"len","","",296,null],[11,"is_empty","std::vec","",280,null],[11,"is_empty","","",281,null],[11,"is_empty","std::collections::vec_deque","",301,null],[11,"is_empty","","",302,null],[11,"is_empty","","",303,null],[11,"into_iter","std::collections::binary_heap","Creates a consuming iterator, that is, one that moves each value out of\nthe binary heap in arbitrary order. The binary heap cannot be used\nafter calling this.",284,null],[11,"into_iter","std::collections::btree_map","",276,null],[11,"into_iter","std::collections::btree_set","Gets an iterator for moving out the BtreeSet&#39;s contents.",308,null],[11,"into_iter","std::collections::linked_list","Consumes the list into an iterator yielding elements by value.",278,null],[11,"into_iter","std::vec","Creates a consuming iterator, that is, one that moves each value out of\nthe vector (from start to end). The vector cannot be used after calling\nthis.",131,null],[11,"into_iter","std::collections::vec_deque","Consumes the list into a front-to-back iterator yielding elements by\nvalue.",282,null],[11,"concat","std","",275,null],[11,"join","","",275,null],[11,"connect","","",275,null],[11,"concat","","",275,null],[11,"join","","",275,null],[11,"connect","","",275,null],[11,"borrow","std::borrow","",72,null],[11,"borrow","std::vec","",131,null],[11,"borrow","std::string","",134,null],[11,"extend","std::collections::binary_heap","",284,null],[11,"extend","","",284,null],[11,"extend","std::collections::btree_map","",276,null],[11,"extend","","",276,null],[11,"extend","std::collections::btree_set","",308,null],[11,"extend","","",308,null],[11,"extend","std::collections::linked_list","",278,null],[11,"extend","","",278,null],[11,"extend","std::string","",134,null],[11,"extend","","",134,null],[11,"extend","","",134,null],[11,"extend","","",134,null],[11,"extend","std::vec","",131,null],[11,"extend","","",131,null],[11,"extend","std::collections::vec_deque","",282,null],[11,"extend","","",282,null],[11,"clone","std::collections::binary_heap","",284,null],[11,"clone_from","","",284,null],[11,"clone","","",285,null],[11,"clone","std::collections::btree_map","",276,null],[11,"clone","","",288,null],[11,"clone","","",290,null],[11,"clone","","",291,null],[11,"clone","","",293,null],[11,"clone","std::collections::btree_set","",295,null],[11,"clone","","",297,null],[11,"clone","","",309,null],[11,"clone","","",310,null],[11,"clone","","",311,null],[11,"clone","","",312,null],[11,"clone","std::borrow","",72,null],[11,"clone","std::collections::linked_list","",298,null],[11,"clone","","",278,null],[11,"clone","std::string","",134,null],[11,"clone_from","","",134,null],[11,"clone","","",120,null],[11,"clone","std::vec","",131,null],[11,"clone_from","","",131,null],[11,"clone","","",280,null],[11,"clone","std::collections::vec_deque","",282,null],[11,"clone","","",301,null],[11,"clone","std::collections::binary_heap","",286,null],[11,"clone","std::collections::btree_set","",308,null],[11,"clone","std::collections::linked_list","",300,null],[11,"clone","std::str","",313,null],[11,"clone","std::collections::vec_deque","",303,null],[11,"clone","std::collections","",101,null],[11,"add","std::borrow","",72,null],[11,"add","","",72,null],[11,"add","std::string","",134,null],[11,"cmp","std::collections::btree_map","",276,null],[11,"cmp","std::borrow","",72,null],[11,"cmp","std::collections::linked_list","",278,null],[11,"cmp","std::vec","",131,null],[11,"cmp","std::collections::vec_deque","",282,null],[11,"cmp","std::collections::btree_set","",308,null],[11,"cmp","std::string","",134,null],[11,"write_str","","",134,null],[11,"write_char","","",134,null],[11,"default","std::collections::binary_heap","Creates an empty `BinaryHeap&lt;T&gt;`.",284,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"default","std::collections::btree_map","Creates an empty `BTreeMap&lt;K, V&gt;`.",276,{"inputs":[],"output":{"name":"btreemap"}}],[11,"default","std::collections::btree_set","Makes an empty `BTreeSet&lt;T&gt;` with a reasonable choice of B.",308,{"inputs":[],"output":{"name":"btreeset"}}],[11,"default","std::borrow","Creates an owned Cow&lt;&#39;a, B&gt; with the default value for the contained owned value.",72,{"inputs":[],"output":{"name":"cow"}}],[11,"default","std::collections::linked_list","Creates an empty `LinkedList&lt;T&gt;`.",278,{"inputs":[],"output":{"name":"linkedlist"}}],[11,"default","std::string","Creates an empty `String`.",134,{"inputs":[],"output":{"name":"string"}}],[11,"default","std::vec","Creates an empty `Vec&lt;T&gt;`.",131,{"inputs":[],"output":{"name":"vec"}}],[11,"default","std::collections::vec_deque","Creates an empty `VecDeque&lt;T&gt;`.",282,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"finalize","std::collections::linked_list","",304,null],[11,"finalize","","",305,null],[11,"index","std::collections::btree_map","",276,null],[11,"index","std::string","",134,null],[11,"index","","",134,null],[11,"index","","",134,null],[11,"index","","",134,null],[11,"index","","",134,null],[11,"index","","",134,null],[11,"index","std::vec","",131,null],[11,"index","","",131,null],[11,"index","","",131,null],[11,"index","","",131,null],[11,"index","","",131,null],[11,"index","","",131,null],[11,"index","","",131,null],[11,"index","std::collections::vec_deque","",282,null],[11,"start","std::ops","",52,null],[11,"end","","",53,null],[11,"start","","",51,null],[11,"end","","",51,null],[11,"from_iter","std::collections::binary_heap","",284,{"inputs":[{"name":"i"}],"output":{"name":"binaryheap"}}],[11,"from_iter","std::collections::btree_map","",276,{"inputs":[{"name":"t"}],"output":{"name":"btreemap"}}],[11,"from_iter","std::collections::btree_set","",308,{"inputs":[{"name":"i"}],"output":{"name":"btreeset"}}],[11,"from_iter","std::collections::linked_list","",278,{"inputs":[{"name":"i"}],"output":{"name":"linkedlist"}}],[11,"from_iter","std::string","",134,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",134,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","","",134,{"inputs":[{"name":"i"}],"output":{"name":"string"}}],[11,"from_iter","std::borrow","",72,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","","",72,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","","",72,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","std::vec","",131,{"inputs":[{"name":"i"}],"output":{"name":"vec"}}],[11,"from_iter","std::borrow","",72,{"inputs":[{"name":"i"}],"output":{"name":"cow"}}],[11,"from_iter","std::collections::vec_deque","",282,{"inputs":[{"name":"t"}],"output":{"name":"vecdeque"}}],[11,"pointer","std::collections::linked_list","",304,null],[11,"pointer","","",305,null],[11,"to_owned","std","",275,null],[11,"to_owned","","",270,null],[11,"partial_cmp","std::collections::btree_map","",276,null],[11,"partial_cmp","std::borrow","",72,null],[11,"partial_cmp","std::collections::linked_list","",278,null],[11,"partial_cmp","std::vec","",131,null],[11,"partial_cmp","std::collections::vec_deque","",282,null],[11,"partial_cmp","std::collections::btree_set","",308,null],[11,"lt","","",308,null],[11,"le","","",308,null],[11,"gt","","",308,null],[11,"ge","","",308,null],[11,"partial_cmp","std::string","",134,null],[11,"lt","","",134,null],[11,"le","","",134,null],[11,"gt","","",134,null],[11,"ge","","",134,null],[11,"deref_mut","std::collections::binary_heap","",274,null],[11,"deref_mut","std::string","",134,null],[11,"deref_mut","std::vec","",131,null],[11,"fmt","std::borrow","",72,null],[11,"fmt","std::string","",118,null],[11,"fmt","","",119,null],[11,"fmt","","",134,null],[11,"fmt","","",120,null],[11,"index_mut","","",134,null],[11,"index_mut","","",134,null],[11,"index_mut","","",134,null],[11,"index_mut","","",134,null],[11,"index_mut","","",134,null],[11,"index_mut","","",134,null],[11,"index_mut","std::vec","",131,null],[11,"index_mut","","",131,null],[11,"index_mut","","",131,null],[11,"index_mut","","",131,null],[11,"index_mut","","",131,null],[11,"index_mut","","",131,null],[11,"index_mut","","",131,null],[11,"index_mut","std::collections::vec_deque","",282,null],[11,"eq","std::collections::btree_map","",276,null],[11,"eq","std::borrow","",72,null],[11,"eq","std::collections::linked_list","",278,null],[11,"ne","","",278,null],[11,"eq","std::string","",134,null],[11,"ne","","",134,null],[11,"eq","","",120,null],[11,"eq","std::collections::vec_deque","",282,null],[11,"eq","std::collections::btree_set","",308,null],[11,"ne","","",308,null],[11,"eq","std::string","",134,null],[11,"ne","","",134,null],[11,"eq","std","",270,null],[11,"ne","","",270,null],[11,"eq","std::string","",134,null],[11,"ne","","",134,null],[11,"eq","std","",270,null],[11,"ne","","",270,null],[11,"eq","std::borrow","",72,null],[11,"ne","","",72,null],[11,"eq","std","",270,null],[11,"ne","","",270,null],[11,"eq","std::borrow","",72,null],[11,"ne","","",72,null],[11,"eq","std","",270,null],[11,"ne","","",270,null],[11,"eq","std::borrow","",72,null],[11,"ne","","",72,null],[11,"eq","std::string","",134,null],[11,"ne","","",134,null],[11,"eq","std::vec","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","std::borrow","",72,null],[11,"ne","","",72,null],[11,"eq","","",72,null],[11,"ne","","",72,null],[11,"eq","","",72,null],[11,"ne","","",72,null],[11,"eq","std::vec","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","","",131,null],[11,"ne","","",131,null],[11,"eq","std::collections","",101,null],[11,"ne","","",101,null],[11,"from_str","std::string","",134,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"borrow_mut","std::vec","",131,null],[11,"as_ref","std::borrow","",72,null],[11,"as_ref","std::string","",134,null],[11,"as_ref","","",134,null],[11,"as_ref","std::vec","",131,null],[11,"as_ref","","",131,null],[11,"next","std::collections::binary_heap","",285,null],[11,"size_hint","","",285,null],[11,"next","","",286,null],[11,"size_hint","","",286,null],[11,"next","","",287,null],[11,"size_hint","","",287,null],[11,"next","std::collections::btree_map","",288,null],[11,"size_hint","","",288,null],[11,"next","","",289,null],[11,"size_hint","","",289,null],[11,"next","","",277,null],[11,"size_hint","","",277,null],[11,"next","","",290,null],[11,"size_hint","","",290,null],[11,"next","","",291,null],[11,"size_hint","","",291,null],[11,"next","","",293,null],[11,"next","","",292,null],[11,"size_hint","","",292,null],[11,"next","","",294,null],[11,"next","std::collections::btree_set","",295,null],[11,"size_hint","","",295,null],[11,"next","","",296,null],[11,"size_hint","","",296,null],[11,"next","","",297,null],[11,"next","","",309,null],[11,"size_hint","","",309,null],[11,"next","","",310,null],[11,"size_hint","","",310,null],[11,"next","","",311,null],[11,"size_hint","","",311,null],[11,"next","","",312,null],[11,"size_hint","","",312,null],[11,"next","std::collections::linked_list","",298,null],[11,"size_hint","","",298,null],[11,"next","","",299,null],[11,"size_hint","","",299,null],[11,"next","","",300,null],[11,"size_hint","","",300,null],[11,"next","std::str","",313,null],[11,"size_hint","","",313,null],[11,"next","std::string","",279,null],[11,"size_hint","","",279,null],[11,"next","std::vec","",280,null],[11,"size_hint","","",280,null],[11,"count","","",280,null],[11,"next","","",281,null],[11,"size_hint","","",281,null],[11,"next","std::collections::vec_deque","",301,null],[11,"size_hint","","",301,null],[11,"fold","","",301,null],[11,"next","","",302,null],[11,"size_hint","","",302,null],[11,"fold","","",302,null],[11,"next","","",303,null],[11,"size_hint","","",303,null],[11,"next","","",283,null],[11,"size_hint","","",283,null],[11,"add_assign","std::borrow","",72,null],[11,"add_assign","","",72,null],[11,"add_assign","std::string","",134,null],[11,"hash","std::collections::btree_map","",276,null],[11,"hash","std::borrow","",72,null],[11,"hash","std::collections::linked_list","",278,null],[11,"hash","std::string","",134,null],[11,"hash","std::vec","",131,null],[11,"hash","std::collections::vec_deque","",282,null],[11,"hash","std::collections::btree_set","",308,null],[11,"hash","std::collections","",101,null],[11,"as_mut","std::vec","",131,null],[11,"as_mut","","",131,null],[11,"bitxor_assign","std::num","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","","",189,null],[11,"bitxor_assign","std","",314,null],[11,"bitxor_assign","","",315,null],[11,"bitxor_assign","","",316,null],[11,"bitxor_assign","","",317,null],[11,"bitxor_assign","","",318,null],[11,"bitxor_assign","","",319,null],[11,"bitxor_assign","","",320,null],[11,"bitxor_assign","","",321,null],[11,"bitxor_assign","","",322,null],[11,"bitxor_assign","","",323,null],[11,"bitxor_assign","","",324,null],[11,"partial_cmp","","",325,null],[11,"lt","","",325,null],[11,"le","","",325,null],[11,"gt","","",325,null],[11,"ge","","",325,null],[11,"partial_cmp","","",325,null],[11,"lt","","",325,null],[11,"le","","",325,null],[11,"gt","","",325,null],[11,"ge","","",325,null],[11,"partial_cmp","std::cmp","",4,null],[11,"partial_cmp","std","",326,null],[11,"partial_cmp","","",314,null],[11,"partial_cmp","std::cell","",327,null],[11,"lt","","",327,null],[11,"le","","",327,null],[11,"gt","","",327,null],[11,"ge","","",327,null],[11,"partial_cmp","","",328,null],[11,"lt","","",328,null],[11,"le","","",328,null],[11,"gt","","",328,null],[11,"ge","","",328,null],[11,"partial_cmp","std","",275,null],[11,"partial_cmp","","",270,null],[11,"partial_cmp","std::num","",189,null],[11,"lt","","",189,null],[11,"le","","",189,null],[11,"gt","","",189,null],[11,"ge","","",189,null],[11,"partial_cmp","std::marker","",329,null],[11,"partial_cmp","std","",330,null],[11,"lt","","",330,null],[11,"le","","",330,null],[11,"ge","","",330,null],[11,"gt","","",330,null],[11,"partial_cmp","","",331,null],[11,"lt","","",331,null],[11,"le","","",331,null],[11,"ge","","",331,null],[11,"gt","","",331,null],[11,"partial_cmp","","",332,null],[11,"lt","","",332,null],[11,"le","","",332,null],[11,"ge","","",332,null],[11,"gt","","",332,null],[11,"partial_cmp","","",315,null],[11,"lt","","",315,null],[11,"le","","",315,null],[11,"ge","","",315,null],[11,"gt","","",315,null],[11,"partial_cmp","","",316,null],[11,"lt","","",316,null],[11,"le","","",316,null],[11,"ge","","",316,null],[11,"gt","","",316,null],[11,"partial_cmp","","",317,null],[11,"lt","","",317,null],[11,"le","","",317,null],[11,"ge","","",317,null],[11,"gt","","",317,null],[11,"partial_cmp","","",318,null],[11,"lt","","",318,null],[11,"le","","",318,null],[11,"ge","","",318,null],[11,"gt","","",318,null],[11,"partial_cmp","","",319,null],[11,"lt","","",319,null],[11,"le","","",319,null],[11,"ge","","",319,null],[11,"gt","","",319,null],[11,"partial_cmp","","",320,null],[11,"lt","","",320,null],[11,"le","","",320,null],[11,"ge","","",320,null],[11,"gt","","",320,null],[11,"partial_cmp","","",321,null],[11,"lt","","",321,null],[11,"le","","",321,null],[11,"ge","","",321,null],[11,"gt","","",321,null],[11,"partial_cmp","","",322,null],[11,"lt","","",322,null],[11,"le","","",322,null],[11,"ge","","",322,null],[11,"gt","","",322,null],[11,"partial_cmp","","",323,null],[11,"lt","","",323,null],[11,"le","","",323,null],[11,"ge","","",323,null],[11,"gt","","",323,null],[11,"partial_cmp","","",324,null],[11,"lt","","",324,null],[11,"le","","",324,null],[11,"ge","","",324,null],[11,"gt","","",324,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","","",333,null],[11,"lt","","",333,null],[11,"le","","",333,null],[11,"ge","","",333,null],[11,"gt","","",333,null],[11,"partial_cmp","std::option","",69,null],[11,"lt","","",69,null],[11,"le","","",69,null],[11,"gt","","",69,null],[11,"ge","","",69,null],[11,"partial_cmp","std::result","",68,null],[11,"lt","","",68,null],[11,"le","","",68,null],[11,"gt","","",68,null],[11,"ge","","",68,null],[11,"partial_cmp","std::fmt","",122,null],[11,"partial_cmp","std","",326,null],[11,"lt","","",326,null],[11,"le","","",326,null],[11,"ge","","",326,null],[11,"gt","","",326,null],[11,"partial_cmp","","",326,null],[11,"lt","","",326,null],[11,"le","","",326,null],[11,"ge","","",326,null],[11,"gt","","",326,null],[11,"partial_cmp","","",326,null],[11,"lt","","",326,null],[11,"le","","",326,null],[11,"ge","","",326,null],[11,"gt","","",326,null],[11,"partial_cmp","","",326,null],[11,"lt","","",326,null],[11,"le","","",326,null],[11,"ge","","",326,null],[11,"gt","","",326,null],[11,"partial_cmp","","",326,null],[11,"lt","","",326,null],[11,"le","","",326,null],[11,"ge","","",326,null],[11,"gt","","",326,null],[11,"partial_cmp","","",326,null],[11,"lt","","",326,null],[11,"le","","",326,null],[11,"ge","","",326,null],[11,"gt","","",326,null],[11,"partial_cmp","","",326,null],[11,"lt","","",326,null],[11,"le","","",326,null],[11,"ge","","",326,null],[11,"gt","","",326,null],[11,"partial_cmp","","",326,null],[11,"lt","","",326,null],[11,"le","","",326,null],[11,"ge","","",326,null],[11,"gt","","",326,null],[11,"partial_cmp","","",326,null],[11,"lt","","",326,null],[11,"le","","",326,null],[11,"ge","","",326,null],[11,"gt","","",326,null],[11,"partial_cmp","","",326,null],[11,"lt","","",326,null],[11,"le","","",326,null],[11,"ge","","",326,null],[11,"gt","","",326,null],[11,"partial_cmp","","",326,null],[11,"lt","","",326,null],[11,"le","","",326,null],[11,"ge","","",326,null],[11,"gt","","",326,null],[11,"partial_cmp","","",326,null],[11,"lt","","",326,null],[11,"le","","",326,null],[11,"ge","","",326,null],[11,"gt","","",326,null],[11,"bitand","std::num","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","","",189,null],[11,"bitand","std","",314,null],[11,"bitand","","",315,null],[11,"bitand","","",316,null],[11,"bitand","","",317,null],[11,"bitand","","",318,null],[11,"bitand","","",319,null],[11,"bitand","","",320,null],[11,"bitand","","",321,null],[11,"bitand","","",322,null],[11,"bitand","","",323,null],[11,"bitand","","",324,null],[11,"bitand","","",314,null],[11,"bitand","","",314,null],[11,"bitand","","",314,null],[11,"bitand","","",315,null],[11,"bitand","","",315,null],[11,"bitand","","",315,null],[11,"bitand","","",316,null],[11,"bitand","","",316,null],[11,"bitand","","",316,null],[11,"bitand","","",317,null],[11,"bitand","","",317,null],[11,"bitand","","",317,null],[11,"bitand","","",318,null],[11,"bitand","","",318,null],[11,"bitand","","",318,null],[11,"bitand","","",319,null],[11,"bitand","","",319,null],[11,"bitand","","",319,null],[11,"bitand","","",320,null],[11,"bitand","","",320,null],[11,"bitand","","",320,null],[11,"bitand","","",321,null],[11,"bitand","","",321,null],[11,"bitand","","",321,null],[11,"bitand","","",322,null],[11,"bitand","","",322,null],[11,"bitand","","",322,null],[11,"bitand","","",323,null],[11,"bitand","","",323,null],[11,"bitand","","",323,null],[11,"bitand","","",324,null],[11,"bitand","","",324,null],[11,"bitand","","",324,null],[11,"sum","","",321,{"inputs":[{"name":"i"}],"output":{"name":"i8"}}],[11,"sum","","",321,{"inputs":[{"name":"i"}],"output":{"name":"i8"}}],[11,"sum","","",322,{"inputs":[{"name":"i"}],"output":{"name":"i16"}}],[11,"sum","","",322,{"inputs":[{"name":"i"}],"output":{"name":"i16"}}],[11,"sum","","",323,{"inputs":[{"name":"i"}],"output":{"name":"i32"}}],[11,"sum","","",323,{"inputs":[{"name":"i"}],"output":{"name":"i32"}}],[11,"sum","","",324,{"inputs":[{"name":"i"}],"output":{"name":"i64"}}],[11,"sum","","",324,{"inputs":[{"name":"i"}],"output":{"name":"i64"}}],[11,"sum","","",320,{"inputs":[{"name":"i"}],"output":{"name":"isize"}}],[11,"sum","","",320,{"inputs":[{"name":"i"}],"output":{"name":"isize"}}],[11,"sum","","",316,{"inputs":[{"name":"i"}],"output":{"name":"u8"}}],[11,"sum","","",316,{"inputs":[{"name":"i"}],"output":{"name":"u8"}}],[11,"sum","","",317,{"inputs":[{"name":"i"}],"output":{"name":"u16"}}],[11,"sum","","",317,{"inputs":[{"name":"i"}],"output":{"name":"u16"}}],[11,"sum","","",318,{"inputs":[{"name":"i"}],"output":{"name":"u32"}}],[11,"sum","","",318,{"inputs":[{"name":"i"}],"output":{"name":"u32"}}],[11,"sum","","",319,{"inputs":[{"name":"i"}],"output":{"name":"u64"}}],[11,"sum","","",319,{"inputs":[{"name":"i"}],"output":{"name":"u64"}}],[11,"sum","","",315,{"inputs":[{"name":"i"}],"output":{"name":"usize"}}],[11,"sum","","",315,{"inputs":[{"name":"i"}],"output":{"name":"usize"}}],[11,"sum","std::num","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"sum","std","",330,{"inputs":[{"name":"i"}],"output":{"name":"f32"}}],[11,"sum","","",330,{"inputs":[{"name":"i"}],"output":{"name":"f32"}}],[11,"sum","","",331,{"inputs":[{"name":"i"}],"output":{"name":"f64"}}],[11,"sum","","",331,{"inputs":[{"name":"i"}],"output":{"name":"f64"}}],[11,"shl","std::num","",189,null],[11,"shl","","",189,null],[11,"shl","","",189,null],[11,"shl","","",189,null],[11,"shl","","",189,null],[11,"shl","","",189,null],[11,"shl","","",189,null],[11,"shl","","",189,null],[11,"shl","","",189,null],[11,"shl","","",189,null],[11,"shl","std","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",316,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",317,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",318,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",319,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",315,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",321,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",322,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",323,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",324,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"shl","","",320,null],[11,"div_assign","std::num","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","","",189,null],[11,"div_assign","std","",315,null],[11,"div_assign","","",316,null],[11,"div_assign","","",317,null],[11,"div_assign","","",318,null],[11,"div_assign","","",319,null],[11,"div_assign","","",320,null],[11,"div_assign","","",321,null],[11,"div_assign","","",322,null],[11,"div_assign","","",323,null],[11,"div_assign","","",324,null],[11,"div_assign","","",330,null],[11,"div_assign","","",331,null],[11,"split_at","","",275,null],[11,"iter","","",275,null],[11,"split","","",275,null],[11,"splitn","","",275,null],[11,"rsplitn","","",275,null],[11,"windows","","",275,null],[11,"chunks","","",275,null],[11,"get","","",275,null],[11,"first","","",275,null],[11,"split_first","","",275,null],[11,"split_last","","",275,null],[11,"last","","",275,null],[11,"get_unchecked","","",275,null],[11,"as_ptr","","",275,null],[11,"binary_search_by","","",275,null],[11,"len","","",275,null],[11,"get_mut","","",275,null],[11,"split_at_mut","","",275,null],[11,"iter_mut","","",275,null],[11,"last_mut","","",275,null],[11,"first_mut","","",275,null],[11,"split_first_mut","","",275,null],[11,"split_last_mut","","",275,null],[11,"split_mut","","",275,null],[11,"splitn_mut","","",275,null],[11,"rsplitn_mut","","",275,null],[11,"chunks_mut","","",275,null],[11,"swap","","",275,null],[11,"reverse","","",275,null],[11,"get_unchecked_mut","","",275,null],[11,"as_mut_ptr","","",275,null],[11,"contains","","",275,null],[11,"starts_with","","",275,null],[11,"ends_with","","",275,null],[11,"binary_search","","",275,null],[11,"clone_from_slice","","",275,null],[11,"copy_from_slice","","",275,null],[11,"binary_search_by_key","","",275,null],[11,"fmt","","",330,null],[11,"fmt","","",331,null],[11,"write_str","std::fmt","",334,null],[11,"write_char","","",334,null],[11,"write_fmt","","",334,null],[11,"add","std::num","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","","",189,null],[11,"add","std","",315,null],[11,"add","","",316,null],[11,"add","","",317,null],[11,"add","","",318,null],[11,"add","","",319,null],[11,"add","","",320,null],[11,"add","","",321,null],[11,"add","","",322,null],[11,"add","","",323,null],[11,"add","","",324,null],[11,"add","","",330,null],[11,"add","","",331,null],[11,"add","","",315,null],[11,"add","","",315,null],[11,"add","","",315,null],[11,"add","","",316,null],[11,"add","","",316,null],[11,"add","","",316,null],[11,"add","","",317,null],[11,"add","","",317,null],[11,"add","","",317,null],[11,"add","","",318,null],[11,"add","","",318,null],[11,"add","","",318,null],[11,"add","","",319,null],[11,"add","","",319,null],[11,"add","","",319,null],[11,"add","","",320,null],[11,"add","","",320,null],[11,"add","","",320,null],[11,"add","","",321,null],[11,"add","","",321,null],[11,"add","","",321,null],[11,"add","","",322,null],[11,"add","","",322,null],[11,"add","","",322,null],[11,"add","","",323,null],[11,"add","","",323,null],[11,"add","","",323,null],[11,"add","","",324,null],[11,"add","","",324,null],[11,"add","","",324,null],[11,"add","","",330,null],[11,"add","","",330,null],[11,"add","","",330,null],[11,"add","","",331,null],[11,"add","","",331,null],[11,"add","","",331,null],[11,"next_back","std::str::pattern","",335,null],[11,"next_match_back","","",335,null],[11,"next_reject_back","","",335,null],[11,"next_back","","",336,null],[11,"next_match_back","","",336,null],[11,"next_reject_back","","",336,null],[11,"next_back","","",337,null],[11,"next_match_back","","",337,null],[11,"next_reject_back","","",337,null],[11,"next_back","","",338,null],[11,"next_match_back","","",338,null],[11,"div","std::num","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","","",189,null],[11,"div","std","",315,null],[11,"div","","",316,null],[11,"div","","",317,null],[11,"div","","",318,null],[11,"div","","",319,null],[11,"div","","",320,null],[11,"div","","",321,null],[11,"div","","",322,null],[11,"div","","",323,null],[11,"div","","",324,null],[11,"div","","",315,null],[11,"div","","",315,null],[11,"div","","",315,null],[11,"div","","",316,null],[11,"div","","",316,null],[11,"div","","",316,null],[11,"div","","",317,null],[11,"div","","",317,null],[11,"div","","",317,null],[11,"div","","",318,null],[11,"div","","",318,null],[11,"div","","",318,null],[11,"div","","",319,null],[11,"div","","",319,null],[11,"div","","",319,null],[11,"div","","",320,null],[11,"div","","",320,null],[11,"div","","",320,null],[11,"div","","",321,null],[11,"div","","",321,null],[11,"div","","",321,null],[11,"div","","",322,null],[11,"div","","",322,null],[11,"div","","",322,null],[11,"div","","",323,null],[11,"div","","",323,null],[11,"div","","",323,null],[11,"div","","",324,null],[11,"div","","",324,null],[11,"div","","",324,null],[11,"div","","",330,null],[11,"div","","",331,null],[11,"div","","",330,null],[11,"div","","",330,null],[11,"div","","",330,null],[11,"div","","",331,null],[11,"div","","",331,null],[11,"div","","",331,null],[11,"build_hasher","std::hash","",339,null],[11,"fmt","std::num","",189,null],[11,"fmt","std","",320,null],[11,"fmt","","",315,null],[11,"fmt","","",321,null],[11,"fmt","","",316,null],[11,"fmt","","",322,null],[11,"fmt","","",317,null],[11,"fmt","","",323,null],[11,"fmt","","",318,null],[11,"fmt","","",324,null],[11,"fmt","","",319,null],[11,"shl_assign","std::num","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","","",189,null],[11,"shl_assign","std","",316,null],[11,"shl_assign","","",316,null],[11,"shl_assign","","",316,null],[11,"shl_assign","","",316,null],[11,"shl_assign","","",316,null],[11,"shl_assign","","",316,null],[11,"shl_assign","","",316,null],[11,"shl_assign","","",316,null],[11,"shl_assign","","",316,null],[11,"shl_assign","","",316,null],[11,"shl_assign","","",317,null],[11,"shl_assign","","",317,null],[11,"shl_assign","","",317,null],[11,"shl_assign","","",317,null],[11,"shl_assign","","",317,null],[11,"shl_assign","","",317,null],[11,"shl_assign","","",317,null],[11,"shl_assign","","",317,null],[11,"shl_assign","","",317,null],[11,"shl_assign","","",317,null],[11,"shl_assign","","",318,null],[11,"shl_assign","","",318,null],[11,"shl_assign","","",318,null],[11,"shl_assign","","",318,null],[11,"shl_assign","","",318,null],[11,"shl_assign","","",318,null],[11,"shl_assign","","",318,null],[11,"shl_assign","","",318,null],[11,"shl_assign","","",318,null],[11,"shl_assign","","",318,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",319,null],[11,"shl_assign","","",315,null],[11,"shl_assign","","",315,null],[11,"shl_assign","","",315,null],[11,"shl_assign","","",315,null],[11,"shl_assign","","",315,null],[11,"shl_assign","","",315,null],[11,"shl_assign","","",315,null],[11,"shl_assign","","",315,null],[11,"shl_assign","","",315,null],[11,"shl_assign","","",315,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",321,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",322,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",323,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",324,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"shl_assign","","",320,null],[11,"cmp","","",325,null],[11,"cmp","","",325,null],[11,"cmp","std::cmp","",4,null],[11,"cmp","std","",326,null],[11,"cmp","","",314,null],[11,"cmp","std::cell","",327,null],[11,"cmp","","",328,null],[11,"cmp","std","",275,null],[11,"cmp","","",270,null],[11,"cmp","std::num","",189,null],[11,"cmp","std::marker","",329,null],[11,"cmp","std","",332,null],[11,"cmp","","",315,null],[11,"cmp","","",316,null],[11,"cmp","","",317,null],[11,"cmp","","",318,null],[11,"cmp","","",319,null],[11,"cmp","","",320,null],[11,"cmp","","",321,null],[11,"cmp","","",322,null],[11,"cmp","","",323,null],[11,"cmp","","",324,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","","",333,null],[11,"cmp","std::option","",69,null],[11,"cmp","std::result","",68,null],[11,"cmp","std::fmt","",122,null],[11,"cmp","std","",326,null],[11,"cmp","","",326,null],[11,"cmp","","",326,null],[11,"cmp","","",326,null],[11,"cmp","","",326,null],[11,"cmp","","",326,null],[11,"cmp","","",326,null],[11,"cmp","","",326,null],[11,"cmp","","",326,null],[11,"cmp","","",326,null],[11,"cmp","","",326,null],[11,"cmp","","",326,null],[11,"next_back","std::ops","",51,null],[11,"next_back","","",54,null],[11,"next_back","std::iter","",340,null],[11,"next_back","","",341,null],[11,"next_back","","",342,null],[11,"next_back","","",343,null],[11,"next_back","","",344,null],[11,"next_back","","",345,null],[11,"next_back","","",346,null],[11,"next_back","","",347,null],[11,"next_back","","",348,null],[11,"next_back","","",349,null],[11,"next_back","","",350,null],[11,"next_back","","",351,null],[11,"next_back","","",352,null],[11,"next_back","","",353,null],[11,"next_back","","",353,null],[11,"next_back","","",354,null],[11,"next_back","std::option","",355,null],[11,"next_back","","",356,null],[11,"next_back","","",357,null],[11,"next_back","std::result","",358,null],[11,"next_back","","",359,null],[11,"next_back","","",360,null],[11,"next_back","std::slice","",361,null],[11,"next_back","","",362,null],[11,"next_back","","",363,null],[11,"next_back","","",364,null],[11,"next_back","","",365,null],[11,"next_back","std::str","",366,null],[11,"next_back","","",367,null],[11,"next_back","","",368,null],[11,"next_back","","",369,null],[11,"next_back","","",370,null],[11,"next_back","std::slice","",371,null],[11,"next_back","","",372,null],[11,"next_back","std::str","",373,null],[11,"next_back","","",374,null],[11,"next_back","","",375,null],[11,"next_back","","",376,null],[11,"next_back","","",377,null],[11,"next_back","","",378,null],[11,"next_back","","",379,null],[11,"next_back","","",380,null],[11,"step","std","",315,null],[11,"steps_between","","",315,{"inputs":[{"name":"usize"},{"name":"usize"},{"name":"usize"}],"output":{"name":"option"}}],[11,"is_negative","","",315,null],[11,"replace_one","","",315,null],[11,"replace_zero","","",315,null],[11,"add_one","","",315,null],[11,"sub_one","","",315,null],[11,"steps_between_by_one","","",315,{"inputs":[{"name":"usize"},{"name":"usize"}],"output":{"name":"option"}}],[11,"step","","",316,null],[11,"steps_between","","",316,{"inputs":[{"name":"u8"},{"name":"u8"},{"name":"u8"}],"output":{"name":"option"}}],[11,"is_negative","","",316,null],[11,"replace_one","","",316,null],[11,"replace_zero","","",316,null],[11,"add_one","","",316,null],[11,"sub_one","","",316,null],[11,"steps_between_by_one","","",316,{"inputs":[{"name":"u8"},{"name":"u8"}],"output":{"name":"option"}}],[11,"step","","",317,null],[11,"steps_between","","",317,{"inputs":[{"name":"u16"},{"name":"u16"},{"name":"u16"}],"output":{"name":"option"}}],[11,"is_negative","","",317,null],[11,"replace_one","","",317,null],[11,"replace_zero","","",317,null],[11,"add_one","","",317,null],[11,"sub_one","","",317,null],[11,"steps_between_by_one","","",317,{"inputs":[{"name":"u16"},{"name":"u16"}],"output":{"name":"option"}}],[11,"step","","",318,null],[11,"steps_between","","",318,{"inputs":[{"name":"u32"},{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"is_negative","","",318,null],[11,"replace_one","","",318,null],[11,"replace_zero","","",318,null],[11,"add_one","","",318,null],[11,"sub_one","","",318,null],[11,"steps_between_by_one","","",318,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[11,"step","","",320,null],[11,"steps_between","","",320,{"inputs":[{"name":"isize"},{"name":"isize"},{"name":"isize"}],"output":{"name":"option"}}],[11,"is_negative","","",320,null],[11,"replace_one","","",320,null],[11,"replace_zero","","",320,null],[11,"add_one","","",320,null],[11,"sub_one","","",320,null],[11,"steps_between_by_one","","",320,{"inputs":[{"name":"isize"},{"name":"isize"}],"output":{"name":"option"}}],[11,"step","","",321,null],[11,"steps_between","","",321,{"inputs":[{"name":"i8"},{"name":"i8"},{"name":"i8"}],"output":{"name":"option"}}],[11,"is_negative","","",321,null],[11,"replace_one","","",321,null],[11,"replace_zero","","",321,null],[11,"add_one","","",321,null],[11,"sub_one","","",321,null],[11,"steps_between_by_one","","",321,{"inputs":[{"name":"i8"},{"name":"i8"}],"output":{"name":"option"}}],[11,"step","","",322,null],[11,"steps_between","","",322,{"inputs":[{"name":"i16"},{"name":"i16"},{"name":"i16"}],"output":{"name":"option"}}],[11,"is_negative","","",322,null],[11,"replace_one","","",322,null],[11,"replace_zero","","",322,null],[11,"add_one","","",322,null],[11,"sub_one","","",322,null],[11,"steps_between_by_one","","",322,{"inputs":[{"name":"i16"},{"name":"i16"}],"output":{"name":"option"}}],[11,"step","","",323,null],[11,"steps_between","","",323,{"inputs":[{"name":"i32"},{"name":"i32"},{"name":"i32"}],"output":{"name":"option"}}],[11,"is_negative","","",323,null],[11,"replace_one","","",323,null],[11,"replace_zero","","",323,null],[11,"add_one","","",323,null],[11,"sub_one","","",323,null],[11,"steps_between_by_one","","",323,{"inputs":[{"name":"i32"},{"name":"i32"}],"output":{"name":"option"}}],[11,"step","","",319,null],[11,"steps_between","","",319,{"inputs":[{"name":"u64"},{"name":"u64"},{"name":"u64"}],"output":{"name":"option"}}],[11,"is_negative","","",319,null],[11,"replace_one","","",319,null],[11,"replace_zero","","",319,null],[11,"add_one","","",319,null],[11,"sub_one","","",319,null],[11,"steps_between_by_one","","",319,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"option"}}],[11,"step","","",324,null],[11,"steps_between","","",324,{"inputs":[{"name":"i64"},{"name":"i64"},{"name":"i64"}],"output":{"name":"option"}}],[11,"is_negative","","",324,null],[11,"replace_one","","",324,null],[11,"replace_zero","","",324,null],[11,"add_one","","",324,null],[11,"sub_one","","",324,null],[11,"steps_between_by_one","","",324,{"inputs":[{"name":"i64"},{"name":"i64"}],"output":{"name":"option"}}],[11,"not","std::num","",189,null],[11,"not","","",189,null],[11,"not","","",189,null],[11,"not","","",189,null],[11,"not","","",189,null],[11,"not","","",189,null],[11,"not","","",189,null],[11,"not","","",189,null],[11,"not","","",189,null],[11,"not","","",189,null],[11,"not","std","",314,null],[11,"not","","",315,null],[11,"not","","",316,null],[11,"not","","",317,null],[11,"not","","",318,null],[11,"not","","",319,null],[11,"not","","",320,null],[11,"not","","",321,null],[11,"not","","",322,null],[11,"not","","",323,null],[11,"not","","",324,null],[11,"not","","",314,null],[11,"not","","",315,null],[11,"not","","",316,null],[11,"not","","",317,null],[11,"not","","",318,null],[11,"not","","",319,null],[11,"not","","",320,null],[11,"not","","",321,null],[11,"not","","",322,null],[11,"not","","",323,null],[11,"not","","",324,null],[11,"product","","",321,{"inputs":[{"name":"i"}],"output":{"name":"i8"}}],[11,"product","","",321,{"inputs":[{"name":"i"}],"output":{"name":"i8"}}],[11,"product","","",322,{"inputs":[{"name":"i"}],"output":{"name":"i16"}}],[11,"product","","",322,{"inputs":[{"name":"i"}],"output":{"name":"i16"}}],[11,"product","","",323,{"inputs":[{"name":"i"}],"output":{"name":"i32"}}],[11,"product","","",323,{"inputs":[{"name":"i"}],"output":{"name":"i32"}}],[11,"product","","",324,{"inputs":[{"name":"i"}],"output":{"name":"i64"}}],[11,"product","","",324,{"inputs":[{"name":"i"}],"output":{"name":"i64"}}],[11,"product","","",320,{"inputs":[{"name":"i"}],"output":{"name":"isize"}}],[11,"product","","",320,{"inputs":[{"name":"i"}],"output":{"name":"isize"}}],[11,"product","","",316,{"inputs":[{"name":"i"}],"output":{"name":"u8"}}],[11,"product","","",316,{"inputs":[{"name":"i"}],"output":{"name":"u8"}}],[11,"product","","",317,{"inputs":[{"name":"i"}],"output":{"name":"u16"}}],[11,"product","","",317,{"inputs":[{"name":"i"}],"output":{"name":"u16"}}],[11,"product","","",318,{"inputs":[{"name":"i"}],"output":{"name":"u32"}}],[11,"product","","",318,{"inputs":[{"name":"i"}],"output":{"name":"u32"}}],[11,"product","","",319,{"inputs":[{"name":"i"}],"output":{"name":"u64"}}],[11,"product","","",319,{"inputs":[{"name":"i"}],"output":{"name":"u64"}}],[11,"product","","",315,{"inputs":[{"name":"i"}],"output":{"name":"usize"}}],[11,"product","","",315,{"inputs":[{"name":"i"}],"output":{"name":"usize"}}],[11,"product","std::num","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","","",189,{"inputs":[{"name":"i"}],"output":{"name":"wrapping"}}],[11,"product","std","",330,{"inputs":[{"name":"i"}],"output":{"name":"f32"}}],[11,"product","","",330,{"inputs":[{"name":"i"}],"output":{"name":"f32"}}],[11,"product","","",331,{"inputs":[{"name":"i"}],"output":{"name":"f64"}}],[11,"product","","",331,{"inputs":[{"name":"i"}],"output":{"name":"f64"}}],[11,"is_null","","Returns true if the pointer is null.",325,null],[11,"as_ref","","Returns `None` if the pointer is null, or else returns a reference to\nthe value wrapped in `Some`.",325,null],[11,"offset","","Calculates the offset from a pointer. `count` is in units of T; e.g. a\n`count` of 3 represents a pointer offset of `3 * sizeof::&lt;T&gt;()` bytes.",325,null],[11,"wrapping_offset","","Calculates the offset from a pointer using wrapping arithmetic.\n`count` is in units of T; e.g. a `count` of 3 represents a pointer\noffset of `3 * sizeof::&lt;T&gt;()` bytes.",325,null],[11,"deref","std::ptr","",381,null],[11,"deref","","",382,null],[11,"deref","std::cell","",383,null],[11,"deref","","",384,null],[11,"from_success","std::result","",68,{"inputs":[{"name":"u"}],"output":{"name":"result"}}],[11,"from_error","","",68,{"inputs":[{"name":"v"}],"output":{"name":"result"}}],[11,"translate","","",68,null],[11,"rem_assign","std::num","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","","",189,null],[11,"rem_assign","std","",315,null],[11,"rem_assign","","",316,null],[11,"rem_assign","","",317,null],[11,"rem_assign","","",318,null],[11,"rem_assign","","",319,null],[11,"rem_assign","","",320,null],[11,"rem_assign","","",321,null],[11,"rem_assign","","",322,null],[11,"rem_assign","","",323,null],[11,"rem_assign","","",324,null],[11,"rem_assign","","",330,null],[11,"rem_assign","","",331,null],[11,"fmt","std::ptr","",381,null],[11,"fmt","","",382,null],[11,"fmt","std","",325,null],[11,"fmt","","",325,null],[11,"from","std::cell","",327,{"inputs":[{"name":"t"}],"output":{"name":"cell"}}],[11,"from","","",328,{"inputs":[{"name":"t"}],"output":{"name":"refcell"}}],[11,"from","","",385,{"inputs":[{"name":"t"}],"output":{"name":"unsafecell"}}],[11,"from","std","",318,{"inputs":[{"name":"char"}],"output":{"name":"u32"}}],[11,"from","","",332,{"inputs":[{"name":"u8"}],"output":{"name":"char"}}],[11,"from","std::option","",69,{"inputs":[{"name":"t"}],"output":{"name":"option"}}],[11,"from","std","",317,{"inputs":[{"name":"u8"}],"output":{"name":"u16"}}],[11,"from","","",318,{"inputs":[{"name":"u8"}],"output":{"name":"u32"}}],[11,"from","","",319,{"inputs":[{"name":"u8"}],"output":{"name":"u64"}}],[11,"from","","",315,{"inputs":[{"name":"u8"}],"output":{"name":"usize"}}],[11,"from","","",318,{"inputs":[{"name":"u16"}],"output":{"name":"u32"}}],[11,"from","","",319,{"inputs":[{"name":"u16"}],"output":{"name":"u64"}}],[11,"from","","",319,{"inputs":[{"name":"u32"}],"output":{"name":"u64"}}],[11,"from","","",322,{"inputs":[{"name":"i8"}],"output":{"name":"i16"}}],[11,"from","","",323,{"inputs":[{"name":"i8"}],"output":{"name":"i32"}}],[11,"from","","",324,{"inputs":[{"name":"i8"}],"output":{"name":"i64"}}],[11,"from","","",320,{"inputs":[{"name":"i8"}],"output":{"name":"isize"}}],[11,"from","","",323,{"inputs":[{"name":"i16"}],"output":{"name":"i32"}}],[11,"from","","",324,{"inputs":[{"name":"i16"}],"output":{"name":"i64"}}],[11,"from","","",324,{"inputs":[{"name":"i32"}],"output":{"name":"i64"}}],[11,"from","","",322,{"inputs":[{"name":"u8"}],"output":{"name":"i16"}}],[11,"from","","",323,{"inputs":[{"name":"u8"}],"output":{"name":"i32"}}],[11,"from","","",324,{"inputs":[{"name":"u8"}],"output":{"name":"i64"}}],[11,"from","","",323,{"inputs":[{"name":"u16"}],"output":{"name":"i32"}}],[11,"from","","",324,{"inputs":[{"name":"u16"}],"output":{"name":"i64"}}],[11,"from","","",324,{"inputs":[{"name":"u32"}],"output":{"name":"i64"}}],[11,"from","","",330,{"inputs":[{"name":"i8"}],"output":{"name":"f32"}}],[11,"from","","",331,{"inputs":[{"name":"i8"}],"output":{"name":"f64"}}],[11,"from","","",330,{"inputs":[{"name":"i16"}],"output":{"name":"f32"}}],[11,"from","","",331,{"inputs":[{"name":"i16"}],"output":{"name":"f64"}}],[11,"from","","",331,{"inputs":[{"name":"i32"}],"output":{"name":"f64"}}],[11,"from","","",330,{"inputs":[{"name":"u8"}],"output":{"name":"f32"}}],[11,"from","","",331,{"inputs":[{"name":"u8"}],"output":{"name":"f64"}}],[11,"from","","",330,{"inputs":[{"name":"u16"}],"output":{"name":"f32"}}],[11,"from","","",331,{"inputs":[{"name":"u16"}],"output":{"name":"f64"}}],[11,"from","","",331,{"inputs":[{"name":"u32"}],"output":{"name":"f64"}}],[11,"from","","",331,{"inputs":[{"name":"f32"}],"output":{"name":"f64"}}],[11,"eq","std::mem","",386,null],[11,"eq","std","",325,null],[11,"eq","","",325,null],[11,"eq","","",326,null],[11,"ne","","",326,null],[11,"eq","std::cell","",327,null],[11,"eq","","",328,null],[11,"eq","std","",275,null],[11,"ne","","",275,null],[11,"eq","","",270,null],[11,"ne","","",270,null],[11,"eq","std::num","",189,null],[11,"ne","","",189,null],[11,"eq","","",387,null],[11,"ne","","",387,null],[11,"eq","","",188,null],[11,"eq","","",388,null],[11,"ne","","",388,null],[11,"eq","std::marker","",329,null],[11,"eq","std::ops","",389,null],[11,"eq","","",51,null],[11,"ne","","",51,null],[11,"eq","","",52,null],[11,"ne","","",52,null],[11,"eq","","",53,null],[11,"ne","","",53,null],[11,"eq","","",54,null],[11,"ne","","",54,null],[11,"eq","","",55,null],[11,"ne","","",55,null],[11,"eq","std::cmp","",4,null],[11,"eq","std","",314,null],[11,"ne","","",314,null],[11,"eq","","",332,null],[11,"ne","","",332,null],[11,"eq","","",315,null],[11,"ne","","",315,null],[11,"eq","","",316,null],[11,"ne","","",316,null],[11,"eq","","",317,null],[11,"ne","","",317,null],[11,"eq","","",318,null],[11,"ne","","",318,null],[11,"eq","","",319,null],[11,"ne","","",319,null],[11,"eq","","",320,null],[11,"ne","","",320,null],[11,"eq","","",321,null],[11,"ne","","",321,null],[11,"eq","","",322,null],[11,"ne","","",322,null],[11,"eq","","",323,null],[11,"ne","","",323,null],[11,"eq","","",324,null],[11,"ne","","",324,null],[11,"eq","","",330,null],[11,"ne","","",330,null],[11,"eq","","",331,null],[11,"ne","","",331,null],[11,"eq","std::any","",390,null],[11,"ne","","",390,null],[11,"eq","std","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","","",275,null],[11,"ne","","",275,null],[11,"eq","","",333,null],[11,"ne","","",333,null],[11,"eq","std::cell","",1,null],[11,"eq","std::char","",125,null],[11,"ne","","",125,null],[11,"eq","std::option","",69,null],[11,"ne","","",69,null],[11,"eq","std::result","",68,null],[11,"ne","","",68,null],[11,"eq","std::str::pattern","",88,null],[11,"ne","","",88,null],[11,"eq","std::str","",116,null],[11,"ne","","",116,null],[11,"eq","","",117,null],[11,"ne","","",117,null],[11,"eq","std::fmt","",122,null],[11,"eq","std","",326,null],[11,"ne","","",326,null],[11,"eq","","",326,null],[11,"ne","","",326,null],[11,"eq","","",326,null],[11,"ne","","",326,null],[11,"eq","","",326,null],[11,"ne","","",326,null],[11,"eq","","",326,null],[11,"ne","","",326,null],[11,"eq","","",326,null],[11,"ne","","",326,null],[11,"eq","","",326,null],[11,"ne","","",326,null],[11,"eq","","",326,null],[11,"ne","","",326,null],[11,"eq","","",326,null],[11,"ne","","",326,null],[11,"eq","","",326,null],[11,"ne","","",326,null],[11,"eq","","",326,null],[11,"ne","","",326,null],[11,"eq","","",326,null],[11,"ne","","",326,null],[11,"try_from","","",332,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",316,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",316,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",316,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",316,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",316,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",317,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",317,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",317,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",317,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",317,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",318,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",318,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",318,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",318,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",318,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",315,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",315,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",315,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",315,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",315,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",316,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",316,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",316,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",316,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"u8"}],"output":{"name":"result"}}],[11,"try_from","","",316,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",317,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",317,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",317,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",317,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"u16"}],"output":{"name":"result"}}],[11,"try_from","","",317,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",318,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",318,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",318,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",318,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"u32"}],"output":{"name":"result"}}],[11,"try_from","","",318,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"u64"}],"output":{"name":"result"}}],[11,"try_from","","",319,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"try_from","","",321,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",315,{"inputs":[{"name":"i8"}],"output":{"name":"result"}}],[11,"try_from","","",322,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",315,{"inputs":[{"name":"i16"}],"output":{"name":"result"}}],[11,"try_from","","",323,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",315,{"inputs":[{"name":"i32"}],"output":{"name":"result"}}],[11,"try_from","","",324,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",315,{"inputs":[{"name":"i64"}],"output":{"name":"result"}}],[11,"try_from","","",320,{"inputs":[{"name":"usize"}],"output":{"name":"result"}}],[11,"try_from","","",315,{"inputs":[{"name":"isize"}],"output":{"name":"result"}}],[11,"index_mut","","",275,null],[11,"index_mut","","",270,null],[11,"index_mut","","",270,null],[11,"index_mut","","",270,null],[11,"index_mut","","",270,null],[11,"index_mut","","",270,null],[11,"index_mut","","",270,null],[11,"write","std::hash","",391,null],[11,"finish","","",391,null],[11,"write","","",392,null],[11,"finish","","",392,null],[11,"write","","",393,null],[11,"finish","","",393,null],[11,"borrow_mut","std","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"borrow_mut","","",333,null],[11,"one","","",316,{"inputs":[],"output":{"name":"u8"}}],[11,"one","","",317,{"inputs":[],"output":{"name":"u16"}}],[11,"one","","",318,{"inputs":[],"output":{"name":"u32"}}],[11,"one","","",319,{"inputs":[],"output":{"name":"u64"}}],[11,"one","","",315,{"inputs":[],"output":{"name":"usize"}}],[11,"one","","",321,{"inputs":[],"output":{"name":"i8"}}],[11,"one","","",322,{"inputs":[],"output":{"name":"i16"}}],[11,"one","","",323,{"inputs":[],"output":{"name":"i32"}}],[11,"one","","",324,{"inputs":[],"output":{"name":"i64"}}],[11,"one","","",320,{"inputs":[],"output":{"name":"isize"}}],[11,"one","","",330,{"inputs":[],"output":{"name":"f32"}}],[11,"one","","",331,{"inputs":[],"output":{"name":"f64"}}],[11,"bitxor","std::num","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","","",189,null],[11,"bitxor","std","",314,null],[11,"bitxor","","",315,null],[11,"bitxor","","",316,null],[11,"bitxor","","",317,null],[11,"bitxor","","",318,null],[11,"bitxor","","",319,null],[11,"bitxor","","",320,null],[11,"bitxor","","",321,null],[11,"bitxor","","",322,null],[11,"bitxor","","",323,null],[11,"bitxor","","",324,null],[11,"bitxor","","",314,null],[11,"bitxor","","",314,null],[11,"bitxor","","",314,null],[11,"bitxor","","",315,null],[11,"bitxor","","",315,null],[11,"bitxor","","",315,null],[11,"bitxor","","",316,null],[11,"bitxor","","",316,null],[11,"bitxor","","",316,null],[11,"bitxor","","",317,null],[11,"bitxor","","",317,null],[11,"bitxor","","",317,null],[11,"bitxor","","",318,null],[11,"bitxor","","",318,null],[11,"bitxor","","",318,null],[11,"bitxor","","",319,null],[11,"bitxor","","",319,null],[11,"bitxor","","",319,null],[11,"bitxor","","",320,null],[11,"bitxor","","",320,null],[11,"bitxor","","",320,null],[11,"bitxor","","",321,null],[11,"bitxor","","",321,null],[11,"bitxor","","",321,null],[11,"bitxor","","",322,null],[11,"bitxor","","",322,null],[11,"bitxor","","",322,null],[11,"bitxor","","",323,null],[11,"bitxor","","",323,null],[11,"bitxor","","",323,null],[11,"bitxor","","",324,null],[11,"bitxor","","",324,null],[11,"bitxor","","",324,null],[11,"next","std::char","",394,null],[11,"size_hint","","",394,null],[11,"count","","",394,null],[11,"last","","",394,null],[11,"next","","",395,null],[11,"size_hint","","",395,null],[11,"count","","",395,null],[11,"nth","","",395,null],[11,"last","","",395,null],[11,"next","","",396,null],[11,"size_hint","","",396,null],[11,"next","","",397,null],[11,"next","std::iter","",398,null],[11,"size_hint","","",398,null],[11,"next","","",398,null],[11,"size_hint","","",398,null],[11,"next","","",398,null],[11,"size_hint","","",398,null],[11,"next","std::ops","",51,null],[11,"size_hint","","",51,null],[11,"next","","",52,null],[11,"next","","",54,null],[11,"size_hint","","",54,null],[11,"next","std::iter","",340,null],[11,"size_hint","","",340,null],[11,"next","","",341,null],[11,"size_hint","","",341,null],[11,"next","","",342,null],[11,"size_hint","","",342,null],[11,"next","","",343,null],[11,"size_hint","","",343,null],[11,"next","","",344,null],[11,"size_hint","","",344,null],[11,"fold","","",344,null],[11,"next","","",399,null],[11,"size_hint","","",399,null],[11,"next","","",345,null],[11,"count","","",345,null],[11,"fold","","",345,null],[11,"nth","","",345,null],[11,"find","","",345,null],[11,"last","","",345,null],[11,"size_hint","","",345,null],[11,"next","","",346,null],[11,"size_hint","","",346,null],[11,"next","","",347,null],[11,"size_hint","","",347,null],[11,"fold","","",347,null],[11,"next","","",348,null],[11,"size_hint","","",348,null],[11,"next","","",349,null],[11,"size_hint","","",349,null],[11,"next","","# Overflow Behavior",350,null],[11,"size_hint","","",350,null],[11,"nth","","",350,null],[11,"count","","",350,null],[11,"next","","",400,null],[11,"count","","",400,null],[11,"nth","","",400,null],[11,"last","","",400,null],[11,"size_hint","","",400,null],[11,"next","","",401,null],[11,"size_hint","","",401,null],[11,"next","","",402,null],[11,"size_hint","","",402,null],[11,"next","","",351,null],[11,"nth","","",351,null],[11,"count","","",351,null],[11,"last","","",351,null],[11,"size_hint","","",351,null],[11,"next","","",403,null],[11,"nth","","",403,null],[11,"size_hint","","",403,null],[11,"next","","",404,null],[11,"size_hint","","",404,null],[11,"next","","",352,null],[11,"size_hint","","",352,null],[11,"next","","",353,null],[11,"nth","","",353,null],[11,"last","","",353,null],[11,"count","","",353,null],[11,"size_hint","","",353,null],[11,"next","","",353,null],[11,"nth","","",353,null],[11,"last","","",353,null],[11,"count","","",353,null],[11,"size_hint","","",353,null],[11,"next","","",354,null],[11,"size_hint","","",354,null],[11,"next","std::option","",355,null],[11,"size_hint","","",355,null],[11,"next","","",356,null],[11,"size_hint","","",356,null],[11,"next","","",357,null],[11,"size_hint","","",357,null],[11,"next","std::result","",358,null],[11,"size_hint","","",358,null],[11,"next","","",359,null],[11,"size_hint","","",359,null],[11,"next","","",360,null],[11,"size_hint","","",360,null],[11,"next","std::slice","",361,null],[11,"size_hint","","",361,null],[11,"next","","",362,null],[11,"size_hint","","",362,null],[11,"next","","",363,null],[11,"size_hint","","",363,null],[11,"count","","",363,null],[11,"nth","","",363,null],[11,"last","","",363,null],[11,"next","","",364,null],[11,"size_hint","","",364,null],[11,"count","","",364,null],[11,"nth","","",364,null],[11,"last","","",364,null],[11,"next","","",365,null],[11,"size_hint","","",365,null],[11,"count","","",365,null],[11,"nth","","",365,null],[11,"last","","",365,null],[11,"next","std::str","",366,null],[11,"count","","",366,null],[11,"size_hint","","",366,null],[11,"last","","",366,null],[11,"next","","",367,null],[11,"count","","",367,null],[11,"size_hint","","",367,null],[11,"last","","",367,null],[11,"next","","",368,null],[11,"size_hint","","",368,null],[11,"count","","",368,null],[11,"last","","",368,null],[11,"nth","","",368,null],[11,"next","","",369,null],[11,"size_hint","","",369,null],[11,"next","","",370,null],[11,"size_hint","","",370,null],[11,"next","std::slice","",371,null],[11,"size_hint","","",371,null],[11,"count","","",371,null],[11,"nth","","",371,null],[11,"last","","",371,null],[11,"next","","",372,null],[11,"size_hint","","",372,null],[11,"count","","",372,null],[11,"nth","","",372,null],[11,"last","","",372,null],[11,"next","","",405,null],[11,"size_hint","","",405,null],[11,"next","","",406,null],[11,"size_hint","","",406,null],[11,"next","","",407,null],[11,"size_hint","","",407,null],[11,"next","","",408,null],[11,"size_hint","","",408,null],[11,"next","std::str","",373,null],[11,"next","","",374,null],[11,"next","","",375,null],[11,"next","","",376,null],[11,"next","","",409,null],[11,"next","","",410,null],[11,"next","","",377,null],[11,"next","","",378,null],[11,"next","","",379,null],[11,"next","","",380,null],[11,"add_assign","std::num","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","","",189,null],[11,"add_assign","std","",315,null],[11,"add_assign","","",316,null],[11,"add_assign","","",317,null],[11,"add_assign","","",318,null],[11,"add_assign","","",319,null],[11,"add_assign","","",320,null],[11,"add_assign","","",321,null],[11,"add_assign","","",322,null],[11,"add_assign","","",323,null],[11,"add_assign","","",324,null],[11,"add_assign","","",330,null],[11,"add_assign","","",331,null],[11,"fmt","std::num","",189,null],[11,"fmt","","",387,null],[11,"fmt","","",411,null],[11,"fmt","","",388,null],[11,"fmt","std::cell","",123,null],[11,"fmt","","",124,null],[11,"fmt","std::char","",125,null],[11,"fmt","std::str","",116,null],[11,"fmt","","",117,null],[11,"fmt","std::fmt","",412,null],[11,"fmt","","",122,null],[11,"fmt","std","",314,null],[11,"fmt","","",270,null],[11,"fmt","","",332,null],[11,"fmt","","",321,null],[11,"fmt","","",316,null],[11,"fmt","","",322,null],[11,"fmt","","",317,null],[11,"fmt","","",323,null],[11,"fmt","","",318,null],[11,"fmt","","",324,null],[11,"fmt","","",319,null],[11,"fmt","","",320,null],[11,"fmt","","",315,null],[11,"fmt","","",330,null],[11,"fmt","","",331,null],[11,"deref_mut","std::cell","",384,null],[11,"shr_assign","std::num","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","","",189,null],[11,"shr_assign","std","",316,null],[11,"shr_assign","","",316,null],[11,"shr_assign","","",316,null],[11,"shr_assign","","",316,null],[11,"shr_assign","","",316,null],[11,"shr_assign","","",316,null],[11,"shr_assign","","",316,null],[11,"shr_assign","","",316,null],[11,"shr_assign","","",316,null],[11,"shr_assign","","",316,null],[11,"shr_assign","","",317,null],[11,"shr_assign","","",317,null],[11,"shr_assign","","",317,null],[11,"shr_assign","","",317,null],[11,"shr_assign","","",317,null],[11,"shr_assign","","",317,null],[11,"shr_assign","","",317,null],[11,"shr_assign","","",317,null],[11,"shr_assign","","",317,null],[11,"shr_assign","","",317,null],[11,"shr_assign","","",318,null],[11,"shr_assign","","",318,null],[11,"shr_assign","","",318,null],[11,"shr_assign","","",318,null],[11,"shr_assign","","",318,null],[11,"shr_assign","","",318,null],[11,"shr_assign","","",318,null],[11,"shr_assign","","",318,null],[11,"shr_assign","","",318,null],[11,"shr_assign","","",318,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",319,null],[11,"shr_assign","","",315,null],[11,"shr_assign","","",315,null],[11,"shr_assign","","",315,null],[11,"shr_assign","","",315,null],[11,"shr_assign","","",315,null],[11,"shr_assign","","",315,null],[11,"shr_assign","","",315,null],[11,"shr_assign","","",315,null],[11,"shr_assign","","",315,null],[11,"shr_assign","","",315,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",321,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",322,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",323,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",324,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"shr_assign","","",320,null],[11,"from_iter","std::option","Takes each element in the `Iterator`: if it is `None`, no further\nelements are taken, and the `None` is returned. Should no `None` occur, a\ncontainer with the values of each `Option` is returned.",69,{"inputs":[{"name":"i"}],"output":{"name":"option"}}],[11,"from_iter","std::result","Takes each element in the `Iterator`: if it is an `Err`, no further\nelements are taken, and the `Err` is returned. Should no `Err` occur, a\ncontainer with the values of each `Result` is returned.",68,{"inputs":[{"name":"i"}],"output":{"name":"result"}}],[11,"mul","std::num","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","","",189,null],[11,"mul","std","",315,null],[11,"mul","","",316,null],[11,"mul","","",317,null],[11,"mul","","",318,null],[11,"mul","","",319,null],[11,"mul","","",320,null],[11,"mul","","",321,null],[11,"mul","","",322,null],[11,"mul","","",323,null],[11,"mul","","",324,null],[11,"mul","","",330,null],[11,"mul","","",331,null],[11,"mul","","",315,null],[11,"mul","","",315,null],[11,"mul","","",315,null],[11,"mul","","",316,null],[11,"mul","","",316,null],[11,"mul","","",316,null],[11,"mul","","",317,null],[11,"mul","","",317,null],[11,"mul","","",317,null],[11,"mul","","",318,null],[11,"mul","","",318,null],[11,"mul","","",318,null],[11,"mul","","",319,null],[11,"mul","","",319,null],[11,"mul","","",319,null],[11,"mul","","",320,null],[11,"mul","","",320,null],[11,"mul","","",320,null],[11,"mul","","",321,null],[11,"mul","","",321,null],[11,"mul","","",321,null],[11,"mul","","",322,null],[11,"mul","","",322,null],[11,"mul","","",322,null],[11,"mul","","",323,null],[11,"mul","","",323,null],[11,"mul","","",323,null],[11,"mul","","",324,null],[11,"mul","","",324,null],[11,"mul","","",324,null],[11,"mul","","",330,null],[11,"mul","","",330,null],[11,"mul","","",330,null],[11,"mul","","",331,null],[11,"mul","","",331,null],[11,"mul","","",331,null],[11,"get","","",315,null],[11,"get_mut","","",315,null],[11,"get_unchecked","","",315,null],[11,"get_unchecked_mut","","",315,null],[11,"index","","",315,null],[11,"index_mut","","",315,null],[11,"get","std::ops","",51,null],[11,"get_mut","","",51,null],[11,"get_unchecked","","",51,null],[11,"get_unchecked_mut","","",51,null],[11,"index","","",51,null],[11,"index_mut","","",51,null],[11,"get","","",53,null],[11,"get_mut","","",53,null],[11,"get_unchecked","","",53,null],[11,"get_unchecked_mut","","",53,null],[11,"index","","",53,null],[11,"index_mut","","",53,null],[11,"get","","",52,null],[11,"get_mut","","",52,null],[11,"get_unchecked","","",52,null],[11,"get_unchecked_mut","","",52,null],[11,"index","","",52,null],[11,"index_mut","","",52,null],[11,"get","","",389,null],[11,"get_mut","","",389,null],[11,"get_unchecked","","",389,null],[11,"get_unchecked_mut","","",389,null],[11,"index","","",389,null],[11,"index_mut","","",389,null],[11,"get","","",54,null],[11,"get_mut","","",54,null],[11,"get_unchecked","","",54,null],[11,"get_unchecked_mut","","",54,null],[11,"index","","",54,null],[11,"index_mut","","",54,null],[11,"get","","",55,null],[11,"get_mut","","",55,null],[11,"get_unchecked","","",55,null],[11,"get_unchecked_mut","","",55,null],[11,"index","","",55,null],[11,"index_mut","","",55,null],[11,"neg","std::num","",189,null],[11,"neg","","",189,null],[11,"neg","","",189,null],[11,"neg","","",189,null],[11,"neg","","",189,null],[11,"neg","","",189,null],[11,"neg","","",189,null],[11,"neg","","",189,null],[11,"neg","","",189,null],[11,"neg","","",189,null],[11,"neg","std","",320,null],[11,"neg","","",321,null],[11,"neg","","",322,null],[11,"neg","","",323,null],[11,"neg","","",324,null],[11,"neg","","",330,null],[11,"neg","","",331,null],[11,"neg","","",320,null],[11,"neg","","",321,null],[11,"neg","","",322,null],[11,"neg","","",323,null],[11,"neg","","",324,null],[11,"neg","","",330,null],[11,"neg","","",331,null],[11,"zero","","",316,{"inputs":[],"output":{"name":"u8"}}],[11,"zero","","",317,{"inputs":[],"output":{"name":"u16"}}],[11,"zero","","",318,{"inputs":[],"output":{"name":"u32"}}],[11,"zero","","",319,{"inputs":[],"output":{"name":"u64"}}],[11,"zero","","",315,{"inputs":[],"output":{"name":"usize"}}],[11,"zero","","",321,{"inputs":[],"output":{"name":"i8"}}],[11,"zero","","",322,{"inputs":[],"output":{"name":"i16"}}],[11,"zero","","",323,{"inputs":[],"output":{"name":"i32"}}],[11,"zero","","",324,{"inputs":[],"output":{"name":"i64"}}],[11,"zero","","",320,{"inputs":[],"output":{"name":"isize"}}],[11,"zero","","",330,{"inputs":[],"output":{"name":"f32"}}],[11,"zero","","",331,{"inputs":[],"output":{"name":"f64"}}],[11,"fmt","std::num","",189,null],[11,"fmt","std","",320,null],[11,"fmt","","",315,null],[11,"fmt","","",321,null],[11,"fmt","","",316,null],[11,"fmt","","",322,null],[11,"fmt","","",317,null],[11,"fmt","","",323,null],[11,"fmt","","",318,null],[11,"fmt","","",324,null],[11,"fmt","","",319,null],[11,"bitand_assign","std::num","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","","",189,null],[11,"bitand_assign","std","",314,null],[11,"bitand_assign","","",315,null],[11,"bitand_assign","","",316,null],[11,"bitand_assign","","",317,null],[11,"bitand_assign","","",318,null],[11,"bitand_assign","","",319,null],[11,"bitand_assign","","",320,null],[11,"bitand_assign","","",321,null],[11,"bitand_assign","","",322,null],[11,"bitand_assign","","",323,null],[11,"bitand_assign","","",324,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"borrow","","",333,null],[11,"clone","std::mem","",386,null],[11,"clone","std","",325,null],[11,"clone","","",325,null],[11,"clone","std::ptr","",382,null],[11,"clone","std::cell","",327,null],[11,"clone","","",328,null],[11,"clone","std::iter","",341,null],[11,"clone","std::option","",355,null],[11,"clone","std::result","",358,null],[11,"clone","std::slice","",371,null],[11,"clone","","",361,null],[11,"clone","","",363,null],[11,"clone","","",364,null],[11,"clone","std::hash","",339,null],[11,"clone","std::num","",189,null],[11,"clone","","",387,null],[11,"clone","","",188,null],[11,"clone","","",411,null],[11,"clone","","",388,null],[11,"clone","std::marker","",329,null],[11,"clone","std::ops","",389,null],[11,"clone","","",51,null],[11,"clone","","",52,null],[11,"clone","","",53,null],[11,"clone","","",54,null],[11,"clone","","",55,null],[11,"clone","std::cmp","",4,null],[11,"clone","std","Returns a deep copy of the value.",320,null],[11,"clone","","Returns a deep copy of the value.",321,null],[11,"clone","","Returns a deep copy of the value.",322,null],[11,"clone","","Returns a deep copy of the value.",323,null],[11,"clone","","Returns a deep copy of the value.",324,null],[11,"clone","","Returns a deep copy of the value.",315,null],[11,"clone","","Returns a deep copy of the value.",316,null],[11,"clone","","Returns a deep copy of the value.",317,null],[11,"clone","","Returns a deep copy of the value.",318,null],[11,"clone","","Returns a deep copy of the value.",319,null],[11,"clone","","Returns a deep copy of the value.",330,null],[11,"clone","","Returns a deep copy of the value.",331,null],[11,"clone","","Returns a deep copy of the value.",326,null],[11,"clone","","Returns a deep copy of the value.",314,null],[11,"clone","","Returns a deep copy of the value.",332,null],[11,"clone","std::any","",390,null],[11,"clone","std","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","","",333,null],[11,"clone","std::sync::atomic","",225,null],[11,"clone","std::cell","",1,null],[11,"clone","std::char","",125,null],[11,"clone","","",394,null],[11,"clone","","",395,null],[11,"clone","","",396,null],[11,"clone","","",397,null],[11,"clone","std::iter","",398,null],[11,"clone","","",340,null],[11,"clone","","",342,null],[11,"clone","","",343,null],[11,"clone","","",344,null],[11,"clone","","",399,null],[11,"clone","","",345,null],[11,"clone","","",346,null],[11,"clone","","",347,null],[11,"clone","","",348,null],[11,"clone","","",349,null],[11,"clone","","",350,null],[11,"clone","","",400,null],[11,"clone","","",401,null],[11,"clone","","",402,null],[11,"clone","","",351,null],[11,"clone","","",403,null],[11,"clone","","",404,null],[11,"clone","","",352,null],[11,"clone","","",353,null],[11,"clone","","",354,null],[11,"clone","std::option","",69,null],[11,"clone","","",357,null],[11,"clone","std::raw","",67,null],[11,"clone","std::result","",68,null],[11,"clone","std::str::pattern","",88,null],[11,"clone","","",335,null],[11,"clone","","",336,null],[11,"clone","","",337,null],[11,"clone","","",338,null],[11,"clone","std::str","",116,null],[11,"clone","","",117,null],[11,"clone","","",366,null],[11,"clone","","",367,null],[11,"clone","","",368,null],[11,"clone","","",373,null],[11,"clone","","",374,null],[11,"clone","","",375,null],[11,"clone","","",376,null],[11,"clone","","",409,null],[11,"clone","","",410,null],[11,"clone","","",377,null],[11,"clone","","",378,null],[11,"clone","","",379,null],[11,"clone","","",380,null],[11,"clone","","",369,null],[11,"clone","","",370,null],[11,"clone","std::hash","",392,null],[11,"clone","","",393,null],[11,"clone","","",391,null],[11,"clone","std::fmt","",122,null],[11,"clone","","",412,null],[11,"clone","std","",326,null],[11,"clone","","",326,null],[11,"clone","","",326,null],[11,"clone","","",326,null],[11,"clone","","",326,null],[11,"clone","","",326,null],[11,"clone","","",326,null],[11,"clone","","",326,null],[11,"clone","","",326,null],[11,"clone","","",326,null],[11,"clone","","",326,null],[11,"clone","","",326,null],[11,"fmt","std::num","",189,null],[11,"fmt","std::mem","",386,null],[11,"fmt","std::ops","",389,null],[11,"fmt","","",51,null],[11,"fmt","","",52,null],[11,"fmt","","",53,null],[11,"fmt","","",54,null],[11,"fmt","","",55,null],[11,"fmt","std::any","",0,null],[11,"fmt","","",0,null],[11,"fmt","std::sync::atomic","",413,null],[11,"fmt","","",414,null],[11,"fmt","std::cell","",123,null],[11,"fmt","","",124,null],[11,"fmt","std::iter","",341,null],[11,"fmt","","",347,null],[11,"fmt","","",348,null],[11,"fmt","","",349,null],[11,"fmt","","",401,null],[11,"fmt","","",402,null],[11,"fmt","","",404,null],[11,"fmt","","",352,null],[11,"fmt","","",354,null],[11,"fmt","std::slice","",371,null],[11,"fmt","","",372,null],[11,"fmt","","",361,null],[11,"fmt","","",362,null],[11,"fmt","","",405,null],[11,"fmt","","",406,null],[11,"fmt","","",407,null],[11,"fmt","","",408,null],[11,"fmt","std::str::pattern","",337,null],[11,"fmt","std::hash","",339,null],[11,"fmt","std::fmt","",412,null],[11,"fmt","std","",314,null],[11,"fmt","","",270,null],[11,"fmt","","",332,null],[11,"fmt","","",325,null],[11,"fmt","","",325,null],[11,"fmt","","",275,null],[11,"fmt","","",326,null],[11,"fmt","std::marker","",329,null],[11,"fmt","std::cell","",327,null],[11,"fmt","","",328,null],[11,"fmt","","",383,null],[11,"fmt","","",384,null],[11,"fmt","","",385,null],[11,"fmt","std::num","",387,null],[11,"fmt","","",188,null],[11,"fmt","","",411,null],[11,"fmt","","",388,null],[11,"fmt","std::cmp","",4,null],[11,"fmt","std::any","",390,null],[11,"fmt","std","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","","",333,null],[11,"fmt","std::sync::atomic","",225,null],[11,"fmt","","",415,null],[11,"fmt","","",416,null],[11,"fmt","","",417,null],[11,"fmt","","",418,null],[11,"fmt","","",419,null],[11,"fmt","","",420,null],[11,"fmt","","",421,null],[11,"fmt","","",422,null],[11,"fmt","","",423,null],[11,"fmt","","",424,null],[11,"fmt","std::cell","",1,null],[11,"fmt","std::char","",125,null],[11,"fmt","","",394,null],[11,"fmt","","",395,null],[11,"fmt","","",396,null],[11,"fmt","","",397,null],[11,"fmt","std::iter","",398,null],[11,"fmt","","",340,null],[11,"fmt","","",342,null],[11,"fmt","","",343,null],[11,"fmt","","",344,null],[11,"fmt","","",399,null],[11,"fmt","","",345,null],[11,"fmt","","",346,null],[11,"fmt","","",350,null],[11,"fmt","","",400,null],[11,"fmt","","",351,null],[11,"fmt","","",403,null],[11,"fmt","","",353,null],[11,"fmt","std::option","",69,null],[11,"fmt","","",355,null],[11,"fmt","","",356,null],[11,"fmt","","",357,null],[11,"fmt","std::result","",68,null],[11,"fmt","","",358,null],[11,"fmt","","",359,null],[11,"fmt","","",360,null],[11,"fmt","std::slice","",363,null],[11,"fmt","","",364,null],[11,"fmt","","",365,null],[11,"fmt","std::str::pattern","",88,null],[11,"fmt","","",335,null],[11,"fmt","","",336,null],[11,"fmt","","",338,null],[11,"fmt","std::str","",116,null],[11,"fmt","","",117,null],[11,"fmt","","",366,null],[11,"fmt","","",367,null],[11,"fmt","","",368,null],[11,"fmt","","",373,null],[11,"fmt","","",374,null],[11,"fmt","","",375,null],[11,"fmt","","",376,null],[11,"fmt","","",409,null],[11,"fmt","","",410,null],[11,"fmt","","",377,null],[11,"fmt","","",378,null],[11,"fmt","","",379,null],[11,"fmt","","",380,null],[11,"fmt","","",369,null],[11,"fmt","","",370,null],[11,"fmt","std::hash","",392,null],[11,"fmt","","",393,null],[11,"fmt","","",391,null],[11,"fmt","std","",320,null],[11,"fmt","","",315,null],[11,"fmt","","",321,null],[11,"fmt","","",316,null],[11,"fmt","","",322,null],[11,"fmt","","",317,null],[11,"fmt","","",323,null],[11,"fmt","","",318,null],[11,"fmt","","",324,null],[11,"fmt","","",319,null],[11,"fmt","std::fmt","",122,null],[11,"fmt","std","",330,null],[11,"fmt","","",331,null],[11,"fmt","","",326,null],[11,"fmt","","",326,null],[11,"fmt","","",326,null],[11,"fmt","","",326,null],[11,"fmt","","",326,null],[11,"fmt","","",326,null],[11,"fmt","","",326,null],[11,"fmt","","",326,null],[11,"fmt","","",326,null],[11,"fmt","","",326,null],[11,"fmt","","",326,null],[11,"fmt","","",326,null],[11,"sub_assign","std::num","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","","",189,null],[11,"sub_assign","std","",315,null],[11,"sub_assign","","",316,null],[11,"sub_assign","","",317,null],[11,"sub_assign","","",318,null],[11,"sub_assign","","",319,null],[11,"sub_assign","","",320,null],[11,"sub_assign","","",321,null],[11,"sub_assign","","",322,null],[11,"sub_assign","","",323,null],[11,"sub_assign","","",324,null],[11,"sub_assign","","",330,null],[11,"sub_assign","","",331,null],[11,"default","std::sync::atomic","Creates an `AtomicBool` initialized to `false`.",413,{"inputs":[],"output":{"name":"atomicbool"}}],[11,"default","","Creates a null `AtomicPtr&lt;T&gt;`.",414,{"inputs":[],"output":{"name":"atomicptr"}}],[11,"default","std::cell","Creates a `Cell&lt;T&gt;`, with the `Default` value for T.",327,{"inputs":[],"output":{"name":"cell"}}],[11,"default","","Creates a `RefCell&lt;T&gt;`, with the `Default` value for T.",328,{"inputs":[],"output":{"name":"refcell"}}],[11,"default","","Creates an `UnsafeCell`, with the `Default` value for T.",385,{"inputs":[],"output":{"name":"unsafecell"}}],[11,"default","std::iter","",341,{"inputs":[],"output":{"name":"empty"}}],[11,"default","std::option","Returns None.",69,{"inputs":[],"output":{"name":"option"}}],[11,"default","std","Creates an empty slice.",275,null],[11,"default","","Creates a mutable empty slice.",275,null],[11,"default","","Creates an empty str",270,{"inputs":[],"output":{"name":"str"}}],[11,"default","std::hash","",339,{"inputs":[],"output":{"name":"buildhasherdefault"}}],[11,"default","std::num","",189,{"inputs":[],"output":{"name":"wrapping"}}],[11,"default","std::marker","",329,{"inputs":[],"output":{"name":"phantomdata"}}],[11,"default","std","",326,null],[11,"default","","",314,{"inputs":[],"output":{"name":"bool"}}],[11,"default","","",332,{"inputs":[],"output":{"name":"char"}}],[11,"default","","",315,{"inputs":[],"output":{"name":"usize"}}],[11,"default","","",316,{"inputs":[],"output":{"name":"u8"}}],[11,"default","","",317,{"inputs":[],"output":{"name":"u16"}}],[11,"default","","",318,{"inputs":[],"output":{"name":"u32"}}],[11,"default","","",319,{"inputs":[],"output":{"name":"u64"}}],[11,"default","","",320,{"inputs":[],"output":{"name":"isize"}}],[11,"default","","",321,{"inputs":[],"output":{"name":"i8"}}],[11,"default","","",322,{"inputs":[],"output":{"name":"i16"}}],[11,"default","","",323,{"inputs":[],"output":{"name":"i32"}}],[11,"default","","",324,{"inputs":[],"output":{"name":"i64"}}],[11,"default","","",330,{"inputs":[],"output":{"name":"f32"}}],[11,"default","","",331,{"inputs":[],"output":{"name":"f64"}}],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","","",333,null],[11,"default","std::sync::atomic","",415,{"inputs":[],"output":{"name":"atomici8"}}],[11,"default","","",416,{"inputs":[],"output":{"name":"atomicu8"}}],[11,"default","","",417,{"inputs":[],"output":{"name":"atomici16"}}],[11,"default","","",418,{"inputs":[],"output":{"name":"atomicu16"}}],[11,"default","","",419,{"inputs":[],"output":{"name":"atomici32"}}],[11,"default","","",420,{"inputs":[],"output":{"name":"atomicu32"}}],[11,"default","","",421,{"inputs":[],"output":{"name":"atomici64"}}],[11,"default","","",422,{"inputs":[],"output":{"name":"atomicu64"}}],[11,"default","","",423,{"inputs":[],"output":{"name":"atomicisize"}}],[11,"default","","",424,{"inputs":[],"output":{"name":"atomicusize"}}],[11,"default","std::hash","",392,{"inputs":[],"output":{"name":"siphasher13"}}],[11,"default","","",393,{"inputs":[],"output":{"name":"siphasher24"}}],[11,"default","","",391,{"inputs":[],"output":{"name":"siphasher"}}],[11,"default","std::fmt","",122,{"inputs":[],"output":{"name":"error"}}],[11,"default","std","",326,null],[11,"default","","",326,null],[11,"default","","",326,null],[11,"default","","",326,null],[11,"default","","",326,null],[11,"default","","",326,null],[11,"default","","",326,null],[11,"default","","",326,null],[11,"default","","",326,null],[11,"default","","",326,null],[11,"default","","",326,null],[11,"default","","",326,null],[11,"index","","",275,null],[11,"index","","",270,null],[11,"index","","",270,null],[11,"index","","",270,null],[11,"index","","",270,null],[11,"index","","",270,null],[11,"index","","",270,null],[11,"into_iter","std::option","Returns a consuming iterator over the possibly contained value.",69,null],[11,"into_iter","std::result","Returns a consuming iterator over the possibly contained value.",68,null],[11,"into_iter","std","",275,null],[11,"into_iter","","",275,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"into_iter","","",333,null],[11,"bitor","std::num","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","","",189,null],[11,"bitor","std","",314,null],[11,"bitor","","",315,null],[11,"bitor","","",316,null],[11,"bitor","","",317,null],[11,"bitor","","",318,null],[11,"bitor","","",319,null],[11,"bitor","","",320,null],[11,"bitor","","",321,null],[11,"bitor","","",322,null],[11,"bitor","","",323,null],[11,"bitor","","",324,null],[11,"bitor","","",314,null],[11,"bitor","","",314,null],[11,"bitor","","",314,null],[11,"bitor","","",315,null],[11,"bitor","","",315,null],[11,"bitor","","",315,null],[11,"bitor","","",316,null],[11,"bitor","","",316,null],[11,"bitor","","",316,null],[11,"bitor","","",317,null],[11,"bitor","","",317,null],[11,"bitor","","",317,null],[11,"bitor","","",318,null],[11,"bitor","","",318,null],[11,"bitor","","",318,null],[11,"bitor","","",319,null],[11,"bitor","","",319,null],[11,"bitor","","",319,null],[11,"bitor","","",320,null],[11,"bitor","","",320,null],[11,"bitor","","",320,null],[11,"bitor","","",321,null],[11,"bitor","","",321,null],[11,"bitor","","",321,null],[11,"bitor","","",322,null],[11,"bitor","","",322,null],[11,"bitor","","",322,null],[11,"bitor","","",323,null],[11,"bitor","","",323,null],[11,"bitor","","",323,null],[11,"bitor","","",324,null],[11,"bitor","","",324,null],[11,"bitor","","",324,null],[11,"shr","std::num","",189,null],[11,"shr","","",189,null],[11,"shr","","",189,null],[11,"shr","","",189,null],[11,"shr","","",189,null],[11,"shr","","",189,null],[11,"shr","","",189,null],[11,"shr","","",189,null],[11,"shr","","",189,null],[11,"shr","","",189,null],[11,"shr","std","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",316,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",317,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",318,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",319,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",315,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",321,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",322,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",323,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",324,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"shr","","",320,null],[11,"fmt","std::num","",189,null],[11,"fmt","std","",320,null],[11,"fmt","","",315,null],[11,"fmt","","",321,null],[11,"fmt","","",316,null],[11,"fmt","","",322,null],[11,"fmt","","",317,null],[11,"fmt","","",323,null],[11,"fmt","","",318,null],[11,"fmt","","",324,null],[11,"fmt","","",319,null],[11,"as_mut","","",275,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"as_mut","","",333,null],[11,"bitor_assign","std::num","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","","",189,null],[11,"bitor_assign","std","",314,null],[11,"bitor_assign","","",315,null],[11,"bitor_assign","","",316,null],[11,"bitor_assign","","",317,null],[11,"bitor_assign","","",318,null],[11,"bitor_assign","","",319,null],[11,"bitor_assign","","",320,null],[11,"bitor_assign","","",321,null],[11,"bitor_assign","","",322,null],[11,"bitor_assign","","",323,null],[11,"bitor_assign","","",324,null],[11,"into_searcher","","",332,null],[11,"is_contained_in","","",332,null],[11,"is_prefix_of","","",332,null],[11,"is_suffix_of","","",332,null],[11,"into_searcher","","",275,null],[11,"is_contained_in","","",275,null],[11,"is_prefix_of","","",275,null],[11,"is_suffix_of","","",275,null],[11,"into_searcher","","",270,null],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the haystack",270,null],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the haystack",270,null],[11,"sub","std::num","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","","",189,null],[11,"sub","std","",315,null],[11,"sub","","",316,null],[11,"sub","","",317,null],[11,"sub","","",318,null],[11,"sub","","",319,null],[11,"sub","","",320,null],[11,"sub","","",321,null],[11,"sub","","",322,null],[11,"sub","","",323,null],[11,"sub","","",324,null],[11,"sub","","",330,null],[11,"sub","","",331,null],[11,"sub","","",315,null],[11,"sub","","",315,null],[11,"sub","","",315,null],[11,"sub","","",316,null],[11,"sub","","",316,null],[11,"sub","","",316,null],[11,"sub","","",317,null],[11,"sub","","",317,null],[11,"sub","","",317,null],[11,"sub","","",318,null],[11,"sub","","",318,null],[11,"sub","","",318,null],[11,"sub","","",319,null],[11,"sub","","",319,null],[11,"sub","","",319,null],[11,"sub","","",320,null],[11,"sub","","",320,null],[11,"sub","","",320,null],[11,"sub","","",321,null],[11,"sub","","",321,null],[11,"sub","","",321,null],[11,"sub","","",322,null],[11,"sub","","",322,null],[11,"sub","","",322,null],[11,"sub","","",323,null],[11,"sub","","",323,null],[11,"sub","","",323,null],[11,"sub","","",324,null],[11,"sub","","",324,null],[11,"sub","","",324,null],[11,"sub","","",330,null],[11,"sub","","",330,null],[11,"sub","","",330,null],[11,"sub","","",331,null],[11,"sub","","",331,null],[11,"sub","","",331,null],[11,"len","std::char","",394,null],[11,"len","","",395,null],[11,"len","std::iter","",341,null],[11,"len","","",342,null],[11,"len","","",343,null],[11,"is_empty","","",343,null],[11,"len","","",344,null],[11,"is_empty","","",344,null],[11,"len","","",347,null],[11,"is_empty","","",347,null],[11,"len","","",350,null],[11,"is_empty","","",350,null],[11,"len","","",353,null],[11,"is_empty","","",353,null],[11,"len","","",354,null],[11,"is_empty","","",354,null],[11,"is_empty","std::slice","",371,null],[11,"is_empty","","",372,null],[11,"len","std::str","",368,null],[11,"is_empty","","",368,null],[11,"rem","std::num","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","","",189,null],[11,"rem","std","",315,null],[11,"rem","","",316,null],[11,"rem","","",317,null],[11,"rem","","",318,null],[11,"rem","","",319,null],[11,"rem","","",320,null],[11,"rem","","",321,null],[11,"rem","","",322,null],[11,"rem","","",323,null],[11,"rem","","",324,null],[11,"rem","","",315,null],[11,"rem","","",315,null],[11,"rem","","",315,null],[11,"rem","","",316,null],[11,"rem","","",316,null],[11,"rem","","",316,null],[11,"rem","","",317,null],[11,"rem","","",317,null],[11,"rem","","",317,null],[11,"rem","","",318,null],[11,"rem","","",318,null],[11,"rem","","",318,null],[11,"rem","","",319,null],[11,"rem","","",319,null],[11,"rem","","",319,null],[11,"rem","","",320,null],[11,"rem","","",320,null],[11,"rem","","",320,null],[11,"rem","","",321,null],[11,"rem","","",321,null],[11,"rem","","",321,null],[11,"rem","","",322,null],[11,"rem","","",322,null],[11,"rem","","",322,null],[11,"rem","","",323,null],[11,"rem","","",323,null],[11,"rem","","",323,null],[11,"rem","","",324,null],[11,"rem","","",324,null],[11,"rem","","",324,null],[11,"rem","","",330,null],[11,"rem","","",331,null],[11,"rem","","",330,null],[11,"rem","","",330,null],[11,"rem","","",330,null],[11,"rem","","",331,null],[11,"rem","","",331,null],[11,"rem","","",331,null],[11,"mul_assign","std::num","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","","",189,null],[11,"mul_assign","std","",315,null],[11,"mul_assign","","",316,null],[11,"mul_assign","","",317,null],[11,"mul_assign","","",318,null],[11,"mul_assign","","",319,null],[11,"mul_assign","","",320,null],[11,"mul_assign","","",321,null],[11,"mul_assign","","",322,null],[11,"mul_assign","","",323,null],[11,"mul_assign","","",324,null],[11,"mul_assign","","",330,null],[11,"mul_assign","","",331,null],[11,"fmt","","",330,null],[11,"fmt","","",331,null],[11,"hash","std::mem","",386,null],[11,"hash","std","",314,null],[11,"hash","","",332,null],[11,"hash","","",270,null],[11,"hash","","",275,null],[11,"hash","","",325,null],[11,"hash","","",325,null],[11,"hash","std::num","",189,null],[11,"hash","std::marker","",329,null],[11,"hash","std::ops","",389,null],[11,"hash","","",51,null],[11,"hash","","",52,null],[11,"hash","","",53,null],[11,"hash","","",54,null],[11,"hash","","",55,null],[11,"hash","std::cmp","",4,null],[11,"hash","std::any","",390,null],[11,"hash","std","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","","",333,null],[11,"hash","std::option","",69,null],[11,"hash","std::result","",68,null],[11,"hash","std","",316,null],[11,"hash_slice","","",316,null],[11,"hash","","",317,null],[11,"hash_slice","","",317,null],[11,"hash","","",318,null],[11,"hash_slice","","",318,null],[11,"hash","","",319,null],[11,"hash_slice","","",319,null],[11,"hash","","",315,null],[11,"hash_slice","","",315,null],[11,"hash","","",321,null],[11,"hash_slice","","",321,null],[11,"hash","","",322,null],[11,"hash_slice","","",322,null],[11,"hash","","",323,null],[11,"hash_slice","","",323,null],[11,"hash","","",324,null],[11,"hash_slice","","",324,null],[11,"hash","","",320,null],[11,"hash_slice","","",320,null],[11,"hash","","",326,null],[11,"hash","","",326,null],[11,"hash","","",326,null],[11,"hash","","",326,null],[11,"hash","","",326,null],[11,"hash","","",326,null],[11,"hash","","",326,null],[11,"hash","","",326,null],[11,"hash","","",326,null],[11,"hash","","",326,null],[11,"hash","","",326,null],[11,"hash","","",326,null],[11,"hash","","",326,null],[11,"hash","std::fmt","",122,null],[11,"haystack","std::str::pattern","",335,null],[11,"next","","",335,null],[11,"next_match","","",335,null],[11,"next_reject","","",335,null],[11,"haystack","","",336,null],[11,"next","","",336,null],[11,"next_match","","",336,null],[11,"next_reject","","",336,null],[11,"haystack","","",337,null],[11,"next","","",337,null],[11,"next_match","","",337,null],[11,"next_reject","","",337,null],[11,"haystack","","",338,null],[11,"next","","",338,null],[11,"next_match","","",338,null],[11,"from_str","std","Parse a `bool` from a string.",314,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","Converts a string in base 10 to a float.\nAccepts an optional decimal exponent.",330,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","Converts a string in base 10 to a float.\nAccepts an optional decimal exponent.",331,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",320,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",321,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",322,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",323,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",324,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",315,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",316,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",317,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",318,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"from_str","","",319,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"as_ref","","",275,null],[11,"as_ref","","",270,null],[11,"as_ref","std::slice","",371,null],[11,"as_ref","std","",270,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"as_ref","","",333,null],[11,"fmt","std::num","",189,null],[11,"fmt","std","",320,null],[11,"fmt","","",315,null],[11,"fmt","","",321,null],[11,"fmt","","",316,null],[11,"fmt","","",322,null],[11,"fmt","","",317,null],[11,"fmt","","",323,null],[11,"fmt","","",318,null],[11,"fmt","","",324,null],[11,"fmt","","",319,null],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",320,{"inputs":[],"output":{"name":"isize"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",320,{"inputs":[],"output":{"name":"isize"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",320,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",320,null],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",320,null],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",320,null],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",320,null],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",320,null],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",320,null],[11,"swap_bytes","","Reverses the byte order of the integer.",320,null],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",320,{"inputs":[{"name":"isize"}],"output":{"name":"isize"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",320,{"inputs":[{"name":"isize"}],"output":{"name":"isize"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",320,null],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",320,null],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",320,null],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",320,null],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",320,null],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",320,null],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",320,null],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` if `self ==\nMIN`.",320,null],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",320,null],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",320,null],[11,"checked_abs","","Checked absolute value. Computes `self.abs()`, returning `None` if\n`self == MIN`.",320,null],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",320,null],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",320,null],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",320,null],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",320,null],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",320,null],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",320,null],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`,\nwrapping around at the boundary of the type.",320,null],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`,\nwrapping around at the boundary of the type.",320,null],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",320,null],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",320,null],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",320,null],[11,"wrapping_abs","","Wrapping (modular) absolute value. Computes `self.abs()`,\nwrapping around at the boundary of the type.",320,null],[11,"overflowing_add","","Calculates `self` + `rhs`",320,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",320,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",320,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",320,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",320,null],[11,"overflowing_neg","","Negates self, overflowing if this is equal to the minimum value.",320,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",320,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",320,null],[11,"overflowing_abs","","Computes the absolute value of `self`.",320,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",320,null],[11,"abs","","Computes the absolute value of `self`.",320,null],[11,"signum","","Returns a number representing sign of `self`.",320,null],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number\nis zero or negative.",320,null],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number\nis zero or positive.",320,null],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",321,{"inputs":[],"output":{"name":"i8"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",321,{"inputs":[],"output":{"name":"i8"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",321,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",321,null],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",321,null],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",321,null],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",321,null],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",321,null],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",321,null],[11,"swap_bytes","","Reverses the byte order of the integer.",321,null],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",321,{"inputs":[{"name":"i8"}],"output":{"name":"i8"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",321,{"inputs":[{"name":"i8"}],"output":{"name":"i8"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",321,null],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",321,null],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",321,null],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",321,null],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",321,null],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",321,null],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",321,null],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` if `self ==\nMIN`.",321,null],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",321,null],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",321,null],[11,"checked_abs","","Checked absolute value. Computes `self.abs()`, returning `None` if\n`self == MIN`.",321,null],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",321,null],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",321,null],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",321,null],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",321,null],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",321,null],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",321,null],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`,\nwrapping around at the boundary of the type.",321,null],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`,\nwrapping around at the boundary of the type.",321,null],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",321,null],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",321,null],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",321,null],[11,"wrapping_abs","","Wrapping (modular) absolute value. Computes `self.abs()`,\nwrapping around at the boundary of the type.",321,null],[11,"overflowing_add","","Calculates `self` + `rhs`",321,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",321,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",321,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",321,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",321,null],[11,"overflowing_neg","","Negates self, overflowing if this is equal to the minimum value.",321,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",321,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",321,null],[11,"overflowing_abs","","Computes the absolute value of `self`.",321,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",321,null],[11,"abs","","Computes the absolute value of `self`.",321,null],[11,"signum","","Returns a number representing sign of `self`.",321,null],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number\nis zero or negative.",321,null],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number\nis zero or positive.",321,null],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",322,{"inputs":[],"output":{"name":"i16"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",322,{"inputs":[],"output":{"name":"i16"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",322,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",322,null],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",322,null],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",322,null],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",322,null],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",322,null],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",322,null],[11,"swap_bytes","","Reverses the byte order of the integer.",322,null],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",322,{"inputs":[{"name":"i16"}],"output":{"name":"i16"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",322,{"inputs":[{"name":"i16"}],"output":{"name":"i16"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",322,null],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",322,null],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",322,null],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",322,null],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",322,null],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",322,null],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",322,null],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` if `self ==\nMIN`.",322,null],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",322,null],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",322,null],[11,"checked_abs","","Checked absolute value. Computes `self.abs()`, returning `None` if\n`self == MIN`.",322,null],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",322,null],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",322,null],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",322,null],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",322,null],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",322,null],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",322,null],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`,\nwrapping around at the boundary of the type.",322,null],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`,\nwrapping around at the boundary of the type.",322,null],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",322,null],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",322,null],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",322,null],[11,"wrapping_abs","","Wrapping (modular) absolute value. Computes `self.abs()`,\nwrapping around at the boundary of the type.",322,null],[11,"overflowing_add","","Calculates `self` + `rhs`",322,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",322,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",322,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",322,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",322,null],[11,"overflowing_neg","","Negates self, overflowing if this is equal to the minimum value.",322,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",322,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",322,null],[11,"overflowing_abs","","Computes the absolute value of `self`.",322,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",322,null],[11,"abs","","Computes the absolute value of `self`.",322,null],[11,"signum","","Returns a number representing sign of `self`.",322,null],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number\nis zero or negative.",322,null],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number\nis zero or positive.",322,null],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",323,{"inputs":[],"output":{"name":"i32"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",323,{"inputs":[],"output":{"name":"i32"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",323,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",323,null],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",323,null],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",323,null],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",323,null],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",323,null],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",323,null],[11,"swap_bytes","","Reverses the byte order of the integer.",323,null],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",323,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",323,{"inputs":[{"name":"i32"}],"output":{"name":"i32"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",323,null],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",323,null],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",323,null],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",323,null],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",323,null],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",323,null],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",323,null],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` if `self ==\nMIN`.",323,null],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",323,null],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",323,null],[11,"checked_abs","","Checked absolute value. Computes `self.abs()`, returning `None` if\n`self == MIN`.",323,null],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",323,null],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",323,null],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",323,null],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",323,null],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",323,null],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",323,null],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`,\nwrapping around at the boundary of the type.",323,null],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`,\nwrapping around at the boundary of the type.",323,null],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",323,null],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",323,null],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",323,null],[11,"wrapping_abs","","Wrapping (modular) absolute value. Computes `self.abs()`,\nwrapping around at the boundary of the type.",323,null],[11,"overflowing_add","","Calculates `self` + `rhs`",323,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",323,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",323,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",323,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",323,null],[11,"overflowing_neg","","Negates self, overflowing if this is equal to the minimum value.",323,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",323,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",323,null],[11,"overflowing_abs","","Computes the absolute value of `self`.",323,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",323,null],[11,"abs","","Computes the absolute value of `self`.",323,null],[11,"signum","","Returns a number representing sign of `self`.",323,null],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number\nis zero or negative.",323,null],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number\nis zero or positive.",323,null],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",324,{"inputs":[],"output":{"name":"i64"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",324,{"inputs":[],"output":{"name":"i64"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",324,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",324,null],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",324,null],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",324,null],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",324,null],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",324,null],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",324,null],[11,"swap_bytes","","Reverses the byte order of the integer.",324,null],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",324,{"inputs":[{"name":"i64"}],"output":{"name":"i64"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",324,{"inputs":[{"name":"i64"}],"output":{"name":"i64"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",324,null],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",324,null],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",324,null],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",324,null],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",324,null],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",324,null],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",324,null],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` if `self ==\nMIN`.",324,null],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",324,null],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",324,null],[11,"checked_abs","","Checked absolute value. Computes `self.abs()`, returning `None` if\n`self == MIN`.",324,null],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",324,null],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",324,null],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",324,null],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",324,null],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",324,null],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",324,null],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`,\nwrapping around at the boundary of the type.",324,null],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`,\nwrapping around at the boundary of the type.",324,null],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",324,null],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",324,null],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",324,null],[11,"wrapping_abs","","Wrapping (modular) absolute value. Computes `self.abs()`,\nwrapping around at the boundary of the type.",324,null],[11,"overflowing_add","","Calculates `self` + `rhs`",324,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",324,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",324,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",324,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",324,null],[11,"overflowing_neg","","Negates self, overflowing if this is equal to the minimum value.",324,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",324,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",324,null],[11,"overflowing_abs","","Computes the absolute value of `self`.",324,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",324,null],[11,"abs","","Computes the absolute value of `self`.",324,null],[11,"signum","","Returns a number representing sign of `self`.",324,null],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the number\nis zero or negative.",324,null],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the number\nis zero or positive.",324,null],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",315,{"inputs":[],"output":{"name":"usize"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",315,{"inputs":[],"output":{"name":"usize"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",315,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",315,null],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",315,null],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",315,null],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",315,null],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",315,null],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",315,null],[11,"swap_bytes","","Reverses the byte order of the integer.",315,null],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",315,{"inputs":[{"name":"usize"}],"output":{"name":"usize"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",315,{"inputs":[{"name":"usize"}],"output":{"name":"usize"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",315,null],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",315,null],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",315,null],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",315,null],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",315,null],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",315,null],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",315,null],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` unless `self ==\n0`.",315,null],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",315,null],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",315,null],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",315,null],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",315,null],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",315,null],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",315,null],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",315,null],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",315,null],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`.\nWrapped division on unsigned types is just normal division.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",315,null],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`.\nWrapped remainder calculation on unsigned types is\njust the regular remainder calculation.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",315,null],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",315,null],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",315,null],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",315,null],[11,"overflowing_add","","Calculates `self` + `rhs`",315,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",315,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",315,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",315,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",315,null],[11,"overflowing_neg","","Negates self in an overflowing fashion.",315,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",315,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",315,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",315,null],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",315,null],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.\nUnspecified behavior on overflow.",315,null],[11,"checked_next_power_of_two","","Returns the smallest power of two greater than or equal to `n`. If\nthe next power of two is greater than the type&#39;s maximum value,\n`None` is returned, otherwise the power of two is wrapped in `Some`.",315,null],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",316,{"inputs":[],"output":{"name":"u8"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",316,{"inputs":[],"output":{"name":"u8"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",316,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",316,null],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",316,null],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",316,null],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",316,null],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",316,null],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",316,null],[11,"swap_bytes","","Reverses the byte order of the integer.",316,null],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",316,{"inputs":[{"name":"u8"}],"output":{"name":"u8"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",316,{"inputs":[{"name":"u8"}],"output":{"name":"u8"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",316,null],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",316,null],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",316,null],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",316,null],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",316,null],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",316,null],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",316,null],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` unless `self ==\n0`.",316,null],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",316,null],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",316,null],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",316,null],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",316,null],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",316,null],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",316,null],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",316,null],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",316,null],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`.\nWrapped division on unsigned types is just normal division.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",316,null],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`.\nWrapped remainder calculation on unsigned types is\njust the regular remainder calculation.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",316,null],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",316,null],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",316,null],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",316,null],[11,"overflowing_add","","Calculates `self` + `rhs`",316,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",316,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",316,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",316,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",316,null],[11,"overflowing_neg","","Negates self in an overflowing fashion.",316,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",316,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",316,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",316,null],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",316,null],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.\nUnspecified behavior on overflow.",316,null],[11,"checked_next_power_of_two","","Returns the smallest power of two greater than or equal to `n`. If\nthe next power of two is greater than the type&#39;s maximum value,\n`None` is returned, otherwise the power of two is wrapped in `Some`.",316,null],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",317,{"inputs":[],"output":{"name":"u16"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",317,{"inputs":[],"output":{"name":"u16"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",317,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",317,null],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",317,null],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",317,null],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",317,null],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",317,null],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",317,null],[11,"swap_bytes","","Reverses the byte order of the integer.",317,null],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",317,{"inputs":[{"name":"u16"}],"output":{"name":"u16"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",317,{"inputs":[{"name":"u16"}],"output":{"name":"u16"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",317,null],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",317,null],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",317,null],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",317,null],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",317,null],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",317,null],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",317,null],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` unless `self ==\n0`.",317,null],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",317,null],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",317,null],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",317,null],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",317,null],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",317,null],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",317,null],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",317,null],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",317,null],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`.\nWrapped division on unsigned types is just normal division.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",317,null],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`.\nWrapped remainder calculation on unsigned types is\njust the regular remainder calculation.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",317,null],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",317,null],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",317,null],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",317,null],[11,"overflowing_add","","Calculates `self` + `rhs`",317,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",317,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",317,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",317,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",317,null],[11,"overflowing_neg","","Negates self in an overflowing fashion.",317,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",317,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",317,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",317,null],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",317,null],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.\nUnspecified behavior on overflow.",317,null],[11,"checked_next_power_of_two","","Returns the smallest power of two greater than or equal to `n`. If\nthe next power of two is greater than the type&#39;s maximum value,\n`None` is returned, otherwise the power of two is wrapped in `Some`.",317,null],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",318,{"inputs":[],"output":{"name":"u32"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",318,{"inputs":[],"output":{"name":"u32"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",318,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",318,null],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",318,null],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",318,null],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",318,null],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",318,null],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",318,null],[11,"swap_bytes","","Reverses the byte order of the integer.",318,null],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",318,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",318,{"inputs":[{"name":"u32"}],"output":{"name":"u32"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",318,null],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",318,null],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",318,null],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",318,null],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",318,null],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",318,null],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",318,null],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` unless `self ==\n0`.",318,null],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",318,null],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",318,null],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",318,null],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",318,null],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",318,null],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",318,null],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",318,null],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",318,null],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`.\nWrapped division on unsigned types is just normal division.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",318,null],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`.\nWrapped remainder calculation on unsigned types is\njust the regular remainder calculation.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",318,null],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",318,null],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",318,null],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",318,null],[11,"overflowing_add","","Calculates `self` + `rhs`",318,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",318,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",318,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",318,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",318,null],[11,"overflowing_neg","","Negates self in an overflowing fashion.",318,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",318,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",318,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",318,null],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",318,null],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.\nUnspecified behavior on overflow.",318,null],[11,"checked_next_power_of_two","","Returns the smallest power of two greater than or equal to `n`. If\nthe next power of two is greater than the type&#39;s maximum value,\n`None` is returned, otherwise the power of two is wrapped in `Some`.",318,null],[11,"min_value","","Returns the smallest value that can be represented by this integer type.",319,{"inputs":[],"output":{"name":"u64"}}],[11,"max_value","","Returns the largest value that can be represented by this integer type.",319,{"inputs":[],"output":{"name":"u64"}}],[11,"from_str_radix","","Converts a string slice in a given base to an integer.",319,{"inputs":[{"name":"str"},{"name":"u32"}],"output":{"name":"result"}}],[11,"count_ones","","Returns the number of ones in the binary representation of `self`.",319,null],[11,"count_zeros","","Returns the number of zeros in the binary representation of `self`.",319,null],[11,"leading_zeros","","Returns the number of leading zeros in the binary representation\nof `self`.",319,null],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary representation\nof `self`.",319,null],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,\nwrapping the truncated bits to the end of the resulting integer.",319,null],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,\nwrapping the truncated bits to the beginning of the resulting\ninteger.",319,null],[11,"swap_bytes","","Reverses the byte order of the integer.",319,null],[11,"from_be","","Converts an integer from big endian to the target&#39;s endianness.",319,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[11,"from_le","","Converts an integer from little endian to the target&#39;s endianness.",319,{"inputs":[{"name":"u64"}],"output":{"name":"u64"}}],[11,"to_be","","Converts `self` to big endian from the target&#39;s endianness.",319,null],[11,"to_le","","Converts `self` to little endian from the target&#39;s endianness.",319,null],[11,"checked_add","","Checked integer addition. Computes `self + other`, returning `None`\nif overflow occurred.",319,null],[11,"checked_sub","","Checked integer subtraction. Computes `self - other`, returning\n`None` if underflow occurred.",319,null],[11,"checked_mul","","Checked integer multiplication. Computes `self * other`, returning\n`None` if underflow or overflow occurred.",319,null],[11,"checked_div","","Checked integer division. Computes `self / other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",319,null],[11,"checked_rem","","Checked integer remainder. Computes `self % other`, returning `None`\nif `other == 0` or the operation results in underflow or overflow.",319,null],[11,"checked_neg","","Checked negation. Computes `-self`, returning `None` unless `self ==\n0`.",319,null],[11,"checked_shl","","Checked shift left. Computes `self &lt;&lt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",319,null],[11,"checked_shr","","Checked shift right. Computes `self &gt;&gt; rhs`, returning `None`\nif `rhs` is larger than or equal to the number of bits in `self`.",319,null],[11,"saturating_add","","Saturating integer addition. Computes `self + other`, saturating at\nthe numeric bounds instead of overflowing.",319,null],[11,"saturating_sub","","Saturating integer subtraction. Computes `self - other`, saturating\nat the numeric bounds instead of overflowing.",319,null],[11,"saturating_mul","","Saturating integer multiplication. Computes `self * other`,\nsaturating at the numeric bounds instead of overflowing.",319,null],[11,"wrapping_add","","Wrapping (modular) addition. Computes `self + other`,\nwrapping around at the boundary of the type.",319,null],[11,"wrapping_sub","","Wrapping (modular) subtraction. Computes `self - other`,\nwrapping around at the boundary of the type.",319,null],[11,"wrapping_mul","","Wrapping (modular) multiplication. Computes `self *\nother`, wrapping around at the boundary of the type.",319,null],[11,"wrapping_div","","Wrapping (modular) division. Computes `self / other`.\nWrapped division on unsigned types is just normal division.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",319,null],[11,"wrapping_rem","","Wrapping (modular) remainder. Computes `self % other`.\nWrapped remainder calculation on unsigned types is\njust the regular remainder calculation.\nThere&#39;s no way wrapping could ever happen.\nThis function exists, so that all operations\nare accounted for in the wrapping operations.",319,null],[11,"wrapping_neg","","Wrapping (modular) negation. Computes `-self`,\nwrapping around at the boundary of the type.",319,null],[11,"wrapping_shl","","Panic-free bitwise shift-left; yields `self &lt;&lt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",319,null],[11,"wrapping_shr","","Panic-free bitwise shift-right; yields `self &gt;&gt; mask(rhs)`,\nwhere `mask` removes any high-order bits of `rhs` that\nwould cause the shift to exceed the bitwidth of the type.",319,null],[11,"overflowing_add","","Calculates `self` + `rhs`",319,null],[11,"overflowing_sub","","Calculates `self` - `rhs`",319,null],[11,"overflowing_mul","","Calculates the multiplication of `self` and `rhs`.",319,null],[11,"overflowing_div","","Calculates the divisor when `self` is divided by `rhs`.",319,null],[11,"overflowing_rem","","Calculates the remainder when `self` is divided by `rhs`.",319,null],[11,"overflowing_neg","","Negates self in an overflowing fashion.",319,null],[11,"overflowing_shl","","Shifts self left by `rhs` bits.",319,null],[11,"overflowing_shr","","Shifts self right by `rhs` bits.",319,null],[11,"pow","","Raises self to the power of `exp`, using exponentiation by squaring.",319,null],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",319,null],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to `self`.\nUnspecified behavior on overflow.",319,null],[11,"checked_next_power_of_two","","Returns the smallest power of two greater than or equal to `n`. If\nthe next power of two is greater than the type&#39;s maximum value,\n`None` is returned, otherwise the power of two is wrapped in `Some`.",319,null],[11,"is_digit","","Checks if a `char` is a digit in the given radix.",332,null],[11,"to_digit","","Converts a `char` to a digit in the given radix.",332,null],[11,"escape_unicode","","Returns an iterator that yields the hexadecimal Unicode escape of a\ncharacter, as `char`s.",332,null],[11,"escape_debug","","Returns an iterator that yields the literal escape code of a `char`.",332,null],[11,"escape_default","","Returns an iterator that yields the literal escape code of a `char`.",332,null],[11,"len_utf8","","Returns the number of bytes this `char` would need if encoded in UTF-8.",332,null],[11,"len_utf16","","Returns the number of 16-bit code units this `char` would need if\nencoded in UTF-16.",332,null],[11,"encode_utf8","","Encodes this character as UTF-8 into the provided byte buffer,\nand then returns the subslice of the buffer that contains the encoded character.",332,null],[11,"encode_utf16","","Encodes this character as UTF-16 into the provided `u16` buffer,\nand then returns the subslice of the buffer that contains the encoded character.",332,null],[11,"is_alphabetic","","Returns true if this `char` is an alphabetic code point, and false if not.",332,null],[11,"is_xid_start","","Returns true if this `char` satisfies the &#39;XID_Start&#39; Unicode property, and false\notherwise.",332,null],[11,"is_xid_continue","","Returns true if this `char` satisfies the &#39;XID_Continue&#39; Unicode property, and false\notherwise.",332,null],[11,"is_lowercase","","Returns true if this `char` is lowercase, and false otherwise.",332,null],[11,"is_uppercase","","Returns true if this `char` is uppercase, and false otherwise.",332,null],[11,"is_whitespace","","Returns true if this `char` is whitespace, and false otherwise.",332,null],[11,"is_alphanumeric","","Returns true if this `char` is alphanumeric, and false otherwise.",332,null],[11,"is_control","","Returns true if this `char` is a control code point, and false otherwise.",332,null],[11,"is_numeric","","Returns true if this `char` is numeric, and false otherwise.",332,null],[11,"to_lowercase","","Returns an iterator that yields the lowercase equivalent of a `char`.",332,null],[11,"to_uppercase","","Returns an iterator that yields the uppercase equivalent of a `char`.",332,null],[11,"is_null","","Returns true if the pointer is null.",325,null],[11,"as_ref","","Returns `None` if the pointer is null, or else returns a reference to\nthe value wrapped in `Some`.",325,null],[11,"offset","","Calculates the offset from a pointer. `count` is in units of T; e.g. a\n`count` of 3 represents a pointer offset of `3 * sizeof::&lt;T&gt;()` bytes.",325,null],[11,"wrapping_offset","","Calculates the offset from a pointer using wrapping arithmetic.\n`count` is in units of T; e.g. a `count` of 3 represents a pointer\noffset of `3 * sizeof::&lt;T&gt;()` bytes.",325,null],[11,"as_mut","","Returns `None` if the pointer is null, or else returns a mutable\nreference to the value wrapped in `Some`.",325,null],[11,"of","std::any","Returns the `TypeId` of the type this generic function has been\ninstantiated with.",390,{"inputs":[],"output":{"name":"typeid"}}],[11,"new","std::cell","Creates a new `Cell` containing the given value.",327,{"inputs":[{"name":"t"}],"output":{"name":"cell"}}],[11,"get","","Returns a copy of the contained value.",327,null],[11,"set","","Sets the contained value.",327,null],[11,"as_unsafe_cell","","Returns a reference to the underlying `UnsafeCell`.",327,null],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",327,null],[11,"get_mut","","Returns a mutable reference to the underlying data.",327,null],[11,"new","","Creates a new `RefCell` containing `value`.",328,{"inputs":[{"name":"t"}],"output":{"name":"refcell"}}],[11,"into_inner","","Consumes the `RefCell`, returning the wrapped value.",328,null],[11,"borrow_state","","Query the current state of this `RefCell`",328,null],[11,"borrow","","Immutably borrows the wrapped value.",328,null],[11,"try_borrow","","Immutably borrows the wrapped value, returning an error if the value is currently mutably\nborrowed.",328,null],[11,"borrow_mut","","Mutably borrows the wrapped value.",328,null],[11,"try_borrow_mut","","Mutably borrows the wrapped value, returning an error if the value is currently borrowed.",328,null],[11,"as_unsafe_cell","","Returns a reference to the underlying `UnsafeCell`.",328,null],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",328,null],[11,"get_mut","","Returns a mutable reference to the underlying data.",328,null],[11,"clone","","Copies a `Ref`.",383,{"inputs":[{"name":"ref"}],"output":{"name":"ref"}}],[11,"map","","Make a new `Ref` for a component of the borrowed data.",383,{"inputs":[{"name":"ref"},{"name":"f"}],"output":{"name":"ref"}}],[11,"map","","Make a new `RefMut` for a component of the borrowed data, e.g. an enum\nvariant.",384,{"inputs":[{"name":"refmut"},{"name":"f"}],"output":{"name":"refmut"}}],[11,"new","","Constructs a new instance of `UnsafeCell` which will wrap the specified\nvalue.",385,{"inputs":[{"name":"t"}],"output":{"name":"unsafecell"}}],[11,"into_inner","","Unwraps the value.",385,null],[11,"get","","Gets a mutable pointer to the wrapped value.",385,null],[11,"reverse","std::cmp","Reverse the `Ordering`.",4,null],[11,"then","","Chains two orderings.",4,null],[11,"then_with","","Chains the ordering with the given function.",4,null],[11,"new","std::hash","Creates a new `SipHasher` with the two initial keys set to 0.",391,{"inputs":[],"output":{"name":"siphasher"}}],[11,"new_with_keys","","Creates a `SipHasher` that is keyed off the provided keys.",391,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"siphasher"}}],[11,"new","","Creates a new `SipHasher24` with the two initial keys set to 0.",393,{"inputs":[],"output":{"name":"siphasher24"}}],[11,"new_with_keys","","Creates a `SipHasher24` that is keyed off the provided keys.",393,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"siphasher24"}}],[11,"new","","Creates a new `SipHasher13` with the two initial keys set to 0.",392,{"inputs":[],"output":{"name":"siphasher13"}}],[11,"new_with_keys","","Creates a `SipHasher13` that is keyed off the provided keys.",392,{"inputs":[{"name":"u64"},{"name":"u64"}],"output":{"name":"siphasher13"}}],[11,"peek","std::iter","Returns a reference to the next() value without advancing the iterator.",400,null],[11,"contains","std::ops","# Examples",51,null],[11,"step_by","","Creates an iterator with the same range, but stepping by the\ngiven amount at each iteration.",51,null],[11,"contains","","# Examples",52,null],[11,"step_by","","Creates an iterator starting at the same point, but stepping by\nthe given amount at each iteration.",52,null],[11,"contains","","# Examples",53,null],[11,"contains","","# Examples",54,null],[11,"step_by","","Creates an iterator with the same range, but stepping by the\ngiven amount at each iteration.",54,null],[11,"contains","","# Examples",55,null],[11,"new","std::ptr","Creates a new `Unique`.",381,null],[11,"get","","Dereferences the content.",381,null],[11,"get_mut","","Mutably dereferences the content.",381,null],[11,"new","","Creates a new `Shared`.",382,null],[11,"is_ok","std::result","Returns true if the result is `Ok`.",68,null],[11,"is_err","","Returns true if the result is `Err`.",68,null],[11,"ok","","Converts from `Result&lt;T, E&gt;` to [`Option&lt;T&gt;`].",68,null],[11,"err","","Converts from `Result&lt;T, E&gt;` to [`Option&lt;E&gt;`].",68,null],[11,"as_ref","","Converts from `Result&lt;T, E&gt;` to `Result&lt;&amp;T, &amp;E&gt;`.",68,null],[11,"as_mut","","Converts from `Result&lt;T, E&gt;` to `Result&lt;&amp;mut T, &amp;mut E&gt;`.",68,null],[11,"map","","Maps a `Result&lt;T, E&gt;` to `Result&lt;U, E&gt;` by applying a function to a\ncontained `Ok` value, leaving an `Err` value untouched.",68,null],[11,"map_err","","Maps a `Result&lt;T, E&gt;` to `Result&lt;T, F&gt;` by applying a function to a\ncontained `Err` value, leaving an `Ok` value untouched.",68,null],[11,"iter","","Returns an iterator over the possibly contained value.",68,null],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",68,null],[11,"and","","Returns `res` if the result is `Ok`, otherwise returns the `Err` value of `self`.",68,null],[11,"and_then","","Calls `op` if the result is `Ok`, otherwise returns the `Err` value of `self`.",68,null],[11,"or","","Returns `res` if the result is `Err`, otherwise returns the `Ok` value of `self`.",68,null],[11,"or_else","","Calls `op` if the result is `Err`, otherwise returns the `Ok` value of `self`.",68,null],[11,"unwrap_or","","Unwraps a result, yielding the content of an `Ok`.\nElse, it returns `optb`.",68,null],[11,"unwrap_or_else","","Unwraps a result, yielding the content of an `Ok`.\nIf the value is an `Err` then it calls `op` with its value.",68,null],[11,"unwrap","","Unwraps a result, yielding the content of an `Ok`.",68,null],[11,"expect","","Unwraps a result, yielding the content of an `Ok`.",68,null],[11,"unwrap_err","","Unwraps a result, yielding the content of an `Err`.",68,null],[11,"unwrap_or_default","","Returns the contained value or a default",68,null],[11,"is_some","std::option","Returns `true` if the option is a `Some` value.",69,null],[11,"is_none","","Returns `true` if the option is a `None` value.",69,null],[11,"as_ref","","Converts from `Option&lt;T&gt;` to `Option&lt;&amp;T&gt;`.",69,null],[11,"as_mut","","Converts from `Option&lt;T&gt;` to `Option&lt;&amp;mut T&gt;`.",69,null],[11,"expect","","Unwraps an option, yielding the content of a `Some`.",69,null],[11,"unwrap","","Moves the value `v` out of the `Option&lt;T&gt;` if it is `Some(v)`.",69,null],[11,"unwrap_or","","Returns the contained value or a default.",69,null],[11,"unwrap_or_else","","Returns the contained value or computes it from a closure.",69,null],[11,"map","","Maps an `Option&lt;T&gt;` to `Option&lt;U&gt;` by applying a function to a contained value.",69,null],[11,"map_or","","Applies a function to the contained value (if any),\nor returns a `default` (if not).",69,null],[11,"map_or_else","","Applies a function to the contained value (if any),\nor computes a `default` (if not).",69,null],[11,"ok_or","","Transforms the `Option&lt;T&gt;` into a [`Result&lt;T, E&gt;`], mapping `Some(v)` to\n[`Ok(v)`] and `None` to [`Err(err)`][Err].",69,null],[11,"ok_or_else","","Transforms the `Option&lt;T&gt;` into a [`Result&lt;T, E&gt;`], mapping `Some(v)` to\n[`Ok(v)`] and `None` to [`Err(err())`][Err].",69,null],[11,"iter","","Returns an iterator over the possibly contained value.",69,null],[11,"iter_mut","","Returns a mutable iterator over the possibly contained value.",69,null],[11,"and","","Returns `None` if the option is `None`, otherwise returns `optb`.",69,null],[11,"and_then","","Returns `None` if the option is `None`, otherwise calls `f` with the\nwrapped value and returns the result.",69,null],[11,"or","","Returns the option if it contains a value, otherwise returns `optb`.",69,null],[11,"or_else","","Returns the option if it contains a value, otherwise calls `f` and\nreturns the result.",69,null],[11,"take","","Takes the value out of the option, leaving a `None` in its place.",69,null],[11,"cloned","","Maps an `Option&lt;&amp;T&gt;` to an `Option&lt;T&gt;` by cloning the contents of the\noption.",69,null],[11,"unwrap_or_default","","Returns the contained value or a default",69,null],[11,"new","std::boxed","Allocates memory on the heap and then places `x` into it.",115,{"inputs":[{"name":"t"}],"output":{"name":"box"}}],[11,"from_raw","","Constructs a box from a raw pointer.",115,null],[11,"into_raw","","Consumes the `Box`, returning the wrapped raw pointer.",115,null],[11,"downcast","","Attempt to downcast the box to a concrete type.",115,null],[11,"downcast","","Attempt to downcast the box to a concrete type.",115,null],[11,"new","std::rc","Constructs a new `Rc&lt;T&gt;`.",264,{"inputs":[{"name":"t"}],"output":{"name":"rc"}}],[11,"try_unwrap","","Returns the contained value, if the `Rc` has exactly one strong reference.",264,{"inputs":[{"name":"rc"}],"output":{"name":"result"}}],[11,"would_unwrap","","Checks whether [`Rc::try_unwrap`][try_unwrap] would return\n[`Ok`].",264,{"inputs":[{"name":"rc"}],"output":{"name":"bool"}}],[11,"into_raw","","Consumes the `Rc`, returning the wrapped pointer.",264,null],[11,"from_raw","","Constructs an `Rc` from a raw pointer.",264,null],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",264,{"inputs":[{"name":"rc"}],"output":{"name":"weak"}}],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",264,{"inputs":[{"name":"rc"}],"output":{"name":"usize"}}],[11,"strong_count","","Gets the number of strong (`Rc`) pointers to this value.",264,{"inputs":[{"name":"rc"}],"output":{"name":"usize"}}],[11,"is_unique","","Returns true if there are no other `Rc` or [`Weak`][weak] pointers to\nthis inner value.",264,{"inputs":[{"name":"rc"}],"output":{"name":"bool"}}],[11,"get_mut","","Returns a mutable reference to the inner value, if there are\nno other `Rc` or [`Weak`][weak] pointers to the same value.",264,{"inputs":[{"name":"rc"}],"output":{"name":"option"}}],[11,"ptr_eq","","Returns true if the two `Rc`s point to the same value (not\njust values that compare as equal).",264,{"inputs":[{"name":"rc"},{"name":"rc"}],"output":{"name":"bool"}}],[11,"make_mut","","Makes a mutable reference into the given `Rc`.",264,{"inputs":[{"name":"rc"}],"output":{"name":"t"}}],[11,"new","","Constructs a new `Weak&lt;T&gt;`, without an accompanying instance of `T`.",267,{"inputs":[],"output":{"name":"weak"}}],[11,"upgrade","","Upgrades the `Weak` pointer to an [`Rc`][rc], if possible.",267,null],[11,"to_mut","std::borrow","Acquires a mutable reference to the owned form of the data.",72,null],[11,"into_owned","","Extracts the owned data.",72,null],[11,"entry","std::fmt","Adds a new entry to the set output.",425,null],[11,"entries","","Adds the contents of an iterator of entries to the set output.",425,null],[11,"finish","","Finishes output and returns any error encountered.",425,null],[11,"field","","Adds a new field to the generated struct output.",426,null],[11,"finish","","Finishes output and returns any error encountered.",426,null],[11,"field","","Adds a new field to the generated tuple struct output.",427,null],[11,"finish","","Finishes output and returns any error encountered.",427,null],[11,"pad_integral","","Performs the correct padding for an integer which has already been\nemitted into a str. The str should *not* contain the sign for the\ninteger, that will be added by this method.",334,null],[11,"pad","","This function takes a string slice and emits it to the internal buffer\nafter applying the relevant formatting flags specified. The flags\nrecognized for generic strings are:",334,null],[11,"write_str","","Writes some data to the underlying buffer contained within this\nformatter.",334,null],[11,"write_fmt","","Writes some formatted information into this instance",334,null],[11,"flags","","Flags for formatting (packed version of rt::Flag)",334,null],[11,"fill","","Character used as &#39;fill&#39; whenever there is alignment",334,null],[11,"align","","Flag indicating what form of alignment was requested",334,null],[11,"width","","Optionally specified integer width that the output should be",334,null],[11,"precision","","Optionally specified precision for numeric types",334,null],[11,"sign_plus","","Determines if the `+` flag was specified.",334,null],[11,"sign_minus","","Determines if the `-` flag was specified.",334,null],[11,"alternate","","Determines if the `#` flag was specified.",334,null],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",334,null],[11,"debug_struct","","Creates a `DebugStruct` builder designed to assist with creation of\n`fmt::Debug` implementations for structs.",334,null],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with creation of\n`fmt::Debug` implementations for tuple structs.",334,null],[11,"debug_list","","Creates a `DebugList` builder designed to assist with creation of\n`fmt::Debug` implementations for list-like structures.",334,null],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with creation of\n`fmt::Debug` implementations for set-like structures.",334,null],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with creation of\n`fmt::Debug` implementations for map-like structures.",334,null],[11,"entry","","Adds a new entry to the list output.",428,null],[11,"entries","","Adds the contents of an iterator of entries to the list output.",428,null],[11,"finish","","Finishes output and returns any error encountered.",428,null],[11,"entry","","Adds a new entry to the map output.",429,null],[11,"entries","","Adds the contents of an iterator of entries to the map output.",429,null],[11,"finish","","Finishes output and returns any error encountered.",429,null],[11,"as_slice","std::slice","View the underlying data as a subslice of the original data.",371,null],[11,"into_slice","","View the underlying data as a subslice of the original data.",372,null],[11,"as_str","std::str","View the underlying data as a subslice of the original data.",366,null],[11,"as_str","","View the underlying data as a subslice of the original data.",367,null],[11,"valid_up_to","","Returns the index in the given string up to which valid UTF-8 was\nverified.",117,null],[11,"new","std::string","Creates a new empty `String`.",134,{"inputs":[],"output":{"name":"string"}}],[11,"with_capacity","","Creates a new empty `String` with a particular capacity.",134,{"inputs":[{"name":"usize"}],"output":{"name":"string"}}],[11,"from_utf8","","Converts a vector of bytes to a `String`.",134,{"inputs":[{"name":"vec"}],"output":{"name":"result"}}],[11,"from_utf8_lossy","","Converts a slice of bytes to a string, including invalid characters.",134,null],[11,"from_utf16","","Decode a UTF-16 encoded vector `v` into a `String`, returning `Err`\nif `v` contains any invalid data.",134,null],[11,"from_utf16_lossy","","Decode a UTF-16 encoded vector `v` into a string, replacing\ninvalid data with the replacement character (U+FFFD).",134,null],[11,"from_raw_parts","","Creates a new `String` from a length, capacity, and pointer.",134,null],[11,"from_utf8_unchecked","","Converts a vector of bytes to a `String` without checking that the\nstring contains valid UTF-8.",134,{"inputs":[{"name":"vec"}],"output":{"name":"string"}}],[11,"into_bytes","","Converts a `String` into a byte vector.",134,null],[11,"as_str","","Extracts a string slice containing the entire string.",134,null],[11,"as_mut_str","","Extracts a string slice containing the entire string.",134,null],[11,"push_str","","Appends a given string slice onto the end of this `String`.",134,null],[11,"capacity","","Returns this `String`&#39;s capacity, in bytes.",134,null],[11,"reserve","","Ensures that this `String`&#39;s capacity is at least `additional` bytes\nlarger than its length.",134,null],[11,"reserve_exact","","Ensures that this `String`&#39;s capacity is `additional` bytes\nlarger than its length.",134,null],[11,"shrink_to_fit","","Shrinks the capacity of this `String` to match its length.",134,null],[11,"push","","Appends the given `char` to the end of this `String`.",134,null],[11,"as_bytes","","Returns a byte slice of this `String`&#39;s contents.",134,null],[11,"truncate","","Shortens this `String` to the specified length.",134,null],[11,"pop","","Removes the last character from the string buffer and returns it.",134,null],[11,"remove","","Removes a `char` from this `String` at a byte position and returns it.",134,null],[11,"insert","","Inserts a character into this `String` at a byte position.",134,null],[11,"insert_str","","Inserts a string slice into this `String` at a byte position.",134,null],[11,"as_mut_vec","","Returns a mutable reference to the contents of this `String`.",134,null],[11,"len","","Returns the length of this `String`, in bytes.",134,null],[11,"is_empty","","Returns `true` if this `String` has a length of zero.",134,null],[11,"split_off","","Divide one string into two at an index.",134,null],[11,"clear","","Truncates this `String`, removing all contents.",134,null],[11,"drain","","Create a draining iterator that removes the specified range in the string\nand yields the removed chars.",134,null],[11,"into_boxed_str","","Converts this `String` into a `Box&lt;str&gt;`.",134,null],[11,"into_bytes","","Returns the bytes that were attempted to convert to a `String`.",118,null],[11,"utf8_error","","Fetch a `Utf8Error` to get more details about the conversion failure.",118,null],[11,"new","std::vec","Constructs a new, empty `Vec&lt;T&gt;`.",131,{"inputs":[],"output":{"name":"vec"}}],[11,"with_capacity","","Constructs a new, empty `Vec&lt;T&gt;` with the specified capacity.",131,{"inputs":[{"name":"usize"}],"output":{"name":"vec"}}],[11,"from_raw_parts","","Creates a `Vec&lt;T&gt;` directly from the raw components of another vector.",131,null],[11,"capacity","","Returns the number of elements the vector can hold without\nreallocating.",131,null],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted\nin the given `Vec&lt;T&gt;`. The collection may reserve more space to avoid\nfrequent reallocations.",131,null],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to\nbe inserted in the given `Vec&lt;T&gt;`. Does nothing if the capacity is already\nsufficient.",131,null],[11,"shrink_to_fit","","Shrinks the capacity of the vector as much as possible.",131,null],[11,"into_boxed_slice","","Converts the vector into [`Box&lt;[T]&gt;`][owned slice].",131,null],[11,"truncate","","Shortens the vector, keeping the first `len` elements and dropping\nthe rest.",131,null],[11,"as_slice","","Extracts a slice containing the entire vector.",131,null],[11,"as_mut_slice","","Extracts a mutable slice of the entire vector.",131,null],[11,"set_len","","Sets the length of a vector.",131,null],[11,"swap_remove","","Removes an element from anywhere in the vector and return it, replacing\nit with the last element.",131,null],[11,"insert","","Inserts an element at position `index` within the vector, shifting all\nelements after it to the right.",131,null],[11,"remove","","Removes and returns the element at position `index` within the vector,\nshifting all elements after it to the left.",131,null],[11,"retain","","Retains only the elements specified by the predicate.",131,null],[11,"dedup_by_key","","Removes consecutive elements in the vector that resolve to the same key.",131,null],[11,"dedup_by","","Removes consecutive elements in the vector that resolve to the same key.",131,null],[11,"push","","Appends an element to the back of a collection.",131,null],[11,"pop","","Removes the last element from a vector and returns it, or [`None`] if it\nis empty.",131,null],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",131,null],[11,"drain","","Create a draining iterator that removes the specified range in the vector\nand yields the removed items.",131,null],[11,"clear","","Clears the vector, removing all values.",131,null],[11,"len","","Returns the number of elements in the vector.",131,null],[11,"is_empty","","Returns `true` if the vector contains no elements.",131,null],[11,"split_off","","Splits the collection into two at the given index.",131,null],[11,"resize","","Resizes the `Vec` in-place so that `len()` is equal to `new_len`.",131,null],[11,"extend_from_slice","","Clones and appends all elements in a slice to the `Vec`.",131,null],[11,"dedup","","Removes consecutive repeated elements in the vector.",131,null],[11,"as_slice","","Returns the remaining items of this iterator as a slice.",280,null],[11,"as_mut_slice","","Returns the remaining items of this iterator as a mutable slice.",280,null],[11,"unpaired_surrogate","std::char","Returns the unpaired surrogate which caused this error.",121,null],[11,"is_nan","std","Returns `true` if this value is `NaN` and false otherwise.",330,null],[11,"is_infinite","","Returns `true` if this value is positive infinity or negative infinity and\nfalse otherwise.",330,null],[11,"is_finite","","Returns `true` if this number is neither infinite nor `NaN`.",330,null],[11,"is_normal","","Returns `true` if the number is neither zero, infinite,\n[subnormal][subnormal], or `NaN`.",330,null],[11,"classify","","Returns the floating point category of the number. If only one property\nis going to be tested, it is generally faster to use the specific\npredicate instead.",330,null],[11,"integer_decode","","Returns the mantissa, base 2 exponent, and sign as integers, respectively.\nThe original number can be recovered by `sign * mantissa * 2 ^ exponent`.\nThe floating point encoding is documented in the [Reference][floating-point].",330,null],[11,"floor","","Returns the largest integer less than or equal to a number.",330,null],[11,"ceil","","Returns the smallest integer greater than or equal to a number.",330,null],[11,"round","","Returns the nearest integer to a number. Round half-way cases away from\n`0.0`.",330,null],[11,"trunc","","Returns the integer part of a number.",330,null],[11,"fract","","Returns the fractional part of a number.",330,null],[11,"abs","","Computes the absolute value of `self`. Returns `NAN` if the\nnumber is `NAN`.",330,null],[11,"signum","","Returns a number that represents the sign of `self`.",330,null],[11,"is_sign_positive","","Returns `true` if `self`&#39;s sign bit is positive, including\n`+0.0` and `INFINITY`.",330,null],[11,"is_sign_negative","","Returns `true` if `self`&#39;s sign is negative, including `-0.0`\nand `NEG_INFINITY`.",330,null],[11,"mul_add","","Fused multiply-add. Computes `(self * a) + b` with only one rounding\nerror. This produces a more accurate result with better performance than\na separate multiplication operation followed by an add.",330,null],[11,"recip","","Takes the reciprocal (inverse) of a number, `1/x`.",330,null],[11,"powi","","Raises a number to an integer power.",330,null],[11,"powf","","Raises a number to a floating point power.",330,null],[11,"sqrt","","Takes the square root of a number.",330,null],[11,"exp","","Returns `e^(self)`, (the exponential function).",330,null],[11,"exp2","","Returns `2^(self)`.",330,null],[11,"ln","","Returns the natural logarithm of the number.",330,null],[11,"log","","Returns the logarithm of the number with respect to an arbitrary base.",330,null],[11,"log2","","Returns the base 2 logarithm of the number.",330,null],[11,"log10","","Returns the base 10 logarithm of the number.",330,null],[11,"to_degrees","","Converts radians to degrees.",330,null],[11,"to_radians","","Converts degrees to radians.",330,null],[11,"ldexp","","Constructs a floating point number of `x*2^exp`.",330,{"inputs":[{"name":"f32"},{"name":"isize"}],"output":{"name":"f32"}}],[11,"frexp","","Breaks the number into a normalized fraction and a base-2 exponent,\nsatisfying:",330,null],[11,"next_after","","Returns the next representable floating-point value in the direction of\n`other`.",330,null],[11,"max","","Returns the maximum of the two numbers.",330,null],[11,"min","","Returns the minimum of the two numbers.",330,null],[11,"abs_sub","","The positive difference of two numbers.",330,null],[11,"cbrt","","Takes the cubic root of a number.",330,null],[11,"hypot","","Calculates the length of the hypotenuse of a right-angle triangle given\nlegs of length `x` and `y`.",330,null],[11,"sin","","Computes the sine of a number (in radians).",330,null],[11,"cos","","Computes the cosine of a number (in radians).",330,null],[11,"tan","","Computes the tangent of a number (in radians).",330,null],[11,"asin","","Computes the arcsine of a number. Return value is in radians in\nthe range [-pi/2, pi/2] or NaN if the number is outside the range\n[-1, 1].",330,null],[11,"acos","","Computes the arccosine of a number. Return value is in radians in\nthe range [0, pi] or NaN if the number is outside the range\n[-1, 1].",330,null],[11,"atan","","Computes the arctangent of a number. Return value is in radians in the\nrange [-pi/2, pi/2];",330,null],[11,"atan2","","Computes the four quadrant arctangent of `self` (`y`) and `other` (`x`).",330,null],[11,"sin_cos","","Simultaneously computes the sine and cosine of the number, `x`. Returns\n`(sin(x), cos(x))`.",330,null],[11,"exp_m1","","Returns `e^(self) - 1` in a way that is accurate even if the\nnumber is close to zero.",330,null],[11,"ln_1p","","Returns `ln(1+n)` (natural logarithm) more accurately than if\nthe operations were performed separately.",330,null],[11,"sinh","","Hyperbolic sine function.",330,null],[11,"cosh","","Hyperbolic cosine function.",330,null],[11,"tanh","","Hyperbolic tangent function.",330,null],[11,"asinh","","Inverse hyperbolic sine function.",330,null],[11,"acosh","","Inverse hyperbolic cosine function.",330,null],[11,"atanh","","Inverse hyperbolic tangent function.",330,null],[11,"is_nan","","Returns `true` if this value is `NaN` and false otherwise.",331,null],[11,"is_infinite","","Returns `true` if this value is positive infinity or negative infinity and\nfalse otherwise.",331,null],[11,"is_finite","","Returns `true` if this number is neither infinite nor `NaN`.",331,null],[11,"is_normal","","Returns `true` if the number is neither zero, infinite,\n[subnormal][subnormal], or `NaN`.",331,null],[11,"classify","","Returns the floating point category of the number. If only one property\nis going to be tested, it is generally faster to use the specific\npredicate instead.",331,null],[11,"integer_decode","","Returns the mantissa, base 2 exponent, and sign as integers, respectively.\nThe original number can be recovered by `sign * mantissa * 2 ^ exponent`.\nThe floating point encoding is documented in the [Reference][floating-point].",331,null],[11,"floor","","Returns the largest integer less than or equal to a number.",331,null],[11,"ceil","","Returns the smallest integer greater than or equal to a number.",331,null],[11,"round","","Returns the nearest integer to a number. Round half-way cases away from\n`0.0`.",331,null],[11,"trunc","","Returns the integer part of a number.",331,null],[11,"fract","","Returns the fractional part of a number.",331,null],[11,"abs","","Computes the absolute value of `self`. Returns `NAN` if the\nnumber is `NAN`.",331,null],[11,"signum","","Returns a number that represents the sign of `self`.",331,null],[11,"is_sign_positive","","Returns `true` if `self`&#39;s sign bit is positive, including\n`+0.0` and `INFINITY`.",331,null],[11,"is_positive","","",331,null],[11,"is_sign_negative","","Returns `true` if `self`&#39;s sign is negative, including `-0.0`\nand `NEG_INFINITY`.",331,null],[11,"is_negative","","",331,null],[11,"mul_add","","Fused multiply-add. Computes `(self * a) + b` with only one rounding\nerror. This produces a more accurate result with better performance than\na separate multiplication operation followed by an add.",331,null],[11,"recip","","Takes the reciprocal (inverse) of a number, `1/x`.",331,null],[11,"powi","","Raises a number to an integer power.",331,null],[11,"powf","","Raises a number to a floating point power.",331,null],[11,"sqrt","","Takes the square root of a number.",331,null],[11,"exp","","Returns `e^(self)`, (the exponential function).",331,null],[11,"exp2","","Returns `2^(self)`.",331,null],[11,"ln","","Returns the natural logarithm of the number.",331,null],[11,"log","","Returns the logarithm of the number with respect to an arbitrary base.",331,null],[11,"log2","","Returns the base 2 logarithm of the number.",331,null],[11,"log10","","Returns the base 10 logarithm of the number.",331,null],[11,"to_degrees","","Converts radians to degrees.",331,null],[11,"to_radians","","Converts degrees to radians.",331,null],[11,"ldexp","","Constructs a floating point number of `x*2^exp`.",331,{"inputs":[{"name":"f64"},{"name":"isize"}],"output":{"name":"f64"}}],[11,"frexp","","Breaks the number into a normalized fraction and a base-2 exponent,\nsatisfying:",331,null],[11,"next_after","","Returns the next representable floating-point value in the direction of\n`other`.",331,null],[11,"max","","Returns the maximum of the two numbers.",331,null],[11,"min","","Returns the minimum of the two numbers.",331,null],[11,"abs_sub","","The positive difference of two numbers.",331,null],[11,"cbrt","","Takes the cubic root of a number.",331,null],[11,"hypot","","Calculates the length of the hypotenuse of a right-angle triangle given\nlegs of length `x` and `y`.",331,null],[11,"sin","","Computes the sine of a number (in radians).",331,null],[11,"cos","","Computes the cosine of a number (in radians).",331,null],[11,"tan","","Computes the tangent of a number (in radians).",331,null],[11,"asin","","Computes the arcsine of a number. Return value is in radians in\nthe range [-pi/2, pi/2] or NaN if the number is outside the range\n[-1, 1].",331,null],[11,"acos","","Computes the arccosine of a number. Return value is in radians in\nthe range [0, pi] or NaN if the number is outside the range\n[-1, 1].",331,null],[11,"atan","","Computes the arctangent of a number. Return value is in radians in the\nrange [-pi/2, pi/2];",331,null],[11,"atan2","","Computes the four quadrant arctangent of `self` (`y`) and `other` (`x`).",331,null],[11,"sin_cos","","Simultaneously computes the sine and cosine of the number, `x`. Returns\n`(sin(x), cos(x))`.",331,null],[11,"exp_m1","","Returns `e^(self) - 1` in a way that is accurate even if the\nnumber is close to zero.",331,null],[11,"ln_1p","","Returns `ln(1+n)` (natural logarithm) more accurately than if\nthe operations were performed separately.",331,null],[11,"sinh","","Hyperbolic sine function.",331,null],[11,"cosh","","Hyperbolic cosine function.",331,null],[11,"tanh","","Hyperbolic tangent function.",331,null],[11,"asinh","","Inverse hyperbolic sine function.",331,null],[11,"acosh","","Inverse hyperbolic cosine function.",331,null],[11,"atanh","","Inverse hyperbolic tangent function.",331,null],[11,"is_ascii","","",270,null],[11,"to_ascii_uppercase","","",270,null],[11,"to_ascii_lowercase","","",270,null],[11,"eq_ignore_ascii_case","","",270,null],[11,"make_ascii_uppercase","","",270,null],[11,"make_ascii_lowercase","","",270,null],[11,"is_ascii","","",275,null],[11,"to_ascii_uppercase","","",275,null],[11,"to_ascii_lowercase","","",275,null],[11,"eq_ignore_ascii_case","","",275,null],[11,"make_ascii_uppercase","","",275,null],[11,"make_ascii_lowercase","","",275,null],[11,"is_ascii","","",316,null],[11,"to_ascii_uppercase","","",316,null],[11,"to_ascii_lowercase","","",316,null],[11,"eq_ignore_ascii_case","","",316,null],[11,"make_ascii_uppercase","","",316,null],[11,"make_ascii_lowercase","","",316,null],[11,"is_ascii","","",332,null],[11,"to_ascii_uppercase","","",332,null],[11,"to_ascii_lowercase","","",332,null],[11,"eq_ignore_ascii_case","","",332,null],[11,"make_ascii_uppercase","","",332,null],[11,"make_ascii_lowercase","","",332,null],[11,"new","std::collections::binary_heap","Creates an empty `BinaryHeap` as a max-heap.",284,{"inputs":[],"output":{"name":"binaryheap"}}],[11,"with_capacity","","Creates an empty `BinaryHeap` with a specific capacity.\nThis preallocates enough memory for `capacity` elements,\nso that the `BinaryHeap` does not have to be reallocated\nuntil it contains at least that many values.",284,{"inputs":[{"name":"usize"}],"output":{"name":"binaryheap"}}],[11,"iter","","Returns an iterator visiting all values in the underlying vector, in\narbitrary order.",284,null],[11,"peek","","Returns the greatest item in the binary heap, or `None` if it is empty.",284,null],[11,"peek_mut","","Returns a mutable reference to the greatest item in the binary heap, or\n`None` if it is empty.",284,null],[11,"capacity","","Returns the number of elements the binary heap can hold without reallocating.",284,null],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the\ngiven `BinaryHeap`. Does nothing if the capacity is already sufficient.",284,null],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the\n`BinaryHeap`. The collection may reserve more space to avoid frequent reallocations.",284,null],[11,"shrink_to_fit","","Discards as much additional capacity as possible.",284,null],[11,"pop","","Removes the greatest item from the binary heap and returns it, or `None` if it\nis empty.",284,null],[11,"push","","Pushes an item onto the binary heap.",284,null],[11,"push_pop","","Pushes an item onto the binary heap, then pops the greatest item off the queue in\nan optimized fashion.",284,null],[11,"replace","","Pops the greatest item off the binary heap, then pushes an item onto the queue in\nan optimized fashion. The push is done regardless of whether the binary heap\nwas empty.",284,null],[11,"into_vec","","Consumes the `BinaryHeap` and returns the underlying vector\nin arbitrary order.",284,null],[11,"into_sorted_vec","","Consumes the `BinaryHeap` and returns a vector in sorted\n(ascending) order.",284,null],[11,"len","","Returns the length of the binary heap.",284,null],[11,"is_empty","","Checks if the binary heap is empty.",284,null],[11,"drain","","Clears the binary heap, returning an iterator over the removed elements.",284,null],[11,"clear","","Drops all items from the binary heap.",284,null],[11,"append","","Moves all the elements of `other` into `self`, leaving `other` empty.",284,null],[11,"new","std::collections::btree_map","Makes a new empty BTreeMap with a reasonable choice for B.",276,{"inputs":[],"output":{"name":"btreemap"}}],[11,"clear","","Clears the map, removing all values.",276,null],[11,"get","","Returns a reference to the value corresponding to the key.",276,null],[11,"contains_key","","Returns true if the map contains a value for the specified key.",276,null],[11,"get_mut","","Returns a mutable reference to the value corresponding to the key.",276,null],[11,"insert","","Inserts a key-value pair into the map.",276,null],[11,"remove","","Removes a key from the map, returning the value at the key if the key\nwas previously in the map.",276,null],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",276,null],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the map, starting\nat min, and ending at max. If min is `Unbounded`, then it will be treated as &quot;negative\ninfinity&quot;, and if max is `Unbounded`, then it will be treated as &quot;positive infinity&quot;.\nThus range(Unbounded, Unbounded) will yield the whole collection.",276,null],[11,"range_mut","","Constructs a mutable double-ended iterator over a sub-range of elements in the map, starting\nat min, and ending at max. If min is `Unbounded`, then it will be treated as &quot;negative\ninfinity&quot;, and if max is `Unbounded`, then it will be treated as &quot;positive infinity&quot;.\nThus range(Unbounded, Unbounded) will yield the whole collection.",276,null],[11,"entry","","Gets the given key&#39;s corresponding entry in the map for in-place manipulation.",276,null],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key,\nincluding the key.",276,null],[11,"iter","","Gets an iterator over the entries of the map, sorted by key.",276,null],[11,"iter_mut","","Gets a mutable iterator over the entries of the map, sorted by key.",276,null],[11,"keys","","Gets an iterator over the keys of the map, in sorted order.",276,null],[11,"values","","Gets an iterator over the values of the map, in order by key.",276,null],[11,"values_mut","","Gets a mutable iterator over the values of the map, in order by key.",276,null],[11,"len","","Returns the number of elements in the map.",276,null],[11,"is_empty","","Returns true if the map contains no elements.",276,null],[11,"new","std::collections::btree_set","Makes a new BTreeSet with a reasonable choice of B.",308,{"inputs":[],"output":{"name":"btreeset"}}],[11,"iter","","Gets an iterator over the BTreeSet&#39;s contents.",308,null],[11,"range","","Constructs a double-ended iterator over a sub-range of elements in the set, starting\nat min, and ending at max. If min is `Unbounded`, then it will be treated as &quot;negative\ninfinity&quot;, and if max is `Unbounded`, then it will be treated as &quot;positive infinity&quot;.\nThus range(Unbounded, Unbounded) will yield the whole collection.",308,null],[11,"difference","","Visits the values representing the difference, in ascending order.",308,null],[11,"symmetric_difference","","Visits the values representing the symmetric difference, in ascending order.",308,null],[11,"intersection","","Visits the values representing the intersection, in ascending order.",308,null],[11,"union","","Visits the values representing the union, in ascending order.",308,null],[11,"len","","Returns the number of elements in the set.",308,null],[11,"is_empty","","Returns true if the set contains no elements.",308,null],[11,"clear","","Clears the set, removing all values.",308,null],[11,"contains","","Returns `true` if the set contains a value.",308,null],[11,"get","","Returns a reference to the value in the set, if any, that is equal to the given value.",308,null],[11,"is_disjoint","","Returns `true` if the set has no elements in common with `other`.\nThis is equivalent to checking for an empty intersection.",308,null],[11,"is_subset","","Returns `true` if the set is a subset of another.",308,null],[11,"is_superset","","Returns `true` if the set is a superset of another.",308,null],[11,"insert","","Adds a value to the set.",308,null],[11,"replace","","Adds a value to the set, replacing the existing value, if any, that is equal to the given\none. Returns the replaced value.",308,null],[11,"remove","","Removes a value from the set. Returns `true` if the value was\npresent in the set.",308,null],[11,"take","","Removes and returns the value in the set, if any, that is equal to the given one.",308,null],[11,"append","","Moves all elements from `other` into `Self`, leaving `other` empty.",308,null],[11,"split_off","","Splits the collection into two at the given key. Returns everything after the given key,\nincluding the key.",308,null],[11,"new","std::collections::linked_list","Creates an empty `LinkedList`.",278,{"inputs":[],"output":{"name":"linkedlist"}}],[11,"append","","Moves all elements from `other` to the end of the list.",278,null],[11,"iter","","Provides a forward iterator.",278,null],[11,"iter_mut","","Provides a forward iterator with mutable references.",278,null],[11,"is_empty","","Returns `true` if the `LinkedList` is empty.",278,null],[11,"len","","Returns the length of the `LinkedList`.",278,null],[11,"clear","","Removes all elements from the `LinkedList`.",278,null],[11,"contains","","Returns `true` if the `LinkedList` contains an element equal to the\ngiven value.",278,null],[11,"front","","Provides a reference to the front element, or `None` if the list is\nempty.",278,null],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the list\nis empty.",278,null],[11,"back","","Provides a reference to the back element, or `None` if the list is\nempty.",278,null],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the list\nis empty.",278,null],[11,"push_front","","Adds an element first in the list.",278,null],[11,"pop_front","","Removes the first element and returns it, or `None` if the list is\nempty.",278,null],[11,"push_back","","Appends an element to the back of a list",278,null],[11,"pop_back","","Removes the last element from a list and returns it, or `None` if\nit is empty.",278,null],[11,"split_off","","Splits the list into two at the given index. Returns everything after the given index,\nincluding the index.",278,null],[11,"front_place","","Returns a place for insertion at the front of the list.",278,null],[11,"back_place","","Returns a place for insertion at the back of the list.",278,null],[11,"new","std::collections::vec_deque","Creates an empty `VecDeque`.",282,{"inputs":[],"output":{"name":"vecdeque"}}],[11,"with_capacity","","Creates an empty `VecDeque` with space for at least `n` elements.",282,{"inputs":[{"name":"usize"}],"output":{"name":"vecdeque"}}],[11,"get","","Retrieves an element in the `VecDeque` by index.",282,null],[11,"get_mut","","Retrieves an element in the `VecDeque` mutably by index.",282,null],[11,"swap","","Swaps elements at indices `i` and `j`.",282,null],[11,"capacity","","Returns the number of elements the `VecDeque` can hold without\nreallocating.",282,null],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional` more elements to be inserted in the\ngiven `VecDeque`. Does nothing if the capacity is already sufficient.",282,null],[11,"reserve","","Reserves capacity for at least `additional` more elements to be inserted in the given\n`VecDeque`. The collection may reserve more space to avoid frequent reallocations.",282,null],[11,"shrink_to_fit","","Shrinks the capacity of the `VecDeque` as much as possible.",282,null],[11,"truncate","","Shortens a `VecDeque`, dropping excess elements from the back.",282,null],[11,"iter","","Returns a front-to-back iterator.",282,null],[11,"iter_mut","","Returns a front-to-back iterator that returns mutable references.",282,null],[11,"as_slices","","Returns a pair of slices which contain, in order, the contents of the\n`VecDeque`.",282,null],[11,"as_mut_slices","","Returns a pair of slices which contain, in order, the contents of the\n`VecDeque`.",282,null],[11,"len","","Returns the number of elements in the `VecDeque`.",282,null],[11,"is_empty","","Returns true if the buffer contains no elements",282,null],[11,"drain","","Create a draining iterator that removes the specified range in the\n`VecDeque` and yields the removed items.",282,null],[11,"clear","","Clears the buffer, removing all values.",282,null],[11,"contains","","Returns `true` if the `VecDeque` contains an element equal to the\ngiven value.",282,null],[11,"front","","Provides a reference to the front element, or `None` if the sequence is\nempty.",282,null],[11,"front_mut","","Provides a mutable reference to the front element, or `None` if the\nsequence is empty.",282,null],[11,"back","","Provides a reference to the back element, or `None` if the sequence is\nempty.",282,null],[11,"back_mut","","Provides a mutable reference to the back element, or `None` if the\nsequence is empty.",282,null],[11,"pop_front","","Removes the first element and returns it, or `None` if the sequence is\nempty.",282,null],[11,"push_front","","Inserts an element first in the sequence.",282,null],[11,"push_back","","Appends an element to the back of a buffer",282,null],[11,"pop_back","","Removes the last element from a buffer and returns it, or `None` if\nit is empty.",282,null],[11,"swap_remove_back","","Removes an element from anywhere in the `VecDeque` and returns it, replacing it with the\nlast element.",282,null],[11,"swap_remove_front","","Removes an element from anywhere in the `VecDeque` and returns it,\nreplacing it with the first element.",282,null],[11,"insert","","Inserts an element at `index` within the `VecDeque`. Whichever\nend is closer to the insertion point will be moved to make room,\nand all the affected elements will be moved to new positions.",282,null],[11,"remove","","Removes and returns the element at `index` from the `VecDeque`.\nWhichever end is closer to the removal point will be moved to make\nroom, and all the affected elements will be moved to new positions.\nReturns `None` if `index` is out of bounds.",282,null],[11,"split_off","","Splits the collection into two at the given index.",282,null],[11,"append","","Moves all the elements of `other` into `Self`, leaving `other` empty.",282,null],[11,"retain","","Retains only the elements specified by the predicate.",282,null],[11,"resize","","Modifies the `VecDeque` in-place so that `len()` is equal to new_len,\neither by removing excess elements or by appending copies of a value to the back.",282,null],[11,"key","std::collections::btree_map","Gets a reference to the key in the entry.",307,null],[11,"remove_pair","","Deprecated, renamed to `remove_entry`",307,null],[11,"remove_entry","","Take ownership of the key and value from the map.",307,null],[11,"get","","Gets a reference to the value in the entry.",307,null],[11,"get_mut","","Gets a mutable reference to the value in the entry.",307,null],[11,"into_mut","","Converts the entry into a mutable reference to its value.",307,null],[11,"insert","","Sets the value of the entry with the `OccupiedEntry`&#39;s key,\nand returns the entry&#39;s old value.",307,null],[11,"remove","","Takes the value of the entry out of the map, and returns it.",307,null],[11,"key","","Gets a reference to the key that would be used when inserting a value\nthrough the VacantEntry.",306,null],[11,"into_key","","Take ownership of the key.",306,null],[11,"insert","","Sets the value of the entry with the `VacantEntry`&#39;s key,\nand returns a mutable reference to it.",306,null],[11,"or_insert","","Ensures a value is in the entry by inserting the default if empty, and returns\na mutable reference to the value in the entry.",102,null],[11,"or_insert_with","","Ensures a value is in the entry by inserting the result of the default function if empty,\nand returns a mutable reference to the value in the entry.",102,null],[11,"key","","Returns a reference to this entry&#39;s key.",102,null],[11,"insert_next","std::collections::linked_list","Inserts the given element just after the element most recently returned by `.next()`.\nThe inserted element does not appear in the iteration.",299,null],[11,"peek_next","","Provides a reference to the next element, without changing the iterator.",299,null],[11,"clone","std::collections::hash_map","",430,null],[11,"clone","","",431,null],[11,"clone","","",432,null],[11,"fmt","","",106,null],[11,"fmt","","",433,null],[11,"fmt","","",434,null],[11,"next","","",430,null],[11,"size_hint","","",430,null],[11,"len","","",430,null],[11,"next","","",435,null],[11,"size_hint","","",435,null],[11,"len","","",435,null],[11,"next","","",436,null],[11,"size_hint","","",436,null],[11,"len","","",436,null],[11,"next","","",431,null],[11,"size_hint","","",431,null],[11,"len","","",431,null],[11,"next","","",432,null],[11,"size_hint","","",432,null],[11,"len","","",432,null],[11,"next","","",437,null],[11,"size_hint","","",437,null],[11,"len","","",437,null],[11,"next","","",438,null],[11,"size_hint","","",438,null],[11,"len","","",438,null],[11,"or_insert","","Ensures a value is in the entry by inserting the default if empty, and returns\na mutable reference to the value in the entry.",106,null],[11,"or_insert_with","","Ensures a value is in the entry by inserting the result of the default function if empty,\nand returns a mutable reference to the value in the entry.",106,null],[11,"key","","Returns a reference to this entry&#39;s key.",106,null],[11,"key","","Gets a reference to the key in the entry.",433,null],[11,"remove_pair","","Deprecated, renamed to `remove_entry`",433,null],[11,"remove_entry","","Take the ownership of the key and value from the map.",433,null],[11,"get","","Gets a reference to the value in the entry.",433,null],[11,"get_mut","","Gets a mutable reference to the value in the entry.",433,null],[11,"into_mut","","Converts the OccupiedEntry into a mutable reference to the value in the entry\nwith a lifetime bound to the map itself.",433,null],[11,"insert","","Sets the value of the entry, and returns the entry&#39;s old value.",433,null],[11,"remove","","Takes the value out of the entry, and returns it.",433,null],[11,"key","","Gets a reference to the key that would be used when inserting a value\nthrough the `VacantEntry`.",434,null],[11,"into_key","","Take ownership of the key.",434,null],[11,"insert","","Sets the value of the entry with the VacantEntry&#39;s key,\nand returns a mutable reference to it.",434,null],[11,"clone","","",439,null],[11,"new","","Constructs a new `RandomState` that is initialized with random keys.",439,{"inputs":[],"output":{"name":"randomstate"}}],[11,"build_hasher","","",439,null],[11,"fmt","","",440,null],[11,"new","","Creates a new `DefaultHasher`.",440,{"inputs":[],"output":{"name":"defaulthasher"}}],[11,"default","","Creates a new `DefaultHasher` using [`DefaultHasher::new`]. See\n[`DefaultHasher::new`] documentation for more information.",440,{"inputs":[],"output":{"name":"defaulthasher"}}],[11,"write","","",440,null],[11,"finish","","",440,null],[11,"default","","Constructs a new `RandomState`.",439,{"inputs":[],"output":{"name":"randomstate"}}],[11,"clone","std::collections::hash_set","",441,null],[11,"next","","",441,null],[11,"size_hint","","",441,null],[11,"len","","",441,null],[11,"next","","",442,null],[11,"size_hint","","",442,null],[11,"len","","",442,null],[11,"next","","",443,null],[11,"size_hint","","",443,null],[11,"len","","",443,null],[11,"clone","","",444,null],[11,"next","","",444,null],[11,"size_hint","","",444,null],[11,"clone","","",445,null],[11,"next","","",445,null],[11,"size_hint","","",445,null],[11,"clone","","",446,null],[11,"next","","",446,null],[11,"size_hint","","",446,null],[11,"clone","","",447,null],[11,"next","","",447,null],[11,"size_hint","","",447,null],[11,"description","std::num","",388,null],[11,"description","","",411,null],[11,"description","","",387,null],[11,"from","std::io","",149,{"inputs":[{"name":"nulerror"}],"output":{"name":"error"}}],[11,"eq","std","",270,null],[11,"eq","","",270,null],[11,"as_ref","","",270,null],[11,"read","","",275,null],[11,"read_exact","","",275,null],[11,"fill_buf","","",275,null],[11,"consume","","",275,null],[11,"write","","",275,null],[11,"write_all","","",275,null],[11,"flush","","",275,null],[11,"from","","",318,{"inputs":[{"name":"ipv4addr"}],"output":{"name":"u32"}}],[11,"to_socket_addrs","","",326,null],[11,"to_socket_addrs","","",326,null],[11,"to_socket_addrs","","",326,null],[11,"to_socket_addrs","","",326,null],[11,"to_socket_addrs","","",270,null],[11,"to_socket_addrs","","",275,null],[11,"as_ref","","",270,null],[11,"new","std::sync","Constructs a new `Arc&lt;T&gt;`.",263,{"inputs":[{"name":"t"}],"output":{"name":"arc"}}],[11,"try_unwrap","","Returns the contained value, if the `Arc` has exactly one strong reference.",263,{"inputs":[{"name":"arc"}],"output":{"name":"result"}}],[11,"into_raw","","Consumes the `Arc`, returning the wrapped pointer.",263,null],[11,"from_raw","","Constructs an `Arc` from a raw pointer.",263,null],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this value.",263,{"inputs":[{"name":"arc"}],"output":{"name":"weak"}}],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this value.",263,{"inputs":[{"name":"arc"}],"output":{"name":"usize"}}],[11,"strong_count","","Gets the number of strong (`Arc`) pointers to this value.",263,{"inputs":[{"name":"arc"}],"output":{"name":"usize"}}],[11,"ptr_eq","","Returns true if the two `Arc`s point to the same value (not\njust values that compare as equal).",263,{"inputs":[{"name":"arc"},{"name":"arc"}],"output":{"name":"bool"}}],[11,"make_mut","","Makes a mutable reference into the given `Arc`.",263,{"inputs":[{"name":"arc"}],"output":{"name":"t"}}],[11,"get_mut","","Returns a mutable reference to the inner value, if there are\nno other `Arc` or [`Weak`][weak] pointers to the same value.",263,{"inputs":[{"name":"arc"}],"output":{"name":"option"}}],[11,"new","","Constructs a new `Weak&lt;T&gt;`, without an accompanying instance of `T`.",266,{"inputs":[],"output":{"name":"weak"}}],[11,"upgrade","","Upgrades the `Weak` pointer to an [`Arc`][arc], if possible.",266,null],[11,"new","std::sync::atomic","Creates a new `AtomicBool`.",413,{"inputs":[{"name":"bool"}],"output":{"name":"atomicbool"}}],[11,"get_mut","","Returns a mutable reference to the underlying `bool`.",413,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",413,null],[11,"load","","Loads a value from the bool.",413,null],[11,"store","","Stores a value into the bool.",413,null],[11,"swap","","Stores a value into the bool, returning the old value.",413,null],[11,"compare_and_swap","","Stores a value into the `bool` if the current value is the same as the `current` value.",413,null],[11,"compare_exchange","","Stores a value into the `bool` if the current value is the same as the `current` value.",413,null],[11,"compare_exchange_weak","","Stores a value into the `bool` if the current value is the same as the `current` value.",413,null],[11,"fetch_and","","Logical &quot;and&quot; with a boolean value.",413,null],[11,"fetch_nand","","Logical &quot;nand&quot; with a boolean value.",413,null],[11,"fetch_or","","Logical &quot;or&quot; with a boolean value.",413,null],[11,"fetch_xor","","Logical &quot;xor&quot; with a boolean value.",413,null],[11,"new","","Creates a new `AtomicPtr`.",414,null],[11,"get_mut","","Returns a mutable reference to the underlying pointer.",414,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",414,null],[11,"load","","Loads a value from the pointer.",414,null],[11,"store","","Stores a value into the pointer.",414,null],[11,"swap","","Stores a value into the pointer, returning the old value.",414,null],[11,"compare_and_swap","","Stores a value into the pointer if the current value is the same as the `current` value.",414,null],[11,"compare_exchange","","Stores a value into the pointer if the current value is the same as the `current` value.",414,null],[11,"compare_exchange_weak","","Stores a value into the pointer if the current value is the same as the `current` value.",414,null],[11,"new","","Creates a new atomic integer.",415,{"inputs":[{"name":"i8"}],"output":{"name":"atomici8"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",415,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",415,null],[11,"load","","Loads a value from the atomic integer.",415,null],[11,"store","","Stores a value into the atomic integer.",415,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",415,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",415,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",415,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",415,null],[11,"fetch_add","","Add to the current value, returning the previous value.",415,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",415,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",415,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",415,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",415,null],[11,"new","","Creates a new atomic integer.",416,{"inputs":[{"name":"u8"}],"output":{"name":"atomicu8"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",416,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",416,null],[11,"load","","Loads a value from the atomic integer.",416,null],[11,"store","","Stores a value into the atomic integer.",416,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",416,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",416,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",416,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",416,null],[11,"fetch_add","","Add to the current value, returning the previous value.",416,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",416,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",416,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",416,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",416,null],[11,"new","","Creates a new atomic integer.",417,{"inputs":[{"name":"i16"}],"output":{"name":"atomici16"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",417,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",417,null],[11,"load","","Loads a value from the atomic integer.",417,null],[11,"store","","Stores a value into the atomic integer.",417,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",417,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",417,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",417,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",417,null],[11,"fetch_add","","Add to the current value, returning the previous value.",417,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",417,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",417,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",417,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",417,null],[11,"new","","Creates a new atomic integer.",418,{"inputs":[{"name":"u16"}],"output":{"name":"atomicu16"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",418,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",418,null],[11,"load","","Loads a value from the atomic integer.",418,null],[11,"store","","Stores a value into the atomic integer.",418,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",418,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",418,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",418,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",418,null],[11,"fetch_add","","Add to the current value, returning the previous value.",418,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",418,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",418,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",418,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",418,null],[11,"new","","Creates a new atomic integer.",419,{"inputs":[{"name":"i32"}],"output":{"name":"atomici32"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",419,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",419,null],[11,"load","","Loads a value from the atomic integer.",419,null],[11,"store","","Stores a value into the atomic integer.",419,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",419,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",419,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",419,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",419,null],[11,"fetch_add","","Add to the current value, returning the previous value.",419,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",419,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",419,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",419,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",419,null],[11,"new","","Creates a new atomic integer.",420,{"inputs":[{"name":"u32"}],"output":{"name":"atomicu32"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",420,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",420,null],[11,"load","","Loads a value from the atomic integer.",420,null],[11,"store","","Stores a value into the atomic integer.",420,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",420,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",420,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",420,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",420,null],[11,"fetch_add","","Add to the current value, returning the previous value.",420,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",420,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",420,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",420,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",420,null],[11,"new","","Creates a new atomic integer.",421,{"inputs":[{"name":"i64"}],"output":{"name":"atomici64"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",421,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",421,null],[11,"load","","Loads a value from the atomic integer.",421,null],[11,"store","","Stores a value into the atomic integer.",421,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",421,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",421,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",421,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",421,null],[11,"fetch_add","","Add to the current value, returning the previous value.",421,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",421,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",421,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",421,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",421,null],[11,"new","","Creates a new atomic integer.",422,{"inputs":[{"name":"u64"}],"output":{"name":"atomicu64"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",422,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",422,null],[11,"load","","Loads a value from the atomic integer.",422,null],[11,"store","","Stores a value into the atomic integer.",422,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",422,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",422,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",422,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",422,null],[11,"fetch_add","","Add to the current value, returning the previous value.",422,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",422,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",422,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",422,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",422,null],[11,"new","","Creates a new atomic integer.",423,{"inputs":[{"name":"isize"}],"output":{"name":"atomicisize"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",423,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",423,null],[11,"load","","Loads a value from the atomic integer.",423,null],[11,"store","","Stores a value into the atomic integer.",423,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",423,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",423,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",423,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",423,null],[11,"fetch_add","","Add to the current value, returning the previous value.",423,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",423,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",423,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",423,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",423,null],[11,"new","","Creates a new atomic integer.",424,{"inputs":[{"name":"usize"}],"output":{"name":"atomicusize"}}],[11,"get_mut","","Returns a mutable reference to the underlying integer.",424,null],[11,"into_inner","","Consumes the atomic and returns the contained value.",424,null],[11,"load","","Loads a value from the atomic integer.",424,null],[11,"store","","Stores a value into the atomic integer.",424,null],[11,"swap","","Stores a value into the atomic integer, returning the old value.",424,null],[11,"compare_and_swap","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",424,null],[11,"compare_exchange","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",424,null],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current value is the same as the\n`current` value.",424,null],[11,"fetch_add","","Add to the current value, returning the previous value.",424,null],[11,"fetch_sub","","Subtract from the current value, returning the previous value.",424,null],[11,"fetch_and","","Bitwise and with the current value, returning the previous value.",424,null],[11,"fetch_or","","Bitwise or with the current value, returning the previous value.",424,null],[11,"fetch_xor","","Bitwise xor with the current value, returning the previous value.",424,null]],"paths":[[8,"Any"],[4,"BorrowState"],[8,"Clone"],[8,"PartialEq"],[4,"Ordering"],[8,"Ord"],[8,"PartialOrd"],[8,"AsRef"],[8,"AsMut"],[8,"Into"],[8,"From"],[8,"TryInto"],[8,"TryFrom"],[8,"Default"],[8,"Hash"],[8,"Hasher"],[8,"BuildHasher"],[8,"FromIterator"],[8,"Sum"],[8,"Product"],[8,"IntoIterator"],[8,"Step"],[8,"Iterator"],[8,"DoubleEndedIterator"],[8,"Extend"],[8,"ExactSizeIterator"],[8,"Drop"],[8,"Add"],[8,"Sub"],[8,"Mul"],[8,"Div"],[8,"Rem"],[8,"Neg"],[8,"Not"],[8,"BitAnd"],[8,"BitOr"],[8,"BitXor"],[8,"Shl"],[8,"Shr"],[8,"AddAssign"],[8,"SubAssign"],[8,"MulAssign"],[8,"DivAssign"],[8,"RemAssign"],[8,"BitAndAssign"],[8,"BitOrAssign"],[8,"BitXorAssign"],[8,"ShlAssign"],[8,"ShrAssign"],[8,"Index"],[8,"IndexMut"],[3,"Range"],[3,"RangeFrom"],[3,"RangeTo"],[4,"RangeInclusive"],[3,"RangeToInclusive"],[8,"Deref"],[8,"DerefMut"],[8,"Fn"],[8,"FnMut"],[8,"FnOnce"],[8,"Place"],[8,"Placer"],[8,"InPlace"],[8,"Boxed"],[8,"BoxPlace"],[8,"Carrier"],[3,"TraitObject"],[4,"Result"],[4,"Option"],[8,"FnBox"],[8,"ToOwned"],[4,"Cow"],[8,"Borrow"],[8,"BorrowMut"],[8,"UpperExp"],[8,"LowerHex"],[8,"UpperHex"],[8,"Pointer"],[8,"Write"],[8,"Octal"],[8,"Binary"],[8,"Debug"],[8,"LowerExp"],[8,"Display"],[8,"SliceConcatExt"],[8,"SliceIndex"],[8,"Pattern"],[4,"SearchStep"],[8,"Searcher"],[8,"ReverseSearcher"],[8,"FromStr"],[8,"ToString"],[4,"LocalKeyState"],[3,"LocalKey"],[3,"Builder"],[3,"ThreadId"],[3,"Thread"],[3,"JoinHandle"],[8,"AsciiExt"],[3,"EscapeDefault"],[4,"Bound"],[4,"Entry"],[8,"RangeArgument"],[3,"HashMap"],[3,"HashSet"],[4,"Entry"],[4,"VarError"],[3,"Vars"],[3,"VarsOs"],[3,"SplitPaths"],[3,"JoinPathsError"],[3,"Args"],[3,"ArgsOs"],[8,"Error"],[3,"Box"],[3,"ParseBoolError"],[3,"Utf8Error"],[3,"FromUtf8Error"],[3,"FromUtf16Error"],[4,"ParseError"],[3,"DecodeUtf16Error"],[3,"Error"],[3,"BorrowError"],[3,"BorrowMutError"],[3,"CharTryFromError"],[3,"CString"],[3,"CStr"],[3,"NulError"],[3,"FromBytesWithNulError"],[3,"IntoStringError"],[3,"Vec"],[3,"OsString"],[3,"OsStr"],[3,"String"],[3,"Metadata"],[3,"ReadDir"],[3,"OpenOptions"],[3,"Permissions"],[3,"FileType"],[3,"File"],[3,"DirEntry"],[3,"DirBuilder"],[4,"ErrorKind"],[4,"SeekFrom"],[4,"CharsError"],[3,"BufReader"],[3,"IntoInnerError"],[3,"BufWriter"],[3,"Error"],[3,"LineWriter"],[3,"Cursor"],[3,"Empty"],[3,"Repeat"],[3,"Sink"],[3,"Stdin"],[3,"StdinLock"],[3,"Stdout"],[3,"StdoutLock"],[3,"Stderr"],[3,"StderrLock"],[8,"Read"],[8,"Write"],[8,"Seek"],[8,"BufRead"],[3,"Chain"],[3,"Take"],[3,"Bytes"],[3,"Chars"],[3,"Split"],[3,"Lines"],[4,"IpAddr"],[4,"Ipv6MulticastScope"],[4,"SocketAddr"],[4,"Shutdown"],[3,"Ipv4Addr"],[3,"Ipv6Addr"],[3,"SocketAddrV4"],[3,"SocketAddrV6"],[3,"TcpStream"],[3,"TcpListener"],[3,"Incoming"],[3,"UdpSocket"],[3,"AddrParseError"],[8,"ToSocketAddrs"],[3,"LookupHost"],[8,"Zero"],[8,"One"],[4,"FpCategory"],[3,"Wrapping"],[8,"AsRawFd"],[8,"FromRawFd"],[8,"IntoRawFd"],[8,"OsStringExt"],[8,"OsStrExt"],[8,"FileExt"],[8,"PermissionsExt"],[8,"OpenOptionsExt"],[8,"MetadataExt"],[8,"FileTypeExt"],[8,"DirEntryExt"],[8,"DirBuilderExt"],[8,"CommandExt"],[8,"ExitStatusExt"],[8,"JoinHandleExt"],[3,"stat"],[8,"MetadataExt"],[3,"AssertUnwindSafe"],[4,"Prefix"],[4,"Component"],[3,"PrefixComponent"],[3,"Components"],[3,"Iter"],[3,"PathBuf"],[3,"Path"],[3,"StripPrefixError"],[3,"Display"],[3,"Child"],[3,"Output"],[3,"ChildStdin"],[3,"ChildStdout"],[3,"ChildStderr"],[3,"Command"],[3,"Stdio"],[3,"ExitStatus"],[4,"Ordering"],[4,"TryLockError"],[3,"SendError"],[4,"TryRecvError"],[4,"RecvTimeoutError"],[4,"TrySendError"],[3,"Select"],[3,"Handle"],[3,"RecvError"],[3,"Sender"],[3,"SyncSender"],[3,"Receiver"],[3,"Iter"],[3,"TryIter"],[3,"IntoIter"],[3,"Barrier"],[3,"BarrierWaitResult"],[3,"WaitTimeoutResult"],[3,"Condvar"],[3,"Mutex"],[3,"MutexGuard"],[3,"Once"],[3,"OnceState"],[3,"RwLock"],[3,"RwLockReadGuard"],[3,"RwLockWriteGuard"],[3,"Duration"],[3,"Instant"],[3,"SystemTime"],[3,"SystemTimeError"],[3,"PoisonError"],[3,"SocketAddr"],[3,"UnixStream"],[3,"UnixListener"],[3,"Incoming"],[3,"UnixDatagram"],[3,"PanicInfo"],[3,"Location"],[3,"Arc"],[3,"Rc"],[3,"ExchangeHeapSingleton"],[3,"Weak"],[3,"Weak"],[3,"IntermediateBox"],[3,"SplitWhitespace"],[15,"str"],[3,"DecodeUtf16"],[3,"ToLowercase"],[3,"ToUppercase"],[3,"PeekMut"],[15,"slice"],[3,"BTreeMap"],[3,"IntoIter"],[3,"LinkedList"],[3,"Drain"],[3,"IntoIter"],[3,"Drain"],[3,"VecDeque"],[3,"Drain"],[3,"BinaryHeap"],[3,"Iter"],[3,"IntoIter"],[3,"Drain"],[3,"Iter"],[3,"IterMut"],[3,"Keys"],[3,"Values"],[3,"ValuesMut"],[3,"Range"],[3,"RangeMut"],[3,"Iter"],[3,"IntoIter"],[3,"Range"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"FrontPlace"],[3,"BackPlace"],[3,"VacantEntry"],[3,"OccupiedEntry"],[3,"BTreeSet"],[3,"Difference"],[3,"SymmetricDifference"],[3,"Intersection"],[3,"Union"],[3,"EncodeUtf16"],[15,"bool"],[15,"usize"],[15,"u8"],[15,"u16"],[15,"u32"],[15,"u64"],[15,"isize"],[15,"i8"],[15,"i16"],[15,"i32"],[15,"i64"],[15,"pointer"],[15,"tuple"],[3,"Cell"],[3,"RefCell"],[3,"PhantomData"],[15,"f32"],[15,"f64"],[15,"char"],[15,"array"],[3,"Formatter"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[3,"BuildHasherDefault"],[3,"Repeat"],[3,"Empty"],[3,"Once"],[3,"Rev"],[3,"Cloned"],[3,"Chain"],[3,"Zip"],[3,"Map"],[3,"Filter"],[3,"FilterMap"],[3,"Enumerate"],[3,"Skip"],[3,"FlatMap"],[3,"Fuse"],[3,"Inspect"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Split"],[3,"SplitMut"],[3,"Windows"],[3,"Chunks"],[3,"ChunksMut"],[3,"Chars"],[3,"CharIndices"],[3,"Bytes"],[3,"Lines"],[3,"LinesAny"],[3,"Iter"],[3,"IterMut"],[3,"Split"],[3,"RSplit"],[3,"SplitTerminator"],[3,"RSplitTerminator"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Matches"],[3,"RMatches"],[3,"Unique"],[3,"Shared"],[3,"Ref"],[3,"RefMut"],[3,"UnsafeCell"],[3,"Discriminant"],[3,"ParseFloatError"],[3,"ParseIntError"],[3,"RangeFull"],[3,"TypeId"],[3,"SipHasher"],[3,"SipHasher13"],[3,"SipHasher24"],[3,"EscapeUnicode"],[3,"EscapeDefault"],[3,"EscapeDebug"],[3,"DecodeUtf8"],[3,"StepBy"],[3,"Cycle"],[3,"Peekable"],[3,"SkipWhile"],[3,"TakeWhile"],[3,"Take"],[3,"Scan"],[3,"SplitN"],[3,"RSplitN"],[3,"SplitNMut"],[3,"RSplitNMut"],[3,"SplitN"],[3,"RSplitN"],[3,"TryFromIntError"],[3,"Arguments"],[3,"AtomicBool"],[3,"AtomicPtr"],[3,"AtomicI8"],[3,"AtomicU8"],[3,"AtomicI16"],[3,"AtomicU16"],[3,"AtomicI32"],[3,"AtomicU32"],[3,"AtomicI64"],[3,"AtomicU64"],[3,"AtomicIsize"],[3,"AtomicUsize"],[3,"DebugSet"],[3,"DebugStruct"],[3,"DebugTuple"],[3,"DebugList"],[3,"DebugMap"],[3,"Iter"],[3,"Keys"],[3,"Values"],[3,"OccupiedEntry"],[3,"VacantEntry"],[3,"IterMut"],[3,"IntoIter"],[3,"ValuesMut"],[3,"Drain"],[3,"RandomState"],[3,"DefaultHasher"],[3,"Iter"],[3,"IntoIter"],[3,"Drain"],[3,"Intersection"],[3,"Difference"],[3,"SymmetricDifference"],[3,"Union"]]};
searchIndex["std_unicode"] = {"doc":"# The Unicode Library","items":[[0,"char","std_unicode","A character type.",null,null],[17,"MAX","std_unicode::char","The highest valid code point a `char` can have.",null,null],[5,"from_digit","","Converts a digit in the given radix to a `char`.",null,{"inputs":[{"name":"u32"},{"name":"u32"}],"output":{"name":"option"}}],[5,"from_u32","","Converts a `u32` to a `char`.",null,{"inputs":[{"name":"u32"}],"output":{"name":"option"}}],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",null,{"inputs":[{"name":"u32"}],"output":{"name":"char"}}],[3,"EscapeDebug","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode escape of a\ncharacter, as `char`s.",null,null],[3,"CharTryFromError","","The error type returned when a conversion from u32 to char fails.",null,null],[3,"DecodeUtf8","","An iterator over an iterator of bytes of the characters the bytes represent\nas UTF-8",null,null],[5,"decode_utf8","","Decodes an `Iterator` of bytes as UTF-8.",null,{"inputs":[{"name":"i"}],"output":{"name":"decodeutf8"}}],[3,"ToLowercase","","Returns an iterator that yields the lowercase equivalent of a `char`.",null,null],[3,"ToUppercase","","Returns an iterator that yields the uppercase equivalent of a `char`.",null,null],[3,"DecodeUtf16","","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",null,null],[3,"DecodeUtf16Error","","An iterator that decodes UTF-16 encoded code points from an iterator of `u16`s.",null,null],[5,"decode_utf16","","Create an iterator over the UTF-16 encoded code points in `iter`,\nreturning unpaired surrogates as `Err`s.",null,{"inputs":[{"name":"i"}],"output":{"name":"decodeutf16"}}],[17,"UNICODE_VERSION","","The version of [Unicode](http://www.unicode.org/)\nthat the unicode parts of `CharExt` and `UnicodeStrPrelude` traits are based on.",null,null],[17,"REPLACEMENT_CHARACTER","","`U+FFFD REPLACEMENT CHARACTER` (�) is used in Unicode to represent a\ndecoding error.",null,null],[11,"next","","",0,null],[11,"next","","",1,null],[11,"clone","","",2,null],[11,"fmt","","",3,null],[11,"clone","","",3,null],[11,"eq","","",3,null],[11,"ne","","",3,null],[11,"next","","",2,null],[11,"size_hint","","",2,null],[11,"unpaired_surrogate","","Returns the unpaired surrogate which caused this error.",3,null],[11,"fmt","","",3,null],[0,"str","std_unicode","",null,null],[3,"SplitWhitespace","std_unicode::str","An iterator over the non-whitespace substrings of a string,\nseparated by any amount of whitespace.",null,null],[3,"Utf16Encoder","","Iterator adaptor for encoding `char`s to UTF-16.",null,null],[5,"is_utf16","","Determines if a vector of `u16` contains valid UTF-16",null,null],[5,"utf8_char_width","","Given a first byte, determine how many bytes are in this UTF-8 character",null,{"inputs":[{"name":"u8"}],"output":{"name":"usize"}}],[8,"UnicodeStr","","Methods for Unicode string slices",null,null],[10,"split_whitespace","","",4,null],[10,"is_whitespace","","",4,null],[10,"is_alphanumeric","","",4,null],[10,"trim","","",4,null],[10,"trim_left","","",4,null],[10,"trim_right","","",4,null],[0,"derived_property","std_unicode","",null,null],[5,"Case_Ignorable","std_unicode::derived_property","",null,{"inputs":[{"name":"char"}],"output":{"name":"bool"}}],[5,"Cased","","",null,{"inputs":[{"name":"char"}],"output":{"name":"bool"}}],[0,"property","std_unicode","",null,null],[5,"Pattern_White_Space","std_unicode::property","",null,{"inputs":[{"name":"char"}],"output":{"name":"bool"}}],[11,"clone","std_unicode::str","",5,null],[11,"new","","Create a UTF-16 encoder from any `char` iterator.",5,{"inputs":[{"name":"i"}],"output":{"name":"utf16encoder"}}],[11,"next","","",5,null],[11,"size_hint","","",5,null],[11,"next","","",6,null],[11,"next_back","","",6,null],[11,"eq","std_unicode::char","",7,null],[11,"ne","","",7,null],[11,"next","","",8,null],[11,"size_hint","","",8,null],[11,"count","","",8,null],[11,"last","","",8,null],[11,"next","","",9,null],[11,"size_hint","","",9,null],[11,"count","","",9,null],[11,"nth","","",9,null],[11,"last","","",9,null],[11,"next","","",10,null],[11,"size_hint","","",10,null],[11,"next","","",11,null],[11,"fmt","","",7,null],[11,"clone","","",7,null],[11,"clone","","",8,null],[11,"clone","","",9,null],[11,"clone","","",10,null],[11,"clone","","",11,null],[11,"fmt","","",7,null],[11,"fmt","","",8,null],[11,"fmt","","",9,null],[11,"fmt","","",10,null],[11,"fmt","","",11,null],[11,"len","","",8,null],[11,"len","","",9,null]],"paths":[[3,"ToLowercase"],[3,"ToUppercase"],[3,"DecodeUtf16"],[3,"DecodeUtf16Error"],[8,"UnicodeStr"],[3,"Utf16Encoder"],[3,"SplitWhitespace"],[3,"CharTryFromError"],[3,"EscapeUnicode"],[3,"EscapeDefault"],[3,"EscapeDebug"],[3,"DecodeUtf8"]]};
initSearch(searchIndex);
