/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.alert.ExtensionAlert;

public class PopupMenuAlertDelete
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    private ExtensionAlert extension = null;

    public PopupMenuAlertDelete() {
        this.initialize();
    }

    public PopupMenuAlertDelete(String string) {
        super(string);
    }

    private void initialize() {
        this.setText(Constant.messages.getString("scanner.delete.popup"));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray = PopupMenuAlertDelete.this.extension.getAlertPanel().getTreeAlert().getSelectionPaths();
                if (treePathArray != null) {
                    if (View.getSingleton().showConfirmDialog(Constant.messages.getString("scanner.delete.confirm")) != 0) {
                        return;
                    }
                    for (TreePath treePath : treePathArray) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        PopupMenuAlertDelete.this.deleteNode(defaultMutableTreeNode);
                    }
                }
            }
        });
    }

    private void deleteNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        while (defaultMutableTreeNode.getChildCount() > 0) {
            this.deleteNode((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0));
        }
        if (defaultMutableTreeNode.getUserObject() != null && (object = defaultMutableTreeNode.getUserObject()) instanceof Alert) {
            this.extension.deleteAlert((Alert)object);
        }
    }

    @Override
    public boolean isEnableForComponent(Component component) {
        if (component.getName() != null && component.getName().equals("treeAlert")) {
            try {
                DefaultMutableTreeNode defaultMutableTreeNode;
                JTree jTree = (JTree)component;
                if (jTree.getLastSelectedPathComponent() != null && !(defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent()).isRoot()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    void setExtension(ExtensionAlert extensionAlert) {
        this.extension = extensionAlert;
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

